/*************************************************************************
 *
 *  $RCSfile: protocol.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: lla $ $Date: 2002/08/02 12:20:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#include "protocol.hxx"

/////////////////////////////////////////////////////////////////////

Protocol::Protocol( const ByteString& rTitle )
		:m_pErrorStrm(NULL),
		 m_pStrm(NULL)
{
	m_bDoHTML		= FALSE;
	m_bDoError		= FALSE;
	m_bDoConsole	= FALSE;
	m_aTitle 		= rTitle;
}

Protocol::~Protocol()
{
	if( m_bDoHTML )
	{
		PrintFoot();
		delete m_pStrm;
	}
	if( m_bDoError )
		delete m_pErrorStrm;
}

void Protocol::DoHTML( const ByteString& rFilename )
{
	m_bDoHTML = TRUE;
	// m_pStrm = new SvFileStream(
	// 		   UniString(rFilename.GetBuffer(), osl_getThreadTextEncoding()),
	// 		   STREAM_WRITE | STREAM_TRUNC );
	m_pStrm = new OWriteStream(UniString(rFilename.GetBuffer(), osl_getThreadTextEncoding()));

	PrintHead( m_aTitle );
}

void Protocol::DoErrorFile( const ByteString& rFilename )
{
	// m_sFilename = rFilename;

	m_bDoError = TRUE;
	// m_pErrorStrm = new SvFileStream(
	// 		   UniString(rFilename.GetBuffer(), osl_getThreadTextEncoding()),
	// 		   STREAM_WRITE | STREAM_TRUNC );
	m_pErrorStrm = new OWriteStream(UniString(rFilename.GetBuffer(), osl_getThreadTextEncoding()));
	*m_pErrorStrm << m_aTitle.GetBuffer();
	*m_pErrorStrm << "\n";
}

/////////////////////////////////////////////////////////////////////

void Protocol::PrintHead(const ByteString& rTitle)
{
	*m_pStrm << "<HTML><HEAD><TITLE>";
	*m_pStrm << rTitle.GetBuffer();
	*m_pStrm << "</TITLE></HEAD><BODY>";
}

void Protocol::PrintFoot()
{
	*m_pStrm << "</BODY></HTML>";
}

void Protocol::NewLine()
{
	if( m_bDoHTML )			*m_pStrm << "<BR>";
	if( m_bDoError )		*m_pErrorStrm << "\n";
	if( m_bDoConsole )      fprintf( stdout, "\n" );
}

/////////////////////////////////////////////////////////////////////

void Protocol::Log( const ByteString& rMsg, BOOL bBold )
{
	if( m_bDoHTML )
	{
		if( bBold )
			*m_pStrm << "<B>";
		else
			*m_pStrm << "<FONT FACE=\"Courier New, monospace\" SIZE=1>";

		*m_pStrm << rMsg.GetBuffer();
		if( bBold )
			*m_pStrm << "</B>";
		else
			*m_pStrm << "</FONT>";
		*m_pStrm << "<BR>";
	}

	if( m_bDoError )
	{
		*m_pErrorStrm << rMsg.GetBuffer();
		*m_pErrorStrm << "\n";
		m_pErrorStrm->Flush();
	}

	if( m_bDoConsole )	fprintf( stdout, "%s\n", rMsg.GetBuffer() );
}

ByteString Protocol::getErrorStreamFileName() const
{
	ByteString sFilename;
	if (m_pErrorStrm)
	{	
		sFilename = ByteString(rtl::OUStringToOString(m_pErrorStrm->getFileName(), osl_getThreadTextEncoding()));
	}
	return sFilename;
}
ByteString Protocol::getStreamFileName() const
{
	ByteString sFilename;
	if (m_pStrm)
	{
		sFilename = ByteString(rtl::OUStringToOString(m_pStrm->getFileName(), osl_getThreadTextEncoding()));
	}
	return sFilename;
}
