/*************************************************************************
 *
 *  $RCSfile: ziplst.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 09:48:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SV_CONFIG_HXX
#include <vcl/config.hxx>
#endif

#ifndef _IPARSER_HXX
#include <tools/geninfo.hxx>
#endif

#ifndef _SICLIENT_HXX
#include <tools/siclient.hxx>
#endif

#include <setup2/sifsys.hxx>
#include "ziplst.hxx"

#include <stdio.h>

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

ByteString GetProcessorType( const ByteString& rEnvironment )
{
	if( rEnvironment.CompareIgnoreCaseToAscii("unxsols",7) == COMPARE_EQUAL ||
		rEnvironment.CompareIgnoreCaseToAscii("unxsogs",7) == COMPARE_EQUAL )
		return ByteString("SPARC");
	return ByteString("INTEL");
}

///////////////////////////////////////////////////////////////////////////////

BOOL GetMetaReplacement( MetaReplacement* pM, const ByteString& rMsg,
						 GenericInformationList* pGenList, BOOL bUseEnv)
{
	USHORT nDelimTok = 0;
	USHORT nTokCount = rMsg.GetTokenCount( ';' );

	USHORT nPos;
	ByteString aMsg( rMsg );
	if( ( nPos = rMsg.Search(" ")) != STRING_NOTFOUND ) {
		aMsg = rMsg.Copy(0, nPos);
	}

	pM->aMetaWorkstamp		= aMsg.GetToken(0, ';', nDelimTok);
	pM->aMetaEnvironment	= aMsg.GetToken(0, ';', nDelimTok);
	pM->aMetaMinorSub		= aMsg.GetToken(0, ';', nDelimTok);

	if( pM->aMetaMinorSub.Len() )
		pM->aMetaMinor			= pM->aMetaMinorSub.Copy( 0, pM->aMetaMinorSub.Search("-") );
    
    pM->aMetaMinorNonPre    = pM->aMetaMinor;

	pM->aMetaOSDef			= pM->aMetaEnvironment.Copy(0,3);
	pM->aMetaOSDef.ToUpperAscii();
	pM->aMetaOS				= pM->aMetaEnvironment;

	if( nPos != STRING_NOTFOUND )
	{
		ByteString aExtMsg( rMsg.Copy(nPos + 1) );
		if( aExtMsg.CompareIgnoreCaseToAscii("PRE") == COMPARE_EQUAL )
		{
			pM->aMetaMinor.Insert( "_pre_", 0 );
		}
	}

	USHORT n = pM->aMetaOS.Search('.');
	if( n != STRING_NOTFOUND )
		pM->aMetaOS.Erase(n);

	// {solarpath}
	ByteString aIncPath;
	char pPath[FILENAME_MAX];

	if( bUseEnv && getenv("SOLARVERSION"))
	{
	  pM->aMetaSolarPath = getenv("SOLARVERSION");
	}
	else
	{
	 	if( bUseEnv && getenv("SRC_ROOT") )
		{
			strncpy( pPath, getenv("SRC_ROOT"), sizeof(pPath) - 1 );
            pPath[ sizeof(pPath)-1 ] = '\0';
			if ( strcmp (pPath, "") )
				pM->aMetaSolarPath = getenv( "SRC_ROOT");
		}
		else if ( pGenList )
		{
			ByteString aOldPathStructure( "/" );
			aOldPathStructure += pM->aMetaWorkstamp;
			aOldPathStructure.Append( "/settings/OLDPATHSTRUCTURE" );
			GenericInformation* pInf = pGenList->GetInfo( aOldPathStructure, TRUE );

			if ( pInf && pInf->GetValue().Equals("_TRUE") )
			{	// old method
				ByteString aInformationPath( "/" );
				aInformationPath += pM->aMetaWorkstamp;
#ifdef UNX
				aInformationPath += "/drives/s:/UnixVolume";
#else
				aInformationPath += "/drives/s:";
#endif
				pInf = pGenList->GetInfo( aInformationPath, TRUE );

				if( pInf )
#ifdef UNX
					pM->aMetaSolarPath =  pInf->GetValue();
#else
				    pM->aMetaSolarPath =  *pInf;
#endif
			}
			else	// from SRC605 on
			{
				ByteString aInformationPath( "/" );
				aInformationPath += pM->aMetaWorkstamp;
#ifdef UNX
				aInformationPath += "/drives/o:/UnixVolume";
#else
				aInformationPath += "/drives/o:";
#endif
				GenericInformation* pInf = pGenList->GetInfo( aInformationPath, TRUE );

				if( pInf )
#ifdef UNX
					pM->aMetaSolarPath =  pInf->GetValue();
#else
            		pM->aMetaSolarPath =  *pInf;
#endif
				ByteString aWorkstamp( pM->aMetaWorkstamp );
				aWorkstamp.ToUpperAscii();
				pM->aMetaSolarPath.Append( ByteString( DirEntry::GetAccessDelimiter(), osl_getThreadTextEncoding() ) );
				pM->aMetaSolarPath.Append( aWorkstamp );
			}
		}

		if ( pM->aMetaSolarPath.Len() == 0 )
		{
			pM->aMetaSolarPath += ByteString( DirEntry::GetAccessDelimiter(), osl_getThreadTextEncoding() );
			pM->aMetaSolarPath += "solver";
			pM->aMetaSolarPath += ByteString( DirEntry::GetAccessDelimiter(), osl_getThreadTextEncoding() );
			pM->aMetaSolarPath += pM->aMetaWorkstamp.Copy(3,6);
		}
	}

	pM->aMetaSolarPath += ByteString( DirEntry::GetAccessDelimiter(), osl_getThreadTextEncoding() );
    pM->aMetaSolarCommonPath = pM->aMetaSolarPath;
    pM->aMetaSolarPath += pM->aMetaEnvironment;
    pM->aMetaSolarCommonPath += ByteString("common");

	USHORT n2 = pM->aMetaEnvironment.Search('.');
	if( n2 != STRING_NOTFOUND )
        pM->aMetaSolarCommonPath += pM->aMetaEnvironment.Copy(n2);
    
	aIncPath = pM->aMetaSolarPath;
	aIncPath += ByteString( DirEntry::GetAccessDelimiter(), osl_getThreadTextEncoding() );

	if( pM->aMetaMinor.Len() )
	{
		aIncPath 		   += "inc.";
		aIncPath 		   += pM->aMetaMinor;
	}
	else
		aIncPath 		   += "inc";


    if ( bUseEnv )
    {
	    pM->aMetaSolarEnvPath = ByteString( getenv( "STAR_INSTPATH" ) );
    	if ( pM->aMetaSolarEnvPath == "" )
    	    pM->aMetaSolarEnvPath = ByteString( getenv( "STAR_SOLARENVPATH" ) );
    }
	if ( pM->aMetaSolarEnvPath == "" )
	{
#ifdef UNX
		pM->aMetaSolarEnvPath = "/develop6/update/dev/s/solenv/inst";
#else
	    pM->aMetaSolarEnvPath = "r:\\solenv\\inst";
#endif
	}
	
//	pM->aMetaSolarEnvPath += ByteString( DirEntry::GetAccessDelimiter(), osl_getThreadTextEncoding() );

	// {buildid}
	UniString aFilename( UniString::CreateFromAscii(pM->aMetaWorkstamp.Copy(3,6).GetBuffer()) );
	aFilename += UniString::CreateFromAscii("minor.mk");

	SiDirEntry aMinorMak( aIncPath );
	aMinorMak += aFilename;

	if( !aMinorMak.Exists() )
	{
		fprintf( stderr, "Error: Can not find %s \n", aMinorMak.GetFull().GetBuffer());
		return FALSE;
	}

	Config aCfg( aMinorMak.GetFullUni() );
	pM->aMetaBuildID = aCfg.ReadKey( "BUILD" );


    if ( bUseEnv )
    	pM->aMetaPMiscPath = ByteString( getenv( "STAR_PACKMISC" ));

	if ( pM->aMetaPMiscPath == "" )
	{	
#ifdef UNX
		pM->aMetaPMiscPath = "/ship/packmisc";
#else
		pM->aMetaPMiscPath = "\\\\jumbo\\ship\\packmisc";
#endif
	}
	
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////

ByteString _Num2Alpha( const ByteString& rStr )
{
	ByteString aStr( rStr );
	aStr.SearchAndReplaceAll( "01", "en" );
	aStr.SearchAndReplaceAll( "03", "pt" );
	aStr.SearchAndReplaceAll( "07", "ru" );
	aStr.SearchAndReplaceAll( "30", "gr" );
	aStr.SearchAndReplaceAll( "31", "nl" );
	aStr.SearchAndReplaceAll( "33", "fr" );
	aStr.SearchAndReplaceAll( "34", "es" );
	aStr.SearchAndReplaceAll( "35", "fi" );
	aStr.SearchAndReplaceAll( "39", "it" );
	aStr.SearchAndReplaceAll( "45", "da" );
	aStr.SearchAndReplaceAll( "46", "sv" );
	aStr.SearchAndReplaceAll( "48", "pl" );
	aStr.SearchAndReplaceAll( "49", "de" );
	aStr.SearchAndReplaceAll( "55", "pt-BR" );
	aStr.SearchAndReplaceAll( "81", "ja" );
	aStr.SearchAndReplaceAll( "82", "ko" );
	aStr.SearchAndReplaceAll( "86", "zh" );
	aStr.SearchAndReplaceAll( "88", "zh_TW" );
	aStr.SearchAndReplaceAll( "90", "tr" );
	aStr.SearchAndReplaceAll( "96", "ar" );

	return aStr;
}

#define OS_SOLS			"solsparc"
#define OS_SOLI			"solia"
#define OS_WINDOWS		"windows"
#define OS_LINUX		"linux"
#define OS_FREEBSD		"freebsd"
#define OS_OS2			"os2"

ByteString _OS2Alpha( const ByteString& rStr )
{
	if( rStr.CompareIgnoreCaseToAscii("wntmsci",7) == COMPARE_EQUAL )
		return OS_WINDOWS;
	else if( rStr.CompareIgnoreCaseToAscii("unxsols",7) == COMPARE_EQUAL )
		return OS_SOLS;
	else if( rStr.CompareIgnoreCaseToAscii("unxsoli",7) == COMPARE_EQUAL )
		return OS_SOLI;
	else if( rStr.CompareIgnoreCaseToAscii("unxlngi",7) == COMPARE_EQUAL )
		return OS_LINUX;
	else if( rStr.CompareIgnoreCaseToAscii("unxfbsdi",7) == COMPARE_EQUAL )
		return OS_FREEBSD;
	else if( rStr.CompareIgnoreCaseToAscii("os2icci",7) == COMPARE_EQUAL )
		return OS_OS2;

	return "na";
}

ByteString DoMetaReplacement( MetaReplacement* pM, const ByteString& rLang, const ByteString& rStr )
{
	ByteString aResult( rStr );
	ByteString aMetaLang( rLang );
	ByteString aLowerOSDef( pM->aMetaOSDef );
	aLowerOSDef.ToLowerAscii();

	while( aMetaLang.SearchAndReplace(",", "_") != STRING_NOTFOUND );
	ByteString aMetaLangAlpha = _Num2Alpha( aMetaLang );
	ByteString aMetaOSAlpha = _OS2Alpha( pM->aMetaOS );

	if( !pM->aMetaMinor.Len() )
	{
		ByteString aNoMinor( "." );
		aNoMinor += META_MINOR;
		while( aResult.SearchAndReplace(aNoMinor, "") != STRING_NOTFOUND );
	}

	while( aResult.SearchAndReplace(META_ENVIRONMENT,	pM->aMetaEnvironment)	!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_WORKSTAMP, 	pM->aMetaWorkstamp)		!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_MINORNONPRE,	pM->aMetaMinorNonPre)	!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_MINORSUB, 		pM->aMetaMinorSub)		!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_MINOR, 		pM->aMetaMinor)			!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_BUILDID, 		pM->aMetaBuildID)		!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_OSDEF, 		aLowerOSDef)			!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_OS, 			pM->aMetaOS)			!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_OSALPHA, 		aMetaOSAlpha)	   		!= STRING_NOTFOUND );
  	while( aResult.SearchAndReplace(META_LANGUAGES, 	aMetaLang)				!= STRING_NOTFOUND );
	while( aResult.SearchAndReplace(META_LANGUAGES_ALPHA, aMetaLangAlpha)		!= STRING_NOTFOUND );

    while( aResult.SearchAndReplace(META_SOLARPATH,		pM->aMetaSolarPath)		!= STRING_NOTFOUND );
    while( aResult.SearchAndReplace(META_SOLARENVPATH,	pM->aMetaSolarEnvPath)	!= STRING_NOTFOUND );
    while( aResult.SearchAndReplace(META_SOLARCOMMONPATH,pM->aMetaSolarCommonPath)	!= STRING_NOTFOUND );
        
	while( aResult.SearchAndReplace(META_PMISCPATH,		pM->aMetaPMiscPath)			!= STRING_NOTFOUND );

	return aResult;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

IServerZipList::IServerZipList()
{
	m_pGenInfo = NULL;
}

IServerZipList::~IServerZipList()
{
	UnloadZipList();
}

BOOL IServerZipList::InitZipList( InformationClient* pIClient )
{
	pIClient->SetCommand( "loadfile", ZIPLIST );
	pIClient->Command_n_Wait();

	pIClient->SetRequest( ZIPLIST, TRUE, TRUE );
	m_pGenInfo = (GenericInformation*) pIClient->Send_n_Wait();

	if( !m_pGenInfo ) {
		return FALSE;
	}
	return TRUE;
}

void IServerZipList::UnloadZipList()
{
	if( m_pGenInfo )
	{
//		delete m_pGenInfo;
		m_pGenInfo = NULL;
	}
}

ByteString IServerZipList::GetValue( GenericInformationList* pGenList, ByteString& rPath )
{
	GenericInformation* pInf = pGenList->GetInfo( rPath, TRUE );
	if( pInf )
		return pInf->GetValue();
	return ByteString("");
}

///////////////////////////////////////////////////////////////////////////////

Project::Project( InformationClient* pIClient )
{
	m_pIClient		= pIClient;
	m_nSplitSize	= 0;
	m_nPrio			= 10;
	m_bActive		= FALSE;
	m_bWeb	  		= FALSE;
}

Project::~Project()
{
}

void Project::ReadSettings( GenericInformationList* pGenList, const ByteString& rPath )
{
	ByteString aPath( rPath );


	// read all variables
	ReadVariables( pGenList->GetInfo(aPath, TRUE, FALSE) );
    aPath = rPath;  // because GetInfo changes the path


	ByteString tmp( aPath );
	tmp += ByteString(KEY_ACTIVE);
	ByteString aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_bActive = aValue == "1" ? TRUE : FALSE;

	tmp	=  aPath;
	tmp += ByteString(KEY_WEB);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_bWeb = aValue == "1" ? TRUE : FALSE;

	tmp	=  aPath;
	tmp += ByteString(KEY_PRIO);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_nPrio = USHORT(aValue.ToInt32());

	tmp	=  aPath;
	tmp += ByteString(KEY_SCRIPT);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_aScript = aValue;

	tmp	=  aPath;
	tmp += ByteString(KEY_FATBINARY);
	// different here to alow resetting the value to an empty String
    {
        GenericInformation* pScpzipExtra = pGenList->GetInfo( tmp, TRUE );
	    if( pScpzipExtra )
		    m_aFatbinary = pScpzipExtra->GetValue();
    }

	tmp	=  aPath;
	tmp += ByteString(KEY_SPLITSIZE);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_nSplitSize = aValue.ToInt32();

	tmp	=  aPath;
	tmp += ByteString(KEY_COMPRESSION);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_aCompression = USHORT(aValue.ToInt32());

	tmp	=  aPath;
	tmp += ByteString(KEY_INCLUDE);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_aInclude = aValue;

	tmp	=  aPath;
	tmp += ByteString(KEY_LANGUAGES);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_aLanguages = aValue;

	tmp	=  aPath;
	tmp += ByteString(KEY_SCPZIP_EXTRA);
	// different here to alow resetting the value to an empty String
    {
        GenericInformation* pScpzipExtra = pGenList->GetInfo( tmp, TRUE );
	    if( pScpzipExtra )
		    m_aScpzipExtra = pScpzipExtra->GetValue();
    }

#ifdef UNX
	aPath += "unix/";
#else
	aPath += "dos/";
#endif

	tmp	=  aPath;
	tmp += ByteString(KEY_LOG);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_aLogfile = aValue;

	tmp	=  aPath;
	tmp += ByteString(KEY_DESTINATION);
	aValue = GetValue( pGenList, tmp );
	if( aValue.Len() ) m_aDestination = aValue;
}

// #99548# read variables section -----------------------

void Project::ReadVariables( GenericInformation* pGenInfo )
{
	// Function, to read all values within the variables area and store the variables into
	// the parameterhelper globalDictionary List

    if ( !pGenInfo )
        return;

    ByteString sVariables(KEY_VARIABLES);
    GenericInformation *pInfo = pGenInfo->GetSubInfo(sVariables, TRUE, FALSE);
	if (pInfo)
	{
		GenericInformationList* pGenList = pInfo->GetSubList();
		if (pGenList)
		{
			for( USHORT x = 0; x < pGenList->Count(); x++ )
			{
				GenericInformation *pInf = (GenericInformation *) pGenList->GetObject(x);
				if (pInf)
				{
					ByteString sKey = *pInf;
					ByteString sValue = pInf->GetValue();

					aVariables.feedDictionary( sKey, sValue, OVERRIDE_EXISTING_VALUES );
				}
			}
		}
	}
}

// -----------------------------------------------------------------------------

void Project::Read( GenericInformationList* pGenList, GenericInformation* pGenInf )
{
    aVariables.clear();

	m_aName = *pGenInf;

	ByteString aTmpPath = *pGenInf;
	aTmpPath += "/notification/";

	ByteString tmp( aTmpPath );
	tmp += ByteString(KEY_SUCCESS);
	m_aSuccessRecipients	= GetValue( pGenList, tmp );

	tmp	=  aTmpPath;
	tmp += ByteString(KEY_FAIL);
	m_aFailRecipients		= GetValue( pGenList, tmp );

	aTmpPath = *pGenInf;
	aTmpPath += "/settings/";

	ReadSettings( pGenList, aTmpPath );
}

Project* Project::GetNewOverloaded( ByteString aWorkstamp, ByteString aEnvironment, ByteString aMinor )
{
	if( !InitZipList(m_pIClient) )
		return NULL;

	GenericInformationList* pGenList = m_pGenInfo->GetSubList();

	Project* pNew = new Project(m_pIClient);

	pNew->m_aName				= m_aName;
	pNew->m_bActive				= m_bActive;
	pNew->m_bWeb				= m_bWeb;
	pNew->m_nPrio				= m_nPrio;
	pNew->m_aLogfile			= m_aLogfile;
	pNew->m_aScript				= m_aScript;
	pNew->m_aFatbinary			= m_aFatbinary;
	pNew->m_nSplitSize			= m_nSplitSize;
	pNew->m_aCompression		= m_aCompression;
	pNew->m_aLanguages			= m_aLanguages;
	pNew->m_aDestination		= m_aDestination;
	pNew->m_aInclude			= m_aInclude;

	pNew->m_aSuccessRecipients	= m_aSuccessRecipients;
	pNew->m_aFailRecipients		= m_aFailRecipients;

    pNew->m_aScpzipExtra		= m_aScpzipExtra;

	for ( int i=0 ; i < aVariables.getCount() ; ++i )
    	pNew->aVariables.feedDictionary( aVariables.getOne(i) );


	ByteString aTPath( m_aName );
	aTPath += "/settings/";

    ByteString aPath;
    aPath = aTPath;
	aPath += aWorkstamp;
	aPath += '/';
	pNew->ReadSettings( pGenList, aPath );

    aPath = aTPath;
	aPath += aEnvironment;
	aPath += '/';
	pNew->ReadSettings( pGenList, aPath );

    aPath = aTPath;
	aPath += aWorkstamp;
	aPath += '/';
	aPath += aEnvironment;
	aPath += '/';
	pNew->ReadSettings( pGenList, aPath );

	aPath += aMinor;
	aPath += '/';
	pNew->ReadSettings( pGenList, aPath );

	UnloadZipList();
	return pNew;
}

