/*************************************************************************
 *
 *  $RCSfile: effcthdl.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: ka $ $Date: 2002/11/14 18:08:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif

#ifndef _SV_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif

#include "effect.hxx"
#include "effect.hrc"
#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdattr.hxx"
#include "sdresid.hxx"
#include "sdview.hxx"
#include "drawdoc.hxx"


using namespace ::com::sun::star;

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickImageButtonHdl, ImageButton *, pBtn )
{
	BOOL bCheck = !pBtn->IsChecked();
	pBtn->Check( bCheck );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickPreviewHdl, void *, EMPTYARG )
{
	BOOL bCheck = !aBtnPreview.IsChecked();
	aBtnPreview.Check( bCheck );

	SfxBoolItem aItem( SID_PREVIEW_WIN, bCheck );
	GetBindings().GetDispatcher()->Execute( 
		SID_PREVIEW_WIN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickUpdateHdl, void *, EMPTYARG )
{
	bUpdate = !aBtnUpdate.IsChecked();
	aBtnUpdate.Check( bUpdate );

	aTlbOrder.SetUpdateMode( bUpdate );

	if( bUpdate )
	{
		SfxBoolItem aItem( SID_EFFECT_STATE, TRUE );
		GetBindings().GetDispatcher()->Execute( 
			SID_EFFECT_STATE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
	}

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickAssignHdl, void *, EMPTYARG )
{
	if( eViewType == VIEWTYPE_ORDER )
	{
		aTlbOrder.Assign();
	}
	else
	{
		SfxBoolItem aItem( SID_EFFECT_ASSIGN, TRUE );
		GetBindings().GetDispatcher()->Execute( 
			SID_EFFECT_ASSIGN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
	}

    const BOOL bEnableExtras = ( ( GetAnimationEffect( &aCtlEffect ) != presentation::AnimationEffect_NONE ) ||
                                 ( GetAnimationEffect( &aCtlTextEffect ) != presentation::AnimationEffect_NONE ) );
                                

	aBtnVTExtras.Enable( bEnableExtras );
    aBtnVTOrder.Enable( bEnableExtras );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, SelectEffectHdl, void *, p )
{
	if( p != &aCtlEffect )
		FillValueSet( &aCtlEffect );

	presentation::AnimationEffect eAE = GetAnimationEffect( &aCtlEffect );

	// Button (Assign) muss fuer Order immer enabled sein
	if( eViewType == VIEWTYPE_ORDER )
		aBtnAssign.Enable();
	else
	{
		if( eAE == presentation::AnimationEffect_PATH )
			aBtnAssign.Enable( bPathEffectAvailable );
		else if ( eAE == presentation::AnimationEffect_LASER_FROM_LEFT ||
				  eAE == presentation::AnimationEffect_LASER_FROM_UPPERLEFT ||
				  eAE == presentation::AnimationEffect_LASER_FROM_TOP ||
				  eAE == presentation::AnimationEffect_LASER_FROM_UPPERRIGHT ||
				  eAE == presentation::AnimationEffect_LASER_FROM_RIGHT ||
				  eAE == presentation::AnimationEffect_LASER_FROM_LOWERRIGHT ||
				  eAE == presentation::AnimationEffect_LASER_FROM_BOTTOM ||
				  eAE == presentation::AnimationEffect_LASER_FROM_LOWERLEFT )
		{
			aBtnAssign.Enable( bTextEffectsAllowed && bCount );
		}
		else
			aBtnAssign.Enable( bCount );
	}

	if( aLbSpeed.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
		aLbSpeed.SelectEntryPos( 1 );

	BOOL bEnableTextEffect = TRUE;

	if( !aLbEffect.GetSelectEntryPos() )
	{
		// Favorit
		const USHORT nId  = aCtlEffect.GetSelectItemId();
				
		if( nId != 1 )
		{
			aLbSound.SelectEntry( GetSoundById( nId ) );
			bEnableTextEffect = FALSE;
			aBtnSound.SetState( STATE_CHECK );
		}

		ClickSoundHdl( NULL );

	}

	aBtnVTTextEffect.Enable( bEnableTextEffect && bTextEffectsAllowed );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, SelectTextEffectHdl, void *, p )
{
	if( p != &aCtlTextEffect )
	{
		FillValueSet( &aCtlTextEffect );
	}

/* z.Z. noch nicht in Betrieb
	// Image fuer Text
	USHORT nPos = aLbTextEffect.GetSelectEntryPos();
	if( nPos == 0 )
		aBtnVTTextEffect.SetImage( SdResId( IMG_TEXT ) );
	else
		aBtnVTTextEffect.SetImage( SdResId( IMG_TEXT_ACTIVE ) );
*/
	return( 0L );
}

// -----------------------------------------------------------------------
//	In Abhaengigkeit vom Sound werden Favoriten gesetzt oder entfernt
// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, SelectSoundHdl, void *, p )
{
	presentation::AnimationEffect eAE = GetAnimationEffect( &aCtlEffect );

	if( p )
	{
		BOOL bEnableTextEffect = TRUE;
		USHORT nPos = aLbEffect.GetSelectEntryPos();

		// Favorit ?
		if( nPos == 0  )
		{
			USHORT nId  = aCtlEffect.GetSelectItemId();

			if( nId == 3 || nId == 6 || nId == 9 )
			{
				SetAnimationEffect( presentation::AnimationEffect_NONE, &aCtlEffect );
				SetAnimationEffect( eAE, &aCtlTextEffect );
			}
			else
			{
				if( eAE != presentation::AnimationEffect_NONE )
					SetAnimationEffect( eAE, &aCtlEffect );
				else
				{
					presentation::AnimationEffect eTE = GetAnimationEffect( &aCtlTextEffect );
					SetAnimationEffect( eTE, &aCtlTextEffect );
				}
			}
		}
		else
		{
			presentation::AnimationEffect eTE = GetAnimationEffect( &aCtlTextEffect );

			SetAnimationEffect( eAE, &aCtlEffect );
			SetAnimationEffect( eTE, &aCtlTextEffect );
		}
		aBtnVTTextEffect.Enable( bEnableTextEffect && bTextEffectsAllowed );
	}
	else
	{
		USHORT nPos = aLbEffect.GetSelectEntryPos();
		USHORT nId  = aCtlEffect.GetSelectItemId();

		// TextFavorit ?
		if( nPos == 0  &&
			( nId == 3 || nId == 6 || nId == 9 ) )
		{
			SetAnimationEffect( presentation::AnimationEffect_NONE, &aCtlEffect );
			SetAnimationEffect( eAE, &aCtlTextEffect );
		}
		else
		{
			if( eAE != presentation::AnimationEffect_NONE )
				SetAnimationEffect( eAE, &aCtlEffect );
			else
			{
				presentation::AnimationEffect eTE = GetAnimationEffect( &aCtlTextEffect );
				SetAnimationEffect( eTE, &aCtlTextEffect );
			}
		}
	}
	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickInvisibleHdl, ImageButton *, pBtn )
{
	if( pBtn )
		pBtn->Check( !aBtnInvisible.IsChecked() );

	BOOL bCheck = aBtnInvisible.IsChecked();

	if( bCheck )
	{
		aBtnFadeOut.Check( FALSE );
		aLbFadeOutColor.Enable( FALSE );
	}

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickFadeOutHdl, ImageButton *, pBtn )
{
	if( pBtn )
		pBtn->Check( !pBtn->IsChecked() );

	BOOL bCheck = aBtnFadeOut.IsChecked();

	if( bCheck )
		aBtnInvisible.Check( FALSE );

	aLbFadeOutColor.Enable( bCheck );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickSoundHdl, ImageButton *, pBtn )
{
	if( pBtn )
		pBtn->Check( !pBtn->IsChecked() );

	BOOL bCheck = aBtnSound.IsChecked();

	aBtnPlayFull.Enable( bCheck );
	aBtnSearch.Enable( bCheck );
	aLbSound.Enable( bCheck );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickSearchHdl, ImageButton *, pBtn )
{
	OpenFileDialog();

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, ClickViewTypeHdl, ImageButton *, pBtn )
{
	// Auskommentierter Code wurde in 1.13 entfernt

	// Der folgende Code ist bestimmt fuer 4 Sichten (und 4 Buttons)
	if( pBtn )
	{
		aBtnVTEffect.Check( &aBtnVTEffect == pBtn || ( aBtnVTEffect.IsChecked() && bBreakEven && &aBtnVTExtras == pBtn ) );
		aBtnVTTextEffect.Check( &aBtnVTTextEffect == pBtn || ( aBtnVTTextEffect.IsChecked() && bBreakEven && &aBtnVTExtras == pBtn ) );
		aBtnVTExtras.Check( &aBtnVTOrder != pBtn && ( &aBtnVTExtras == pBtn || ( bBreakEven && aBtnVTExtras.IsEnabled() ) ) );
		aBtnVTOrder.Check( &aBtnVTOrder == pBtn );

		if( aBtnVTEffect.IsChecked() )
			eViewType = VIEWTYPE_EFFECT;
		else if( aBtnVTTextEffect.IsChecked() )
			eViewType = VIEWTYPE_TEXT;
		else if( aBtnVTExtras.IsChecked() )
			eViewType = VIEWTYPE_EXTRAS;
		else if( aBtnVTOrder.IsChecked() )
			eViewType = VIEWTYPE_ORDER;

		if( eViewType == VIEWTYPE_EFFECT )
		{
			aLbEffect.Show();
			aCtlEffect.Show();
			aLbSpeed.Show();

			aLbTextEffect.Hide();
			aCtlTextEffect.Hide();

			aTlbOrder.Hide();
		}
		else if( eViewType == VIEWTYPE_TEXT )
		{
			aLbEffect.Hide();
			aCtlEffect.Hide();
			//aLbSpeed.Hide();
			aLbSpeed.Show();

			aLbTextEffect.Show();
			aCtlTextEffect.Show();

			aTlbOrder.Hide();
		}
		else if( eViewType == VIEWTYPE_EXTRAS )
		{
			if( !bBreakEven )
			{
				aLbEffect.Hide();
				aCtlEffect.Hide();
				aLbSpeed.Hide();

				aLbTextEffect.Hide();
				aCtlTextEffect.Hide();
			}

			aTlbOrder.Hide();
		}
		else if( eViewType == VIEWTYPE_ORDER )
		{
			aLbEffect.Hide();
			aCtlEffect.Hide();
			aLbSpeed.Hide();

			aLbTextEffect.Hide();
			aCtlTextEffect.Hide();

			// TLB ist nicht zwangslauefig auf aktuellem Stand,
			// da nicht immer ModelHasChanged() gerufen wird
			aTlbOrder.Update();
			aTlbOrder.Show();
		}
		if( eViewType != VIEWTYPE_ORDER &&
			( eViewType == VIEWTYPE_EXTRAS || bBreakEven ) )
		{
			aBtnInvisible.Show();
			aBtnFadeOut.Show();
			aLbFadeOutColor.Show();
			aBtnSound.Show();
			aBtnPlayFull.Show();
			aBtnSearch.Show();
			aLbSound.Show();
		}
		else
		{
			aBtnInvisible.Hide();
			aBtnFadeOut.Hide();
			aLbFadeOutColor.Hide();
			aBtnSound.Hide();
			aBtnPlayFull.Hide();
			aBtnSearch.Hide();
			aLbSound.Hide();
		}

		aGrpEffect.SetText( String( SdResId( GetViewTypeResId( eViewType ) ) ) );

		// Button (Assign) muss fuer Order immer enabled sein
		if( eViewType == VIEWTYPE_ORDER )
			aBtnAssign.Enable();
		else
		{
			presentation::AnimationEffect eAE = GetAnimationEffect( &aCtlEffect );
			if( eAE == presentation::AnimationEffect_PATH )
				aBtnAssign.Enable( bPathEffectAvailable );
			else
				aBtnAssign.Enable( bCount );
		}
	}
	else
	{
		aBtnVTEffect.Check( eViewType == VIEWTYPE_EFFECT );
		aBtnVTTextEffect.Check( eViewType == VIEWTYPE_TEXT );
		aBtnVTExtras.Check( eViewType != VIEWTYPE_ORDER && ( eViewType == VIEWTYPE_EXTRAS || ( bBreakEven && aBtnVTExtras.IsEnabled() ) ) );
		aBtnVTOrder.Check( eViewType == VIEWTYPE_ORDER );
	}
	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, MenuSelectHdl, Menu *, pMenu )
{
	return( 0 );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdEffectWin, DoubleClickHdl, void *, p )
{
	if( p == &aCtlEffect &&
		GetAnimationEffect( &aCtlEffect ) == presentation::AnimationEffect_RANDOM )
	{
		USHORT nPos = aLbSpeed.GetSelectEntryPos();
		if( nPos == LISTBOX_ENTRY_NOTFOUND )
			nPos = 2;
		else
			nPos = 3 - nPos;

		USHORT nItemId = aCtlEffect.GetSelectItemId();
		Image  aImage = aCtlEffect.GetItemImage( nItemId );

		for( USHORT i = BMP_EFFECT_FADE_FROM_UL;
			 i <= BMP_EFFECT_PATH;
			 i++ )
		{
			aCtlEffect.SetItemImage( nItemId, Bitmap( SdResId( i ) ) );
			aCtlEffect.Update();
			WaitInEffect(40 * nPos);
		}
		WaitInEffect(200);

		aCtlEffect.SetItemImage( nItemId, aImage );
	}
	// Effekt zuweisen (nur, wenn es nicht der PfadEffekt bei
	//					ungueltiger Konstellation ist)
	if( !( p == &aCtlEffect &&
		  GetAnimationEffect( &aCtlEffect ) == presentation::AnimationEffect_PATH &&
		  !bPathEffectAvailable ) )
		ClickAssignHdl( NULL );

	return( 0L );
}

