/*************************************************************************
 *
 *  $RCSfile: tlborder.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: cl $ $Date: 2002/05/31 14:20:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <tools/urlobj.hxx>
#include <sfx2/app.hxx>
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif

#ifndef _SFX_BINDINGS_HXX
#include <sfx2/bindings.hxx>
#endif

#ifndef _SFXDISPATCH_HXX
#include <sfx2/dispatch.hxx>
#endif

#include "tlborder.hxx"
#include "viewshel.hxx"
#include "docshell.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "sdview.hxx"
#include "sdresid.hxx"
#include "anminfo.hxx"
#include "unoaprms.hxx"                 // Undo-Action
#include "sdundogr.hxx"                 // Undo Gruppe

// fuer Preview-Window
#include "preview.hxx"
#include "prevchld.hxx"

#include "strings.hrc"
#include "res_bmp.hrc"


/*************************************************************************
|*
|* Ctor1 SdOrderTLB
|*
\************************************************************************/

SdOrderTLB::SdOrderTLB(  Window* pParentWin, const SdResId& rSdResId, SfxBindings* pInBindings ) :
	SvTreeListBox   ( pParentWin, rSdResId ),
	pBindings       ( pInBindings ),
	pParent 		( pParentWin ),
	bUpdate			( FALSE ),
	bExtSelect		( FALSE )
{
	// Tree-ListBox mit Linien versehen
	SetWindowBits( WinBits( WB_TABSTOP |
							WB_BORDER |
							WB_HASLINES |
							WB_HASBUTTONS |
							WB_HASLINESATROOT |
							//WB_HSCROLL |
							WB_HASBUTTONSATROOT ) );

	// internes Drag&Drop zulassen
	SetDragDropMode( SV_DRAGDROP_CTRL_MOVE );

	pTable = new Table();

	// Tabelle und ListBox aufbauen
	FillTable( pTable );
	Fill();
}

/*************************************************************************
|*
|* Dtor SdOrderTLB
|*
\************************************************************************/

SdOrderTLB::~SdOrderTLB()
{
	delete pTable;
}

/*************************************************************************
|*
|* Ueberladen, um Flag zu setzen, dass von Aussen die TLB bedient wird
|*
\************************************************************************/

void SdOrderTLB::MouseButtonDown( const MouseEvent& rMEvt )
{
	bExtSelect = TRUE;

	SvTreeListBox::MouseButtonDown( rMEvt );
}

/*************************************************************************
|*
|* Ueberladen, um Flag zu setzen, dass von Aussen die TLB bedient wird
|*
\************************************************************************/

void SdOrderTLB::KeyInput( const KeyEvent& rKEvt )
{
	bExtSelect = TRUE;

	USHORT nKCode = rKEvt.GetKeyCode().GetFullCode();
	if( nKCode != KEY_BACKSPACE && nKCode != KEY_DELETE )
		SvTreeListBox::KeyInput( rKEvt );
}

/*************************************************************************
|*
|* In TreeLB Eintrag selektieren
|*
\************************************************************************/

BOOL SdOrderTLB::SelectEntry( const SdrObject* pObj )
{
	BOOL bFound = FALSE;

	if( pObj )
	{
		SvLBoxEntry* pEntry = NULL;
		SdrObject*	 pTmpObj;

		for( pEntry = First(); pEntry && !bFound; pEntry = Next( pEntry ) )
		{
			pTmpObj = (SdrObject*)pEntry->GetUserData();
			if( pObj == pTmpObj )
			{
				bFound = TRUE;
				SetCurEntry( pEntry );
			}
		}
	}
	return( bFound );
}

/*************************************************************************
|*
|* Selectierten String zurueckgeben
|*
\************************************************************************/

String SdOrderTLB::GetSelectEntry()
{
	return( GetEntryText( GetCurEntry() ) );
}

/*************************************************************************
|*
|* Select-Hdl
|*
\************************************************************************/

//void SdOrderTLB::SelectHdl()
BOOL SdOrderTLB::Select( SvLBoxEntry* pEntry, BOOL bSelect )
{
	BOOL bReturn = SvTreeListBox::Select( pEntry, bSelect );

	if( bReturn && bSelect )
	{
		if( bExtSelect )
		{
			bExtSelect = FALSE;

			if( bUpdate )
			{
				//SvLBoxEntry* pEntry = FirstSelected();
				if( pEntry )
				{
					SdrObject* pObj = (SdrObject*)pEntry->GetUserData();
					if( pObj )
					{
						SdViewShell*	pViewShell= ( SdViewShell* ) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
						SdrView*		pView	  = pViewShell->GetDrawView();
						SdrPageView*	pPageView = pView->GetPageViewPvNum( 0 );

						pView->UnmarkAll();
						pView->MarkObj( pObj, pPageView, FALSE );
					}
				}
			}
		}
	}
	return( bReturn );
}

/*************************************************************************
|*
|* TreeLB mit Seiten und Objekten fuellen
|*
\************************************************************************/

void SdOrderTLB::Fill()
{
	Color aColor( COL_WHITE );
	Bitmap aBmpObject( SdResId( BMP_OBJECTS ) );
	Image aImgObject( aBmpObject, aColor );
	Bitmap aBmpGroup( SdResId( BMP_GROUP ) );
	Image aImgGroup( aBmpGroup, aColor );
	Bitmap aBmpObjectH( SdResId( BMP_OBJECTS_H ) );
	Image aImgObjectH( aBmpObjectH, Color( COL_BLACK ) );
	Bitmap aBmpGroupH( SdResId( BMP_GROUP_H ) );
	Image aImgGroupH( aBmpGroupH, Color( COL_BLACK ) );

	SdDrawDocShell* pDocSh = ( SdDrawDocShell* ) pBindings->GetDispatcher()->GetFrame()->GetObjectShell();
	SdDrawDocument*	pDoc      = pDocSh->GetDoc();
	SdrObject*	 	pObj 	  = NULL;
	SvLBoxEntry*	pEntry	  = NULL;

	for( pObj = (SdrObject*)pTable->First();
		 pObj;
		 pObj = (SdrObject*)pTable->Next() )
	{
		SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pObj );
		if( pInfo && pInfo->bActive )
		{
			String aStr( pObj->GetName() );
			if( aStr.Len() == 0 )
			{
				aStr = String( SdResId( STR_EFFECTDLG_OBJECT ) );
				aStr.Append( sal_Unicode(' ') );
				aStr.Append( UniString::CreateFromInt32( pObj->GetOrdNum() + 1 ) );
			}
			String aObjStr;
			pObj->TakeObjNameSingul( aObjStr );
			aStr.AppendAscii( " (" );
			aStr.Append( aObjStr );
			aStr.Append( sal_Unicode(')') );

			// Reihenfolge
			ULONG nPos = pInfo->nPresOrder;

			if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRUP )
			{
				pEntry = InsertEntry( aStr, aImgGroup, aImgGroup, 0, FALSE, nPos );
				SetExpandedEntryBmp( pEntry, aImgGroupH, BMP_COLOR_HIGHCONTRAST );
				SetCollapsedEntryBmp( pEntry, aImgGroupH, BMP_COLOR_HIGHCONTRAST );
			}
			else
			{
				pEntry = InsertEntry( aStr, aImgObject, aImgObject, 0, FALSE, nPos );
				SetExpandedEntryBmp( pEntry, aImgObjectH, BMP_COLOR_HIGHCONTRAST );
				SetCollapsedEntryBmp( pEntry, aImgObjectH, BMP_COLOR_HIGHCONTRAST );
			}

			pEntry->SetUserData( pObj );
		}
	}
}

/*************************************************************************
|*
|* Inhalt Ueberprufen und ggfs. die TLB neu aufbauen
|*
\************************************************************************/

void SdOrderTLB::Update()
{
	BOOL bDifferent = FALSE;
	SdDrawDocShell* pDocSh = ( SdDrawDocShell* ) pBindings->GetDispatcher()->GetFrame()->GetObjectShell();
	SdDrawDocument*	pDoc      = pDocSh->GetDoc();
	SdrObject*	 	pObj 	  = NULL;
	SdrObject*	 	pObj2 	  = NULL;

	// Tabelle aufbauen
	Table* pNewTab = new Table();
	FillTable( pNewTab );

	// Anzahl
	ULONG nCount = pNewTab->Count();
	if( nCount != GetEntryCount() )
		bDifferent = TRUE;

	for( pObj = (SdrObject*)pTable->First(), pObj2 = (SdrObject*)pNewTab->First();
		 pObj && pObj2 && !bDifferent;
		 pObj = (SdrObject*)pTable->Next(), pObj2 = (SdrObject*)pNewTab->Next() )
	{
		if( pObj != pObj2 )
			bDifferent = TRUE;
	}

	if( bDifferent )
	{
		delete pTable;
		pTable = pNewTab;

		Clear();
		Fill();
	}
	else
		delete pNewTab;

	// Eintrag selektieren
	if( bUpdate )
	{
		SdViewShell* pViewShell= ( SdViewShell* ) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
		SdrView* pView = pViewShell->GetDrawView();
		SdrMarkList aMarkList = pView->GetMarkList();
		ULONG nMarkCount = aMarkList.GetMarkCount();
		if( nMarkCount == 1 )
		{
			pObj = aMarkList.GetMark( 0 )->GetObj();
			if( !SelectEntry( pObj ) )
				SelectAll( FALSE );
		}
		else
			SelectAll( FALSE );
	}
}

/*************************************************************************
|*
|* Tabelle aufbauen
|*
\************************************************************************/

void SdOrderTLB::FillTable( Table* pTab )
{
	SdDrawDocShell* pDocSh = ( SdDrawDocShell* ) pBindings->GetDispatcher()->GetFrame()->GetObjectShell();
	SdDrawDocument*	pDoc      = pDocSh->GetDoc();
	SdViewShell*	pViewShell= pDocSh->GetViewShell();
	SdPage* 	 	pPage 	  = pViewShell->GetActualPage();
	SdrObject*	 	pObj 	  = NULL;
	SdrObjListIter	aIter( *pPage, IM_FLAT );

	ULONG i = 0;
	while( aIter.IsMore() )
	{
		pObj = aIter.Next();
		SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pObj );
		SdrObjKind eKind	   = (SdrObjKind)pObj->GetObjIdentifier();

		if( pInfo && pInfo->bActive )
		{
			// Wenn es sich um das Pfad-Objekt bei dem Effekt "An Kurve entlang"
			// handelt, soll es nicht in der Tabelle aufgenommen werden
			// "bInvisibleInPresentation" ist der einzige Hinweis darauf, ob
			// es sich um das Pfad-Objekt handelt
			if( !( pInfo->bInvisibleInPresentation &&
				   pObj->GetObjInventor() == SdrInventor &&
				   ( (eKind == OBJ_LINE) ||        // 2-Punkt-Linie
					 (eKind == OBJ_PLIN) ||        // Polygon
					 (eKind == OBJ_PATHLINE) ) ) ) // Bezier-Kurve
			{
				ULONG nPos = pInfo->nPresOrder;
				// eindeutiger Key wird generiert
				if( nPos == LIST_APPEND )
					nPos /= 1024;
				else
					nPos *= 1024;
				nPos += ++i;
				BOOL bOK = pTab->Insert( nPos, pObj );
				DBG_ASSERT( bOK, "Table::Insert fehlgeschlagen (Key schon vorhanden)" );
			}
		}
	}
}

/*************************************************************************
|*
|* Reihenfolge an der Page zuweisen
|*
\************************************************************************/

void SdOrderTLB::Assign()
{
	SdDrawDocShell* pDocSh = ( SdDrawDocShell* ) pBindings->GetDispatcher()->GetFrame()->GetObjectShell();
	SdDrawDocument*	pDoc      = pDocSh->GetDoc();
	SdrObject*		pObj 	  = NULL;
	SvLBoxEntry*	pEntry 	  = NULL;

	// Undo...
	SfxUndoManager*				pUndoMgr = pDocSh->GetUndoManager();
	SdAnimationPrmsUndoAction*	pAction = NULL;
	SdUndoGroup*				pUndoGroup = NULL;
	String	aComment( SdResId( STR_UNDO_ANIMATION_ORDER ) );


	ULONG i = 0;
	for( pEntry = First(); pEntry; pEntry = Next( pEntry ), i++ )
	{
		pObj = (SdrObject*)pEntry->GetUserData();
		if( pObj )
		{
			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pObj );
			if( pInfo && pInfo->bActive )
			{
				if( pInfo->nPresOrder != i )
				{
					if( !pAction )
					{
						// Undo klammern
						pUndoMgr->EnterListAction( aComment, aComment );

						// Undo Gruppe erzeugen
						pUndoGroup = new SdUndoGroup( pDoc );
						pUndoGroup->SetComment( aComment );
					}

					// die eigentliche Undo-Action...
					pAction = new SdAnimationPrmsUndoAction( pDoc, pObj );
					pAction->SetPresOrder( pInfo->nPresOrder, i );
					pUndoGroup->AddAction( pAction );
					//pUndoMgr->AddUndoAction( pAction );

					// Dies ist die eigentlich Animations-Reihenfolge
					pInfo->nPresOrder = i;
				}
			}
		}
	}

	if( pAction ) // Aenderungen wurden gemacht
	{
		// Undo Gruppe dem Undo Manager uebergeben
		pUndoMgr->AddUndoAction( pUndoGroup );
		pUndoMgr->LeaveListAction();

		// Tabelle auf den neuesten Stand bringen (insb. fuer Undo/Redo)
		pTable->Clear();
		FillTable( pTable );

		// Dokument ist geaendert worden
		pDoc->SetChanged();

		// ggfs. in Preview anzeigen
		SfxChildWindow* pPreviewChildWindow =
			pBindings->GetDispatcher()->GetFrame()->GetChildWindow( SdPreviewChildWindow::GetChildWindowId() );
		if( pPreviewChildWindow )
		{
			SdPreviewWin* pPreviewWin = (SdPreviewWin*)pPreviewChildWindow->GetWindow();
			if( pPreviewWin )
				pPreviewWin->AnimatePage();
		}
	}
}


