/*************************************************************************
 *
 *  $RCSfile: effect.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: cl $ $Date: 2002/05/21 14:03:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SD_EFFECT_HXX
#define _SD_EFFECT_HXX

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif

#ifndef _IMAGEBTN_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _SVX_DLG_CTRL_HXX //autogen
#include <svx/dlgctrl.hxx>
#endif
#ifndef _SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SFXCTRLITEM_HXX //autogen
#include <sfx2/ctrlitem.hxx>
#endif
#ifndef _SFXDOCKWIN_HXX //autogen
#include <sfx2/dockwin.hxx>
#endif

#ifndef _SD_SDRESID_HXX
#include "sdresid.hxx"
#endif
#ifndef _TLBORDER_HXX
#include "tlborder.hxx"
#endif
#ifndef _SD_EFCTCHLD_HXX
#include "efctchld.hxx"
#endif
#ifndef _SD_ANMDEF_HXX
#include "anmdef.hxx"
#endif

class SdDrawDocument;
class SdView;

enum ViewType
{
	VIEWTYPE_EFFECT = 1,
	VIEWTYPE_TEXT,
	VIEWTYPE_EXTRAS,
	VIEWTYPE_ORDER
};

// Bitte mitpflegen !!!
#define VIEWTYPE_COUNT 4


#define EFFECT_STATE_NONE	0x00000000

#define EFFECT_COUNT	 	0x00000001
#define EFFECT_PATH			0x00000002

//------------------------------------------------------------------------

class SdEffectWin : public SfxDockingWindow
{
 friend class SdEffectChildWindow;
 friend class SdEffectCtrlItem;
 friend class SdEffectPrevCtrlItem;

private:
	ImageButton			aBtnVTEffect;
	ImageButton			aBtnVTTextEffect;
	ImageButton			aBtnVTExtras;
	ImageButton			aBtnVTOrder;

	ImageButton 		aBtnPreview;
	ImageButton 		aBtnUpdate;
	ImageButton 		aBtnAssign;

	ListBox				aLbEffect;
	ValueSet			aCtlEffect;
	ListBox				aLbSpeed;

	ListBox				aLbTextEffect;
	ValueSet			aCtlTextEffect;

	ImageButton			aBtnInvisible;
	ImageButton			aBtnFadeOut;
	ColorLB				aLbFadeOutColor;
	ImageButton			aBtnSound;
	ImageButton			aBtnPlayFull;
	ImageButton			aBtnSearch;
	ListBox 			aLbSound;

	SdOrderTLB			aTlbOrder;

	FixedLine			aGrpEffect;

	Size				aSize;
	USHORT				aValueSetHeight;
	USHORT				aExtrasHeight;
	USHORT				aBreakEvenHeight;
	BOOL				bBreakEven;

	USHORT				aBtnInvisiblePosY;
	USHORT				aBtnFadeOutPosY;
	USHORT				aLbFadeOutColorPosY;
	USHORT				aBtnSoundPosY;
	USHORT				aBtnPlayFullPosY;
	USHORT				aBtnSearchPosY;
	USHORT				aLbSoundPosY;

	BOOL				bTextEffectsAllowed;
	BOOL				bPathEffectAvailable;
	BOOL				bCount;
	BOOL				bUpdate;
	ViewType			eViewType;

	List*				ppStringIdList;
	List*				ppBitmapIdList;
	List*				ppHCBitmapIdList;
	List*				ppStringIdListTE; // TE fuer TextEffekt
	List*				ppBitmapIdListTE; // dito
	List*				ppHCBitmapIdListTE; // dito
	List*				pSoundList;

	SfxBindings*			pBindings;
	SdEffectCtrlItem*		pControllerItem;
	SdEffectPrevCtrlItem*	pEffectPrevCtrlItem;

	//------------------------------------

	DECL_LINK( ClickViewTypeHdl, ImageButton * );
	DECL_LINK( ClickPreviewHdl, void * );
	DECL_LINK( ClickUpdateHdl, void * );
	DECL_LINK( ClickAssignHdl, void * );

	DECL_LINK( SelectEffectHdl, void * );
	DECL_LINK( SelectTextEffectHdl, void * );
	DECL_LINK( SelectSoundHdl, void * );

	DECL_LINK( ClickInvisibleHdl, ImageButton * );
	DECL_LINK( ClickFadeOutHdl, ImageButton * );
	DECL_LINK( ClickSoundHdl, ImageButton * );
	DECL_LINK( ClickSearchHdl, ImageButton * );

	DECL_LINK( ClickImageButtonHdl, ImageButton * );
	DECL_LINK( MenuSelectHdl, Menu * );
	DECL_LINK( DoubleClickHdl, void * );

	void 			OpenFileDialog();

	void			Construct();
	void			Reset();
	void			FillValueSet( ValueSet* );
	USHORT			GetBitmapId( USHORT i, USHORT nPos, ValueSet* );
	USHORT			GetStringId( USHORT i, USHORT nPos, ValueSet* );
	void			WaitInEffect( ULONG nMilliSeconds ) const;
	void			SetAnimationEffect( ::com::sun::star::presentation::AnimationEffect eAE, ValueSet* );
	::com::sun::star::presentation::AnimationEffect GetAnimationEffect( ValueSet* );
	USHORT 			GetViewTypeResId( ViewType eVT, BOOL bImage = FALSE );

	void			FillSoundListAndBox();
	void			ClearSoundList();
	long			GetSoundObject( const String& rStr );
	String			GetSoundById( USHORT nId );
	USHORT			GetIdBySound( const String& rStr );

	virtual void DataChanged( const DataChangedEvent& rDCEvt );

protected:
	virtual BOOL	Close();
	virtual void	Resize();

public:
			SdEffectWin( SfxBindings* pBindings, SfxChildWindow *pCW,
						Window* pParent, const SdResId& rSdResId );
			~SdEffectWin();

	void	InitColorLB( const SdDrawDocument* pDoc );
	BOOL	IsUpdateMode() const { return bUpdate; }

	void	Update( SfxItemSet& rSet );
	void	GetAttr( SfxItemSet& rSet );
	//void	Assign( SdView& rView );
};

/*************************************************************************
|*
|* ControllerItem fuer Effekte Window (Floating/Docking)
|*
\************************************************************************/

class SdEffectCtrlItem : public SfxControllerItem
{
	SdEffectWin* pEffectWin;

 protected:
	virtual void StateChanged( USHORT nSId, SfxItemState eState,
								const SfxPoolItem* pState );

 public:
	SdEffectCtrlItem( USHORT, SdEffectWin*, SfxBindings* );
};

/*************************************************************************
|*
|* ControllerItem fuer Preview-Button
|*
\************************************************************************/

class SdEffectPrevCtrlItem : public SfxControllerItem
{
	SdEffectWin*	pWin;

 protected:
	virtual void StateChanged( USHORT nSId, SfxItemState eState,
								const SfxPoolItem* pState );

 public:
	SdEffectPrevCtrlItem( USHORT, SdEffectWin*, SfxBindings* );
};

#endif		// _SD_EFFECT_HXX

