/*************************************************************************
 *
 *  $RCSfile: showwin.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/06 10:46:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
#include <svtools/syslocale.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#pragma hdrstop

#include "res_bmp.hrc"
#include "showwin.hxx"
#include "slidvish.hxx"
#include "fuslshow.hxx"
#include "preview.hxx"
#include "sdresid.hxx"
#include "helpids.h"
#include "strings.hrc"

#define SHOWWIN_FONTHEIGHT 14

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SdShowWindow::SdShowWindow( Window* pParent, SdPreviewWin* pPreviewWin ) :
	SdWindow(pParent),
	pPreview(pPreviewWin),
    eShowWindowMode(SHOWWINDOWMODE_NORMAL),
	nRestartPage( PAGE_NO_END ),
	nPauseTimeout( SLIDE_NO_TIMEOUT ),
	bShowNavigatorAfterSpecialMode( FALSE )
{
    // Do never mirror the preview window.  This explicitly includes right
    // to left writing environments.
    EnableRTL (FALSE);

	MapMode aMap(GetMapMode());
	aMap.SetMapUnit(MAP_100TH_MM);
	SetMapMode(aMap);

	// HelpId setzen
	SetHelpId( HID_SD_WIN_PRESENTATION );
	SetUniqueId( HID_SD_WIN_PRESENTATION );

	aPauseTimer.SetTimeoutHdl( LINK( this, SdShowWindow, PauseTimeoutHdl ) );
	aPauseTimer.SetTimeout( 1000 );

	Bitmap 	  aBitmap(SdResId(BMP_WAIT_ICON));
	BitmapEx  aBmpEx( aBitmap, COL_LIGHTMAGENTA );
	AlphaMask aMask( aBmpEx.GetMask() );
	aMask.Replace( 0, 128 );
	aWaitIcon = BitmapEx( aBmpEx.GetBitmap(), aMask );

	aRestoreSpace.SetSizePixel( aWaitIcon.GetSizePixel() );
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SdShowWindow::~SdShowWindow()
{
}

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

void SdShowWindow::KeyInput(const KeyEvent& rKEvt)
{
	if( SHOWWINDOWMODE_END == eShowWindowMode )
		TerminateShow();
	else if( SHOWWINDOWMODE_BLANK == eShowWindowMode )
	{
		RestartShow();
	}
	else if( SHOWWINDOWMODE_PAUSE == eShowWindowMode )
	{
		if( rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE )
			TerminateShow();
		else
			RestartShow();
	}
	else
	{
		BOOL bReturn = FALSE;

		if( pViewShell )
			bReturn = pViewShell->KeyInput(rKEvt, this);
		else if (pPreview)
			pPreview->KeyInputFromContents(rKEvt);

		if( !bReturn )
			Window::KeyInput(rKEvt);
	}

	if( pViewShell )
		pViewShell->SetActiveWindow( this );
}

/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/

void SdShowWindow::MouseButtonDown(const MouseEvent& rMEvt)
{
	if( SHOWWINDOWMODE_NORMAL == eShowWindowMode )
	{
		if( pViewShell )
			pViewShell->MouseButtonDown( rMEvt, this );
		else if (pPreview)
			pPreview->MouseButtonDownFromContents(rMEvt);
	}
	else if( pViewShell )
		pViewShell->SetActiveWindow( this );
}

/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/

void SdShowWindow::MouseMove(const MouseEvent& rMEvt)
{
	if( SHOWWINDOWMODE_NORMAL == eShowWindowMode )
	{
		if (pViewShell)
			pViewShell->MouseMove( rMEvt, this );
		else if (pPreview)
			pPreview->MouseMoveFromContents( rMEvt );
	}
	else if( pViewShell )
		pViewShell->SetActiveWindow( this );
}

/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

void SdShowWindow::MouseButtonUp(const MouseEvent& rMEvt)
{
	if( SHOWWINDOWMODE_END == eShowWindowMode )
		TerminateShow();
	else if( ( SHOWWINDOWMODE_BLANK == eShowWindowMode ) ||
	         ( SHOWWINDOWMODE_PAUSE == eShowWindowMode ) )
	{
        RestartShow();
	}
	else if( pViewShell )
		pViewShell->MouseButtonUp( rMEvt, this );
	else if (pPreview)
		pPreview->MouseButtonUpFromContents( rMEvt );
}

/*************************************************************************
|*
|* Paint-Event: wenn FuSlideShow noch erreichbar ist, weiterleiten
|*
\************************************************************************/

void SdShowWindow::Paint(const Rectangle& rRect)
{
	if( SHOWWINDOWMODE_END == eShowWindowMode )
		DrawEndScene();
	else if( SHOWWINDOWMODE_PAUSE == eShowWindowMode )
		DrawPauseScene( FALSE );
	else if( SHOWWINDOWMODE_BLANK == eShowWindowMode )
		DrawBlankScene();
	else
	{
		if (pViewShell)
			pViewShell->Paint(rRect, this);
		else if (pPreview)
			pPreview->PaintContents(rRect);
	}
}

/*************************************************************************
|*
|* ParentNotify
|*
\************************************************************************/

long SdShowWindow::ParentNotify(NotifyEvent& rNEvt)
{
	long nOK = FALSE;

	if( pViewShell && rNEvt.GetType() == EVENT_GETFOCUS )
	{
		NotifyEvent aNEvt(EVENT_GETFOCUS, this);
		nOK = pViewShell->GetViewFrame()->GetWindow().Notify(aNEvt);
	}

	if (!nOK)
		nOK = SdWindow::Notify(rNEvt);

	return nOK;
}


/*************************************************************************
|*
|* GetFocus()
|* Window des MDIFrames benachrichtigen
|*
\************************************************************************/

void SdShowWindow::GetFocus()
{
	// Basisklasse
	SdWindow::GetFocus();

	if( pViewShell )
	{
		NotifyEvent aNEvt(EVENT_GETFOCUS, this);
		pViewShell->GetViewFrame()->GetWindow().Notify(aNEvt);
	}
}

/*************************************************************************
|*
|* GetFocus()
|* Window des MDIFrames benachrichtigen
|*
\************************************************************************/

BOOL SdShowWindow::SetEndMode()
{
	if( ( SHOWWINDOWMODE_NORMAL == eShowWindowMode ) && !pPreview && pViewShell && pViewShell->GetView() )
	{
		pViewShell->GetView()->DelWin( this );
		eShowWindowMode = SHOWWINDOWMODE_END;
		aShowBackground = GetBackground();
		SetBackground( Wallpaper( Color( COL_BLACK ) ) );

		// hide navigator if it is visible
		if( GetViewShell()->GetViewFrame()->GetChildWindow( SID_NAVIGATOR ) )
		{
			GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, FALSE );
			bShowNavigatorAfterSpecialMode = TRUE;
		}

		Invalidate();
	}

	return( SHOWWINDOWMODE_END == eShowWindowMode );
}

// -----------------------------------------------------------------------------

BOOL SdShowWindow::SetPauseMode( USHORT nPageToRestart, ULONG nTimeout, Graphic* pLogo )
{
	if( pViewShell && pViewShell->GetSlideShow() && !nTimeout )
		pViewShell->GetSlideShow()->JumpToPage( nPageToRestart );
	else if( ( SHOWWINDOWMODE_NORMAL == eShowWindowMode ) && !pPreview && pViewShell && pViewShell->GetView() )
	{
		pViewShell->GetView()->DelWin( this );
		nPauseTimeout = nTimeout;
		nRestartPage = nPageToRestart;
		eShowWindowMode = SHOWWINDOWMODE_PAUSE;
		aShowBackground = GetBackground();
		SetBackground( Wallpaper( Color( COL_BLACK ) ) );

		// hide navigator if it is visible
		if( GetViewShell()->GetViewFrame()->GetChildWindow( SID_NAVIGATOR ) )
		{
			GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, FALSE );
			bShowNavigatorAfterSpecialMode = TRUE;
		}

		if( pLogo )
			aLogo = *pLogo;

		Invalidate();

		if( SLIDE_NO_TIMEOUT != nPauseTimeout )
			aPauseTimer.Start();
	}

	return( SHOWWINDOWMODE_PAUSE == eShowWindowMode );
}

// -----------------------------------------------------------------------------

BOOL SdShowWindow::SetBlankMode( USHORT nPageToRestart, const Color& rBlankColor )
{
    if( ( SHOWWINDOWMODE_NORMAL == eShowWindowMode ) && !pPreview && pViewShell && pViewShell->GetView() )
	{
		pViewShell->GetView()->DelWin( this );
		nRestartPage = nPageToRestart;
		eShowWindowMode = SHOWWINDOWMODE_BLANK;
		aShowBackground = GetBackground();
		SetBackground( Wallpaper( rBlankColor ) );

		// hide navigator if it is visible
		if( GetViewShell()->GetViewFrame()->GetChildWindow( SID_NAVIGATOR ) )
		{
			GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, FALSE );
			bShowNavigatorAfterSpecialMode = TRUE;
		}

		Invalidate();
	}

	return( SHOWWINDOWMODE_BLANK == eShowWindowMode );
}

// -----------------------------------------------------------------------------

void SdShowWindow::TerminateShow()
{
	aLogo.Clear();
	aPauseTimer.Stop();
	Erase();
	SetBackground( aShowBackground );
    eShowWindowMode = SHOWWINDOWMODE_NORMAL;
	nPauseTimeout = SLIDE_NO_TIMEOUT;

	// show navigator?
	if( bShowNavigatorAfterSpecialMode )
	{
		GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, TRUE );
		bShowNavigatorAfterSpecialMode = FALSE;
	}

	if( pViewShell && pViewShell->GetSlideShow() )
	{
		if( pViewShell->GetView() )
			pViewShell->GetView()->AddWin( this );

		pViewShell->GetSlideShow()->Terminate();
	}

	nRestartPage = PAGE_NO_END;
}

// -----------------------------------------------------------------------------

void SdShowWindow::RestartShow()
{
    ShowWindowMode eOldShowWindowMode = eShowWindowMode;

	aLogo.Clear();
	aPauseTimer.Stop();
	Erase();
	SetBackground( aShowBackground );
    eShowWindowMode = SHOWWINDOWMODE_NORMAL;
	nPauseTimeout = SLIDE_NO_TIMEOUT;

	if( pViewShell && pViewShell->GetSlideShow() )
	{
		if( pViewShell->GetView() )
			pViewShell->GetView()->AddWin( this );
	
	    if( SHOWWINDOWMODE_BLANK == eOldShowWindowMode )
	        Invalidate();
	    else
		    pViewShell->GetSlideShow()->JumpToPage( nRestartPage );
	}

	nRestartPage = PAGE_NO_END;

	// show navigator?
	if( bShowNavigatorAfterSpecialMode )
	{
		GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, TRUE );
		bShowNavigatorAfterSpecialMode = FALSE;
	}
}

// -----------------------------------------------------------------------------

void SdShowWindow::DrawPauseScene( BOOL bTimeoutOnly )
{
	const MapMode&	rMap = GetMapMode();
	const Point		aOutOrg( PixelToLogic( Point() ) );
	const Size		aOutSize( GetOutputSize() );
	const Size		aTextSize( LogicToLogic( Size( 0, SHOWWIN_FONTHEIGHT ), MAP_POINT, rMap ) );
	const Size		aOffset( LogicToLogic( Size( 1000, 1000 ), MAP_100TH_MM, rMap ) );
	String			aText( SdResId( STR_PRES_PAUSE ) );
	BOOL			bDrawn = FALSE;

	Font 			aFont( GetSettings().GetStyleSettings().GetMenuFont() );
	const Font 		aOldFont( GetFont() );

	aFont.SetSize( aTextSize );
	aFont.SetColor( COL_WHITE );
	aFont.SetCharSet( aOldFont.GetCharSet() );
	aFont.SetLanguage( aOldFont.GetLanguage() );

	if( !bTimeoutOnly && ( aLogo.GetType() != GRAPHIC_NONE ) )
	{
		Size aGrfSize;

		if( aLogo.GetPrefMapMode() == MAP_PIXEL )
			aGrfSize = PixelToLogic( aLogo.GetPrefSize() );
		else
			aGrfSize = LogicToLogic( aLogo.GetPrefSize(), aLogo.GetPrefMapMode(), rMap );

		const Point	aGrfPos( Max( aOutOrg.X() + aOutSize.Width() - aGrfSize.Width() - aOffset.Width(), aOutOrg.X() ),
							 Max( aOutOrg.Y() + aOutSize.Height() - aGrfSize.Height() - aOffset.Height(), aOutOrg.Y() ) );

		if( aLogo.IsAnimated() )
			aLogo.StartAnimation( this, aGrfPos, aGrfSize, (long) this );
		else
			aLogo.Draw( this, aGrfPos, aGrfSize );
	}

	if( SLIDE_NO_TIMEOUT != nPauseTimeout )
	{
		MapMode			aVMap( rMap );
		VirtualDevice	aVDev( *this );

		aVMap.SetOrigin( Point() );
		aVDev.SetMapMode( aVMap );
		aVDev.SetBackground( Wallpaper( Color( COL_BLACK ) ) );
		
		// set font first, to determine real output height
		aVDev.SetFont( aFont );
			
		const Size aVDevSize( aOutSize.Width(), aVDev.GetTextHeight() );

		if( aVDev.SetOutputSize( aVDevSize ) )
		{
			// Note: if performance gets an issue here, we can use NumberFormatter directly
			SvtSysLocale				aSysLocale;
			const LocaleDataWrapper&    aLocaleData = aSysLocale.GetLocaleData();
			
			aText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " ( " ));
			aText += aLocaleData.getDuration( Time( 0, 0, nPauseTimeout ) );
			aText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " )" ));
			aVDev.DrawText( Point( aOffset.Width(), 0 ), aText );
			DrawOutDev( Point( aOutOrg.X(), aOffset.Height() ), aVDevSize, Point(), aVDevSize, aVDev );
			bDrawn = TRUE;
		}
	}

	if( !bDrawn )
	{
		SetFont( aFont );
		DrawText( Point( aOutOrg.X() + aOffset.Width(), aOutOrg.Y() + aOffset.Height() ), aText );
		SetFont( aOldFont );
	}
}

// -----------------------------------------------------------------------------

void SdShowWindow::DrawEndScene()
{
	const Font		aOldFont( GetFont() );
	Font			aFont( GetSettings().GetStyleSettings().GetMenuFont() );

	const Point		aOutOrg( PixelToLogic( Point() ) );
	const Size		aTextSize( LogicToLogic( Size( 0, SHOWWIN_FONTHEIGHT ), MAP_POINT, GetMapMode() ) );
	const String	aText( SdResId( STR_PRES_SOFTEND ) );

	aFont.SetSize( aTextSize );
	aFont.SetColor( COL_WHITE );
	aFont.SetCharSet( aOldFont.GetCharSet() );
	aFont.SetLanguage( aOldFont.GetLanguage() );
	SetFont( aFont );
	DrawText( Point( aOutOrg.X() + aTextSize.Height(), aOutOrg.Y() + aTextSize.Height() ), aText );
	SetFont( aOldFont );
}

// -----------------------------------------------------------------------------

void SdShowWindow::DrawBlankScene()
{
    // just blank through background color => nothing to be done here
}

// -----------------------------------------------------------------------------

IMPL_LINK( SdShowWindow, PauseTimeoutHdl, Timer*, pTimer )
{
	if( !( --nPauseTimeout ) )
		RestartShow();
	else
	{
		DrawPauseScene( TRUE );
		pTimer->Start();
	}

	return 0L;
}

// -----------------------------------------------------------------------------

const int BORDER = 16;

void SdShowWindow::DrawWaitIcon()
{
	const MapMode nOldMode = GetMapMode();
	SetMapMode( MapMode(MAP_PIXEL) );

	Size aOutputSize = GetOutputSizePixel();
	Size aIconSize = aWaitIcon.GetSizePixel();

	Point aPoint( BORDER, aOutputSize.Height() - aIconSize.Height() - BORDER );

	aRestoreSpace = GetBitmap( aPoint, aIconSize );

	DrawBitmapEx( aPoint, aWaitIcon );

	SetMapMode( nOldMode );
}

// -----------------------------------------------------------------------------

void SdShowWindow::ClearWaitIcon()
{
	const MapMode nOldMode = GetMapMode();
	SetMapMode( MapMode(MAP_PIXEL) );

	Size aOutputSize = GetOutputSizePixel();
	Size aIconSize = aWaitIcon.GetSizePixel();

	Point aPoint( BORDER, aOutputSize.Height() - aIconSize.Height() - BORDER );

	DrawBitmap( aPoint, aRestoreSpace );

	SetMapMode( nOldMode );
}


