#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: hr $ $Date: 2003/06/30 16:12:03 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=..$/..
PRJNAME=sdk_oo
TARGET=copying

#----------------------------------------------------------------
.INCLUDE: settings.mk
.INCLUDE: $(PRJ)$/util$/makefile.pmk
#----------------------------------------------------------------

IDLLIST={$(subst,/,$/ $(shell $(FIND) $(IDLOUT) -type f | sed -e '/star.portal/d' -e'/star.webservices/d'))}
IDL_DOCU_INDEX_FILE = $(DESTDIRGENIDLREF)$/module-ix.html
IDL_CHAPTER_REFS=idl_chapter_refs.txt

DOCUHTMLFILES= \
    $(DESTDIR)$/index.html \
    $(DESTDIRDOCU)$/tools.html \
    $(DESTDIRDOCU)$/notsupported.html \
    $(DESTDIRDOCU)$/install.html \
    $(DESTDIRDOCU)$/DevelopersGuide_intro.html \
    $(DESTDIREXAMPLES)$/examples.html \
    $(DESTDIREXAMPLES)$/DevelopersGuide$/examples.html

DOCUFILES= \
    $(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.htm \
    $(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.pdf \
    $(DESTDIRDOCU)$/sdk_styles.css \
    $(DESTDIRDOCUIMAGES)$/logo.gif \
    $(DESTDIRDOCUIMAGES)$/sdk_logo.gif

.IF "$(GUI)"=="WNT"
DOCUFILES += \
    $(DESTDIR)$/license.html \
    $(DESTDIR)$/license.txt
.ELSE
DOCUFILES += \
    $(DESTDIR)$/license.html \
    $(DESTDIR)$/LICENSE
.ENDIF

all : 	\
    $(DOCUFILES) \
    $(DESTDIR)$/settings$/dk.mk \
    $(IDL_DOCU_INDEX_FILE) \
    $(CONVERTTAGFLAG) 

$(DESTDIRDOCU)$/sdk_styles.css : $(PRJ)$/docs$/sdk_styles.css
	+-$(MKDIRHIER) $(@:d)    
	+-rm -f $(CONVERTTAGFLAG) >& $(NULLDEV)
	$(MY_COPY) $? $@

$(DESTDIR)$/license.html : $(PRJ)$/license$/license.html
	+-$(MKDIRHIER) $(@:d)        
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIR)$/license.txt : $(PRJ)$/license$/license.txt
	+-$(MKDIRHIER) $(@:d)        
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIR)$/LICENSE : $(PRJ)$/license$/LICENSE
	+-$(MKDIRHIER) $(@:d)        
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIRDOCUIMAGES)$/% : $(PRJ)$/docs$/images$/%
	+-$(MKDIRHIER) $(@:d)    
	+-rm -f $@ >& $(NULLDEV)
	$(MY_COPY) $? $@

$(DESTDIR)$/settings$/dk.mk :
	+-$(MKDIRHIER) $(@:d)    
	+-rm -f $@ >& $(NULLDEV)
	echo #$(PRODUCT_NAME) dependent settings > $@
	echo DKNAME=$(PRODUCT_NAME)>> $@
.IF "$(GUI)"=="UNX"
	echo 'BUILDID= $(RSCREVISION)'>> $@
	echo 'DKREGISTRYNAME=$$(subst \\,\,"$$(OFFICE_PROGRAM_PATH)$$(PS)types.rdb")' >> $@
.ELSE
	echo BUILDID= $(RSCREVISION)>> $@
	echo DKREGISTRYNAME=$$(subst \\,\,"$$(OFFICE_PROGRAM_PATH)$$(PS)types.rdb") >> $@
.ENDIF

$(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.pdf : DevelopersGuide.pdf
	+-$(MKDIRHIER) $(@:d)    
	$(GNUCOPY) -p DevelopersGuide.pdf $(DESTDIRDOCU)$/DevelopersGuide
    
$(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.htm : DevelopersGuide.zip
	+-$(MKDIRHIER) $(@:d)    
	unzip -quod $(DESTDIRDOCU) DevelopersGuide.zip

$(CONVERTTAGFLAG) : $(MISC)$/deltree.txt
    +$(PERL) $(CONVERTTAGSCRIPT) 1 $(TITLE) $(OFFICEPRODUCTNAME) $(DOCUHTMLFILES)
    @echo "tags converted" > $@
    
$(IDL_DOCU_INDEX_FILE) : $(IDL_CHAPTER_REFS) $(IDLFILES)
	+-$(MKDIRHIER) $(@:d)        
	+$(MY_AUTODOC) -html $(DESTDIRGENIDLREF) -dvgroot ../../DevelopersGuide -name $(IDLDOCREFNAME) -lg \
	idl -dvgfile $(IDL_CHAPTER_REFS) -t $(DESTDIRIDL)    
