/*************************************************************************
 *
 *  $RCSfile: environ.hxx,v $
 *
 *  $Revision: 1.31 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 15:45:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SETUP_ENVIRON_HXX
#define _SETUP_ENVIRON_HXX

#define			AEGYPTEN								1
#define			ALBANIEN                                2
#define			ALGERIEN                                3
#define			ANDORRA                                 4
#define			ANTIGUA_UND_BARBUDA                     5
#define			ARGENTINIEN                             6
#define			ARMENIEN                                7
#define			AUSTRALIEN                              8
#define			BAHAMAS                                 9
#define			BARBADOS                                10
#define			BELGIEN                                 11
#define			BERMUDA                                 12
#define			BOLIVIEN                                13
#define			BOSNIENHERZEGOWINA                      14
#define			BRASILIEN                               15
#define			BULGARIEN                               16
#define			BUNDESREPUBLIK_DEUTSCHLAND              17
#define			CHILE                                   18
#define			CHINA                                   19
#define			COSTA_RICA                              20
#define			DOMINIKANISCHE_REPUBLIK                 21
#define			DAENEMARK                               22
#define			ECUADOR                                 23
#define			EL_SALVADOR                             24
#define			ELFENBEINKUESTE                         25
#define			ESTLAND                                 26
#define			FINNLAND                                27
#define			FRANKREICH                              28
#define			FAEROEER                                29
#define			FUERSTENTUM_LIECHTENSTEIN               30
#define			GEMEINSCHAFT_UNABHAENGIGER_STAATEN      31
#define			GEORGIEN                                32
#define			GRENADA                                 33
#define			GRIECHENLAND                            34
#define			GROSSBRITANNIEN                         35
#define			GUADELOUPE                              36
#define			GUATEMALA                               37
#define			GUYANA                                  38
#define			HAITI                                   39
#define			HONDURAS                                40
#define			HONGKONG                                41
#define			INDIEN                                  42
#define			INDONESIEN                              43
#define			IRAN                                    44
#define			IRLAND                                  45
#define			ISLAND                                  46
#define			ISRAEL                                  47
#define			ITALIEN                                 48
#define			JAMAIKA_BRITISCHE_ANTILLEN              49
#define			JAPAN                                   50
#define			JORDANIEN                               51
#define			JUGOSLAVIEN                             52
#define			KAIMANINSELN                            53
#define			KAMERUN                                 54
#define			KANADA                                  55
#define			KOLUMBIEN                               56
#define			KROATIEN                                57
#define			KUBA                                    58
#define			KUWAIT                                  59
#define			LIBANON                                 60
#define			LITAUEN                                 61
#define			LUXEMBURG                               62
#define			MALAYSIA                                63
#define			MALTA                                   64
#define			MAROKKO                                 65
#define			MAURITIUS                               66
#define			MAZEDONIEN                              67
#define			MEXIKO                                  68
#define			MONACO                                  69
#define			NAMIBIA                                 70
#define			NEPAL                                   71
#define			NEUSEELAND                              72
#define			NICARAGUA                               73
#define			NIEDERLANDE                             74
#define			NIEDERLAENDISCHE_ANTILLEN_CURACAO       75
#define			NIGERIA                                 76
#define			NORWEGEN                                77
#define			OESTERREICH                             78
#define			PAKISTAN                                79
#define			PANAMA                                  80
#define			PAPUANEUGUINEA                          81
#define			PARAGUAY                                82
#define			PERU                                    83
#define			PHILIPPINEN                             84
#define			POLEN                                   85
#define			PORTUGAL                                86
#define			PUERTO_RICO                             87
#define			REPUBLIK_KASACHSTAN                     88
#define			REPUBLIK_LETTLAND                       89
#define			REPUBLIK_MOLDAWIEN                      90
#define			REPUBLIK_SUEDAFRIKA                     91
#define			REPUBLIK_USBEKISTAN                     92
#define			REPUBLIK_WEISSRUSSLAND                  93
#define			REPUBLIK_ZENTRALAFRIKA                  94
#define			RUMAENIEN                               95
#define			RUSSISCHE_FOEDERATION                   96
#define			SAUDI_ARABIEN                           97
#define			SCHWEDEN                                98
#define			SCHWEIZ                                 99
#define			SINGAPUR                                100
#define			SLOWAKEI                                101
#define			SLOWENIEN                               102
#define			SPANIEN                                 103
#define			SRI_LANKA                               104
#define			SWASILAND                               105
#define			SUED_KOREA_REPUBLIK                     106
#define			TADSCHIKISTAN                           107
#define			TAIWAN_REPUBLIK_CHINA                   108
#define			THAILAND                                109
#define			TRINIDAD_UND_TOBAGO                     110
#define			TSCHECHIEN                              111
#define			TUNESIEN                                112
#define			TURKMENISTAN                            113
#define			TUERKEI                                 114
#define			UKRAINE                                 115
#define			UNGARN                                  116
#define			URUGUAY                                 117
#define			VENEZUELA                               118
#define			VEREINIGTE_ARABISCHE_EMIRATE            119
#define			VEREINIGTE_STAATEN_VON_AMERIKA          120
#define			VIETNAM                                 121
#define			ZYPERN                                  122

#ifndef _LANG_CODES_ONLY

#ifdef UNX
#include <sys/types.h>
#include <pwd.h>
#endif

#ifndef _LIST_HXX //autog
#include <tools/list.hxx>
#endif
#ifndef _LANG_HXX
#include <tools/lang.hxx>
#endif

#ifndef _COM_SUN_STAR_SETUP_OSTYPE_HPP_
#include <com/sun/star/setup/OSType.hpp>
#endif

#include "arch.hxx"
#include "simode.hxx"

using namespace com::sun::star::setup;

class SiEnvironment;
class SiModuleSet;

#define KH_PATCH_DETECTOR	"insaddn"


extern ULONG _Substitute(const ByteString& rFilename, const SiEnvironment& rEnv, SiInstallMode eMode);

struct LanguageContext
{
	USHORT			nLanguage;
	BOOL			isProg;
	BOOL			isDoc;
};

struct InitiateWorkstation
{
	ByteString		aDirectory;
	USHORT			nLanguage;
};

#define OSL_GETTHREADTEXTENCODING 1
#define LANGCODE2TEXTENCODING     2

#define ENCODING_DEFAULT LANGCODE2TEXTENCODING
struct ReplacementEntry
{
	ByteString		aTag;
	ByteString		aValue;
	sal_Int16       nEncoding;

	ReplacementEntry()
			:nEncoding(ENCODING_DEFAULT){}
};

DECLARE_LIST(SiReplacementList, ReplacementEntry*)
DECLARE_LIST(SiFollowAppList, ByteString*)
DECLARE_LIST(SiModuleSetList, SiModuleSet*)
DECLARE_LIST(SiLangCtxList, LanguageContext*)
DECLARE_LIST(SiInitiateWksList, InitiateWorkstation*)

class SiEnvironment
{
    // environment
	BOOL 				m_bParamDestPath;
	BOOL    			m_bBigMode;
	ArchDirectory*		pArchive;

	OSType				m_eWebOsType;

	ByteString   		m_aSuiteName;
	ByteString   		m_aProductName;
	ByteString   		m_aSingleProductName;
	ByteString   		m_aProductVersion;
	ByteString   		m_aInternalVersion;
	ByteString   		m_aVendorName;
	ByteString   		m_aVendorVersion;

	ByteString   		m_aProductKey;

	BOOL 				m_bInUpdate;
	BOOL 				m_bUpdateNoVersion;
	BOOL 				m_bUpdateOldVersion;
	BOOL 				m_bUpgradeOldVersion;
	BOOL 				m_bUpdateOldVersionNoRights;
	BOOL 				m_bUpdateOldVersionWrongLanguage;

	BOOL 				m_bReboot;
	BOOL 				m_bLogout;
	BOOL 				m_bDefuseRestart;
	BOOL 				m_bPropagateWinEnvChange;

	BOOL 				m_bMigrationAvailalbe;
	BOOL 				m_bDoMigration;
	ByteString   		m_aMigrationPath;
	ULONG 				m_nMigrationSize;

	SiInstallType 		m_eInstallType;
    SiInstallMode       m_eInstallMode;
	BOOL				m_bIsLocal;
	BOOL				m_bInstallFromNet;

	BOOL 				m_bVerboseMode;
	BOOL				m_bIsResponse;
	BOOL				m_bIsResponseWizard;
	BOOL    			m_bFirstInstallation;
	BOOL 				m_bInstallOnRoot;
	BOOL 				m_bAutoRepair;

	USHORT 				m_nResponseStep;
	ByteString			m_aResponseFilename;

	ByteString  		m_aStartPath;
	ByteString  		m_aSourcePath;
	ByteString  		m_aDestPath;
	ByteString  		m_aOuterDestPath;

	ByteString  		m_anInstalledPath;

	rtl::OUString   	m_aUserName;
	rtl::OUString   	m_aUserFirstName;
	rtl::OUString   	m_aUserFatherName;
	rtl::OUString   	m_aUserId;
	rtl::OUString		m_aUserEmail;
	rtl::OUString		m_aStreet;
	rtl::OUString		m_aApartment;
	rtl::OUString		m_aZip;
	rtl::OUString		m_aCity;
	rtl::OUString		m_aTitle;
	rtl::OUString		m_aPosition;
	rtl::OUString		m_aFax;
	rtl::OUString		m_aTelefonWork;
	rtl::OUString		m_aTelefonHome;
	rtl::OUString		m_aState;
	rtl::OUString		m_aCompanyName;
	rtl::OUString		m_aCustomerNr;

	rtl::OUString		m_aCountry;
	USHORT 				m_nCountry;

	ByteString			m_aHumanLicenseKey;
	ByteString			m_aLicenseKey;

	ByteString   		m_aServerName;
	ByteString   		m_aPrintServerName;

	// runtime
	SiModuleSet*		m_pActiveModuleSet;
	SiModuleSetList		m_aModSetList;
	SiFollowAppList		m_aFollowAppList;
	SiReplacementList	m_aReplacementList;

	SiInitiateWksList	m_aWorkstationList;

	// Languages
	USHORT				m_nUILanguage;
	USHORT 				m_nDefLanguage;
    LanguageType        m_nLangType;
	SiLangCtxList		m_aLangContext;
	SiLangCtxList		m_aUILangContext;
	SiLangCtxList		m_aSwitchCtxInstall;
	SiLangCtxList		m_aSwitchCtxDelete;

	BOOL 				m_bHasKHPatched				: 1;
	BOOL 				m_bNoBasicError				: 1;
	BOOL 				m_bDoOnlineReg				: 1;
	BOOL 				m_bVirtualMode				: 1;
	BOOL 				m_bTimeCheck				: 1;
	BOOL 				m_bNoRegistration 			: 1;
	BOOL 				m_bDlgPrecreateDir 			: 1;
	BOOL 				m_bForceReinstall 			: 1;    // 8
	BOOL 				m_bForceDeinstall 			: 1;

	BOOL 				m_bHackFlag_1				: 1;	// fuer SUPD == 506 Filterupdate vergeben!
	BOOL 				m_bHackFlag_2				: 1;	// fuer SUPD == 506 Filterupdate vergeben!
	BOOL 				m_bHackFlag_3				: 1;
	BOOL 				m_bHackFlag_4				: 1;
	BOOL 				m_bHackFlag_5				: 1;

	BOOL 				m_bAuseStreamFlush			: 1;
	BOOL 				m_bUNOEvil					: 1;    // 16
    BOOL                m_bHasVCL                   : 1;
    BOOL                m_bForceRepair              : 1;
    BOOL                m_bInstallForAll            : 1;

	BOOL                m_bATToolSupport            : 1;
	BOOL                m_bIsUpdateOnly             : 1;
    BOOL                m_bCantUpdateNetInst        : 1;
    BOOL                m_bCantUpdateStdInst        : 1;
    BOOL                m_bCantUpdateWrkInst        : 1;    // 24
    BOOL                m_bCantUpdateThatVers       : 1;
    BOOL 				m_bIsAutoWorkstation        : 1;
    BOOL 				m_bUIDoNiceLangDefault      : 1;


	ByteString Setup_ConvertForRegistry( rtl::OUString const& _rSource );
	rtl::OUString Setup_ConvertFromRegistry(ByteString const& _rSource);

public:
    enum UpdateError
    {
        NO_ERR                      = 0,
        CANT_UPDATE_THAT_VERSION,
        CANT_UPDATE_NET_INSTALL,
        CANT_UPDATE_STD_INSTALL_NET,
        CANT_UPDATE_STD_INSTALL_WRK,
        CANT_UPDATE_WRK_INSTALL,
        CANT_UPDATE_WRONG_LANG,
        CANT_UPDATE_NO_RIGHTS,
        ONLY_UPDATE_ALLOWED,
        UPDATE_NO_VERSION
    };

		SiEnvironment();
		~SiEnvironment();

	void				ClearEnvironment();
	void				InitReplacement(SiInstallMode eIMode);
    void                UpdateReplacement( const ByteString& rKey,
                                           const ByteString& rValue,
                                           sal_Int16 nEncoding = ENCODING_DEFAULT );
	void 				StoreRecycle();
	void 				InitRecycle();

	BOOL				IsParamDestPath() const					{ return m_bParamDestPath; }
	void				SetParamDestPath(BOOL b = TRUE)			{ m_bParamDestPath = b; }

	BOOL				IsBigMode() const						{ return m_bBigMode; }
	void				SetBigMode(BOOL b = TRUE)				{ m_bBigMode = b; }

	void				SetArchive(ArchDirectory* pNew, FncFindArch fncFindArch);
	ArchDirectory*		GetArchive() const						{ return pArchive; }

	void				SetWebOSType(OSType eNew)				{ m_eWebOsType = eNew; }
	OSType				GetWebOSType() const 					{ return m_eWebOsType; }

	ByteString   		GetSuiteName() const					{ return m_aSuiteName; }
	void  				SetSuiteName(ByteString const& s)	 	{ m_aSuiteName = s; }

	ByteString   		GetProductName() const					{ return m_aProductName; }
//	void  				SetProductName(ByteString const& s)	 	{ m_aProductName = s; }
	void  				SetProductName( const ByteString& rName,
                                        const ByteString& rVersion );

	ByteString   		GetSingleProductName() const		  	{ return m_aSingleProductName; }
	void  				SetSingleProductName(ByteString const& s) { m_aSingleProductName = s; }

	ByteString   		GetProductVersion() const		  		{ return m_aProductVersion; }
	void  				SetProductVersion(ByteString const& s)	{ m_aProductVersion = s; }

	ByteString   		GetInternalVersion() const		  		{ return m_aInternalVersion; }
	void  				SetInternalVersion(ByteString const& s)	{ m_aInternalVersion = s; }

	ByteString   		GetVendorName() const					{ return m_aVendorName; }
	void  				SetVendorName(ByteString const& s)	 	{ m_aVendorName = s; }

	ByteString   		GetVendorVersion() const		  		{ return m_aVendorVersion; }
	void  				SetVendorVersion(ByteString const& s)	{ m_aVendorVersion = s; }

	ByteString   		GetProductKey() const					{ return m_aProductKey; }
	void  				SetProductKey(ByteString const& s)	 	{ m_aProductKey = s; }

	BOOL				IsUpgradeOldVersion() const				{ return m_bUpgradeOldVersion; }
	void				SetUpgradeOldVersion(BOOL b = TRUE)		{ m_bUpgradeOldVersion = b; }

	BOOL				IsInUpdate() const		 				{ return m_bInUpdate; }
	void				SetInUpdate(BOOL b = TRUE)		 		{ m_bInUpdate = b; }

	BOOL				IsUpdateNoVersion() const				{ return m_bUpdateNoVersion; }
	void				SetUpdateNoVersion(BOOL b = TRUE)		{ m_bUpdateNoVersion = b; }

	BOOL				IsUpdateOldVersion() const				{ return m_bUpdateOldVersion; }
	void				SetUpdateOldVersion(BOOL b = TRUE)		{ m_bUpdateOldVersion = b; }

	BOOL				IsUpdateOldVersionNoRights() const		{ return m_bUpdateOldVersionNoRights; }
	void				SetUpdateOldVersionNoRights(BOOL b = TRUE) { m_bUpdateOldVersionNoRights = b; }

	BOOL				IsUpdateOldVersionWrongLanguage() const	{ return m_bUpdateOldVersionWrongLanguage; }
	void				SetUpdateOldVersionWrongLanguage(BOOL b = TRUE) { m_bUpdateOldVersionWrongLanguage = b; }

    BOOL                IsUpdateOnly() const                    { return m_bIsUpdateOnly; }
    void                SetUpdateOnly( BOOL b = TRUE )          { m_bIsUpdateOnly = b; }

    void 				SetUINiceLangDefault( BOOL bNew )		{ m_bUIDoNiceLangDefault = bNew; }
	BOOL 				IsUINiceLangDefault() const 			{ return m_bUIDoNiceLangDefault; }

	void 				SetAutoRepair( BOOL bNew )				{ m_bAutoRepair = bNew; }
	BOOL 				IsAutoRepair() const 		   			{ return m_bAutoRepair; }

	////////////////////////////////////////////////////////////
	// reboot, logout, defuse mode
	BOOL				IsReboot() const						{ return m_bReboot; }
	void				SetReboot(BOOL b = TRUE) 				{ m_bReboot = b; }
	BOOL				IsLogout() const						{ return m_bLogout; }
	void				SetLogout(BOOL b = TRUE) 				{ m_bLogout = b; }
	BOOL				IsDefuseRestart() const					{ return m_bDefuseRestart; }
	void				SetDefuseRestart(BOOL b = TRUE) 		{ m_bDefuseRestart = b; }
	BOOL				IsPropagateWinEnvChange() const			{ return m_bPropagateWinEnvChange; }
	void				SetPropagateWinEnvChange(BOOL b = TRUE) { m_bPropagateWinEnvChange = b; }

	////////////////////////////////////////////////////////////
	// migration
	BOOL				IsMigrationAvailable() const			{ return m_bMigrationAvailalbe; }
	void				SetMigrationAvailable(BOOL bNew)		{ m_bMigrationAvailalbe = bNew; }
	BOOL				DoMigration() const						{ return m_bDoMigration; }
	void				SetMigration(BOOL bNew)					{ m_bDoMigration = bNew; }
	ByteString   		GetMigrationPath() const				{ return m_aMigrationPath; }
	void  				SetMigrationPath(ByteString const& s)	{ m_aMigrationPath = s; }
	ULONG				GetMigrationSize() const				{ return m_nMigrationSize; }
	void  				SetMigrationSize(ULONG n)				{ m_nMigrationSize = n; }

	SiInstallType 		GetInstallType() const					{ return m_eInstallType; }
	void				SetInstallType(SiInstallType eType)		{ m_eInstallType = eType; }

    SiInstallMode 		GetInstallMode() const					{ return m_eInstallMode; }
	void				SetInstallMode(SiInstallMode eMode)		{ m_eInstallMode = eMode; }

	BOOL				IsLocal() const							{ return m_bIsLocal; }
	void 				SetLocal(BOOL bNew = TRUE)				{ m_bIsLocal = bNew; }

	BOOL				InstallFromNet() const					{ return m_bInstallFromNet; }
	void 				SetInstallFromNet(BOOL bNew = TRUE)	 	{ m_bInstallFromNet = bNew; }

	BOOL				IsResponsefileMode() const	 			{ return m_bIsResponse; }
	void 				SetResponsefileMode(BOOL bNew = TRUE)	{ m_bIsResponse = bNew; }

	BOOL				IsResponsefileWizardMode() const	 	{ return m_bIsResponseWizard; }
	void 				SetResponsefileWizardMode(BOOL bNew = TRUE)	{ m_bIsResponseWizard = bNew; }

	BOOL				IsVerboseMode() const	 		  		{ return m_bVerboseMode; }
	void 				SetVerboseMode(BOOL bNew = TRUE)   		{ m_bVerboseMode = bNew; }

	BOOL				IsVirtualMode() const	 		  		{ return m_bVirtualMode; }
	void 				SetVirtualMode(BOOL bNew = TRUE)   		{ m_bVirtualMode = bNew; }

	BOOL				IsTimeCheck() const	 		  			{ return m_bTimeCheck; }
	void 				SetTimeCheck(BOOL bNew = TRUE)   		{ m_bTimeCheck = bNew; }

	BOOL				IsNoRegistration() const	   			{ return m_bNoRegistration; }
	void 				SetNoRegistration(BOOL bNew = TRUE) 	{ m_bNoRegistration = bNew; }

	BOOL				IsDlgPrecreateDir() const	   			{ return m_bDlgPrecreateDir; }
	void 				SetDlgPrecreateDir(BOOL bNew = TRUE) 	{ m_bDlgPrecreateDir = bNew; }

	BOOL				IsForceReinstall() const	   			{ return m_bForceReinstall; }
	void 				SetForceReinstall(BOOL bNew = TRUE) 	{ m_bForceReinstall = bNew; }

	BOOL				IsForceDeinstall() const	   			{ return m_bForceDeinstall; }
	void 				SetForceDeinstall(BOOL bNew = TRUE) 	{ m_bForceDeinstall = bNew; }

	ByteString   		GetResponseFilename() const				{ return m_aResponseFilename; }
	void  				SetResponseFilename(ByteString const& s){ m_aResponseFilename = s; }

	USHORT 				GetResponseStep()			 			{ return m_nResponseStep; }
	void 				SetResponseStep( USHORT n ) 			{ m_nResponseStep = n; }

	BOOL				IsFirstInstallation() const				{ return m_bFirstInstallation; }
	void				SetFirstInstallation(BOOL b = TRUE)		{ m_bFirstInstallation  =  b; }

	ByteString   		GetSourcePath() const					{ return m_aSourcePath; }
	void  				SetSourcePath(ByteString const& s)	 	{ m_aSourcePath = s; }

	ByteString   		GetDestPath() const						{ return m_aDestPath; }
	void  				SetDestPath(ByteString const& s)		{ m_aDestPath = s; }

	ByteString   		GetOuterDestPath() const				{ return m_aOuterDestPath; }
	void  				SetOuterDestPath(ByteString const& s)	{ m_aOuterDestPath = s; }

	BOOL				IsInstallOnRoot() const					{ return m_bInstallOnRoot; }
	void				SetInstallOnRoot(BOOL b = TRUE)	   		{ m_bInstallOnRoot  =  b; }

	ByteString   		GetInstalledPath() const				{ return m_anInstalledPath; }
	void  				SetInstalledPath(ByteString const& s)	{ m_anInstalledPath = s; }

	ByteString   		GetStartPath() const					{ return m_aStartPath; }
	void				SetStartPath(ByteString const& s)  		{ m_aStartPath = s; }
	void				InitStartPath();

	ByteString   		GetWorkPath(SiInstallMode) const;
	ByteString   		GetProgPath(SiInstallMode) const;

    void                SetUpdateError( const SiInstallMode eSrcInstMode,
                                        const SiInstallMode eDstInstMode );
    void                SetUpdateError( const UpdateError eError );
    UpdateError         GetUpdateError() const;

	// User Information
	rtl::OUString   	GetUserName() const						    { return m_aUserName; }
	void  				SetUserName(rtl::OUString const& s)         { m_aUserName = s; }

	rtl::OUString   	GetUserFirstName() const				    { return m_aUserFirstName; }
	void  				SetUserFirstName(rtl::OUString const& s)  	{ m_aUserFirstName = s; }

	rtl::OUString   	GetUserFatherName() const				    { return m_aUserFatherName; }
	void  				SetUserFatherName(rtl::OUString const& s)   { m_aUserFatherName = s; }

	rtl::OUString   	GetUserId() const						    { return m_aUserId; }
	void  				SetUserId(rtl::OUString const& s)		 	{ m_aUserId = s; }

	void				SetUserEMail( rtl::OUString const& s )		{ m_aUserEmail = s; }
	rtl::OUString		GetUserEMail() const 					    { return m_aUserEmail; }

	void				SetCompanyName( rtl::OUString const& s )  	{ m_aCompanyName = s; }
	rtl::OUString		GetCompanyName() const 					    { return m_aCompanyName; }

	void				SetStreet( rtl::OUString const& s )	   		{ m_aStreet = s; }
	rtl::OUString		GetStreet() const 						    { return m_aStreet; }

	void				SetApartment( rtl::OUString const& s )	   	{ m_aApartment = s; }
	rtl::OUString		GetApartment() const 					    { return m_aApartment; }

	void				SetZip( rtl::OUString const& s )	  	  	{ m_aZip = s; }
	rtl::OUString		GetZip() const 				  			    { return m_aZip; }

	void				SetCity( rtl::OUString const& s )	 		{ m_aCity = s; }
	rtl::OUString		GetCity() const 				 		    { return m_aCity; }

	void				SetTitle( rtl::OUString const& s )	 		{ m_aTitle = s; }
	rtl::OUString		GetTitle() const 				 		    { return m_aTitle; }

	void				SetPosition( rtl::OUString const& s ) 		{ m_aPosition = s; }
	rtl::OUString		GetPosition() const 			   		    { return m_aPosition; }

	void				SetFax( rtl::OUString const& s )  			{ m_aFax = s; }
	rtl::OUString		GetFax() const 			   	   			    { return m_aFax; }

	void				SetTelefonWork( rtl::OUString const& s )  	{ m_aTelefonWork = s; }
	rtl::OUString		GetTelefonWork() const 			   	   	    { return m_aTelefonWork; }

	void				SetTelefonHome( rtl::OUString const& s )  	{ m_aTelefonHome = s; }
	rtl::OUString		GetTelefonHome() const 			   	   	    { return m_aTelefonHome; }

	void				SetState( rtl::OUString const& s )  		{ m_aState = s; }
	rtl::OUString		GetState() const 			   	   		    { return m_aState; }

	void				SetCustomerNr( rtl::OUString const& s )	    { m_aCustomerNr = s; }
	rtl::OUString		GetCustomerNr() const 				 	    { return m_aCustomerNr; }

	void				SetCountry(rtl::OUString const& rNew) 		{ m_aCountry = rNew; }
	rtl::OUString		GetCountry() const 				 		    { return m_aCountry; }

	void				SetCountryIdx( USHORT nNew )	 		{ m_nCountry = nNew; }
	USHORT			   	GetCountryIdx() const 				 	{ return m_nCountry; }

	void				SetHumanLicenseKey( ByteString const& s ){ m_aHumanLicenseKey = s; }
	ByteString		   	GetHumanLicenseKey() const 				{ return m_aHumanLicenseKey; }

	void				SetLicenseKey( ByteString const& s )	{ m_aLicenseKey = s; }
	ByteString		   	GetLicenseKey() const 					{ return m_aLicenseKey; }

	// runtime
	SiModuleSet*	  	GetActiveModuleSet()					{ return m_pActiveModuleSet; }
	void				SetActiveModuleSet(SiModuleSet* p)		{ m_pActiveModuleSet = p; }

	SiModuleSetList&  	GetModuleSetList()						{ return m_aModSetList; }
	void				AddModuleSet(SiModuleSet* pToAdd)		{ m_aModSetList.Insert(pToAdd,LIST_APPEND); }

	SiFollowAppList&  	GetFollowAppList()						{ return m_aFollowAppList; }
	void				AddFollowAppList(ByteString* pToAdd)	{ m_aFollowAppList.Insert(pToAdd,LIST_APPEND); }

	SiInitiateWksList&  GetWorkstationList()	 				{ return m_aWorkstationList; }
	void				AddWorkstationList(InitiateWorkstation* pToAdd) { m_aWorkstationList.Insert(pToAdd,LIST_APPEND); }

	const SiReplacementList& GetReplacementList() const         { return m_aReplacementList; }
	void				AddReplacementList(ReplacementEntry* pToAdd) { m_aReplacementList.Insert(pToAdd,LIST_APPEND); }
	void				AddReplacement(const ByteString& rTag, const ByteString& rValue, sal_Int16 _nEncoding = ENCODING_DEFAULT);

	BOOL				IsAutoWorkstation() const				{ return m_bIsAutoWorkstation; }
	void 				SetAutoWorkstation(BOOL bNew = TRUE)	{ m_bIsAutoWorkstation = bNew; }

	// Languages
	void				SetUILanguage( USHORT nNew );
	USHORT			   	GetUILanguage() const 				 	{ return m_nUILanguage; }
    LanguageType        GetUILanguageType() const               { return m_nLangType; }

	void				SetDefLanguage( USHORT nNew )	 		{ m_nDefLanguage = nNew; }
	USHORT			   	GetDefLanguage() const 				 	{ return m_nDefLanguage; }

	SiLangCtxList&	  	GetLanguageContext()					{ return m_aLangContext; }
	void				AddLanguageContext(LanguageContext* pToAdd) { m_aLangContext.Insert(pToAdd,LIST_APPEND); }
	SiLangCtxList&		GetUILanguageContext()	   				{ return m_aUILangContext; }
	void				AddUILanguageContext(LanguageContext* pToAdd) { m_aUILangContext.Insert(pToAdd,LIST_APPEND); }

	SiLangCtxList&		GetSwitchContextInstall()	   			{ return m_aSwitchCtxInstall; }
	void				AddSwitchContextInstall(LanguageContext* pToAdd);
	SiLangCtxList&		GetSwitchContextDelete()	   			{ return m_aSwitchCtxDelete; }
	void				AddSwitchContextDelete(LanguageContext* pToAdd);

	BOOL				HasKHPatched() const	   				{ return m_bHasKHPatched; }

	BOOL				NoBasicError() const		  			{ return m_bNoBasicError; }
	void				SetNoBasicError(BOOL b = TRUE)	 		{ m_bNoBasicError = b; }

	BOOL				DoOnlineReg() const		  				{ return m_bDoOnlineReg; }
	void				SetOnlineReg(BOOL b = TRUE)	 		 	{ m_bDoOnlineReg = b; }

	BOOL				IsHackFlag(USHORT nFlag) const;
	void				SetHackFlag(USHORT nFlag);
	void				ClearHackFlag(USHORT nFlag);

	////////////////////////////////////////////////////////////
	// SPECIALS
	BOOL				IsAUSEStreamFlush() const		   		{ return m_bAuseStreamFlush; }
	void				SetAUSEStreamFlush(BOOL b = TRUE)  		{ m_bAuseStreamFlush = b; }

	BOOL				IsUNOEvil() const				   		{ return m_bUNOEvil; }
	void				SetUNOEvil(BOOL b = TRUE)  	   			{ m_bUNOEvil = b; }
	BOOL				HasVCL() const                          { return m_bHasVCL; }
	void				SetHasVCL(BOOL b = TRUE)  	   			{ m_bHasVCL = b; }
    BOOL                IsForceRepair() const                   { return m_bForceRepair; }
    void                SetForceRepair( BOOL b = TRUE )         { m_bForceRepair = b; }
    BOOL                InstallForAllUser() const               { return m_bInstallForAll; }
    void                SetInstallForAllUser( BOOL b = TRUE )   { m_bInstallForAll = b; }
    ByteString          GetDefaultDestPath( BOOL bWorkStation,
                                            const ByteString& rDefault ) const;

	////////////////////////////////////////////////////////////
	// ACCESSIBILITY
	ByteString          GetATToolSupport() const { return m_bATToolSupport ? ByteString("TRUE") : ByteString("FALSE");}
	void                SetATToolSupport(BOOL b) { m_bATToolSupport = b;}
};

inline ByteString SiEnvironment::GetWorkPath(SiInstallMode eInstallMode) const
{
	return m_aDestPath;
}

inline ByteString SiEnvironment::GetProgPath(SiInstallMode eInstallMode) const
{
	return eInstallMode == IM_WORKSTATION ? m_aSourcePath : m_aDestPath;
}

#endif                                  // _LANG_CODES_ONLY
#endif									// _SETUP_ENVIRON_HXX
