/*************************************************************************
 *
 *  $RCSfile: main.hxx,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 - 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SETUP_MAIN_HXX
#define _SETUP_MAIN_HXX

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_APP_HXX_
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif

#ifdef MAC
#include <vcl/menu.hxx>
#endif

#ifndef _SVEDIT_HXX
#include <svtools/svmedit.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <vos/thread.hxx>

#include "simode.hxx"
#include "event.hxx"

class ResMgr;
class ModelessDialog;
class Button;

class SiModule;
class SiDoneList;
class SiEnvironment;
class SiCompiledScript;
class SiProfileItem;
class SiAgenda;
class SetupWindow;
class SetupAgentDialog;
class ResponseFile;
class ThreadExecuter;
class ExecuterData;

struct InitiateWorkstation;
struct SetupEventData;

extern "C" {
extern const char* FindArch(const char* pDefSource, const char* pDefName );
};

struct TopLevelObject;
DECLARE_LIST(TopLevelStack,TopLevelObject*)

using namespace ::vos;

DECLARE_LIST( EvilList, char* );
class Evil : public OThread
{
	EvilList aList;
public:
	Evil();
	~Evil();
	virtual void SAL_CALL run();
};

enum SetupParameter
{
    PAR_IGNORE      = 0,
    PAR_CRC_CHECK,
    PAR_NET_INSTALL,
    PAR_VIRTUAL,
    PAR_VERBOSE,
    PAR_DEBUG,
    PAR_NOEXIT,
    PAR_RESPONSEFILEAUTOPILOT,
    PAR_RSP1,
    PAR_RSP2,
    PAR_MSET,
    PAR_RESPONSEFILE,
    PAR_SDUMP,
    PAR_OFFICEMODE,
    PAR_REPAIR,
    PAR_REINSTALL,
    PAR_DEINSTALL,
    PAR_NOREG,
    PAR_AUSE,
    PAR_EVIL,
    PAR_UNOEVIL,
    PAR_DESTINATION_PATH,
    PAR_FOLLOW_APP,
    PAR_DONT_DELETE_TEMP,
    PAR_PATCH,
    PAR_UPDATE,
    PAR_NOGUI,
    PAR_SHOW_USAGE,
    PAR_SHOW_HELP,
    PAR_LANGUAGE,
    PAR_UNKNOWN
};

class ShowUsageDlg : public ModalDialog
{
public:
    OKButton        aButton;
    FixedText       aTitle;
    MultiLineEdit   aMessage;

                    ShowUsageDlg( Window *pParent, ResMgr* pResMgr );
    void            SetText( const String& rText ) { aMessage.SetText( rText ); }
};

class SetupApp : public Application
{
private:

	class OReadScriptModeGuard
	{
		bool &m_bReadScriptMode;
	public:
		OReadScriptModeGuard(bool &_bReadScriptMode)
				:m_bReadScriptMode(_bReadScriptMode)
			{
				m_bReadScriptMode = true;
			}
		~OReadScriptModeGuard() {m_bReadScriptMode = false;}
	};

	Evil*				m_pEvil1;
	Evil*				m_pEvil2;
	Evil*				m_pEvil3;
	Evil*				m_pEvil4;
	Evil*				m_pEvil5;
	Evil*				m_pEvil6;
	Evil*				m_pEvil7;

	Accelerator*		m_pExitAccel;
	ResMgr*				m_pResMan;
	ResMgr*             m_pSecondResMgr;

	SetupWindow*		m_pMainWin;
	SetupAgentDialog*	m_pMainDlg;
	bool                m_bReadScriptMode;

	SiEnvironment*		m_pEnv;
	SiCompiledScript*	m_pCompiledScript;
	SiCompiledScript*	m_pOldCompiledScript;
	SiAgenda*			m_pAgenda;
	ResponseFile*		m_pResponseFile;

	BOOL				m_bPerformInstall		: 1;
	BOOL				m_bInterrupt			: 1;
	BOOL				m_bParamDoCRCCheck		: 1;
	BOOL 				m_bOfficeMode			: 1;
	BOOL 				m_bIsAppServerInstall	: 1;
	BOOL 				m_bResponseWizard		: 1;
	#if defined WIN || defined WNT
	BOOL				m_bShare				: 1;
	#endif
	BOOL 				m_bNoVcl                : 1;
    BOOL                m_bParamDisableGUI      : 1;
    BOOL                m_bParamLanguage        : 1;

	ThreadExecuter*		m_pExecuter;
	ByteString			m_aOldLicense;

	ByteString			m_aParamDestPath;
    ByteString          m_aUpdateDestPath;
	ByteString			m_aParamFollowApp;
	ByteString			m_SetupIniSourcePath;
	int				  	m_nLanguage;
	USHORT 				m_nWorkStationCnt;
	USHORT 				m_nWorkStationIdx;

    ::osl::Mutex        m_aMutex;
    SetupEventData*     m_pFirstEvent;

	String              m_aProductPatchName;
	// application
	void			SetAccelerators();
	BOOL			LoadResources();

    BOOL            GetAdditionalParam( int &i, ByteString& rExtendedParam );
    SetupParameter  GetParameter( const ByteString& rParameter );
    void            ReadParams( UniString &rParamError, SetupParameter &rCommand );
    void            ShowUsage( SetupParameter eCommand );
    void            CheckLanguage();
    BOOL            GetValue( const ByteString& rLine, const ByteString& rKey,
                              ByteString& rValue );
    void            SimpleFindAndReadScript();
    ByteString      SplitParameter( const ByteString& rData,
                                    ByteString& rParam );

	// event
	void			OnEventStart();
	void			OnEventEnd();
	void			OnEventEndInstallation();
	void 			GetMainDialogModel();

	void 			RunUpdateOldVersion();
	void			RunInstallation( SiCompiledScript*, SiInstallMode, SiInstallSubMode = ISM_INVALID,
									 BOOL bUpgrade = FALSE, BOOL bNoEvents = FALSE );
	void			InstallWorkstation( InitiateWorkstation* pWorkStation );
	void 			WriteWorkstationDB( ExecuterData* pData );
	void			PrepareLanguageContext();
	void 			CloseInstallation( ExecuterData *pData = NULL );

	BOOL 			ProcessFollowApps( BOOL bTestOnly = FALSE );

	// script
	BOOL			ReadScript(SiDirEntry const&);
	BOOL			ReadScript(SiDirEntry const&, SiCompiledScript*);
	BOOL			FindAndReadScript();
	ByteString  	GetValue(SiProfileItem const*, ByteString const& aDefault) const;
	void 			ShowScriptNotFound();
    ByteString      GetUpdateDestURL() const;

	// responsefile wizard
	BOOL			CallResponsePlugins(SiModule* pMod, SiDoneList& rDoneList);
	BOOL			FinishResponseFileWizard();

	// service
	BOOL			AreAllAppsClosed(Window* pParent, USHORT nId);
	void			KillSlideshowFiles(SiCompiledScript*);
	BOOL 			QueryKillEntireDir(ByteString const&);
	void 			KillEntireDir(ByteString const&);
	void 			KillEntireDir(SiDirEntry const& rEntry, BOOL bDelFiles);

	// handler
	#ifdef MAC
					DECL_LINK( ExitMenuHdl, Menu * );
	#endif
					DECL_LINK( ExitHdl, Accelerator* );
protected:
					DECL_LINK( WindowHideHdl, void* );

	virtual void UserEvent(ULONG nEvent, void* pEventData);
	#ifdef MAC
	virtual void AppEvent( const ApplicationEvent& rAppEvent );
	#endif

	// unter WNT wird bShare hart auf TRUE gesetzt, gleicher GUIBASE-Code
	#if defined  WIN || defined WNT
	BOOL		IsShareLoaded() 	 						{ return m_bShare; }
	#endif

	void		CheckForUpdate();



public:
				SetupApp();
				~SetupApp();

	virtual void        Main();

    void				Exit() { ExitHdl(0); }
	void				PaintExitButton( Window* pWin );
	void 				MainWindowResize();

	BOOL 				IsResponseMode() const;

	SiEnvironment*		GetEnvironment() const { return m_pEnv; }
	SiAgenda*	   		GetAgenda() const { return m_pAgenda; }
	SiCompiledScript* 	GetCScript() const { return m_pCompiledScript; }
	SiCompiledScript* 	GetOldCScript() const { return m_pOldCompiledScript; }

    void                SetResManager( ResMgr* pResMgr ) { m_pResMan = pResMgr; }
	ResMgr*             GetResManager() const { return m_pResMan; }
    void                SetSecondResManager( ResMgr* pResMgr ) { m_pSecondResMgr = pResMgr; }

    void                SetLanguage( int nLanguage ) { m_nLanguage = nLanguage; }
	int 				GetLanguage() const { return m_nLanguage; }
    BOOL                HadParamLanguage() const { return m_bParamLanguage; }

	const Link			GetExitHdl() const { return LINK(this, SetupApp, ExitHdl); }

	// event
    void                PostUserEvent( ULONG nEvent );
    void                HandleUserEvents();

    void                SetProductPatchName( const String& rName ) { m_aProductPatchName = rName; }
    String              GetProductPatchName() const { return m_aProductPatchName; }
    SetupWindow*		GetMainWindow() const { return m_pMainWin; }
};

extern SetupApp *pSetupApp;

#endif

