/*************************************************************************
 *
 *  $RCSfile: loader.c,v $
 *
 *  $Revision: 1.49.14.2 $
 *
 *  last change: $Author: svesik $ $Date: 2003/09/28 02:18:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <limits.h>
#include <dirent.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>

#ifdef LINUX
# include <sys/vfs.h>
# define statvfs statfs
#elif defined(NETBSD) || defined(FREEBSD) || defined(MACOSX)
# include <sys/param.h>
# include <sys/mount.h>
# define statvfs statfs
#else
# include <sys/statvfs.h>
#endif

#ifdef FREEBSD
#if (OSVERSION < 500000)
#define iswspace(c) ((c)==' ' || (c)=='\t' || (c)=='\n')
#endif
#endif

#ifdef MACOSX
#include <unistd.h>
#define iswspace(c) ((c)==' ' || (c)=='\t' || (c)=='\n')
#define MAX_FILES_IN_DIR 1024
#endif

#include "bitmap"
#include "logo.xpm"

#include "svunzip.h"

#include <sys/types.h>
#include <sys/wait.h>

/* */

#include <string.h>
#include <stdlib.h>
#include <utime.h>
#include <dlfcn.h>

#ifndef _LOADER_CXX
#include <tools/solar.h>
#else
#undef BOOL
#define BOOL unsigned char
#ifndef ULONG
#define ULONG unsigned long
#endif
#ifndef USHORT
#define USHORT unsigned short
#endif
#endif

#include <rtl/ustring.h>

#include <errno.h>

#ifdef UNX
#define stricmp strcasecmp
#endif

#define MAX_ENTRYS              10000
#define MAX_ARCH_PATH           255
#define BUF_SZ                  32000
#define ARCH_ACTUAL_VERSION     1

#define STRNCPY(dest,source,size)   strncpy( dest, source, size-1 ); dest[size-1]='\0'
#define STRNCAT(dest,source,size)   strncat( dest, source, size-strlen(dest)-1 )

#ifndef WIN
#ifndef WNT
#define CALLTYPE
#else
#define CALLTYPE            __cdecl
#endif
#else
#define PASCAL              _pascal
#define FAR                 _far
#define CALLTYPE            FAR PASCAL
#endif

void ConvertXpm( Display* pDisplay, char *xpm[], Pixmap* aPixmap, Pixmap* aMask, int* nWidth, int* nHeight );

typedef const char* (*FncFindArch)(const char* pDefSource, const char* pDefName);

#ifdef UNX
#define MASTER_EXTENSION    "bin"
#define JUNK_EXTENSION      "bin"
#else
#define MASTER_EXTENSION    "exe"
#define JUNK_EXTENSION      "bin"
#endif

#define PATCH_FILE          "patch.inf"
#define INSTDBINF_FILE      "instdb.ins"
#define SVERSION_FILE       ".sversionrc"

BOOL m_bNoJunk = FALSE;
BOOL m_bUseX = TRUE;
BOOL m_bDeleteTemp = TRUE;

typedef struct EventData
{
    long              nEvent;
    struct EventData* pNextEvent;
} EventData;

EventData* m_pEventList = NULL;

typedef struct _ArchEntry
{
    ULONG   nOffset;
    ULONG   nSize;
    char*   pName;
} ArchEntry;

typedef struct _ArchDirectory
{
    FILE*       pArch;
    ULONG       nArchSize;
    FncFindArch fncFindArch;

    char        cDelim;
    char        pSourceDir[MAX_ARCH_PATH];
    char        pMasterArch[MAX_ARCH_PATH];

    ULONG       nArchVersion;
    ULONG       nDirOffset;
    ULONG       nDataOffset;

    ULONG       nDirCount;
    ArchEntry*  pDirectory[MAX_ENTRYS];
} ArchDirectory;

void ArchDirectory_Init( ArchDirectory* p )
{
    p->pArch            = NULL;
    p->fncFindArch      = NULL;
    p->nDirOffset       = 0L;
    p->nDataOffset      = 0L;
    p->nDirCount        = 0L;
    p->nArchSize        = 0L;

    #if defined(MAC)
    p->cDelim           = ':';
    #elif defined(UNX)
    p->cDelim           = '/';
    #else
    p->cDelim           = '\\';
    #endif
}

void ArchDirectory_Deinit( ArchDirectory* p )
{
    ULONG n;
    if( p->pArch )
        fclose( p->pArch );

    for( n = 0; n < p->nDirCount; ++ n )
    {
        ArchEntry* pEntry = p->pDirectory[n];
        free( pEntry->pName );
        free( pEntry );
    }
}

void ArchDirectory_GetArchFileName( ArchDirectory* p, USHORT nSegment, char* pBuffer, size_t nBufSize )
{
    char pDelim[2];
    char pExtension[10];
    unsigned short i;

    pDelim[0] = p->cDelim;
    pDelim[1] = 0x00;

    STRNCPY( pBuffer, p->pSourceDir, nBufSize );

    if( pBuffer[strlen(pBuffer)-1] != p->cDelim )
    {
        STRNCAT( pBuffer, pDelim, nBufSize );
    }

    STRNCAT( pBuffer, p->pMasterArch, nBufSize );

    if( !m_bNoJunk )
    {
        if( nSegment != 0 )
            sprintf( pExtension, "-%03ld.%s", nSegment, JUNK_EXTENSION );   // #100211# - checked
        else
            sprintf( pExtension, "-%03ld.%s", nSegment, MASTER_EXTENSION ); // #100211# - checked

        STRNCAT( pBuffer, pExtension, nBufSize );
    }
}

BOOL ArchDirectory_ReadDirectory( ArchDirectory* p )
{
    USHORT  i;
    char    cChar;
    int     nIdx = 0;

    int nErr = fseek( p->pArch, p->nDirOffset, SEEK_SET );
    if( nErr )
        return FALSE;

    p->nDirCount = 0;

    fread( &(p->nArchVersion), sizeof(ULONG), 1, p->pArch );
    fread( &(p->nDirCount), sizeof(ULONG), 1, p->pArch );

    for( i = 0; i < p->nDirCount; ++i )
    {
        ArchEntry*  pNew = (ArchEntry*)malloc( sizeof(ArchEntry) );

        pNew->pName = (char*) malloc( MAX_ARCH_PATH );

        fread( &(pNew->nOffset), sizeof(ULONG), 1, p->pArch );
        fread( &(pNew->nSize), sizeof(ULONG), 1, p->pArch );

        for( nIdx = 0; (cChar = fgetc(p->pArch)) != 0x00; ++nIdx )
            pNew->pName[nIdx] = cChar;
        pNew->pName[nIdx] = 0x00;

        p->pDirectory[i] = pNew;
    }

    p->nDataOffset = ftell( p->pArch );
    return TRUE;
}

void ArchDirectory_SetFindArchHdl( ArchDirectory* p, FncFindArch fncNew )
{
    p->fncFindArch = fncNew;
}

BOOL ArchDirectory_SetArchFile( ArchDirectory* p, const char* pBigFile )
{
    USHORT nLen;
    BOOL  bFnd = FALSE;
    char* pBuf = NULL;
    long i;
    char  aSrch1[5] = "BIGF";
    char  aSrch2[5] = "ILE:";
    char  aSrchStr[9];
    BOOL bReturn;
    USHORT nJunks;
    char cBuffer[MAX_ARCH_PATH];
    FILE* pTest;
    BOOL bAllFiles = TRUE;

    p->nArchSize = 0L;
    p->nDataOffset  = 0L;

    p->pArch = fopen( pBigFile, "rb" );
    if( !p->pArch )
        return FALSE;

    fseek( p->pArch, 0L, SEEK_END );
    p->nArchSize = ftell( p->pArch );
    fseek( p->pArch, 0L, SEEK_SET );


    pBuf = (char*) malloc(BUF_SZ);

    STRNCPY( aSrchStr, aSrch1, 5 );
    strncat( aSrchStr, aSrch2, 4 );

    while( !feof(p->pArch) && !bFnd )
    {
        ULONG nRead = fread( pBuf, sizeof(char), BUF_SZ, p->pArch );
        for( i = 0; i < nRead; ++i )
            if( pBuf[i] == 'B' )
                if( strncmp(&(pBuf[i]), aSrchStr, 8) == 0)
                {
                    p->nDirOffset = atol(&(pBuf[i+8]));
                    if( !p->nDirOffset )
                    {
                        fclose(p->pArch);
                        free( pBuf );
                        return FALSE;
                    }
                    bFnd = TRUE;
                    break;
                }
    }
    free( pBuf );

    if( !bFnd )
    {
        fclose(p->pArch);
        return FALSE;
    }

    bReturn = ArchDirectory_ReadDirectory( p );
    nJunks = (USHORT) ceil( ((double)(p->pDirectory[p->nDirCount-1]->nOffset + p->pDirectory[p->nDirCount-1]->nSize) + p->nDataOffset) / (double)p->nArchSize );
    nJunks = nJunks - 1;

    fclose(p->pArch);

    nLen = strlen(pBigFile);
    memset(p->pSourceDir, 0, MAX_ARCH_PATH );
    memset(p->pMasterArch, 0, MAX_ARCH_PATH );

    for( i = nLen; i >= 0; --i)
        if(pBigFile[i] == p->cDelim)
        {
            if ( i >= MAX_ARCH_PATH - 1 )
                return FALSE;

            strncpy(p->pSourceDir, pBigFile, i+1);

            if ( nLen - i - 1 >= MAX_ARCH_PATH )
                return FALSE;

            strncpy(p->pMasterArch, &(pBigFile[i+1]), MAX_ARCH_PATH);
            break;
        }

    if( nJunks )
    {
        nLen = strlen(p->pMasterArch);
        for( i = nLen; i >= 0; --i )
            if( p->pMasterArch[i] == '-' )
            {
                p->pMasterArch[i] = 0x00;
                break;
            }
    }

    if( !nJunks )
        m_bNoJunk = TRUE;
    else
    for( i = 0; i <= nJunks; ++i )
    {
        ArchDirectory_GetArchFileName( p, i, cBuffer, sizeof(cBuffer) );
        pTest = fopen( cBuffer, "rb" );
        if( pTest )
            fclose( pTest );
        else
        {
            bAllFiles = FALSE;
            fprintf( stderr, "\nfile not found '%s'", cBuffer );
        }

    }

    if( !bAllFiles )
    {
        fprintf( stderr, "\n\nerror: One or more files are missing! Please ensure that all necessary files are present.\n\n" );
        exit( -1 );
    }

    return bReturn;
}

const ArchEntry* ArchDirectory_ExistsFile( ArchDirectory* p, const char* pFileName )
{
    USHORT i;

    ArchEntry* pEntry = NULL;
    for( i = 0; i < p->nDirCount; ++i )
        if( stricmp(pFileName, p->pDirectory[i]->pName) == 0 )
        {
            pEntry = p->pDirectory[i];
            break;
        }
    return pEntry;
}

BOOL ArchDirectory_GetFile( ArchDirectory* p, const char* pFileName, const char* pDestDir )
{
    char pDestFileName[MAX_ARCH_PATH];
    char pDelim[2];
    const ArchEntry* pEntry = ArchDirectory_ExistsFile( p, pFileName );
    char pArchFileName[MAX_ARCH_PATH];
    USHORT nSplitArchNr;
    const char* pReturn;
    FILE* pDestFile;
    ULONG nStartPos;
    int nErr;
    ULONG nReadSz = 0;
    char* pBuf;
    ULONG nToRead;
    ULONG nRead;

    if( !pEntry )
        return FALSE;

    pDelim[0] = p->cDelim;
    pDelim[1] = 0x00;

    STRNCPY( pDestFileName, pDestDir, sizeof(pDestFileName) );
    STRNCAT( pDestFileName, pDelim, sizeof(pDestFileName) );
    STRNCAT( pDestFileName, pEntry->pName, sizeof(pDestFileName) );

    nSplitArchNr = (USHORT)((pEntry->nOffset + p->nDataOffset) / p->nArchSize);
    ArchDirectory_GetArchFileName( p, nSplitArchNr, pArchFileName, sizeof(pArchFileName) );

    pDestFile = fopen( pDestFileName, "wb" );
    if( !pDestFile )
        return FALSE;

DO_RETRY_FIRST:
    p->pArch = fopen( pArchFileName, "rb" );
    if( !p->pArch )
    {
        if( !p->fncFindArch )
        {
        EXIT_RETRY_FIRST:
            fclose( pDestFile );
            return FALSE;
        }
        pReturn = p->fncFindArch( p->pSourceDir, pArchFileName );
        if( !pReturn )
            goto EXIT_RETRY_FIRST;
        STRNCPY( p->pSourceDir, pReturn, MAX_ARCH_PATH );
        ArchDirectory_GetArchFileName( p, nSplitArchNr, pArchFileName, sizeof(pArchFileName) );
        goto DO_RETRY_FIRST;
    }


    nStartPos = (pEntry->nOffset - (nSplitArchNr * p->nArchSize)) + p->nDataOffset;
    nErr = fseek( p->pArch, nStartPos, SEEK_SET );
    if( nErr )
        return FALSE;

    pBuf = (char*) malloc(BUF_SZ);

    while( nReadSz < pEntry->nSize )
    {
        if( feof(p->pArch) )
        {
            fclose( p->pArch );
            nSplitArchNr += 1;
        DO_RETRY:
            ArchDirectory_GetArchFileName( p, nSplitArchNr, pArchFileName, sizeof(pArchFileName) );
            p->pArch = fopen( pArchFileName, "rb" );
            if( !p->pArch )
            {
                if( !p->fncFindArch )
                {
                EXIT_RETRY:
                    fclose( pDestFile );
                    fclose( p->pArch );
                    free( pBuf );
                    return FALSE;
                }
                pReturn = p->fncFindArch( p->pSourceDir, pArchFileName);
                if( !pReturn )
                    goto EXIT_RETRY;
                STRNCPY( p->pSourceDir, pReturn, MAX_ARCH_PATH );
                goto DO_RETRY;
            }
        }

        nToRead = BUF_SZ;
        if( nReadSz + nToRead > pEntry->nSize )
            nToRead = pEntry->nSize - nReadSz;

        nRead = fread( pBuf, sizeof(char), nToRead, p->pArch );
        fwrite( pBuf, sizeof(char), nRead, pDestFile );

        nReadSz += nRead;
    }

    fclose( pDestFile );
    fclose( p->pArch );
    free( pBuf );

    return TRUE;
}


ULONG ArchDirectory_GetCount( ArchDirectory* p )
{
    return p->nDirCount;
}

ArchEntry** ArchDirectory_GetRawList( ArchDirectory* p )
{
    return (ArchEntry**) p->pDirectory;
}

void ArchDirectory_ExtractAll( ArchDirectory* p, const char* pDirname )
{
    ULONG i;
    ULONG nCnt          = ArchDirectory_GetCount(p);
    ArchEntry** ppRaw   = ArchDirectory_GetRawList(p);

    for( i = 0; i < nCnt; ++i ) {
        ArchEntry* pEntry = (ArchEntry*)ppRaw[i];
        ArchDirectory_GetFile( p, pEntry->pName, "." );
    }
    #ifdef UNX
    chmod( "setup", S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );
    #endif
}

#ifdef _LOADER_CXX
#undef BOOL
#endif

/* */

#define PROGRESS_HEIGHT                     12
#define PROGRESS_WIDTH                     200
#define PROGRESS_OFFSET                     10
#define IMAGE_OFFSET                        10

#define __MAX_PATH                          1024
#define MAX_BLOCK                           1048576
#define MAX_LINEBUF                         1024

#define KBYTE                               1024
/* define LD_LIBRARY_PATH                     "LD_LIBRARY_PATH" */

#define SETUP_EVENT_TIME_TO_START           1L
#define SETUP_EVENT_INSTALL_SETUP           2L
#define SETUP_EVENT_KILL_LOADER_WINDOW      3L
#define SETUP_EVENT_START_SETUP             4L
#define SETUP_EVENT_EXIT_LOADER             5L
#define SETUP_EVENT_EXPOSE                  6L

#ifdef MACOSX
#define SAL_FILE_PATTERN                    "libsal.dylib*"
#define STL_FILE_PATTERN                    "libstlport_gcc.dylib.4.5"
#else
#define SAL_FILE_PATTERN                    "libsal.so*"
#ifdef LINUX
#define GCC_FILE_PATTERN                    "libgcc_s.so.1"
#define CPLUS_FILE_PATTERN                  "libstdc++.so.3.0.1"
#define STL_FILE_PATTERN                    "libstlport_gcc.so"
#elif defined (FREEBSD)
#define STL_FILE_PATTERN                    "libstlport_gcc.so"
#else
#define STL_FILE_PATTERN                    "libstlport_sunpro.so"
#endif
#endif

Display*            gpDisplay;
Window              gaWin;
GC                  gaGC;
int                 screen_num;
char*               display_name = NULL;

unsigned int        screen_width;
unsigned int        screen_height;

unsigned int        gnWindowWidth;
unsigned int        gnWindowHeight;

BOOL                bIsSalLib = FALSE;
BOOL                bUnpackLib = FALSE;
BOOL                bExtractBIG = FALSE;
BOOL                gbSize = FALSE;
ULONG               nMinTempSize = 0;

long                gnTotalSize = 0;
long                gnLastPercent = -1;
long                gnLastBytesWritten = 0;
long                gnTotalBytesWritten = 0;

static char*        progname;
static char         strTmpPath[__MAX_PATH];
static char         strInitPath[__MAX_PATH];
static char         strAbsBinaryName[__MAX_PATH];
static char         strSetupBIN[__MAX_PATH];
static char         strExtractPath[__MAX_PATH];
static char         strDestPath[__MAX_PATH];
static char         strSalLibName[__MAX_PATH];

static const char   strExePatch[] = "BIGFILE:patchpatchpatch";
unsigned long       nSetupSize = 0;

void SendEvent(long);
BOOL __getFullPath(const char* pszFilename, char* pszPath, unsigned long MaxLen);
void __EnumFilesCallBack( char *pFile, ULONG nSize, void *pObject );
void __UnzipCallback( long lBytesWritten );

void DrawProgress( long nPercent );
unsigned short WildcardMatch( const char *pWild, const char *pStr );
BOOL           GetSystemPathFromFileURL( const char* strURL, char* strSystemPath );

BOOL CopyFile( const char* pSourceDir,
               const char* pDestDir,
               const char* pName,
               BOOL bSizeOnly );
int  ReadLine( FILE* _pFile,
               char* _pBuffer,
               int _nMaxSize );
BOOL HandlePatch( ArchDirectory* pBigDir,
               BOOL* pIsPatch,
               BOOL bSizeOnly );

static char strStartupShellScript[] =
{
"#!/bin/sh\n" \
"#\n" \
"# StarOffice setup script\n" \
"# (c) 1997, Star Division GmbH\n" \
"cd `dirname $0`\n" \
"sd_archive_path=`pwd`\n" \
"sd_setup_binary=setup.bin\n" \
"sd_platform=`uname -s`\n" \
"# some platforms may need an additional search path for X11 shared libraries\n" \
"case $sd_platform in\n" \
"  SunOS)\n" \
"    AL_IGNOREXERRORS=1\n" \
"    export SAL_IGNOREXERRORS\n" \
"    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/openwin/lib:.:./lib\n" \
"    export LD_LIBRARY_PATH\n" \
"    ;;\n" \
"  Linux)\n" \
"    LD_LIBRARY_PATH=.:./lib:$LD_LIBRARY_PATH\n" \
"    export LD_LIBRARY_PATH\n" \
"    ;;\n" \
"  Darwin)\n" \
"    DYLD_LIBRARY_PATH=.:./lib:${DYLD_LIBRARY_PATH}\n" \
"    export DYLD_LIBRARY_PATH\n" \
"    ;;\n" \
"  FreeBSD)\n" \
"    LD_LIBRARY_PATH=.:./lib:$LD_LIBRARY_PATH\n" \
"    export LD_LIBRARY_PATH\n" \
"    ;;\n" \
"  NetBSD)\n" \
"    LD_LIBRARY_PATH=.:./lib:$LD_LIBRARY_PATH\n" \
"    export LD_LIBRARY_PATH\n" \
"    ;;\n" \
"      *)\n" \
"    ;;\n" \
"esac\n" \
"   export SAL_FONTPATH XPPATH\n" \
"# execute setup binary\n" \
"exec $sd_archive_path/$sd_setup_binary $*\n"
};


#define POPEN_COMMAND                   "/sbin/ldconfig -v -X -N 2> /dev/null"

#define MAX_BUF                         32000
#define BUF_OVERFLOW_SPOOL_BACK         30

typedef struct _Library
{
    int     nFnd;
    char*   pName;
} Library;

#define MAX_FILENAMES                  (sizeof(staticLibCheckList)/sizeof(staticLibCheckList[0]))
Library staticLibCheckList[] = {
    { 0, "libc.so.6" }
};

#define SUSE_RELEASE_FILE "/etc/SuSE-release"

void ChopNewline( char* pLine )
{
    while( *pLine && *pLine != '\n' && *(pLine+1) != 0 )
        pLine++;
    if( *pLine == '\n' )
        *pLine = 0;
}

char* CheckSuSE()
{
    FILE* fp;
    static char aVersion[1024];
    int         nMajor = 0, nMinor = 0;
    struct stat aStat;

    if( stat( SUSE_RELEASE_FILE, &aStat ) )
        return NULL;
    fp = fopen( SUSE_RELEASE_FILE, "r" );
    if( ! fp )
        return NULL;

    aVersion[0] = 0;
    fgets( aVersion, sizeof( aVersion ), fp );
    fscanf( fp, "VERSION = %d.%d", &nMajor, &nMinor );
    fclose( fp );
    if( nMajor < 6 )
        return NULL;

    ChopNewline( aVersion );
    return aVersion;
}

void check_system()
{
    int i;
    char* pLDPath;
    FILE* pFile;
    int nAllOK = 1;
    struct stat aStat;
    char* pName;
    char cAnswer;

    FILE* pOut = popen( POPEN_COMMAND, "r" );
    if( pOut )
    {
        char pBuf[MAX_BUF];
        while( !feof(pOut) )
        {
            size_t nRead = fread( pBuf, 1, MAX_BUF, pOut );

            for( i = 0; i < MAX_FILENAMES; ++i )
                if( staticLibCheckList[i].nFnd == 0 )
                    if( strstr(pBuf, staticLibCheckList[i].pName) != NULL )
                        staticLibCheckList[i].nFnd = 1;

            if( !feof(pOut) )
            {
                nRead -= BUF_OVERFLOW_SPOOL_BACK;
                fseek( pOut, 0, nRead );
            }
        }
        fclose( pOut );
#ifdef MACOSX
        pLDPath = getenv( "DYLD_LIBRARY_PATH" );
#else
        pLDPath = getenv( "LD_LIBRARY_PATH" );
#endif
        if( pLDPath )
        {
            char *pToken;
            pLDPath = strdup( pLDPath );

            pToken = strtok( pLDPath, ":" );
            while( pToken != NULL )
            {
                if( strlen(pToken) != 0 )
                {
                    for( i = 0; i < MAX_FILENAMES; ++i )
                        if( staticLibCheckList[i].nFnd == 0 )
                        {
                            char cFilename[MAX_BUF];
                            STRNCPY( cFilename, pToken, sizeof(cFilename) );
                            STRNCAT( cFilename, "/", sizeof(cFilename) );
                            STRNCAT( cFilename, staticLibCheckList[i].pName, sizeof(cFilename) );

                            pFile = fopen( cFilename, "r" );
                            if( pFile )
                            {
                                staticLibCheckList[i].nFnd = 1;
                                fclose( pFile );
                            }
                        }
                }
                pToken = strtok( NULL, ":" );
            }

            free( pLDPath );
        }

        for( i = 0; i < MAX_FILENAMES; ++i )
            if( staticLibCheckList[i].nFnd == 0 )
            {
                if( nAllOK )
                    printf( "\nERROR: setup system check failed:\n\n" );
                printf( "\t%s   library not found\n", staticLibCheckList[i].pName );
                nAllOK = 0;
            }

        if( nAllOK )
            return;

        printf( "\nStarOffice 5.0 uses the new glibc2 (=libc6).\n" );
        printf( "The libraries above could not be found.\n\n" );
        printf( "The glibc_inst.tar package includes a README file which describes\n" );
        printf( "how to install these libraries. It will be made available on the StarDivision\n" );
        printf( "ftp mirror sites in the same directory as the StarOffice installation files.\n\n" );


        if( stat( "/lib/ld-linux.so.2", &aStat ) )
        {
            printf( "Since there is no /lib/ld-linux.so.2 your system probably\ndoes not support glibc2. Please install the glibc_inst.tar package.\n" );
            exit( -1 );
        }

        pName = CheckSuSE();
        if( pName )
        {
            printf( "Since you seem to use\n\t\"%s\"\nas distribution this is probably not a problem.\n\n", pName );
        }
        else
        {
            printf( "You can try to run setup (and StarOffice) anyway. If it does\nnot work or you experience strange crashes or get unresolved symbol errors\nwe recommend installing the glibc_inst.tar package.\n" );
            printf( "\nDo you want to proceed anyway ? <y/n> " );

            cAnswer = (char)fgetc( stdin );
            if( cAnswer == 'n' || cAnswer == 'N' )
                exit( 1 );
        }
    }
}


#ifdef LINUX
#include <dlfcn.h>
void check_glibc()
{
    void *handle;
    void * (*pverfunc)(void);
    char *pvstr;
    char *pos;
    int maj_ver;
    int min_ver;
    int mic_ver;

    maj_ver = min_ver = mic_ver = 0;
	 
    handle      = dlopen("libc.so.6", RTLD_LAZY);

    /* new API for glibc-2.1, not available in glibc-2.0.7 */
    pverfunc    = dlsym(handle, "gnu_get_libc_version");

    if ( pverfunc ) {
        pvstr = pverfunc();
        printf("glibc version: %s\n", pvstr);
        pos = pvstr;
        if (NULL != pos) {
            maj_ver = atoi(pos);

            pos = strchr (pos, '.');
            if ((NULL != pos) && (strlen (pos) > 1)) {
                min_ver = atoi (++pos);

                pos = strchr (pos, '.');
                if ((NULL != pos) && (strlen (pos) > 1))
                    mic_ver = atoi (++pos);
            }
        }
        dlclose (handle);

        if ((maj_ver > 2) || ((maj_ver == 2) && (min_ver >= 2)))
            return;
    } else {
        dlclose (handle);
    }

    printf("error: wrong glibc version, you need at least 2.2.0\n" );
    exit(1);
}
#endif

Bool b_xerror = False;

int
NewErrorHandler(Display *p_display, XErrorEvent *p_event)
{
    b_xerror = True;
    return 0;
}

int (*OldErrorHandler)(Display* p_display, XErrorEvent *p_event);

Bool
check_fontpath (Display *p_display)
{
    Bool   b_anyxerror = False;
    int    n_oldfp;
    char** pp_oldfp;

    if (p_display == NULL)
        return 0;

    OldErrorHandler = XSetErrorHandler (NewErrorHandler);

    /* rehash the fontpath */

    pp_oldfp = XGetFontPath (p_display, &n_oldfp);

    b_xerror = False;
    XSetFontPath (p_display, pp_oldfp, n_oldfp);
    XSync (p_display, False);

    /* in case of an error check each fontpath element separately */

    if (b_xerror)
    {
        int i;
        int n_newfp = n_oldfp;
        char** pp_newfp = (char**)malloc(n_newfp * sizeof(char*));

        for (i = 0, n_newfp = 0; i < n_oldfp; i++)
        {
            pp_newfp[ n_newfp ] = pp_oldfp[i];
            b_xerror = False;
            XSetFontPath (p_display, pp_newfp, n_newfp + 1);
            XSync (p_display, False);

            /* in case of an error remove the pathelement from fontpath */
            if (b_xerror)
                b_anyxerror = True;
            else
                n_newfp++;
        }

        free (pp_newfp);
    }
    XFreeFontPath (pp_oldfp);

    XSetErrorHandler (OldErrorHandler);

    return b_anyxerror;
}

/* ----------------------------------------------------------------------------- */
int CheckForSlash( char* _pStr )
{
	int i = 0;
	char c;

	while( c = _pStr[i++] )
    {
		if (c == '\\' || c == '/')
		{
			return i;
		}
	}
	return 0;
}

/* ----------------------------------------------------------------------------- */

BOOL CopyFile( const char* pSourceDir,
               const char* pDestDir,
               const char* pName,
               BOOL bSizeOnly )
{
    int             hSourceHdl, hDestHdl;
    int             nPos;
    unsigned long   nSize, nRead;
    char*           pBuffer;
    char            pDest[ __MAX_PATH ];
    char            pSource[ __MAX_PATH ];
    struct stat     aStat;
    struct utimbuf  aTimes;

    STRNCPY( pSource, pSourceDir, sizeof(pSource) );
    STRNCAT( pSource, "/", sizeof(pSource) );
    STRNCAT( pSource, pName, sizeof(pSource) );

    STRNCPY( pDest, pDestDir, sizeof(pDest) );
    STRNCAT( pDest, "/", sizeof(pDest) );
    
    nPos = CheckForSlash( pName );
    STRNCAT( pDest, pName+nPos, sizeof(pDest) );

    hSourceHdl = open( pSource, O_RDONLY );

    if( hSourceHdl == -1 )
        return FALSE;

    nSize = lseek( hSourceHdl, 0L, SEEK_END );
    lseek( hSourceHdl, 0L, SEEK_SET );

    if ( bSizeOnly )
    {
        __EnumFilesCallBack( 0L, nSize, 0L );
        close( hSourceHdl );
        return TRUE;
    }

    /* Check wether file already exists! If it exists then don't copy.
       It's not an error, so return TRUE here.
    */
    hDestHdl = open( pDest, O_RDONLY );
    if ( hDestHdl != -1 )
    {
        close( hSourceHdl );
        close( hDestHdl );
        return TRUE;
    }

    hDestHdl = open( pDest, O_CREAT | O_WRONLY );

    if( hDestHdl == -1 )
    {
        close( hSourceHdl );
        return FALSE;
    }

    if ( nSize > MAX_BLOCK )
        nSize = MAX_BLOCK;

    pBuffer = (char*)malloc( nSize );

    do {
        nRead = read( hSourceHdl, pBuffer, nSize );
        if( nRead )
        {
            write( hDestHdl, pBuffer, nRead );
            __UnzipCallback( nRead );
        }
    } while( nRead != 0 );

    close( hSourceHdl );
    close( hDestHdl );
    free( pBuffer );

    if ( stat( pSource, &aStat ) == 0 )
    {
        aTimes.actime = aStat.st_atime;
        aTimes.modtime = aStat.st_mtime;
        utime( pDest, &aTimes );
    }

    chmod( pDest, S_IRWXU );

    return TRUE;
}

/* ----------------------------------------------------------------------------- */
void KillDir( DIR* pDir )
{
    DIR* pSubDir;
    struct dirent* pFile;

    while ( ( pFile = readdir( pDir ) ) != NULL )
    {
        if ( strcmp( pFile->d_name, "." ) == 0 )
            continue;
        if ( strcmp( pFile->d_name, ".." ) == 0 )
            continue;

        pSubDir = opendir( pFile->d_name );

        if ( pSubDir )
        {
            chdir( pFile->d_name );
            KillDir( pSubDir );
            chdir( ".." );
            closedir( pSubDir );
            rmdir( pFile->d_name );
        }
        else
            unlink( pFile->d_name );
    }
}

void KillSetupDir()
{
    DIR* pDir;
    struct dirent* pFile;

	if (m_bDeleteTemp == FALSE)
	{
		fprintf(stderr, "%s will not delete.", strTmpPath);
		return;
	}

    pDir = opendir( strTmpPath );

    if( !pDir )
        return ;

    KillDir( pDir );

    closedir( pDir );
    chdir( strInitPath );
    rmdir( strTmpPath );
}

void makeSymLink( char* s )
{
    char pFile[__MAX_PATH];
    char * ptr;
    int i = 0;
    int rv = 0;
    char tmp[2];
    char dest[__MAX_PATH];
    char src[__MAX_PATH];

    STRNCPY( pFile, s, sizeof(pFile) );

    while( ptr = strrchr(pFile,'.') )
    {
        char c = *(ptr+1);

        if ( c < 48 || c > 57 )
            break;
        else if ( ++i == 3 )
            break;
        *ptr = '\0';
    }

    /*
     * i==2: for external libs: libabc.so.1 -> abc.so.1.2
     * i==3: our own versioning: libabc.so.1 -> abc.so.1.2.3
     */
    if( i == 2 || i == 3 )
    {
        if ( i == 2 )
            pFile[ strlen( pFile ) ] = '.';

        STRNCPY( src, strTmpPath, sizeof(src) );
        STRNCAT( src, "/", sizeof(src) );
        STRNCAT( src, s, sizeof(src) );

        STRNCPY( dest, strTmpPath, sizeof(dest) );
        STRNCAT( dest, "/", sizeof(dest) );
        STRNCAT( dest, pFile, sizeof(dest) );

        symlink( src, dest );
    }
}

char* GetTempPath( char* pBuf, size_t nBufSize )
{
	int nLen;
    char* pTmp = getenv( "TMP" );

    if( !pTmp )
        pTmp = getenv( "TEMP" );

    if( pTmp )
    {
        STRNCPY( pBuf, pTmp, nBufSize );
    }
    else
    {
		pTmp = P_tmpdir;
		nLen = strlen(pTmp);
		if ( (nLen <= nBufSize) && (pTmp[ nLen - 1] == '/') )
		{
			STRNCPY( pBuf, pTmp, nLen );
		}
		else
		{
			STRNCPY( pBuf, pTmp, nBufSize );
		}
	}

    return pBuf;
}

void GetTempFile( char* pBuf, size_t nBufSize )
{
    char*       ret_val;
    size_t      i, nMaxLen;
    char        sBuf[__MAX_PATH];
    unsigned    u;

    char        pfx[6];
    char        ext[5];
    struct stat aStat;

    STRNCPY( pfx, "sv", 6 );
    STRNCPY( ext, ".tmp", 5 );

    if ( !GetTempPath(sBuf, sizeof(sBuf)) )
        return;

    i = strlen(sBuf);
    nMaxLen = i+2 + 8 + 4;  // 

    ret_val = (char*) malloc( nMaxLen );
    if (ret_val)
    {
        strncpy( ret_val, sBuf, i+1 );

        if( i>0 && ret_val[i-1] != '\\' && ret_val[i-1] != '/' && ret_val[i-1] != ':' )
            ret_val[i++] = '/';

        strncpy(ret_val + i, pfx, 5);
        ret_val[i + 5] = '\0';
        i = strlen(ret_val);

        if ( i >= nMaxLen )
            return;         // should never happen

        for (u = 1; u < 26*26*26; u++)
        {
            snprintf( ret_val+i, nMaxLen-i-1, "%03u", u );

            strncat( ret_val, ext, nMaxLen - strlen(ret_val) - 1 );
            ret_val[ nMaxLen-1 ] = '\0';

            if ( stat( ret_val, &aStat ) )
            {
                STRNCPY( pBuf, ret_val, nBufSize );
                break;
            }
        }
        free( ret_val);
        ret_val = 0;
    }
}

void __EnumFilesCallBack( char *pFile, ULONG nSize, void *pObject )
{
    if ( gbSize )
    {
        nMinTempSize += nSize;
        gnTotalSize  += nSize;
    }

    bIsSalLib = FALSE;
    bUnpackLib = FALSE;

    if ( pFile )
    {
        if ( WildcardMatch( SAL_FILE_PATTERN, pFile ) )
        {
            STRNCPY( strSalLibName, pFile, sizeof(strSalLibName) );
            bIsSalLib = TRUE;
        }
        else if ( WildcardMatch( STL_FILE_PATTERN, pFile ) )
            bUnpackLib = TRUE;
#ifdef LINUX
        else if ( WildcardMatch( GCC_FILE_PATTERN, pFile ) )
            bUnpackLib = TRUE;
        else if ( WildcardMatch( CPLUS_FILE_PATTERN, pFile ) )
            bUnpackLib = TRUE;
#endif
    }
}

void __UnzipCallback( long lBytesWritten )
{
    long nPercent;

    if ( gnTotalSize == 0 )
        return;

    if ( lBytesWritten <= gnLastBytesWritten )
        gnTotalBytesWritten += gnLastBytesWritten;

    gnLastBytesWritten = lBytesWritten;

    nPercent = ( ( gnTotalBytesWritten + lBytesWritten ) / ( gnTotalSize / 100 ) );

    DrawProgress( nPercent );
}

void UnpackBIG2Temp( ArchDirectory* pBigDir, BOOL bSize )
{
    ArchEntry* pEntry;
    ULONG i;

    for( i = 0; i < pBigDir->nDirCount; ++i )
    {
        pEntry = (ArchEntry*)pBigDir->pDirectory[i];
        if( strncmp(pEntry->pName, "f0_", 3) == 0 )
            if( bSize )
            {
                ArchDirectory_GetFile( pBigDir, pEntry->pName, strTmpPath );
                SVUnzipEnumFiles( pEntry->pName, "*", (UnzipEnumFilesCallBack*) __EnumFilesCallBack, NULL );

                if ( bIsSalLib || bUnpackLib )
                    SVUnzip( pEntry->pName, "*", (const char*)"qq", NULL );

                unlink( pEntry->pName );
	    }
            else
            {
                ArchDirectory_GetFile( pBigDir, pEntry->pName, strTmpPath );
                SVUnzipEnumFiles( pEntry->pName, "*", (UnzipEnumFilesCallBack*) __EnumFilesCallBack, NULL );

                if ( !bIsSalLib && !bUnpackLib )
                    SVUnzip( pEntry->pName, "*", (const char*)"qq", (UnzipCallBack*) __UnzipCallback );

                unlink( pEntry->pName );
            }
    }
}


void Unpack2Temp( BOOL bSize )
{
    char            file[16*1024];
    struct dirent*  pFile;
    DIR*            pDir = opendir( strInitPath );

    if( !pDir ) return ;

    while( (pFile = readdir(pDir)) != NULL )
    {
        if( strncmp(pFile->d_name, "f0_", 3) == 0 )
        {
            STRNCPY( file, strInitPath, sizeof(file) );
            STRNCAT( file, "/", sizeof(file) );
            STRNCAT( file, pFile->d_name, sizeof(file) );

            if( bSize )
            {
                SVUnzipEnumFiles( file, "*", (UnzipEnumFilesCallBack*) __EnumFilesCallBack, NULL );

                if ( bIsSalLib || bUnpackLib )
                    SVUnzip( file, "*", (const char*)"qq", NULL );
            }
            else
            {
                SVUnzipEnumFiles( file, "*", (UnzipEnumFilesCallBack*) __EnumFilesCallBack, NULL );

                if ( !bIsSalLib && !bUnpackLib )
                    SVUnzip( file, "*", (const char*)"qq", (UnzipCallBack*) __UnzipCallback );
	    }
	}
    }
    closedir( pDir );
}


void InstallSetupFile( ArchDirectory* pBigDir )
{
    int nErr = 0;
    int dfd = 0;
    char    strSetupOrgZIP[__MAX_PATH];
    char    strSetupZIP[__MAX_PATH];
    char    strSetupINI[__MAX_PATH];
	char	strUnoINI[__MAX_PATH];

    FILE*   pFile;
    struct  statvfs buf;
    ULONG   nSize = 0;
    DIR* pDir;
    struct dirent* pDirFile;
    BOOL    bIsPatchMode = FALSE;

    GetTempFile( strTmpPath, sizeof(strTmpPath) );

    if( strTmpPath[0] != '\0' )
        nErr = mkdir( strTmpPath, S_IRWXU );
    else
    {
        (void)  fprintf( stderr, "%s: cannot find temppath!\n",
                         progname );
        exit( -1 );
    }

    if( nErr == -1 )
    {
        (void)  fprintf( stderr, "%s: could not create temporary directory (%s)\n",
                         progname, strTmpPath );
        exit( -1 );
    }

    if( chdir(strTmpPath) == -1 )
    {
        (void)  fprintf( stderr, "%s: could not change to temporary directory (%s)\n",
                         progname, strTmpPath );
        exit( -1 );
    }

    gbSize = TRUE;
    if( !pBigDir )
    {
        Unpack2Temp( TRUE );
        nMinTempSize += 512000;
    }
    else
    {
        UnpackBIG2Temp( pBigDir, TRUE );
        nMinTempSize += 8192000;
    }
    gbSize = FALSE;

#ifdef MACOSX

    /* MacOSX readdir will incorrrectly return NULL if enough */
    /* symlinks are added to to the directory readdir is accessing */
    /* So this builds a list of all files first */
    /* and then creates the symlinks to avoid any problems */
    {
      char * fnamelist[MAX_FILES_IN_DIR];
      int nfiles = 0;
      int j;
      pDir = opendir( strTmpPath );
      while( (pDirFile = readdir(pDir)) != NULL )
          if( strcmp(pDirFile->d_name, ".") != 0 &&
              strcmp(pDirFile->d_name, "..") != 0 )
	        fnamelist[nfiles++] = strdup(pDirFile->d_name);
      closedir(pDir);
      for (j = 0; j < nfiles; j++) { 
	  makeSymLink(fnamelist[j]);
          free(fnamelist[j]);
          fnamelist[j] = NULL;
      }
      nfiles = 0;
    }

#else

    pDir = opendir( strTmpPath );
    if( pDir )
    {
        while( (pDirFile = readdir(pDir)) != NULL )
            if( strcmp(pDirFile->d_name, ".") != 0 &&
                strcmp(pDirFile->d_name, "..") != 0 )
            makeSymLink( pDirFile->d_name );
        closedir( pDir );
    }

#endif

    gbSize = TRUE;
    if ( !HandlePatch( pBigDir, &bIsPatchMode, TRUE ) && bIsPatchMode )
        exit( -1 );
    gbSize = FALSE;

    nMinTempSize /= KBYTE;

    statvfs( strTmpPath, &buf);
    #if defined(LINUX) || defined(NETBSD) || defined(FREEBSD) || defined(MACOSX)
    nSize = buf.f_bsize;
    #else
    nSize = (buf.f_frsize ? buf.f_frsize : buf.f_bsize);
    #endif
    if( nSize < KBYTE )
        nSize = buf.f_bavail / (KBYTE / nSize);
    else if( nSize > KBYTE )
        nSize = buf.f_bavail * (nSize / KBYTE);
    else
        nSize = buf.f_bavail;

    if( nSize < nMinTempSize )
    {
        (void)  fprintf( stderr, "%s: The temporary directory is full. (%s)\n",
                         progname, strTmpPath );
        exit( -1 );
    }

    if( !pBigDir )
        Unpack2Temp( FALSE );
    else
        UnpackBIG2Temp( pBigDir, FALSE );


    if ( !HandlePatch( pBigDir, &bIsPatchMode, FALSE ) )
        exit( -1 );

    if ( nErr )
    {
        (void)  fprintf( stderr, "%s: Could not unpack file '%s'\n",
                         progname, strSetupZIP );
        exit( -1 );
    }
    else
        DrawProgress( 100 );


/* --------------------------------- setup.ini --------------------------------- */

    STRNCPY( strSetupINI, strTmpPath, sizeof(strSetupINI) );
    STRNCAT( strSetupINI, "/setup.ini", sizeof(strSetupINI) );

    pFile = fopen( strSetupINI, "w+" );

    if( pFile )
    {
        fprintf( pFile, "[source]\n" );
        if( pBigDir )
        {
            fprintf( pFile, "path=%s\n", strAbsBinaryName );
            fprintf( pFile, "big=1\n" );
            fprintf( pFile, "offset=%ld\n", nSetupSize );
        }
        else
                fprintf( pFile, "path=%s\n", strInitPath );

        fclose( pFile );
    }


/* ---------------------------------- uno.ini ---------------------------------- */

/* #91782# */
    STRNCPY( strUnoINI, strTmpPath, sizeof(strUnoINI) );
    STRNCAT( strUnoINI, "/unorc", sizeof(strUnoINI) );

    pFile = fopen( strUnoINI, "w+" );

    if( pFile )
    {
		fprintf( pFile, "[bootstrap]\n");
		fprintf( pFile, "UNO_TYPES = types.rdb\n");

        if ( bIsPatchMode )
            fprintf( pFile, "UNO_SERVICES = services.rdb" );
		else
		fprintf( pFile, "UNO_SERVICES = setup_services.rdb" );

		fclose( pFile );
	}

/* ----------------------------------------------------------------------------- */
    STRNCPY( strSetupBIN, strTmpPath, sizeof(strSetupBIN) );
    STRNCAT( strSetupBIN, "/setup.bin", sizeof(strSetupBIN) );
    chmod( strSetupBIN, S_IRWXU );

    STRNCPY( strSetupBIN, strTmpPath, sizeof(strSetupBIN) );
    STRNCAT( strSetupBIN, "/sopatchlevel.sh", sizeof(strSetupBIN) );
    chmod( strSetupBIN, S_IRWXU );

    STRNCPY( strSetupBIN, strTmpPath, sizeof(strSetupBIN) );
    STRNCAT( strSetupBIN, "/sorev", sizeof(strSetupBIN) );
    chmod( strSetupBIN, S_IRWXU );

    STRNCPY( strSetupBIN, strTmpPath, sizeof(strSetupBIN) );
    STRNCAT( strSetupBIN, "/setup", sizeof(strSetupBIN) );
    chmod( strSetupBIN, S_IRWXU );

#ifdef MACOSX

    /* MacOSX readdir will incorrrectly return NULL if enough */
    /* symlinks are added to to the directory readdir is accessing */
    /* So this builds a list of all files first */
    /* and then creates the symlinks to avoid any problems */
    {
      char * fnamelist[MAX_FILES_IN_DIR];
      int nfiles = 0;
      int j;
      pDir = opendir( strTmpPath );
      while( (pDirFile = readdir(pDir)) != NULL )
          if( strcmp(pDirFile->d_name, ".") != 0 &&
              strcmp(pDirFile->d_name, "..") != 0 )
	        fnamelist[nfiles++] = strdup(pDirFile->d_name);
      closedir(pDir);
      for (j = 0; j < nfiles; j++) { 
	  makeSymLink(fnamelist[j]);
          free(fnamelist[j]);
          fnamelist[j] = NULL;
      }
      nfiles = 0;
    }

#else

    pDir = opendir( strTmpPath );
    if( pDir )
    {
        while( (pDirFile = readdir(pDir)) != NULL )
            if( strcmp(pDirFile->d_name, ".") != 0 &&
                strcmp(pDirFile->d_name, "..") != 0 )
                   makeSymLink( pDirFile->d_name );
            closedir( pDir );
    }

#endif

    SendEvent( SETUP_EVENT_KILL_LOADER_WINDOW );
}

void InstallBigSetupFile()
{
    ArchDirectory aDir;
    ArchDirectory_Init( &aDir );

    if( !ArchDirectory_SetArchFile(&aDir, strAbsBinaryName) )
    {
        (void)  fprintf( stderr, "%s: cannot open archivefile %s\n",
                         progname, strAbsBinaryName );
        exit( -1 );
    }

    if( bExtractBIG )
    {
        USHORT nLen = strlen(strExtractPath);
        if( nLen ) {
            if( chdir(strExtractPath) == -1 ) {
                (void) fprintf( stderr, "%s: could not change directory (%s)\n",
                                progname, strExtractPath );
                exit( -1 );
            }
        }
        else 
        {
            STRNCPY( strExtractPath, ".", sizeof(strExtractPath) );
        }

        fprintf( stderr, " extracting files please wait...\n" );
        ArchDirectory_ExtractAll( &aDir, strExtractPath );
        exit( 0 );
    }
    else
        InstallSetupFile( &aDir );
}

void load_font(XFontStruct **font_info)
{
    char *fontname = "9x15";
    if( (*font_info = XLoadQueryFont( gpDisplay, fontname )) == NULL )
    {
        (void) fprintf( stderr, "%s: Cannot open 9x15 font\n",
               progname);
        exit( -1 );
    }
}

/*
void draw_text(Window win, GC gc, XFontStruct *font_info, unsigned int win_width,
    unsigned int win_height)
{
    char*   strText = "Initializing installation program...";
    int     nLen,
            nWidth;
    char    cd_height[50];
    int     font_height;

    nLen        = strlen( strText );
    nWidth      = XTextWidth( font_info, strText, nLen );
    font_height = font_info->ascent + font_info->descent;

    XDrawString( gpDisplay, win, gc, (win_width - nWidth)/2,
                 (win_height - font_height) / 2, strText, nLen );
}*/

void SendEvent( long nEvent )
{
    if ( m_bUseX )
    {
        XEvent aClient;
        memset( &aClient, 0, sizeof(XEvent) );

        (&(aClient.xclient))->type          = ClientMessage;
        (&(aClient.xclient))->display       = gpDisplay;
        (&(aClient.xclient))->window        = gaWin;
        (&(aClient.xclient))->message_type  = (Atom) nEvent;
        (&(aClient.xclient))->format        = 32;
        (&(aClient.xclient))->data.l[0]     = nEvent;

        XSendEvent( gpDisplay, gaWin, False, 0, &aClient );
    }
    else
    {
        EventData *pEvent = (EventData*) malloc( sizeof( EventData ) );
        pEvent->nEvent = nEvent;
        pEvent->pNextEvent = NULL;

        if ( m_pEventList == 0 )
            m_pEventList = pEvent;
        else
        {
            EventData *pData = m_pEventList;
            while ( pData->pNextEvent )
                pData = pData->pNextEvent;
            pData->pNextEvent = pEvent;
        }
    }
}

long NextEvent()
{
    XEvent  report;
    long    nRet = 0;

    if ( m_bUseX )
    {
        XNextEvent( gpDisplay, &report );

        switch( report.type )
        {
            case ClientMessage :
                nRet = report.xclient.message_type;
                break;

            case Expose:
                if (report.xexpose.count != 0)
                    break;
                nRet = SETUP_EVENT_EXPOSE;
                break;
        }
    }
    else
    {
        EventData* pEvent = m_pEventList;

        if ( m_pEventList == NULL )
            return SETUP_EVENT_EXIT_LOADER;

        m_pEventList = pEvent->pNextEvent;
        nRet = pEvent->nEvent;

        free( pEvent );
    }

    return nRet;
}

BOOL MayUseX( int argc, char** argv )
{
    int i;

    for ( i=1; i<argc; i++ )
    {
        if ( ( strcasecmp(argv[i], "-r") == 0 ) ||
             ( strncasecmp(argv[i], "-r:", 3) == 0 ) ||
             ( strncasecmp(argv[i], "-rsp1", 5) == 0 ) ||
             ( strncasecmp(argv[i], "-rsp2", 5) == 0 ) )
        {
            return FALSE;
        }
    }
    return TRUE;
}

int main(int argc, char**argv)
{
    int             x, y;
    unsigned int    display_width,
                    display_height;
    int             nWidth, nHeight;
    int             nMask;
    Pixmap          aImage;
    Pixmap          aMask;
    GC              gc;
    GC              aCopyGC;
    XFontStruct*    font_info;
    int             nIdx;
    int             i;
    long            nEvent;
    XGCValues       aValues;
    BOOL            bLD_LIBRARY_PATH_Set = FALSE;
    char*           pLibPath;
    XSetWindowAttributes aAttr;
    XColor aColor;
    Colormap aColorMap;

/* #90613# */
    int bReturnValueSet = 0;
    int nReturnValue = 1;
    pid_t pid;
    int nWaitpidValue;
    int nStatus;

    /* parse command line */
    progname = argv[0];
    strDestPath[0] = '\0';

    for ( i=1; i<argc; i++ )
    {
        if ( strncasecmp( argv[i], "-extract", 8 ) == 0 )
        {
            bExtractBIG = TRUE;
            if ( ( i+1 < argc ) && ( *(argv[i+1]) != '-' ) )
            {
                i += 1;
                STRNCPY( strExtractPath, argv[i], sizeof(strExtractPath) );
            }
        }
        else if ( strncasecmp( argv[i], "-patch:", 7 ) == 0 )
        {
            STRNCPY( strDestPath, argv[i]+7, sizeof(strDestPath) );
        }
        else if ( ( strncasecmp( argv[i], "-patch", 6 ) == 0 ) &&
                  ( i+1 < argc ) )
        {
            STRNCPY( strDestPath, argv[++i], sizeof(strDestPath) );   // attention! i modified!
        }
        else if ( strncasecmp( argv[i], "-dontdeletetemp", 15 ) == 0 )
        {
            m_bDeleteTemp = FALSE;
        }
        else if ( strncasecmp( argv[i], "-display", 8 ) == 0 )
        {
            display_name = argv[i+1];
        }
    }

    if( !__getFullPath(progname, strAbsBinaryName, __MAX_PATH) )
    {
        fprintf( stderr, "%s: absolute programpath cannot be found.\n", progname );
        exit(0);
    }

    // we need a LD_LIBRARY_PATH with a current directory in it so we can
    // dynamicly load a library ( needed for patching! )
#ifdef MACOSX
    pLibPath = getenv("DYLD_LIBRARY_PATH");
#else
    pLibPath = getenv("LD_LIBRARY_PATH");
#endif
    if ( ! pLibPath || ( strcmp( pLibPath, "." ) != 0 ) &&
                       ( strncmp( pLibPath, ".:", 2 ) != 0 ) )
    {
        char * pNewPath;
        if ( pLibPath )
        {
#ifdef MACOSX
            pNewPath = malloc( strlen( "DYLD_LIBRARY_PATH=" ) + strlen( pLibPath ) + 3 );
            strcpy( pNewPath, "DYLD_LIBRARY_PATH=" );     // #100211# - checked
#else
            pNewPath = malloc( strlen( "LD_LIBRARY_PATH=" ) + strlen( pLibPath ) + 3 );
            strcpy( pNewPath, "LD_LIBRARY_PATH=" );     // #100211# - checked
#endif
            strcat( pNewPath, ".:" );                   // #100211# - checked
            strcat( pNewPath, pLibPath );               // #100211# - checked
            putenv( pNewPath );
        }
        else
        {
#ifdef MACOSX
            pNewPath = malloc( strlen( "DYLD_LIBRARY_PATH=" ) + 2 );
            strcpy( pNewPath, "DYLD_LIBRARY_PATH=" );     // #100211# - checked
#else
            pNewPath = malloc( strlen( "LD_LIBRARY_PATH=" ) + 2 );
            strcpy( pNewPath, "LD_LIBRARY_PATH=" );     // #100211# - checked
#endif
            strcat( pNewPath, "." );                    // #100211# - checked
            putenv( pNewPath );
        }

        if ( execv( strAbsBinaryName, argv ) < 0 )
        {
            fprintf( stderr, "execv failed with file:%s with %d.\n", strAbsBinaryName );
            exit(-1);
        }
        exit(0);
    }

#if defined LINUX
    check_system();
    check_glibc();
#endif

    m_bUseX = MayUseX( argc, argv );

    nIdx = strlen( strAbsBinaryName );
    while( strAbsBinaryName[nIdx] != '/' )
    {
        if( nIdx == 0)
            break;
        else
            nIdx--;
    }
    strncpy( strInitPath, strAbsBinaryName, nIdx );
    strInitPath[ nIdx ] = '\0';

    if ( m_bUseX )
    {
        if ( (gpDisplay = XOpenDisplay( display_name )) == NULL )
        {
            (void) fprintf( stderr, "%s: cannot connect to X server %s\n",
                            progname, XDisplayName(display_name) );
            exit( -1 );
        }

        if ( check_fontpath( gpDisplay ) )
        {
        #if OSL_DEBUG_LEVEL > 1
            fprintf(stderr, "%s: error in fontpath (salvaged)\n", progname);
        #endif
        }

        screen_num      = DefaultScreen(gpDisplay);
        display_width   = DisplayWidth(gpDisplay, screen_num);
        display_height  = DisplayHeight(gpDisplay, screen_num);
	    aColorMap = DefaultColormap( gpDisplay, screen_num );
        ConvertXpm( gpDisplay, logo_xpm, &aImage, &aMask, &nWidth, &nHeight );

        gnWindowWidth = nWidth + ( 2 * PROGRESS_OFFSET ) + PROGRESS_WIDTH + IMAGE_OFFSET;
        if ( nHeight + 2*IMAGE_OFFSET > ( ( 2 * PROGRESS_OFFSET ) + PROGRESS_HEIGHT ) )
            gnWindowHeight = nHeight + 2*IMAGE_OFFSET;
        else
            gnWindowHeight = ( 2 * PROGRESS_OFFSET ) + PROGRESS_HEIGHT;

        x = (display_width - gnWindowWidth) / 2;
        y = (display_height - gnWindowHeight) / 2;

		/* Add some space for the border, too */
        gnWindowWidth += 2;
        gnWindowHeight += 2;
        x -= 1;
        y -= 1;

        XAllocNamedColor( gpDisplay,
						  aColorMap,
						  "lightgrey",
                          &aColor, &aColor );
        aAttr.background_pixel = aColor.pixel;
        aAttr.override_redirect = True;
        aAttr.event_mask = ExposureMask;
        gaWin = XCreateWindow( gpDisplay,
                             DefaultRootWindow( gpDisplay ),
                             x, y, gnWindowWidth, gnWindowHeight, 0,
                             DefaultDepth( gpDisplay, DefaultScreen( gpDisplay ) ),
                             InputOutput,
                             DefaultVisual( gpDisplay, DefaultScreen( gpDisplay ) ),
                             CWOverrideRedirect | CWBackPixel | CWEventMask,
                             &aAttr );

        nMask = GCFunction|GCForeground;
        aValues.foreground	= 0xffffffff;
        aValues.function	= GXcopy;

        if( aMask != None )
        {
            aValues.clip_mask		= aMask;
            aValues.clip_x_origin	= IMAGE_OFFSET+1;
            aValues.clip_y_origin	= IMAGE_OFFSET+1;
            nMask |= GCClipMask | GCClipXOrigin | GCClipYOrigin;
        }

        gaGC    = DefaultGC( gpDisplay, screen_num );
        aCopyGC = XCreateGC( gpDisplay, gaWin, nMask, &aValues );

        load_font( &font_info );

        XMapWindow( gpDisplay, gaWin );
        XFlush( gpDisplay );
    }

    SendEvent( SETUP_EVENT_TIME_TO_START );

    while( 1 )
    {
        nEvent = NextEvent();

        switch( nEvent )
        {
            case SETUP_EVENT_TIME_TO_START :
                SendEvent( SETUP_EVENT_INSTALL_SETUP );
                break;

            case SETUP_EVENT_INSTALL_SETUP :
                nSetupSize = atol( &(strExePatch[8]) );
                if( !nSetupSize )
                    InstallSetupFile( NULL );
                else
                    InstallBigSetupFile();
                break;

            case SETUP_EVENT_KILL_LOADER_WINDOW :
                if ( m_bUseX )
                    XUnmapWindow( gpDisplay, gaWin );
                SendEvent( SETUP_EVENT_START_SETUP );
                break;

            case SETUP_EVENT_START_SETUP : {
                DIR  *pDir;
                char  pPrintPath[ __MAX_PATH ];
                chdir( strInitPath );

                // Check if we have a folder psprint. When we have such a folder
                // we set the environment variable SAL_PSPRINT to that folder

                STRNCPY( pPrintPath, strTmpPath, sizeof(pPrintPath) );
                STRNCAT( pPrintPath, "/psprint", sizeof(pPrintPath) );
                if ( NULL != ( pDir = opendir( pPrintPath ) ) )
                {
                    char pPrintEnv[ __MAX_PATH ];
                    STRNCPY( pPrintEnv, "SAL_PSPRINT=", sizeof(pPrintEnv) );
                    STRNCAT( pPrintEnv, pPrintPath, sizeof(pPrintEnv) );
                    
                    if ( putenv( strdup( pPrintEnv ) ) != 0 )
                        fprintf( stderr, "\ncould not set print path: '%s'\n", pPrintEnv );
                    closedir( pDir );
                }
/*              system( strSetupBIN ); */

                /* #90613# this is the system(...) replacement */

                if (( pid = fork()) < 0 )
                {
                    // DBG_ASSERT( FALSE, "fork error" );
                    fprintf(stderr, "fork error.\n");
                    exit(-1);
                }
                else if ( pid == 0 )
                {
//                  if ( execv( strSetupBIN, (char * const *) NULL ) < 0 )
                    if ( execv( strSetupBIN, argv ) < 0 )
                    {
                        // DBG_ASSERT( FALSE, "execv failed" );
                        fprintf(stderr, "execv failed with file:%s with %d.\n", strSetupBIN);
                        exit(-1);
                    }
                }
                //fprintf( stderr, "parent: %s %s\n", ppArgv[0] , ppArgv[1] );
                if ( nWaitpidValue = waitpid( pid, &nStatus, 0 ) < 0 )
                {
                    // DBG_ASSERT( FALSE, "wait error" );
                    fprintf(stderr, "wait failed.\n");
                    exit(-1);
                }

                if (WIFEXITED(nStatus) != 0)
                {
                    bReturnValueSet = 1;
                    nReturnValue = WEXITSTATUS(nStatus);
                }

    		chdir( strTmpPath );
                SendEvent( SETUP_EVENT_EXIT_LOADER );
            } break;

            case SETUP_EVENT_EXIT_LOADER :
                KillSetupDir();

                if ( m_bUseX )
                {
                    XUnloadFont( gpDisplay, font_info->fid );
                    XFreePixmap( gpDisplay, aImage );
                    if( aMask )
                        XFreePixmap( gpDisplay, aMask );
                    XFreeGC( gpDisplay, aCopyGC );
                    XCloseDisplay( gpDisplay );
                }

                if (bReturnValueSet == 1)
                    exit(nReturnValue);
                else
                    exit(1);
                break;

            case SETUP_EVENT_EXPOSE:
                {
                    int nX1, nX2, nY1, nY2;

                    nX1 = 0;
                    nY1 = 0;
                    nX2 = nX1 + gnWindowWidth - 1;
                    nY2 = nY1;

                    XSetForeground( gpDisplay, gaGC,
                                    WhitePixel( gpDisplay, screen_num ) );
                    XDrawLine( gpDisplay, gaWin, gaGC, nX1, nY1, nX2, nY2 );

                    nX2 = nX1;
                    nY2 = nY1 + gnWindowHeight - 1;
                    XDrawLine( gpDisplay, gaWin, gaGC, nX1, nY1, nX2, nY2 );

                    XSetForeground( gpDisplay, gaGC,
                                    BlackPixel( gpDisplay, screen_num ) );

                    nX1 = nX2 + gnWindowWidth - 1;
                    nY1 = nY2;
                    XDrawLine( gpDisplay, gaWin, gaGC, nX1, nY1, nX2, nY2 );

                    nX2 = nX1;
                    nY2 = nY1 - gnWindowHeight + 1;
                    XDrawLine( gpDisplay, gaWin, gaGC, nX1, nY1, nX2, nY2 );

                    XCopyArea( gpDisplay, aImage, gaWin,
                               aCopyGC, 0, 0,
                               nWidth, nHeight, 1 + IMAGE_OFFSET, 1 + IMAGE_OFFSET );
                    DrawProgress( gnLastPercent );
                }

                break;
        }
    }

    return 1;
}

/*****************************************************************************/
/* getFullPath */
/*****************************************************************************/

BOOL __getFullPath(const char* pszFilename, char* pszPath, unsigned long MaxLen)
{
    int   n, nBufSize;
    char* pBuffer;
    char* pDir;
    struct stat status;
    struct stat root;
    struct stat parent;
    char  Path[PATH_MAX + 1];

    pDir = strdup(pszFilename);

    /* check if path has a trailing '/', so it should specify a directory, */
        /* or if last component doesn't exist or is not a directory. So in any case */
    /* of this the last component should be remove before checking the path */
    if ((pDir[strlen(pDir) - 1] == '/') ||
        (stat(pDir, &status) < 0) || (! S_ISDIR(status.st_mode)))
    {
        char* pFile;

        if ((pFile = strrchr(pDir, '/')) != NULL)
        {
            *pFile++ = '\0';
            STRNCPY( Path, pFile, sizeof(Path) );
            STRNCAT( Path, "/", sizeof(Path) );
        }
        else
        {
            STRNCPY( Path, pDir, sizeof(Path) );
            STRNCAT( Path, "/", sizeof(Path) );
            free(pDir);
            pDir = strdup(".");
        }

        if ((strlen(pDir) > 0) &&
            ((stat(pDir, &status) < 0) || (! S_ISDIR(status.st_mode))))
        {
            free(pDir);
            return (FALSE);
        }
    }
    else
        Path[0] = '\0';

    if ((n = pathconf(pDir, _PC_PATH_MAX)) < 0)
        n = PATH_MAX + 1;

    nBufSize = n+1;
    pBuffer = (char *)malloc((n + 1) * sizeof(char));
    STRNCPY( pBuffer, pDir, nBufSize );

    stat("/", &root);

    STRNCAT( pBuffer, "/.", nBufSize );
    stat(pBuffer, &status);
    STRNCAT( pBuffer, ".", nBufSize );

    while ((status.st_dev != root.st_dev) || (status.st_ino != root.st_ino))
    {
        DIR*           dir;
        struct dirent* entry;

        if (((dir = opendir(pBuffer)) == NULL) ||
            (stat(pBuffer, &parent) < 0))
        {
            if ( dir ) closedir( dir );
            free(pDir);
            free(pBuffer);

            return (FALSE);
        }

        if (status.st_dev == parent.st_dev)
        {
            do
            {
                if ((entry = readdir(dir)) == NULL)
                {
                    closedir( dir );
                    free(pDir);
                    free(pBuffer);

                    return (FALSE);
                }
            }
            while (entry->d_ino != status.st_ino);
        }
        else
        {
            /*
             * if this point is a mount point we have to check
             * each entry, because the inode number in the directory
             * is for the parent directory, not for the mounted file
             */
            size_t nFullLen = (strlen(pBuffer) + PATH_MAX + 1) * sizeof(char);
            size_t nNameLen;
            char* full = (char *)malloc( nFullLen );
            char* name;

            STRNCPY( full, pBuffer, nFullLen );
            STRNCAT( full, "/", nFullLen );
            name = full + strlen(full);
            nNameLen = nFullLen - strlen(full);

            do
            {
                if ((entry = readdir(dir)) == NULL)
                {
                    free(full);

                    closedir( dir );
                    free(pDir);
                    free(pBuffer);

                    return (FALSE);
                }

                if ((entry->d_name[0] == '.') && ((entry->d_name[1] == '\0') ||
                    ((entry->d_name[1] == '.') && (entry->d_name[2] == '\0'))))
                    continue;

                STRNCPY( name, entry->d_name, nNameLen );

                if (stat(full, &parent) < 0)
                    continue;
            }
            while ((parent.st_ino != status.st_ino) || (parent.st_dev != status.st_dev));

            free(full);
        }

        STRNCAT( Path, entry->d_name, sizeof(Path) );
        STRNCAT( Path, "/", sizeof(Path) );

        closedir(dir);

        stat(pBuffer, &status);
        STRNCAT( pBuffer, "/..", nBufSize );
    }

    free(pDir);
    free(pBuffer);

    if (strlen(Path) < MaxLen)
    {
        int  n;
        char *p, *l;

        for (p = Path + strlen(Path), l = p; p >= Path; p--)
        {
            if (*p == '/')
            {
                n = l - (p + 1);
                memcpy(pszPath, p + 1, n);
                pszPath += n;
                *pszPath++ = '/';
                l = p;
            }
        }

        n = l - (p + 1);
        memcpy(pszPath, p + 1, n);
        pszPath += n;
        *pszPath = '\0';

        return (TRUE);
    }

    return (FALSE);
}

/*****************************************************************************/
/* ConvertXpm */
/*****************************************************************************/

typedef int bool;

#define true 1
#define false 0

void ConvertXpm( Display* pDisplay, char *xpm[], Pixmap* aPixmap, Pixmap* aMask, int* nWidth, int* nHeight )
{
	int nColors, nCharsPerPixel;
	XColor *pColors;
	char *pColorAlias;
	int nElement = 0,nColor = 0,i,nX,nY;
	char pColorString[256];
	bool bTransparent = false;
	XGCValues aValues;
    GC aMonoGC;

    int nScreen			= DefaultScreen( pDisplay );
    int nDepth			= DefaultDepth( pDisplay, nScreen );
    Colormap aColormap	= DefaultColormap( pDisplay, nScreen );
    Window aRoot		= DefaultRootWindow( pDisplay );
    GC aGC				= DefaultGC( pDisplay, nScreen );

	sscanf( xpm[ nElement++ ], "%d%d%d%d", nWidth, nHeight,
			&nColors, &nCharsPerPixel );
#if OSL_DEBUG_LEVEL > 1
	fprintf( stderr, "ConvertXpm: converting width = %d height = %d ncolors = %d chars_per_pixel = %d\n", *nWidth, *nHeight, nColors, nCharsPerPixel );
#endif
	nColor  = 0;
	pColors = (XColor*)malloc( sizeof( XColor ) * nColors );
	pColorAlias = (char*)malloc( nColors * nCharsPerPixel );
	while( nElement <= nColors )
	{
		char* pLine = xpm[nElement++];
		char* pStart = pLine + nCharsPerPixel;
		while( *pStart && ( pStart[0] != 'c' || ! isspace( pStart[1] ) ) )
			pStart++;
		if( *pStart )
		{
			sscanf( pStart,"c %s", pColorString);
			if( strncasecmp( pColorString, "None", 4 ) )
			{
				XAllocNamedColor( pDisplay,
								  aColormap,
								  pColorString, &pColors[nColor], &pColors[nColor] );
				strncpy( &pColorAlias[nColor*nCharsPerPixel],
						 pLine, nCharsPerPixel );
				nColor++;
			}
		}
	}
	nColors = nColor+1;

	*aPixmap = XCreatePixmap( pDisplay,
                              aRoot,
                              *nWidth, *nHeight,
                              nDepth );
	XSetForeground( pDisplay,
					aGC,
					BlackPixel( pDisplay, nScreen ) );
	XFillRectangle( pDisplay,
                    *aPixmap,
                    aGC,
					0,0,*nWidth,*nHeight );

	*aMask   = XCreatePixmap( pDisplay, aRoot,
                              *nWidth, *nHeight, 1 );

	aValues.foreground = 0xffffffff;
	aValues.function = GXclear;
	aMonoGC = XCreateGC( pDisplay, *aMask,
                         GCFunction|GCForeground, &aValues );

	XFillRectangle( pDisplay, *aMask, aMonoGC,
					0,0, *nWidth, *nHeight );
	aValues.function   = GXset;
	XChangeGC( pDisplay, aMonoGC, GCFunction, &aValues );

	for( nY=0; nY < *nHeight; nY++ )
	{
		char *pRun = xpm[ nElement+nY ];
		for( nX=0; nX < *nWidth; nX++ )
		{
			// get color number
			nColor = 0;
			while( nColor < nColors &&
				   strncmp( pRun, &pColorAlias[nColor*nCharsPerPixel],
							nCharsPerPixel ) )
				nColor++;
			if( nColor < nColors )
			{
				XSetForeground( pDisplay,
                                aGC,
								pColors[ nColor ].pixel );
				XDrawPoint( pDisplay,
							*aPixmap,
                            aGC,
							nX, nY );

				XDrawPoint( pDisplay,
							*aMask, aMonoGC, nX, nY );
			}
			else
			{
				bTransparent = true;
			}
			pRun += nCharsPerPixel;
		}
	}
	free( pColors );
	free( pColorAlias );
	XFreeGC( pDisplay, aMonoGC );

	if( ! bTransparent )
	{
#if OSL_DEBUG_LEVEL > 1
		fprintf( stderr, "ConvertXpm: keine Transparenz -> keine Maske\n" );
#endif
		XFreePixmap( pDisplay, *aMask );
		*aMask = None;
	}
}

/********************************/
/* ---      DrawProgress    --- */
/********************************/

void DrawProgress( long nPercent )
{
    if ( nPercent > 100 )
        nPercent = 100;
    else if ( nPercent < 0 )
        nPercent = 0;

    if ( m_bUseX )
    {
        int nX, nY;
        unsigned int nWidth, nHeight;

        XColor   aColor;
        Colormap aColorMap	= DefaultColormap( gpDisplay, screen_num );

        if ( nPercent <= gnLastPercent )
            return;

        gnLastPercent = nPercent;

        nX = gnWindowWidth - PROGRESS_OFFSET - PROGRESS_WIDTH - 1;
        nY = ( ( gnWindowHeight - PROGRESS_OFFSET ) / 2 ) - 1;
        nHeight = PROGRESS_HEIGHT;
        nWidth = PROGRESS_WIDTH * nPercent / 100;

        XAllocNamedColor( gpDisplay, aColorMap, "#000080", &aColor, &aColor );
        XSetForeground( gpDisplay, gaGC, aColor.pixel );
        XFillRectangle( gpDisplay, gaWin, gaGC, nX, nY, nWidth, nHeight );

        nWidth   = PROGRESS_WIDTH;

        XAllocNamedColor( gpDisplay, aColorMap, "black", &aColor, &aColor );
        XSetForeground( gpDisplay, gaGC, aColor.pixel );
        XDrawRectangle( gpDisplay, gaWin, gaGC, nX, nY, nWidth, nHeight );

        XFlush( gpDisplay );
    }
    else
    {
        if ( ( nPercent == 0 ) && ( gnLastPercent == -1 ) )
        {
            gnLastPercent = 0;
            printf( "\nInitializing installation program" );
            return;
        }

        nPercent = nPercent / 5;

        if ( nPercent <= gnLastPercent )
            return;

        gnLastPercent = nPercent;
        printf( "." );

        if ( nPercent == 20 )
            printf( "\n" );
        else
            fflush( stdout );
    }
}

/* ----------------------------------------------------------------------------- */

unsigned short WildcardMatch( const char *pWild, const char *pStr )
{
    int pos=0;
    int flag=0;

    while ( *pWild || flag )
    {
        switch (*pWild)
        {
        case '?':
            if ( *pStr == '\0' )
                return 0;
            break;
        default:
            if ( (*pWild == '\\') && ((*(pWild+1)=='?') || (*(pWild+1) == '*')) )
                pWild++;
            if ( *pWild != *pStr )
                if ( !pos )
                    return 0;
                else
                    pWild += pos;
            else
                break;          // ACHTUNG laeuft unter bestimmten
                                // Umstaenden in den nachsten case rein!!
        case '*':
            while ( *pWild == '*' )
                pWild++;
            if ( *pWild == '\0' )
                return 1;
            flag = 1;
            pos  = 0;
            if ( *pStr == '\0' )
                return ( *pWild == '\0' );
            while ( *pStr && *pStr != *pWild )
            {
                if ( *pWild == '?' )
                {
                    pWild++;
                    while ( *pWild == '*' )
                        pWild++;
                }
                pStr++;
                if ( *pStr == '\0' )
                    return ( *pWild == '\0' );
            }
            break;
        }
        if ( *pWild != '\0' )
            pWild++;
        if ( *pStr != '\0' )
            pStr++;
        else
            flag = 0;
        if ( flag )
            pos--;
    }
    return ( *pStr == '\0' ) && ( *pWild == '\0' );
}

/* ----------------------------------------------------------------------------- */

BOOL CopyFilesWithWildcard( const char* _pSourceDir,
                            const char* _pDestDir,
                            const char* _pWildcard,
                            BOOL bSizeOnly )
{
    DIR*			dirp;
    struct dirent*	dp = NULL;
    char            pDir[ __MAX_PATH ];
    BOOL            bFound = FALSE;
    BOOL            bNoErr = TRUE;
    int             nLen = 0;

    STRNCPY( pDir, _pSourceDir, sizeof(pDir) );
    
    if ( nLen = CheckForSlash( _pWildcard ) )
    {
        STRNCAT( pDir, "/", sizeof(pDir) ); 

        if ( sizeof(pDir) > strlen(pDir) + nLen-1 )
            strncat( pDir, _pWildcard, nLen-1 );
        else
            return FALSE;
    }

    dirp = opendir( pDir );

    while( bNoErr && dirp && ( dp = readdir(dirp) ) )
    {
        if ( strcmp( dp->d_name, "." ) == 0 || strcmp( dp->d_name, ".." ) == 0 )
            continue;
        else if( WildcardMatch( _pWildcard+nLen, dp->d_name) )
        {
            bFound = TRUE;
            bNoErr = CopyFile( pDir, _pDestDir, dp->d_name, bSizeOnly );
        }
    }

    if ( dirp )
        closedir(dirp);

    return bFound && bNoErr;
}

/* ----------------------------------------------------------------------------- */
int ReadLine( FILE* _pFile, char* _pBuffer, int _nMaxSize )
{
    BOOL bLineStart = TRUE;
    int i = 0;

    if ( _pFile )
    {
        --_nMaxSize;

        while( !feof( _pFile ) && _nMaxSize )
        {
            char c = fgetc( _pFile );

            if( c == (char)0xFF )
                continue;
            if ( bLineStart && ( c == ' ' || c == '\t' ) )
                continue;

            if( c == 0x0a || c == 0x0d )
			{
				/* read the next char, too, because dos/windows uses 2 bytes for line ending
                */
                c = fgetc(_pFile);
                if( c != 0x0a && c != 0x0d )
                {
                    ungetc(c, _pFile);
                }

                /* ok, found a line, lets return. */
                break;
            }
            bLineStart = FALSE;
            _pBuffer[i++] = c;
            --_nMaxSize;
        }
    }
    _pBuffer[i] = '\0';
    return i;
}

/* ----------------------------------------------------------------------------- */
BOOL GetHomeDir( char * _pHomeDir, size_t nBufSize )
{
	char *pEnv = getenv( "HOME" );
    if ( !pEnv )
        return FALSE;

	STRNCPY( _pHomeDir, pEnv, nBufSize );

    return TRUE;
}

/* ----------------------------------------------------------------------------- */
/* this function looks in the given profile for a given section, searches
   that section for a given key and returns the value
*/
BOOL ReadStringFromProfile( const char* _pProfile, const char* _pSection,
                            const char* _pKeyName, char* _pValue,
                            size_t nBufSize )
{
    int  i, nLen;
    BOOL bValueFound = FALSE;
    BOOL bSectionFound = FALSE;
    char strSection[260];
    char strLineBuf[MAX_LINEBUF];

    FILE* pFile = fopen( _pProfile, "r" );

    if ( !pFile )
        return FALSE;

    STRNCPY( strSection, "[", sizeof(strSection) );
    STRNCAT( strSection, _pSection, sizeof(strSection) );
    STRNCAT( strSection, "]", sizeof(strSection) );

    while( !feof( pFile ) )
    {
        nLen = ReadLine( pFile, strLineBuf, MAX_LINEBUF );

        if ( strLineBuf[0] == '[' )     // a new section starts
        {
            if ( bSectionFound )        // we allready searched the section, so we
                break;                  // can stop here

            if ( strncmp( strSection, strLineBuf, strlen( strSection ) ) == 0 )
            {
                bSectionFound = TRUE;   // we found the desired section so we can
                continue;               // continue with the next line
            }
        }

        if ( bSectionFound && strncmp( strLineBuf, _pKeyName, strlen( _pKeyName ) ) == 0 )
        {
            // Searched Value found, search for '=' skiping whitespaces
            i = strlen( _pKeyName );

            while ( iswspace( strLineBuf[i] ) && ( i < nLen ) )
                ++ i;

            if ( ( i < nLen ) && ( strLineBuf[i] == '=' ) )
            {
                // stop more searching, because found value.
                STRNCPY( _pValue, strLineBuf + i + 1, nBufSize );
                bValueFound = TRUE;
                break;
            }
        }
    }

    fclose(pFile);

    return bValueFound;
}

/* ----------------------------------------------------------------------------- */
/* this functions changes file URLs to unix pathes
*/
void unEscapeStr( const char *_pStrURL, char* _pStr )
{
    int nLen = strlen( _pStrURL );
    int i = 0;
    int j = 0;
    int nEscapeValue = 0;

    while ( _pStrURL[i] == ' ' )                        // remove leading spaces
        i++;

    if ( strncmp( _pStrURL + i, "file://", 7 ) == 0 )  // remove file:///
        i += 7;

    while ( i < nLen )                                  // change escaped characters
    {
        char c = _pStrURL[i++];

        if ( c == '%' )
        {
            nEscapeValue = ( ( _pStrURL[i] - '0' ) << 4) | ( _pStrURL[i + 1] - '0' );
            c = (char)nEscapeValue;
            i += 2;
        }
        else if ( c == 0x0d || c == 0x0a )
        {
            continue;
        }
        _pStr[j++] = c;
    }

    _pStr[j] = '\0';
}

/* -----------------------------------------------------------------------------
*/
BOOL ReadInstDBInf( const char* _strInstDBInfPath, char* strOfficePath )
{
	char cLineBuf[ MAX_LINEBUF ];
	char cInstDBInfFile[ __MAX_PATH ];
	BOOL bFound = FALSE;
	FILE* pFile;
    
    STRNCPY( cInstDBInfFile, _strInstDBInfPath, sizeof(cInstDBInfFile) );
    STRNCAT( cInstDBInfFile, "/", sizeof(cInstDBInfFile) );
    STRNCAT( cInstDBInfFile, INSTDBINF_FILE, sizeof(cInstDBInfFile) );
    
    pFile = fopen( cInstDBInfFile, "r" );

	if ( pFile )
	{
		while( !feof( pFile ) )
		{
			ReadLine( pFile, cLineBuf, MAX_LINEBUF );
            if ( strncmp( cLineBuf, "SourcePath", 10 ) == 0 )
                break;
            if ( strcmp( cLineBuf, "End" ) == 0 )
                return bFound;
		}
		if (!feof(pFile))
		{
			char* sStartQuote = strchr( cLineBuf, '\"' );
			char* sEndQuote = strrchr( cLineBuf, '\"' );

            if ( sStartQuote < sEndQuote )
            {
                strncpy( strOfficePath, sStartQuote+1, sEndQuote - sStartQuote - 1 );
                strOfficePath[ sEndQuote - sStartQuote - 1 ] = '\0';
				bFound = TRUE;
            }
		}
	}
	return bFound;
}

/* ----------------------------------------------------------------------------- */
/* this function looks for the path to the given office (_pKey )
*/
BOOL FindInstallPath( const char* _pKey, char* _pInstallPath, size_t nBufSize )
{
	char strPath    [ __MAX_PATH ];
	char strPathTmp [ __MAX_PATH ];
	char strProfile [ __MAX_PATH ];
    DIR* pDir = NULL;
    	
    if ( ! GetHomeDir( strProfile, sizeof(strProfile) ) )
        return FALSE;

	STRNCAT( strProfile, "/", sizeof(strProfile) );
	STRNCAT( strProfile, SVERSION_FILE, sizeof(strProfile) );

	if ( ReadStringFromProfile( strProfile, "Versions", _pKey, strPath, sizeof(strPath) ) )
	{
		if ( ! GetSystemPathFromFileURL( strPath, _pInstallPath ) )
            unEscapeStr( strPath, _pInstallPath );
        
        STRNCPY( strPathTmp, _pInstallPath, sizeof(strPathTmp) );
        
        if ( ReadInstDBInf( strPathTmp, _pInstallPath ) )
        {
            STRNCAT( _pInstallPath, "/program", nBufSize );
            pDir = opendir( _pInstallPath );
        }

        if ( !pDir )
        {
            STRNCPY( _pInstallPath, strPathTmp, nBufSize );
            STRNCAT( _pInstallPath, "/program", nBufSize );
        
            pDir = opendir( _pInstallPath );
        }

        if ( !pDir )
            return FALSE;
        else
            closedir( pDir );

        return TRUE;
	}

    return FALSE;
}

/* ----------------------------------------------------------------------------- */

BOOL HandlePatch( ArchDirectory* pBigDir, BOOL* pIsPatch, BOOL bSizeOnly )
{
    char    pFileName[ __MAX_PATH ];
    char    pSourcePath[ __MAX_PATH ];
    char    pFontPath[ __MAX_PATH ];
    char    pLine[ MAX_LINEBUF ];
    char*   pKey;
    FILE*   pFile;
    int     nLen;
    BOOL    bErr = FALSE;

    if ( pBigDir )
        *pIsPatch = ArchDirectory_GetFile( pBigDir, PATCH_FILE, strTmpPath );
    else
        *pIsPatch = CopyFile( strInitPath, strTmpPath, PATCH_FILE, FALSE );

    if ( !(*pIsPatch) )
        return TRUE;

    /* open patch file */
    STRNCPY( pFileName, strTmpPath, sizeof(pFileName) );
    STRNCAT( pFileName, "/", sizeof(pFileName) );
    STRNCAT( pFileName, PATCH_FILE, sizeof(pFileName) );

    pFile = fopen( pFileName, "r" );

    if (!pFile)
        return FALSE;

    /* get key to patched office */
    nLen = ReadLine( pFile, pLine, MAX_LINEBUF);

    if ( !nLen )
    {
        fprintf( stderr, "\nerror in patch file '%s'", pFileName );
        fclose( pFile );
        return FALSE;
    }

    if ( strDestPath[0] != '\0' )
    {
        DIR* pDir = NULL;
        STRNCPY( pSourcePath, strDestPath, sizeof(pSourcePath) );
        STRNCAT( pSourcePath, "/program", sizeof(pSourcePath) );
        pDir = opendir( pSourcePath );
        if ( !pDir )
        {
            fprintf( stderr, "\nPath to office installation is invalid '%s'!\n", strDestPath );
            fclose( pFile );
            return FALSE;
        }
        else
            closedir( pDir );
    }
    else
    {
        pKey = strtok( pLine, ";" );
        while ( pKey )
        {
            if ( FindInstallPath( pKey, pSourcePath, sizeof(pSourcePath) ) )
                break;
            else
                pKey = strtok( NULL, ";" );
        }

        if ( !pKey )
        {
            fprintf( stderr, "\nStarOffice 6.1 / StarSuite 6.1 was not found on your system." );
            fprintf( stderr, "\nTo specify the folder manually use:\n" );
            fprintf( stderr, "\n%s -patch <path to installation>\n", progname );
            fclose( pFile );
            return FALSE;
        }
    }

    /* copy files from old office */
    while ( !feof( pFile ) )
    {
        nLen = ReadLine( pFile, pFileName, __MAX_PATH );

        if ( nLen > 0 )
        {
            if ( strchr( pFileName, '*' ) || strchr( pFileName, '?' ) )
                bErr = !CopyFilesWithWildcard( pSourcePath, strTmpPath,
                                               pFileName, bSizeOnly );
            else
                bErr = !CopyFile( pSourcePath, strTmpPath, pFileName, bSizeOnly );

            if ( bErr && !bSizeOnly )
            {
                fprintf( stderr, "\nerror copying file '%s'\nfrom: %s\nto: %s\n",
                         pFileName, pSourcePath, strTmpPath );
                break;
            }
        }
    }

    fclose( pFile );

    if ( !bErr && !bSizeOnly )
    {
        /* we need to set the SAL_FONTPATH_PRIVATE to the font directory of
           the installed office, so the setup can use this font without copying
           them first into the temp directory
        */
        STRNCPY( pFontPath, "SAL_FONTPATH_PRIVATE=", sizeof(pFontPath) );
        
        if ( sizeof(pFontPath) > strlen(pFontPath) + strlen(pSourcePath) )
        {
            strncat( pFontPath, pSourcePath, strlen( pSourcePath )-8 );
            STRNCAT( pFontPath, "/share/fonts/truetype", sizeof(pFontPath) );

            if ( putenv( strdup( pFontPath ) ) != 0 )
            {
                bErr = TRUE;
                fprintf( stderr, "\ncould not set fontpath: '%s'", pFontPath );
            }
        }
    }

    return !bErr;
}

typedef unsigned long oslFileError;
typedef oslFileError (SAL_CALL * getSystemPathFromFileURL_Func)( rtl_uString *, rtl_uString **);
typedef void (SAL_CALL * uString_newFromAscii_Func)( rtl_uString **, const sal_Char * );
typedef void (SAL_CALL * uString2String_Func)( rtl_String **, const sal_Unicode *,
                                               sal_Int32, rtl_TextEncoding, sal_uInt32 );
typedef rtl_TextEncoding(SAL_CALL * getThreadTextEncoding_Func)();
typedef void (SAL_CALL * string_release_Func) ( rtl_String * str );
typedef void (SAL_CALL * uString_release_Func) ( rtl_uString * str );

BOOL GetSystemPathFromFileURL( const char* strURL, char* strSystemPath )
{
	// Load library
    BOOL bRet = FALSE;
    void *hLib;
	char strSALInTemp[ __MAX_PATH ];

	STRNCPY( strSALInTemp, strTmpPath, sizeof(strSALInTemp) );
	STRNCAT( strSALInTemp, "/", sizeof(strSALInTemp) );
    STRNCAT( strSALInTemp, strSalLibName, sizeof(strSALInTemp) );
	
	hLib = dlopen( strSALInTemp, RTLD_LAZY );

    if ( hLib )
	{
        rtl_uString* pSystemPath    = NULL;
        rtl_uString* pFileURL       = NULL;
        rtl_String*  pReturn        = NULL;

        getThreadTextEncoding_Func      getTextEncoding;
        getSystemPathFromFileURL_Func   getSystemPathFromFileURL;
        uString_newFromAscii_Func       uString_newFromAscii;
        uString2String_Func             uString2String;
        string_release_Func             string_release;
        uString_release_Func            uString_release;

        uString2String          = dlsym( hLib, "rtl_uString2String");
        uString_newFromAscii    = dlsym( hLib, "rtl_uString_newFromAscii");
        getSystemPathFromFileURL = dlsym( hLib, "osl_getSystemPathFromFileURL");
        getTextEncoding         = dlsym( hLib, "osl_getThreadTextEncoding");
        string_release          = dlsym( hLib, "rtl_string_release");
        uString_release         = dlsym( hLib, "rtl_uString_release");

        if ( !uString_newFromAscii || !getSystemPathFromFileURL ||
             !uString2String || !getTextEncoding || !string_release ||
             !uString_release )
        {
#ifndef LINUX
            dlclose( hLib );
#endif
            return bRet;
        }

        uString_newFromAscii( &pFileURL, strURL );
        if ( getSystemPathFromFileURL( pFileURL, &pSystemPath ) == 0 )
        {
            uString2String( &pReturn, pSystemPath->buffer,
                            pSystemPath->length,
                            getTextEncoding(),
                            OUSTRING_TO_OSTRING_CVTFLAGS );
            strncpy( strSystemPath, pReturn->buffer, pReturn->length );
            strSystemPath[ pReturn->length ] = '\0';
            uString_release( pSystemPath );
            string_release( pReturn );
            bRet = TRUE;
        }
        uString_release( pFileURL );
	}
    else
    {
        char *pError = dlerror();
        fprintf( stderr, "\ncould not load dll: '%s'", pError );
    }

#ifndef LINUX
    if ( hLib ) dlclose( hLib );
#endif

    return bRet;
}


