#!/bin/sh
#*************************************************************************
#
#   $RCSfile: setup.sh,v $
#
#   $Revision: 1.19.14.1 $
#
#   last change: $Author: rt $ $Date: 2003/09/17 08:32:35 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

# resolve installation directory
if [ -h "$0" ] ; then
	sd_basename=`basename $0`
	sd_script=`ls -l "$0" | sed "s/.*${sd_basename} -> //g"`
	cd "`dirname "$0"`"
	cd "`dirname "$sd_script"`"
else
	sd_script="$0"
	cd "`dirname "$0"`"
fi

sd_archive_path="`pwd`"

sd_setup_binary=setup.bin
sd_platform=`uname -s`
sd_release=`uname -r`

if [ `basename "$sd_archive_path"` = "program" ]; then
	sd_fonts=`dirname "$sd_archive_path"`
    sd_fonts="$sd_fonts/share/fonts/truetype"
else
    sd_fonts="$sd_archive_path"
fi
if [ "x$SAL_FONTPATH_PRIVATE" = "x" ]; then 
    SAL_FONTPATH_PRIVATE="$sd_fonts"
else
    SAL_FONTPATH_PRIVATE="$sd_fonts;$SAL_FONTPATH_PRIVATE"
fi
export SAL_FONTPATH_PRIVATE

if [ -x "./sopatchlevel.sh" ]; then
        ./sopatchlevel.sh
        if [ $? -eq 1 ]; then
                exit 0;
        fi
fi

# disable File Locking for NFS2 Linux Servers
#STAR_PROFILE_LOCKING_DISABLED=1
#export STAR_PROFILE_LOCKING_DISABLED

SAL_IGNOREXERRORS=1
export SAL_IGNOREXERRORS

# initialize (extend) library search path with installation directory
# LD_LIBRARY_PATH=${LD_LIBRARY_PATH:+${LD_LIBRARY_PATH}:}${sd_archive_path}
case $sd_platform in
  Linux)
     # @@@ <NOTE> @@@
     # Please remove '.' as soon as all to be registered UNO components...
     # 1) link with a runpath of '$ORIGIN', and
     # 2) link against 'libcppuhelper$(COMID).so.$(UDK_MAJOR)'
     #    instead of obsolete 'libcppuhelper$(UDK_MAJOR)$(COMID).so'
     # @@@ </NOTE> @@@
	 LD_LIBRARY_PATH=${sd_archive_path}:.:$LD_LIBRARY_PATH
	 export LD_LIBRARY_PATH
	 ;;
  Darwin)
	 DYLD_LIBRARY_PATH=${sd_archive_path}:.:$DYLD_LIBRARY_PATH
	 export DYLD_LIBRARY_PATH
	 ;;
  IRIX*)
	 LD_LIBRARYN32_PATH=${sd_archive_path}:$LD_LIBRARY32_PATH
	 export LD_LIBRARYN32_PATH
	 ;;
  *)
	 LD_LIBRARY_PATH=${sd_archive_path}:$LD_LIBRARY_PATH
	 export LD_LIBRARY_PATH
	 ;;
esac

# extend the library search path for java
if [ -x "./javaldx" ]; then
    java_ld_library_path=`./javaldx`
    if [ "$java_ld_library_path" != "" ] ; then
        case $sd_platform in
            Darwin)
                DYLD_LIBRARY_PATH=${DYLD_LIBRARY_PATH}:${java_ld_library_path}
                ;;
            IRIX*)
                LD_LIBRARYN32_PATH=${LD_LIBRARYN32_PATH}:${java_ld_library_path}
                ;;
            *)
                LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${java_ld_library_path}
                ;;
        esac
    fi
fi

#
# parse command line arguments
#

for DUMMY in ${1+"$@"}
do
	case $1 in

	?display) 
		if [ $# -lt 2 ]; then
			err "$1 option requires a display name"
	    fi
		DISPLAY=$2
		export DISPLAY
		shift; shift
		;;
	*)
		break;
		;;
	esac
done

# execute setup binary
exec "$sd_archive_path/$sd_setup_binary" "$@"

