/*************************************************************************
 *
 *  $RCSfile: agenda.cxx,v $
 *
 *  $Revision: 1.82 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/01 14:46:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#include <ctype.h>
#include <string.h>
#include <unistd.h>

#ifndef _REGISTRY_REGISTRY_HXX_
#include <registry/registry.hxx>
#endif

#ifndef _SV_CONFIG_HXX
#include <tools/config.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _FILEARCH_HXX
#include <svtools/filearch.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCHANGESBATCH_HPP_
#include <com/sun/star/util/XChangesBatch.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/lang/XSingleServiceFactory.hpp>

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#include "agenda.hxx"
#include "script.hxx"
#include "action.hxx"
#include "environ.hxx"
#include "zipfile.hxx"
#include "sicustom.hxx"
#include "sihelp.hxx"
#include "fields.hxx"
#include "critical.hxx"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::registry;
using namespace ::com::sun::star::beans;
using namespace ::cppu;

using rtl::OUString;

SV_DECL_PTRARR_SORT( SortedDirList, SiDeleteDirAction*, 1, 3 );
SV_IMPL_OP_PTRARR_SORT( SortedDirList, SiDeleteDirAction* );

// SiLogStream ----------------------------------------------------------------

SiFileStream& SiLogStream::Success(BOOL b)
{
	*this << (b ? "OK  " : "ERR ");
	if( m_bFlush ) Flush();
	return *this;
}

// SiAgenda ----------------------------------------------------------------

SiAgenda::SiAgenda()
	: m_pEnv					(NULL),
	  m_bStopRunning	  		(FALSE),
	  m_eInstallMode	  		(IM_INVALID),
	  m_eInstallSubMode 		(ISM_INVALID),
	  m_bInstallFromNet 		(FALSE),
	  m_bRecoverOnly	  		(FALSE),
	  m_lBytesToCopy    		(0),
	  m_lBytesCopied    		(0),
	  m_lBytesToUnzip   		(0),
	  m_lBytesUnzipped  		(0),
	  m_nRunProgress    		(0),
	  m_nCurrentDiskNo  		(0),
	  m_pCurrentAction  		(NULL),
	  m_pCScript				(NULL),
	  m_bCompleteHelpReorg      (FALSE),
	  m_pCallback				(new SiAgendaCallback),
	  m_bWebMode				(FALSE),
	  m_bSwitchMode			    (FALSE)
{
}

SiAgenda::~SiAgenda()
{
	JoinActionLists();
	for( USHORT i = 0; i < m_ActionList.Count(); i++ )
		delete m_ActionList.GetObject(i);
	for( USHORT x = 0; x < m_ActionProcList.Count(); x++ )
		delete m_ActionProcList.GetObject(x);

	CloseAllOpenProfiles();
	m_aUnoComponents.Clear();

	if( m_pCallback )
		delete m_pCallback;
}

void SiAgenda::SetCallback(SiAgendaCallback* pNew)
{
	if( m_pCallback )
		delete m_pCallback;
	m_pCallback = pNew;
}

// SiAgenda-Handles --------------------------------------------------------

void SiAgenda::AddCanceledFileSize(ULONG nSize, BOOL bUnzip)
{
	if( bUnzip )
		m_lBytesUnzipped += nSize;
	else
		m_lBytesCopied += nSize;

	if( m_pCallback )
		m_pCallback->ProgressTransfer( GetPercentage() );
}

void SiAgenda::AddCanceledFileSize(SiFile* pFile, BOOL bUnzip)
{
	ULONG nSize = pFile->IsArchive()? pFile->GetArchiveSize() : pFile->GetSize();
	AddCanceledFileSize( nSize, bUnzip );
}

IMPL_LINK(SiAgenda,CopyProgressHdl,FileCopier*,pFileCopier)
{
	static ULONG lLast = 0;
	if( pFileCopier->GetBytesCopied() < lLast )
		lLast = 0;

	m_lBytesCopied += pFileCopier->GetBytesCopied() - lLast;

	if( m_pCallback )
		m_pCallback->ProgressTransfer( GetPercentage() );

	lLast = pFileCopier->GetBytesCopied();
	return !m_bStopRunning;
}

IMPL_LINK(SiAgenda,UnzipProgressHdl,SiZipFile*,pZipFile)
{
	static ULONG lLast = 0;

	if( pZipFile->GetBytesWritten() < lLast )
		lLast = 0;

	m_lBytesUnzipped += pZipFile->GetBytesWritten() - lLast;

	if( m_pCallback )
		m_pCallback->ProgressTransfer( GetPercentage() );

	lLast = pZipFile->GetBytesWritten();
	return TRUE;
}

int SiAgenda::GetPercentage() const
{
	if ((m_lBytesToCopy + m_lBytesToUnzip) == 0)
		return m_nRunProgress; // nicht Byte sondern aktionsorientiert

	double dTotal = m_lBytesToCopy + m_lBytesToUnzip + 1;
	double pu     = double(m_lBytesToUnzip) / dTotal;
	double pc     = double(m_lBytesToCopy)  / dTotal;

	return int (100.0 *
		(
			//      ---------- Anteil ----------------             * Gewichtung
			(double(m_lBytesCopied)   / double(m_lBytesToCopy+1))  * pc
		  + (double(m_lBytesUnzipped) / double(m_lBytesToUnzip+1)) * pu
		));
}

BOOL SiAgenda::RequestDisk( ByteString const& CurrentFile, BOOL bNoWarn, int nDiskNo, ByteString const& DiskName )
{
	if (InstallFromNet())
		return TRUE;

	SiDirEntry aSourceFile( m_pEnv->GetSourcePath() );

	#ifdef UNX
		if (CurrentFile.GetTokenCount( '/' ))
			aSourceFile += CurrentFile.GetToken( 0, '/' );
		else
	#endif

	aSourceFile += CurrentFile;

	if( aSourceFile.Exists() )
		return TRUE;
	else if( bNoWarn )
	{
		return FALSE;
	}

	GetLogfile() << "change disk: " << long(nDiskNo) << endl;

	ByteString aSource	= m_pEnv->GetSourcePath();
	int    nDigits	= 0;

	if( !aSource.Len() )
		return FALSE;

	while (isdigit(aSource.GetChar(USHORT(aSource.Len()-1-nDigits))))
		nDigits++;

	if (nDigits>0)
	{
		aSource  = aSource.Erase(0,aSource.Len()-nDigits); // Ziffern abschneiden
		aSource += ByteString(nDiskNo);

		SiDirEntry Check  = aSource;
				 Check += CurrentFile;

		if (Check.Exists())
		{
			m_pEnv->SetSourcePath(aSource);
			m_nCurrentDiskNo = nDiskNo;
			return TRUE;
		}
	}

	// Benutzer solange zum Diskettenwechsel auffordern, bis
	// die richtige Disk eingelegt worden ist.
	BOOL bFound  = FALSE;
	BOOL bSearch = TRUE;
	BOOL bFirst  = TRUE;

	while (bSearch   // suchen ...
	   &&  !bFound)	 // ... solange nicht gefunden
	{
		ByteString aFile;

		if (!bFirst)	// beim ersten Mal wird die Datei noch nicht vermisst
			aFile = CurrentFile;

		bFirst = FALSE;

		SiAgendaCallback::ChangedDisk eCD = SiAgendaCallback::CHANGEDDISK_IGNORE;
		if( m_pCallback )
			eCD = m_pCallback->ChangeDisk(aFile, nDiskNo, DiskName);

		switch( eCD )
		{
			case SiAgendaCallback::CHANGEDDISK_CANCEL:
			{
				GetLogfile() << "*** canceled *** ";
				m_bStopRunning = TRUE;
				bSearch = FALSE;
				break;
			}

			case SiAgendaCallback::CHANGEDDISK_IGNORE:
			{
				GetLogfile() << "missing: " << CurrentFile << endl;
				bSearch = FALSE;
				break;
			}

			default:
			case SiAgendaCallback::CHANGEDDISK_OK:
			{
				SiDirEntry Check  = m_pEnv->GetSourcePath();
						 Check += CurrentFile;

				if (Check.Exists())
				{
					bFound = TRUE;
					m_nCurrentDiskNo = nDiskNo;
				}
			}
		}
	}

	return bFound;
}

// --------------------------------------------------------

Config* SiAgenda::GetOpenProfile(const ByteString& rFileName)
{
	for( USHORT i = 0; i < m_aOpenProfiles.Count(); i++ )
	{
		ProfileEntry* pEntry = m_aOpenProfiles.GetObject(i);
		if( pEntry->aFileName == rFileName )
			return pEntry->pConfig;
	}

	ProfileEntry* pNew = new ProfileEntry;
	pNew->aFileName	= rFileName;
	pNew->pConfig	= new Config( UniString(rFileName, osl_getThreadTextEncoding()) );
	if (pNew->pConfig)
	{
		pNew->pConfig->SetLineEnd(GetSystemLineEnd());
	}	

	m_aOpenProfiles.Insert( pNew, LIST_APPEND );

	return pNew->pConfig;
}

void SiAgenda::CloseAllOpenProfiles()
{
	for( USHORT i = 0; i < m_aOpenProfiles.Count(); i++ )
	{
		ProfileEntry* pEntry = m_aOpenProfiles.GetObject(i);
		pEntry->pConfig->Flush();
		delete pEntry->pConfig;
		delete pEntry;
	}
	m_aOpenProfiles.Clear();
}

// --------------------------------------------------------
// Sortierung fuer Installation
// --------------------------------------------------------

void SiAgenda::Add( SiWebAction* pAction )
{
	((SiWebAgenda*)this)->AddWeb( pAction );
}

void SiAgenda::Add( SiMakeDirAction* pAction )
{
    ULONG nIndex = m_ActionSlot1.Count();
    ULONG nLen = pAction->GetName().Len();
    while ( nIndex )
    {
        SiMakeDirAction* pTmp = (SiMakeDirAction*) m_ActionSlot1.GetObject( nIndex-1 );
        if ( pTmp->GetType() != AT_MAKEDIR )
            break;
        if ( pTmp->GetName().Len() < nLen )
            break;
        nIndex--;
    }

    m_ActionSlot1.Insert( pAction, nIndex );
}

void SiAgenda::Add(SiTransferAction* pAction)
{
	if (pAction->FromDataCarrier())
	{
		m_ActionSlot2.Insert(pAction,LIST_APPEND);

		for (USHORT i=(USHORT)m_ActionSlot2.Count()-1; i>0; i--)
		{
			if (m_ActionSlot2.GetObject(i-1)->GetDiskNo()
			 >  m_ActionSlot2.GetObject(i)->GetDiskNo())
			{
				SiTransferAction* pTemp = m_ActionSlot2.GetObject(i-1);
				m_ActionSlot2.Replace(m_ActionSlot2.GetObject(i),i-1);
				m_ActionSlot2.Replace(pTemp,i);
			}
		}
	}
	else
	{
		m_ActionSlot4.Insert(pAction,0UL);
	}
}

void SiAgenda::Add(SiAppendAction* pAction)
{
	USHORT i         = 0;
	BOOL   bPosFound = FALSE;

	while (i<m_ActionSlot3.Count()
	   && !bPosFound)
	{
		if (pAction->GetBaseFile() == m_ActionSlot3.GetObject(i)->GetBaseFile()
		&&  pAction->GetPart()     <  m_ActionSlot3.GetObject(i)->GetPart())
			bPosFound = TRUE;
		else
			i++;
	}
	m_ActionSlot3.Insert(pAction,i);
}

void SiAgenda::Add(SiActiveXAction* pAction)
{
	if( pAction->IsRegister() )
		m_ActionSlot5.Insert( pAction, LIST_APPEND );
	else
		m_ActionSlot1.Insert( pAction, 0UL );
}

void SiAgenda::Add(SiUnixCreateSoftLinkAction* pAction)
{
	m_ActionSlot4.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiShortcutAction* pAction)
{
	m_ActionSlot4.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiMakeFolderAction* pAction)
{
	m_ActionSlot4.Insert(pAction,0UL);
}

void SiAgenda::Add(SiMakeFolderItemAction* pAction)
{
	m_ActionSlot4.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiInstallFontAction* pAction)
{
	m_ActionSlot4.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiProfileItemAction* pAction)
{
	if( m_eInstallSubMode == ISM_DELETE )
	{
		m_ActionSlot1.Insert(pAction,0UL);
		return;
	}

	ULONG  i         = m_ActionSlot6.Count();
	BOOL   bPosFound = FALSE;

	// Stelle zum Einfuegen suchen (von hinten)
	while (i>0
	   && !bPosFound)
	{
		if (pAction->GetOrder() >= m_ActionSlot6.GetObject(i-1)->GetOrder())
			bPosFound = TRUE;
		else
			i--;
	}
	// assert: wenn pPosFound dann mu vor i eingefuegt werden
	//         sonst i = Count() (ans Ende haengen)
	// an der richtigen Stelle einfgen
	m_ActionSlot6.Insert(pAction,i);
}

void SiAgenda::Add(SiStarRegistryAction* pAction)
{
	if( m_eInstallSubMode == ISM_DELETE )
	{
		m_ActionSlot1.Insert(pAction,0UL);
		return ;
	}
	m_ActionSlot4.Insert(pAction, LIST_APPEND);
}

void SiAgenda::Add(SiRunProcedureAction* pAction, BOOL bExecBefore)
{
	if( bExecBefore )
		m_ActionSlot1.Insert( pAction,0UL );
	else
		m_ActionSlot5.Insert( pAction,LIST_APPEND );
}

void SiAgenda::Add(SiRegistryItemAction* pAction)
{
	m_ActionSlot4.Insert(pAction,0UL);
}

void SiAgenda::Add(SiOs2RegisterClassAction* pAction)
{
	// Classes vor Templates registrieren
	m_ActionSlot4.Insert(pAction,0UL);
}

void SiAgenda::Add(SiOs2CreateTemplateAction* pAction)
{
	// Templates nach Classes erzeugen
	m_ActionSlot4.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiOs2JoinEAsAction* pAction)
{
	m_ActionSlot4.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiMacAddApplicationAction* pAction)
{
	m_ActionSlot4.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiConfigurationAction* pAction)
{
	m_CfgActionSlot.Insert( pAction, LIST_APPEND );
}

// --------------------------------------------------------
// Sortierung fuer Deinstallation
// --------------------------------------------------------

void SiAgenda::Add(SiDeleteDirAction* pAction)
{
	m_ActionSlot5.Insert(pAction,LIST_APPEND);
}

void SiAgenda::Add(SiDeleteFileAction* pAction, BOOL bLink )
{
	m_ActionSlot4.Insert(pAction, bLink ? 0UL : LIST_APPEND);
}

void SiAgenda::Add(SiUnregisterAction* pAction)
{
	m_ActionSlot1.Insert(pAction,0UL);
}

void SiAgenda::Add(SiDeleteFolderAction* pAction)
{
	// Container zuletzt loeschen
	m_ActionSlot1.Insert(pAction,LIST_APPEND);
}

void SiAgenda::JoinActionLists()
{
	USHORT i=0;

	// 1. anhaengen
	for (i=0; i<m_ActionSlot1.Count(); i++)
		m_ActionList.Insert(m_ActionSlot1.GetObject(i),LIST_APPEND);

	for (i=0; i<m_ActionSlot2.Count(); i++)
		m_ActionList.Insert(m_ActionSlot2.GetObject(i),LIST_APPEND);

	for (i=0; i<m_ActionSlot3.Count(); i++)
		m_ActionList.Insert(m_ActionSlot3.GetObject(i),LIST_APPEND);

	for (i=0; i<m_ActionSlot4.Count(); i++)
		m_ActionList.Insert(m_ActionSlot4.GetObject(i),LIST_APPEND);

	for (i=0; i<m_ActionSlot6.Count(); i++)
		m_ActionList.Insert(m_ActionSlot6.GetObject(i),LIST_APPEND);

	// hier stehen die AfterInst ProcedureObjecte, sie sollen nach den
	// Profiles ausgefuehrt werden.
	for (i=0; i<m_ActionSlot5.Count(); i++)
	{
		if( m_eInstallSubMode == ISM_DELETE )
			m_ActionList.Insert( m_ActionSlot5.GetObject(i),LIST_APPEND );
		else
		{
			// zur Installation stehen in Slot 5 nur Proc's, die in eine
			// etxtra liste die spter abgearbeitet werden soll.
			m_ActionProcList.Insert( m_ActionSlot5.GetObject(i),LIST_APPEND );
		}
	}

	// 2. loeschen
	m_ActionSlot1.Clear();
	m_ActionSlot2.Clear();
	m_ActionSlot3.Clear();
	m_ActionSlot4.Clear();
	m_ActionSlot5.Clear();
	m_ActionSlot6.Clear();
}

void SiAgenda::SortDir4Uninstall()
{
	// Die List der Directorys sortieren und optimieren, wegen der aus
	// einem ZIP-File erzeugten MakeDirAction's
	SortedDirList* pList = new SortedDirList;
	for( USHORT nIdx = 0; nIdx < m_ActionSlot5.Count(); ++nIdx )
	{
		SiDeleteDirAction* pAction = (SiDeleteDirAction*)m_ActionSlot5.GetObject(nIdx);
		if( !pList->C40_PTR_INSERT( SiDeleteDirAction, pAction ) )
		{
			delete pAction;
			pAction = NULL;
		}
	}
	m_ActionSlot5.Clear();

	for( USHORT nSortIdx = 0; nSortIdx < pList->Count(); ++nSortIdx )
		m_ActionSlot5.Insert( (*pList)[nSortIdx], LIST_APPEND );
	delete pList;
}

ByteString SiAgenda::GetSourceDir(SiFile const* pFile) const
{
	if( InstallFromNet() )
	{
		SiDirectory* pDir = (SiDirectory*) pFile->GetNetDirectory();
		SiDirectory* pLangRef = (SiDirectory*) pDir->GetLangRef( pFile->GetLanguage() );
		if( pLangRef )
		{
			pLangRef->JoinWithParent();
			return pLangRef->GetName();
		}
		return pDir->GetName();
	}
	return "";
}

ByteString SiAgenda::GetDestDir(SiFile const* pFile, BOOL bWebMode ) const
{
	SiDirectory* pDir = (SiDirectory*) (GetInstallMode() == IM_NETWORK ?
						pFile->GetNetDirectory() : pFile->GetDirectory());

	SiDirectory* pLangRef = (SiDirectory*) pDir->GetLangRef( pFile->GetLanguage() );
	if( pLangRef )
	{
		pLangRef->JoinWithParent();
		return bWebMode ? pLangRef->GetWebName() : pLangRef->GetName();
	}

	return bWebMode? pDir->GetWebName() : pDir->GetName();
}

ByteString SiAgenda::GetSourceName(SiFile const* pFile) const
{
	if (InstallFromNet())
		return pFile->GetName();   // wurde entpacked
	else
		if( pFile->IsSetupZip() )
			return pFile->GetName();
	return pFile->GetPackedName(); // gibt Name zurueck, wenn PackedName leer ist
}

// Agenda-Erzeugung ----------------------------------------------------

BOOL SiAgenda::CreateForInstall
(
	SiModule	*pModule,
	SiDoneList	&aDoneList,
	SiCompiledScript &rCS,
	BOOL		 bRecover
)
{
	// Dieses Modul bearbeiten
	BOOL bProcess = FALSE;

	if( !m_pEnv->IsFirstInstallation() && pModule->IsInstalled() )
		bProcess = bRecover;
	else // nicht installiert
		bProcess = pModule->IsSelected();

	if( bProcess )
	{
		Install(pModule,aDoneList,rCS);
		pModule->SetInstalled(); // wird installiert

		// Damit das Modul nicht ausversehen bei Uninstall
		// gleich wieder deinstalliert wird:
		pModule->Select( SiModule::THIS_UNSEL_IGNORE_INST );

		if( m_pEnv->GetInstallType() == IT_CHANGE )
			pModule->SetChangeInstall();
	}

	// rekursiv durch alles durchgehen
	SiModuleList const* pModuleList = pModule->GetModuleList();

	for (USHORT i=0; i < pModuleList->Count(); i++)
	{
		CreateForInstall(pModuleList->GetObject(i),aDoneList, rCS, bRecover);
	}
	return TRUE;
}

BOOL SiAgenda::CreateForUninstall
(
	SiModule	*pModule,
	SiDoneList	&aDoneList,
	SiCompiledScript &rCS
)
{
	// Dieses Modul bearbeiten
	if( pModule->IsInstalled()
	&&  pModule->IsSelected() ) // soll Uninstalliert werden
	{
		Uninstall(pModule,aDoneList,rCS);

		if( m_eInstallSubMode != ISM_DELETE )
			pModule->SetInstalled(FALSE); // wird deinstalliert

		// Damit das Modul nicht ausversehen bei Install
		// gleich wieder installiert wird:
		pModule->Select( SiModule::THIS_UNSEL_IGNORE_INST );

		if( m_pEnv->GetInstallType() == IT_CHANGE )
			pModule->SetChangeUninstall();
	}

	// rekursiv durch alles durchgehen
	SiModuleList const* pModuleList = pModule->GetModuleList();
	for (USHORT i=0; i < pModuleList->Count(); i++)
	{
		CreateForUninstall(pModuleList->GetObject(i),aDoneList, rCS);
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void SiAgenda::GetCustoms( BOOL bBefore, SiActionList* pActions,
						   SiModule* pModule, SiModule* pRoot,
						   SiDoneList& rDoneList, SiCompiledScript& rCS )
{
	SiInstallType eTyp = m_pEnv->GetInstallType();

	if( pModule->GetCustomList().Count() )
	{
		for(USHORT i = 0; i < pModule->GetCustomList().Count(); ++i)
		{
			BOOL bInsert	= FALSE;
			BOOL bInstall	= TRUE;
			SiCustom* pItem = pModule->GetCustomList().GetObject(i);

			if( rDoneList.Find(pItem->GetDllName()) != 0 )
				continue;

			switch( eTyp )
			{
			case IT_MAXIMAL:
			case IT_USERDEFINED:
			case IT_MINIMAL:
			case IT_WORKSTATION:
				if( (bBefore  && pItem->ExecInstBefore() && pModule->IsSelected()) ||
					(!bBefore && pItem->ExecInstAfter()  && pModule->IsInstalled()) )
				{
					bInsert	 = TRUE;
					bInstall = TRUE;
				}
				break;

			case IT_CHANGE:
				if( (bBefore && pItem->ExecInstBefore() && !pModule->IsInstalled() && pModule->IsSelected()) ||
					(!bBefore && pItem->ExecInstAfter() && pModule->IsInstalled() && pModule->HasChangeInstall()) ) {
					bInsert	 = TRUE;
					bInstall = TRUE;
				}
				else
				if( (bBefore && pItem->ExecDeInstBefore() && pModule->IsInstalled() && pModule->IsSelected()) ||
					(!bBefore && pItem->ExecDeInstAfter() && pModule->HasChangeUninstall()) ) {
					bInsert	 = TRUE;
					bInstall = FALSE;
				}
                else if ( ( bBefore && pItem->ExecModifyBefore() ) ||
                          ( !bBefore && pItem->ExecModifyAfter() ) )
                {
                    bInsert	 = TRUE;
                    bInstall = TRUE;
                }
				break;

			case IT_UNINSTALL:
				if( (bBefore  && pItem->ExecDeInstBefore() && pModule->IsInstalled()) ||
					(!bBefore && pItem->ExecDeInstAfter()  && pModule->IsInstalled()) )
				{
					bInsert	 = TRUE;
					bInstall = FALSE;
				}
				break;
            case IT_RECOVER:
				if( pItem->ExecRepair() && pModule->IsInstalled() )
				{
					bInsert	 = TRUE;
					bInstall = TRUE;
				}
				break;
			}

			if( bInsert &&
			  ((pItem->RunAtStandalone() && GetInstallMode() == IM_STANDALONE)	||
			   (pItem->RunAtNetwork() && ((GetInstallMode() == IM_NETWORK) || (GetInstallMode() == IM_APPSERVER)) ) ||
			   (pItem->RunAtWorkstation() && GetInstallMode() == IM_WORKSTATION)) )
			{
				SiFile* pFile = SiHelp::FindFileByName( rCS.GetRootModule(), pItem->GetDllName() );
				if( pFile )
				{
					SiDirEntry aEntry;
					if( eTyp == IT_WORKSTATION )
						aEntry += m_pEnv->GetSourcePath();
					else
						aEntry += m_pEnv->GetDestPath();

					aEntry += pFile->GetDirectory()->GetName();
					aEntry.ToAbs();

					SiCustomAction* pNew = new SiCustomAction( this, pRoot, pItem->GetDllName(), aEntry.GetFull(), bInstall, bBefore, pItem, &rCS );
                    if ( eTyp == IT_CHANGE )
                        pNew->SetModify();
                    else if ( eTyp == IT_RECOVER )
                        pNew->SetRepair();

                    if ( pItem->KeepAlive() )
                        pNew->SetKeepAlive();

					pActions->Insert(pNew, LIST_APPEND);
					rDoneList.Insert(pItem->GetDllName(), 1);
				}
			}
		}
	}

	SiModuleList const* pModuleList = pModule->GetModuleList();
	for(USHORT x=0; x < pModuleList->Count(); ++x)
		GetCustoms( bBefore, pActions, pModuleList->GetObject(x), pRoot, rDoneList, rCS );
}

void SiAgenda::CallCustoms( SiCompiledScript &rCS, BOOL bBefore )
{
    // We don't want to execute custom modules of the old installation
    // when updating to a new version ( because there are many possible
    // pitfalls like incompatible DLLs or resources, which can't be found )
    if ( ( GetInstallSubMode() == ISM_DELETE ) &&
         m_pEnv->IsUpdateOldVersion() )
        return;

    m_pEnv->SetInstallFromNet( InstallFromNet() );

	SiDoneList		aDoneList(1017);
	SiModule* 		pModule = rCS.GetRootModule();
	SiActionList	aCustomList;

	GetCustoms(bBefore, &aCustomList, pModule, pModule, aDoneList, rCS);

	for( USHORT i = 0; i < aCustomList.Count(); ++i )
	{
		SiCustomAction* pAction = (SiCustomAction*)aCustomList.GetObject(i);
		if( !m_bStopRunning && pAction->Execute(*m_pEnv) )
		{
			if( pAction->InternalError() )
				continue;

			SiCustomModuleList* pList = pAction->GetCustomModuleList();
			for( USHORT x = 0; x < pList->Count(); ++x )
			{
				SiCustomModuleInfo* pModInf = pList->GetObject(x);
				SiModule* pMod = PTR_CAST(SiModule,rCS.Find(pModInf->GetModuleID()));
				if( !pMod )
				{
					DBG_ASSERT(!this, "Module aus CustomModuleInfo konne nicht gefunden werden!");
					continue;
				}
				if( pMod->IsSelected() != pModInf->IsSelected() )
					if( pModInf->IsSelected() )
						pMod->Select(SiModule::ALL_SEL);
					else
						pMod->Select(SiModule::ALL_UNSEL);
			}
		}
		else
			m_bStopRunning = TRUE;

		delete pAction;
	}
	aCustomList.Clear();

    // The java custom proc might have changed the installed java
    UpdateATToolSupport();
}

///////////////////////////////////////////////////////////////////////////////

BOOL SiAgenda::CreateForInstall( SiCompiledScript &rCS, SiInstallMode eInstallMode, BOOL bInstallFromNet )
{
	m_bStopRunning		= FALSE;
	m_eInstallMode		= eInstallMode;
	m_bInstallFromNet	= bInstallFromNet || eInstallMode == IM_WORKSTATION;

	m_pEnv->InitReplacement( m_eInstallMode );
	CallCustoms(rCS, TRUE);

	SiDoneList aDoneList(1017);

	if( m_eInstallMode == IM_WORKSTATION )
		Install( rCS.GetDirectoryList(), aDoneList );

	BOOL bSuccess = CreateForInstall(rCS.GetRootModule(), aDoneList, rCS);

	JoinActionLists();
	return bSuccess;
}

BOOL SiAgenda::CreateForUninstall( SiCompiledScript &rCS, SiInstallSubMode eInstallSubMode )
{
	m_bStopRunning		= FALSE;
	m_eInstallSubMode	= eInstallSubMode;
	m_eInstallMode		= rCS.GetInstallation()->GetInstallMode();

	m_pEnv->InitReplacement( m_eInstallMode );
	CallCustoms(rCS, TRUE);
	SiDoneList aDoneList(1017);

	Uninstall(rCS.GetDirectoryList(), aDoneList);

	rCS.GetRootModule()->Select(SiModule::ALL_SEL);

	BOOL bSuccess = CreateForUninstall(rCS.GetRootModule(),aDoneList,rCS);
 	SortDir4Uninstall();
	JoinActionLists();

	return bSuccess;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SWITCH Context bei IT_CHANGE
//

#define SWT_FIRST_INST(module, list, type) { \
		Si##list##List const& rLst = module->Get##list##List(); \
		for( USHORT i = 0; i < rLst.Count(); ++i ) \
		{ \
			type* pdecl = rLst.GetObject(i); \
			if( pdecl->HasLangRef() ) \
			{ \
				SiLangCtxList& rCtxLst = m_pEnv->GetSwitchContextInstall();  \
				for( USHORT ctxidx = 0; ctxidx < rCtxLst.Count(); ++ctxidx ) \
				{ \
					LanguageContext* pDelCtx = rCtxLst.GetObject(ctxidx); \
					type* pLangDecl = (type*) pdecl->GetLangRef( pDelCtx->nLanguage ); \
					if( pLangDecl )

#define SWT_FIRST_DEL(module, list, type) { \
		Si##list##List const& rLst = module->Get##list##List(); \
		for( USHORT i = 0; i < rLst.Count(); ++i ) \
		{ \
			type* pdecl = rLst.GetObject(i); \
			if( pdecl->HasLangRef() ) \
			{ \
				SiLangCtxList& rCtxLst = m_pEnv->GetSwitchContextDelete();  \
				for( USHORT ctxidx = 0; ctxidx < rCtxLst.Count(); ++ctxidx ) \
				{ \
					LanguageContext* pDelCtx = rCtxLst.GetObject(ctxidx); \
					type* pLangDecl = (type*) pdecl->GetLangRef( pDelCtx->nLanguage ); \
					if( pLangDecl )

#define SWT_MIDDLE_DELETE \
					{ \
						pLangDecl->JoinWithParent(); \
						if( pDelCtx->isDoc && !pDelCtx->isProg && !pLangDecl->IsDocLang() ) \
							continue; \
						Uninstall( pLangDecl, aDoneList ); \
					} \


#define SWT_MIDDLE_DELETE_SCR \
					{ \
						pLangDecl->JoinWithParent(); \
						if( pDelCtx->isDoc && !pDelCtx->isProg && !pLangDecl->IsDocLang() ) \
							continue; \
						Uninstall( pLangDecl, aDoneList, rCS ); \
					} \

#define SWT_MIDDLE_INSTALL \
					{ \
						pLangDecl->JoinWithParent(); \
						if( pLangDecl->IsDocLang() && !pDelCtx->isDoc ) \
							continue; \
						Install( pLangDecl, aDoneList ); \
					} \

#define SWT_MIDDLE_INSTALL_SCR \
					{ \
						pLangDecl->JoinWithParent(); \
						if( pLangDecl->IsDocLang() && !pDelCtx->isDoc ) \
							continue; \
						Install( pLangDecl, aDoneList, rCS ); \
					} \

#define SWT_END \
				} \
			} \
		}}

#define SWITCH_DELETE(module, list, type) \
	SWT_FIRST_DEL(module, list, type) \
	SWT_MIDDLE_DELETE \
	SWT_END

#define SWITCH_DELETE_SCR(module, list, type) \
	SWT_FIRST_DEL(module, list, type) \
	SWT_MIDDLE_DELETE_SCR \
	SWT_END

#define SWITCH_INSTALL(module, list, type) \
	SWT_FIRST_INST(module, list, type) \
	SWT_MIDDLE_INSTALL \
	SWT_END

#define SWITCH_INSTALL_SCR(module, list, type) \
	SWT_FIRST_INST(module, list, type) \
	SWT_MIDDLE_INSTALL_SCR \
	SWT_END

void SiAgenda::DeleteSwitchContext(SiModule* pModule, SiDoneList& aDoneList, SiCompiledScript& rCS, BOOL bRecursive)
{
	if( !bRecursive || pModule->IsInstalled() && pModule->HasLangRef() )
	{
		SiFileList const& rFLst = pModule->GetFileList();
		for( USHORT i = 0; i < rFLst.Count(); ++i )
		{
			SiFile* pFile = rFLst.GetObject(i);
			if( pFile->HasLangRef() )
			{
				SiLangCtxList& rCtxLst = m_pEnv->GetSwitchContextDelete();
				for( USHORT ctxidx = 0; ctxidx < rCtxLst.Count(); ++ctxidx )
				{
					LanguageContext* pDelCtx = rCtxLst.GetObject(ctxidx);
					SiFile* pLangDecl = (SiFile*) pFile->GetLangRef( pDelCtx->nLanguage );
					if( pLangDecl && ((pDelCtx->isDoc  && pFile->IsDocLang()) ||
									  (pDelCtx->isProg && !pFile->IsDocLang())) )
					{
						pLangDecl->JoinWithParent();
						Uninstall( pLangDecl, aDoneList );
					}
				}
			}
		}

		SWITCH_DELETE		( pModule, Dir, SiDirectory );
		SWITCH_DELETE		( pModule, FolderItem, SiFolderItem );
		SWITCH_DELETE		( pModule, Profile, SiProfile );

		SiLangCtxList& rCtxLst = m_pEnv->GetSwitchContextDelete();
		for( USHORT ctxidx = 0; ctxidx < rCtxLst.Count(); ++ctxidx )
		{
			LanguageContext* pDelCtx = rCtxLst.GetObject(ctxidx);
		}

		SWITCH_DELETE		( pModule, ProfileItem, SiProfileItem );


		SWITCH_DELETE_SCR	( pModule, StarRegistryItem, SiStarRegistryItem );
		SWITCH_DELETE		( pModule, RegistryItem, SiRegistryItem );
		SWITCH_DELETE		( pModule, RegistryArea, SiRegistryArea );
		SWITCH_DELETE		( pModule, Os2Class, SiOs2Class );
		SWITCH_DELETE		( pModule, Os2Template, SiOs2Template );
	}

	if( bRecursive )
	{
		SiModuleList const* pModuleList = pModule->GetModuleList();
		for (USHORT nModIdx = 0; nModIdx < pModuleList->Count(); nModIdx++ )
			DeleteSwitchContext( pModuleList->GetObject(nModIdx), aDoneList, rCS );
	}
}

void SiAgenda::InstallSwitchContext(SiModule* pModule, SiDoneList& aDoneList, SiCompiledScript& rCS, BOOL bRecursive)
{
 	if( !bRecursive || pModule->IsInstalled() && pModule->HasLangRef() )
	{
		SiFileList const& rFLst = pModule->GetFileList();
		for( USHORT i = 0; i < rFLst.Count(); ++i )
		{
			SiFile* pFile = rFLst.GetObject(i);
			if( pFile->HasLangRef() && !pFile->IsCompHelpFile() )
			{
				SiLangCtxList& rCtxLst = m_pEnv->GetSwitchContextInstall();
				for( USHORT ctxidx = 0; ctxidx < rCtxLst.Count(); ++ctxidx )
				{
					LanguageContext* pDelCtx = rCtxLst.GetObject(ctxidx);
					SiFile* pLangDecl = (SiFile*) pFile->GetLangRef( pDelCtx->nLanguage );
					if( pLangDecl && ((pDelCtx->isDoc  && pFile->IsDocLang()) ||
									  (pDelCtx->isProg && !pFile->IsDocLang())) )
					{
						pLangDecl->JoinWithParent();
						Install( pLangDecl, aDoneList, rCS );
					}
				}
			}
		}

		SWITCH_INSTALL		( pModule, Dir, SiDirectory );
		SWITCH_INSTALL		( pModule, FolderItem, SiFolderItem );
//		SWITCH_INSTALL_SCR	( pModule, Profile, SiProfile );

		SWITCH_INSTALL		( pModule, ProfileItem, SiProfileItem );
/*		SiProfileItemList const& rLst = pModule->GetProfileItemList();
		for( i = 0; i < rLst.Count(); ++i )
		{
			SiProfileItem* pdecl = rLst.GetObject(i);
			if( pdecl->HasLangRef() )
			{
				SiLangCtxList& rCtxLst = m_pEnv->GetSwitchContextInstall();
				for( USHORT ctxidx = 0; ctxidx < rCtxLst.Count(); ++ctxidx )
				{
					LanguageContext* pDelCtx = rCtxLst.GetObject(ctxidx);
					if( pdecl->GetSection() == "User" )
						int i = 0;

					SiProfileItem* pLangDecl = (SiProfileItem*) pdecl->GetLangRef( pDelCtx->nLanguage );
					if( pLangDecl )
					{
						pLangDecl->JoinWithParent();
						if( pLangDecl->IsDocLang() && !pDelCtx->isDoc )
							continue;
						Install( pLangDecl, aDoneList );
					}
				}
			}
		}
*/

		SWITCH_INSTALL_SCR	( pModule, StarRegistryItem, SiStarRegistryItem );
		SWITCH_INSTALL		( pModule, RegistryItem, SiRegistryItem );
//		SWITCH_INSTALL_SCR	( pModule, RegistryArea, SiRegistryArea );
		SWITCH_INSTALL		( pModule, Os2Class, SiOs2Class );
		SWITCH_INSTALL		( pModule, Os2Template, SiOs2Template );
	}

	if( bRecursive )
	{
		SiModuleList const* pModuleList = pModule->GetModuleList();
		for (USHORT nModIdx = 0; nModIdx < pModuleList->Count(); nModIdx++ )
			InstallSwitchContext( pModuleList->GetObject(nModIdx), aDoneList, rCS );
	}
}

BOOL SiAgenda::CreateForChange( SiCompiledScript& rCS, SiInstallSubMode eInstallSubMode )
{
	SiDoneList aDoneList(1017);
	BOOL	   bSuccess = FALSE;

	m_bStopRunning	  = FALSE;
	m_eInstallMode	  = rCS.GetInstallation()->GetInstallMode();
	m_bInstallFromNet = rCS.GetInstallation()->InstallFromNet();

	switch (eInstallSubMode)
	{
		case ISM_ADD:
			bSuccess = CreateForInstall(rCS.GetRootModule(),aDoneList,rCS);
			break;

		case ISM_DELETE:
		{
			bSuccess = CreateForUninstall(rCS.GetRootModule(),aDoneList,rCS);
		}	break;

		case ISM_CHANGE:
		{
			m_eInstallSubMode = ISM_CHANGE;
			if( m_pEnv->GetSwitchContextDelete().Count() )
				DeleteSwitchContext( rCS.GetRootModule(), aDoneList, rCS );

			m_pEnv->InitReplacement( m_eInstallMode );
			CallCustoms(rCS, TRUE);

			bSuccess = CreateForUninstall(rCS.GetRootModule(),aDoneList,rCS);
			SortDir4Uninstall();

			m_eInstallSubMode = ISM_INVALID;
			JoinActionLists();

			SiDoneList aInstall_DoneList(1017);
			bSuccess = bSuccess && CreateForInstall(rCS.GetRootModule(),aInstall_DoneList,rCS);

			if( m_pEnv->GetSwitchContextInstall().Count() )
				InstallSwitchContext( rCS.GetRootModule(), aInstall_DoneList, rCS );

			break;
		}

		default:
			DBG_ERROR("SiAgenda::CreateForChange() unknown mode");
			break;
	}

	JoinActionLists();
	return bSuccess;
}

BOOL SiAgenda::CreateForRecover( SiCompiledScript &rCS )
{
	SiDoneList aDoneList(1017);

	m_bStopRunning		= FALSE;
	m_eInstallMode		= rCS.GetInstallation()->GetInstallMode();
	m_bInstallFromNet	= rCS.GetInstallation()->InstallFromNet();

	EnableRecoverMode();

    m_pEnv->InitReplacement( m_eInstallMode );

	BOOL bSuccess = CreateForInstall(rCS.GetRootModule(),aDoneList, rCS, TRUE /* bRecover */);

	JoinActionLists();
	return bSuccess;
}

void SiAgenda::OpenLogfile( const ByteString& r )
{
	m_Logfile.Open( UniString(r, osl_getThreadTextEncoding()), STREAM_WRITE);
	m_Logfile.Seek(STREAM_SEEK_TO_END);
}

// =======================================================================
// Agenda - RUN
BOOL SiAgenda::Run(SiCompiledScript& rCS, SiInstallSubMode eInstallSubMode)
{
	SiDirEntry aDestPath	= m_pEnv->GetDestPath();
	SiDirEntry aLogfile 	= GetInstallMode() == IM_WORKSTATION? aDestPath :
						  SiDirEntry(rCS.GetSetupExePath(*m_pEnv));

	aLogfile.ToAbs();
	aLogfile += ByteString("setup.log");

	// warscheinlich existiert Zielpfad noch nicht
	if( !aDestPath.Exists() ) {
		SiMakeDirAction aMkDir( this, aDestPath.GetFull() );
		aMkDir.Execute( *m_pEnv );
	}
	if( !aLogfile.GetPath().Exists() ) {
		SiMakeDirAction aMkDir( this, ((const SiDirEntry&)aLogfile.GetPath()).GetFull() );
		aMkDir.Execute( *m_pEnv );
	}

	m_Logfile.Open(aLogfile.GetFullUni(), STREAM_WRITE);
	m_Logfile.Seek(STREAM_SEEK_TO_END);
	m_Logfile.m_bFlush = m_pEnv->IsAUSEStreamFlush();

	JoinActionLists();
	PrintHeader();

	SiDirectory* pOuterDir = (SiDirectory*) rCS.Find( "PREDEFINED_OUTERPATH" );
	if( pOuterDir ) pOuterDir->SetProperty( PROPERTY_HOSTNAME, m_pEnv->GetOuterDestPath() );
	m_pEnv->AddReplacement( "<outerpath>", m_pEnv->GetOuterDestPath(), OSL_GETTHREADTEXTENCODING );

	// Aktionsliste abarbeiten
	int nErrors = 0;
	m_pCScript = &rCS;

	// Beim Recovermode Aktionen herausfiltern, die
	// nicht ausgefuehrt werden duerfen.
	if( DoRecoverOnly() )
	{
		USHORT i;
		for( i = 0; i < m_ActionList.Count(); i++ )
		{
			SiAction* pAction = m_ActionList.GetObject(i);
			if( pAction->DoesTargetExist(*m_pEnv) )
            {
				BOOL bDoNotExecute = TRUE;

                // when a file has the ForceRepair flag set and when the environment
                // has this flag set, too ( which should only happen, when the setup
                // isn't executed inside the destination folder ) we will execute the
                // copy or unzip action.
                switch( pAction->GetType() )
				{
                    case AT_COPY : {
						SiCopyAction* pTAct = (SiCopyAction*) pAction;
						if( pTAct->GetSiFile() )
							bDoNotExecute = ! ( pTAct->GetSiFile()->IsForceRepair() &&
                                                m_pEnv->IsForceRepair() );
                        } break;
					case AT_UNZIP : {
						SiUnzipAction* pTAct = (SiUnzipAction*) pAction;
						if( pTAct->GetSiFile() )
							bDoNotExecute = ! ( pTAct->GetSiFile()->IsForceRepair() &&
                                                m_pEnv->IsForceRepair() );
                        } break;
				}

                if ( bDoNotExecute )
                    pAction->DoNotExecute();
            }
		}

		m_lBytesToCopy	= 0;
		m_lBytesToUnzip	= 0;

		// die Werte in der oberen Schleife abzuzaehlen war ungenau ???
		for( i = 0; i < m_ActionList.Count(); i++ )
		{
			SiAction* pAction = m_ActionList.GetObject(i);
			if( pAction->MayExecute() )
				switch( pAction->GetType() )
				{
					case AT_COPY : {
						SiCopyAction* pTAct = (SiCopyAction*) pAction;
						if( pTAct->GetSiFile() )
							m_lBytesToCopy += pTAct->GetSiFile()->GetSize();
					} break;
					case AT_UNZIP : {
						SiUnzipAction* pTAct = (SiUnzipAction*) pAction;
						if( pTAct->GetSiFile() ) {
							m_lBytesToUnzip +=	pTAct->GetSiFile()->IsArchive()?
												pTAct->GetSiFile()->GetArchiveSize() :
												pTAct->GetSiFile()->GetSize();
						}
					} break;
				}
		}
	}

	if( !m_ActionList.Count() )
	{
		m_nRunProgress = 99;
		if( m_pCallback )
			m_pCallback->ProgressTransfer( m_nRunProgress );
	}
	else
	for( USHORT i=0; i < m_ActionList.Count() && !m_bStopRunning; i++ )
	{
		m_pCurrentAction = m_ActionList.GetObject(i);
		m_nRunProgress   = (int)(((ULONG)i) * 100L / m_ActionList.Count());

		if( m_pCurrentAction->MayExecute() )
		{
			if( m_pCallback )
			{
				ByteString aMsg;
				switch( m_pCurrentAction->GetType() )
				{
					case AT_MAKEDIR:	aMsg = m_pEnv->GetDestPath();
										aMsg += "/";
										aMsg += ((SiMakeDirAction*)m_pCurrentAction)->GetName();
										break;

					case AT_RMDIR:		aMsg = m_pEnv->GetDestPath();
										aMsg += "/";
										aMsg += ((SiDeleteDirAction*)m_pCurrentAction)->GetName();
										break;

					case AT_COPY:		aMsg = m_pEnv->GetDestPath();
										aMsg += "/";
										aMsg += ((SiCopyAction*)m_pCurrentAction)->GetSiFile()->GetDirectory()->GetName();
										aMsg += "/";
										aMsg += ((SiCopyAction*)m_pCurrentAction)->GetSiFile()->GetName();
										break;

					case AT_UNZIP:		aMsg = m_pEnv->GetDestPath();
										aMsg += "/";
										aMsg += ((SiUnzipAction*)m_pCurrentAction)->GetSiFile()->GetDirectory()->GetName();
										aMsg += "/";
										aMsg += ((SiUnzipAction*)m_pCurrentAction)->GetSiFile()->GetName();
										break;

					case AT_DELETE:		if( ((SiDeleteFileAction*)m_pCurrentAction)->GetSiFile() )
										{
											aMsg = m_pEnv->GetDestPath();
											aMsg += "/";
											aMsg += ((SiDeleteFileAction*)m_pCurrentAction)->GetSiFile()->GetDirectory()->GetName();
											aMsg += "/";
											aMsg += ((SiDeleteFileAction*)m_pCurrentAction)->GetSiFile()->GetName();
										}
										else
											aMsg = ((SiDeleteFileAction*)m_pCurrentAction)->GetFilename();
										break;

					case AT_PROCEDURE:	aMsg = ((SiRunProcedureAction*)m_pCurrentAction)->GetProcname(); break;
					case AT_CUSTOM:		aMsg = ((SiCustomAction*)m_pCurrentAction)->GetModuleName(); break;

					case AT_HELP:
					case AT_ACTIVEX:
					case AT_REGUNO:
					case AT_REGISTER:
					case AT_UNREGISTER: break;

				}
				if( m_pCurrentAction->GetType() != AT_REGISTER )
					m_pCallback->ProgressAction( m_pCurrentAction->GetType(), GetPercentage(), aMsg );
			}

			if( !m_pCurrentAction->Execute(*m_pEnv) )
			{
				nErrors++;
				if( m_pCurrentAction->GetType() == AT_CUSTOM )
					m_bStopRunning = TRUE;
				else
				if( m_pCallback )
				{
					switch( m_pCallback->ExecutionError( m_pCurrentAction ) )
					{
						case SiAgendaCallback::EEA_CANCEL	:	m_bStopRunning = TRUE;		break;
						case SiAgendaCallback::EEA_RETRY	: 	i--;						break;
					}
				}
			}
		}
	}

	CloseAllOpenProfiles();

	if( !m_bStopRunning )
	{
		if( m_pEnv->GetResponseStep() != 2 )
		{
			try
			{
				/////////////////////////////////////////////////////
				// UNO_COMPONET gefaggte Dateien muessen bei
				// Erstinstallation und der Reparatur registriert werden.
				if( GetInstallMode() == IM_PATCH )
				{
					RegisterAllUnoComponets( rCS.GetRootModule() );
					RegisterExplicitUnoComponets( rCS );
					SiHelp::DisposeUNOImpl();
				}
				else if( (GetInstallMode() != IM_WORKSTATION) &&
						 (m_pEnv->IsFirstInstallation() || m_pEnv->GetInstallType() == IT_RECOVER) )
				{
					RegisterAllUnoComponets( rCS.GetRootModule() );
					SiHelp::DisposeUNOImpl();
				}
				else if( m_pEnv->GetInstallType() == IT_CHANGE )
				{
					RegisterListedUnoComponets();
					SiHelp::DisposeUNOImpl();
				}
			}
			catch (Exception const & e)
			{
				ByteString aMessage (
					UniString(e.Message),osl_getThreadTextEncoding());

				GetLogfile().Success(FALSE) << aMessage;
				Critical_Log( aMessage );

				return FALSE;
			}
		}

		/////////////////////////////////////////////////////
		// configuration
		if( m_CfgActionSlot.Count() )
		{
			if( m_pCallback )
				m_pCallback->StartRegister();

			try
			{
				SiDirEntry aApplicat(
					((m_pEnv->GetInstallType() == IT_WORKSTATION) ||
					 (m_eInstallMode == IM_WORKSTATION)) ?
					m_pEnv->GetSourcePath() : m_pEnv->GetDestPath() );

				aApplicat += ByteString("program");
				aApplicat += ByteString("types.rdb");
				aApplicat.ToAbs();

				aApplicat.GetPath().SetCWD();

				OUString regURL;
				osl::FileBase::getFileURLFromSystemPath(
					rtl::OStringToOUString(
						aApplicat.GetFull().GetBuffer(),
						osl_getThreadTextEncoding() ),
					regURL );

				// create path to the services.rdb from the types.rdb path
				OSL_ASSERT( regURL.lastIndexOf( '/' ) >= 0 );

				rtl::OUStringBuffer bufServices(
					regURL.copy( 0, regURL.lastIndexOf( '/' )+1 ) );
				bufServices.appendAscii("services.rdb");

				OUString strServices (bufServices.makeStringAndClear());

				// Note: can't use defaultBootstrap_InitialComponentContext(),
				// because $SYSBINDIR is wrong (and variables might be cached).
				Reference< XMultiServiceFactory > xORB (
					cppu::createRegistryServiceFactory(regURL, strServices , sal_True));
				if( xORB.is() )
				{
					Reference< XMultiServiceFactory > xUserCfgProvider;
					Reference< XMultiServiceFactory > xShareCfgProvider;

					// --------------------------------------------
					Sequence< Any > aCPArgs( 5 );
					sal_Int32 nArgs = 0;

					PropertyValue aPropVal;
                    aPropVal.Handle = -1;
                    aPropVal.State = PropertyState_DIRECT_VALUE;

					ByteString const aBasePath(
						m_pEnv->GetInstallType() == IT_WORKSTATION ||
						m_eInstallMode == IM_WORKSTATION ?
						m_pEnv->GetSourcePath() : m_pEnv->GetDestPath() );

					// - 1 -------------------------------------------
                    SiDirEntry aSharedPath( aBasePath );
					aSharedPath += ByteString("share");
					aSharedPath += ByteString("registry");
					aSharedPath.ToAbs();

					OUString const sSharedPath(
						aSharedPath.GetFull().GetBuffer(),
						aSharedPath.GetFull().Len(),
						osl_getThreadTextEncoding() );

                    OUString sSharedURL;
                    OSL_VERIFY(osl::File::getFileURLFromSystemPath(sSharedPath,sSharedURL) == osl::File::E_None);

                    aPropVal.Name = OUString::createFromAscii("DefaultLayerUrls");
					aPropVal.Value <<= sSharedURL;

					aCPArgs[nArgs++] <<= aPropVal;

					// - 2 ------------------------------------------
					OUString const sSchemaURL (
						sSharedURL + OUString::createFromAscii("/schema"));

                    aPropVal.Name = OUString::createFromAscii("SchemaDataUrl");
					aPropVal.Value <<= sSchemaURL;

					aCPArgs[nArgs++] <<= aPropVal;

					// HACK: Inhibit LDAP configuration 
					// - 3 ------------------------------------------
					OUString const sLocalBackend (
						OUString::createFromAscii(
							"com.sun.star.configuration.backend.LocalSingleBackend"));

                    aPropVal.Name = OUString::createFromAscii("BackendService");
					aPropVal.Value <<= sLocalBackend;

					aCPArgs[nArgs++] <<= aPropVal;

					// - 4 ------------------------------------------
					OUString const sNormalWrapper (
						OUString::createFromAscii (
							"com.sun.star.configuration.backend.OnlineBackend"));

                    aPropVal.Name = OUString::createFromAscii("BackendWrapper");
					aPropVal.Value <<= sNormalWrapper;

					aCPArgs[nArgs++] <<= aPropVal;

					// Don't use an offline cache 
					// - 5 ------------------------------------------

                    aPropVal.Name = OUString::createFromAscii("Offline");
                    aPropVal.Value <<= sal_False;

					aCPArgs[nArgs++] <<= aPropVal;

					// ----------------------------------------------

                    xShareCfgProvider.set(
                        xORB->createInstanceWithArguments(
                            OUString::createFromAscii(
                                "com.sun.star.configuration.AdministrationProvider"),
                            aCPArgs),
                        UNO_QUERY );

                    // ----------------------------------------------

                    if ( m_eInstallMode != IM_NETWORK )
                    {
						aCPArgs.realloc( nArgs + 2 );

						// - 1 ------------------------------------------
						SiDirEntry aUserPath( m_pEnv->GetDestPath() );
						aUserPath += ByteString("user");
						aUserPath += ByteString("registry");
						aUserPath.ToAbs();

						OUString const sUserPath(
							aUserPath.GetFull().GetBuffer(),
							aUserPath.GetFull().Len(),
							osl_getThreadTextEncoding() );

                        OUString sUserURL;
                        OSL_VERIFY(osl::File::getFileURLFromSystemPath(sUserPath,sUserURL) == osl::File::E_None);

                        aPropVal.Name = OUString::createFromAscii("UserLayerUrl");
						aPropVal.Value <<= sUserURL;

						aCPArgs[nArgs++] <<= aPropVal;

						// - 2 ------------------------------------------
                        aPropVal.Name = OUString::createFromAscii("Locale");
						aPropVal.Value <<= OUString::createFromAscii( "*" );

						aCPArgs[nArgs++] <<= aPropVal;

						// ----------------------------------------------

						xUserCfgProvider.set(
							xORB->createInstanceWithArguments(
								OUString::createFromAscii(
									"com.sun.star.configuration.ConfigurationProvider"),
								aCPArgs),
							UNO_QUERY );

						// ----------------------------------------------
					}

                    if ( !xUserCfgProvider.is() )
                        xUserCfgProvider = xShareCfgProvider;

                    if ( !xShareCfgProvider.is() )
                        xShareCfgProvider = xUserCfgProvider;

                    if ( xShareCfgProvider.is() && xUserCfgProvider.is() )
                    {
                        for( USHORT x = 0; x < m_CfgActionSlot.Count(); ++x )
                        {
                            if( m_pCallback )
                                m_pCallback->ProgressAction( AT_CONFIGURATION, 0, "" );

                            m_pCurrentAction = m_CfgActionSlot.GetObject( x );

                            SiConfigurationAction *pCurAction = (SiConfigurationAction*) m_pCurrentAction;

                            if ( pCurAction->GetItem()->IsWorkstation() )
                                pCurAction->setUNO( xORB, xUserCfgProvider );
                            else
                                pCurAction->setUNO( xORB, xShareCfgProvider );

                            pCurAction->Execute( *m_pEnv );
                        }
                    }
					else
						DBG_ERRORFILE( "SiAgenda::Run - Could not create config provider" );

					// dispose the default context of the ORB, if available
					Reference< XComponent > xComponent;

					Reference< XPropertySet > xProps( xORB, UNO_QUERY );
					if( xProps.is() )
                    {
                        OUString aName = OUString::createFromAscii("DefaultContext");
                        xProps->getPropertyValue( aName ) >>= xComponent;
                    }

					// ... otherwise dispose the ORB itself
					if( !xComponent.is() )
						xComponent.set( xORB, UNO_QUERY );
					if( xComponent.is() )
						xComponent->dispose();
				}
			}
			catch (Exception const & e)
			{
				ByteString aMessage (
					UniString(e.Message),osl_getThreadTextEncoding());

				GetLogfile().Success(FALSE) << aMessage;
				Critical_Log( aMessage );

				return FALSE;
			}

			if( m_pCallback )
				m_pCallback->StartRegister();
		}

		/////////////////////////////////////////////////////
		// exec basic procedures
		for( USHORT xx = 0; xx < m_ActionProcList.Count(); ++xx )
		{
			m_pCurrentAction = m_ActionProcList.GetObject( xx );
			m_pCurrentAction->Execute( *m_pEnv );
		}

		/////////////////////////////////////////////////////
		// exec SiCustom migration plugin
		if( m_pEnv->GetResponseStep() != 2 &&
			m_pEnv->IsFirstInstallation() && m_pEnv->IsLocal() && m_pEnv->DoMigration() )
		{
			SiCustom* pMigPlugin = SiHelp::GetMigrationPlugin( rCS.GetRootModule() );
			if( pMigPlugin )
			{
				SiCustomAction* pAction = new SiCustomAction( NULL,
							rCS.GetRootModule(),
							pMigPlugin->GetDllName(),
							m_pEnv->GetStartPath(),
							FALSE,
							FALSE,
							pMigPlugin,
                            &rCS );

				pAction->SetKeepAlive();
				pAction->Execute( *m_pEnv );
				pAction->GetCustomFnc().fncPtrExecute();
				pAction->SetKeepAlive( FALSE );
				pAction->GetCustomFnc().fncKill();
				delete pAction;
			}
		}

        /////////////////////////////////////////////////////
        // exec SiCustom plugin libs
        if( !m_pEnv->IsAutoWorkstation() )
            CallCustoms( rCS, FALSE );
	}

	PrintFoot(nErrors);
	return nErrors==0;
}

// =======================================================================
// Uno Components
void SiAgenda::RegisterExplicitUnoComponets( SiCompiledScript& rCs )
{
	SiDirEntry aPrgDir( m_pEnv->GetDestPath() );
	aPrgDir += ByteString("program");
	aPrgDir.SetCWD();

	if( m_pCallback )
		m_pCallback->StartRegisterUNO();

	for( USHORT i = 0; rCs.GetExplicitUNORegList().Count(); i++ )
	{
		ByteString* pEntry = rCs.GetExplicitUNORegList().GetObject(i);
		if( m_pCallback )
			m_pCallback->ProgressAction( AT_REGUNO, 100, *pEntry );
		SiHelp::RegisterUnoComponent( *pEntry, TRUE );
	}
}

void SiAgenda::RegisterListedUnoComponets()
{
	for( USHORT i = 0; i < m_aUnoComponents.Count(); ++i )
	{
		SiFile* pFile = m_aUnoComponents.GetObject(i);
		if( !pFile ) continue;

		BOOL bErr;
		ByteString aErrMsg;
		if( m_pCallback )
		{
			ByteString aMsg = m_pEnv->GetDestPath();
			aMsg += "/";
			aMsg += pFile->GetDirectory()->GetName();
			aMsg += "/";
			aMsg += pFile->GetName();

			m_pCallback->ProgressAction( AT_REGUNO, 100, aMsg );

			BOOL bRetry = TRUE;
			while( !(bErr = SiHelp::RegisterUnoComponent(pFile, *m_pEnv, TRUE, aErrMsg)) && bRetry )
				bRetry = m_pCallback->ErrorRegisterUnoComponent(pFile->GetName()) == SiAgendaCallback::EEA_RETRY;
		}
		else
			bErr = SiHelp::RegisterUnoComponent( pFile, *m_pEnv, TRUE, aErrMsg );

		const SiStarRegistryList* pLst = pFile->GetRegistryList();
		SiStarRegistry* pRegistry = pLst->GetObject(0);

		GetLogfile().Success(bErr) << "register component " <<
			pFile->GetName() << " : " << pRegistry->GetName() << endl;
		if( !bErr )
			GetLogfile().Success(FALSE) << "UNO exception (" << pFile->GetName() << "): " << aErrMsg << endl;
	}
}

void SiAgenda::RegisterAllUnoComponets( SiModule* pMod, BOOL bRegister )
{
	if( m_pCallback )
		m_pCallback->StartRegisterUNO();

	if( pMod->IsInstalled() )
	{
		const SiFileList& rLst = pMod->GetFileList();
		for( USHORT n = 0; n < rLst.Count(); ++n )
		{
			SiFile* pFile = rLst.GetObject(n);
			if( !pFile ) continue;

			const SiStarRegistryList* pLst = pFile->GetRegistryList();
			if( pFile->IsUnoComponent() && pLst->Count() )
			{
				BOOL bErr;
				ByteString aErrMsg;
				if( m_pCallback )
				{
					ByteString aMsg = m_pEnv->GetDestPath();
					aMsg += "/";
					aMsg += pFile->GetDirectory()->GetName();
					aMsg += "/";
					aMsg += pFile->GetName();

					m_pCallback->ProgressAction( AT_REGUNO, 100, aMsg );

					#ifdef UNX
					if( m_pEnv->IsUNOEvil() )
						fprintf( stdout, "EVIL: %s ", pFile->GetName().GetBuffer() );
					#endif

					BOOL bRetry = TRUE;
					while( !(bErr = SiHelp::RegisterUnoComponent(pFile, *m_pEnv, bRegister, aErrMsg)) && bRetry )
					{
						bRetry = m_pCallback->ErrorRegisterUnoComponent(pFile->GetName()) == SiAgendaCallback::EEA_RETRY;
					}
				}
				else
				 	bErr = SiHelp::RegisterUnoComponent( pFile, *m_pEnv, bRegister, aErrMsg );

				#ifdef UNX
				if( m_pEnv->IsUNOEvil() )
					if( !bErr )
						fprintf( stdout, "fail: %s\n", aErrMsg.GetBuffer() );
					else
						fprintf( stdout, "success\n" );
				#endif


				SiStarRegistry* pRegistry = pLst->GetObject(0);
				GetLogfile().Success(bErr) << (bRegister? "register component: " : "deregister component: ")
					<< pFile->GetName() << " : " << pRegistry->GetName() << endl;
				if( !bErr )
					GetLogfile().Success(FALSE) << "UNO exception (" << pFile->GetName() << "): " << aErrMsg << endl;
			}
		}
	}

	SiModuleList* pModLst = pMod->GetModuleList();
	for( USHORT i = 0; i < pModLst->Count(); ++i )
	{
		SiModule* pNextMod = pModLst->GetObject(i);
		RegisterAllUnoComponets(pNextMod, bRegister);
	}
}

// =======================================================================
// Help Files
BOOL SiAgenda::DelHelpFiles(SiDirEntry& rEntry, SimpleFileArchive* pArch)
{
	ByteString aExt( ByteString(rEntry.CutExtension().GetBuffer(), osl_getThreadTextEncoding()) );

	ByteString aSrchName( '/' );
	aSrchName += rEntry.GetName();
	aSrchName += '/';
	aSrchName.ToLowerAscii();

	BOOL bReorg = FALSE;
	for( USHORT nIdx = 0; nIdx < pArch->GetFileCount(); ++nIdx )
	{
		// Application::Reschedule();
		ByteString aName = ByteString( pArch->GetFileName(nIdx), osl_getThreadTextEncoding() );
		aName.ToLowerAscii();
		if( aName.Search(aSrchName) != STRING_NOTFOUND )
		{
			bReorg = TRUE;
			pArch->DelFile( nIdx, FALSE );
			nIdx = nIdx - 1;
		}
	}

	rEntry.SetExtension( UniString::CreateFromAscii("svh") );
	rEntry.Kill();
	rEntry.SetExtension( UniString::CreateFromAscii(aExt.GetBuffer()) );

	return bReorg;
}

void SiAgenda::OrganizeHelpFiles(SiCompiledScript& rCS)
{
	if( m_pCallback )
		m_pCallback->StartCompileHelp();

	SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
	for( USHORT nLangIdx = 0; nLangIdx < rLst.Count(); ++nLangIdx )
	{
		LanguageContext* pCtx = rLst.GetObject(nLangIdx);
		if( !pCtx ) continue;

		SimpleFileArchive* pNewArch = NULL;
		BOOL bReorg = FALSE;

		for( ULONG i = 0; i < m_HelpFileList.Count(); ++i )
		{
			HelpFileEntry* pHEntry = m_HelpFileList.GetObject(i);
			if( pHEntry->pFile->GetLanguage() != pCtx->nLanguage ) continue;

			SiDirEntry aEntry( m_pEnv->GetDestPath() );
			aEntry += pHEntry->pFile->GetDirectory()->GetName();
			if( !pNewArch )
			{
				SiDirEntry aTemp( aEntry );
				aTemp += ByteString("shelp");
				aTemp.ToAbs();
				pNewArch = new SimpleFileArchive( aTemp.GetFullUni(), STREAM_READWRITE );
			}
			rCS.SetCompiledHelp( pHEntry->pFile, "shelp" );

			aEntry += pHEntry->pFile->GetName();
			aEntry.CutExtension();
			aEntry.ToAbs();

			if( pHEntry->bInsert )
			{
				SimpleFileArchive* pAdd = new SimpleFileArchive( aEntry.GetFullUni(), STREAM_READ );
				pNewArch->AddArchive( *pAdd );
				delete pAdd;

				aEntry.SetExtension( UniString::CreateFromAscii("dat") );
				aEntry.Kill();

				aEntry.SetExtension( UniString::CreateFromAscii("dir") );
				aEntry.Kill();
			}
			else
			{
				// der EntryName aus der Liste ist immer der des 'DAT' Identifyer aus dem Script;
				// es kann sein, das an einem Modul zusaetzlich 'SVH' Identifyer angehaengt sind fuer
				// die es keine 'DAT' gibt. (common.dat; common.dir; svhelp.svh); deshalb muessen
				// an dem Modul des DAT's alle SVH's deren Name ungleich des Names der DAT Datei sind
				// ebenfalls bearbeitet werden.
				bReorg = DelHelpFiles(aEntry, pNewArch)? TRUE : bReorg? TRUE : FALSE;

				aEntry.SetExtension( UniString::CreateFromAscii("DAT") );
				SiModule* pMod = SiHelp::FindModuleByFileName(rCS.GetRootModule(), aEntry.GetName());
				if( !pMod )
					continue;

				const SiFileList& rFLst = pMod->GetFileList();
				for( USHORT i = 0; i < rFLst.Count(); ++i )
				{
					SiFile* pHFile = rFLst.GetObject(i);
					SiDirEntry aHEntry( m_pEnv->GetDestPath() );
					aHEntry += pHFile->GetDirectory()->GetName();
					aHEntry += pHFile->GetName();
					aHEntry.ToAbs();

					ByteString aHExt = ByteString( aHEntry.CutExtension(), osl_getThreadTextEncoding() );
					ByteString aExt = ByteString( aEntry.CutExtension(), osl_getThreadTextEncoding() );

					if( aHExt.CompareIgnoreCaseToAscii("SVH") == COMPARE_EQUAL &&
						aHEntry.GetName().CompareIgnoreCaseToAscii(aEntry.GetName()) != COMPARE_EQUAL )
					{
						// taucht diese Datei in weiteren installierten Modulen auf
						// darf sie nicht bearbeitet werden!
						BOOL bDoIt = TRUE;
						if( pHFile->GetRefCount() > 1 &&
							SiHelp::CountInstalledRefs(rCS.GetRootModule(), pHFile->GetName()) > 0 )
							bDoIt = FALSE;

						if( bDoIt )
							bReorg = DelHelpFiles(aHEntry, pNewArch)? TRUE : bReorg? TRUE : FALSE;
					}

					aHEntry.SetExtension( UniString::CreateFromAscii(aHExt.GetBuffer()) );
					aEntry.SetExtension( UniString::CreateFromAscii(aExt.GetBuffer()) );
				}
			}
		}

		if( bReorg )
			pNewArch->ReOrganize();
		if( pNewArch )
			delete pNewArch;
	}

	for( USHORT x = 0; x < m_HelpFileList.Count(); ++x )
		delete m_HelpFileList.GetObject(x);
	m_HelpFileList.Clear();

	if( m_pCallback )
		m_pCallback->EndCompileHelp();
}

void SiAgenda::DeleteKHPatchedFiles()
{
	if( !m_pEnv->HasKHPatched() )
		return ;

	SiDirEntry aKHFile( m_pEnv->GetStartPath() );
	aKHFile += ByteString(KH_PATCH_DETECTOR);

	SvFileStream aStrm( aKHFile.GetFullUni(), STREAM_READ );
	if( !aStrm.IsOpen() )
		return ;

	ByteString aLine;
	while( aStrm.ReadLine(aLine) )
	{
		aLine.EraseLeadingChars();
		aLine.EraseTrailingChars();
		if( !aLine.Len() ) continue;

		SiDirEntry aDelFile( m_pEnv->GetStartPath() );
		aDelFile += aLine;

		if( aDelFile.Exists() )
			aDelFile.Kill();
	}

	aStrm.Close();
}

void SiAgenda::PrintHeader()
{
	// Stream ffnen
	// (an bestehende Datei anhngen)
	m_Logfile
		<< endl
		<< "Begin Installation -----------" << endl
		<< "Mode     : ";

	switch(GetInstallMode())
	{
		case IM_STANDALONE:  m_Logfile << "Standalone";  break;
		case IM_NETWORK:	 m_Logfile << "Network";	 break;
		case IM_WORKSTATION: m_Logfile << "Workstation"; break;
		default:			 m_Logfile << "unknown";	 break;
	}

	if (DoRecoverOnly())
		m_Logfile << " (Recover only)";

	m_Logfile << endl;
	m_Logfile
		<< "Date/Time: "
		<< ByteString( International().GetDate(Date()), osl_getThreadTextEncoding() )
		<< " "
		<< ByteString( International().GetTime(Time()), osl_getThreadTextEncoding() )
		<< endl << endl;

}

void SiAgenda::PrintFoot(int nErrors)
{
	// Fuss ausgeben
	m_Logfile << endl;
	m_Logfile << "Errors = " << (long)nErrors << endl;
	m_Logfile.Close();
}

void SiAgenda::UpdateATToolSupport()
{
    // i15335, don't use the application class, when vcl isn't initialized
    if( m_pEnv->HasVCL() )
    {
        AllSettings  aAllSettings( Application::GetSettings() );
        MiscSettings aMiscSettings( aAllSettings.GetMiscSettings() );

        // now we get the ATTool Settings
        BOOL bEnable = aMiscSettings.GetEnableATToolSupport();
        m_pEnv->SetATToolSupport( bEnable );

        // and finaly change the Replacement
        m_pEnv->UpdateReplacement( "<ATToolSupport>", m_pEnv->GetATToolSupport() );
    }
}

