#ifndef _SETUP_STRINGHELPER_HXX
#include "stringhelper.hxx"
#endif

#include "rtl/ustring.hxx"

#include "osl/thread.h"

namespace stringhelper
{
	UniString TrimString(String const& _suStr)
	{
		String suStr(_suStr);
		suStr.EraseTrailingChars();
		suStr.EraseLeadingChars();
		return suStr;
	}
	
	String rtlStr2Str(rtl::OUString const& _sStr)
	{
		UniString suStr(_sStr);
		return suStr;
	}
	
	ByteString ConvertToUTF8(String const& _suStr)
	{
		::rtl::OString sStr = ::rtl::OUStringToOString( _suStr, RTL_TEXTENCODING_UTF8 );
		return ByteString(sStr);
	}
	UniString ConvertFromUTF8(ByteString const& _sStr)
	{
		rtl::OString sStr(_sStr);
		rtl::OUString suStr(::rtl::OStringToOUString( sStr, RTL_TEXTENCODING_UTF8 ));
		return UniString(suStr);
	}
}
