/*************************************************************************
 *
 *  $RCSfile: webagenda.cxx,v $
 *
 *  $Revision: 1.23 $
 *
 *  last change: $Author: lla $ $Date: 2002/08/13 07:34:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#include "script.hxx"
#include "agenda.hxx"

#include "service.hxx"
#include "webaction.hxx"

SV_DECL_PTRARR_SORT( SortedWebDirList, SiWebMakeDirAction*, 1, 3 );
SV_IMPL_OP_PTRARR_SORT( SortedWebDirList, SiWebMakeDirAction* );

//-----------------------------------------------------------------------

SiWebAgenda::SiWebAgenda()
{
	m_bWebMode = TRUE;
}

SiWebAgenda::~SiWebAgenda()
{
}

//-----------------------------------------------------------------------

void SiWebAgenda::SubstituteTemplates( ByteString& rValue )
{
	USHORT nBeginTpl = rValue.Search( '<' );
	while( nBeginTpl != STRING_NOTFOUND )
	{
		USHORT nNested = 0;
		USHORT nEndTpl = STRING_NOTFOUND;
		for( USHORT i = nBeginTpl + 1; i <= rValue.Len(); ++i )
		{
			if( rValue.GetChar(i) == '<' )
				nNested++;
			if( rValue.GetChar(i) == '>' )
				if( nNested )
					nNested--;
				else
				{
					nEndTpl = i;
					break;
				}
		}

		if( nEndTpl != STRING_NOTFOUND )
		{
			ByteString aTpl = rValue.Copy( nBeginTpl, nEndTpl-nBeginTpl+1 );
			QueryTemplateResult aResult = QueryTemplateValue( aTpl );
			rValue.SearchAndReplace( aTpl, aResult.sValue );
		}
		nBeginTpl = rValue.Search( '<', nBeginTpl+1 );
	}
}

//-----------------------------------------------------------------------

void SiWebAgenda::AddWeb( SiWebAction* pAction )
{
	switch( pAction->GetType() )
	{
		// deinstall
		case ActionType_DELETEFILE :	m_WebDeActionSlot2.Insert( (SiWebDeleteFileAction*)pAction, 0UL ); break;
		case ActionType_DELETEDIR :		m_WebDeActionSlot3.Insert( (SiWebDeleteDirAction*)pAction, LIST_APPEND ); break;

		case ActionType_DELETEFOLDERITEM : m_WebDeActionSlot4.Insert( (SiWebDeleteFolderItemAction*)pAction, 0UL ); break;
		case ActionType_DELETEFOLDER :	m_WebDeActionSlot4.Insert( (SiWebDeleteFolderAction*)pAction, LIST_APPEND ); break;

		// deinstall / install
		case ActionType_PROFILEITEM :  	if( ((SiWebProfileItemAction*)pAction)->bCreate )
										{
											ULONG i = m_WebActionSlot4.Count();
											BOOL bPosFound = FALSE;

											while( i > 0 && !bPosFound )
											{
												if( ((SiWebProfileItemAction*)pAction)->GetOrder() >=
													((SiWebProfileItemAction*)m_WebActionSlot4.GetObject(i-1))->GetOrder() )
													bPosFound = TRUE;
												else
													i--;
											}
											m_WebActionSlot4.Insert( (SiWebProfileItemAction*)pAction, i );
										}
										else
											m_WebDeActionSlot2.Insert( (SiWebProfileItemAction*)pAction, LIST_APPEND );
										break;

		case ActionType_FONT :			if( ((SiWebFontAction*)pAction)->bCreate )
											m_WebActionSlot5.Insert( (SiWebFontAction*)pAction, LIST_APPEND );
										else
											m_WebDeActionSlot3.Insert( (SiWebFontAction*)pAction, 0UL );
 										break;

		case ActionType_WINREGISTRY :	if( ((SiWebWindowsRegistryAction*)pAction)->bCreate )
											m_WebActionSlot5.Insert( (SiWebWindowsRegistryAction*)pAction, 0UL );
										else
											m_WebDeActionSlot4.Insert( (SiWebWindowsRegistryAction*)pAction, LIST_APPEND );
										break;

		// install
		case ActionType_DOWNLOAD :		m_WebActionSlot2.Insert( (SiWebDownloadAction*)pAction, LIST_APPEND ); break;
		case ActionType_MAKEDIR :		m_WebActionSlot1.Insert( (SiWebMakeDirAction*)pAction, LIST_APPEND ); break;

		case ActionType_COPYFILE :		m_WebActionSlot3.Insert( (SiWebCopyFileAction*)pAction, 0UL ); break;
		case ActionType_UNZIPFILE :		m_WebActionSlot3.Insert( (SiWebUnzipAction*)pAction, LIST_APPEND ); break;

		case ActionType_CREATESHORTCUT : m_WebActionSlot6.Insert( (SiWebMakeShortcutAction*)pAction, 0UL ); break;

		case ActionType_MAKEFOLDER :	m_WebActionSlot6.Insert( (SiWebMakeFolderAction*)pAction, 0UL ); break;
		case ActionType_MAKEFOLDERITEM: m_WebActionSlot6.Insert( (SiWebMakeFolderItemAction*)pAction, LIST_APPEND ); break;
	}
}

void SiWebAgenda::JoinActionLists()
{
	USHORT i=0;

	// sort makedir actions
	SortedWebDirList* pList = new SortedWebDirList;
	for( USHORT nIdx = 0; nIdx < m_WebActionSlot1.Count(); ++nIdx )
	{
		SiWebMakeDirAction* pAction = (SiWebMakeDirAction*) m_WebActionSlot1.GetObject( nIdx );
		if( !pList->C40_PTR_INSERT( SiWebMakeDirAction, pAction ) )
		{
			delete pAction;
			pAction = NULL;
		}
	}
	m_WebActionSlot1.Clear();
	for( USHORT nSortIdx = 0; nSortIdx < pList->Count(); ++nSortIdx )
		m_WebActionSlot1.Insert( (*pList)[nSortIdx], LIST_APPEND );
	delete pList;

	// deinstall
	for( i = 0; i < m_WebDeActionSlot1.Count(); i++ )
		m_WebActionList.Insert( m_WebDeActionSlot1.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebDeActionSlot2.Count(); i++ )
		m_WebActionList.Insert( m_WebDeActionSlot2.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebDeActionSlot3.Count(); i++ )
		m_WebActionList.Insert( m_WebDeActionSlot3.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebDeActionSlot4.Count(); i++ )
		m_WebActionList.Insert( m_WebDeActionSlot4.GetObject(i), LIST_APPEND );

	// install
	for( i = 0; i < m_WebActionSlot1.Count(); i++ )
		m_WebActionList.Insert( m_WebActionSlot1.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebActionSlot2.Count(); i++ )
		m_WebActionList.Insert( m_WebActionSlot2.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebActionSlot3.Count(); i++ )
		m_WebActionList.Insert( m_WebActionSlot3.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebActionSlot4.Count(); i++ )
		m_WebActionList.Insert( m_WebActionSlot4.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebActionSlot5.Count(); i++ )
		m_WebActionList.Insert( m_WebActionSlot5.GetObject(i), LIST_APPEND );

	for( i = 0; i < m_WebActionSlot6.Count(); i++ )
		m_WebActionList.Insert( m_WebActionSlot6.GetObject(i), LIST_APPEND );

	m_WebDeActionSlot1.Clear();
	m_WebDeActionSlot2.Clear();
	m_WebDeActionSlot3.Clear();
	m_WebDeActionSlot4.Clear();

	m_WebActionSlot1.Clear();
	m_WebActionSlot2.Clear();
	m_WebActionSlot3.Clear();
	m_WebActionSlot4.Clear();
	m_WebActionSlot5.Clear();
	m_WebActionSlot6.Clear();
}

//-----------------------------------------------------------------------

ULONG SiWebAgenda::_addDownload( SiFile* pFile, SiDoneList& rDonelist )
{
	UniString aFilename = UniString( pFile->GetPackedName().GetBuffer(), osl_getThreadTextEncoding() );
	if( rDonelist.Find(pFile->GetPackedName()) != 0 )
		return 0;
	rDonelist.Insert( pFile->GetPackedName(), 1 );

	if( m_pEnv->IsInUpdate() && pFile->IsNoUpdate() ) return 0;

	SiWebDownloadAction* pNew = new SiWebDownloadAction(this, aFilename);
	pNew->SetSize( pFile->GetSize() );
	pNew->SetCRC( pFile->GetCRC() );

	AddWeb( pNew );

	// be sure destination directory is present
	SiDirectory* pDir = (SiDirectory*) pFile->GetDirectory();
	SiDirectory* pDirLangRef = (SiDirectory*) pDir->GetLangRef( pFile->GetLanguage() );
	if( pDirLangRef )
		pDirLangRef->JoinWithParent();

	Install( pDirLangRef? pDirLangRef : pDir, rDonelist );
	return pFile->GetDownloadSize();
}

ULONG SiWebAgenda::CreateDownload4Module( SiModule* pModule, SiDoneList& rDonelist )
{
	ULONG nDownloadSz = 0;
	const SiFileList& rFileList = pModule->GetFileList();
	for( USHORT i = 0; i < rFileList.Count(); i++ )
	{
		SiFile* pFile = rFileList.GetObject(i);
		if( pFile->DeleteOnly() ) continue;
		if( pFile->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiFile* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pFile;
					else
						pLangRef = (SiFile*) pFile->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						nDownloadSz += _addDownload( pLangRef, rDonelist );
					}
					else
						nDownloadSz += _addDownload( pFile, rDonelist );
				}
			}
		}
		else
			nDownloadSz += _addDownload( pFile, rDonelist );
	}
	return nDownloadSz;
}

ULONG SiWebAgenda::CreateForWebInstall( SiModule* pModule, CachedConfiguration* pCC, SiDoneList& rDonelist, BOOL bFullInstall )
{
	ULONG nDownloadSz = CreateDownload4Module( pModule, rDonelist );

	if( bFullInstall && !pModule->GetParent() )
	{
		DirEntry aFileEntry( UniString(pCC->aScriptLocation, osl_getThreadTextEncoding()) );

		if( m_pEnv->GetWebOSType() == OSType_WIN )
			aFileEntry.SetName( UniString("setup.exe", osl_getThreadTextEncoding()) );
		else
			aFileEntry.SetName( UniString("setup", osl_getThreadTextEncoding()) );

		SiWebDownloadAction* pNew = new SiWebDownloadAction(this, aFileEntry.GetName());
		sal_Int32 nSz = FileStat(aFileEntry).GetSize() / 1024;
		pNew->SetSize( nSz ? nSz : 1 );
		pNew->SetCRC( 0UL );

		AddWeb( pNew );

		if( m_pEnv->GetWebOSType() == OSType_WIN )
			aFileEntry.SetName( UniString("setup.inf", osl_getThreadTextEncoding()) );
		else
			aFileEntry.SetName( UniString("setup.ins", osl_getThreadTextEncoding()) );
		pNew = new SiWebDownloadAction(this, aFileEntry.GetName());
		pNew->SetCRC( 0UL );
		AddWeb( pNew );

		if( m_pEnv->GetWebOSType() != OSType_WIN )
		{
			aFileEntry.SetName( UniString("setup.bin", osl_getThreadTextEncoding()) );
			pNew = new SiWebDownloadAction(this, aFileEntry.GetName());
			pNew->SetCRC( 0UL );
			AddWeb( pNew );
		}

		return nDownloadSz;
	}

	const SiFileList& rFileList = pModule->GetFileList();

	// makedir actions
	const SiDirList& rDirList = pModule->GetDirList();
	Install( rDirList, rDonelist );

	// unzip actions
	Install( rFileList, rDonelist, *(pCC->pCS) );

	// profile actions
	const SiProfileItemList& rProfileList = pModule->GetProfileItemList();
	Install( rProfileList, rDonelist );

	// configuration actions
	const SiConfigurationItemList& rCfgList = pModule->GetConfigurationItemList();
	Install( rCfgList, rDonelist, *(pCC->pCS) );

	// windows registry actions
	const SiRegistryItemList& rRegistryList = pModule->GetRegistryItemList();
	Install( rRegistryList, rDonelist, *(pCC->pCS) );

	// folder / item actions
	const SiFolderItemList& rFolderList = pModule->GetFolderItemList();
	Install( rFolderList, rDonelist );

	return nDownloadSz;
}

//-----------------------------------------------------------------------

BOOL SiWebAgenda::CreateForWebDeinstall( SiModule* pModule, CachedConfiguration* pCC, SiDoneList& rDonelist, BOOL bFullInstall )
{
	// delete file actions
	const SiFileList& rFileList = pModule->GetFileList();
	Uninstall( rFileList, rDonelist );

	// delete dir actions
	const SiDirList& rDirList = pModule->GetDirList();
	Uninstall( rDirList, rDonelist );

	// profile actions
	const SiProfileItemList& rProfileList = pModule->GetProfileItemList();
	Uninstall( rProfileList, rDonelist );

	// windows registry actions
	const SiRegistryItemList& rRegistryList = pModule->GetRegistryItemList();
	Uninstall( rRegistryList, rDonelist );

	// folder / item actions
	const SiFolderItemList& rFolderList = pModule->GetFolderItemList();
	Uninstall( rFolderList, rDonelist );

	return TRUE;
}

//-----------------------------------------------------------------------

ULONG SiWebAgenda::CreateForWebInstall( CachedConfiguration* pCC, const InstallEnvironment& rEnvironment )
{
	ULONG nSz = 0;
	sal_Int32 nIdx = rEnvironment.seqModuleIDList.getLength();
	SiDoneList aDoneListInstall(1017);
	SiDoneList aDoneListDeinstall(1017);

	m_pCachedConfig	= pCC;
	m_eInstallMode 	= IM_STANDALONE;


	for( sal_Int32 n = 0; n < nIdx; ++n )
	{
		ModuleState aActState = rEnvironment.seqModuleIDList[n];


		if( aActState.isInstalled && !aActState.isSelected && rEnvironment.eInstallType == InstallType_CHANGE )
		{
			ByteString aID( UniString(aActState.strID), osl_getThreadTextEncoding() );
			SiModule* pMod = PTR_CAST( SiModule, pCC->pCS->Find(aID) );

			m_bSwitchMode = TRUE;
			DeleteSwitchContext( pMod, aDoneListDeinstall, *pCC->pCS, FALSE );
			InstallSwitchContext( pMod, aDoneListInstall, *pCC->pCS, FALSE );
			m_bSwitchMode = FALSE;

			continue;
		}

		if( !aActState.isSelected && rEnvironment.eInstallType != InstallType_REPAIR )
			continue;

		ByteString aID( UniString(aActState.strID), osl_getThreadTextEncoding() );
		SiModule* pMod = PTR_CAST( SiModule, pCC->pCS->Find(aID) );
		if( !pMod ) continue;

		if( rEnvironment.eInstallType == InstallType_REPAIR )
		{
			if( aActState.isInstalled )
				nSz += CreateForWebInstall( pMod, pCC, aDoneListInstall, rEnvironment.eInstallType == InstallType_FULLINSTALL ? TRUE : FALSE );
		}
		else
		{
			ULONG nModSz = pMod->CalculateSize( *m_pEnv, SiModule::ONLYTHIS, rEnvironment.nClusterSize );
			if( aActState.isInstalled )
			{
				if( rEnvironment.eInstallType == InstallType_CHANGE ) DeleteSwitchContext( pMod, aDoneListDeinstall, *pCC->pCS, FALSE );
				CreateForWebDeinstall( pMod, pCC, aDoneListDeinstall, rEnvironment.eInstallType == InstallType_FULLINSTALL ? TRUE : FALSE );
				if( nSz > nModSz ) nSz -= nModSz; else nSz = 0;
			}
			else
			{
				// dont install hidden modules
				if( pMod->IsHidden() || pMod->IsHiddenRecursive() ) continue;
				if( rEnvironment.eInstallType == InstallType_CHANGE ) InstallSwitchContext( pMod, aDoneListInstall, *pCC->pCS, FALSE );
				nSz += CreateForWebInstall( pMod, pCC, aDoneListInstall, rEnvironment.eInstallType == InstallType_FULLINSTALL ? TRUE : FALSE );
				nSz += nModSz;
			}
		}
	}

	if( rEnvironment.eInstallType == InstallType_FULLDELETE )
	{
		com::sun::star::util::DateTime aDateTime;
		SiWebDeleteFileAction* pNew = new SiWebDeleteFileAction(
				this,
				UniString::CreateFromAscii( "program" ),
				UniString::CreateFromAscii( "initialize.ini" ),
				FALSE, FALSE, FALSE, aDateTime );
		AddWeb( pNew );
	}

	return nSz;
}

