/*************************************************************************
 *
 *  $RCSfile: sidir.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"

TYPEINIT1(SiDirectory,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiDirectory
//

SiDirectory::SiDirectory( SiIdentifier const& ID, SiCompiler* pCompiler,
						  BOOL bSystemObj, BOOL bSystemDir, BOOL bDeleteAll ) :
	SiDeclarator(ID,pCompiler,bSystemObj)
{
	INIT_MULTI_LANG_MEMBER( pParent			);
	INIT_MULTI_LANG_MEMBER( Name			);
	INIT_MULTI_LANG_MEMBER( bWorkstation	);
	INIT_MULTI_LANG_MEMBER( bCreate			);
	INIT_MULTI_LANG_MEMBER( bDontDelete 	);
	INIT_MULTI_LANG_MEMBER( bDeleteAll		);
	INIT_MULTI_LANG_MEMBER( bSystem			);
	INIT_MULTI_LANG_MEMBER( nRefCount		);
	INIT_MULTI_LANG_MEMBER( SubDirs			);
	INIT_MULTI_LANG_MEMBER( nUnixRights		);

	m_pParent		= NULL;
	m_bWorkstation  = FALSE;
	m_bCreate		= FALSE;
	m_bSystem		= bSystemDir;
	m_bDontDelete 	= FALSE;
	m_bDeleteAll	= bDeleteAll;
	m_nRefCount		= 0;
	m_nUnixRights	= 0;
}

// ----------------------------------------------------------------------------

void SiDirectory::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiDirectory* pParent = (SiDirectory*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pParent			);
	JOIN_MULTI_LANG_MEMBER( Name			);
	JOIN_MULTI_LANG_MEMBER( bWorkstation	);
	JOIN_MULTI_LANG_MEMBER( bCreate			);
	JOIN_MULTI_LANG_MEMBER( bDontDelete 	);
	JOIN_MULTI_LANG_MEMBER( bDeleteAll		);
	JOIN_MULTI_LANG_MEMBER( bSystem			);
	JOIN_MULTI_LANG_MEMBER( nRefCount		);
	JOIN_MULTI_LANG_MEMBER( SubDirs			);
	JOIN_MULTI_LANG_MEMBER( nUnixRights		);
}

// ----------------------------------------------------------------------------

SiDeclarator* SiDirectory::GetLangRef( USHORT nLanguage )
{
	SiDirectory* pThis = (SiDirectory*) SiDeclarator::GetLangRef( nLanguage );
	if( !pThis )
		return pThis;
	pThis->JoinWithParent();

	if( pThis->m_pParent )
	{
		SiDirectory* pLangParent = (SiDirectory*)pThis->m_pParent->GetLangRef( nLanguage );
		if( pLangParent )
		{
			pThis->m_pParent = pLangParent;
			pThis->m_IspParent = TRUE;
		}
	}

	return pThis;
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::SetProperty( ByteString const& aProperty, ByteString const& aValue )
{
	if( aProperty == PROPERTY_DOSNAME )
	{
		SET_MULTI_LANG_MEMBER(Name, aValue);
		return TRUE;
	}

	if( aProperty == PROPERTY_HOSTNAME )
	{
		SET_MULTI_LANG_MEMBER(Name, aValue);
		return TRUE;
	}

	if( aProperty == PROPERTY_FLAGS )
	{
		if( aValue == VALUE_DONT_DELETE )
		{
			SET_MULTI_LANG_MEMBER(bDontDelete, TRUE);
			return TRUE;
		}
		if( aValue == VALUE_DELETE_ALL )
		{
			SET_MULTI_LANG_MEMBER(bDeleteAll, TRUE);
			return TRUE;
		}
		if( aValue == VALUE_WORKSTATION )
		{
			SET_MULTI_LANG_MEMBER(bWorkstation, TRUE);
			return TRUE;
		}
		else if( aValue == VALUE_CREATE )
		{
			SET_MULTI_LANG_MEMBER(bCreate, TRUE);
			return TRUE;
		}
		ByteString aMsg( "unknown value " );
		aMsg += aValue;
		Error( aMsg );

		return FALSE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::SetProperty( ByteString const& aProperty, long aValue )
{
	if( aProperty == PROPERTY_UNIX_RIGHTS )
	{
		SET_MULTI_LANG_MEMBER( nUnixRights, (int)aValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::SetProperty( ByteString const& aProperty, SiDeclarator* aValue )
{
	if( aProperty == PROPERTY_PARENTID )
	{
		m_pParent = PTR_CAST(SiDirectory,aValue);
		if( m_pParent == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a directory";
			Error( aMsg );
			return FALSE;
		}
		else
		{
			m_IspParent = TRUE;
			m_pParent->AddRefCount();
		}
		return TRUE;
	}
	return SiDeclarator::SetProperty( aProperty,aValue );
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::Check()
{
	if( m_pParent != NULL &&  m_bWorkstation && !m_pParent->m_bWorkstation )
		Warning("the parent of this directory should have the WORKSTATION-Style too");

	if( !CheckField(m_Name, PROPERTY_NAME) )
		return FALSE;
	else
		return SiDeclarator::Check();
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::WriteTo( SiDatabase& aStream ) const
{
	if( m_bSystem )
	{
		DBG_ERROR("SiDirectory::WriteTo() called for system dir");
		return FALSE;
	}

	if( !IsLangRef() )
	{
		aStream.BeginDeclaration( "Directory", this );
		// PROPERTY_PARENTID
		WRITE_MULTI_LANG_MEMBER( PROPERTY_PARENTID, pParent );
	}

	// PROPERTY_HOSTNAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_HOSTNAME, Name );

	if( m_IsbWorkstation || m_IsbCreate || m_IsbDeleteAll || m_IsbDontDelete )
	{
		aStream.BeginProperty( PROPERTY_FLAGS, m_nLanguage );
			aStream.BeginList();
				if( m_bWorkstation )
					aStream.AddListValue(SiIdentifier(VALUE_WORKSTATION));
				if( m_bCreate )
					aStream.AddListValue(SiIdentifier(VALUE_CREATE));
				if( m_bDeleteAll )
					aStream.AddListValue(SiIdentifier(VALUE_DELETE_ALL));
				if( m_IsbDontDelete )
					aStream.AddListValue(SiIdentifier(VALUE_DONT_DELETE));
			aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiDirectory* pDir = (SiDirectory*) m_aLangRefs.GetObject(nIdx);
		pDir->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();

	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiDirectory::GetNaturalID() const
{
	ByteString aNatID(GetName());
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

// ----------------------------------------------------------------------------

ByteString SiDirectory::GetName() const
{
	if( m_pParent == NULL )
		return m_Name;
	SiDirEntry aDirEntry( SiDirEntry(m_pParent->GetName()) + SiDirEntry(m_Name) );
	return aDirEntry.GetFull();
}

ByteString SiDirectory::GetWebName() const
{
	ByteString aName;
	if( IsSystemObject() || IsThisSystem() )
	{
		aName = '<';
		aName += GetID();
		aName += '>';
	}
	else
		aName = m_Name;

	if( m_pParent == NULL )
		return aName;

	SiDirEntry aDirEntry( SiDirEntry(m_pParent->GetWebName()) + SiDirEntry(aName) );
	return aDirEntry.GetFull();
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::IsSystem() const
{
	if (m_pParent == NULL)
		return m_bSystem;
	return m_bSystem || m_pParent->IsSystem();
}

BOOL SiDirectory::IsDontDelete() const
{
	if (m_pParent == NULL)
		return m_bDontDelete;
	return m_bDontDelete || m_pParent->IsDontDelete();
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::InstallFileInThisDirOnWorkstation() const
{
	BOOL bRet = m_bWorkstation || IsSystem();
	if( GetID().CompareIgnoreCaseToAscii("PREDEFINED_PROGDIR") == COMPARE_EQUAL )
		return bRet;
	// bei Files alle Dir's ueber mir anschauen
	if( m_pParent )
		bRet = m_pParent->InstallFileInThisDirOnWorkstation();
	return bRet;
}

// ----------------------------------------------------------------------------

BOOL SiDirectory::InstallOnWorkstation() const
{
	// Dieses Verzeichnis
	BOOL bRet = m_bWorkstation || IsSystem();

	if( GetID().CompareIgnoreCaseToAscii("PREDEFINED_PROGDIR") == COMPARE_EQUAL )
		return bRet;

	// Unterverzeichnisse
	for (USHORT i=0; i<m_SubDirs.Count() && !bRet; i++)
		bRet = m_SubDirs.GetObject(i)->InstallOnWorkstation();

	return bRet;
}

