/*************************************************************************
 *
 *  $RCSfile: jvmdlg.cxx,v $
 *
 *  $Revision: 1.25 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/15 14:32:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



// INCLUDE ---------------------------------------------------------------

#include <algorithm>

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif

#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#include "environ.hxx"

#pragma hdrstop

#include <vcl/msgbox.hxx>

#include "jvmdlg.hxx"
#include "jvmdlg.hrc"
#include "jvmsetup.hxx"
#include "jvmscan.hxx"
#include "sicustom.hxx"

// #include "maindialog.h"
#define CELL_SPACING 6
#define HCELL_SPACING 32

using namespace rtl;

JVMDialog::JVMDialog (	Window*					pParent,
						ResMgr*					pResMgr,
						SiCustomEnvironment*	pEnv,
						SiCustomModuleList*		pModList,
						ByteString				srcPath,
						ByteString				destPath,
						ByteString				instPackage,
                        const ByteString&       version,
						BOOL					isSetupMode
	):
	ModalDialog			(pParent, 		ResId(DLG_JVM,				pResMgr) ),
	maOK				(this,			ResId(BT_OK,				pResMgr) ),
	maCancel			(this,			ResId(BT_CANCEL,			pResMgr) ),
	maHelp				(this,			ResId(BT_HELP,				pResMgr) ),
	maContainer			(this,			ResId(TAB_WND,				pResMgr) ),
	maLine				(this,			ResId(FL_LINE,				pResMgr) ),
	maHelpEdit			(this,			ResId(HELP_EDIT,			pResMgr) ),
	maRbtInstall		(&maContainer,	ResId(RBT_INSTALL,			pResMgr) ),
	maRbtUseExisting	(&maContainer,	ResId(RBT_USESELECTED,		pResMgr) ),
	maRbtNoJava			(&maContainer,	ResId(RBT_NOJAVA,			pResMgr) ),
	maBrowse			(&maContainer,	ResId(BT_BROWSE,			pResMgr) ),
	maJavaVMs			(&maContainer,	ResId(LB_JAVAVMS,			pResMgr) ),
	maInfoText			(&maContainer,	ResId(FT_INFO,  			pResMgr) ),
	maListboxText		(&maContainer,	ResId(FT_LISTBOX,			pResMgr) ),
	maJavaHomeText  	(&maContainer,	ResId(FT_JAVA_HOME,	        pResMgr) ),
	maBrowseText    	(&maContainer,	ResId(FT_BROWSE,        	pResMgr) )
{
    BOOL bIsUpdate = FALSE;
    Link aLnk( STATIC_LINK(this, JVMDialog, ImplSelectionChanged ) );

    maRbtInstall.SetClickHdl( aLnk );
	maRbtUseExisting.SetClickHdl( aLnk );
	maRbtNoJava.SetClickHdl( aLnk );

	maHelp.SetClickHdl( LINK(this, JVMDialog, HelpHdl) );
	maBrowse.SetClickHdl( LINK(this, JVMDialog, BrowseHdl) );
	maCancel.SetClickHdl( LINK(this, JVMDialog, CancelHdl) );
	maOK.SetClickHdl( LINK(this, JVMDialog, OKHdl) );

	maJavaVMs.SetSelectHdl( LINK(this, JVMDialog, SelectHdl) );

	this->pResMgr		= pResMgr;
	this->pParent		= pParent;
	this->pModuleList	= pModList;

	aSourcePath			= srcPath;
	aDestPath			= destPath;
	aInstallPackage		= instPackage;
    aVersion            = version;

	bIsSetupMode 		= isSetupMode;
    nJVMCount           = 0;

	bAbort = FALSE;
	bHelpMode = FALSE;
	maHelpEdit.Hide();

    UniString aInfo = maInfoText.GetText();
    UniString aVersion = UniString( aJavaInstProps[ REQUIRED_VERSION ], osl_getThreadTextEncoding() );

    aInfo.SearchAndReplaceAll( UniString::CreateFromAscii("%VERSION"), aVersion );
    maInfoText.SetText( aInfo );

#if defined (OS2)
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_OS2, pResMgr) );
#elif defined (LINUX) || defined (FREEBSD) || defined (NETBSD)
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_LINUX, pResMgr) );
#elif defined (SOLARIS)
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_SOLARIS, pResMgr) );
#else
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_WIN32, pResMgr) );
#endif

	pCustomEnv = pEnv;

	UniString javaInstallTxt = maRbtInstall.GetText();
	
    if ( aJavaInstProps.find(INSTALLATION_PACKAGE) !=  aJavaInstProps.end() )
	{

		javaInstallTxt.SearchAndReplaceAll(	UniString::CreateFromAscii("%1"),
											UniString::CreateFromAscii(aJavaInstProps[VERSION].GetBuffer()));
		javaInstallTxt.SearchAndReplaceAll(	UniString::CreateFromAscii("%2"),
											UniString::CreateFromAscii(aJavaInstProps[VENDOR].GetBuffer()));

	}
	else
    {
		// When there is no java, remove at least the place holders
        javaInstallTxt.SearchAndReplaceAll(	UniString::CreateFromAscii(" %1 (%2)"), UniString() );
		maRbtInstall.Disable();
    }

    maRbtInstall.SetText( javaInstallTxt ) ;

    if ( pCustomEnv )
    {
        SiEnvironment* pBig = pCustomEnv->GetBigEnv();
        if ( pBig && pBig->IsUpdateOldVersion() )
            bIsUpdate = TRUE;
    }

	// #97812# resize buttons
    if ( bIsUpdate )
    {
        maOK.SetText( ResId( STR_NEXT, pResMgr ) );
        maCancel.SetText( ResId( STR_NEXT, pResMgr ) );
    }

    Size aSize = maCancel.CalcMinimumSize();
	sal_Int32 nWidthCancel = aSize.Width();
	aSize = maOK.CalcMinimumSize();
	sal_Int32 nWidthOk = aSize.Width();
	nWidthCancel += 2 * CELL_SPACING;
	nWidthCancel = std::max(nWidthCancel, sal_Int32(80));

	nWidthOk += 2 * CELL_SPACING;
	nWidthOk = std::max(nWidthOk, sal_Int32(80));

	Size aWindowSize = GetSizePixel();
	sal_Int32 nNewCancelXPos = aWindowSize.Width() - CELL_SPACING - nWidthCancel;
	sal_Int32 nNewOkXPos = nNewCancelXPos - CELL_SPACING - nWidthOk;

	Point aCancelPoint = maCancel.GetPosPixel();
    Size  aCancelSize  = maCancel.GetSizePixel();
    aCancelSize.Width() = nWidthCancel;
	maCancel.SetPosSizePixel(Point(nNewCancelXPos, aCancelPoint.Y()), aCancelSize);
    Size aOkSize = maOK.GetSizePixel();
    aOkSize.Width() = nWidthOk;

    if ( bIsUpdate )
    {
        maCancel.Hide();
        maOK.SetPosSizePixel(Point(nNewCancelXPos, aCancelPoint.Y()), aCancelSize);
    }
    else
        maOK.SetPosSizePixel(Point(nNewOkXPos, aCancelPoint.Y()), aOkSize);

    // #97821# resize maBrowse
    aSize = maBrowse.CalcMinimumSize();

	sal_Int32 nWidthBrowse = aSize.Width();
	nWidthBrowse += 2 * CELL_SPACING;
	nWidthBrowse = std::max( nWidthBrowse, sal_Int32(80) );

	sal_Int32 nNewBrowseXPos = aWindowSize.Width() - HCELL_SPACING - nWidthBrowse;
	Point aBrowsePoint = maBrowse.GetPosPixel();
    Size  aBrowseSize  = maBrowse.GetSizePixel();
    aBrowseSize.Width() = nWidthBrowse;
	maBrowse.SetPosSizePixel(Point(nNewBrowseXPos, aBrowsePoint.Y()), aBrowseSize);

    maNoTermMsg = String( ResId( STR_NO_TERM_MSG, pResMgr ) );
}

// -----------------------------------------------------------------------

JVMDialog::~JVMDialog()
{
	FreeResource();
}

void JVMDialog::StateChanged( StateChangedType nStateChange )
{
	ModalDialog::StateChanged( nStateChange );

	//if ( (nStateChange == STATE_CHANGE_VISIBLE) && (! bIsSetupMode) )
	//	InfoBox(this, ResId( DLG_CLOSE_STAROFFICE )).Execute();
}

//------------------------------------------------------------------------
BOOL JVMDialog::isUseExisting()
{
    return maRbtUseExisting.IsChecked();
}

//------------------------------------------------------------------------
BOOL JVMDialog::isNoJava()
{
    return maRbtNoJava.IsChecked();
}

//------------------------------------------------------------------------
BOOL JVMDialog::isInstall()
{
    return maRbtInstall.IsChecked();
}

//------------------------------------------------------------------------
void JVMDialog::selectUseExisting( BOOL bSelect )
{
    maRbtUseExisting.Check( bSelect );
}

//------------------------------------------------------------------------
void JVMDialog::selectNoJava( BOOL bSelect )
{
    maRbtNoJava.Check( bSelect );
}

//------------------------------------------------------------------------
void JVMDialog::selectInstall( BOOL bSelect )
{
    maRbtInstall.Check( bSelect );
}

//------------------------------------------------------------------------
BOOL JVMDialog::insertEntry( const UniString& rEntry, ULONG pUserData )
{
	USHORT nPos = maJavaVMs.InsertEntry( rEntry );

	maJavaVMs.SetEntryData( nPos, (void*) pUserData );

	return TRUE;
}

//------------------------------------------------------------------------
void JVMDialog::clearList()
{
	maJavaVMs.Clear();
}

//------------------------------------------------------------------------
BOOL JVMDialog::getSelectedEntry( ULONG &nUserData )
{
	USHORT nPos = maJavaVMs.GetSelectEntryPos();
	if( maJavaVMs.IsEntryPosSelected( nPos ) )
	{
		nUserData = (ULONG) maJavaVMs.GetEntryData( nPos );

		return TRUE;
	}

	return FALSE;
}

//------------------------------------------------------------------------
void JVMDialog::selectEntry( USHORT nPos )
{
	maJavaVMs.SelectEntryPos( nPos , TRUE );
}

//------------------------------------------------------------------------
USHORT JVMDialog::getEntryCount()
{
	return maJavaVMs.GetEntryCount();
}

//------------------------------------------------------------------------
void JVMDialog::enableListBox( BOOL bEnable )
{
	maJavaVMs.Enable( bEnable );
}

//------------------------------------------------------------------------
void JVMDialog::enableUseExistingRbt( BOOL bEnable )
{
	maRbtUseExisting.Enable( bEnable ) ;
	maJavaVMs.Enable( bEnable );
}

//------------------------------------------------------------------------
void JVMDialog::enableInstallRbt( BOOL bEnable )
{
	maRbtInstall.Enable( bEnable ) ;
}

//------------------------------------------------------------------------

void JVMDialog::update(USHORT nCount, USHORT nSelect, const JVMEntry* pEntryList )
{
	maJavaVMs.Clear();
	
    UniString aListEntry;

    for (USHORT i=0; i<nCount; i++)
	{
        if ( COMPARE_EQUAL == pEntryList[i].mJVMType.CompareIgnoreCaseToAscii( "jre" ) )
            aListEntry = UniString( ResId( STR_JVM_JRE, pResMgr ) );
        else if ( COMPARE_EQUAL == pEntryList[i].mJVMType.CompareIgnoreCaseToAscii( "sdk" ) )
            aListEntry = UniString( ResId( STR_JVM_SDK, pResMgr ) );
        else
        {
            aListEntry = UniString( ResId( STR_JVM_JRE, pResMgr ) );
        }

        aListEntry += UniString::CreateFromAscii(" (");
		aListEntry += UniString( ResId( STR_JVM_VERSION, pResMgr ) );
		aListEntry += UniString::CreateFromAscii(" ");
		aListEntry += pEntryList[i].mVersion;

        if ( pEntryList[i].bIsAccessable )
            aListEntry += UniString( ResId( STR_JVM_ACCESSABLE, pResMgr ) );
        
        aListEntry += UniString::CreateFromAscii(")");
		aListEntry.EraseAllChars( '"' );

		insertEntry( aListEntry.GetBuffer(), i+1 );
	}

	if( nCount )
	{
		selectEntry( nSelect );
		selectUseExisting( TRUE );
		enableUseExistingRbt( TRUE );
	}
	else
	{
		// GetJavaVMEntryCount() == 0 -> Kopieren
		insertEntry( ResId( STR_NO_JAVA_ENTRIES, pResMgr ), 1 );
		
        if ( maRbtInstall.IsEnabled() )
        {
            selectUseExisting( FALSE );
            selectInstall( TRUE );
        }
        else
        {
            selectUseExisting( TRUE );
        }
		enableUseExistingRbt( TRUE );
	}

    nJVMCount = nCount;

    ImplSelectionChanged( this, NULL );

    updateJavaHomeComment();
}

//------------------------------------------------------------------------
void JVMDialog::updateJavaHomeComment()
{
    const JVMEntry* pEntry = GetEntry( maJavaVMs.GetSelectEntryPos() );

    if ( pEntry )
    {
        UniString   javaHome = UniString::CreateFromAscii("Java Home = ");
        OUString    sysPath;

        osl::FileBase::getSystemPathFromFileURL( pEntry->mHome, sysPath );

        javaHome += UniString( sysPath );

        maJavaHomeText.SetText( javaHome );
    }
    else
        maJavaHomeText.SetText( UniString::CreateFromAscii("") );
}

//------------------------------------------------------------------------
IMPL_STATIC_LINK( JVMDialog, ImplSelectionChanged, RadioButton *, EMPTYARG )
{
    if ( pThis->maRbtNoJava.IsChecked() )
    {
        InfoBox( pThis, ResId( DLG_QUERYNOJAVA ) ).Execute();

        pThis->maListboxText.Enable( FALSE );
        pThis->maJavaVMs.Enable( FALSE ) ;
        pThis->maJavaHomeText.Enable( FALSE );
        pThis->maBrowse.Enable( FALSE ) ;
        pThis->maBrowseText.Enable( FALSE );
        pThis->maOK.Enable( TRUE );
    }
    else if ( pThis->maRbtUseExisting.IsChecked() )
    {
        if ( pThis->nJVMCount == 0 )
        {
            pThis->maListboxText.Enable( FALSE );
            pThis->maJavaVMs.Enable( FALSE ) ;
            pThis->maJavaHomeText.Enable( FALSE );
            pThis->maOK.Enable( FALSE );
        }
        else
        {
            pThis->maListboxText.Enable( TRUE );
            pThis->maJavaVMs.Enable( TRUE ) ;
            pThis->maJavaHomeText.Enable( TRUE );
            pThis->maOK.Enable( TRUE );
        }

        pThis->maBrowse.Enable( TRUE ) ;
        pThis->maBrowseText.Enable( TRUE );
    }
    else if ( pThis->maRbtInstall.IsChecked() )
    {
        pThis->maListboxText.Enable( FALSE );
        pThis->maJavaVMs.Enable( FALSE ) ;
        pThis->maJavaHomeText.Enable( FALSE );
        pThis->maBrowse.Enable( TRUE ) ;
        pThis->maBrowseText.Enable( TRUE );
        pThis->maOK.Enable( TRUE );
    }

	return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( JVMDialog, HelpHdl, Button *, EMPTYARG )
{
	if (bHelpMode)
	{
		maHelp.SetText( ResId( STR_HELP, pResMgr ) );
		maHelpEdit.Hide();
		maContainer.Show();
		maOK.Show();
		maCancel.Show();
	}
	else
	{
		maHelp.SetText( ResId( STR_BACK, pResMgr) );
		maHelpEdit.Show();
		maContainer.Hide();
		maOK.Hide();
		maCancel.Hide();
	}

	bHelpMode = !bHelpMode;

	return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( JVMDialog, BrowseHdl, PushButton *, EMPTYARG )
{
	SiDirEntry currentDir(".");
	currentDir.ToAbs();

	PathDialog dlg(NULL, 0, FALSE);
	dlg.SetPath( UniString(currentDir.GetFull(), osl_getThreadTextEncoding()) );

	if ( dlg.Execute() )
	{
		JVMEntry entry;

        if ( GetInstalledVM( entry, dlg.GetPath() ) )
		{
            AddEntry( entry, this );
		}
		else
		{
			InfoBox(this, ResId(DLG_NO_VALID_VM_FOUND)).Execute();
		}
	}

	return 0;
}

//------------------------------------------------------------------------
void JVMDialog::install()
{
	InstallNewJavaEnvironment( aSourcePath, aDestPath, aInstallPackage, aVersion, this );
}

//------------------------------------------------------------------------
void JVMDialog::selectInstalledJVM( USHORT nSelect )
{
    maRbtInstall.Check( FALSE );
    maRbtNoJava.Check( FALSE );
    maRbtUseExisting.Check( TRUE );

    selectEntry( nSelect );
    EndDialog( FALSE );
}

//------------------------------------------------------------------------
IMPL_LINK( JVMDialog, CancelHdl, CancelButton *, EMPTYARG )
{
	bAbort = FALSE;

	if ( bIsSetupMode )
	{
		if ( QueryBox(this, ResId(DLG_QUERYEXITBOX)).Execute() == RET_YES )
		{
			bAbort = TRUE;
			EndDialog( FALSE );
		}
	}
	else
	{
		bAbort = TRUE;
		EndDialog( FALSE );
	}

	return 0;
}

IMPL_LINK( JVMDialog, OKHdl, OKButton *, EMPTYARG )
{
    if ( isInstall() )
    {
        install();
    }
    else
    {
		EndDialog( FALSE );
    }

    return 0;
}

IMPL_LINK( JVMDialog, SelectHdl, ListBox *, EMPTYARG )
{
	updateJavaHomeComment();
	return 0;
}

