/*
 *
 *  $RCSfile: jvmsetup.cxx,v $
 *
 *  $Revision: 1.50 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/15 14:33:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _VOS_PROCESS_HXX_ //autogen
#include <vos/process.hxx>
#endif

#ifndef _VOS_THREAD_HXX_ //autogen
#include <vos/thread.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <tools/solar.h>
#include <sifsys.hxx>
#include <tools/debug.hxx>
#include <tools/stream.hxx>
#include <tools/string.hxx>
#include <tools/config.hxx>
#include <rtl/string.hxx>

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#include "jvmaccess/javainfo.hxx"

#include "environ.hxx"

#include "sicustom.hxx"
#include "jvmscan.hxx"
#include "jvmdlg.hxx"
#include "jvmdlg.hrc"

#include "jvmsetup.hxx"

#include <stdio.h>

#ifdef UNX
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <grp.h>
#endif

#if defined ( UNX ) || defined( MAC )
#include <limits.h>
#define _MAX_PATH PATH_MAX
#endif

#define	JAVA_SECTION			"Java"
#define INSTALL_SECTION			"Install"
#define	JAVA_VERSION			"Version"
#define	JAVA_HOME				"Home"
#define JAVA_SUPPORT			"Java"
#define JAVASCRIPT_SUPPORT		"JavaScript"
#define APPLET_SUPPORT			"Applets"
#define SYSTEM_CLASSPATH		"SystemClasspath"
#define JAVA_RUNTIME			"RuntimeLib"
#define	JAVA_LIBPATH			"JavaLibPath"
#define	JAVA_CPLD				"com.sun.star.comp.loader.CPLD_ACCESSPATH"

#define USER_SECTION            (TRUE)
#define SHARE_SECTION           (FALSE)

#ifdef UNX
#define	JAVA_INI                "javarc"
#define PROG_DIR                "/program/"
#define DIR_SEP                 "/"
#define PATH_SEP                ":"
#else
#define	JAVA_INI                "java.ini"
#define PROG_DIR                "\\program\\"
#define DIR_SEP                 "\\"
#define PATH_SEP                ";"
#endif

using namespace vos;
using namespace rtl;
using namespace osl;

ByteString GetAdditionalJarPath( const JVMEntry& rEntry, const ByteString& rJar );
USHORT     GetJavaVirtualMachine( JVMEntry * pJVM );
BOOL       GetInstalledVM( JVMEntry& entry, const ByteString& rDestPath );
BOOL       CheckVersion( const String& rVersion );
BOOL       _compareJVMEntries( const JVMEntry& a, const JVMEntry& b );

// unschoene Loesung...
// Die verschiedenen Plattformabhaengigen erlaubten Java Versionsnummern
// fuer die Kontrolle in IsValidJVMEntry( const JVMEntry& aJvmEntry );
// Das v hinter der Verisonsnummer gibt an, ob diese Version uns schon verifiziert
// worden ist.

SiSetupFnc aSetupFnc;

static ResMgr* pResMgr_JVM = 0;

const char *	envPath = NULL;
JVMEntry		aEntryList[ MAX_LIST_ENTRIES ];
USHORT			nEntriesCount	= 0;
USHORT			nBestEntry		= 0;
BOOL			bHasInstPackage = FALSE;
JavaInstProps	aJavaInstProps;

ByteString 		strDestinationPath;
UniString       strLastSelectedJava;
UniString 		strResourceHook_ProductName;
UniString 		strResourceHook_ProductVersion;
ResHookProc		fncOldResourceHook = NULL;

class OJavaInstallThread : public OThread
{
	OProcess::TProcessError m_ProcessError;
	JVMDialog* 				pDialog;
	ByteString 				m_ProgramName;
	ByteString 				mSourcePath;
	ByteString 				mDestPath;
	ByteString 				mInstallPackage;
    ByteString              mVersion;

	void install();

public:
	NAMESPACE_VOS(OCondition) aWaitCondition;

	OJavaInstallThread( const ByteString& srcPath,
						const ByteString& destPath,
						const ByteString& package,
                        const ByteString& version,
						JVMDialog* pDialog = NULL
	);
	virtual void SAL_CALL run();
	virtual void SAL_CALL onTerminated();
	vos::OProcess::TProcessError getError() { return m_ProcessError; }

};

OJavaInstallThread::OJavaInstallThread( const ByteString& srcPath,
										const ByteString& destPath,
										const ByteString& package,
                                        const ByteString& version,
										JVMDialog* pDialog )
{
	this->pDialog	= pDialog;
	mSourcePath		= srcPath;
	mDestPath		= destPath;
	mInstallPackage = package;
    mVersion        = version;

	if (!pDialog)
	{
		aWaitCondition.set();
		aWaitCondition.reset();
	}
}

#ifdef UNX
BOOL _findImage( const char* pImg )
{
	BOOL bReturn 				= FALSE;
	rtl_uString* ustrImage		= NULL;
	rtl_uString* ustrSrchPath	= NULL;
	rtl_uString* ustrPath		= NULL;

	rtl_uString_newFromAscii( &ustrImage, pImg );
	rtl_uString_newFromAscii( &ustrSrchPath, getenv("PATH") );

	if( osl_File_E_None == osl_searchFileURL(ustrImage, ustrSrchPath, &ustrPath) )
		if( ustrPath != 0 )
			bReturn = TRUE;

	rtl_uString_release( ustrImage );
	rtl_uString_release( ustrSrchPath );

	return bReturn;
}
#endif

void OJavaInstallThread::install()
{
	if (bHasInstPackage)
	{
#ifdef UNX
		// change current working directory to install path
		SiDirEntry aCurrentDir(".");
		SiDirEntry( mDestPath ).SetCWD();

		ByteString savePath = "PATH=";
		savePath += getenv ( "PATH" );

		ByteString path = savePath;
		path += ":/usr/openwin/bin:/usr/X11R6/bin:/usr/bin/X11";
		putenv ( strdup( path.GetBuffer() ) );

		// start the installation in a new xterm

		rtl::OUString sArgs[8];
		sArgs[0] = OUString::createFromAscii("-T");
		sArgs[1] = OUString::createFromAscii("JavaInstall");
		sArgs[2] = OUString::createFromAscii("-e");
		sArgs[3] = OUString::createFromAscii( mInstallPackage.GetBuffer() );
		sArgs[4] = OUString::createFromAscii("-bg");
		sArgs[5] = OUString::createFromAscii("white");
		sArgs[6] = OUString::createFromAscii("-fg");
		sArgs[7] = OUString::createFromAscii("black");

		OUString auCommand;
		OUString auSearchPath;

		char cTerm[200];

		if( _findImage("dtterm") )
		{
			strncpy( cTerm, "dtterm", sizeof(cTerm) );
			sArgs[0] = OUString::createFromAscii("-title");
		}
		else if( _findImage("kterm") )
		{
			strncpy( cTerm, "kterm", sizeof(cTerm) );
		}
		else if ( _findImage("xterm") )
		{
			strncpy( cTerm, "xterm", sizeof(cTerm) );
		}
		else
		{
            NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

            UniString errMsg;
            if ( pDialog )
                errMsg = pDialog->getNoTermMsg();
            else
                errMsg = UniString::CreateFromAscii("No terminal program could be found.\nThe Java installation process will therefore be aborted");
            ErrorBox( pDialog, WB_OK, errMsg).Execute();
            m_ProcessError = vos::OProcess::E_NotFound;

            return;     // no terminal found, return!
		}

        FileBase::RC result = File::searchFileURL( OUString::createFromAscii(cTerm), auSearchPath, auCommand );

		VOS_ASSERT(result == File::E_None);

		//fprintf(stdout, "path to xterm %s\n", OUStringToOString(auCommand, osl_getThreadTextEncoding()).getStr());
		vos::OProcess aProcess( auCommand );
		//aProcess.addEnvironment("PATH", path);

		m_ProcessError = aProcess.execute( (vos::OProcess::TProcessOption)
			(vos::OProcess::TOption_Normal | vos::OProcess::TOption_SearchPath), vos::OArgumentList(sArgs, 8) );

		if ( m_ProcessError != vos::OProcess::E_None  )// if an error occured try it without the xterm
		{
			FileBase::RC result = File::getFileURLFromSystemPath(OUString(mInstallPackage.GetBuffer(), mInstallPackage.Len(), osl_getThreadTextEncoding()), auCommand);
            VOS_ASSERT(result == File::E_None);
			vos::OProcess aProcess2(auCommand);
			m_ProcessError = aProcess2.execute( (vos::OProcess::TProcessOption)
				(vos::OProcess::TOption_Normal | vos::OProcess::TOption_SearchPath));
		}

		putenv ( strdup( savePath.GetBuffer() ) );

        m_ProcessError = aProcess.join();

        aCurrentDir.SetCWD();
#elif defined WNT
        BOOL      bCheckReturn = FALSE;
		sal_Int32 nMajor = 0;
        sal_Int32 nMinor = 0;
        sal_Int32 nMicro = 0;

        if ( mVersion.Len() )
        {
            nMajor = mVersion.GetToken( 0, '.' ).ToInt32();
            nMinor = mVersion.GetToken( 1, '.' ).ToInt32();
            nMicro = mVersion.GetToken( 2, '.' ).ToInt32();
        }

        vos::OProcess aProcess( OUString(mInstallPackage.GetBuffer(), mInstallPackage.Len(), osl_getThreadTextEncoding()) );

        if( ( nMajor > 1 ) ||
            ( ( nMajor == 1 ) && ( nMinor > 4 ) ) ||
            ( ( nMajor == 1 ) && ( nMinor == 4 ) && ( nMicro >= 2 ) ) )
        {
            rtl::OUString sArgs[1];
            sArgs[0] = OUString::createFromAscii("/v\"REBOOT=R\"");
            bCheckReturn = TRUE;

            m_ProcessError = aProcess.execute( vos::OProcess::TOption_Normal, vos::OArgumentList(sArgs, 1) );
        }
        else
        {
            m_ProcessError = aProcess.execute( vos::OProcess::TOption_Normal );
        }

        m_ProcessError = aProcess.join();

        if ( bCheckReturn )
        {
            vos::OProcess::TProcessInfo aProcessInfo;
            if ( aProcess.getInfo( vos::OProcess::TProcessData::TData_ExitCode, &aProcessInfo ) == vos::OProcess::E_None )
            {
                if ( aProcessInfo.Code == 3010 )
                {
                    SiEnvironment *pEnv = NULL;
                    if ( pDialog->getCustomEnv() )
                        pEnv = pDialog->getCustomEnv()->GetBigEnv();
                    if ( pEnv )
                        pEnv->SetReboot( TRUE );
                }
            }
        }
#else
		vos::OProcess aProcess( OUString(mInstallPackage.GetBuffer(), mInstallPackage.Len(), osl_getThreadTextEncoding()) );
		m_ProcessError = aProcess.execute( vos::OProcess::TOption_Normal );
		m_ProcessError = aProcess.join();
#endif
	}
}

void OJavaInstallThread::run()
{
	JVMEntry  *pLastJVMList  = NULL;
    USHORT     nCurrJVMCount = 0;
    USHORT     nLastJVMCount = nEntriesCount;

    // save list of currently installed JVMs so we can detect the new installed
    // JVM and select it for usage
    if ( pDialog && nLastJVMCount )
    {
        pLastJVMList = new JVMEntry[ nLastJVMCount ];
        for ( ULONG i=0; i<nLastJVMCount; i++ )
            pLastJVMList[i] = aEntryList[i];
    }

    install();

	UpdateList();

	nCurrJVMCount = nEntriesCount;
    
    if ( !pDialog )
	{
		aWaitCondition.set();
	}
	else
	{
		NAMESPACE_VOS(OGuard) aGuard( Application::GetSolarMutex() );
		pDialog->EnableInput( TRUE );
		pDialog->ToTop(); // for Windows 2000
		pDialog->GrabFocusToFirstControl();

		pDialog->update( nEntriesCount, nBestEntry, aEntryList );

        // search for the new installed JVM
        for ( USHORT i=0; i<nCurrJVMCount; i++ )
        {
            BOOL bFound = FALSE;

            for ( USHORT j=0; j<nLastJVMCount; j++ )
            {
                if ( _compareJVMEntries( aEntryList[i], pLastJVMList[j] ) )
                {
                    bFound = TRUE;
                    break;
                }
            }
            if ( !bFound )
            {
                pDialog->selectInstalledJVM( i );
                break;
            }
        }
	}

    if ( pLastJVMList )
        delete [] pLastJVMList;
}

void OJavaInstallThread::onTerminated()
{
    if ( pDialog )
	{
		delete this;
	}
}

BOOL VerifyInstallProperties();

void ReadInstallSection( ByteString iniFile );
void WriteInstallSection( ByteString iniFile );

ByteString GetJavaIniURL( const ByteString& rDestPath, BOOL bUser );

////////////////////////////////////////////////////////////////////////////////
//
//	EntryPoint
//
extern "C"
{
BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return FALSE;

	pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

	aSetupFnc.nVersion 				= pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup			= pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup			= pSetupFnc->fncShowSetup;
	aSetupFnc.fncGetCodeFilename	= pSetupFnc->fncGetCodeFilename;

	return TRUE;
};
}

void ResourceHook_JVM( UniString& rStr )
{
	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTNAME"), strResourceHook_ProductName );
	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTVERSION"), strResourceHook_ProductVersion );
}

ResMgr* GetResourceManager( const ByteString resName,
                            const ByteString resPath,
                            LanguageType &rLangType )
{
	ResMgr* pResMgr;

    pResMgr = ResMgr::SearchCreateResMgr( resName.GetBuffer(), rLangType );

	if ( !pResMgr )
	{
		SiDirEntry resource( resPath );
		resource += SiDirEntry( "resource" );
		resource += SiDirEntry( resName );

		pResMgr	  = ResMgr::SearchCreateResMgr( resource.GetFull().GetBuffer(), rLangType );
	}

    if( !fncOldResourceHook ) fncOldResourceHook = ResMgr::GetReadStringHook();
	ResMgr::SetReadStringHook( ResourceHook_JVM );

	return pResMgr;
};

////////////////////////////////////////////////////////////////////////////////
//
//	CustomMain
//
BOOL _SV_CALL CustomMain( SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList )
{
	enum { INST_NONE, INST_NEW, INST_PRE, INST_PRE_NONE };

	ULONG		nSelectedEntry		= 0;
	UINT32		nInstallType		= INST_PRE;
	BOOL		bIsSetupMode		= pModuleList != NULL;
	BOOL		bIsWorkstation		= FALSE;

	ByteString		aDestIniName;
	ByteString		aSrcIniName;

	ByteString aSourcePath 	= pEnv->GetSourcePath();
	ByteString aDestPath	= pEnv->GetDestPath();
	ByteString aClassDir;
	ByteString aInstallPackage;
	ByteString aInstallPath;

	if(bIsSetupMode)
	{
		strResourceHook_ProductName		= UniString(pEnv->GetBigEnv()->GetSingleProductName(), osl_getThreadTextEncoding());
		strResourceHook_ProductVersion	= UniString(pEnv->GetBigEnv()->GetProductVersion(), osl_getThreadTextEncoding());
	}
	else
	{
		strResourceHook_ProductName		= pEnv->getProductName();
        bIsWorkstation                  = IsWorkstation( aSourcePath );
		// strResourceHook_ProductVersion	= UniString(pEnv->GetBigEnv()->GetProductVersion(), osl_getThreadTextEncoding());
	}

#ifdef UNX
	SiCustomModuleInfo* pPgpModule = NULL;
#endif
	//WarningBox( NULL, WB_OK, UniString::CreateFromAscii("Debug Stop.")).Execute();
	if ( bIsSetupMode )
	{

#ifdef UNX
		// looking up for PGP
		unsigned int i = 0;
		while ( i<pModuleList->Count() && !pPgpModule )
		{
			SiCustomModuleInfo* pCurrentModule = pModuleList->GetObject( i++ );
			ByteString aCurrentModuleID = pCurrentModule->GetModuleID();
			if ( aCurrentModuleID == PGP_MODULE_ID )
			{
				pPgpModule = pCurrentModule;
			}
		}
#endif

		bIsWorkstation = pEnv->GetBigEnv()->GetInstallType() == IT_WORKSTATION || pEnv->GetBigEnv()->InstallFromNet();
	}

	// look for the resource
	if ( ! pEnv->IsResponseFileMode() )
	{
		LanguageType nLangType = LANGUAGE_SYSTEM;
        ByteString	aResFileName("jvm");
		aResFileName += MAKE_NUMSTR( SUPD );

        if ( bIsSetupMode )
            nLangType = pEnv->GetBigEnv()->GetUILanguageType();

		ByteString aStartPath = pEnv->GetStartPath();

		pResMgr_JVM = GetResourceManager( aResFileName, aStartPath, nLangType );

		if ( ! pResMgr_JVM )
		{
			UniString errMsg = UniString::CreateFromAscii("Java Setup : can't find resource:\n");
			errMsg += UniString( aResFileName, osl_getThreadTextEncoding() );
			WarningBox( NULL, WB_OK, errMsg).Execute();
			ResMgr::SetReadStringHook( fncOldResourceHook );
			return TRUE; // return FALSE -> Setup exit
		}
		
        if ( !bIsSetupMode )
        {
            AllSettings aSettings = Application::GetSettings();
            aSettings.SetUILanguage( nLangType );
            Application::SetSettings( aSettings );
        }
	}

	if ( bIsWorkstation && bIsSetupMode )
	{
		aSourcePath += PROG_DIR;
	}
	else
	{
		aSourcePath += DIR_SEP;
	}

	aDestPath += PROG_DIR;

    aClassDir = bIsWorkstation? aSourcePath : aDestPath;
	aClassDir += "classes";

//      OUString aTempSrc = UniString( aClassDir, osl_getThreadTextEncoding() );
//      OUString aTemp;
//	FileBase::getSystemPathFromFileURL( aTempSrc, aTemp );
//	aClassDir = ByteString( UniString(aTemp), osl_getThreadTextEncoding() );

	// fprintf(stderr, "set source path to %s\n", aSourcePath.GetBuffer());
	// fprintf(stderr, "set dest path to %s\n", aDestPath.GetBuffer());


	if ( bIsSetupMode ) // seems to be the setup
	{
        BOOL bLocal = pEnv->GetBigEnv()->IsLocal();        

        // when there is a java ini file created by a network installation,
        // we must not create a new one for the workstation installation and
        // therefor quit here #101509#
        if ( pEnv->GetBigEnv()->GetInstallMode() == IM_WORKSTATION )
        {
            ByteString aShareIniURL = GetJavaIniURL( pEnv->GetSourcePath(), SHARE_SECTION );
            SiDirEntry aShareIni( aShareIniURL );
            if ( aShareIni.Exists() )
            {
            	ResMgr::SetReadStringHook( fncOldResourceHook );
                return TRUE;
            }
        }
        
        aDestIniName = GetJavaIniURL( pEnv->GetDestPath(), bLocal );
        
		aSrcIniName = aSetupFnc.fncGetCodeFilename();
		
        // convert the temp file name returned from fncGetCodeFilename into a file URL
        OUString aTmpName( aSrcIniName.GetBuffer(), aSrcIniName.Len(), osl_getThreadTextEncoding() );
        File::getFileURLFromSystemPath( aTmpName,  aTmpName);
        aSrcIniName = OUStringToOString( aTmpName, osl_getThreadTextEncoding() );
        
        ReadInstallSection( aSrcIniName );

		//WriteInstallSection( aDestIniName );
	}
	else
	{
        // Check whether we want to write the java ini file into the user or the shared config
        // section. The parameter '--shared' means we want to use the shared section

        BOOL bSharedEnv = FALSE;
        for ( int i = 0; i < Application::GetCommandLineParamCount(); ++i )
	    {
		    ByteString aParam = ByteString( Application::GetCommandLineParam(i),
                                            osl_getThreadTextEncoding() );
            if ( aParam.CompareIgnoreCaseToAscii( "--shared" ) == COMPARE_EQUAL )
                bSharedEnv = TRUE;
        }

        // first look at $OFFICEHOME$/user/config
        aDestIniName = GetJavaIniURL( pEnv->GetInstalledPath(), USER_SECTION );

		if ( !bSharedEnv && SiDirEntry( aDestIniName ).Exists() )
		{
			// looks like an user installation
			aSrcIniName = aDestIniName;
		}
		else
		{
            ByteString  aSrcPath = pEnv->GetSourcePath();
            xub_StrLen  nIndex = aSrcPath.SearchCharBackward( DIR_SEP );
            aSrcPath.Erase( nIndex );

            aSrcIniName = GetJavaIniURL( aSrcPath, SHARE_SECTION );
            
            if ( bSharedEnv )
                aDestIniName = aSrcIniName;
			
            if ( ! SiDirEntry( aSrcIniName ).Exists() )
			{
				// now we have a problem
#ifdef UNX
				UniString errMsg(RTL_CONSTASCII_USTRINGPARAM("Java Setup : can't find javarc"));
#else
				UniString errMsg(RTL_CONSTASCII_USTRINGPARAM("Java Setup : can't find java.ini"));
#endif
				WarningBox( NULL, WB_OK, errMsg).Execute();
				ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE; // return FALSE -> Setup exit
			}
		}

		ReadInstallSection( aSrcIniName );
	}

	if ( !VerifyInstallProperties() )
	{
		ResMgr::SetReadStringHook( fncOldResourceHook );
		return TRUE;
	}

	if ( aJavaInstProps.find(INSTALLATION_PACKAGE) != aJavaInstProps.end() )
	{
		if ( bIsSetupMode && pEnv->GetBigEnv()->IsBigMode() )
		{
			ArchDirectory* pArchive = pEnv->GetBigEnv()->GetArchive();

			if ( pArchive->ExistsFile( aJavaInstProps[INSTALLATION_PACKAGE].GetBuffer() ) )
			{
				pArchive->GetFile( aJavaInstProps[INSTALLATION_PACKAGE].GetBuffer(), pEnv->GetStartPath().GetBuffer() );

				SiDirEntry aEntry( pEnv->GetStartPath() );
				aEntry += SiDirEntry( aJavaInstProps[INSTALLATION_PACKAGE] );
				bHasInstPackage = aEntry.Exists();
				if( bHasInstPackage )
				{
					aInstallPackage = aEntry.GetFull();
#ifdef UNX
					chmod( aInstallPackage.GetBuffer(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH );
#endif
				}
			}
		}
		else
		{
			aInstallPackage = aSourcePath;
			aInstallPackage += aJavaInstProps[INSTALLATION_PACKAGE];
			bHasInstPackage = SiDirEntry( aInstallPackage ).Exists();
		}

		aInstallPath     = aDestPath;
        aInstallPath    += aJavaInstProps[PACKAGE_INSTALL_DIR];

		// fprintf(stderr, "set install package to %s\n", aInstallPackage.GetBuffer());
		// fprintf(stderr, "set install path to %s\n", aInstallPath.GetBuffer());
	}

#ifdef UNX

	// append the Java installation path to PATH
	// so the scan routine can find the installation
	ByteString aNewPath( "PATH=" );
	aNewPath += aInstallPath;
	aNewPath += "/bin:";
    
    // append source dir, too, when bIsWorkstation is set
    if ( bIsWorkstation )
    {
        aNewPath += aSourcePath;
        aNewPath += aJavaInstProps[PACKAGE_INSTALL_DIR];
        aNewPath += "/bin:";
    }

	aNewPath += getenv ("PATH");

	if ( envPath )
	{
		free( const_cast<char*>(envPath) );
	}

	envPath = strdup( aNewPath.GetBuffer() );
	putenv( const_cast<char*>(envPath) );

	// fprintf( stderr, "adding %s to search path\n", aNewPath.GetBuffer() );

#endif

	UpdateList();

	strDestinationPath = aDestPath;
    nSelectedEntry = nBestEntry;

	if ( pEnv->IsResponseFileMode() ) // response mode enabled
	{
		rtl::OUString aResFileName = rtl::OUString(pEnv->GetResponseFileName().GetBuffer(),
				pEnv->GetResponseFileName().Len(), osl_getThreadTextEncoding() );

		// #92976#
        FileBase::RC res = File::getFileURLFromSystemPath( aResFileName,  aResFileName);
        // VOS_ENSURE(res == FileBase::E_None, "Can't convert responce file name in unc notation!");

        Config      aRspFile( aResFileName );
        ByteString  aValue;

        aRspFile.SetGroup( "Java" );
        aValue = aRspFile.ReadKey( "JavaSupport" );

		WriteInstallSection( aDestIniName );

		if ( aValue.Len() )
		{
			if ( aValue.EqualsIgnoreCaseAscii("none") )
			{
				nInstallType = INST_NONE;
#ifdef UNX
				if ( pPgpModule && pPgpModule->IsSelected() )
					pPgpModule->DeselectModule();
#endif
			}
			else
			if ( aValue.EqualsIgnoreCaseAscii("newinstall") )
			{
				if (bHasInstPackage)
				{
					ByteString aVersion;
                    
                    if ( aJavaInstProps.find( VERSION ) != aJavaInstProps.end() )
                        aVersion = aJavaInstProps[ VERSION ];

                    if ( InstallNewJavaEnvironment( aSourcePath, aDestPath, aInstallPackage, aVersion, NULL ) )
					{
						JVMEntry entry;

                        if ( GetInstalledVM( entry, aInstallPath ) )
						{
							WriteVMInfoToFile( entry, aDestIniName, aClassDir );
							WriteJavaSupportToFile(TRUE, aDestIniName );
							ResMgr::SetReadStringHook( fncOldResourceHook );
							return TRUE;
						}
					}
				}

#ifdef UNX
				if ( pPgpModule && pPgpModule->IsSelected() )
					pPgpModule->DeselectModule();
#endif
				WriteJavaSupportToFile( FALSE, aDestIniName );
				ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE;
			}
			else
			if ( aValue.EqualsIgnoreCaseAscii("preinstalled_or_none") )
			{
				if ( nEntriesCount )
				{
					WriteVMInfoToFile( aEntryList[nBestEntry], aDestIniName, aClassDir );
					WriteJavaSupportToFile( TRUE, aDestIniName );
				}
				else
				{
#ifdef UNX
					if ( pPgpModule && pPgpModule->IsSelected() )
						pPgpModule->DeselectModule();
#endif
					WriteJavaSupportToFile( FALSE, aDestIniName );
				}

				ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE;
			}
			else //	preinstalled and all other (default)
			{
				if ( nEntriesCount )
				{
					WriteVMInfoToFile( aEntryList[nBestEntry], aDestIniName, aClassDir );
					WriteJavaSupportToFile( TRUE, aDestIniName );
				}
				else
				{
					if ( bHasInstPackage )
					{
					    ByteString aVersion;
                        
                        if ( aJavaInstProps.find( VERSION ) != aJavaInstProps.end() )
                            aVersion = aJavaInstProps[ VERSION ];

                        if ( InstallNewJavaEnvironment( aSourcePath, aDestPath, aInstallPackage, aVersion, NULL ) )
						{
							JVMEntry entry;

                            if ( GetInstalledVM( entry, aInstallPath ) )
							{
								WriteVMInfoToFile( entry, aDestIniName, aClassDir );
								WriteJavaSupportToFile( TRUE, aDestIniName );
								ResMgr::SetReadStringHook( fncOldResourceHook );
								return TRUE;
							}
						}
					}
#ifdef UNX
					if ( pPgpModule && pPgpModule->IsSelected() )
						pPgpModule->DeselectModule();
#endif
					WriteJavaSupportToFile( FALSE, aDestIniName );
				}
				ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE;
			}
		}
	}
	else // no response mode
	{
        // select the last used Java, if there is one
        if ( strLastSelectedJava.Len() )
        {
            for( USHORT i=0; i < nEntriesCount; i++ )
            {
                if ( aEntryList[ i ].mVersion == strLastSelectedJava )
                {
                    nSelectedEntry = i;
                    break;
                }
            }
        }

		ByteString aVersion;

        if ( aJavaInstProps.find( VERSION ) != aJavaInstProps.end() )
            aVersion = aJavaInstProps[ VERSION ];

		JVMDialog aDlg ( NULL, pResMgr_JVM, pEnv, pModuleList,
						 aSourcePath, aDestPath, aInstallPackage, aVersion,
						 bIsSetupMode );
		aDlg.update( nEntriesCount, (USHORT) nSelectedEntry, aEntryList );

		if ( bHasInstPackage )
		{
			// fprintf( stderr, "looking for package %s\n", aInstallPackage.GetBuffer() );
			aDlg.enableInstallRbt( SiDirEntry( aInstallPackage ).Exists() );
		}

		aDlg.ToTop(); // for Windows 2000
		aDlg.GrabFocusToFirstControl();
		aDlg.Execute();

		if ( aDlg.abort() )
		{
			ResMgr::SetReadStringHook( fncOldResourceHook );
			return FALSE;
		}

		// ok - we are here - we should write out the properties
		WriteInstallSection( aDestIniName );

		if ( aDlg.isNoJava() )
		{
			nInstallType = INST_NONE;
		}
		else
		{
			nInstallType = INST_PRE;
			aDlg.getSelectedEntry( nSelectedEntry );

			if (nSelectedEntry)
			{
				nSelectedEntry --;
			}

		}
	} // end of else IsResponseFileMode

	switch ( nInstallType )
	{
		case INST_NONE		:
			WriteJavaSupportToFile(FALSE, aDestIniName );
			break;

		case INST_NEW		:
			WriteJavaSupportToFile(TRUE, aDestIniName );
			break;

		case INST_PRE_NONE	:
			if ( nEntriesCount )
			{
				WriteVMInfoToFile( aEntryList[ nSelectedEntry ], aDestIniName, aClassDir );
				WriteJavaSupportToFile(TRUE, aDestIniName );
			}
			else // no pre installed VM found -- now do nothing
			if ( nInstallType == INST_PRE_NONE )
				WriteJavaSupportToFile(FALSE, aDestIniName );
			break;

		case INST_PRE		:
		default				:
			if ( nEntriesCount )
			{
				WriteVMInfoToFile( aEntryList[ nSelectedEntry ], aDestIniName, aClassDir );
				WriteJavaSupportToFile( TRUE, aDestIniName );
			}
			else // no pre installed VM found -- now install new
			{
				WriteJavaSupportToFile(TRUE, aDestIniName );
			}
			break;
	};

	ResMgr::SetReadStringHook( fncOldResourceHook );
	return TRUE;
}

void UpdateList()
{
	nEntriesCount = GetJavaVirtualMachine( aEntryList );

	int i;

	for( i=0; i < nEntriesCount; i++ )
	{
		if ( aEntryList[ i ].bIsBestVersion )
		{
			nBestEntry = i;
			break;
		}
	}
}

BOOL _compareJVMEntries( const JVMEntry& a, const JVMEntry& b )
{
	if( a.mVersion		== b.mVersion &&
		a.mHome			== b.mHome &&
		a.mRuntimeLib	== b.mRuntimeLib &&
		a.mLibPath		== b.mLibPath &&
		a.mJVMType		== b.mJVMType )
		return TRUE;
	return FALSE;
}

void AddEntry(const JVMEntry entry, JVMDialog* pDlg)
{
	int i;
	for( i = 0; i < nEntriesCount; i++ )
		if( _compareJVMEntries(entry, aEntryList[ i ]) )
			return;

	if ( nEntriesCount >= MAX_LIST_ENTRIES )
        return;

    for( i = 0; i < nEntriesCount; i++ )
		aEntryList[ i ].bIsBestVersion  = FALSE;

	aEntryList[ nEntriesCount ] = entry;
	aEntryList[ nEntriesCount ].bIsBestVersion  = TRUE;
	nBestEntry = nEntriesCount ++;

	if (pDlg)
		pDlg->update( nEntriesCount, nBestEntry, aEntryList );
}

BOOL WriteVMInfoToFile( const JVMEntry& rJvmEntry, const ByteString& aIniFile, const ByteString& aClassDir )
{
#ifdef WNT
    // #109938# the ATToolSupport settings are not used on other platforms but
    // UNIX might crash when SetEnableATToolSupport() tries to enable accessability!
    AllSettings  aAllSettings( Application::GetSettings() );
    MiscSettings aMiscSettings( aAllSettings.GetMiscSettings() );

    // so now we get the ATTool Settings.
    aMiscSettings.SetEnableATToolSupport( rJvmEntry.bIsAccessable );
    aAllSettings.SetMiscSettings( aMiscSettings );
    Application::SetSettings( aAllSettings );
#endif

    Config      aSoIni( String( aIniFile, osl_getThreadTextEncoding() ) );
    ByteString  aBuffer;

	ByteString aCPLDPath( strDestinationPath );
	aCPLDPath += "/program;";
	aCPLDPath += strDestinationPath;
	aCPLDPath += "/program/classes";

    aBuffer = ByteString( rJvmEntry.mHome, RTL_TEXTENCODING_UTF8 );

    aSoIni.SetGroup( JAVA_SECTION );
	aSoIni.WriteKey( JAVA_HOME, aBuffer );

	if( aJavaInstProps.find(CPLD_PATH) != aJavaInstProps.end() )
	{
		ByteString val = aJavaInstProps[CPLD_PATH];
		if( val.ToInt32() == 1 )
        {
			aSoIni.WriteKey( JAVA_CPLD, aCPLDPath );
        }
	}

	aBuffer = ByteString( rJvmEntry.mJVMType, RTL_TEXTENCODING_UTF8 );
    aSoIni.WriteKey( VM_TYPE, aBuffer );

	aBuffer = ByteString( rJvmEntry.mVersion, RTL_TEXTENCODING_UTF8 );
    aSoIni.WriteKey( JAVA_VERSION, aBuffer );

	aBuffer = ByteString( rJvmEntry.mRuntimeLib, RTL_TEXTENCODING_UTF8 );
	aSoIni.WriteKey( JAVA_RUNTIME, aBuffer );

#ifdef UNIX
	aBuffer = ByteString( rJvmEntry.mLibPath, RTL_TEXTENCODING_UTF8 );
	aSoIni.WriteKey( JAVA_LIBPATH, aBuffer );
#endif

	ByteString addClasspath;

    if (aJavaInstProps.find(ADDITIONAL_CLASSPATH) != aJavaInstProps.end() )
	{
		addClasspath = aJavaInstProps[ADDITIONAL_CLASSPATH];
		addClasspath.SearchAndReplaceAll( CLASSDIR, aClassDir );
        addClasspath.Convert( osl_getThreadTextEncoding(), RTL_TEXTENCODING_UTF8 );
	}

    if( aJavaInstProps.find( ADDITIONAL_JARS ) != aJavaInstProps.end() )
    {
        xub_StrLen nTok = 0;
        ByteString aAddJars = aJavaInstProps[ ADDITIONAL_JARS ];
        ByteString aAddJar = aAddJars.GetToken( nTok++ );

        while ( aAddJar.Len() )
        {
            aBuffer = GetAdditionalJarPath( rJvmEntry, aAddJar );
            if ( aBuffer.Len() )
            {
                if ( addClasspath.Len() )
                    addClasspath += PATH_SEP;
                addClasspath += aBuffer;
            }
            aAddJar = aAddJars.GetToken( nTok++ );
        }
    }

    if ( addClasspath.Len() )
        aSoIni.WriteKey( SYSTEM_CLASSPATH, addClasspath );

	return TRUE;
}

BOOL WriteJavaSupportToFile( BOOL bSupport, const ByteString& aIniFile )
{
    ByteString aVal = bSupport ? ByteString( '1' ) : ByteString( '0' );

    Config aSoIni( String( aIniFile, osl_getThreadTextEncoding() ) );

    aSoIni.SetGroup( JAVA_SECTION );
    aSoIni.WriteKey( JAVA_SUPPORT, aVal );
    aSoIni.WriteKey( JAVASCRIPT_SUPPORT, aVal );
    aSoIni.WriteKey( APPLET_SUPPORT, aVal );

    return TRUE;
}

BOOL InstallNewJavaEnvironment( const ByteString& sourcePath,
								const ByteString& destPath,
								const ByteString& instPackage,
                                const ByteString& version,
								JVMDialog * pDialog )
{
	if ( pDialog )
		pDialog->EnableInput( FALSE );

	SiDirEntry aDestDir( destPath );

	if ( !aDestDir.Exists() )
	{
		aDestDir.MakeDir();
	}

	OJavaInstallThread* pInstallThread = new OJavaInstallThread ( sourcePath, destPath, instPackage, version, pDialog );
	pInstallThread->create();

	if ( !pDialog )
	{
		pInstallThread->aWaitCondition.wait();

		while ( pInstallThread->isRunning() )
			NAMESPACE_VOS(OThread)::yield();

		delete pInstallThread;
	}

	return TRUE;
}

const JVMEntry* GetEntry( USHORT nIndex )
{
	if ( nIndex < nEntriesCount )
		return & aEntryList[nIndex];
	else
		return NULL;
}

void ReadInstallSection( ByteString iniFile )
{
    Config aConfig( String( iniFile, osl_getThreadTextEncoding() ) );
    aConfig.SetGroup( INSTALL_SECTION );

    USHORT nKeyCount = aConfig.GetKeyCount();

    for ( USHORT i=0; i<nKeyCount; i++ )
    {
        ByteString aEntryTag = aConfig.GetKeyName( i );
        ByteString aValueStr = aConfig.ReadKey( i );

        if ( aEntryTag.Len() && aValueStr.Len() )
            aJavaInstProps[aEntryTag] = aValueStr;
    }

    aConfig.SetGroup( JAVA_SECTION );
    strLastSelectedJava = String( aConfig.ReadKey( JAVA_VERSION ), RTL_TEXTENCODING_UTF8 );
}

void WriteInstallSection( ByteString iniFile )
{
	UniString aFileName = UniString( iniFile, osl_getThreadTextEncoding() );

	USHORT nStartIndex;
	nStartIndex	= aFileName.SearchCharBackward( UniString::CreateFromAscii("/").GetBuffer() );

	UniString aIniHome = aFileName.Erase(nStartIndex, aFileName.Len() - nStartIndex);

	DirEntry aPath = DirEntry( aIniHome );

	aPath.ToAbs();

	if ( ! aPath.Exists() )
		aPath.MakeDir();

	typedef JavaInstProps::iterator IT;

    Config aConfig( String( iniFile, osl_getThreadTextEncoding() ) );
    aConfig.SetGroup( INSTALL_SECTION );

    for ( IT it= aJavaInstProps.begin(); it != aJavaInstProps.end(); it++)
    {
        ByteString aKey((*it).first);
        ByteString aValue(aJavaInstProps[aKey]);

        aConfig.WriteKey( aKey, aValue );
    }
}

BOOL VerifyInstallProperties()
{
	UniString errMsg;

	if ( aJavaInstProps.find(REQUIRED_VERSION) == aJavaInstProps.end() )
	{
		errMsg = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n"
		"No \"required version\" is specified.");
		errMsg += UniString(RTL_CONSTASCII_USTRINGPARAM("No \"required version\" is specified."));
		WarningBox( NULL, WB_OK, errMsg).Execute();
	}

	if ( aJavaInstProps.find(INSTALLATION_PACKAGE) != aJavaInstProps.end() )
	{
		if ( aJavaInstProps.find(VENDOR) == aJavaInstProps.end() )
		{
			errMsg  = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n");
			errMsg += UniString::CreateFromAscii("The Vendor of the installation package must be specified.");
			errMsg += UniString::CreateFromAscii("\nJava Setup - abort");
			ErrorBox( NULL, WB_OK, errMsg).Execute();
			return FALSE;
		}

		if ( aJavaInstProps.find(VERSION) == aJavaInstProps.end() )
		{
			errMsg = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n");
			errMsg += UniString::CreateFromAscii("The Version of the installation package must be specified.");
			errMsg += UniString::CreateFromAscii("\nJava Setup - abort");
			ErrorBox( NULL, WB_OK, errMsg).Execute();
			return FALSE;
		}
#ifdef UNX
		if ( aJavaInstProps.find(PACKAGE_INSTALL_DIR) == aJavaInstProps.end() )
		{
			errMsg = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n");
			errMsg += UniString::CreateFromAscii("The directory of the installation package must be specified.");
			errMsg += UniString::CreateFromAscii("\nJava Setup - abort");
			ErrorBox( NULL, WB_OK, errMsg).Execute();
			return FALSE;
		}
#endif
	}

	return TRUE;
}

// -----------
BOOL IsWorkstation( const ByteString& rSourcePath )
{
    BOOL bWorkstation = FALSE;

    SiDirEntry aBootstrapfile( rSourcePath );
	aBootstrapfile.ToAbs();
#ifdef UNX
	aBootstrapfile += UniString::CreateFromAscii("bootstraprc");
#else
	aBootstrapfile += UniString::CreateFromAscii("bootstrap.ini");
#endif

	if( aBootstrapfile.Exists() )
	{
		Config aCfg( aBootstrapfile.GetFullUni() );
		aCfg.SetGroup( "Bootstrap" );

        ByteString aInstallMode = aCfg.ReadKey( "InstallMode" );
        if ( ( aInstallMode.CompareIgnoreCaseToAscii( "NETWORK" ) == COMPARE_EQUAL ) ||
             ( aInstallMode.CompareIgnoreCaseToAscii( "ALL_USERS" ) == COMPARE_EQUAL ) )
        {
            bWorkstation = TRUE;
        }
	}

    return bWorkstation;
}

// -------------------------------------------------
ByteString GetJavaIniURL( const ByteString& rDestPath, BOOL bUser )
{
    ByteString aJavaIniURL;
    OUString aUDestIniName;
    OUString aOUStr( rDestPath.GetBuffer(), rDestPath.Len(), osl_getThreadTextEncoding() );

    FileBase::RC result = File::getFileURLFromSystemPath( aOUStr, aUDestIniName );

    aUDestIniName += OUString::createFromAscii( "/" );
    aUDestIniName +=  bUser ? OUString::createFromAscii( "user" ) : OUString::createFromAscii( "share" );
    aUDestIniName += OUString::createFromAscii( "/config/" );
    aUDestIniName += OUString::createFromAscii( JAVA_INI );

    aJavaIniURL = OUStringToOString( aUDestIniName, osl_getThreadTextEncoding() );

    return aJavaIniURL;
}

// -------------------------------------------------
USHORT GetJavaVirtualMachine( JVMEntry* pJVM )
{
    USHORT nCount = 0;

    try
    {
        std::vector<jvmaccess::JavaInfo> aInfos;

        jvmaccess::JavaInfo::createAllInfo( &aInfos );

        USHORT nFound = aInfos.size();

        for ( USHORT i=0; i<nFound; i++ )
        {
            jvmaccess::JavaInfo &rInfo = aInfos[ i ];
			pJVM->mRuntimeLib = rInfo.getRuntimeLibLocation();
			try 
			{
				pJVM->mJVMType  = rInfo.getType();
			} 
			catch( jvmaccess::JavaInfo::UnsupportedException & )
			{
			}
			try
			{
				pJVM->mVersion  = rInfo.getVersion();
			}
			catch( jvmaccess::JavaInfo::UnsupportedException & )
			{
			}
			try
			{
				pJVM->mHome     = rInfo.getInstallationLocation();
			}
			catch( jvmaccess::JavaInfo::UnsupportedException & )
			{
			}
            try
			{
				pJVM->mLibPath  = rInfo.getLibLocations();
			}
			catch(jvmaccess::JavaInfo::UnsupportedException & )
			{
			}
            
            pJVM->bIsBestVersion = ( i == 0 );
            try
			{
				pJVM->bIsAccessable  = rInfo.supportsAccessibility();
			}
			catch(jvmaccess::JavaInfo::UnsupportedException & )
			{
			}
            // Only add found entry if it meets the requirements
            if ( CheckVersion( pJVM->mVersion ) )
            {
                pJVM += 1;
                nCount += 1;
            }
        }
    }
    catch ( jvmaccess::JavaInfo::InitException & )
    {
        DBG_ERRORFILE( "GetJavaVirtualMachine(): caught exception!" );
    }
    return nCount;
}

// -------------------------------------------------
BOOL GetInstalledVM( JVMEntry& entry, const String& rDestPath )
{
    BOOL bRet = TRUE;

    try
    {
        OUString aDestURL;
        osl::FileBase::getFileURLFromSystemPath( rDestPath, aDestURL );
        
        jvmaccess::JavaInfo aInfo( aDestURL );
		entry.mRuntimeLib = aInfo.getRuntimeLibLocation();
		try
		{
			entry.mJVMType  = aInfo.getType();
		}
		catch ( jvmaccess::JavaInfo::UnsupportedException &)
		{
		}
		try
		{
			entry.mVersion  = aInfo.getVersion();
		}
		catch ( jvmaccess::JavaInfo::UnsupportedException &)
		{
		}
		try
		{
			entry.mHome     = aInfo.getInstallationLocation();
		}
		catch ( jvmaccess::JavaInfo::UnsupportedException &)
		{
		}
		try
		{
			entry.mLibPath  = aInfo.getLibLocations();
		}
		catch ( jvmaccess::JavaInfo::UnsupportedException &)
		{
		}
		try
		{
			entry.bIsAccessable = aInfo.supportsAccessibility();
		}
		catch ( jvmaccess::JavaInfo::UnsupportedException &)
		{
		}
        entry.bIsBestVersion = FALSE;
    }
    catch ( jvmaccess::JavaInfo::InitException & )
    {
        bRet = FALSE;
    }
    return bRet;
}

// -------------------------------------------------
ByteString GetAdditionalJarPath( const JVMEntry& rEntry,
                                 const ByteString& rJar )
{
    String aJar( rJar, osl_getThreadTextEncoding() );
    ByteString aPath;
    
    try
    {
        std::vector<jvmaccess::JavaInfo> aInfos;

        jvmaccess::JavaInfo::createAllInfo( &aInfos );

        OUString aURL;

        USHORT   nFound = aInfos.size();

        for ( USHORT i=0; i<nFound; i++ )
        {
            jvmaccess::JavaInfo &rInfo = aInfos[ i ];

            if ( rEntry.mRuntimeLib == String( rInfo.getRuntimeLibLocation() )) 
            {
				try
				{
					aURL = rInfo.getJarFilePath( aJar );
				}
				catch ( jvmaccess::JavaInfo::UnsupportedException &)
				{
				}
                break;
            }
        }

        if ( !aURL.getLength() )
        {
            jvmaccess::JavaInfo aInfo( rEntry.mHome );
			try
			{
				aURL = aInfo.getJarFilePath( aJar );
			}
			catch ( jvmaccess::JavaInfo::UnsupportedException &)
			{
			}
        }

        if ( aURL.getLength() )
        {
            OUString aSysPath;
            osl::FileBase::getSystemPathFromFileURL( aURL, aSysPath );
            aPath = ByteString( String( aSysPath ), RTL_TEXTENCODING_UTF8 );
        }
    }
    catch ( jvmaccess::JavaInfo::InitException & )
    {
        DBG_ERRORFILE( "GetAdditionalJarPath(): cought exception!" );
    }

    return aPath;
}

// -------------------------------------------------
BOOL GetInstalledVM( JVMEntry& entry, const ByteString& rDestPath )
{
    UniString aDestPath( rDestPath, osl_getThreadTextEncoding() );
    return GetInstalledVM( entry, aDestPath );
}

// -------------------------------------------------
BOOL CheckVersion( const String& rVersion )
{
    static String aRequiredVers;
    static String aExcludeVers;
    static BOOL bInit = FALSE;

    if ( !bInit )
    {
        bInit = TRUE;
        
        if ( aJavaInstProps.find( REQUIRED_VERSION ) != aJavaInstProps.end() )
            aRequiredVers = String( aJavaInstProps[ REQUIRED_VERSION ], osl_getThreadTextEncoding() );

        if ( aJavaInstProps.find( EXCLUDE_VERSION ) != aJavaInstProps.end() )
            aExcludeVers = String( aJavaInstProps[ EXCLUDE_VERSION ], osl_getThreadTextEncoding() );
    }

    if ( aRequiredVers.Len() && ( rVersion < aRequiredVers ) )
        return FALSE;

    if ( aExcludeVers.Len() )
    {
        xub_StrLen nCount = aExcludeVers.GetTokenCount( ' ' );

        for ( xub_StrLen i=0; i<nCount; i++ )
            if ( rVersion == aExcludeVers.GetToken( i, ' ' ) )
                return FALSE;
    }

    return TRUE;
}

