// Registrar.h: Schnittstelle fr die Klasse Registrar.
//
//////////////////////////////////////////////////////////////////////

#ifndef _REGISTRAR_HXX_
#define _REGISTRAR_HXX_

#ifndef _REGISTRY_HXX_
#include "registry.hxx"
#endif

#ifndef _REGISTRATIONCONTEXTINFORMATION_HXX_
#include "registrationcontextinformation.hxx"
#endif

#ifndef _CONSTANTS_HXX_
#include "constants.hxx"
#endif

/*
const int MSWORD                                    = 0x1;
const int MSEXCEL                                    = 0x2;
const int MSPOWERPOINT                           = 0x4;	
const int DEFAULT_HTML_EDITOR_FOR_IE     = 0x8;	
const int HTML_EDITOR				              = 0x10;	
const int DEFAULT_SHELL_HTML_EDITOR      = 0x20;
*/

class Registrar  
{
public:
	
	//###################################
	// Creation
	//###################################

	Registrar(const RegistrationContextInformation& RegContext);

	virtual ~Registrar();

    //###################################
	// Query
	//###################################
    
    bool IsRegisteredFor(int State) const;
    
	//###################################
	// Command 
	//###################################

	virtual void RegisterForMsWord() const;
	virtual void UnregisterForMsWord() const;
    virtual bool QueryPreselectMsWordRegistration() const;
    
	virtual void RegisterForMsExcel() const;
	virtual void UnregisterForMsExcel() const;
    virtual bool QueryPreselectMsExcelRegistration() const;
    
	virtual void RegisterForMsPowerPoint() const;
	virtual void UnregisterForMsPowerPoint() const;
    virtual bool QueryPreselectMsPowerPointRegistration() const;
    
	virtual void RegisterAsHtmlEditorForInternetExplorer() const;
	virtual void UnregisterAsHtmlEditorForInternetExplorer() const;

	virtual void RegisterAsDefaultHtmlEditorForInternetExplorer() const;
	virtual void UnregisterAsDefaultHtmlEditorForInternetExplorer() const;

	virtual void RegisterAsDefaultShellHtmlEditor() const;
	virtual void UnregisterAsDefaultShellHtmlEditor() const;

	/** Restore the last registration state (necessary for
		Setup repair)
	*/
	virtual void RepairRegistrationState() const;

    /** Unregisters all and delete all Registry keys we have written
    */
    virtual void UnregisterAllAndCleanUpRegistry() const;
    
	//###################################
	// 
	//###################################

protected:
	
    //###################################
	// command
	//###################################
    
    virtual void RegisterForMsOfficeApplication(
        const std::wstring& FileExtension,
        const std::wstring& DocumentDisplayName,
        const std::wstring& DefaultIconEntry,
        const std::wstring& DefaultShellCommand,
        const std::wstring& ShellNewCommandDisplayName) const;
    
    virtual void UnregisterForMsOfficeApplication(
        const std::wstring& FileExtension) const;
    
    virtual RegistryKey GetRootKeyForDefHtmlEditorForIERegistration() const;
    
	void SaveRegisteredFor(int State) const;
    void SaveNotRegisteredFor(int State) const;
    
    int GetRegisterState() const;
    void SetRegisterState(int NewState) const;
    
    virtual bool QueryPreselectForMsApplication(const std::wstring& file_extension) const;
    
    //###################################
	// query
	//###################################
    
    /** A helper function (for readability) returns true if OpenOffice is already
          registered for a MS application
          
          @param DocumentExtensionDefValue
                      The default value of the appropriate document extension Registry key
    */
    bool IsOpenOfficeRegisteredForMsApplication(const std::wstring& DocumentExtensionDefValue) const;
        
	//###################################
	// Instance data
	//###################################

protected:	
	const RegistrationContextInformation&	m_ContextInformation;

    const std::wstring FORWARD_KEY_PREFIX;
    const std::wstring DEFAULT_VALUE_NAME;
    const std::wstring BACKUP_VALUE_NAME;
    const std::wstring PRIVATE_BACKUP_KEY_NAME;
    const std::wstring REGISTRATION_STATE;
    
    RegistryKey	 m_RootKey;
    
// prevent copy/assignment
private:
	Registrar(const Registrar&);
	Registrar& operator=(const Registrar&);
};

#endif 
