/*************************************************************************
 *
 *  $RCSfile: regactivex.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 15:50:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/presys.h>
#include <windows.h>
#include <tools/postsys.h>

#define VCL_NEED_BASETSD

#ifndef _OSL_DIAGNOSE_HXX_
#include <osl/diagnose.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif

#ifndef _SETUP_ENVIRON_HXX
#include "environ.hxx"
#endif

#ifndef _SICUSTOM_HXX
#include "sicustom.hxx"
#endif

#ifndef _SIMODE_HXX
#include "simode.hxx"
#endif

using namespace ::rtl;

SiSetupFnc aSetupFnc;

const OString ACTIVEX_MODULE_ID = "gid_Module_Optional_Activexcontrol";
const OUString BACKSLASH = OUString::createFromAscii("\\");

rtl_TextEncoding gsl_getSystemTextEncoding();
#define osl_getThreadTextEncoding gsl_getSystemTextEncoding

typedef int ( __stdcall * DllNativeProc ) ( BOOL );
typedef int ( __stdcall * DllDocProc )( int, BOOL );

//----------------------------------------------------------

void RegisterActiveXNative( const ::rtl::OUString& aActiveXPath, BOOL InstallForAllUser )
{
	::rtl::OString aLibPath = ::rtl::OUStringToOString( aActiveXPath, osl_getThreadTextEncoding() );
	HINSTANCE hModule = LoadLibraryA( aLibPath.getStr() );
	if( !(hModule <= (HINSTANCE)HINSTANCE_ERROR) )
	{
		DllNativeProc pNativeProc = (DllNativeProc)GetProcAddress( hModule, "DllRegisterServerNative" );
		if( pNativeProc!=NULL )
			(*pNativeProc)( InstallForAllUser );

		FreeLibrary(hModule);
	}
}

//----------------------------------------------------------

void UnregisterActiveXNative( const ::rtl::OUString& aActiveXPath, BOOL InstallForAllUser )
{
	HINSTANCE hModule = LoadLibraryA( ::rtl::OUStringToOString( aActiveXPath, osl_getThreadTextEncoding() ).getStr() );
	if( !(hModule <= (HINSTANCE)HINSTANCE_ERROR) )
	{
		DllNativeProc pNativeProc = (DllNativeProc)GetProcAddress( hModule, "DllUnregisterServerNative" );
		if( pNativeProc!=NULL )
			(*pNativeProc)( InstallForAllUser );

		FreeLibrary(hModule);
	}
}

//----------------------------------------------------------

inline BOOL IsAfterInstallation( SiCustomEnvironment *pEnv )
{ return ( !pEnv->IsModify( ) && !pEnv->IsRepair( ) && pEnv->IsInstallation( ) && pEnv->IsPost( ) ); }

inline BOOL IsDeinstallation( SiCustomEnvironment *pEnv )
{ return ( !pEnv->IsModify( ) && !pEnv->IsRepair( ) && pEnv->IsDeinstallation( ) ); }

inline BOOL IsSetupModifyBefore( SiCustomEnvironment *pEnv )
{ return ( pEnv->IsModify( ) && pEnv->IsPre( ) ); }

inline BOOL IsSetupModifyAfter( SiCustomEnvironment *pEnv )
{ return ( pEnv->IsModify( ) && pEnv->IsPost( ) ); }

inline BOOL IsSetupRepair( SiCustomEnvironment *pEnv )
{ return  pEnv->IsRepair( ); }

inline BOOL IsModule( const OString& ExpectedModuleName, const OString& ModuleName )
{ return ( ModuleName.equalsIgnoreAsciiCase( ExpectedModuleName ) ); }

//----------------------------------------------------------

inline BOOL QueryActiveXInstalled( SiCustomModuleList* pModuleList )
{
    sal_Int32 nModules = pModuleList->Count();

    for (sal_Int32 i = 0; i < nModules; i++)
    {
        SiCustomModuleInfo* pCustModInf = pModuleList->GetObject(i);

        if (pCustModInf->IsInstalled())
        {
            ByteString strModID = pModuleList->GetObject(i)->GetModuleID();

            if ( IsModule(ACTIVEX_MODULE_ID, strModID))
				return TRUE;
        }
    }

    return FALSE;
}

//----------------------------------------------------------

inline BOOL QueryActiveXUninstall( SiCustomModuleList* pModuleList )
{
    sal_Int32 nModules = pModuleList->Count();

    for (sal_Int32 i = 0; i < nModules; i++)
    {
        SiCustomModuleInfo* pCustModInf = pModuleList->GetObject(i);

        if (pCustModInf->IsInstalled() && pCustModInf->IsSelected())
        {
            ByteString strModID = pModuleList->GetObject(i)->GetModuleID();

            if ( IsModule(ACTIVEX_MODULE_ID, strModID))
				return TRUE;
        }
    }

    return FALSE;
}

//----------------------------------------------------------

OUString GetFullActiveXPath(SiCustomEnvironment* pEnv)
{
    OUString path;

	SiInstallType InstType = pEnv->GetBigEnv()->GetInstallType();

	BOOL bItWorkstation  = (InstType == IT_WORKSTATION);
	BOOL bItRecover      = (InstType == IT_RECOVER);
	BOOL bItChange		 = (InstType == IT_CHANGE);
    BOOL bItUninstall    = (InstType == IT_UNINSTALL);
    BOOL bInstallFromNet = pEnv->GetBigEnv()->InstallFromNet();

	if (bInstallFromNet && (bItWorkstation || bItRecover || bItChange || bItUninstall))
		path = OStringToOUString(pEnv->GetBigEnv()->GetSourcePath(), osl_getThreadTextEncoding());
	else
		path = OStringToOUString(pEnv->GetDestPath(), osl_getThreadTextEncoding());

    if (path.lastIndexOf(BACKSLASH) != (path.getLength() - 1))
        path += BACKSLASH;

    path += OUString::createFromAscii("program\\so_activex.dll");

#if OSL_DEBUG_LEVEL > 0
    rtl::OString OOFilePath = OUStringToOString(path, osl_getThreadTextEncoding());
    WIN32_FIND_DATAA fd;
    HANDLE hFile = FindFirstFileA(OOFilePath, &fd);
    if (INVALID_HANDLE_VALUE == hFile)
        OSL_ENSURE(false, "The name of the OpenOffice executable or the path to it has changed!\nModify function GetFullProgramPath!!!");
    else
        FindClose(hFile);
#endif

    return path;
}


//----------------------------------------------------------

void HandleAfterInstallation( SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList )
{
	if( QueryActiveXInstalled( pModuleList ) )
		RegisterActiveXNative( GetFullActiveXPath( pEnv ), pEnv->GetBigEnv( )->InstallForAllUser( ) );
}

//----------------------------------------------------------

void HandleSetupModifyBefore( SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList )
{
	if( QueryActiveXUninstall( pModuleList ) )
		UnregisterActiveXNative( GetFullActiveXPath( pEnv ), pEnv->GetBigEnv( )->InstallForAllUser( ) );

}

//----------------------------------------------------------

void HandleSetupModifyAfter( SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList )
{
	if( QueryActiveXInstalled( pModuleList ) )
		RegisterActiveXNative( GetFullActiveXPath( pEnv ), pEnv->GetBigEnv( )->InstallForAllUser( ) );
}

//----------------------------------------------------------

void HandleDeinstallation(SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList)
{
	if( QueryActiveXInstalled( pModuleList ) )
		UnregisterActiveXNative( GetFullActiveXPath( pEnv ), pEnv->GetBigEnv( )->InstallForAllUser( ) );
}

//----------------------------------------------------------

BOOL _SV_CALL CustomMain( SiCustomEnvironment* pEnv, SiCustomModuleList* pList )
{
    BOOL bRet = true;

    if ( IsAfterInstallation( pEnv ) )
        HandleAfterInstallation( pEnv, pList );
    else if ( IsSetupModifyBefore( pEnv ) )
        HandleSetupModifyBefore( pEnv, pList );
	else if ( IsSetupModifyAfter( pEnv ) )
		HandleSetupModifyAfter( pEnv, pList );
    else if ( IsDeinstallation( pEnv ) )
        HandleDeinstallation( pEnv, pList );
    else
        OSL_ENSURE( false, "impossible case?" );

    return bRet;
}

//----------------------------------------------------------

BOOL _SV_CALL CustomInit( SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc )
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return false;

	pCustomFnc->fncMain = ( FncPtrCustomMain )CustomMain;

	aSetupFnc.nVersion 		     = pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup	     = pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup	     = pSetupFnc->fncShowSetup;
    aSetupFnc.fncGetCodeFilename = pSetupFnc->fncGetCodeFilename;

	return true;
}

