/*************************************************************************
 *
 *  $RCSfile: arch.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 11:03:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef UNX
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <grp.h>
#endif

#ifdef MAC
#include <Mac_Start.h>
#include <TextUtils.h>
#include <Mac_End.h>
#endif

#include <math.h>
#include <string.h>
#include <stdlib.h>

#include "arch.hxx"

#ifdef UNX
#define stricmp strcasecmp
#endif

#ifdef UNX
#define MASTER_EXTENSION	"bin"
#define JUNK_EXTENSION		"bin"
#else
#define MASTER_EXTENSION	"exe"
#define JUNK_EXTENSION		"bin"
#endif

//////////////////////////////////////////////////////////////////////////
// ArchDirectory
ArchDirectory::ArchDirectory()
{
	pArch			= NULL;
	fncFindArch		= NULL;
	nDirOffset		= 0L;
	nDataOffset		= 0L;
	nDirCount		= 0L;
	nArchSize		= 0L;

	bNoJunk			= FALSE;

#if defined(MAC)
	cDelim			= ':';
#elif defined(UNX)
	cDelim			= '/';
#else
	cDelim			= '\\';
#endif
}

//////////////////////////////////////////////////////////////////////////
// ~ArchDirectory()
ArchDirectory::~ArchDirectory()
{
	if( pArch )
		fclose( pArch );

	for( ULONG n = 0; n < nDirCount; ++ n )
	{
		ArchEntry* pEntry = pDirectory[n];
		delete [] (pEntry->pName);
		delete pEntry;
	}
}

//////////////////////////////////////////////////////////////////////////
// SetArchFile( const char* pBigFile )
BOOL ArchDirectory::SetArchFile( const char* pBigFile )
{
	nArchSize = 0L;
	nDataOffset	= 0L;

#ifdef UNX
	struct stat buf;
	if( stat(pBigFile, &buf) == -1 )
		return FALSE;
	if( !(buf.st_mode & S_IFREG) )
		return FALSE;
#endif

	pArch = fopen( pBigFile, "rb" );
	if( !pArch )
		return FALSE;

	fseek( pArch, 0L, SEEK_END );
	nArchSize = ftell( pArch );
	fseek( pArch, 0L, SEEK_SET );

	BOOL  bFnd = FALSE;
	char* pBuf = new char[BUF_SZ];

	// Damit der Searchstring im CODE Seg. nicht
	// zusammenhaengend auftaucht!
	char  aSrch1[5] = "BIGF";
	char  aSrch2[5] = "ILE:";
	char  aSrchStr[9];
	strcpy( aSrchStr, aSrch1 );     // #100211# - checked
	strcat( aSrchStr, aSrch2 );     // #100211# - checked

	while( !feof(pArch) && !bFnd )
	{
		ULONG nRead = fread( pBuf, sizeof(char), BUF_SZ, pArch );
		for( ULONG i = 0; i < nRead; ++i )
			if( pBuf[i] == 'B' )
				if( strncmp(&(pBuf[i]), aSrchStr, 8) == 0)
				{
					nDirOffset = atol(&(pBuf[i+8]));
					if( !nDirOffset )
					{
						fclose(pArch);
						delete pBuf;
						return FALSE;
					}
					bFnd = TRUE;
					break;
				}
	}
	delete [] pBuf;

	if( !bFnd )
	{
		fclose(pArch);
		return FALSE;
	}

	BOOL bReturn = ReadDirectory();
	USHORT nJunks = (USHORT) ceil( ((double)(pDirectory[nDirCount-1]->nOffset + pDirectory[nDirCount-1]->nSize) + nDataOffset) / (double)nArchSize );
	nJunks--;

	fclose(pArch);

	USHORT nLen = strlen(pBigFile);
	
    if ( nLen >= MAX_ARCH_PATH - 1 )
        return FALSE;
    
    memset(pSourceDir, 0, MAX_ARCH_PATH );
	memset(pMasterArch, 0, MAX_ARCH_PATH );

	for( int i = nLen; i >= 0; --i )
		if(pBigFile[i] == cDelim)
		{
			strncpy(pSourceDir, pBigFile, i+1);
			strncpy(pMasterArch, &(pBigFile[i+1]), MAX_ARCH_PATH-1 );
            pSourceDir[ MAX_ARCH_PATH-1 ] = '\0';
            pMasterArch[ MAX_ARCH_PATH-1]  = '\0';
			break;
		}

	if( nJunks )
	{
		nLen = strlen(pMasterArch);
		for( int x = nLen; x >= 0; --x )
			if( pMasterArch[x] == '-' )
			{
				pMasterArch[x] = 0x00;
				break;
			}
	}

	pErrorMsg[0] = '\0';
    BOOL bAllFiles = TRUE;
	FILE* pTest;
	char cBuffer[MAX_ARCH_PATH];

	if( !nJunks )
		bNoJunk = TRUE;
	else
		for( int y = 0; y <= nJunks; ++y )
		{
			GetArchFileName( y, cBuffer, sizeof( cBuffer ) );
			pTest = fopen( cBuffer, "rb" );
			if( pTest )
				fclose( pTest );
			else
			{
				bAllFiles = FALSE;
				strncat( pErrorMsg, "\nfile not found '", sizeof(pErrorMsg) - strlen(pErrorMsg) - 1 );
				strncat( pErrorMsg, cBuffer, sizeof(pErrorMsg) - strlen(pErrorMsg) - 1 );
				strncat( pErrorMsg, "'", sizeof(pErrorMsg) - strlen(pErrorMsg) - 1 );
			}
		}

	if( !bAllFiles )
	{
		strncat( pErrorMsg, "\n\nerror: One or more files are missing! Please ensure that all necessary files are present.",
                 sizeof(pErrorMsg) - strlen(pErrorMsg) - 1);
		return FALSE;
	}

	return bReturn;
}

//////////////////////////////////////////////////////////////////////////
// ReadDirectory()
BOOL ArchDirectory::ReadDirectory()
{
	int nErr = fseek( pArch, nDirOffset, SEEK_SET );
	if( nErr )
		return FALSE;

	nDirCount = 0;

	fread( &nArchVersion, sizeof(ULONG), 1, pArch );
	fread( &nDirCount, sizeof(ULONG), 1, pArch );

	for( USHORT i = 0; i < nDirCount; ++i )
	{
		ArchEntry* 	pNew = new ArchEntry;
		char 		cChar;
		int 		nIdx = 0;

		pNew->pName = new char [MAX_ARCH_PATH];

		fread( &(pNew->nOffset), sizeof(ULONG), 1, pArch );
		fread( &(pNew->nSize), sizeof(ULONG), 1, pArch );

		for( nIdx = 0; (cChar = fgetc(pArch)) != 0x00; ++nIdx )
			pNew->pName[nIdx] = cChar;
		pNew->pName[nIdx] = 0x00;

		pDirectory[i] = pNew;
	}

	nDataOffset = ftell( pArch );
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////
// ExistsFile( const char* pFileName )
const ArchEntry* ArchDirectory::ExistsFile( const char* pFileName )
{
	ArchEntry* pEntry = NULL;
	for( USHORT i = 0; i < nDirCount; ++i )
#ifdef MAC
		if( IdenticalText(pFileName, pDirectory[i]->pName,
			strlen(pFileName), strlen(pDirectory[i]->pName), nil) == 0 )
#else
		if( stricmp(pFileName, pDirectory[i]->pName) == 0 )
#endif
		{
			pEntry = pDirectory[i];
			break;
		}
	return pEntry;
}

//////////////////////////////////////////////////////////////////////////
// GetArchFileName( USHORT nSegment, char* pBuffer )
void ArchDirectory::GetArchFileName( USHORT nSegment, char* pBuffer, long nBufSize )
{
	char pDelim[2] = { cDelim, 0x00 };

	strncpy( pBuffer, pSourceDir, nBufSize-1 );
    pBuffer[ nBufSize-1] = '\n';
	if( pBuffer[strlen(pBuffer)-1] != cDelim )
		strncat( pBuffer, pDelim, nBufSize-strlen(pBuffer)-1 );
	strncat( pBuffer, pMasterArch, nBufSize-strlen(pBuffer)-1 );

	if( !bNoJunk )
	{
		char pExtension[10];
		sprintf( pExtension, "-%03ld.%s", nSegment, nSegment != 0? JUNK_EXTENSION : MASTER_EXTENSION ); // #100211# - checked
		strncat( pBuffer, pExtension, nBufSize-strlen(pBuffer)-1 );
	}
}

//////////////////////////////////////////////////////////////////////////
// GetFile( const char* pFileName, const char* pDestDir )
BOOL ArchDirectory::GetFile( const char* pFileName, const char* pDestDir )
{
	const ArchEntry* pEntry = ExistsFile( pFileName );
	if( !pEntry )
		return FALSE;

	// destination
	char pDestFileName[MAX_ARCH_PATH];
	char pDelim[2] = { cDelim, 0x00 };

	strncpy( pDestFileName, pDestDir, sizeof(pDestFileName) - 1 );
	strncat( pDestFileName, pDelim, sizeof(pDestFileName) - strlen(pDestFileName) - 1 );
	strncat( pDestFileName, pEntry->pName, sizeof(pDestFileName) - strlen(pDestFileName) - 1 );

	// source
	USHORT nSplitArchNr = (USHORT)((pEntry->nOffset + nDataOffset) / nArchSize);
	char pArchFileName[MAX_ARCH_PATH];
	GetArchFileName( nSplitArchNr, pArchFileName, sizeof(pArchFileName) );

	FILE* pDestFile = fopen( pDestFileName, "wb" );
	if( !pDestFile )
		return FALSE;

DO_RETRY_FIRST:
	pArch = fopen( pArchFileName, "rb" );
	if( !pArch )
	{
		if( !fncFindArch )
		{
		EXIT_RETRY_FIRST:
			fclose( pDestFile );
			return FALSE;
		}
		const char* pReturn = fncFindArch(pSourceDir, pArchFileName);
		if( !pReturn )
			goto EXIT_RETRY_FIRST;
		strncpy( pSourceDir, pReturn, sizeof(pSourceDir)-1 );
        pSourceDir[ sizeof( pSourceDir )-1 ] = '\0';
		GetArchFileName(nSplitArchNr, pArchFileName, sizeof(pArchFileName) );
		goto DO_RETRY_FIRST;
	}


	ULONG nStartPos = (pEntry->nOffset - (nSplitArchNr * nArchSize)) + nDataOffset;
	int nErr = fseek( pArch, nStartPos, SEEK_SET );
	if( nErr )
		return FALSE;

	ULONG nReadSz = 0;
	char* pBuf = new char[BUF_SZ];

	while( nReadSz < pEntry->nSize )
	{
		if( feof(pArch) )
		{
			fclose( pArch );
			nSplitArchNr += 1;
		DO_RETRY:
			GetArchFileName(nSplitArchNr, pArchFileName, sizeof(pArchFileName));
			pArch = fopen( pArchFileName, "rb" );
			if( !pArch )
			{
				if( !fncFindArch )
				{
				EXIT_RETRY:
					fclose( pDestFile );
					fclose( pArch );
					delete pBuf;
					return FALSE;
				}
				const char* pReturn = fncFindArch(pSourceDir, pArchFileName);
				if( !pReturn )
					goto EXIT_RETRY;
				strncpy( pSourceDir, pReturn, sizeof(pSourceDir)-1 );
                pSourceDir[ sizeof( pSourceDir )-1 ] = '\0';
				goto DO_RETRY;
			}
		}

		ULONG nToRead = BUF_SZ;
		if( nReadSz + nToRead > pEntry->nSize )
			nToRead = pEntry->nSize - nReadSz;

		ULONG nRead = fread( pBuf, sizeof(char), nToRead, pArch );
		fwrite( pBuf, sizeof(char), nRead, pDestFile );

		nReadSz += nRead;
	}

	fclose( pDestFile );
	fclose( pArch );
	delete [] pBuf;

	return TRUE;
}

void ArchDirectory::ExtractAll( const char* pDirname )
{
	ULONG nCnt			= GetCount();
	ArchEntry** ppRaw	= GetRawList();

	for( ULONG i = 0; i < nCnt; ++i ) {
		ArchEntry* pEntry = (ArchEntry*)ppRaw[i];
		GetFile( pEntry->pName, "." );
	}
#ifdef UNX
	chmod( "setup", S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );
#endif
}

