/*************************************************************************
 *
 *  $RCSfile: main.cxx,v $
 *
 *  $Revision: 1.114 $
 *
 *  last change: $Author: rt $ $Date: 2003/07/31 10:06:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef UNX
#include <unistd.h>
#include <sys/stat.h>
#endif

#include <stdlib.h>
#include <stdlib.h>

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _SAL_CONFIG_H_
#include <sal/config.h>
#endif

#ifndef _SAL_MAIN_H_
#include <sal/main.h>
#endif

#include "jvmaccess/javainfo.hxx"

#ifndef _SV_HELP_HXX //autogen
#include <vcl/help.hxx>
#endif
#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif

#ifndef NOOLDSV //autogen
#include <vcl/system.hxx>
#endif

#include <sot/factory.hxx>

#ifndef _SV_RESMGR_HXX //autogen
#include <vcl/resmgr.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <tools/list.hxx>
#include <tools/rcid.h>

#ifndef _RTL_BOOTSTRAP_HXX_
#include "rtl/bootstrap.hxx"
#endif

#ifndef AUTOMATION_HXX
#include <automation/automation.hxx>
#endif

#ifndef _OSL_MODULE_H_
#include <osl/module.h>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif
#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <com/sun/star/uno/XComponentContext.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#include <cppuhelper/bootstrap.hxx>

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::cppu;


#include "main.hxx"
#include "mainwnd.hxx"
#include "maindlg.hxx"
#include "arch.hxx"
#include "critical.hxx"
#include "script.hxx"
#include "sihelp.hxx"
#include "respfile.hxx"
#include "texec.hxx"

#include "agenda.hxx"
#include "environ.hxx"
#include "sibasic.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "infodlg.hxx"

#include <svtools/solar.hrc>
#include "strings.hrc"
#include "app.hrc"
#include "error.hrc"

// These jar files are put into the CLASSPATH, see function prepareJava
#define JAVA_JAR_FILES    "jurt.jar","juh.jar","jut.jar","sandbox.jar","ridl.jar",\
		                  "java_uno.jar","unoil.jar","java_uno_accessbridge.jar"

#define WEBRESPONSE_FILENAME 			"response.ini"
#define WEBRESPONSE_SEC_INSTALLATION 	"Installation"
#define WEBRESPONSE_SEC_USERDATA	 	"UserData"
#define WEBRESPONSE_SEC_MODULE 		 	"Modules"

#define SETUP_ERROR_LOG_FILE 		 	"Setup_err.txt"
#define MAX_LOOKUPS                     5

#define SETUP_FONT_FILE                 "soui.ttf"
#define SETUP_FONT_FILE2                "sungulimp.ttf"
#define SETUP_FONT_FILE3                "vera.ttf"
#define SETUP_FONT_NAME                 "Andale Sans UI"
#define SETUP_FONT_NAME2                "SunGulim"
#define SETUP_FONT_NAME3                "Bitstream Vera Sans"

static BOOL param_bAutoPilot			= FALSE;
static BOOL param_bEvil					= FALSE;
static BOOL param_bModuleDump			= FALSE;
static BOOL param_bRepair				= FALSE;
static BOOL param_bOfficeMode			= FALSE;
static ByteString param_aModuleSet;

const char SETUP_INI[]					= "setup.ini";
const char SETUP_TEMPFILE[] 			= "_setup.tmp";

// ----------------------------------------------------------------------------
void prepareJava(const char * szStartPath);

struct SetupEventData
{
    ULONG            m_nEvent;
    SetupEventData  *m_pNext;

    SetupEventData( ULONG nEvent ) { m_nEvent = nEvent; m_pNext = NULL; }
};

// ----------------------------------------------------------------------------

oslModule InitTestToolLib()
{
	OUString	aFuncName( RTL_CONSTASCII_USTRINGPARAM( "CreateRemoteControl" ));
	OUString	aModulePath;

	::vos::OStartupInfo().getExecutableFile( aModulePath );
	sal_uInt32 	lastIndex = aModulePath.lastIndexOf('/');
	if ( lastIndex > 0 )
		aModulePath = aModulePath.copy( 0, lastIndex+1 );

	aModulePath += OUString::createFromAscii( SVLIBRARY( "sts" ) );

	// Shortcut for Performance: We expect that the test tool library is not installed
	// (only for testing purpose). It should be located beside our executable.
	// We don't want to pay for searching through LD_LIBRARY_PATH so we check for
	// existence only in our executable path!!
	osl::DirectoryItem	aItem;
	osl::FileBase::RC	nResult = osl::DirectoryItem::get( aModulePath, aItem );

	if ( nResult == osl::FileBase::E_None )
	{
		oslModule aTestToolModule = osl_loadModule( aModulePath.pData, SAL_LOADMODULE_DEFAULT );
		if ( aTestToolModule )
		{
			void* pInitFunc = osl_getSymbol( aTestToolModule, aFuncName.pData );
			if ( pInitFunc )
				(*(pfunc_CreateRemoteControl)pInitFunc)();
		}

		return aTestToolModule;
	}

	return 0;
}

void DeInitTestToolLib( oslModule aTestToolModule )
{
	if ( aTestToolModule )
	{
		OUString	aFuncName( RTL_CONSTASCII_USTRINGPARAM( "DestroyRemoteControl" ));

		void* pDeInitFunc = osl_getSymbol( aTestToolModule, aFuncName.pData );
		if ( pDeInitFunc )
			(*(pfunc_DestroyRemoteControl)pDeInitFunc)();

		osl_unloadModule( aTestToolModule );
	}
}

// -----------------------------------------------------------------------

Evil::Evil()
{}

Evil::~Evil()
{}

void Evil::run()
{
	ULONG nsz = 1;
	while( TRUE )
	{
		char* foo = new char[nsz];
		memset( foo, 0x77, nsz );
		aList.Insert( foo, LIST_APPEND );
		nsz += 10;
		if( aList.Count() > 300 )
		{
			for( USHORT n = 0; n < aList.Count(); ++n )
				delete [] aList.GetObject(n);
				aList.Clear();
				nsz = 1;
		}
	}
}

// -----------------------------------------------------------------------

SetupApp::SetupApp()
		:m_bReadScriptMode(false),
		 m_pSecondResMgr(NULL)
{
	#if defined(OS2)
	if( Os2OS::DoesTempFileExists() )
	{
		Os2OS::KillTempFile();
		exit(0);
	}
	#endif

	m_pEvil1 = NULL;
	m_pEvil2 = NULL;
	m_pEvil3 = NULL;
	m_pEvil4 = NULL;
	m_pEvil5 = NULL;
	m_pEvil6 = NULL;
	m_pEvil7 = NULL;

	m_pMainWin			= NULL;
	m_bPerformInstall	= FALSE;
	m_bInterrupt		= FALSE;
	m_bParamDoCRCCheck	= FALSE;
	m_bOfficeMode		= FALSE;
	m_bResponseWizard	= FALSE;
    m_bNoVcl            = FALSE;
    m_bParamDisableGUI  = FALSE;
    m_bParamLanguage    = FALSE;

	m_nLanguage			= 0;
	m_nWorkStationCnt	= 0;
	m_nWorkStationIdx	= 0;

	#if defined WIN || defined WNT
	m_bShare            = TRUE;
	#endif

	m_pExecuter			= NULL;
	m_pExitAccel      	= NULL;
	m_pEnv            	= new SiEnvironment;
	m_pCompiledScript	= NULL;
	m_pOldCompiledScript	= NULL;
	m_pResponseFile		= NULL;
    m_pFirstEvent       = NULL;
    m_pResMan           = NULL;

	pSetupApp 			= this;

	Critical::AllocStaticInstance();
	Critical::GetStaticInstance()->SetStdOut( FALSE );
}

SetupApp::~SetupApp()
{
	if( param_bEvil )
	{
		delete m_pEvil1;
		delete m_pEvil2;
		delete m_pEvil3;
		delete m_pEvil4;
		delete m_pEvil5;
		delete m_pEvil6;
		delete m_pEvil7;
	}

	if( m_pMainDlg )
	{
		Application::SetDefDialogParent( NULL );
		delete m_pMainDlg;
	}

	delete m_pEnv;
	delete m_pCompiledScript;
	delete m_pOldCompiledScript;

	if( m_pResponseFile )
	{
		delete m_pResponseFile;
		m_pResponseFile = NULL;
	}

	Critical::DeleteStaticInstance();
}

// -----------------------------------------------------------------------

SetupApp aSetupApp;
SetupApp *pSetupApp = &aSetupApp;

// -----------------------------------------------------------------------
void SetupApp::Main()
{
    // bootstrap an initial context and set it as process service manager
	// #91782#

    BOOL bHasApplicatProblems = FALSE;
    SetupParameter eCommand   = PAR_IGNORE;
    UniString aParamError;

    Reference<XMultiServiceFactory> xMS;

    try
    {
        Reference<XComponentContext> xComponentContext = defaultBootstrap_InitialComponentContext();
    	xMS.set(xComponentContext->getServiceManager(), UNO_QUERY);
    	comphelper::setProcessServiceFactory(xMS);
    }
    catch (::com::sun::star::uno::Exception e )
    {
        ByteString aError( UniString( e.Message ), (rtl_TextEncoding) RTL_TEXTENCODING_ASCII_US );
        Critical::GetStaticInstance()->SetLogFile( ByteString( SETUP_ERROR_LOG_FILE ) );
        Critical_Log( aError );
        bHasApplicatProblems = TRUE;
    }

    m_pEnv->InitStartPath();
    // Java is needed to have accessibility in the setup
    prepareJava(m_pEnv->GetStartPath().GetBuffer());

    ReadParams( aParamError, eCommand );

    if( !LoadResources() )
        Critical_Error( ERR_RESFILE_NOTFOUND, "" );

    USHORT nResponseStep = m_pEnv->GetResponseStep();

    if( ! Critical::GetStaticInstance()->IsDebug() &&
        m_pEnv->GetResponseFilename().Len() &&
        ( ( nResponseStep == 1 ) || ( nResponseStep == 2 ) ||
          m_bParamDisableGUI ) )
    {
        m_bNoVcl = TRUE;
		m_pEnv->SetHasVCL( FALSE );
    }
    else
    {
        #ifdef UNX
        #ifndef MACOSX
        extern unsigned char check_fontpath();
        if( check_fontpath() )
        {
            fprintf( stderr, "error in fontpath (salvaged)\n" );
        }
        #endif
        #endif
        InitVCL( xMS );
    }

	oslModule aTestToolModule = InitTestToolLib();
//	m_pRemoteControl = new RemoteControl;

	if ( ! m_bNoVcl )
    {
        Help::EnableBalloonHelp();
	    SetAccelerators();
	    EnableAutoHelpId();
    }

	m_pEnv->SetUILanguage( m_nLanguage );

	if ( ! m_bNoVcl )
    {
        if( Application::GetSettings().GetMiscSettings().GetEnableATToolSupport() )
        {
            BOOL bQuitApp;
            if( !InitAccessBridge( true, bQuitApp ) )
                if( bQuitApp )
                    return;
        }

        m_pMainWin = new SetupWindow;

		// #100182# IMPORTANT before
		AllSettings  aAllSettings( Application::GetSettings() );
		MiscSettings aMiscSettings( aAllSettings.GetMiscSettings() );

		// so now we get the MiscSettings.
		BOOL bEnable = aMiscSettings.GetEnableATToolSupport();
		m_pEnv->SetATToolSupport( bEnable );

#ifndef WNT
        // Try to use the soui.ttf file next to the setup executable as a private font file
        // this doesn't work well with windows, so non windows system only
        OUString aPath;
        if ( osl_Process_E_None == osl_getExecutableFile( &aPath.pData ) )
        {
            INetURLObject aPathObj( aPath );

            aPathObj.SetName( OUString::createFromAscii( SETUP_FONT_FILE ) );
            if ( m_pMainWin->AddTempDevFont( aPathObj.GetMainURL( INetURLObject::NO_DECODE ),
                                             OUString::createFromAscii( SETUP_FONT_NAME ) ) )
            {
                StyleSettings aStyle( aAllSettings.GetStyleSettings() );
                Font aAppFont = aStyle.GetAppFont();
                aAppFont.SetName( OUString::createFromAscii( SETUP_FONT_NAME ) );
                aStyle.SetAppFont( aAppFont );
                aAllSettings.SetStyleSettings( aStyle );
            }
            else
            {
                aPathObj.SetName( OUString::createFromAscii( SETUP_FONT_FILE2 ) );
                if ( m_pMainWin->AddTempDevFont( aPathObj.GetMainURL( INetURLObject::NO_DECODE ),
                                                 OUString::createFromAscii( SETUP_FONT_NAME2 ) ) )
                {
                    StyleSettings aStyle( aAllSettings.GetStyleSettings() );
                    Font aAppFont = aStyle.GetAppFont();
                    aAppFont.SetName( OUString::createFromAscii( SETUP_FONT_NAME2 ) );
                    aStyle.SetAppFont( aAppFont );
                    aAllSettings.SetStyleSettings( aStyle );
                }
				else
				{
					aPathObj.SetName( OUString::createFromAscii( SETUP_FONT_FILE3 ) );
                	if ( m_pMainWin->AddTempDevFont( aPathObj.GetMainURL( INetURLObject::NO_DECODE ),
                                                 	OUString::createFromAscii( SETUP_FONT_NAME3 ) ) )
                	{
                    	StyleSettings aStyle( aAllSettings.GetStyleSettings() );
                    	Font aAppFont = aStyle.GetAppFont();
                    	aAppFont.SetName( OUString::createFromAscii( SETUP_FONT_NAME3 ) );
                    	aStyle.SetAppFont( aAppFont );
                    	aAllSettings.SetStyleSettings( aStyle );
					}
				}
            }
        }
#endif

#ifdef UNX
        MouseSettings aMouseSettings = aAllSettings.GetMouseSettings();
        aMouseSettings.SetMiddleButtonAction( MOUSE_MIDDLE_PASTESELECTION );
        aAllSettings.SetMouseSettings( aMouseSettings );
#endif
        Application::SetSettings( aAllSettings );

        // Init children here because SetSettings might overwrite the
        // settings of all children
        m_pMainWin->InitChildren( m_pResMan );
    }

	if( aParamError.Len() )
	{
        // This errorbox is ok, because parameter errors in response file mode
        // will be handled elsewhere
        ErrorBox aBox(NULL, WB_OK, aParamError);
		aBox.Execute();
        return;
	}
    else if ( eCommand == PAR_SHOW_USAGE ||
              eCommand == PAR_SHOW_HELP )
    {
        ShowUsage( eCommand );
        return;
    }

	if( param_bEvil )
	{
		m_pEvil1 = new Evil();
		m_pEvil2 = new Evil();
		m_pEvil3 = new Evil();
		m_pEvil4 = new Evil();
		m_pEvil5 = new Evil();
		m_pEvil6 = new Evil();
		m_pEvil7 = new Evil();

		m_pEvil1->create();
		m_pEvil2->create();
		m_pEvil3->create();
		m_pEvil4->create();
		m_pEvil5->create();
		m_pEvil6->create();
		m_pEvil7->create();
	}

	if( !FindAndReadScript() )
	{
		Exit();
		return;
	}

	if ( bHasApplicatProblems )
    {
        UniString anErrorText;

        if ( m_pEnv->IsFirstInstallation() )
            anErrorText = UniString( ResId( ERR_NO_APPLICAT_RDB ) );
        else
        {
            anErrorText = UniString( ResId( ERR_NO_APPLICAT_RDB_2 ) );
            anErrorText.SearchAndReplaceAll( UniString::CreateFromAscii("%1"),
                                             UniString( m_pEnv->GetSourcePath(),
                                                        osl_getThreadTextEncoding() ) );

        }

        UniString aTitle = GetAppName();
        if ( ! aTitle.Len() )
            aTitle = GetAppFileName();
        
		if( !IsResponseMode() )
        {
            ErrorBox aBox( GetAppWindow(), WB_OK, anErrorText );
            aBox.SetText( aTitle );
            aBox.Execute();
        }
   	    Critical_Error( ERR_INVALID_APPLICAT_RDB, ByteString(anErrorText, osl_getThreadTextEncoding()) );
    }

    if ( ! m_bNoVcl )
    {
        Application::SetDefDialogParent( m_pMainWin );

	    if( m_pEnv->GetInstallMode() == IM_APPSERVER &&
		    !m_bResponseWizard && !m_pEnv->GetResponseStep() && !m_bParamDoCRCCheck )
	    {
		    UniString anError(ResId(ERR_ONLY_RESPONSE));
		    ErrorBox aBox( GetAppWindow(), WB_OK, anError );
		    aBox.Execute();
		    Quit();
	    }
    }

    if( m_pEnv->IsFirstInstallation() && !m_pEnv->InstallFromNet() )
	{
		// es wird alles fuer Default voreingestellt, wenn die Page InstallMode
		// angezeigt wird passt diese den Mode event. wieder an!
		m_pEnv->SetInstallType( IT_MAXIMAL );
		m_pCompiledScript->GetRootModule()->Select( SiModule::ALL_DEFAULT );
	}

	if ( ! m_bNoVcl )
    {
        m_pMainWin->ShowFullScreenMode(FALSE);

	    // Set MainWindow title
	    String aTitle( m_pMainWin->GetText() );
	    aTitle += String( m_pEnv->GetProductName(), osl_getThreadTextEncoding() );
	    aTitle += ' ';

        if ( ( m_pEnv->GetInstallMode() == IM_PATCH ) && m_pSecondResMgr )
        {
			aTitle += String( ResId( STR_DLG_TITLE_PATCH, m_pSecondResMgr ) );
		}
        else
        {
			aTitle += String( ResId( STR_DLG_TITLE ) );
		}
		
        m_pMainWin->SetText( aTitle );
    }

	////////////////////////////////
	// crc check
	if( m_bParamDoCRCCheck ) {
		PostUserEvent(EVT_START);
		Execute();
		DeInitTestToolLib( aTestToolModule );
//		delete m_pRemoteControl;
		return;
	}

	////////////////////////////////
	// webinstall mode
	SiDirEntry aWebResponse( m_pEnv->GetStartPath() );
	aWebResponse += ByteString( WEBRESPONSE_FILENAME );
	if( !aWebResponse.Exists() )
	{
		aWebResponse  = m_pEnv->GetSourcePath();
		aWebResponse += ByteString( WEBRESPONSE_FILENAME );
	}
	if( aWebResponse.Exists() )
	{
		Config aCfg( aWebResponse.GetFullUni() );

		aCfg.SetGroup( WEBRESPONSE_SEC_INSTALLATION );
		m_pEnv->SetDestPath( aCfg.ReadKey("installDir") );
		ByteString aLanguages = aCfg.ReadKey("installLang");

		USHORT nDelimTok = 0;
		USHORT nTokCount = aLanguages.GetTokenCount(';');
		for( USHORT x = 0; x < nTokCount; ++x )
		{
			ByteString a( aLanguages.GetToken(0, ';', nDelimTok) );

			LanguageContext* pCtx = new LanguageContext;
			pCtx->nLanguage	= (USHORT) a.GetToken( 0, ':' ).ToInt32();
			pCtx->isProg   	= a.GetToken( 1, ':' ) == "1"? TRUE : FALSE;
			pCtx->isDoc		= a.GetToken( 2, ':' ) == "1"? TRUE : FALSE;

			m_pEnv->AddLanguageContext( pCtx );
		}

		aCfg.SetGroup( WEBRESPONSE_SEC_USERDATA );
		m_pEnv->SetUserName			( aCfg.ReadKey("lastName", osl_getThreadTextEncoding()) );
		m_pEnv->SetUserFirstName	( aCfg.ReadKey("firstName", osl_getThreadTextEncoding()) );
		m_pEnv->SetUserEMail		( aCfg.ReadKey("email", osl_getThreadTextEncoding()) );
		m_pEnv->SetCompanyName		( aCfg.ReadKey("firm", osl_getThreadTextEncoding()) );
		m_pEnv->SetStreet			( aCfg.ReadKey("address", osl_getThreadTextEncoding()) );
		m_pEnv->SetZip				( aCfg.ReadKey("zip", osl_getThreadTextEncoding()) );
		m_pEnv->SetCity				( aCfg.ReadKey("city", osl_getThreadTextEncoding()) );
		m_pEnv->SetTitle			( aCfg.ReadKey("title", osl_getThreadTextEncoding()) );
		m_pEnv->SetPosition			( aCfg.ReadKey("position", osl_getThreadTextEncoding()) );
		m_pEnv->SetFax				( aCfg.ReadKey("fax", osl_getThreadTextEncoding()) );
		m_pEnv->SetTelefonWork		( aCfg.ReadKey("telOffice", osl_getThreadTextEncoding()) );
		m_pEnv->SetTelefonHome		( aCfg.ReadKey("telHome", osl_getThreadTextEncoding()) );
		m_pEnv->SetState			( aCfg.ReadKey("state", osl_getThreadTextEncoding()) );
		m_pEnv->SetCountry			( aCfg.ReadKey("country", osl_getThreadTextEncoding()) );
		m_pEnv->SetUserFatherName	( aCfg.ReadKey("fatherName", osl_getThreadTextEncoding()) );
		m_pEnv->SetApartment   		( aCfg.ReadKey("apartment", osl_getThreadTextEncoding()) );

		m_pCompiledScript->GetRootModule()->Select(SiModule::ALL_UNSEL);
		aCfg.SetGroup( WEBRESPONSE_SEC_MODULE );
		for( USHORT i = 0; i < aCfg.GetKeyCount(); ++i )
		{
			BOOL bRegister = aCfg.ReadKey(i) == "1" ? TRUE : FALSE;
			if( bRegister )
			{
				ByteString aModuleID( aCfg.GetKeyName(i) );
				SiModule* pMod = PTR_CAST( SiModule, m_pCompiledScript->Find(aModuleID) );
				if( pMod ) pMod->Select( SiModule::THIS_SEL );
			}
		}

    	if ( ! m_bNoVcl )
        {
		    m_pMainWin->Show();
		    m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_ADD );
            m_pMainWin->SetVendorBMP( m_pCompiledScript->GetInstallation()->GetVendorBMP() );
            m_pMainWin->SetLogoBMP( m_pCompiledScript->GetInstallation()->GetLogoBMP() );
		    if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );
		    PostUserEvent( EVT_START_INSTALL );

		    Execute();
        }
        else
        {
            Critical_Error( ERR_WRONG_INSATALLATIONMODE, "" );
        }
		aWebResponse.Kill();
	}
	else
	////////////////////////////////
	// moduledump mode
	if( param_bModuleDump )
	{
		SiDirEntry aEntry( m_pEnv->GetSourcePath() );
		if( m_aParamDestPath.Len() )
			aEntry += m_aParamDestPath;
		aEntry += ByteString( "script.htm" );
		aEntry.ToAbs();
		if( aEntry.GetPath().Exists() ) aEntry.GetPath().MakeDir();
		SiHelp::ModuleDump( m_pCompiledScript->GetRootModule(), aEntry.GetFull() );
		Exit();
		return;
	}
	else
	////////////////////////////////
	// Response Wizard mode
	if( m_bResponseWizard )
	{
		Critical::GetStaticInstance()->SetDebug( TRUE );
		m_pEnv->SetUINiceLangDefault( FALSE );
		m_pEnv->SetResponsefileWizardMode( TRUE );
		BOOL bSetDefaults = TRUE;

		if( m_pEnv->GetResponseFilename().Len() )
		{
			SiDirEntry aAbsRspFile = m_pEnv->GetSourcePath();
			aAbsRspFile += m_pEnv->GetResponseFilename();
			aAbsRspFile.ToAbs();

			m_pEnv->SetResponseFilename( aAbsRspFile.GetFull() );
		}

		m_pResponseFile = new ResponseFile( m_pEnv, m_pCompiledScript );

		if( m_pEnv->GetResponseFilename().Len() )
		{
			if( !(bSetDefaults = m_pResponseFile->Read(m_pEnv->GetResponseFilename())? FALSE : TRUE) )
			{
				SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
				SiLangCtxList& rUILst = m_pEnv->GetUILanguageContext();
				USHORT nDefLang = (USHORT) m_pCompiledScript->GetInstallation()->GetDefLanguage().ToInt32();

				for( USHORT x = 0; x < rUILst.Count(); ++x )
					rUILst.GetObject(x)->isProg = FALSE;

				for( USHORT i = 0; i < rLst.Count(); ++i )
				{
    				LanguageContext* pAct = rLst.GetObject(i);
					for( USHORT x = 0; x < rUILst.Count(); ++x )
					{
						USHORT nLang = rUILst.GetObject(x)->nLanguage == nDefLang ?
									   LANG_DEFAULT : rUILst.GetObject(x)->nLanguage;
						if( nLang == pAct->nLanguage )
							rUILst.GetObject(x)->isProg = TRUE;
					}
				}

				if( m_pResponseFile->GetDestinationPath().Len() )
					m_pEnv->SetDestPath( m_pResponseFile->GetDestinationPath() );
			}
		}
		else
		{
			SiDirEntry aDefRespFilename( m_pEnv->GetDestPath() );
			if( aDefRespFilename.Level() > 1 )
				aDefRespFilename = aDefRespFilename[1];
			aDefRespFilename += ByteString("responsefile.txt");

			m_pEnv->SetResponseFilename( aDefRespFilename.GetFull() );
		}

		if( bSetDefaults )
		{
			m_pResponseFile->SetInstallationMode	( INSTALL_NETWORK );
			m_pResponseFile->SetInstallationType	( SPECIFY );
		}

		PostUserEvent(EVT_START);
		Execute();
	}
	else
	////////////////////////////////
	// repair mode
	if( param_bRepair )
	{
		ByteString aInstalledPath;
		if( SiHelp::IsVersionAlreadyInstalled(aInstalledPath, m_pCompiledScript, m_pEnv) &&
			aInstalledPath.CompareIgnoreCaseToAscii(m_pEnv->GetStartPath()) != COMPARE_EQUAL  )
		{
			// Setup wurde vom Installations-Medium aufgerufen.
			ByteString strInstDB( SETUP_INSTDB_FILE );
			SiDirEntry aInstDB( aInstalledPath );
			aInstDB += strInstDB;
			while( (!aInstDB.Exists()) && (aInstDB.Level() > 2) )
			{
				aInstDB = aInstDB[2];
				aInstDB += strInstDB;
			}

			if( aInstDB.Exists() )
				ReadScript( aInstDB );

			m_pEnv->SetInstalledPath( aInstalledPath );
			m_pEnv->SetDestPath( aInstalledPath );
			m_pEnv->SetFirstInstallation( FALSE );
            m_pEnv->SetInstallMode( m_pCompiledScript->GetInstallation()->GetInstallMode() );

			if( m_pCompiledScript->GetInstallation() )
				m_pEnv->SetSourcePath( m_pCompiledScript->GetInstallation()->GetSourcePath() );
		}

		if ( ! m_bNoVcl )
        {
            m_pMainWin->SetVendorBMP( m_pCompiledScript->GetInstallation()->GetVendorBMP() );
            m_pMainWin->SetLogoBMP( m_pCompiledScript->GetInstallation()->GetLogoBMP() );
		    if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );

            m_pMainWin->Show();
//          m_pMainWin->Update();

            m_pEnv->SetInstallType( IT_RECOVER );
		    PostUserEvent( EVT_REINST_RECOVER );
		    Execute();
        }
        else
        {
            Critical_Error( ERR_WRONG_INSATALLATIONMODE, "" );
        }

	}
	else
	////////////////////////////////
	// response mode
	if( m_pEnv->GetResponseFilename().Len() )
	{
		Critical::GetStaticInstance()->SetStdOut( TRUE );

		SiDirEntry aFile( m_pEnv->GetResponseFilename() );
		if( !aFile.Exists() )
		{
			aFile = m_pEnv->GetStartPath();
			aFile += m_pEnv->GetResponseFilename();
			if( !aFile.Exists() )
			{
				aFile = m_pEnv->GetSourcePath();
				aFile += m_pEnv->GetResponseFilename();
				if( !aFile.Exists() )
					Critical_Error( ERR_RESPONSEFILE_NOTFOUND, "" );
			}
		}

		CheckForUpdate();

        aFile.ToAbs();
		m_pEnv->SetResponseFilename( aFile.GetFull() );

		m_pResponseFile = new ResponseFile( m_pEnv, m_pCompiledScript );
		m_pEnv->SetResponsefileMode( TRUE );

		if( m_aParamDestPath.Len() )
			m_pResponseFile->SetDestinationPath( m_aParamDestPath );
		m_pResponseFile->Read( aFile.GetFull() );

        if( m_pEnv->GetResponseStep() == 1 )
        {
            // Response step one requires a module set
            // We will exit, when there is none
            if ( ! param_aModuleSet.Len() )
                Critical_Error( ERR_NOMODULES, "" );
        }

		if( param_aModuleSet.Len() )
		{
			SiModuleSet* pSet = SiHelp::FindModuleSetByName(m_pEnv, param_aModuleSet);
			if( !pSet )
			{
				Critical_Error( ERR_INSTALLMODULESET_NOTFOUND, "" );
			}
			else
			{
				m_pCompiledScript->GetRootModule()->Select(SiModule::ALL_UNSEL);
				pSet->Select();
				m_pResponseFile->SetPreModuleSet(TRUE);
			}
		}

		if( m_pEnv->GetResponseStep() == 2 )
		{
			m_pEnv->SetFirstInstallation(TRUE);
			m_pEnv->SetInstallType( IT_MAXIMAL );

			SiModuleSetList& rLst = m_pEnv->GetModuleSetList();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				SiModuleSet* pSet = rLst.GetObject(i);
                pSet->Select( SiModule::THIS_SEL_IGNORE_INST );
			}
			m_pResponseFile->SetPreModuleSet( TRUE );
		}

		USHORT nEvt = m_pResponseFile->ProcessEvents();

		if ( ! m_bNoVcl )
        {
            if( ( nEvt == EVT_START_INSTALL ) )
			    m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_ADD );

            m_pMainWin->SetVendorBMP( m_pCompiledScript->GetInstallation()->GetVendorBMP() );
            m_pMainWin->SetLogoBMP( m_pCompiledScript->GetInstallation()->GetLogoBMP() );

            if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );
        }

		m_pResponseFile->ExecStartProcedure();

        PostUserEvent( nEvt );

        if ( m_bNoVcl )
            HandleUserEvents();
        else
		    Execute();
	}
	else
	////////////////////////////////
	// normal- & officemode
	{
		if( param_bOfficeMode &&
			m_pEnv->GetInstallMode() != IM_NETWORK )
			m_bOfficeMode = TRUE;

		if ( ! m_bNoVcl )
        {
#ifdef UNX /* #95450# */
            if (m_pEnv->IsLocal() == FALSE)
            {
                // For a Network installation check whether we are root and whether 
                // the umask is set properly
                BOOL bQuit = FALSE;
                if (getuid() != 0)
                {
                    String suText( ResId(STR_NETWORK_WARNING_IF_NO_ROOT, (ResMgr*)m_pResMan) );
                    suText.SearchAndReplace( UniString::CreateFromAscii("%1"),
                                             UniString::CreateFromAscii(m_pEnv->GetProductName().GetBuffer()) );
                    QueryBox aBox(NULL, WB_YES_NO | WB_DEF_NO, suText);
                    if ( aBox.Execute() == RET_NO)
                        bQuit = TRUE;
                }

                mode_t aMask = umask( 0 );
                umask( aMask );

                if ( !bQuit && ( aMask | 022 ) != 022 )
                {
                    String suText( ResId(STR_NETWORK_WARNING_BAD_UMASK, (ResMgr*)m_pResMan) );
                    suText.SearchAndReplace( UniString::CreateFromAscii("%PRODUCTNAME"),
                                             UniString::CreateFromAscii(m_pEnv->GetProductName().GetBuffer()) );
                    QueryBox aBox(NULL, WB_YES_NO | WB_DEF_NO, suText);
                    if ( aBox.Execute() == RET_NO)
                        bQuit = TRUE;
                }

                if ( bQuit )
                    Quit();
            }
#endif
            m_pMainWin->SetVendorBMP( m_pCompiledScript->GetInstallation()->GetVendorBMP() );
            m_pMainWin->SetLogoBMP( m_pCompiledScript->GetInstallation()->GetLogoBMP() );
		    if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );

            m_pMainWin->Show();
//          m_pMainWin->Update();

            PostUserEvent(EVT_START);
		    Execute();
        }
	}

	if ( ! m_bNoVcl )
        Application::SetDefDialogParent( NULL );

	DeInitTestToolLib( aTestToolModule );
//	DELETEZ( m_pRemoteControl );
	DELETEZ( m_pExitAccel );
	Resource::SetResManager( NULL );
	DELETEZ( m_pResMan );

    if ( ! m_bNoVcl )
    {
        DELETEZ( m_pMainWin );
        DeInitVCL();
    }
}

void ResourceHook_Setup( UniString& rStr )
{
	UniString aSingleName, aName, aProductPatchName;
	if( param_bAutoPilot )
	{
		aSingleName = UniString( pSetupApp->GetEnvironment()->GetVendorName(), osl_getThreadTextEncoding() );
		aName = UniString( pSetupApp->GetEnvironment()->GetVendorVersion(), osl_getThreadTextEncoding() );
	}
	else
	{
		aSingleName = UniString( pSetupApp->GetEnvironment()->GetSingleProductName(), osl_getThreadTextEncoding() );
		aName = UniString( pSetupApp->GetEnvironment()->GetProductVersion(), osl_getThreadTextEncoding() );
	}

	aProductPatchName = pSetupApp->GetProductPatchName();

	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTNAME"), aSingleName );
	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTVERSION"), aName );

	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTPATCHNAME"), aProductPatchName );

	SiCompiledScript* pCS = pSetupApp->GetOldCScript();
	if (pCS)
	{
		SiInstallation* pCurrentInstall = pCS->GetInstallation();
		if (pCurrentInstall)
		{
			ByteString sProductVersion = pCurrentInstall->GetProductVersion();
			UniString suProductVersion( sProductVersion, osl_getThreadTextEncoding() );
			rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PREVIOUSPRODUCTVERSION"), suProductVersion );
		}
	}
	else
	{
		// to prevent us for showing unused text
		rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PREVIOUSPRODUCTVERSION"), UniString() );
	}
}

// -----------------------------------------------------------------------------
namespace setup
{
	ResMgr* LoadResourcesByName(ByteString const& _sName, LanguageType& _nType)
	{
		ByteString aMgrName(_sName);
		aMgrName += ByteString::CreateFromInt32( SOLARUPD );
		ResMgr* pResMgr = ResMgr::SearchCreateResMgr( aMgrName.GetBuffer(), _nType );

		return pResMgr;
	}
}

// -----------------------------------------------------------------------------

BOOL SetupApp::LoadResources()
{
    if ( m_pResMan )    // resource manager already set?
        return TRUE;

    LanguageType  nType;
    ByteString    aMgrName( "set" );
    ResMgr       *pResMgr = NULL;
    
    // When a language is set ( via parameter -l <languageid> ) we first
    // try to use the appropiate resource.
    if ( m_nLanguage )
    {
        LanguageType nParLang = SvAgentDlg::Lang2LangType( m_nLanguage );
        nType = nParLang;
        pResMgr = setup::LoadResourcesByName( aMgrName, nType );
        if ( nType != nParLang )
        {
            delete pResMgr;
            pResMgr = NULL;
        }
    }

    // When we don't have a resmgr yet, we try to get one matching
    // our system language ( or use a nice default ( implemented by
    // SearchCreateResMgr() ) )
    if ( !pResMgr )
    {
        nType = GetSystemUILanguage();
        pResMgr = setup::LoadResourcesByName( aMgrName, nType );
    }

	// load a second resource file
	// try to load the allready found language also for the product patch version.
	LanguageType nType2 = nType;
	m_pSecondResMgr = setup::LoadResourcesByName("set_pp1", nType2);

	if( pResMgr )
	{
	    m_pResMan = pResMgr;
        Resource::SetResManager( pResMgr );
        ResMgr::SetReadStringHook( ResourceHook_Setup );
		AllSettings aSettings = Application::GetSettings();
        aSettings.SetUILanguage( nType );
        SetSettings( aSettings );
	}
	else
		return FALSE;


#ifndef UNX
	// init icon, svlook
	InitAppRes(ResId(APP_ID));
#endif

	UniString aUniFilename( pResMgr->GetFileName() );
	ByteString aFileName = ByteString(aUniFilename, osl_getThreadTextEncoding()).ToLowerAscii();
    xub_StrLen nLast, nPos = 0;

    nPos = aFileName.Search( aMgrName.ToLowerAscii() );
    while ( nPos != STRING_NOTFOUND )
    {
        nLast = nPos;
        nPos = aFileName.Search(aMgrName.ToLowerAscii(), nPos+1);
    }

	m_nLanguage = aFileName.Copy( nLast + aMgrName.Len() + 3, 2).ToInt32();

	// get Product Patch Brand Name from resources
	if( m_pSecondResMgr )
	{
		ResId aResId(STR_PRODUCTPATCH);
		ResId aResId2(STR_PRODUCTPATCH, m_pSecondResMgr);
		aResId2.SetRT(RSC_STRING);
		if( aResId2.GetResMgr()->IsAvailable(aResId2) )
		{
			aResId.SetResMgr( m_pSecondResMgr );
		}
		m_aProductPatchName = String( aResId );
	}

    return TRUE;
}

BOOL SetupApp::IsResponseMode() const
{
	return m_pEnv && m_pEnv->GetResponseFilename().Len()? TRUE : FALSE;
}

BOOL SetupApp::GetAdditionalParam( int &i, ByteString& rExtendedParam )
{
    rExtendedParam  = ByteString( GetCommandLineParam(i), osl_getThreadTextEncoding() );
    xub_StrLen nPos = rExtendedParam.Search( ':' );
    
    if ( nPos == STRING_NOTFOUND )
    {
        rExtendedParam = ByteString( GetCommandLineParam(i+1), osl_getThreadTextEncoding() );
        if ( !rExtendedParam.Len() || ( PAR_UNKNOWN != GetParameter( rExtendedParam ) ) )
            return FALSE;
        else
            i += 1;                 // skip this parameter as it is already handled
    }
    else
    {
        rExtendedParam.Erase( 0, nPos+1 );
        if ( !rExtendedParam.Len() )
            return FALSE;
    }

    return TRUE;
}

SetupParameter SetupApp::GetParameter( const ByteString& rParameter )
{
    SetupParameter  eParameter;
    ByteString      aParameter = rParameter.GetToken( 0, ':' );

    if ( ( aParameter.GetChar(0) == '-' ) ||
         ( aParameter.GetChar(0) == '/' ) )
        aParameter.Erase( 0, 1 );
    else
        return PAR_UNKNOWN;

    aParameter.ToUpperAscii();

    if( aParameter == "CRC" || aParameter == "C" )          // CRC
        eParameter = PAR_CRC_CHECK;
    else if( aParameter == "NET" || aParameter == "N" )     // NET
        eParameter = PAR_NET_INSTALL;
    else if( aParameter == "VIRTUAL" )                      // VIRTUAL
        eParameter = PAR_VIRTUAL;
    else if( aParameter == "V" )                            // VERBOSE
        eParameter = PAR_VERBOSE;
    else if( aParameter == "DEBUG" )                        // DEBUG
        eParameter = PAR_DEBUG;
    else if( aParameter == "NOEXIT" )                       // NOEXIT
        eParameter = PAR_NOEXIT;
    else if( aParameter == "RESPONSEFILEAUTOPILOT" ||       // RESPONSEWIZARD
             aParameter == "RSPA" )
        eParameter = PAR_RESPONSEFILEAUTOPILOT;
    else if( aParameter == "RSP1" )                         // RSP1:(RESPONSE FILE first step)
        eParameter = PAR_RSP1;
    else if( aParameter == "RSP2" )                         // RSP2:(RESPONSE FILE second step)
        eParameter = PAR_RSP2;
    else if( aParameter == "MSET" )                         // module set for response file mode
        eParameter = PAR_MSET;
    else if( aParameter == "R" )                            // R:(RESPONSE FILE)
        eParameter = PAR_RESPONSEFILE;
    else if( aParameter == "SDUMP" )                        // SDUMP
        eParameter = PAR_SDUMP;
    else if( aParameter == "OFFICEMODE" )                   // OFFICEMODE
        eParameter = PAR_OFFICEMODE;
    else if( aParameter == "REPAIR" )                       // REPAIR
        eParameter = PAR_REPAIR;
    else if( aParameter == "REINSTALL" )                    // REINSTALL
        eParameter = PAR_REINSTALL;
    else if( aParameter == "DEINSTALL" )                    // DEINSTALL
        eParameter = PAR_DEINSTALL;
    else if( aParameter == "NOREG" )                        // NOREG
        eParameter = PAR_NOREG;
    else if( aParameter == "AUSE" )                         // AUSE
        eParameter = PAR_AUSE;
    else if( aParameter == "EVIL" )                         // EVIL
        eParameter = PAR_EVIL;
    else if( aParameter == "UNOEVIL" )                      // UNOEVIL
        eParameter = PAR_UNOEVIL;
    else if( aParameter == "D" )                            // D:(DESTINATION PATH)
        eParameter = PAR_DESTINATION_PATH;
    else if( aParameter == "F" )                            // F:(FOLLOW APP)
        eParameter = PAR_FOLLOW_APP;
    else if (aParameter == "DONTDELETETEMP")                // DONTDELETETEMP
        eParameter = PAR_DONT_DELETE_TEMP;
    else if( aParameter == "PATCH" )                        // Patch
        eParameter = PAR_PATCH;
    else if (aParameter == "UPDATE")                        // Update
        eParameter = PAR_UPDATE;
    else if( aParameter == "NOGUI" )                        // NOGUI
        eParameter = PAR_NOGUI;
    else if( aParameter == "H" || aParameter == "?" ||      // SHOW_HELP
             aParameter == "HELP" )
        eParameter = PAR_SHOW_HELP;
    else if( aParameter == "L" ||                           // LANGUAGE
             aParameter == "LANGUAGE" )
        eParameter = PAR_LANGUAGE;
    else
        eParameter = PAR_UNKNOWN;

    if ( ( eParameter == PAR_UNKNOWN ) &&
         ( aParameter.CompareTo( "SOW", 3 ) == COMPARE_EQUAL ) )
        eParameter = PAR_IGNORE;

    return eParameter;
}

void SetupApp::ReadParams( UniString &rParamError,
                           SetupParameter &rCommand )
{
    SiDirEntry aSetupIni  = m_pEnv->GetStartPath();
               aSetupIni += SiDirEntry(SETUP_INI);

	if (aSetupIni.Exists())
	{
		Config aCfg(aSetupIni.GetFullUni());

		aCfg.SetGroup("Source");
		m_SetupIniSourcePath = aCfg.ReadKey("Path");
		m_pEnv->SetSourcePath(m_SetupIniSourcePath);

		ByteString aTmpBool( aCfg.ReadKey("big", "0") );
		m_pEnv->SetBigMode( (BOOL)(USHORT)aTmpBool.ToInt32() );

		if( m_pEnv->IsBigMode() )
		{
			ByteString aTmpOffset( aCfg.ReadKey("offset", "0") );
		}
	}

#ifdef OS2

	if (!GetCommandLineParamCount())
	{
		if (aSetupIni.Exists())
		{
			Config aIniCfg(aSetupIni.GetFull());
			aIniCfg.SetGroup( "extra" );
			ByteString aVal = aIniCfg.ReadKey( "network" );
			m_pEnv->SetLocal( aVal != "1" );
		}
	}

#endif

    int nCount = GetCommandLineParamCount();

    for ( int i = 0; i < nCount; ++i )
    {
        ByteString  aExtendedParam;
        ByteString  aParam = ByteString( GetCommandLineParam(i), osl_getThreadTextEncoding() );
        BOOL        bExtParamError = FALSE;
        BOOL        bParameterError = FALSE;

        SetupParameter eParameter = GetParameter( aParam );

        switch ( eParameter )
        {
        case PAR_CRC_CHECK: m_bParamDoCRCCheck = TRUE; break;

        case PAR_NET_INSTALL: m_pEnv->SetLocal( FALSE ); break;

        case PAR_VIRTUAL:   m_pEnv->SetVirtualMode( TRUE ); break;

        case PAR_VERBOSE:   m_pEnv->SetVerboseMode( TRUE ); break;

        case PAR_DEBUG:     if( Critical::GetStaticInstance() )
                                Critical::GetStaticInstance()->SetDebug( TRUE );
                            break;

        case PAR_NOEXIT:    if( Critical::GetStaticInstance() )
                                Critical::GetStaticInstance()->SetNoExit( TRUE );
                            break;
        case PAR_RESPONSEFILEAUTOPILOT:
                            m_bResponseWizard = TRUE;
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseFilename( aExtendedParam );
                                param_bAutoPilot = TRUE;  // static 4 reource hook
                            }
                            break;
        case PAR_RSP1:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseStep( 1 );
                                m_pEnv->SetResponseFilename( aExtendedParam );
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_RSP2:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseStep( 2 );
                                m_pEnv->SetResponseFilename( aExtendedParam );
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_MSET:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                                param_aModuleSet = aExtendedParam;
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_RESPONSEFILE:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseStep( 0 );
                                m_pEnv->SetResponseFilename( aExtendedParam );
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_SDUMP:     param_bModuleDump = TRUE; break;

        case PAR_OFFICEMODE: param_bOfficeMode = TRUE; break;

        case PAR_REPAIR:    param_bRepair = TRUE; break;

        case PAR_REINSTALL: m_pEnv->SetForceReinstall( TRUE ); break;

        case PAR_DEINSTALL: m_pEnv->SetForceDeinstall( TRUE ); break;

        case PAR_NOREG:     m_pEnv->SetNoRegistration( TRUE ); break;

        case PAR_AUSE:      m_pEnv->SetAUSEStreamFlush( TRUE ); break;

        case PAR_EVIL:      param_bEvil = TRUE; break;

        case PAR_UNOEVIL:   m_pEnv->SetUNOEvil( TRUE ); break;

        case PAR_DESTINATION_PATH:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_aParamDestPath = aExtendedParam;
                                m_pEnv->SetParamDestPath(TRUE);
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_FOLLOW_APP:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                                m_aParamFollowApp = aExtendedParam;
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_IGNORE:    break;

        case PAR_DONT_DELETE_TEMP: break;

        case PAR_PATCH:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                                m_aParamDestPath = aExtendedParam;
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_UPDATE:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                                m_aUpdateDestPath = aExtendedParam;
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_NOGUI:     m_bParamDisableGUI = TRUE; break;

        case PAR_SHOW_HELP:
        case PAR_SHOW_USAGE: rCommand = eParameter; break;
        
        case PAR_LANGUAGE:  if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_nLanguage = aExtendedParam.ToInt32();
                                m_bParamLanguage = TRUE;
                            }
                            else
                                bExtParamError = TRUE;
                            break;

        default:            bParameterError = TRUE;
        } // end switch ( eParameter )

        if( bParameterError || bExtParamError )
        {
            if( !IsResponseMode() && LoadResources() )
            {
                rParamError = UniString( ResId( bParameterError ? ERR_COMMAND_PARAM : ERR_COMMAND_PARAM_MISSING ) );
                rParamError.SearchAndReplace( UniString::CreateFromAscii( "%1" ),
                                              UniString::CreateFromAscii( aParam.GetBuffer() ) );
                rParamError += '\n';
                rParamError += '\n';
                rParamError += UniString( ResId( ERR_SHOW_USAGE ) );
				return;
            }
            else
                Critical_Error( ERR_WRONGPARAMETER, "" );
        }
    } // end for ( int i = 0; i < nCount; ++i )

    if ( m_bParamDisableGUI && ! m_pEnv->GetResponseFilename().Len() )
    {
        Critical::GetStaticInstance()->SetStdOut( TRUE );
        Critical_Error( ERR_WRONGPARAMETER, "" );
    }
}

// -----------------------------------------------------------------------------

BOOL SetupApp::FindAndReadScript()
{
	BOOL bWorkstation = FALSE;

	ByteString aScriptName( SETUP_INSTDB_FILE );
	SiDirEntry aScript (m_pEnv->GetStartPath());
	aScript += aScriptName;

	while( (!aScript.Exists()) && (aScript.Level() > 2) )
	{
		aScript = aScript[2];
		aScript += aScriptName;
	}

	if( aScript.Exists() )
	{
		m_pEnv->SetFirstInstallation(FALSE);
	}
	else
	{
		m_pEnv->SetFirstInstallation();

		if( m_pEnv->IsBigMode() )
		{
			ArchDirectory* pArch = new ArchDirectory;
			SiDirEntry aEntry( m_SetupIniSourcePath );
			if( !pArch->SetArchFile(aEntry.GetFull().GetBuffer()) )
			{
				if( !IsResponseMode() )
				{
					aEntry.ToAbs();
					m_pEnv->SetInstalledPath(aEntry.GetFull());
					ShowScriptNotFound();

					delete pArch;
					return FALSE;
				}
				else
					Critical_Error( ERR_SCRIPT_NOTFOUND, "" );
			}
			else
				m_pEnv->SetArchive( pArch, FindArch );

			ByteString aScrt(SETUP_SCRIPT_FILE);
			pArch->GetFile( aScrt.GetBuffer(), m_pEnv->GetStartPath().GetBuffer() );
		}

		aScript  = m_pEnv->GetStartPath();
		aScript += ByteString(SETUP_SCRIPT_FILE);

		if (!aScript.Exists())
		{
			aScript	 = m_SetupIniSourcePath;
			aScript += ByteString(SETUP_SCRIPT_FILE);

			if( !aScript.Exists() )
			{
				if( !IsResponseMode() )
				{
					aScript.ToAbs();
					m_pEnv->SetInstalledPath(aScript.GetFull());
					ShowScriptNotFound();
					return FALSE;
				}
				else
					Critical_Error( ERR_SCRIPT_NOTFOUND, "" );
			}
		}
	}

	if( !ReadScript(aScript) )
	{
		if( !IsResponseMode() )
		{
			ErrorBox( NULL, WB_OK, ResId(ERR_SCRIPT) ).Execute();
			return FALSE;
		}
		else
			Critical_Error( ERR_SCRIPT_NOTFOUND, "" );
	}

	if( !m_pCompiledScript->GetInstallation() )
		return FALSE;

	m_pEnv->SetDefLanguage( (USHORT) m_pCompiledScript->GetInstallation()->GetDefLanguage().ToInt32() );

	m_pEnv->SetSingleProductName( m_pCompiledScript->GetInstallation()->GetProductName() );
	m_pEnv->SetProductVersion( m_pCompiledScript->GetInstallation()->GetProductVersion() );
	m_pEnv->SetVendorName( m_pCompiledScript->GetInstallation()->GetVendorName() );
	m_pEnv->SetVendorVersion( m_pCompiledScript->GetInstallation()->GetVendorVersion() );
	m_pEnv->SetInternalVersion( m_pCompiledScript->GetInstallation()->GetInternalProductVersion() );
	m_pEnv->SetSuiteName( m_pCompiledScript->GetInstallation()->GetSuiteName() );
    m_pEnv->SetInstallMode( m_pCompiledScript->GetInstallation()->GetInstallMode() );

#ifdef WNT
    m_pEnv->SetInstallForAllUser( ! WinOS::SupportsUserRegMerge() );    // Install on older windows system is all users only
#else
    m_pEnv->SetInstallForAllUser( FALSE );
#endif

	if( !m_pEnv->GetVendorName().Len() )
		param_bAutoPilot = FALSE;       // so resource hook dont use this...

	if ( m_pCompiledScript->GetInstallInfo() )
		m_pEnv->SetProductKey( m_pCompiledScript->GetInstallInfo()->GetKey() );

    m_pEnv->SetProductName( m_pEnv->GetSingleProductName(), m_pEnv->GetProductVersion() );

	if( !m_pEnv->IsFirstInstallation() )
	{
        m_pEnv->SetInstallForAllUser( m_pCompiledScript->GetInstallation()->InstallForAllUser() );
		m_pEnv->SetInstalledPath( m_pCompiledScript->GetInstallation()->GetDestPath() );
		m_pEnv->SetDestPath( m_pCompiledScript->GetInstallation()->GetDestPath() );
		if( m_pEnv->GetInstallMode() == IM_NETWORK )
		{
			SiDirEntry aStartRoot( m_pEnv->GetStartPath() );
			aStartRoot = aStartRoot[1];
			aStartRoot.ToAbs();
			m_pEnv->SetSourcePath( aStartRoot.GetFull() );
			m_pEnv->SetInstallFromNet( TRUE );
		}
		else
			m_pEnv->SetSourcePath( m_pCompiledScript->GetInstallation()->GetSourcePath() );

		if( !(m_pEnv->IsLocal() && m_pEnv->GetInstallMode() == IM_NETWORK) )
		{
			ArchDirectory* pArch = new ArchDirectory;
			if( pArch->SetArchFile(m_pCompiledScript->GetInstallation()->GetSourcePath().GetBuffer()) )
			{
				m_pEnv->SetBigMode( TRUE );
				m_pEnv->SetArchive( pArch, FindArch );
				m_pEnv->SetSourcePath( m_pCompiledScript->GetInstallation()->GetSourcePath() );
			}
			else
				delete pArch;
		}
	}

	// Wenn der MODE == APPSERVER m_bIsLocal auf FALSE setzen
	if( m_pEnv->IsLocal() &&
		m_pEnv->GetInstallMode() == IM_APPSERVER )
		m_pEnv->SetLocal( FALSE );

	// Bei Netzinstallation noch ermitteln, ob vielleicht die
	// Arbeitsplatzinstallation gemeint war.
	if( m_pEnv->IsLocal() &&
		m_pEnv->GetInstallMode() == IM_NETWORK)
	{
		// In z.B. sversion.ini nachschauen, ob es dort einen Verweis auf das installierte
		// Programm gibt.
		SiProfileItem *pItem = m_pCompiledScript->GetInstallInfo();

		if (pItem != NULL)
		{
			aScript  = GetValue(pItem,"__empty__");
			aScript += ByteString(SETUP_INSTDB_FILE);

			// Eintrag muss existieren und gueltig sein
			if( aScript.Exists() )
			{
				ByteString aNetLang;
                SiInstallation *pNetInst = m_pCompiledScript->GetInstallation();
                if ( pNetInst )
                    aNetLang = pNetInst->GetInstalledLanguages();

                if( !ReadScript(aScript) )
				{
					if( !IsResponseMode() )
					{
						ErrorBox(NULL,WB_OK,ResId(ERR_SCRIPT)).Execute();
						return FALSE;
					}
					else
						Critical_Error( ERR_SETUPSCRIPT, "" );
				}

				SiInstallation *pWorkInst = m_pCompiledScript->GetInstallation();

                m_pEnv->SetInstalledPath( ((SiDirEntry&)aScript.GetPath()).GetFull() );
				m_pEnv->SetDestPath( ((SiDirEntry&)aScript.GetPath()).GetFull() );
				m_pEnv->SetFirstInstallation(FALSE); // in bezug auf Arbeitsplatz ...
                m_pEnv->SetInstallMode( pWorkInst->GetInstallMode() );
			    m_pEnv->SetInstallForAllUser( pWorkInst->InstallForAllUser() );

                if ( aNetLang.Len() && !pWorkInst->GetInstalledLanguages().Len() )
                {
                    pWorkInst->SetInstalledLanguages( aNetLang );
                    USHORT nLanguage = (USHORT) pWorkInst->GetLanguages().ToInt32();
                    m_pEnv->SetUILanguage( nLanguage );
                }
			}
			else
			{
				bWorkstation = TRUE;
				m_pEnv->SetFirstInstallation(); // in bezug auf Arbeitsplatz ...
#ifdef WNT
                m_pEnv->SetInstallForAllUser( ! WinOS::SupportsUserRegMerge() );    // Install on older windows system is all users only
#else
                m_pEnv->SetInstallForAllUser( FALSE );
#endif
				m_pEnv->SetDestPath( ((SiDirEntry&)aScript.GetPath()).GetFull() );
            }
		}
		else
			bWorkstation = TRUE;
	}

	// Wenn eine Erstinstallation basierend auf einer Netzinstallation
	// durchgefuhert werden soll.
	if( bWorkstation &&
		m_pEnv->IsFirstInstallation() &&
		m_pEnv->GetInstallMode() == IM_NETWORK )
	{
		m_pCompiledScript->PrepareForLocalInstallation();
	}

	if( m_pEnv->IsFirstInstallation() )
	{
		if( m_pEnv->GetInstallMode() == IM_PATCH )
		{
            BOOL        bPathFound  = FALSE;
            short       nLookups    = 0;
            ByteString  aInstalledPath;

			if( !SiHelp::IsVersionAlreadyInstalled(aInstalledPath, m_pCompiledScript, m_pEnv) )
			{
				SiProfileItem* pItem = m_pCompiledScript->GetInstallInfo();
				pItem->SetProperty( "Key", "StarSuite 6.0" );
				SiHelp::IsVersionAlreadyInstalled( aInstalledPath, m_pCompiledScript, m_pEnv );
			}

            if ( ! aInstalledPath.Len() )
                aInstalledPath = m_aParamDestPath;

            while ( !bPathFound && ( nLookups++ < MAX_LOOKUPS ) )
            {
                ByteString aScriptName( SETUP_INSTDB_FILE );
                SiDirEntry aOldScript( aInstalledPath );
                aOldScript += ByteString("program");
                aOldScript += aScriptName;

                while( !aOldScript.Exists() && (aOldScript.Level() > 2) )
                {
                    aOldScript  = aOldScript[2];
                    aOldScript += aScriptName;
                }

                if ( !aOldScript.Exists() )
                    Critical_Error( ERR_INSTALLINFOMISSING, "" );

                delete m_pOldCompiledScript;
                m_pOldCompiledScript = new SiCompiledScript;
                ReadScript( aOldScript, m_pOldCompiledScript );

                if ( m_pOldCompiledScript->GetInstallation() )
                {
                    m_pEnv->SetSingleProductName( m_pOldCompiledScript->GetInstallation()->GetProductName() );
                    m_pEnv->SetProductVersion( m_pOldCompiledScript->GetInstallation()->GetProductVersion() );
                }
                else
                    Critical_Error( ERR_INSTALLINFOMISSING, "" );

				if( m_pOldCompiledScript->GetInstallation()->GetPatchLevel() &&
					m_pOldCompiledScript->GetInstallation()->GetPatchLevel() >= m_pCompiledScript->GetInstallation()->GetPatchLevel() )
				{
					ResId aResId(STR_PATCH_ALREADY_INSTALLED);
					if( m_pSecondResMgr )
					{
						ResId aResId2(STR_PATCH_ALREADY_INSTALLED, m_pSecondResMgr);
						aResId2.SetRT(RSC_STRING);
						if( aResId2.GetResMgr()->IsAvailable(aResId2) )
							aResId.SetResMgr( m_pSecondResMgr );
					}
					UniString anError( aResId );

					// Set Window title
					String aTitle;
					aTitle += String( m_pEnv->GetProductName(), osl_getThreadTextEncoding() );
				    aTitle += ' ';

					{
						ResId aResId( STR_DLG_TITLE_PATCH );
						if( m_pSecondResMgr )
						{
							ResId aResId2(STR_DLG_TITLE_PATCH, m_pSecondResMgr);
							aResId2.SetRT(RSC_STRING);
							if( aResId2.GetResMgr()->IsAvailable(aResId2) )
								aResId.SetResMgr( m_pSecondResMgr );
						}
						aTitle += String( aResId );
					}
					
                    if( !IsResponseMode() )
                    {
                        ErrorBox aBox( NULL, WB_OK, anError );
                        aBox.SetText( aTitle );
                        aBox.Execute();
#ifdef UNX
                        _exit(0);
#endif
                        Quit();
                    }
                    else
                        Critical_Error( ERR_VERSIONALLREADYINSTALLED, ByteString(anError, osl_getThreadTextEncoding()) );
				}

				// We are only patching the network part of a office installation, but we use
                // the sverion.ini ( and therefor the workstation installation ) to find the
                // location.
                SiInstallMode eInstallMode = m_pOldCompiledScript->GetInstallation()->GetInstallMode();

                if ( eInstallMode == IM_STANDALONE )
                {
                    m_pEnv->SetLocal( TRUE );
                    aInstalledPath = m_pOldCompiledScript->GetInstallation()->GetDestPath();
                    bPathFound = TRUE;
                }
                else
                {
                    m_pEnv->SetLocal( FALSE );

                    if ( eInstallMode == IM_NETWORK )
                    {
                        aInstalledPath = m_pOldCompiledScript->GetInstallation()->GetDestPath();
                        bPathFound = TRUE;
                    }
                    else
                    {
                        aInstalledPath = m_pOldCompiledScript->GetInstallation()->GetSourcePath();
                        // Quick hack for remembering the path to the workstation installation
                        // (needed for #99441# test for running office )
                        m_pEnv->SetLicenseKey( m_pOldCompiledScript->GetInstallation()->GetDestPath() );
                    }
                }
            }

            if ( nLookups >= MAX_LOOKUPS )
                Critical_Error( ERR_INSTALLINFOMISSING, "" );

            m_pEnv->SetInstalledPath	( aInstalledPath );
			m_pEnv->SetDestPath			( aInstalledPath );
			m_pEnv->SetProductName      ( m_pEnv->GetSingleProductName(),
                                          m_pEnv->GetProductVersion() );
		}
		else
		{
            ByteString aRelativPath = m_pCompiledScript->GetInstallation()->GetDefaultDestPath();

            if ( m_aParamDestPath.Len() != 0 )
                m_pEnv->SetDestPath( m_aParamDestPath );
            else
                m_pEnv->SetDestPath( m_pEnv->GetDefaultDestPath( bWorkstation, aRelativPath ) );
		}
	}
	else
	{
		DBG_ASSERT(m_pEnv->GetDestPath().Len() != 0, "kein Zielpfad");
	}

	if( m_pCompiledScript && !m_pCompiledScript->GetInstallInfo() )
	{
		if( !IsResponseMode() )
		{
			ErrorBox aBox(NULL, WB_OK, UniString::CreateFromAscii("INSTALL_INFO\nis missing!") );
			aBox.Execute();
		}
		else
			Critical_Error( ERR_INSTALLINFOMISSING, "" );
		return FALSE;
	}

	// Installation FollowApp
	if( m_pCompiledScript->GetInstallation()->GetFollowApp().Len() &&
		m_pEnv->IsFirstInstallation() && m_pEnv->IsLocal() )
	{
		SiDirEntry aEntry( m_pCompiledScript->GetInstallation()->GetFollowApp() );
		if( !aEntry.Exists() )
		{
			aEntry = m_pEnv->GetSourcePath();
			aEntry += m_pCompiledScript->GetInstallation()->GetFollowApp();
		}
		if( aEntry.Exists() )
		{
			aEntry.ToAbs();
			ByteString* pNew = new ByteString( aEntry.GetFull() );
			
            // check if we need to quote the string
            if ( pNew->Search( ' ' ) != STRING_NOTFOUND )
            {
                pNew->Insert( '\'', 0 );
                pNew->Insert( '\'' );
            }
            m_pEnv->AddFollowAppList( pNew );
		}
	}

	// Languages
	SiInstallation* pInst;
	if( m_pEnv->GetInstallMode() == IM_PATCH )
		pInst = m_pOldCompiledScript->GetInstallation();
	else
		pInst = m_pCompiledScript->GetInstallation();

	ByteString aLanguages( pInst->GetLanguages() );

	USHORT nDelimTok = 0;
	USHORT nTokCount = aLanguages.GetTokenCount(',');

	for( USHORT x = 0; x < nTokCount; ++x )
    {
        BOOL    bInst;
        BOOL    bProg = FALSE;
        BOOL    bDoc  = FALSE;
        USHORT  nLang = (USHORT) aLanguages.GetToken(0, ',', nDelimTok).ToInt32();

        LanguageContext* pNew = new LanguageContext;

        bInst = pInst->IsLanguageInstalled( nLang, bProg, bDoc );

        pNew->nLanguage = nLang;

        if ( m_pEnv && m_pEnv->IsLocal() )
        {
            if ( HadParamLanguage() && ( nLang == GetLanguage() ) )
            {
                pNew->isProg	= TRUE;
                pNew->isDoc		= TRUE;
            }
            else
            {
                pNew->isProg	= FALSE;
                pNew->isDoc		= FALSE;
            }
        }
        else
        {
            pNew->isProg	= bProg;
            pNew->isDoc		= bDoc;
        }

        // when performing a workstation installation from a network installation
        // we have to add only those languages, which are installed. Otherwise we
        // have to add the language anyway
        if ( m_pEnv && m_pEnv->InstallFromNet() && m_pEnv->IsLocal() )
        {
            if ( bInst )
                m_pEnv->AddUILanguageContext( pNew );
            else
                delete pNew;
        }
        else
            m_pEnv->AddUILanguageContext( pNew );
    }

	// Execute PreSelectProcedure
	if( m_pEnv->IsFirstInstallation() )
	{
		SiProcedure* pProc = (SiProcedure*)m_pCompiledScript->FindPreSelectProc();
		if( pProc )
		{
			SiBasic aBasic( *m_pCompiledScript, *m_pEnv );
        	if ( m_pEnv->HasVCL() )
            {
                NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
                aBasic.Call( pProc->GetProcName(), pProc->GetCode() );
            }
            else
                aBasic.Call( pProc->GetProcName(), pProc->GetCode() );
		}
	}

#ifdef WNT
	// Adabas check.
	if ( m_pEnv->IsFirstInstallation() && setup::isAdabas(pInst) )
	{
		ByteString aRelativPath = m_pCompiledScript->GetInstallation()->GetDefaultDestPath();
		ByteString aStr(WinOS::SHGetUserProgramFilesFolder(), osl_getThreadTextEncoding());
		aRelativPath.SearchAndReplace("<winprogpath>", aStr );
		if ( m_pEnv->GetDestPath() == aRelativPath )
		{
			if (aStr.Len() >= 2)
			{
				aStr = aStr.Copy(0,2);
			}
			else
			{
				// Fallback
				aStr = "C:";
			}
			aRelativPath = m_pCompiledScript->GetInstallation()->GetDefaultDestPath();
			aRelativPath.SearchAndReplace("<winprogpath>", aStr );
			m_pEnv->SetDestPath(aRelativPath);
		}
	}
#endif
	
	return TRUE;
}

BOOL SetupApp::ReadScript(SiDirEntry const& aScript)
{
	// eventuell vorhandenes Script loeschen
	if (m_pCompiledScript != NULL)
		delete m_pCompiledScript;
	m_pCompiledScript = new SiCompiledScript;

	SetupInfoDialog* pInfDlg = NULL;
	if( !IsResponseMode() )
	{
		pInfDlg = new SetupInfoDialog( m_pMainWin->GetContWin() );
		pInfDlg->Show();
		pInfDlg->Update(); // sonst ist event. der Dialog nicht zu sehen
	}

	BOOL bSuccess = ReadScript( aScript, m_pCompiledScript );

	if( bSuccess )
	{
		SiModule *pModule = m_pCompiledScript->GetRootModule();
		if( pModule == NULL )
			bSuccess = FALSE; // nicht mal ein Modul!
	}

	if( !IsResponseMode() )
	{
		pInfDlg->Hide();
		delete pInfDlg;
	}
	return bSuccess;
}

BOOL SetupApp::ReadScript(SiDirEntry const& aScript, SiCompiledScript *pCS)
{
	// #97704#
	OReadScriptModeGuard aGuard(m_bReadScriptMode);

	SiAnsiFileStream aStream;

	aStream.Open( aScript.GetFullUni(), STREAM_READ );

	if( !aStream.IsOpen() )
		if( aScript.GetName().CompareIgnoreCaseToAscii("instdb.inf") == COMPARE_EQUAL )
		{	// wir suchten nach einer installierten Version!
			// Probieren wir es noch einmal mit dem 'alten' Scriptnamen
			SiDirEntry aOldScript = aScript;
			aOldScript.SetName(UniString::CreateFromAscii("setup.inf"));
			aStream.Open( aOldScript.GetFullUni(), STREAM_READ );
			if( !aStream.IsOpen() )
				return FALSE;
		}

	SiCompilerRef xCompiler = new SiCompiler( aStream, OS::GetType() );

	if ( m_bNoVcl )
        xCompiler->NoVCL();

    char aFirstChar;
	aStream >> aFirstChar;
	aStream.Seek(0);

	if( aFirstChar == '[' )
	{
		if( !IsResponseMode() )
		{
			InfoBox aBox(NULL, UniString::CreateFromAscii("Alte Scripts werden nicht mehr unterstuetzt!"));
			aBox.Execute();
		}
		else
			Critical_Error( ERR_OLDSCRIPTVERSION, "" );
		return FALSE;
	}
	else
		return xCompiler->CompileTo( pCS );
}

void SetupApp::PrepareLanguageContext()
{
	SiLangCtxList& rUILst = m_pEnv->GetUILanguageContext();
	SiInstallation* pInst = m_pCompiledScript->GetInstallation();
	USHORT nDefLang = (USHORT) pInst->GetDefLanguage().ToInt32();

	for( USHORT i = 0; i < rUILst.Count(); ++i )
	{
		LanguageContext* pAct = rUILst.GetObject(i);

		BOOL isprog = FALSE;
		BOOL isdoc  = FALSE;
		BOOL isInst = FALSE;
        
        if ( ! m_pEnv->InstallFromNet() )
            isInst = pInst->IsLanguageInstalled( pAct->nLanguage, isprog, isdoc );

		if( !isInst && !pAct->isProg && !pAct->isDoc )
			// war noch nie installiert und soll auch nicht;
			// also weiter
			continue;

		LanguageContext* pCtx = new LanguageContext;
		pCtx->nLanguage	= pAct->nLanguage == nDefLang? LANG_DEFAULT : pAct->nLanguage;
		pCtx->isProg   	= pAct->isProg;
		pCtx->isDoc		= pAct->isDoc;

		m_pEnv->AddLanguageContext( pCtx );
	}

	// bei einem event. Languagewechsel mssen die Switch Ctx'e fuer
	// die Agenda aufgebaut werden.
	if( m_pEnv->GetInstallType() == IT_CHANGE )
	{
		ByteString aInstLanguages = pInst->GetLanguages();
		USHORT nDelimTok = 0;
		USHORT nTokCount = aInstLanguages.GetTokenCount(',');

		for( USHORT x = 0; x < nTokCount; ++x )
		{
			USHORT nLang = (USHORT) aInstLanguages.GetToken(0, ',', nDelimTok).ToInt32();
			LanguageContext* pUICtx = NULL;

			for( USHORT xx = 0; xx < rUILst.Count(); ++xx )
			{
				pUICtx = rUILst.GetObject(xx);
				if( pUICtx->nLanguage == nLang )
					break;
			}
			if( !pUICtx ) continue;

			BOOL isprog = FALSE;
			BOOL isdoc  = FALSE;
			BOOL isInst = pInst->IsLanguageInstalled(pUICtx->nLanguage, isprog, isdoc);

			if( isprog != pUICtx->isProg )
			{
				LanguageContext* pSwitch = new LanguageContext;
				pSwitch->nLanguage	= nLang;
				pSwitch->isProg		= TRUE;
				pSwitch->isDoc		= FALSE;

				if( pUICtx->isProg )
					m_pEnv->AddSwitchContextInstall(pSwitch);
				else
					m_pEnv->AddSwitchContextDelete(pSwitch);
			}
			if( isdoc != pUICtx->isDoc )
			{
				LanguageContext* pSwitch = new LanguageContext;
				pSwitch->nLanguage	= nLang;
				pSwitch->isProg		= FALSE;
				pSwitch->isDoc		= TRUE;
				if( pUICtx->isDoc )
					m_pEnv->AddSwitchContextInstall(pSwitch);
				else
					m_pEnv->AddSwitchContextDelete(pSwitch);
			}
		}
	}

	pInst->SetInstalledLanguages( m_pEnv );
}

ByteString SetupApp::GetValue(SiProfileItem const* pItem, ByteString const& aDefault) const
{
	SiDirEntry anIniPath  = pItem->GetProfile()->GetDirectory()->GetName();
			 anIniPath += pItem->GetProfile()->GetName();
	Config   anIni(anIniPath.GetFullUni());

	anIni.SetGroup(pItem->GetSection());

	return anIni.ReadKey(pItem->GetKey(),aDefault);
}

// -----------------------------------------------------------------------

void SetupApp::SetAccelerators()
{
#ifdef MAC
	m_pExitAccel = new Accelerator;
	m_pExitAccel->InsertItem( 1, KeyCode( KEY_ESCAPE ) );
	m_pExitAccel->InsertItem( 2, KeyCode( KEY_POINT, KEY_MOD1 ) );
	m_pExitAccel->PushSelectHdl( LINK( this, SetupApp, ExitHdl ) );
	InsertAccel(m_pExitAccel, ACCEL_STANDARD );
#else
	m_pExitAccel = new Accelerator;
	#if !defined(UNX) && !defined(OS2)
	m_pExitAccel->InsertItem( 1, KeyCode(KEY_I, KEY_SHIFT | KEY_MOD1) );
	#endif
	m_pExitAccel->SetSelectHdl( LINK( this, SetupApp, ExitHdl ) );
	InsertAccel( m_pExitAccel );
#endif
}

// -----------------------------------------------------------------------

#ifdef MAC
void SetupApp::AppEvent(ApplicationEvent const& rAppEvent)
{
}
#endif

// -----------------------------------------------------------------------

IMPL_LINK( SetupApp, WindowHideHdl, void*, pFoo )
{
	if( pFoo )
		m_pMainWin->Hide();
	else
	{
		m_pMainWin->Show();
		m_pMainWin->GrabFocus();
	}
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SetupApp, ExitHdl, Accelerator*, pAccel )
{
	if( m_pExitAccel == pAccel )
	{
		if( m_pMainWin->IsFullScreenMode() )
			m_pMainWin->EndFullScreenMode();
		else
			m_pMainWin->ShowFullScreenMode();
		return 0;
	}

	if (m_bPerformInstall)
	{
		m_bInterrupt = TRUE;

		if( QueryBox( GetAppWindow(), ResId( DLG_QUERYEXITBOX ) ).Execute() ==
			RET_YES )
		{
			m_bPerformInstall = FALSE;
			if( m_pAgenda != NULL )
				m_pAgenda->StopRunning();
		}
		m_bInterrupt = FALSE;
	}
	else
		PostUserEvent(EVT_END);

	return 0;
}

// -----------------------------------------------------------------------

#ifdef MAC

IMPL_LINK( SetupApp, ExitMenuHdl, Menu *, pMenu )
{
	if ( pMenu->GetCurItemId() == MN_ABOUT )
		InfoBox( GetAppWindow(), ByteString( ResId( STR_ABOUT ) ) ).Execute();

	if ( pMenu->GetCurItemId() == MN_QUIT )
	{
		ExitHdl(NULL);
	}
	return 0;
}

#endif

// -----------------------------------------------------------------------

void SetupApp::MainWindowResize()
{}

// -----------------------------------------------------------------------

void SetupApp::ShowScriptNotFound()
{
	m_pMainDlg = new SetupAgentDialog( GetAppWindow(), m_pResMan, this );

	m_pMainDlg->CreateModel_ScriptNotFound();
	m_pMainDlg->StartAgentDlg();
	m_pMainDlg->Show();

	m_pMainDlg->DoModal();

	delete m_pMainDlg;
	m_pMainDlg = NULL;
}

// -----------------------------------------------------------------------

void SetupApp::PostUserEvent( ULONG nEvent )
{
    if ( m_bNoVcl )
    {
    	MutexGuard aGuard( &m_aMutex );

        if ( m_pFirstEvent )
        {
            SetupEventData* pEvent = m_pFirstEvent;
            while ( pEvent->m_pNext )
                pEvent = pEvent->m_pNext;
            pEvent->m_pNext = new SetupEventData( nEvent );
        }
        else
            m_pFirstEvent = new SetupEventData( nEvent );
    }
    else
        Application::PostUserEvent( nEvent );
}

// -----------------------------------------------------------------------

void SetupApp::HandleUserEvents()
{
    while ( m_pFirstEvent )
    {
    	MutexGuard aGuard( &m_aMutex );
        SetupEventData* pData = m_pFirstEvent;
        m_pFirstEvent = pData->m_pNext;
        UserEvent( pData->m_nEvent, NULL );
        delete pData;
    }
}

// -----------------------------------------------------------------------
BOOL SetupApp::GetValue( const ByteString& rLine,
                         const ByteString& rKey,
                         ByteString& rValue )
{
    xub_StrLen nKeyPos = rLine.Search( rKey, 0 );
    
    if ( nKeyPos == STRING_NOTFOUND )
        return FALSE;

    xub_StrLen nEQPos = rLine.Search( '=', 0 );
    
    if ( ( nEQPos == STRING_NOTFOUND ) ||
         ( nEQPos <= nKeyPos ) )
        return FALSE;

    ByteString aValue = rLine.Copy( nEQPos+1 );
    aValue.EraseLeadingAndTrailingChars( ' ' );
    aValue.EraseTrailingChars( ';' );
    aValue.EraseLeadingAndTrailingChars( '\"' );

    rValue = aValue;
    return TRUE;
}

// -----------------------------------------------------------------------
// This function just reads the first few lines of the setup script
// and sets some variables in the setup environment
//
void SetupApp::SimpleFindAndReadScript()
{
	ByteString aScriptName( SETUP_INSTDB_FILE );
	SiDirEntry aScript (m_pEnv->GetStartPath());
	aScript += aScriptName;

	while( (!aScript.Exists()) && (aScript.Level() > 2) )
	{
		aScript = aScript[2];
		aScript += aScriptName;
	}

	if( ! aScript.Exists() )
	{
		if( m_pEnv->IsBigMode() )
		{
			ArchDirectory* pArch = new ArchDirectory;
			SiDirEntry aEntry( m_SetupIniSourcePath );

            if( !pArch->SetArchFile(aEntry.GetFull().GetBuffer()) )
				return;
			else
				m_pEnv->SetArchive( pArch, FindArch );

			ByteString aScrt(SETUP_SCRIPT_FILE);
			pArch->GetFile( aScrt.GetBuffer(), m_pEnv->GetStartPath().GetBuffer() );
		}

		aScript  = m_pEnv->GetStartPath();
		aScript += ByteString(SETUP_SCRIPT_FILE);

		if (!aScript.Exists())
		{
			aScript	 = m_SetupIniSourcePath;
			aScript += ByteString(SETUP_SCRIPT_FILE);

			if( !aScript.Exists() )
                return;
		}
	}

	ByteString aLine, aValue;
    SiAnsiFileStream aStream;

    aStream.Open( aScript.GetFullUni(), STREAM_READ );
    aStream.ReadLine( aLine );

    if ( !aLine.Len() || !aLine.EqualsIgnoreCaseAscii( "Installation", 0, strlen("Installation") ) )
        return;

    for ( int i=0; i<20; i++ )
    {
        if ( ! aStream.ReadLine( aLine ) )
            break;

        if ( GetValue( aLine, "ProductName", aValue ) )
            m_pEnv->SetSingleProductName( aValue );
        else if ( GetValue( aLine, "ProductVersion", aValue ) )
            m_pEnv->SetProductVersion( aValue );
        else if ( GetValue( aLine, "Mode", aValue ) )
        {
            if ( aValue.EqualsIgnoreCaseAscii( "PATCH" ) )
            {
                m_pEnv->SetInstallMode( IM_PATCH );
                
                // get Product Patch Brand Name from resources
                if( m_pSecondResMgr )
                {
                    ResId aResId( STR_PRODUCTPATCH );
                    ResId aResId2( STR_PRODUCTPATCH, m_pSecondResMgr );

                    aResId2.SetRT( RSC_STRING );

                    if( aResId2.GetResMgr()->IsAvailable( aResId2 ) )
                        aResId.SetResMgr( m_pSecondResMgr );

                    SetProductPatchName( String( aResId ) );
                }
            }
        }
        else if ( aLine.EqualsIgnoreCaseAscii( "end" ) )
            break;
    }

    aValue = m_pEnv->GetSingleProductName();

    if ( aValue.Len() )
        m_pEnv->SetProductName( aValue, m_pEnv->GetProductVersion() );
}



// -----------------------------------------------------------------------
void SetupApp::ShowUsage( SetupParameter eCommand )
{
    static const USHORT aParamList[] =
    {
        STR_PAR_HELP,
        STR_PAR_NET,
        STR_PAR_REPAIR,
        STR_PAR_REINST,
        STR_PAR_DEINST,
        STR_PAR_RSPFILE,
        STR_PAR_DESTDIR,
        STR_PAR_PATCH,
        STR_PAR_CRC,
        STR_PAR_VERBOSE,
        STR_PAR_DEBUG,
        STR_PAR_NOEXIT
    }; 
    
    if( IsResponseMode() )
        Critical_Error( ERR_WRONGPARAMETER, "" );

    SimpleFindAndReadScript();

    UniString aHelpText( ResId( eCommand == PAR_SHOW_USAGE ? ERR_SHOW_USAGE : ERR_SHOW_HELP ) );

    if ( eCommand == PAR_SHOW_HELP )
    {
        BOOL    bPatchMode = ( m_pEnv->GetInstallMode() == IM_PATCH );
        USHORT  nMaxLen = 0;

        aHelpText += UniString::CreateFromAscii( "\n\n" );

        for ( int i=0; i<sizeof(aParamList)/sizeof(aParamList[0]); i++ )
        {
            // only show the description of the parameter -patch if the
            // setup is in patch mode
            if ( !bPatchMode && ( aParamList[i] == STR_PAR_PATCH ) )
                continue;

            UniString aParam = UniString( ResId( aParamList[i] ) );
            if ( aParam.Len() > nMaxLen )
                nMaxLen = aParam.Len();
        }

        nMaxLen += 2;

        for ( int j=0; j < sizeof(aParamList)/sizeof(aParamList[0]); j++ )
        {
            // only show the description of the parameter -patch if the
            // setup is in patch mode
            if ( !bPatchMode && ( aParamList[j] == STR_PAR_PATCH ) )
                continue;

            UniString aParam = UniString( ResId( aParamList[j] ) );
            
            aParam.Expand( nMaxLen );
            aParam += UniString( ResId( aParamList[j]+1 ) );
            aParam += '\n';
            aHelpText += aParam;
        }
    }

#ifdef UNX
    ByteString aText = ByteString( aHelpText, osl_getThreadTextEncoding() );
    fprintf( stdout, "%s\n", aText.GetBuffer() );
#else
    BOOL bAuto = IsAutoMnemonicEnabled();
    EnableAutoMnemonic( FALSE );

    ShowUsageDlg aBox( NULL, m_pResMan );
    
    Font aMono( String::CreateFromAscii( "Courier" ), Size( 0, 8 ) );
    Wallpaper aBack = aBox.GetBackground();

    aBox.aMessage.SetControlBackground( aBack.GetColor() );
    aBox.aMessage.SetControlFont( aMono );
    aBox.SetText( aHelpText );

    aBox.Execute();

    EnableAutoMnemonic( bAuto );
#endif
}

// -----------------------------------------------------------------------

// Forward declaration
void Main();

// -----------------------------------------------------------------------

SAL_IMPLEMENT_MAIN()
{
    aSetupApp.Main();

	#ifdef UNX
	_exit(0);
	#endif

    return 0;
}

#define BUF_SIZE 4096
static sal_Bool hasJavarc();
void prepareJava(const char * szStartPath)
{
    if(szStartPath)
    {
        //check if we are started from an installation. This is done by looking for the classes
        //directory. We do not use  m_pEnv->IsFirstInstallation() because it is not working at the time
        //prepareJava is called.
        char szDelim[]={SAL_PATHDELIMITER,0};                
        OUString usStartPath= OStringToOUString(szStartPath, osl_getThreadTextEncoding());
        usStartPath= usStartPath + OUString(RTL_CONSTASCII_USTRINGPARAM(szDelim))
            + OUString(RTL_CONSTASCII_USTRINGPARAM("classes"));
        
        //check if there is a javarc, if so then we are in an office installation
        if(! hasJavarc())
        {
            // We set three environment variables at this point which are inherited
            // by the setup process that is created further on. They are necessary for
            // using Java in the  setup
            //Set OO_JAVA_PROPERTIES environment variable. It contains the RuntimLib
            // entry as it appears in the java.ini. It is used by the JavaVirtualMachine service
            // to find the jvm.dll
            char envVarBuf[BUF_SIZE];
            envVarBuf[0]= 0;
            char * szEnvJavaProps= NULL;
            char * arJars[]= {JAVA_JAR_FILES};
            short nJars= sizeof (arJars) / sizeof(char *);
            char * szEnvClasspath= NULL;
            char * szEnvComppath= NULL;
            int i= 0;

            rtl::OString aJavaLib;
                
            rtl::OUString aLib;
            jvmaccess::JavaInfo* pInfo = NULL;

            try
            {
                //try getting a java with accessibility
                jvmaccess::JavaInfo _info(OUString(
                                              RTL_CONSTASCII_USTRINGPARAM("1.4.1_01")),
                                          jvmaccess::JavaInfo::EqualVersion |
                                          jvmaccess::JavaInfo::GreaterVersion |
                                          jvmaccess::JavaInfo::Accessibility);
                pInfo = new jvmaccess::JavaInfo(_info);
            }
            catch(jvmaccess::JavaInfo::InitException &)
            {
                //try getting a java without accessibility
                try
                {
                    jvmaccess::JavaInfo _info(OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM("1.4.1_01")),
                                              jvmaccess::JavaInfo::EqualVersion |
                                              jvmaccess::JavaInfo::GreaterVersion);
                    pInfo = new jvmaccess::JavaInfo(_info);
                }
                catch (jvmaccess::JavaInfo::InitException&)
                {
                    //no adequate Java found
                    return;
                }
            }
            if (osl::FileBase::getSystemPathFromFileURL(
                    pInfo->getRuntimeLibLocation(),
                    aLib)
                == osl::FileBase::E_None)
                aLib.convertToString(&aJavaLib, osl_getThreadTextEncoding(),
                                     RTL_UNICODETOTEXT_FLAGS_UNDEFINED_ERROR
                                     | RTL_UNICODETOTEXT_FLAGS_INVALID_ERROR);
            delete pInfo;
            
            if (aJavaLib.getLength() != 0)
            {
                strncpy(envVarBuf,"OO_JAVA_PROPERTIES=RuntimeLib=", BUF_SIZE - 1);
                size_t len = sizeof("OO_JAVA_PROPERTIES=RuntimeLib=");
                //make sure the buffer is large enough
                if(sizeof(envVarBuf) > (len + aJavaLib.getLength()))
                {
                    strncat( envVarBuf, aJavaLib.getStr(), sizeof(envVarBuf) - len);
                    szEnvJavaProps= (char *) malloc( strlen( envVarBuf) + 1); // must leak
                    strncpy( szEnvJavaProps, envVarBuf, strlen( envVarBuf) + 1 );
                    putenv( szEnvJavaProps);
                }
                else
                    OSL_ASSERT(0);
            }
            
            OString sJarDir;
            char szSep[]={SAL_PATHSEPARATOR,0};

            sJarDir= OString(szStartPath);
                
            strncpy( envVarBuf, "CLASSPATH=", BUF_SIZE - 1 );
            envVarBuf[ BUF_SIZE - 1 ] = '\0';
                
            size_t lenBegin= sizeof("CLASSPATH=") - 1;
            size_t lenDel= sizeof(szDelim);
            size_t lenSep= sizeof(szSep);
            size_t lenStartPath= sJarDir.getLength();
            
            size_t lenCur = lenBegin; // count without terminating null
            size_t lenFree = sizeof( envVarBuf ) - lenBegin - 1;
            for( i= 0; i < nJars; i++)
            {
                lenCur += lenStartPath + lenDel + strlen(arJars[i]) + lenSep;
                if( sizeof(envVarBuf) > lenCur)
                {
                    strncat( envVarBuf, sJarDir.getStr(), lenFree );
                    lenFree -= lenStartPath;
                    strncat( envVarBuf, szDelim, lenFree );
                    lenFree -= lenDel;
                    strncat( envVarBuf, arJars[i], lenFree );
                    lenFree -= strlen( arJars[i] );
                    strncat( envVarBuf, szSep, lenFree );
                    lenFree -= lenSep;
                }
                else
                    OSL_ASSERT(0); //buffer envVarBuf is too small
            }
            szEnvClasspath= (char *) malloc( strlen( envVarBuf) + 1); // must leak
            strncpy( szEnvClasspath, envVarBuf, strlen( envVarBuf) + 1 );
            putenv( szEnvClasspath );

            strncpy( envVarBuf, "UNO_JAVA_COMPPATH=", BUF_SIZE - 1 );
            envVarBuf[ BUF_SIZE - 1 ] = '\0';
            strncat( envVarBuf, "$SYSBINDIR", BUF_SIZE - 1 - strlen( envVarBuf ) );
            szEnvComppath= (char *) malloc( strlen( envVarBuf) + 1 ); // must leak
            strncpy( szEnvComppath, envVarBuf, strlen( envVarBuf) + 1 );
            putenv( szEnvComppath);
            
#ifdef WNT
            putenv("SAL_ACCESSIBILITY_ENABLED=1");
#endif            
         }
    }
}    

static sal_Bool hasJavarc()
{
    sal_Bool  retVal= sal_True;
	OUString value;

	// try user config
	rtl::Bootstrap::get(OUString(RTL_CONSTASCII_USTRINGPARAM("JavaLibPath")), 
				   value, 
				   OUString(RTL_CONSTASCII_USTRINGPARAM("${${$SYSBINDIR/bootstraprc:UserInstallation}/user/config/javarc:Java:JavaLibPath}")));

	// fall back to share config
	if(!value.getLength())
		rtl::Bootstrap::get(OUString(RTL_CONSTASCII_USTRINGPARAM("JavaLibPath")), 
					   value, 
					   OUString(RTL_CONSTASCII_USTRINGPARAM("${${$SYSBINDIR/bootstraprc:UserInstallation}/share/config/javarc:Java:JavaLibPath}")));

    if(!value.getLength())
    {
        rtl::Bootstrap::get(OUString(RTL_CONSTASCII_USTRINGPARAM("JavaLibPath")),
                       value,
                       OUString(RTL_CONSTASCII_USTRINGPARAM("${${$SYSBINDIR/bootstraprc:BaseInstallation}/share/config/javarc:Java:JavaLibPath}")));
    }
    if(value.getLength())
        retVal= sal_True;
	else
        retVal= sal_False;
    return retVal;
}

// -----------------------------------------------------------------------

ShowUsageDlg::ShowUsageDlg( Window *pParent, ResMgr* pResMgr )
    : ModalDialog ( pParent, ResId( RID_SHOW_USAGE_DLG, pResMgr )),
      aButton     ( this,    ResId( RID_BTN_OK, pResMgr ) ),
      aTitle      ( this,    ResId( RID_FT_MESSAGE, pResMgr ) ),
      aMessage    ( this,    ResId( RID_ME_MESSAGE, pResMgr ) )
{
    FreeResource();
}
