/*************************************************************************
 *
 *  $RCSfile: mainevt.cxx,v $
 *
 *  $Revision: 1.83 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/21 11:02:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef UNX
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>
#endif

#include <time.h>
#include <stdio.h>
#include <ctype.h>

#if defined(ICC) && defined(OS2)
#include <tools/svpm.h>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _VOS_PROCESS_HXX //autogen
#include <vos/process.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#ifndef _WLDCRD_HXX //autogen
#include <tools/wldcrd.hxx>
#endif

#include "main.hxx"
#include "mainwnd.hxx"
#include "maindlg.hxx"
#include "critical.hxx"
#include "fields.hxx"
#include "texec.hxx"
#include "action.hxx"

#include "zipfile.hxx"
#include "sihelp.hxx"
#include "environ.hxx"
#include "agenda.hxx"
#include "compiler.hxx"
#include "script.hxx"
#include "instdb.hxx"
#include "magenda.hxx"
#include "sibasic.hxx"
#include "respfile.hxx"

#include "arch.hxx"
#include "os.hxx"

#include "infodlg.hxx"
#include "insrtdsk.hxx"

#include "strings.hrc"
#include "app.hrc"
#include "error.hrc"

#include "OfficeRunningCheck.hxx"

#include <memory> /* auto_ptr */
#include <osl/file.hxx>

#define AUTO_UPDATE_SAME_VERSION		1

static BOOL        IsUpdateAdabas( const ByteString& rStartPath );
static ByteString  GetAdabasDir();

DECLARE_HASHTABLE_ITERATOR(DeclaratorSetIt,SiDeclarator*)

// ----------------------------------------------------------------------------
namespace setup
{
   void ChangeDirectory(UniString const& _aFilename)
   {

      SiDirEntry aFilename( _aFilename );
      SiDirEntry aPath( aFilename.GetPath() );
      // UniString suPathAsStr = aPath.GetFullUni();
      // ByteString sPathAsStr(suPathAsStr, osl_getThreadTextEncoding());
      aPath.SetCWD();
      // _wchdir(suPathAsStr.GetBuffer());
   }
}

// ----------------------------------------------------------------------------
USHORT _CountParams( const UniString& rParams )
{
    xub_StrLen nLen = rParams.Len();
    xub_StrLen nPos = 0;
    USHORT nCount = 0;
    BOOL   bInQuote = FALSE;
    BOOL   bInWhite = TRUE;

    while ( nPos < nLen )
    {
        sal_Unicode nChar = rParams.GetChar( nPos );

        if ( nChar == '\'' )
            bInQuote = ! bInQuote;
        else if ( nChar == ' ' )
        {
            if ( ! bInQuote )
                bInWhite = TRUE;
        }
        else if ( bInWhite )
        {
            bInWhite = FALSE;
            nCount += 1;
        }
        nPos += 1;
    }
    return nCount;
}

// ----------------------------------------------------------------------------
UniString _GetParam( const UniString& rParams, USHORT nIndex )
{
    UniString  aRet;
    
    xub_StrLen nLen = rParams.Len();
    xub_StrLen nPos = 0;
    xub_StrLen nStart = 0;

    USHORT nCount = 0;
    BOOL   bInQuote = FALSE;
    BOOL   bInWhite = TRUE;
    BOOL   bInParam = FALSE;

    if ( !nLen )
        return aRet;

    while ( nPos < nLen )
    {
        sal_Unicode nChar = rParams.GetChar( nPos );

        if ( nChar == '\'' )
        {
            bInQuote = ! bInQuote;
            if ( bInParam )
                break;
        }
        else if ( nChar == ' ' )
        {
            if ( ! bInQuote )
            {
                bInWhite = TRUE;
                if ( bInParam )
                    break;
            }
        }
        else if ( bInWhite )
        {
            if ( nIndex == nCount )
            {
                nStart = nPos;
                bInParam = TRUE;
            }
            bInWhite = FALSE;
            nCount += 1;
        }
        nPos += 1;
    }
    
    aRet = rParams.Copy( nStart, nPos-nStart );
    return aRet;
}

void _StartApplication( UniString& rApp, UniString& rParam )
{
	USHORT nOptions = NAMESPACE_VOS(OProcess)::TOption_SearchPath;

	NAMESPACE_VOS(OProcess)::TProcessOption eOptions =
							(NAMESPACE_VOS(OProcess)::TProcessOption)nOptions;

	rtl::OUString aApplication;
	FileBase::getFileURLFromSystemPath( rApp, aApplication );

    if( rParam.Len() )
	{
    	::rtl::OUString* pArgs = NULL;
		USHORT n = _CountParams( rParam );

        pArgs = new ::rtl::OUString[ n ];
        
        for ( USHORT i=0; i<n; i++ )
            pArgs[i] = OUString( _GetParam( rParam, i ) );

		NAMESPACE_VOS(OArgumentList) aArgs( pArgs, n );
		NAMESPACE_VOS( OProcess ) aProcess( aApplication );
		aProcess.execute( eOptions, aArgs );

		delete[] pArgs;
	}
	else
	{
		NAMESPACE_VOS( OProcess ) aProcess( aApplication );
		aProcess.execute( eOptions );
	}
}

// ----------------------------------------------------------------------------

void SetupApp::UserEvent( ULONG nEvent, void* pEventData)
{
	static BOOL bEnd = FALSE;

	if (bEnd)
		return;

	BOOL bInExec        = IsInExecute();
    BOOL bInShutdown    = IsShutDown();

    if ( ( !bInExec || bInShutdown ) && !m_bNoVcl )
    {
        DBG_ERRORFILE( "Can't process event while quiting application" );
        return;
    }

	// HACK, #97704# to suppress problems with readscript, if MainDialog is allready open
	if (m_bReadScriptMode)
	{
		// do nothing!
		return;
	}

	if( m_pMainDlg && nEvent != EVT_START_RESPONSE_WIZARD )
	{
		delete m_pMainDlg;
		m_pMainDlg = NULL;
	}

	switch (nEvent)
	{
		case EVT_START:
			OnEventStart();
			break;

		case EVT_EXIT:
			ExitHdl(0);
			break;

		case EVT_CANCEL_MAINDLG:
			if( m_pEnv->IsDlgPrecreateDir() )
			{
				SiDirEntry aEntry( m_pEnv->GetDestPath() );
				aEntry.Kill();
			}
			PostUserEvent( EVT_END );
			break;

		case EVT_END:
			if( m_pAgenda != NULL )
			{
				if( m_bNoVcl || ( QueryBox(GetAppWindow(), ResId(DLG_QUERYEXITBOX)).Execute() == RET_YES ) )
					m_pAgenda->StopRunning();
				break;
			}
			bEnd = TRUE;
			OnEventEnd();
			break;

		case EVT_CLOSE_INSTALLATION:
			CloseInstallation();
			break;

		case EVT_ENDINSTALL:
			OnEventEndInstallation();
			break;

		case EVT_START_UPDATE_OLD_VERSION :
			RunUpdateOldVersion();
			break;

		case EVT_START_PATCH :
            if ( m_pMainWin )
                m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_CHANGE );
			RunInstallation( m_pCompiledScript, m_pEnv->GetInstallMode() );
			break;

		case EVT_START_INSTALL :
		case EVT_START_APPSERVER_INSTALL :
		{
			SiInstallMode eInstallMode =
				m_pEnv->GetInstallType() == IT_WORKSTATION ? IM_WORKSTATION :
				m_pEnv->IsLocal() ? IM_STANDALONE : IM_NETWORK;

            if ( m_pMainWin )
                m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_ADD );

			RunInstallation( m_pCompiledScript, eInstallMode );
			break;
		}

		case EVT_INITIATE_WORKSTATION :
		{
			if( m_pEnv->GetWorkstationList().Count() )
			{
				if( !m_nWorkStationIdx )
					m_nWorkStationCnt = (USHORT) m_pEnv->GetWorkstationList().Count();
				m_nWorkStationIdx++;

				InitiateWorkstation* pWorkStation = m_pEnv->GetWorkstationList().Remove((ULONG)0);
				InstallWorkstation( pWorkStation );
			}
			else
				PostUserEvent( EVT_ENDINSTALL );
			break;
		}

		case EVT_REINST_CHANGE :
		{
            if ( m_pMainWin )
                m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_CHANGE );
			RunInstallation( m_pCompiledScript, IM_INVALID, ISM_CHANGE );
			break;
		}

		case EVT_REINST_UNINSTALL :
		{
			DEL_DELFILE( *m_pEnv );
            if ( m_pMainWin )
                m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_DELETE );
			RunInstallation( m_pCompiledScript, IM_INVALID, ISM_DELETE );
			break;
		}

		case EVT_REINST_RECOVER :
		{
            if ( m_pMainWin )
                m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_RECOVER );
			RunInstallation( m_pCompiledScript, IM_INVALID, ISM_RECOVER );
			break;
		}

		case EVT_START_RESPONSE_WIZARD :
		{
			m_pMainDlg->Hide();
			FinishResponseFileWizard();
			m_pMainDlg->Show();

			break;
		}

		case EVT_REINST_APPSERVER_USERADD :
		{
			PostUserEvent(EVT_END);
			break;
		}

		case EVT_REINST_APPSERVER_DEINSTALL :
		{
            if ( m_pMainWin )
                m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_DELETE );
			RunInstallation( m_pCompiledScript, IM_INVALID, ISM_DELETE );
			break;
		}

		default:
			DBG_ERROR( "SetupApp::UserEvent() invalid event" );
	}
}

// -----------------------------------------------------------------------

void SetupApp::GetMainDialogModel()
{
	if( !m_pMainDlg )
		return;

	CheckLanguage();

    ModelType eModelType = MODEL_NOTSET;
	SiInstallation* pInstObj = m_pCompiledScript->GetInstallation();

	if( m_bResponseWizard )
	{
		m_pMainDlg->CreateModel_ResponseWizard();
		m_pMainDlg->SuccEvent( EVT_END );
		m_pMainDlg->FailEvent( EVT_END );
		return ;
	}
	else if( m_bParamDoCRCCheck )
	{
		m_pMainDlg->CreateModel_CRCCheck();
		m_pMainDlg->SuccEvent( EVT_END );
		m_pMainDlg->FailEvent( EVT_END );
		return ;
	}
	else if( m_bOfficeMode )
	{
		m_pMainDlg->CreateModel_OfficeRepair();
		m_pMainDlg->SuccEvent( EVT_REINST_RECOVER );
		m_pMainDlg->FailEvent( EVT_END );
		return ;
	}
	else if( m_pEnv->GetInstallMode() == IM_PATCH )
	{
		m_pMainDlg->CreateModel_PatchSetup();
		m_pMainDlg->SuccEvent( EVT_START_PATCH );
		m_pMainDlg->FailEvent( EVT_END );
		return ;
	}

	ByteString aInstalledPath;
	if( SiHelp::IsVersionAlreadyInstalled(aInstalledPath, m_pCompiledScript, m_pEnv) )
	{
		m_pEnv->SetInstalledPath( aInstalledPath );
		m_pEnv->SetDestPath( aInstalledPath );

        // We are not in the office folder so we can do a force repair
        m_pEnv->SetForceRepair( TRUE );

		SiDirEntry aScript( aInstalledPath );
		aScript += ByteString( "program" );
		aScript += ByteString( SETUP_INSTDB_FILE );

        SiDirEntry aWSScript( aInstalledPath );
        aWSScript += ByteString( SETUP_INSTDB_FILE );

		SiDirEntry aAdabasScript( aInstalledPath );
		aAdabasScript += ByteString( "adabas" );
		aAdabasScript += ByteString( SETUP_INSTDB_FILE );

        // ReadScript will trash m_pCompiledScript when it fails
        // therefor we make a backup copy
        SiCompiledScript *pCSBackup  = m_pCompiledScript;
        m_pCompiledScript = new SiCompiledScript;

		if( ! ReadScript(aScript) && ! ReadScript(aWSScript) && ! ReadScript(aAdabasScript) )
        {
            // #96883# Allow repair of existing installation, even when instdb.inf is damaged
            // When we can't read the script of either the standalone or workstation installation
            // we will ignore the installed version
            delete m_pCompiledScript;
            m_pCompiledScript = pCSBackup;
			m_pEnv->SetAutoRepair( FALSE );
        }
		else
        {
			delete pCSBackup;

            m_pEnv->SetFirstInstallation( FALSE );

            if ( m_pCompiledScript->GetInstallation() )
                m_pEnv->SetInstallForAllUser( m_pCompiledScript->GetInstallation()->InstallForAllUser() );

			if (m_pMainDlg)
			{
                m_pMainDlg->SetCScript( m_pCompiledScript );
				m_pMainDlg->CreateModel_WrongSetup();
				m_pMainDlg->SuccEvent( EVT_REINST_RECOVER );
				m_pMainDlg->FailEvent( EVT_END );
			}
    		return;
        }
	}

	if( m_pEnv->IsUpdateOldVersion() || m_pEnv->IsUpgradeOldVersion() )
	{
		m_pMainDlg->CreateModel_UpdateOldVersion();
		m_pMainDlg->FailEvent( EVT_END );
		if( m_pEnv->IsUpdateNoVersion() )
			m_pMainDlg->SuccEvent( EVT_END );
		else
			m_pMainDlg->SuccEvent( EVT_START_UPDATE_OLD_VERSION );
		return;
	}

	if( m_pEnv->IsFirstInstallation() )
	{
		if( pInstObj->GetUiProcName().Len() )
		{
			SiProcedure* pProc = (SiProcedure*)m_pCompiledScript->
								FindProcedureByName( pInstObj->GetUiProcName() );
			BOOL bOk = FALSE;
			if( pProc )
			{
				SiBasic aBasic( *m_pCompiledScript, *m_pEnv );
				aBasic.SetAgentDlg( m_pMainDlg );

                if ( m_pEnv->HasVCL() )
                {
                    NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
                    bOk = aBasic.Call( pProc->GetProcName(), pProc->GetCode() );
                }
                else
                    bOk = aBasic.Call( pProc->GetProcName(), pProc->GetCode() );

				m_pMainDlg->FailEvent( EVT_END );
				m_pMainDlg->SuccEvent( EVT_START_INSTALL );
			}
			if( !bOk )
			{
				UniString aMessage( UniString::CreateFromAscii("Error: UiProcedure not found\n\n") );
				aMessage += UniString::CreateFromAscii( pInstObj->GetUiProcName().GetBuffer() );

				if( !IsResponseMode() )
				{
					ErrorBox anErrorBox(NULL, WB_OK, aMessage);
					anErrorBox.Execute();
					PostUserEvent(EVT_END);
				}
				else
					Critical_Error( ERR_UIPROCNOTFOUND, "" );
			}
			return;
		}
		else if( pInstObj->GetInstallMode() == IM_APPSERVER )
		{
			m_pMainDlg->CreateModel_AppServerInstallation();
			m_pMainDlg->SuccEvent( EVT_START_APPSERVER_INSTALL );
		}
		else
		{
			m_pMainDlg->CreateModel_FirstInstallation();
			m_pMainDlg->SuccEvent( EVT_START_INSTALL );
		}

		m_pMainDlg->FailEvent( EVT_CANCEL_MAINDLG );

		return;
	}
	else
	{
		if( pInstObj->GetInstallMode() == IM_APPSERVER )
			m_pMainDlg->CreateModel_AppServerReInstallation();
		else
			m_pMainDlg->CreateModel_ReInstallation();

		m_pMainDlg->FailEvent( EVT_END );
		return;
	}
}

// -----------------------------------------------------------------------
namespace
{
	UniString getSystemPathFromFileURL(ByteString const& _sFileURL)
	{
		rtl::OUString suInstalledPathURL(UniString(_sFileURL, osl_getThreadTextEncoding()));
		rtl::OUString suInstalledPath( suInstalledPathURL );
        
        // when the function returns an error, the url probably isn't an url but an system path
        if ( FileBase::getSystemPathFromFileURL( suInstalledPathURL, suInstalledPath ) == FileBase::E_None )
            return UniString( suInstalledPath );
        else
            return UniString( suInstalledPathURL );
	}

    ByteString getFileURLFromSystemPath( ByteString const& _sPath )
	{
		rtl::OUString suPathURL;
		rtl::OUString suPath( UniString( _sPath, osl_getThreadTextEncoding()) );
		FileBase::getFileURLFromSystemPath( suPath, suPathURL );

		return ByteString( OUStringToOString( suPathURL, osl_getThreadTextEncoding() ) );
	}
}

// ------------------- Check for an already installed version -------------------
void SetupApp::CheckForUpdate()
{
	if( !m_pEnv->IsFirstInstallation() ) return;
    if ( m_pEnv->IsResponsefileMode() ) return;

	// look for an already installed version
	//  find its setup.inf
	//  compile it
	//  check versions

	// if there is an UpdateFor key in the script
	SiInstallation* pInstObjForInstall = m_pCompiledScript->GetInstallation();
	ByteString  sUpdateForList = pInstObjForInstall->GetUpdateFor();
    xub_StrLen  nToken = sUpdateForList.GetTokenCount();
    BOOL        bIsAdabas = pInstObjForInstall->GetProductName() == ByteString( "Adabas D" );

    for ( xub_StrLen i=0; i<nToken; i++ )
    {
        ByteString sUpdateFor = sUpdateForList.GetToken( i );
        if ( ! sUpdateFor.Len() )
            continue;

        // search for an installed staroffice
		ByteString sInstalledPathURL_WS;

        // first we check whether we had a parameter update with path
        sInstalledPathURL_WS = GetUpdateDestURL();

        // if not, we look for the Office via sversion.ini ( SiHelp::... )
        if ( !sInstalledPathURL_WS.Len() )
        {
            SiProfileItem* pItem = m_pCompiledScript->GetInstallInfo();
            sInstalledPathURL_WS = SiHelp::FindInstallation(pItem, sUpdateFor);
        }

        // extended check for adabas
        if ( bIsAdabas && !sInstalledPathURL_WS.Len() )
        {
            sInstalledPathURL_WS = GetAdabasDir();
        }

        // when we still hadn't found a version, we can quit here because it's not an update
        if ( !sInstalledPathURL_WS.Len() )
            continue;

        ByteString sInstallPath( getSystemPathFromFileURL(sInstalledPathURL_WS), osl_getThreadTextEncoding());
        ByteString sInstalledPathURL_NET = sInstalledPathURL_WS;
        ByteString sInstalledPathURL_ADABAS = sInstalledPathURL_WS;
        sInstalledPathURL_WS += "/program/";
        sInstalledPathURL_WS += ByteString( SETUP_INSTDB_FILE );
        sInstalledPathURL_ADABAS += "/adabas/";
        sInstalledPathURL_ADABAS += ByteString( SETUP_INSTDB_FILE );
        sInstalledPathURL_NET += "/";
        sInstalledPathURL_NET += ByteString( SETUP_INSTDB_FILE );

		String suInstalledPath = getSystemPathFromFileURL(sInstalledPathURL_WS);
		SiAnsiFileStream aStream;
		aStream.Open( suInstalledPath, STREAM_READ );

		if( !aStream.IsOpen() )
		{
			// second try, we go one directory up
			suInstalledPath = getSystemPathFromFileURL(sInstalledPathURL_NET);
			aStream.Open( suInstalledPath, STREAM_READ );
		}
        if( !aStream.IsOpen() )
        {
            // third try, checking for an adabas installation
            suInstalledPath = getSystemPathFromFileURL(sInstalledPathURL_ADABAS);
            aStream.Open( suInstalledPath, STREAM_READ );
            if( !aStream.IsOpen() )
                continue;
        }

        SetupInfoDialog* pInfDlg = NULL;
        if( !IsResponseMode() )
        {
            pInfDlg = new SetupInfoDialog( m_pMainWin );
            pInfDlg->Show();
            pInfDlg->Update(); // sonst ist event. der Dialog nicht zu sehen
        }

		std::auto_ptr<SiCompiledScript>  cs( new SiCompiledScript );
		// important: do not delete cs,
		SiCompilerRef xCompiler = new SiCompiler( aStream );
		xCompiler->NoApplication();
		// try to compile the script
		if (xCompiler->CompileTo( cs.get() ))
		{
			// Script compiled.
			SiInstallation* pCurrentInstall = cs->GetInstallation();
			ByteString sProductName = pCurrentInstall->GetProductName();
			ByteString sProductVersion = pCurrentInstall->GetProductVersion();
			ByteString sProductLanguage = pCurrentInstall->GetLanguages();

			sal_Int32 nProductNamePos = sUpdateFor.Search(sProductName);
			sal_Int32 nProductVerPos  = sUpdateFor.Search(sProductVersion);
			sal_Int32 nLanguagePos = sProductLanguage.Search(pInstObjForInstall->GetLanguages());

            // check if we are the same UpdateFor
            BOOL bTryUpdate = FALSE;
            if ( bIsAdabas )
            {
                if ( IsUpdateAdabas( pInstObjForInstall->GetProductVersion() ) )
                    bTryUpdate = TRUE;
            }
            else if ( (nProductNamePos != STRING_NOTFOUND) && (nProductVerPos != STRING_NOTFOUND) )
                bTryUpdate = TRUE;

            if ( bTryUpdate )
            {
                // Check, whether the install modes matches
                SiInstallMode eCurrInstMode, eDestInstMode;
                if ( m_pEnv->GetInstallMode() == IM_INVALID )
                    if ( m_pEnv->IsLocal() )
                        eCurrInstMode = IM_STANDALONE;
                    else
                        eCurrInstMode = IM_NETWORK;
                else if ( ( m_pEnv->GetInstallMode() == IM_NETWORK ) &&
                            m_pEnv->IsLocal() )
                    eCurrInstMode = IM_WORKSTATION;
                else
                    eCurrInstMode = IM_INVALID;

                eDestInstMode = pCurrentInstall->GetInstallMode();

                //  check if the languages are the same
				if (nLanguagePos == STRING_NOTFOUND)
				{
					m_pEnv->SetUpdateOldVersionWrongLanguage(true);
				}

				// Name and Version are equal
				m_pEnv->SetUpdateOldVersion();
				m_pEnv->SetInstalledPath(sInstallPath);

                if ( eDestInstMode == IM_WORKSTATION )
                {
                    ByteString aSourcePath = pCurrentInstall->GetSourcePath();

                    if ( eCurrInstMode != IM_WORKSTATION )
                    {
                        ByteString aNetPath = getFileURLFromSystemPath( aSourcePath );
                        aNetPath += "/program/";
                        aNetPath += ByteString( SETUP_INSTDB_FILE );

                        suInstalledPath = getSystemPathFromFileURL( aNetPath );
                        aStream.Open( suInstalledPath, STREAM_READ );

                        if( !aStream.IsOpen() )
                        {
                            m_pEnv->SetUpdateOldVersion( FALSE );
                            delete pInfDlg;
                            continue;             // Network installation invalid?
                        }

                        std::auto_ptr< SiCompiledScript> cs2( new SiCompiledScript );

                        xCompiler = new SiCompiler( aStream );
                        xCompiler->NoApplication();
                        // try to compile the script
                        if ( xCompiler->CompileTo( cs2.get() ) )
                        {
                            SiInstallation *pNetInstall = cs2->GetInstallation();
                            SiInstallation *pNewInstall = m_pCompiledScript->GetInstallation();

                            m_pEnv->SetInstalledPath( aSourcePath );
                            m_pOldCompiledScript = cs2.release();
                            eDestInstMode = m_pOldCompiledScript->GetInstallation()->GetInstallMode();
                        }
                        else
                        {
                            // No valid script, don't update!
                            m_pEnv->SetUpdateOldVersion( FALSE );
                            delete pInfDlg;
                            continue;
                        }
                    }
                    else
                    {
                        m_pEnv->SetInstallType( IT_WORKSTATION );
                        if ( aSourcePath.EqualsIgnoreCaseAscii( m_pEnv->GetSourcePath() ) )
                            m_pEnv->SetUpdateOnly( TRUE );
                        m_pOldCompiledScript = cs.release();
                    }
                }
                else
                    m_pOldCompiledScript = cs.release();

                if ( eCurrInstMode != eDestInstMode )
                    m_pEnv->SetUpdateError( eCurrInstMode, eDestInstMode );

				SiDirEntry aTmp( m_pEnv->GetInstalledPath() );
				aTmp += ByteString( "foo.tmp" );

				FILE* pF = fopen( aTmp.GetFull().GetBuffer(), "w" );
				if( pF ) fclose( pF );

				if( !aTmp.Exists() )
					m_pEnv->SetUpdateOldVersionNoRights( TRUE );
				else
					aTmp.Kill();
			}
            delete pInfDlg;
		}

        break;
	}
}
// -----------------------------------------------------------------------
void SetupApp::OnEventStart()
{
	CheckForUpdate();

    SiHelp::InitMigration( m_pCompiledScript, m_pEnv );
	m_pEnv->InitRecycle();

	if( m_pEnv->GetInstallMode() == IM_PATCH )
	{
		// #99628# Kill Quickstarter before welcome window starts.
		SiHelp::KillQuickStarter(m_pEnv, m_pOldCompiledScript);
	}

	m_pMainDlg = new SetupAgentDialog( GetAppWindow(), m_pResMan, this, m_bResponseWizard );

    m_pMainDlg->SetCScript(m_pCompiledScript);
	m_pMainDlg->SetOldCScript(m_pOldCompiledScript);
	m_pMainDlg->SetSecondResMgr(m_pSecondResMgr);

	GetMainDialogModel();

    if (m_pMainDlg)
	{
		m_pMainDlg->StartAgentDlg();
		m_pMainDlg->Show();
	}
}
// -----------------------------------------------------------------------

void _FlagAllAsInstalled(SiModule* const pMod)
{
	pMod->SetInstalled();
	SiModuleList const* pModuleList = pMod->GetModuleList();
	if( pModuleList != NULL )
		for (USHORT xx=0; xx < pModuleList->Count(); xx++)
			_FlagAllAsInstalled( pModuleList->GetObject(xx) );
}

// -----------------------------------------------------------------------
extern "C" {
const char* FindArch(const char* pDefSource, const char* pDefName )
{
	SiDirEntry aEntry(pDefName);

	SetupInsertDiskDialog *pDlg = new SetupInsertDiskDialog(
		((SetupWindow*)Application::GetAppWindow)->GetContWin(),
		Point(50,50), pSetupApp->GetEnvironment()->GetProductName(),
		ByteString(""), ((SiDirEntry&)aEntry.GetPath()).GetFull() );

	pDlg->SetError();
	pDlg->SetFileText(aEntry.GetName());

	BOOL bFnd = FALSE;
	BOOL bEndInst = FALSE;
	while( !bFnd && !bEndInst )
	{
		USHORT nRet = pDlg->Execute();
		if( nRet == RET_CANCEL &&
			QueryBox(NULL, ResId(DLG_QUERYEXITBOX)).Execute() == RET_YES )
		{
			bEndInst = TRUE;
		}
		if( nRet == RET_OK )
		{
			aEntry = pDlg->GetSourcePath();
			pSetupApp->GetEnvironment()->SetSourcePath( aEntry.GetFull() );
			bFnd = TRUE;
		}
	}
	delete pDlg;

	if( bEndInst )
	{
		pSetupApp->GetAgenda()->StopRunning();
		return NULL;
	}
	return pSetupApp->GetEnvironment()->GetSourcePath().GetBuffer();
}
};

// -----------------------------------------------------------------------

void SetupApp::RunUpdateOldVersion()
{
	if ( !m_pEnv->IsUpdateOldVersion() )
    {
        delete m_pOldCompiledScript;
        m_pOldCompiledScript = NULL;
        m_pEnv->SetInstalledPath( ByteString() );
        PostUserEvent( EVT_START_INSTALL );
        return;
    }

	SiInstallation *pOldInstallation = m_pOldCompiledScript->GetInstallation();
    SiInstallMode   eInstMode = pOldInstallation->GetInstallMode();
	ByteString      aSrcPath;

    aSrcPath = m_pEnv->GetSourcePath();

    m_pEnv->SetDestPath         ( pOldInstallation->GetDestPath() );
    m_pEnv->SetSourcePath       ( pOldInstallation->GetSourcePath() );
	m_pEnv->SetFirstInstallation( FALSE );
    m_pEnv->SetInstallForAllUser( pOldInstallation->InstallForAllUser() );

	SiHelp::KillQuickStarter( m_pEnv, m_pOldCompiledScript );

	if( m_pEnv->IsUpdateOldVersion() )
	{
        SiInstallation* pCurrentInstall = m_pCompiledScript->GetInstallation();
        String sProductName( pCurrentInstall->GetUpdateFor(), osl_getThreadTextEncoding() );

        OfficeRunning aCheckOffice( NULL, m_pResMan );
        if ( aCheckOffice.isRunning( m_pEnv, sProductName ) == TRUE )
        {
            PostUserEvent( EVT_EXIT );
            return;
        }

		// Bei Uninstall werden alle Module selektiert, deshalb muessen vorher die
		// Selections auf das neue Script uebertragen werden.
		m_pCompiledScript->GetRootModule()->Select( SiModule::ALL_UNSEL );
		SiHelp::TransferSelection( m_pOldCompiledScript->GetRootModule(), m_pCompiledScript->GetRootModule() );

        // select all new modules that are not in the old installation set
        // (to avoid missing a new feature!)
        SiHelp::SelectNewAdded( m_pCompiledScript->GetRootModule(), m_pOldCompiledScript->GetRootModule() );

		// deinstallation wird jetzt sync. gefahren!
		//# if( m_pAgenda ) we don't need to check if null with following delete!
		delete m_pAgenda;
		m_pAgenda = new SiAgenda;
		UIAgendaCallback* pUICall = new UIAgendaCallback( m_pMainWin, m_pOldCompiledScript, m_pEnv );

		Link aLink = LINK(this, SetupApp, WindowHideHdl);
		m_pAgenda->SetWindowHideLink( aLink );
		m_pAgenda->SetCallback( pUICall );
		m_pAgenda->SetAppLanguage( m_nLanguage );
		m_pAgenda->SetEnvironment( m_pEnv );

		m_pAgenda->CreateForUninstall( *m_pOldCompiledScript, ISM_DELETE );

		// und los...
        if ( m_pMainWin )
            m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_DELETE );
		m_pAgenda->Run( *m_pOldCompiledScript, ISM_DELETE );

		delete m_pAgenda;
		m_pAgenda = NULL;
	}

	m_pEnv->SetFirstInstallation();
	m_pEnv->SetSourcePath( aSrcPath );

    if ( m_pMainWin )
        m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_ADD, m_pEnv );

    m_pEnv->SetLocal( eInstMode != IM_NETWORK );

	RunInstallation( m_pCompiledScript, eInstMode );
}

// -----------------------------------------------------------------------

void SetupApp::RunInstallation( SiCompiledScript* pCS, SiInstallMode eInstallMode,
		SiInstallSubMode eInstallSubMode, BOOL bUpgrade, BOOL bNoEvents )
{
	SiModule        *pRootModule    = pCS->GetRootModule();
	SiInstallation  *pInstallation  = pCS->GetInstallation();

	if( !pRootModule )
		return;

	SiHelp::KillQuickStarter(m_pEnv, pCS);

	if( !IsResponseMode() )
	{
		if( m_pEnv->GetUILanguageContext().Count() == 1 )
		{
			LanguageContext* pAct = m_pEnv->GetUILanguageContext().GetObject(0);
			pAct->isProg = TRUE;
			pAct->isDoc	 = TRUE;
		}
		PrepareLanguageContext();
	}
	// Agenda berechnen
	// SiCompiledScript aCS;

	if( m_pAgenda )
		delete m_pAgenda;
	m_pAgenda = new SiAgenda;

	UIAgendaCallback* pUICall = new UIAgendaCallback( m_pMainWin, m_pCompiledScript, m_pEnv );
	m_pAgenda->SetCallback( pUICall );

    Link aLink = LINK(this, SetupApp, WindowHideHdl);
	m_pAgenda->SetWindowHideLink( aLink );
	m_pAgenda->SetAppLanguage( m_nLanguage );
	m_pAgenda->SetEnvironment( m_pEnv );

	if( bUpgrade )
	{
		m_pEnv->SetFirstInstallation();
		eInstallMode = m_pCompiledScript->GetInstallation()->GetInstallMode();
	}
	else if( m_pEnv->IsFirstInstallation() )
	{
		if( pCS->GetRootModule() != NULL )
			pCS->GetRootModule()->Select( SiModule::THIS_SEL_IGNORE_INST );

		if( m_pEnv->GetSourcePath() == "" )
			m_pEnv->SetSourcePath( m_pEnv->GetStartPath() );
	}
	else
	{
		eInstallMode = pInstallation->GetInstallMode();
		m_pEnv->SetSourcePath( pCS->GetInstallation()->GetSourcePath() );
	}

	SiInstallMode eOldInstallMode = m_pEnv->GetInstallMode();
    m_pEnv->SetInstallMode( eInstallMode );

    if( m_pEnv->IsFirstInstallation() )
	{
		m_pAgenda->CreateForInstall( *pCS, eInstallMode,
					pInstallation != NULL && pInstallation->GetInstallMode() == IM_NETWORK );
	}
	else
	{
		switch( eInstallSubMode )
		{
			case ISM_CHANGE:
				m_pAgenda->CreateForChange(*pCS,eInstallSubMode);
				break;

			case ISM_RECOVER:
				m_pAgenda->CreateForRecover(*pCS);
				break;

			case ISM_DELETE:
				m_pAgenda->CreateForUninstall(*pCS, ISM_DELETE);
				break;

			default:
				DBG_ERROR("SetupApp::RunInstallation() wrong submode");
				break;
		}
	}

	m_bIsAppServerInstall = eOldInstallMode == IM_APPSERVER ?
							TRUE : FALSE;

	OSL_ASSERT(m_pResMan);
	OfficeRunning aCheckOffice(NULL, m_pResMan);
	if (aCheckOffice.isRunning(m_pEnv) == TRUE)
	{
		// we must stop
		if( m_pAgenda )
		{
			delete m_pAgenda;
			m_pAgenda = NULL;
		}
		PostUserEvent( EVT_EXIT );
		return;
	}

	m_bPerformInstall = TRUE;

    if ( m_pEnv->HasVCL() )
    {
        m_pExecuter = new ThreadExecuter(m_pAgenda);

	    m_pExecuter->SetSourcePath		( m_pEnv->GetSourcePath() );
	    m_pExecuter->SetInstallMode		( eInstallMode );
	    m_pExecuter->SetInstallSubMode	( eInstallSubMode );
	    m_pExecuter->SetCScript			( pCS );
	    m_pExecuter->SetUpgrade			( bUpgrade );
	    m_pExecuter->SetNoEvent			( bNoEvents );

	    m_pExecuter->create();
	    m_pExecuter->setPriority( NAMESPACE_VOS(OThread)::TPriority_AboveNormal );
    }
    else
    {
    	ExecuterData aData;
	    aData.SetSourcePath     ( m_pEnv->GetSourcePath() );
	    aData.SetInstallMode    ( eInstallMode );
	    aData.SetInstallSubMode ( eInstallSubMode );
	    aData.SetCScript        ( pCS );
	    aData.SetUpgrade        ( bUpgrade );
	    aData.SetNoEvent        ( bNoEvents );
        aData.SetWorkstation    ( FALSE );

        m_pAgenda->Run( *pCS, eInstallSubMode );
	    CloseInstallation( &aData );
    }
}

void SetupApp::CloseInstallation( ExecuterData* pData )
{
    ExecuterData *pExecData = pData ? pData : m_pExecuter->GetData();

    SiInstallation* pInstallation = pExecData->GetCScript()->GetInstallation();

	// bei AppServer Deinstallation war's das hier, es folgen ja noch
	// die Clients...
/*	if( m_pExecuter->GetInstallMode() == IM_APPSERVER &&
		m_pExecuter->GetInstallSubMode() == ISM_DELETE )
	{
		m_bPerformInstall = FALSE;

		delete m_pExecuter;
		m_pExecuter = NULL;

		delete m_pAgenda;
		m_pAgenda = NULL;

		return;
	}
*/
	if( m_pEnv->IsFirstInstallation() && pExecData->GetInstallMode() == IM_STANDALONE )
		KillSlideshowFiles( pExecData->GetCScript() );

	if( !m_pAgenda->WasRunningStopped() && m_pEnv->IsFirstInstallation() && m_pEnv->IsLocal() )
		m_pEnv->StoreRecycle();

	// Inst-DB
	SiDirEntry aScriptEntry;
	if( !m_bIsAppServerInstall )
		aScriptEntry = m_pEnv->GetInstallType() == IT_WORKSTATION?
					   m_pEnv->GetDestPath() : m_pCompiledScript->GetSetupExePath(*m_pEnv);
	else
		aScriptEntry = m_pCompiledScript->GetSetupExePath(*m_pEnv);

	if ( m_pEnv->GetInstallMode() == IM_PATCH )
	{
		// backup old instdb.inf
		SiDirEntry aSource( m_pEnv->GetDestPath() );
		aSource += ByteString("program");
		#ifdef UNX
		aSource += ByteString("instdb.ins");
		#else
		aSource += ByteString("instdb.inf");
		#endif

		ByteString aFolderName( "Backup_PP" );
		aFolderName += ByteString::CreateFromInt32(
					   m_pCompiledScript->GetInstallation()->GetPatchLevel() );

		SiDirEntry aDest( m_pEnv->GetDestPath() );
		aDest += aFolderName;
		aDest += ByteString("program");
		#ifdef UNX
		aDest += ByteString("instdb.ins");
		#else
		aDest += ByteString("instdb.inf");
		#endif

        FileCopier aFileCopier( aSource, aDest );
		aFileCopier.Execute();

		// mere objects
		DeclaratorSet* pDecl = m_pCompiledScript->GetDeclarators();
		DeclaratorSetIt Iterator( *pDecl );
		for( SiDeclarator* pDeclarator = Iterator.GetFirst(); pDeclarator != NULL;
			 pDeclarator = Iterator.GetNext() )
		{
			if( !m_pOldCompiledScript->Find(pDeclarator->GetID()) )
			{
				SiModule *pModule = PTR_CAST(SiModule,pDeclarator);
				if( pModule )
					pModule->SetParent( m_pOldCompiledScript->GetRootModule() );
				pDeclarator->ResetRefCount();  // to bind new decl. on root module
				m_pOldCompiledScript->Add( pDeclarator, NULL );
			}
		}
		m_pOldCompiledScript->AddUnlinkedObjectsToRoot();
		m_pOldCompiledScript->GetInstallation()->SetPatchLevel(
			m_pCompiledScript->GetInstallation()->GetPatchLevel() );
		m_pOldCompiledScript->GetInstallation()->SetPatched();
	}

	aScriptEntry += ByteString( SETUP_INSTDB_FILE );
    pInstallation->SetDestPath( m_pEnv->GetDestPath() );
	pInstallation->SetInstallForAllUser( m_pEnv->InstallForAllUser() );

	if( ( m_pEnv->GetInstallMode() != IM_NETWORK ) && pInstallation->GetLanguages().Len() )
	{
		ByteString aNewLanguages;
		SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
		for( USHORT i = 0; i < rLst.Count(); ++i )
		{
			LanguageContext* pAct = rLst.GetObject(i);
			if( pAct->isProg || pAct->isDoc )
			{
				ByteString add = pAct->nLanguage == LANG_DEFAULT?
								pInstallation->GetDefLanguage() : ByteString::CreateFromInt32( pAct->nLanguage );

				if( add.Len() == 1 ) add.Insert( "0", 0 );
				aNewLanguages += add;

				if( i != rLst.Count()-1 )
					aNewLanguages += ",";
			}
		}
		pInstallation->ClearInstalledLanguages();
		pInstallation->SetLanguages( aNewLanguages );
	}

	if( !m_pAgenda->WasRunningStopped()	&&
//		pExecData->GetInstallSubMode() != ISM_RECOVER &&
		pExecData->GetInstallSubMode() != ISM_DELETE  &&
		!pExecData->IsWorkstation() )
	{
		SiAnsiFileStream aStream;
		SiDatabase       aDB(aStream);

		aStream.Open(aScriptEntry.GetFullUni(), STREAM_STD_WRITE | STREAM_TRUNC);

		if (aStream.IsOpen())
		{
			// #99973# a repaired office should not have the status patched
            // #104214# a modified office should not have the status patched, too
            if ( ( pExecData->GetInstallSubMode() == ISM_RECOVER ) ||
                 ( pExecData->GetInstallSubMode() == ISM_CHANGE ) )
            {
                pInstallation->SetPatchLevel( 0 );
                pInstallation->SetPatched( FALSE );
            }

			if( pExecData->GetInstallMode() == IM_NETWORK &&
				pInstallation->GetInstallMode() == IM_APPSERVER )
				pExecData->SetInstallMode( IM_APPSERVER );

			if( m_pEnv->IsFirstInstallation() && !pExecData->GetUpgrade() )
			{
				ByteString aSource = pExecData->GetSourcePath();
				if( pExecData->GetInstallMode() == IM_NETWORK && m_pEnv->IsBigMode() )
					aSource = m_pEnv->GetDestPath();

				SiCompiledScript* pDB2Write = m_pEnv->GetInstallMode() == IM_PATCH ?
								  m_pOldCompiledScript : pExecData->GetCScript();
				aDB.Create( pDB2Write, pExecData->GetInstallMode(), aSource,
					(pInstallation != NULL && pInstallation->GetInstallMode() == IM_NETWORK) );
			}
			else
			{
			if( pExecData->GetUpgrade() )
			{
				m_pCompiledScript->Join( pExecData->GetCScript() );
				aDB.Create( m_pCompiledScript ); // Inst-DB
			}
			else
				aDB.Create( pExecData->GetCScript() );
			}
		}
		aStream.Flush();
	}
	else if( pExecData->GetInstallSubMode() == ISM_DELETE )
	{
		aScriptEntry.Kill();
	}

	// Installation wurde durchgefuehrt, Hauptfenster ggf. restaurieren
	// damit MessBoxen sichtbar werden koennen.
	if( !IsResponseMode() )
		m_pMainWin->ToTop( TOTOP_RESTOREWHENMIN );

	if( !m_pAgenda->WasRunningStopped() && m_bIsAppServerInstall )
	{
		pInstallation->SetInstallMode( IM_APPSERVER );
		if( m_pEnv->GetWorkstationList().Count() )
		{
			if( pExecData->IsWorkstation() )
			{
				WriteWorkstationDB( pExecData );

				delete pExecData->GetCScript();
				delete m_pAgenda->GetEnvironment();
			}

            if ( m_pExecuter )
            {
                m_pExecuter->join();
			    delete m_pExecuter;
			    m_pExecuter = NULL;
            }

			delete m_pAgenda;
			m_pAgenda = NULL;

			PostUserEvent( EVT_INITIATE_WORKSTATION );
			return ;
		}
		else
		{
			if( pExecData->IsWorkstation() )
			{
				WriteWorkstationDB( pExecData );

				delete pExecData->GetCScript();
				delete m_pAgenda->GetEnvironment();
			}
		}
	}

	// Systemdateien anpassen...
	if( !m_pAgenda->WasRunningStopped()  &&
		pExecData->GetInstallMode() != IM_NETWORK &&
		pExecData->GetCScript()->GetInstallation() != NULL )
	{
		if( m_pEnv->IsFirstInstallation() )
		{
			#ifdef WIN
			if( !IsShareLoaded() &&
				pExecData->GetCScript()->GetInstallation()->RequiresShare() )
			{
				WinOS::InstallShare();
				m_pEnv->SetReboot( TRUE );
			}
			#endif
			#ifdef OS2
			if( pExecData->GetCScript()->GetInstallation()->DoModifyPath() )
			{
				BOOL bOK = TRUE;
				Os2OS::AddDestPathToConfigSys( !bOK, m_pEnv->GetProgPath(pExecData->GetInstallMode()) );
				m_pEnv->SetReboot( bOK );
			}
			#endif
		}
		else if (pExecData->GetInstallSubMode() == ISM_DELETE)
		{
			#ifdef OS2
			if( pExecData->GetCScript()->GetInstallation()->DoModifyPath() )
				Os2OS::RemoveDestPathFromConfigSys( m_pEnv->GetDestPath() );
			#endif
		}
	}

	if( !m_pAgenda->WasRunningStopped() )
	{	// have fun ...
		#ifdef OS2
		if( m_pEnv->IsFirstInstallation() &&  pExecData->GetInstallMode() != IM_NETWORK )
			m_pEnv->SetReboot( TRUE );
		#endif

		if( m_aParamFollowApp.Len() != 0 )
		{
            UniString aTmpString(UniString::CreateFromAscii(m_aParamFollowApp.GetBuffer()));
            UniString aEmptyString;
			_StartApplication( aTmpString, aEmptyString );
			if( !pExecData->GetNoEvent() )
				PostUserEvent(EVT_END);
		}
		else if( !pExecData->GetNoEvent() )
			PostUserEvent( EVT_ENDINSTALL );
	}
	else
	{
            if( m_pEnv->IsFirstInstallation() && QueryKillEntireDir(m_pEnv->GetDestPath()) )
			    KillEntireDir(m_pEnv->GetDestPath());
		    if( !pExecData->GetNoEvent() )
			    PostUserEvent(EVT_END);
        }

	m_bPerformInstall = FALSE;

	if ( m_pExecuter )
    {
        m_pExecuter->join();
	    delete m_pExecuter;
	    m_pExecuter = NULL;
    }

	delete m_pAgenda;
	m_pAgenda = NULL;
}

void SetupApp::OnEventEnd()
{
	if ( ! m_bNoVcl )
    {
        GetAppWindow()->Hide();
        Quit();
    }
}

void SetupApp::OnEventEndInstallation()
{
	/////////////////////////////////////////////////////////////
	// end dialog or procedure
	BOOL bRetYes 	= FALSE;
	BOOL bShutdown	= m_pEnv->IsReboot() || m_pEnv->IsLogout();

#ifdef WNT
    if ( ! m_bNoVcl )
        WinOS::PostFontChangedMsg(TRUE);

    WinOS::Shell_FlushIconCache();
	if( m_pEnv->IsPropagateWinEnvChange() )
		WinOS::PropagateEnvironmentChange();
#endif

	if( m_pEnv->GetFollowAppList().Count() && ProcessFollowApps(TRUE) )
		m_pEnv->SetDefuseRestart( TRUE );

	if( !IsResponseMode() )
	{
		m_pMainDlg = new SetupAgentDialog( GetAppWindow(), m_pResMan, this );

        m_pMainDlg->SetCScript(m_pCompiledScript);
		m_pMainDlg->SetSecondResMgr(m_pSecondResMgr);

		if( m_pEnv->IsFirstInstallation() )
			m_pMainDlg->CreateModel_EndFirstInstallation( bShutdown );
		else
			m_pMainDlg->CreateModel_EndInstallation( bShutdown );

		m_pMainDlg->StartAgentDlg();
		m_pMainDlg->Show();

		bRetYes = m_pMainDlg->DoModal();

		delete m_pMainDlg;
		m_pMainDlg = NULL;
	}
	else
		m_pResponseFile->ExecEndProcedure();

	/////////////////////////////////////////////////////////////
	// unloader
	BOOL 		bKillDelFile = TRUE;
	ByteString 	aAbsDelFileName;

	GET_DELFILENAME(*m_pEnv, aAbsDelFileName);

	#if defined(WNT) || defined(WIN)
    if( m_pEnv->GetInstallType() == IT_UNINSTALL )
	{

        // For debugging the 'delete all files' process we write some tracing informations
        ByteString 	aAbsLogDelFileName;
        time_t ltime;

        GET_DELFILENAME(*m_pEnv, aAbsLogDelFileName);
        aAbsLogDelFileName += ".log";
        FILE* pFile = fopen( aAbsLogDelFileName.GetBuffer(), "w" );
	    if( pFile )
        {
            time( &ltime );
            fprintf( pFile, "Will call uinst soon:%s\n", ctime( &ltime ) );
            fprintf( pFile, "The delme file is: %s\n",
                     aAbsDelFileName.GetBuffer() );
            fprintf( pFile, "Shutdown = %d, RetYes = %d\n", bShutdown, bRetYes );
            fflush( pFile );
            ADD_TO_DELFILE( *m_pEnv, aAbsLogDelFileName );
        }

        if ( !bShutdown || !bRetYes )
        {
            SiDirEntry aEntry( m_pEnv->GetInstalledPath() );
            aEntry += ByteString( "instdb.inf" );
            ADD_TO_DELFILE( *m_pEnv, aEntry.GetFull() );

            aEntry = m_pEnv->GetInstalledPath();
            aEntry += ByteString( "setup.log" );
            ADD_TO_DELFILE( *m_pEnv, aEntry.GetFull() );

            aEntry = m_pEnv->GetInstalledPath();
            aEntry += ByteString( "program/setup.log" );
            ADD_TO_DELFILE( *m_pEnv, aEntry.GetFull() );

            aEntry = m_pEnv->GetInstalledPath();
            aEntry += ByteString( "adabas/setup.log" );
            ADD_TO_DELFILE( *m_pEnv, aEntry.GetFull() );

            SiDirEntry aUnLoader( OS::GetGUIPath() );
            aUnLoader += ByteString( "uinst001.exe" );
            if( aUnLoader.Exists() )
            {
                // Quote parameter if necessary
                UniString aDelFile( aAbsDelFileName, osl_getThreadTextEncoding() );
                if ( aDelFile.Search( ' ' ) != STRING_NOTFOUND )
                {
                    aDelFile.Insert( '\'', 0 );
                    aDelFile.Insert( '\'' );
                }
                _StartApplication( aUnLoader.GetFullUni(), aDelFile );
                bKillDelFile = FALSE;
                time( &ltime );
                if ( pFile ) fprintf( pFile, "Uninst call finished at:%s\n", ctime( &ltime ) );
            }
            else
            {
                if ( pFile ) fprintf( pFile, "%s not found!\n", aUnLoader.GetFull().GetBuffer() );
            }
        }
        if ( pFile )
            fclose( pFile );
	}
	#endif
	if( bKillDelFile ) {
		SiDirEntry aEntry( aAbsDelFileName );
		aEntry.Kill();
	}

	/////////////////////////////////////////////////////////////
	// reboot quit
	if( !m_pEnv->GetFollowAppList().Count() &&
		bShutdown && !m_pEnv->IsDefuseRestart() && (bRetYes || IsResponseMode()) )
	{
		BOOL bLogoutOnly = m_pEnv->IsLogout() && !m_pEnv->IsReboot();
		if( m_pEnv->IsFirstInstallation() && m_pEnv->GetInstallType() != IT_WORKSTATION )
		{
			#if defined(WIN) || defined(WNT) || defined(OS2)
			SiDirEntry aEntry( m_pEnv->GetStartPath() );
			aEntry += ByteString("shutdown.me");
			FILE* pFile = fopen( aEntry.GetFull().GetBuffer(), "w" );
			if( bLogoutOnly )
				fprintf( pFile, "logout" );
			fclose( pFile );
			#endif
		}
		else
		{
			#if defined(WIN) || defined(WNT)
			WinOS::Shutdown(bLogoutOnly);
			#elif defined(OS2)
			Os2OS::Shutdown();
			#endif
		}
	}
	else
		ProcessFollowApps();
	PostUserEvent( EVT_END );
}


// -----------------------------------------------------------------------
ByteString SetupApp::SplitParameter( const ByteString& rData,
                                     ByteString& rParam )
{
    ByteString aAppName;

    xub_StrLen nStart = 0;
    xub_StrLen nPos = 0;

    if ( rData.GetChar(0) == '\'' )
    {
        BOOL bInQuote = TRUE;
        nStart = 1;
        nPos = rData.Search( '\'', nStart );
        
        while ( bInQuote && ( nPos != STRING_NOTFOUND ) )
        {
            if ( rData.GetChar( nPos+1 ) == '\'' )
            {
                aAppName += rData.Copy( nStart, nPos-nStart+1 );
                nStart = nPos + 2;
            }
            else
            {
                aAppName += rData.Copy( nStart, nPos-nStart );
                nStart = nPos + 1;
                bInQuote = FALSE;
            }
        }
        DBG_ASSERT( !bInQuote, "ProcessFollowApps: Misquoted application name?" );
    }

    nPos = rData.Search( ' ', nStart );
    
    if ( nPos != STRING_NOTFOUND )
    {
        aAppName += rData.Copy( nStart, nPos-nStart );
        rParam = rData.Copy( nPos+1 );
    }
    else
        aAppName += rData.Copy( nStart );

    return aAppName;
}

BOOL SetupApp::ProcessFollowApps( BOOL bTestOnly )
{
	BOOL bReturn = TRUE;
	SiFollowAppList& rLst = m_pEnv->GetFollowAppList();
	for( USHORT i = 0; i < rLst.Count(); ++i )
	{
        ByteString  aParam;
		ByteString* pAppName = rLst.GetObject(i);
		SiDirEntry  aEntry;
		
        if( m_pEnv->IsBigMode() ) {
			SiDirEntry aTmp( m_pEnv->GetSourcePath() );
			aEntry = aTmp.GetPath();
		}
		else
			aEntry = m_pEnv->GetSourcePath();

        aEntry += SplitParameter( *pAppName, aParam );

        if( bTestOnly && !aEntry.Exists() )
			bReturn = FALSE;
		if( !bTestOnly && aEntry.Exists() )
        {
            UniString aApplication;
            UniString aParameter( aParam, osl_getThreadTextEncoding() );

            aApplication = aEntry.GetFullUni();

            setup::ChangeDirectory( aApplication );
            _StartApplication( aApplication, aParameter );
        }
	}
	return bReturn;
}
// -----------------------------------------------------------------------

BOOL SetupApp::AreAllAppsClosed(Window* pParent, USHORT nId)
{
	return TRUE;
}

void SetupApp::KillSlideshowFiles(SiCompiledScript* pCS)
{
	const SiFileList& rFileList = pCS->GetRootModule()->GetFileList();
	for( USHORT i = 0; i < pCS->GetSlideList().Count(); ++i )
	{
		SiFile* pFile           = NULL;
		ByteString aBmpName         = pCS->GetSlideList().GetObject(i)->GetBmpFileName();
		ByteString aWaveName        = pCS->GetSlideList().GetObject(i)->GetWaveFileName();

		for( USHORT x = 0; x < rFileList.Count(); ++x )
		{
			pFile = rFileList.GetObject(x);
			if( pFile &&
			   (pFile->GetName().CompareIgnoreCaseToAscii(aBmpName) == COMPARE_EQUAL ||
				pFile->GetName().CompareIgnoreCaseToAscii(aWaveName) == COMPARE_EQUAL) )
			{
				pFile->SetDontRecover( TRUE );

				SiDirEntry aFile( m_pEnv->GetDestPath() );
				aFile += pFile->GetDirectory()->GetName();
				aFile += pFile->GetName();
				aFile.ToAbs();
				aFile.Kill();
			}
		}
	}
}

// -----------------------------------------------------------------------
// Zielverzeichnis komplett loeschen; Abfragen und ausfuehren
//

BOOL SetupApp::QueryKillEntireDir(ByteString const& rPath)
{
	if( m_pEnv->IsResponsefileMode() ) return FALSE;
    if ( m_pEnv->GetInstallMode() == IM_PATCH ) return FALSE;

	QueryBox aBox(GetAppWindow(), ResId(m_pEnv->IsInstallOnRoot() ? QBOX_KILLDIR_ROOT : QBOX_KILLDIR));
	String sMess = aBox.GetMessText();

	sMess.SearchAndReplace(
				UniString::CreateFromAscii("%s"),
				/* #91501#
				UniString::CreateFromAscii(rPath.GetBuffer()*/
				UniString(rPath, osl_getThreadTextEncoding() ) );
	aBox.SetMessText(sMess);

	return aBox.Execute() == RET_YES;
}

void SetupApp::KillEntireDir(ByteString const& rPath)
{
	SiDirEntry aKillDir(rPath);
	KillEntireDir(aKillDir, TRUE);
	if( aKillDir.Exists() )
		aKillDir.Kill();
}

void SetupApp::KillEntireDir(SiDirEntry const& rEntry, BOOL bDelFiles)
{
	if( !rEntry.Exists() )
		return ;

	SiDirEntry aTmp  = rEntry;
			 aTmp += SiDirEntry( "*" );

	if (bDelFiles)
	{
	Dir aFiles(aTmp , FSYS_KIND_FILE);

	for (USHORT i = 0; i < aFiles.Count(); ++i)
		aFiles[i].Kill();
	}

	Dir aDir(aTmp, FSYS_KIND_DIR);

	for ( USHORT i = 0; i < aDir.Count(); ++i )
	{
		ByteString aDummy( aDir[i].GetName(), osl_getThreadTextEncoding() );
		ByteString aFull( aDummy );
		if (aFull != "." && aFull != "..")
		{
				SiDirEntry aSubDir  = rEntry;
					 	aSubDir += aDir[i];

			KillEntireDir(aSubDir, bDelFiles);
		}
	}

	FSysError nErr = rEntry.Kill();

	if (nErr != 0)
	{
		SiDirEntry aCurrentDir;
		nErr = nErr;
	}
}

void SetupApp::InstallWorkstation(InitiateWorkstation* pWorkStation)
{
	SiDirEntry aServerInstDB( m_pCompiledScript->GetSetupExePath(*m_pEnv) );
	aServerInstDB += ByteString( SETUP_INSTDB_FILE );
	aServerInstDB.ToAbs();

	SiCompiledScript* pWCScript = new SiCompiledScript;
	if( !ReadScript(aServerInstDB, pWCScript) )
	{
		delete pWorkStation;
		delete pWCScript;
		return;
	}

	SiDirEntry aInstPath( pWorkStation->aDirectory );
	aInstPath.ToAbs();
	if( !aInstPath.Exists() )
		aInstPath.MakeDir();

	BOOL bSuccCWD = aInstPath.SetCWD();
	if( !bSuccCWD )
	{
		String aMsg( ResId(STR_APPSERVER_NORIGHTS) );
		aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromInt32(pWorkStation->nLanguage) );
		aMsg.SearchAndReplace( UniString::CreateFromAscii("%2"), aInstPath.GetFullUni() );
		ErrorBox aBox( GetAppWindow(), WB_OK, aMsg );
		aBox.Execute();

		delete pWorkStation;
		delete pWCScript;
		PostUserEvent( EVT_INITIATE_WORKSTATION );
		return;
	}

	SiEnvironment* pWEnv = new SiEnvironment;

	pWEnv->SetFirstInstallation	( TRUE );
	pWEnv->SetInstalledPath		( m_pEnv->GetDestPath() );
	pWEnv->SetSourcePath		( m_pEnv->GetDestPath() );
	pWEnv->SetDestPath			( aInstPath.GetFull() );
	pWEnv->SetAutoWorkstation	( TRUE );
    pWEnv->SetHasVCL            ( m_pEnv->HasVCL() );

	pWEnv->SetResponseStep		( m_pEnv->GetResponseStep() );
	pWEnv->SetDefLanguage		( (USHORT) pWCScript->GetInstallation()->GetDefLanguage().ToInt32() );
	pWEnv->SetSingleProductName	( pWCScript->GetInstallation()->GetProductName() );
	pWEnv->SetProductVersion	( pWCScript->GetInstallation()->GetProductVersion() );
	pWEnv->SetVendorName        ( pWCScript->GetInstallation()->GetVendorName() );
	pWEnv->SetVendorVersion     ( pWCScript->GetInstallation()->GetVendorVersion() );
	pWEnv->SetInternalVersion	( pWCScript->GetInstallation()->GetInternalProductVersion() );
	pWEnv->SetSuiteName			( pWCScript->GetInstallation()->GetSuiteName() );
	pWEnv->SetInstallMode		( pWCScript->GetInstallation()->GetInstallMode() );

	pWEnv->SetProductName( m_pEnv->GetSingleProductName(), m_pEnv->GetProductVersion() );

    if ( m_pCompiledScript->GetInstallInfo() )
		pWEnv->SetProductKey( m_pCompiledScript->GetInstallInfo()->GetKey() );

	if( pWorkStation->nLanguage != LANG_DEFAULT )
	{
		USHORT nDefLang = (USHORT) pWCScript->GetInstallation()->GetDefLanguage().ToInt32();
		LanguageContext* pCtx = new LanguageContext;
		pCtx->nLanguage	= pWorkStation->nLanguage == nDefLang? LANG_DEFAULT : pWorkStation->nLanguage;
		pCtx->isProg   	= TRUE;
		pCtx->isDoc		= TRUE;

		pWEnv->AddLanguageContext( pCtx );
	}

	pWCScript->PrepareForLocalInstallation();

	if( !pWCScript->GetRootModule() )
	{
		delete pWorkStation;
		delete pWCScript;
		delete pWEnv;
		PostUserEvent( EVT_INITIATE_WORKSTATION );
		return;
	}

	ByteString aTitle = m_pEnv->GetProductName();
    if ( m_pMainWin )
	    m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_APPSERVER_USER, pWEnv,
											    m_nWorkStationIdx, m_nWorkStationCnt );

	pWCScript->GetRootModule()->Select( SiModule::ALL_SEL );

	UIAgendaCallback* pUICall = new UIAgendaCallback( m_pMainWin, pWCScript, pWEnv );

	m_pAgenda = new SiAgenda;

    Link aLink = LINK(this, SetupApp, WindowHideHdl);
	m_pAgenda->SetWindowHideLink( aLink );
	m_pAgenda->SetCallback		( pUICall );
	m_pAgenda->SetEnvironment	( pWEnv );
	m_pAgenda->CreateForInstall	( *pWCScript, IM_WORKSTATION, TRUE );

	m_bPerformInstall = TRUE;

	if ( pWEnv->HasVCL() )
    {
        m_pExecuter = new ThreadExecuter(m_pAgenda);

	    m_pExecuter->SetWorkstation		( TRUE );
	    m_pExecuter->SetSourcePath		( pWEnv->GetSourcePath() );
	    m_pExecuter->SetInstallMode		( IM_WORKSTATION );
	    m_pExecuter->SetInstallSubMode	( ISM_ADD );
	    m_pExecuter->SetCScript			( pWCScript );
	    m_pExecuter->SetUpgrade			( FALSE );
	    m_pExecuter->SetNoEvent			( FALSE );

	    m_pExecuter->create();
	    m_pExecuter->setPriority( NAMESPACE_VOS(OThread)::TPriority_AboveNormal );
    }
    else
    {
    	ExecuterData aData;
	    aData.SetWorkstation        ( TRUE );
	    aData.SetSourcePath         ( pWEnv->GetSourcePath() );
	    aData.SetInstallMode        ( IM_WORKSTATION );
	    aData.SetInstallSubMode     ( ISM_ADD );
	    aData.SetCScript            ( pWCScript );
	    aData.SetUpgrade            ( FALSE );
	    aData.SetNoEvent            ( FALSE );

        // threadExecuter calls :   m_pAgenda->Run( * GetCScript(), GetInstallSubMode() );
        //                          Application::PostUserEvent( EVT_CLOSE_INSTALLATION );
        // this will be translated to the following ...

        m_pAgenda->Run( *pWCScript, ISM_ADD );
	    CloseInstallation( &aData );
    }

	delete pWorkStation;
}

void SetupApp::WriteWorkstationDB( ExecuterData* pData )
{
	if( m_pAgenda->WasRunningStopped() )
		return ;

	SiInstallation* pInst = pData->GetCScript()->GetInstallation();

	if( pInst )
		pInst->SetInstalledLanguages( m_pAgenda->GetEnvironment() );

	SiAnsiFileStream aStream;
	SiDatabase		 aDB(aStream);

	SiDirEntry aScriptEntry( m_pAgenda->GetEnvironment()->GetDestPath() );
	aScriptEntry += ByteString( SETUP_INSTDB_FILE );
	aStream.Open( aScriptEntry.GetFullUni(), STREAM_STD_WRITE | STREAM_TRUNC );

	if( aStream.IsOpen() )
	{
		ByteString aSource = m_pAgenda->GetEnvironment()->GetSourcePath();
		aDB.Create( pData->GetCScript(), IM_WORKSTATION, aSource, FALSE );
	}
	aStream.Flush();
}

ByteString SetupApp::GetUpdateDestURL() const
{
    ByteString aRet;

    if ( m_aUpdateDestPath.Len() )
        aRet = getFileURLFromSystemPath( m_aUpdateDestPath );

    return aRet;
}

void SetupApp::CheckLanguage()
{
    if ( !m_pCompiledScript || !m_pMainDlg ) return;

    if ( m_pEnv && ! m_pEnv->IsLocal() ) return;
    
    SiInstallation *pInst = m_pCompiledScript->GetInstallation();

    if ( !pInst ) return;

    ByteString aInstLang = pInst->GetInstalledLanguages();
    ByteString aLanguages = pInst->GetLanguages();

    BOOL    bProg, bDoc;
    USHORT  nLang;

    // We first try to use the UI language if installed
    if ( m_pEnv )
    {
        nLang = m_pEnv->GetUILanguage();
        if ( pInst->IsLanguageInstalled( nLang, bProg, bDoc ) )
        {
            if ( GetLanguage() != nLang )
            {
                m_pMainDlg->SwitchLanguage( nLang );
                m_pMainDlg->SetLanguage( nLang );
            }
            return;
        }
    }

    // when the ui language isn't installed, we switch to
    // the first installed language

    USHORT  nDelimTok = 0;
    USHORT  nTokCount = aLanguages.GetTokenCount(',');

    for( USHORT x = 0; x < nTokCount; ++x )
    {
        nLang = (USHORT) aLanguages.GetToken(0, ',', nDelimTok).ToInt32();
        if ( pInst->IsLanguageInstalled( nLang, bProg, bDoc ) )
        {
            if ( GetLanguage() != nLang )
            {
                m_pMainDlg->SwitchLanguage( nLang );
                m_pMainDlg->SetLanguage( nLang );
            }
            return;
        }
    }
}

// -----------------------------------------------------------------------------
static ByteString GetAdabasDir()
{
    ByteString sAdabasRoot;

    // read the DBROOT environment var to check if there is any adabas version installed
    rtl_uString* pDbVar = NULL;
    OUString sTemp = OUString::createFromAscii( "DBROOT" );

    if( osl_getEnvironment( sTemp.pData, &pDbVar ) == osl_Process_E_None && pDbVar )
    {
        OUString aRet;
        String aFileURL;
        if ( FileBase::getFileURLFromSystemPath( OUString( pDbVar ), aRet ) == FileBase::E_None )
        {
            aFileURL = aRet;
            sAdabasRoot = ByteString( aFileURL, osl_getThreadTextEncoding() );
        }
    }
    
    if ( pDbVar )
        rtl_uString_release( pDbVar );

    return sAdabasRoot;
}

// -----------------------------------------------------------------------------
static BOOL IsUpdateAdabas( const ByteString& aCurrentVersion )
{
    BOOL bUpdateOld = TRUE;

    rtl_uString *pCmd = NULL;
    rtl_uString *pArgs = NULL;
    rtl_uString *pWork = NULL;

    oslProcess  aProcess;

    oslFileHandle pIn = NULL;
    oslFileHandle pOut = NULL;
    oslFileHandle pErr = NULL;

    oslProcessError eErr;

    rtl_uString_newFromAscii( &pCmd, "dbversion" );

    eErr = osl_executeProcess_WithRedirectedIO( pCmd, NULL, 0, osl_Process_HIDDEN, osl_getCurrentSecurity(),
                                                pWork, NULL, 0, &aProcess, &pIn, &pOut, &pErr );
    if ( ( eErr == osl_Process_E_None ) && pOut )
    {
        char         pBuf[ 32000 ];
        sal_uInt64   nRead = 0;
        oslFileError eFileErr = osl_readFile( pOut, pBuf, 32000, &nRead );
        ByteString   aVersion;

        while ( eFileErr == osl_File_E_None && nRead )
        {
            aVersion += ByteString( pBuf, (USHORT) nRead );
            eFileErr = osl_readFile( pOut, pBuf, 32000, &nRead );
        }

        if ( aVersion >= aCurrentVersion )
            bUpdateOld = FALSE;

        osl_closeFile( pOut );
    }

    osl_closeFile( pIn );
    osl_closeFile( pErr );
    rtl_uString_release( pCmd );

    return bUpdateOld;
}

