/*************************************************************************
 *
 *  $RCSfile: mainwnd.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 11:04:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000-2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#if defined(WNT)
#include <tools/svwin.h>
#endif

#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif

#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif

#ifndef _SV_SETTINGS_HXX //autogen
#include <vcl/settings.hxx>
#endif

#ifndef _SV_GRADIENT_HXX //autogen
#include <vcl/gradient.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include <tools/l2txtenc.hxx>

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#include "main.hxx"
#include "mainwnd.hxx"
#include "agenda.hxx"
#include "progress.hxx"
#include "texture.hxx"
#include "decltor.hxx"
#include "environ.hxx"
#include "fader.hxx"

#include "app.hrc"
#include "strings.hrc"

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif

#ifndef _SV_OUTDEV_HXX
#include <vcl/outdev.hxx>
#endif

using namespace ::com::sun::star;

//------------------------------------------------------------------------

// #define WALLPAPER_MODE				1

#define COL_SUN_BLUE                Color(RGB_COLORDATA( 0x59, 0x4F, 0xBF ))
#define COL_SUN_YELLOW              Color(RGB_COLORDATA( 0xFB, 0xE2, 0x49 ))
#define COL_SUN_RED                 Color(RGB_COLORDATA( 0xD1, 0x21, 0x24 ))
#define COL_DISABLED                Color(RGB_COLORDATA( 0x66, 0x66, 0x66 ))
#define COL_BORDER                  Color(RGB_COLORDATA( 0xCC, 0xCC, 0xCC ))

#define HEAD_HEIGHT_PERCENT			30
#define HEAD_HEIGHT_MINPIXEL		200
#define HEAD_HEIGHT_MAXPIXEL		260
#define MIN_LOGO_POS                420

#define LEFT_WIDTH_PERCENT			20
#define LEFT_WIDTH_MINPIXEL			180
#define LEFT_WIDTH_MAXPIXEL			180
#define MIN_STATUS_OFFSET           45
#define TEXT_OFFSET                 12

#define DEF_HEADLINE_FONTSIZE_OFFSET	4
#define DEF_INFO_SPACE					10
#define DEF_PROGBAR_DIST_UPPER			20
#define DEF_TIME_DIST					10
#define DEF_TIMEOUT						500
#define DEF_LINE_DIST					2

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

SetupWindow::SetupWindow() :
    WorkWindow			( NULL, WB_APP | WB_STDWORK | WB_CLIPCHILDREN )
{
	m_pHeadWin = NULL;
	m_pLeftWin = NULL;
	m_pContWin = NULL;
}

SetupWindow::~SetupWindow()
{
	delete m_pHeadWin;
	delete m_pLeftWin;
	delete m_pContWin;
}

void SetupWindow::InitChildren( ResMgr* pMgr )
{
    SetPen( Pen(PEN_NULL) );

	m_pHeadWin = new HeadWin( this, 0, pMgr );
	m_pLeftWin = new LeftWin( this, 0, pMgr );
	m_pContWin = new ContWin( this, 0, pMgr );

	SetBackColor();

    m_pHeadWin->Show();
	m_pLeftWin->Show();
	m_pContWin->Show();
}

BOOL SetupWindow::Close()
{
	SiInstallSubMode eInstallSubMode = pSetupApp->GetAgenda() ?
		pSetupApp->GetAgenda()->GetInstallSubMode() : ISM_INVALID;

	if( !pSetupApp->IsResponseMode() && eInstallSubMode != ISM_DELETE )
		pSetupApp->Exit();

	return FALSE;
}

void SetupWindow::Resize()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Size aSz( GetOutputSizePixel() );

	Size aHeadSz( aSz.Width(), aSz.Height() * HEAD_HEIGHT_PERCENT / 100 );
	if( aHeadSz.Height() < HEAD_HEIGHT_MINPIXEL )
		aHeadSz.Height() = HEAD_HEIGHT_MINPIXEL;
	else if( aHeadSz.Height() > HEAD_HEIGHT_MAXPIXEL )
		aHeadSz.Height() = HEAD_HEIGHT_MAXPIXEL;

	Size aLeftSz( aSz.Width() * LEFT_WIDTH_PERCENT / 100, aSz.Height()-aHeadSz.Height() );
	if( aLeftSz.Width() < LEFT_WIDTH_MINPIXEL )
		aLeftSz.Width() = LEFT_WIDTH_MINPIXEL;
	else if( aLeftSz.Width() > LEFT_WIDTH_MAXPIXEL )
		aLeftSz.Width() = LEFT_WIDTH_MAXPIXEL;

	Size aContSz( aSz.Width() - aLeftSz.Width(), aSz.Height() - aHeadSz.Height() );

	m_pHeadWin->SetPosSizePixel( Point(0,0), aHeadSz );
	m_pLeftWin->SetPosSizePixel( Point(0,aHeadSz.Height()), aLeftSz );
	m_pContWin->SetPosSizePixel( Point(aLeftSz.Width(), aHeadSz.Height()), aContSz );

	pSetupApp->MainWindowResize();
}


void SetupWindow::DataChanged( const DataChangedEvent& rDCEvt )
{
    WorkWindow::DataChanged( rDCEvt );

    if( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
    {
        SetBackColor();
    }
}

void SetupWindow::SetBackColor()
{
	// Better support for HighContrast
    BOOL             bIsHC = Application::GetSettings().GetStyleSettings().GetHighContrastMode();
    BOOL             bUseBlack = FALSE;
    const Wallpaper& aBack = GetDisplayBackground();
    const Color&     aBackCol = aBack.GetColor();

    if ( aBackCol.IsDark() )
        bUseBlack = TRUE;

	if ( m_pHeadWin ) m_pHeadWin->SetIsBlack( bUseBlack );
	if ( m_pLeftWin ) m_pLeftWin->SetIsBlack( bUseBlack );
	if ( m_pContWin ) m_pContWin->SetIsBlack( bUseBlack );

    if ( bUseBlack )
    {
        if ( m_pHeadWin ) m_pHeadWin->SetBackground( Wallpaper( Color( COL_BLACK ) ) );
        if ( m_pLeftWin ) m_pLeftWin->SetBackground( Wallpaper( Color( COL_BLACK ) ) );
        if ( m_pContWin ) m_pContWin->SetBackground( Wallpaper( Color( COL_BLACK ) ) );
    }
    else
    {
        if ( m_pHeadWin ) m_pHeadWin->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
        if ( m_pLeftWin ) m_pLeftWin->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
        if ( m_pContWin ) m_pContWin->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
    }

    if ( m_pLeftWin )
    {
        if ( bUseBlack || bIsHC )
            m_pLeftWin->SetUseSysColors( TRUE );
        else
            m_pLeftWin->SetUseSysColors( FALSE );
    }
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

HeadWin::HeadWin( Window* pParent, WinBits nWinBits, ResMgr* pMgr ) :
		Window				( pParent, nWinBits | WB_CLIPCHILDREN )
{
#ifndef OS2
	m_aProductFont = Font( UniString::CreateFromAscii("Arial"), Size(0,36) );
#else
	m_aProductFont = Font( UniString::CreateFromAscii("Helv"), Size(0,36) );
#endif

	m_aProductFont.SetTransparent( TRUE );
	m_aProductFont.SetColor( COL_SUN_BLUE );
	// m_aProductFont.SetShadow( TRUE );

	m_bTextMode = TRUE;

    // We don't want to mirror the bitmaps in the header window, therefor
    // disable rtl automatics
    EnableRTL( FALSE );
}

// -----------------------------------------------------------------------
HeadWin::~HeadWin()
{
}

// -----------------------------------------------------------------------------
void HeadWin::DataChanged( const DataChangedEvent& _rDCEvt )
{
	if (( _rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( _rDCEvt.GetFlags() & SETTINGS_STYLE ))
    {
		// Do some changes for High contrast
		volatile int dummy = 0;
    }

    // call super function
	Window::DataChanged(_rDCEvt);
}

// -----------------------------------------------------------------------
void HeadWin::Paint( const Rectangle& rRect )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( Application::GetAppWindow()->IsMinimized() )
		return ;

    Size aWinSz( GetOutputSizePixel() );
    Size aLogoSz( m_aLogoBMP.GetSizePixel() );
    Size aVendSz( m_aVendorBMP.GetSizePixel() );
    Size aProdSz( m_aProductBMP.GetSizePixel() );

    long nLogoPosX = aWinSz.Width() - aLogoSz.Width();
    long nProdPosY = aWinSz.Height() - aProdSz.Height();
    long nVendPosY = nProdPosY - aVendSz.Height();
    long nBottom   = nProdPosY + aProdSz.Height();

    if ( nLogoPosX < MIN_LOGO_POS )
        nLogoPosX = MIN_LOGO_POS;

    if ( IsBlack() )
        SetBackground( Wallpaper( Color( COL_BLACK ) ) );
    else
        SetBackground( Wallpaper( Color( COL_WHITE ) ) );

    if ( m_bTextMode )
    {
        Font aOld = GetFont();
        SetFont( m_aProductFont );
        DrawText( Point( 22, aWinSz.Height() - 154 ), m_aProductName );
        SetFont( aOld );
    }
    else
    {
        // Draw the vendor image
        if ( IsBlack() )
            DrawImage( Point( 0, nVendPosY ), m_aVendorHC_BMP );
        else
            DrawImage( Point( 0, nVendPosY ), m_aVendorBMP );

        // Draw the logo image
        DrawImage( Point( nLogoPosX, nProdPosY ), m_aLogoBMP );

        // Draw the product image
        Rectangle aClip( 0, nProdPosY, nLogoPosX, nBottom );
        IntersectClipRegion( aClip );
        DrawImage( Point( 0, nProdPosY ), m_aProductBMP );

        SetClipRegion();
    }
}

// -----------------------------------------------------------------------
void HeadWin::Resize()
{
// Unix sends an invalidate automatically, when resizing
#ifndef UNX
    Invalidate();
#endif
}

// -----------------------------------------------------------------------
void HeadWin::SetProductName( const String& rNew )
{
	m_aProductName = rNew;
	m_bTextMode = TRUE;
}

// -----------------------------------------------------------------------
void HeadWin::SetProductBMP( const ByteString& rNew )
{
	Bitmap		aBmp;
	SiDirEntry 	aFileName( pSetupApp->GetEnvironment()->GetStartPath() );
	aFileName += rNew;

	ByteString aAppName( pSetupApp->GetEnvironment()->GetProductName() );
	if( aAppName.ToLowerAscii().Search("suite") != STRING_NOTFOUND )
	{
		ByteString aFName( aFileName.GetBase(), osl_getThreadTextEncoding() );
		aFName += "_cjk";
		aFName += ".";
		aFName += ByteString( aFileName.GetExtension(), osl_getThreadTextEncoding() );

		DirEntry aEntry( aFileName );
		aEntry.SetName( UniString(aFName, osl_getThreadTextEncoding()) );
		if( aEntry.Exists() ) aFileName = aEntry;
	}

	if( !aFileName.Exists() ) {
		SetProductName( UniString(pSetupApp->GetEnvironment()->GetProductName(), osl_getThreadTextEncoding()) );
		return ;
	}

	rtl::OUString aFileURL;
	FileBase::getFileURLFromSystemPath( aFileName.GetFullUni(), aFileURL );

	SvFileStream aSvFileStrm( aFileURL, STREAM_READ );
	aSvFileStrm >> aBmp;

	m_aProductBMP = Image( aBmp, aBmp.CreateMask( COL_LIGHTMAGENTA, 5UL ) );
	m_bTextMode = FALSE;
    Invalidate();
}

// -----------------------------------------------------------------------------
void HeadWin::SetVendorBMP( const ByteString& rNew )
{
	if( !rNew.Len() ) return ;

	Bitmap		aBmp, aBmpHC;
	SiDirEntry 	aFileName( pSetupApp->GetEnvironment()->GetStartPath() );

	aFileName += rNew;
	if( !aFileName.Exists() ) return ;

	rtl::OUString aFileURL;
	FileBase::getFileURLFromSystemPath( aFileName.GetFullUni(), aFileURL );

	SvFileStream aSvFileStrm( aFileURL, STREAM_READ );
	aSvFileStrm >> aBmp;

	m_aVendorBMP = Image( aBmp, aBmp.CreateMask( COL_LIGHTMAGENTA, 5UL ) );

    // Get the HighContrast Bitmap as well
    INetURLObject aHCBmp( aFileURL );
    UniString aBaseName = aHCBmp.getBase();
    aBaseName += UniString::CreateFromAscii( "_hc" );
    aHCBmp.setBase( aBaseName );

	SvFileStream aSvFileStrmHC( aHCBmp.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
	aSvFileStrmHC >> aBmpHC;

	m_aVendorHC_BMP = Image( aBmpHC, aBmpHC.CreateMask( COL_LIGHTMAGENTA, 5UL ) );

    Invalidate();
}

// -----------------------------------------------------------------------------
void HeadWin::SetLogoBMP( const ByteString& rNew )
{
	if( !rNew.Len() ) return ;

	Bitmap		aBmp;
	SiDirEntry 	aFileName( pSetupApp->GetEnvironment()->GetStartPath() );

	aFileName += rNew;
	if( !aFileName.Exists() ) return ;

	rtl::OUString aFileURL;
	FileBase::getFileURLFromSystemPath( aFileName.GetFullUni(), aFileURL );

	SvFileStream aSvFileStrm( aFileURL, STREAM_READ );
	aSvFileStrm >> aBmp;

	m_aLogoBMP = Image( aBmp, aBmp.CreateMask( COL_LIGHTMAGENTA, 5UL ) );

    Invalidate();
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

LeftWin::LeftWin( Window* pParent, WinBits nWinBits, ResMgr* pMgr ) :
		Window	   			( pParent, nWinBits | WB_CLIPCHILDREN ),
		m_aClockImg			( ResId(IMG_CLOCK, pMgr) ),
		m_aHC_ClockImg		( ResId(IMG_CLOCK_HC, pMgr) ),
		m_aFTPrepare		( this, ResId(FT_INSTINFO_PREPARE, pMgr) ),
		m_aFTMkDir	   		( this, ResId(FT_INSTINFO_MKDIR, pMgr) ),
		m_aFTCopy			( this, ResId(FT_INSTINFO_COPY, pMgr) ),
		m_aFTLocal			( this, ResId(FT_INSTINFO_LOCAL, pMgr) ),
		m_aFTRegisterUno	( this, ResId(FT_INSTINFO_REGUNOCOMPONENT, pMgr) ),
		m_aFTChange			( this, ResId(FT_INSTINFO_CHANGE, pMgr) ),
		m_aFTDelete			( this, ResId(FT_INSTINFO_DELETE, pMgr) ),
		m_aFTRmDir			( this, ResId(FT_INSTINFO_RMDIR, pMgr) ),
		m_aFTUnregister		( this, ResId(FT_INSTINFO_UNREGISTER, pMgr) ),
		m_aFTRecoverFiles	( this, ResId(FT_INSTINFO_RECOVER_FILES, pMgr) ),
		m_aFTRecoverLocal	( this, ResId(FT_INSTINFO_RECOVER_LOCAL, pMgr) ),
		m_aFTRecoverHelp	( this, ResId(FT_INSTINFO_RECOVER_HELP, pMgr) ),

		m_aAnimator(this, pMgr)
{
	m_pProgress = NULL;
	m_bInProgress = FALSE;
    m_bUseSysColors = FALSE;
    m_bSetColors = TRUE;
    m_bShowInstInfo = FALSE;

	m_eOldActionType = AT_UNKNOWN;

	m_aTimer.SetTimeout( DEF_TIMEOUT );
	m_aTimer.SetTimeoutHdl( LINK(this, LeftWin, TimeoutHdl) );

	ShowInstInfo( FALSE );
}

LeftWin::~LeftWin()
{
}

void LeftWin::Resize()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Size aSz( GetSizePixel() );
    Size aOffset = LogicToPixel( Size( 5, 30 ), MapMode( MAP_APPFONT ) );
    long nOffsetY = aSz.Height() * 12 / 100;

    if ( nOffsetY < MIN_STATUS_OFFSET )
        nOffsetY = MIN_STATUS_OFFSET;

    long nOffsetX = TEXT_OFFSET;

    m_aFTPrepare.SetPosPixel      ( Point( nOffsetX, nOffsetY ) );
    m_aFTUnregister.SetPosPixel   ( Point( nOffsetX, nOffsetY ) );

    m_aFTMkDir.SetPosPixel        ( Point( nOffsetX, nOffsetY + aOffset.Height() ) );
    m_aFTDelete.SetPosPixel       ( Point( nOffsetX, nOffsetY + aOffset.Height() ) );

    m_aFTCopy.SetPosPixel         ( Point( nOffsetX, nOffsetY + 2 * aOffset.Height() ) );
    m_aFTChange.SetPosPixel       ( Point( nOffsetX, nOffsetY + 2 * aOffset.Height() ) );
    m_aFTRecoverFiles.SetPosPixel ( Point( nOffsetX, nOffsetY + 2 * aOffset.Height() ) );
    m_aFTRmDir.SetPosPixel        ( Point( nOffsetX, nOffsetY + 2 * aOffset.Height() ) );

    m_aFTRegisterUno.SetPosPixel  ( Point( nOffsetX, nOffsetY + 3 * aOffset.Height() ) );

    m_aFTLocal.SetPosPixel        ( Point( nOffsetX, nOffsetY + 4 * aOffset.Height() ) );
    m_aFTRecoverLocal.SetPosPixel ( Point( nOffsetX, nOffsetY + 4 * aOffset.Height() ) );
    m_aFTRecoverHelp.SetPosPixel  ( Point( nOffsetX, nOffsetY + 4 * aOffset.Height() ) );
	
    long nWidth = aSz.Width() - nOffsetX;

	if( m_bInProgress && m_pProgress )
    {
        m_pProgress->SetPosSizePixel(
                Point( nOffsetX, m_aFTLocal.GetPosPixel().Y() + m_aFTLocal.GetSizePixel().Height() +
                       DEF_PROGBAR_DIST_UPPER),
                Size( nWidth, m_pProgress->GetSizePixel().Height()) );
    }

    m_aFTLocal.SetSizePixel        ( Size( nWidth, m_aFTLocal.GetSizePixel().Height()) );
    m_aFTPrepare.SetSizePixel      ( Size( nWidth, m_aFTPrepare.GetSizePixel().Height()) );
    m_aFTMkDir.SetSizePixel        ( Size( nWidth, m_aFTMkDir.GetSizePixel().Height()) );
    m_aFTCopy.SetSizePixel         ( Size( nWidth, m_aFTCopy.GetSizePixel().Height()) );
    m_aFTRegisterUno.SetSizePixel  ( Size( nWidth, m_aFTRegisterUno.GetSizePixel().Height()) );
    m_aFTChange.SetSizePixel       ( Size( nWidth, m_aFTChange.GetSizePixel().Height()) );
    m_aFTDelete.SetSizePixel       ( Size( nWidth, m_aFTDelete.GetSizePixel().Height()) );
    m_aFTRmDir.SetSizePixel        ( Size( nWidth, m_aFTRmDir.GetSizePixel().Height()) );
    m_aFTUnregister.SetSizePixel   ( Size( nWidth, m_aFTUnregister.GetSizePixel().Height()) );
    m_aFTRecoverFiles.SetSizePixel ( Size( nWidth, m_aFTRecoverFiles.GetSizePixel().Height()) );
    m_aFTRecoverLocal.SetSizePixel ( Size( nWidth, m_aFTRecoverLocal.GetSizePixel().Height()) );
    m_aFTRecoverHelp.SetSizePixel  ( Size( nWidth, m_aFTRecoverHelp.GetSizePixel().Height()) );
}

// -----------------------------------------------------------------------------
void LeftWin::Paint( const Rectangle& rRect )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( Application::GetAppWindow()->IsMinimized() )
		return ;

    if ( m_bShowInstInfo && m_bSetColors )
    {
        SetActionType( m_eOldActionType, TRUE );
        m_bSetColors = FALSE;
    }
    
    if ( IsBlack() )
        SetBackground( Wallpaper( Color( COL_BLACK ) ) );
    else
        SetBackground( Wallpaper( Color( COL_WHITE ) ) );

	Erase();
    
    if( m_bInProgress )
	{
		DrawTime( &m_aLastTime );
	}
	// repaint Animation
	m_aAnimator.Paint();
}

// -----------------------------------------------------------------------------
void LeftWin::DataChanged( const DataChangedEvent& _rDCEvt )
{
    // call super function
	Window::DataChanged(_rDCEvt);

	// set all text colors
	// SetFTColor( m_aFTPrepare, TRUE );
	
    // Language Changed?
    if (( _rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( _rDCEvt.GetFlags() & SETTINGS_UILOCALE ))
    {
        LanguageChanged();
    }

    if (( _rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( _rDCEvt.GetFlags() & SETTINGS_STYLE ))
    {
        SetActionType( m_eOldActionType, TRUE );

		// Do some changes for High contrast
		volatile int dummy = 0;
    }
}

void LeftWin::StartProgress()
{
	if( m_pProgress )
		delete m_pProgress;

	Point aFTPos = m_aFTLocal.GetPosPixel();
    Size  aFTSize = m_aFTLocal.GetSizePixel();

    m_pProgress = new SiProgressBar( this );
	m_pProgress->SetIsBlack( IsBlack() );
	m_pProgress->SetPosSizePixel(
		Point( aFTPos.X(), aFTPos.Y() + aFTSize.Height() + DEF_PROGBAR_DIST_UPPER ),
        Size( aFTSize.Width()-14, 19) );

	DrawTime( NULL );
	m_pProgress->Show();

	m_lGuess 	= 9999999;
	m_nPercent	= 0;

	m_aStopWatch.Start();
	m_aTimer.Start();
	m_bInProgress = TRUE;
}

void LeftWin::StopProgress()
{
	m_bInProgress = FALSE;

	m_aStopWatch.Stop();
	m_aTimer.Stop();

	ShowInstInfo( FALSE, eActiveMode );
	DrawTime( NULL );

	StopUnknownProgress();
	if( m_pProgress )
		delete m_pProgress;
	m_pProgress = NULL;
}

void LeftWin::DrawTime( Time* pTime )
{
	if( !m_pProgress )
		return;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	USHORT nY = (USHORT) ( m_pProgress->GetPosPixel().Y() + m_pProgress->GetSizePixel().Height() +
		DEF_TIME_DIST );

    if( !pTime )
	{
		Rectangle aRect( Point( 0, nY ), Size( GetSizePixel().Width(), 30 ) );
		Invalidate( aRect );
//		Update();
		return;
	}

	Time aDrawTime = *pTime;

    const LocaleDataWrapper& rWrap = Application::GetSettings().GetUILocaleDataWrapper();
    String sTime( rWrap.getDuration( aDrawTime ) );

    Color aFillColor;

    if ( IsBlack() )
        aFillColor = Color( COL_BLACK );
    else
        aFillColor = Color( COL_WHITE );

    Color aOldLineCol( GetLineColor() );
    Color aOldFillColor( GetFillColor() );
    SetLineColor();
    SetFillColor( aFillColor );
    DrawRect( Rectangle(Point(2, nY), Size(GetSizePixel().Width()-4, 30)));
    SetLineColor( aOldLineCol );
    SetFillColor( aOldFillColor );

	Color aTextColor;
    
    if ( UseSysColors() )
    {
        AllSettings		aASettings( Application::GetSettings() );
        StyleSettings	aStyle( aASettings.GetStyleSettings() );

        aTextColor = aStyle.GetLabelTextColor();
    }
    else
        aTextColor = Color( COL_SUN_BLUE );

    Font aOld( GetFont() );
	Font aFont( aOld );

	aFont.SetTransparent( FALSE );
	aFont.SetColor( aTextColor );
    aFont.SetFillColor( aFillColor );

	SetFont( aFont );
	DrawText( Point(12+35, nY + 5), sTime );
	if ( IsBlack() )
        DrawImage( Point(12, nY), m_aHC_ClockImg );
    else
        DrawImage( Point(12, nY), m_aClockImg );
	SetFont( aOld );
}

void LeftWin::StartUnknownProgress()
{
	sal_Int32 nYPos = m_aFTLocal.GetPosPixel().Y() + m_aFTLocal.GetSizePixel().Height() + DEF_PROGBAR_DIST_UPPER;
	Point aPoint(12, nYPos);
	m_aAnimator.SetPos(aPoint);
	m_aAnimator.StartAnim( IsBlack() );
}

void LeftWin::StopUnknownProgress()
{
	m_aAnimator.StopAnim();
}

void LeftWin::SetPercentage( USHORT nPercent )
{
	if( !m_pProgress )
		return ;
	m_nPercent = nPercent;
	m_pProgress->SetPercent( m_nPercent );
}

void LeftWin::ShowInstInfo( BOOL bShow, SiInstallSubMode eMode, SiEnvironment* pEnv,
							USHORT nUserProf, USHORT nMaxProf )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	eActiveMode = eMode;
    m_bShowInstInfo = bShow;

	if( !bShow )
	{
		m_aFTPrepare.Hide();
		m_aFTMkDir.Hide();
		m_aFTCopy.Hide();
		m_aFTLocal.Hide();
		m_aFTRegisterUno.Hide();
		m_aFTChange.Hide();
		m_aFTRecoverFiles.Hide();
		m_aFTRecoverLocal.Hide();
		m_aFTRecoverHelp.Hide();
		m_aFTDelete.Hide();
		m_aFTRmDir.Hide();
		m_aFTUnregister.Hide();
	}
	else if( eActiveMode == ISM_ADD )
	{
		if( !pEnv || !pEnv->IsUpdateOldVersion() )
			m_aFTPrepare.Show();

		m_aFTMkDir.Show();
		m_aFTCopy.Show();
		m_aFTLocal.Show();
		m_aFTRegisterUno.Show();
	}
	else if( eActiveMode == ISM_DELETE )
	{
		m_aFTDelete.Show();
		m_aFTRmDir.Show();
		m_aFTUnregister.Show();
	}
	else if( eActiveMode == ISM_CHANGE )
	{
		m_aFTChange.Show();
		m_aFTLocal.Show();
		m_aFTRegisterUno.Show();
	}
	else if( eActiveMode == ISM_RECOVER )
	{
		m_aFTRecoverFiles.Show();
		m_aFTRecoverLocal.Show();
		m_aFTRegisterUno.Show();
	}
	else if( eActiveMode == ISM_APPSERVER_USER )
	{
		String aStr( ResId(STR_APPSERVER_USER_INSTALL, (ResMgr*)pSetupApp->GetResManager()) );
		aStr.SearchAndReplace( UniString::CreateFromAscii("%1"),
							   UniString::CreateFromInt32(nUserProf) );
		aStr.SearchAndReplace( UniString::CreateFromAscii("%2"),
							   UniString::CreateFromInt32(nMaxProf) );

		m_aFTPrepare.SetText( aStr );
		m_aFTPrepare.Show();
		m_aFTMkDir.Show();
		m_aFTCopy.Show();
		m_aFTLocal.Show();
	}
}

void LeftWin::SetActionType( SiActionType eType,
                             BOOL bForceSetting )
{
	if( ( eType == m_eOldActionType || eType == AT_PROCEDURE ) &&
        ! bForceSetting )
		return ;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( eType == AT_HELP || eType == AT_REGISTER || eType == AT_REGUNO )
	{
		m_bInProgress = FALSE;
		DrawTime( NULL );

		m_aStopWatch.Stop();
		m_aTimer.Stop();

		if( m_pProgress )
			delete m_pProgress;
		m_pProgress = NULL;

		StartUnknownProgress();
	}

	if( eActiveMode == ISM_ADD || eActiveMode == ISM_APPSERVER_USER )
	{
		if ( eType != AT_MAKEDIR && eType != AT_COPY && eType != AT_UNZIP &&
             eType != AT_REGISTER && eType != AT_CONFIGURATION && eType != AT_REGUNO )
            SetFTColor( m_aFTPrepare, TRUE );
        else
            SetFTColor( m_aFTPrepare, eActiveMode == ISM_APPSERVER_USER? TRUE : FALSE );

        SetFTColor( m_aFTMkDir,	eType == AT_MAKEDIR ? TRUE : FALSE );
		SetFTColor( m_aFTCopy,	eType == AT_COPY || eType == AT_UNZIP ? TRUE : FALSE );
		SetFTColor( m_aFTLocal, (eType == AT_REGISTER || eType == AT_CONFIGURATION ) ? TRUE : FALSE );
		SetFTColor( m_aFTRegisterUno, eType == AT_REGUNO ? TRUE : FALSE );
	}
	else if( eActiveMode == ISM_DELETE )
	{
		SetFTColor( m_aFTDelete,	eType == AT_DELETE ? TRUE : FALSE );
		SetFTColor( m_aFTRmDir,		eType == AT_RMDIR ? TRUE : FALSE );
		SetFTColor( m_aFTUnregister,eType == AT_UNREGISTER ? TRUE : FALSE );
	}
	else if( eActiveMode == ISM_CHANGE )
	{
		SetFTColor( m_aFTChange, eType == AT_DELETE || eType == AT_COPY || eType == AT_UNZIP ? TRUE : FALSE );
		SetFTColor( m_aFTRegisterUno, eType == AT_REGUNO ? TRUE : FALSE );
		SetFTColor( m_aFTLocal, eType == (AT_REGISTER || eType == AT_CONFIGURATION ) ? TRUE : FALSE );
	}
	else if( eActiveMode == ISM_RECOVER )
	{
		SetFTColor( m_aFTRecoverFiles, eType == AT_MAKEDIR || eType == AT_COPY || eType == AT_UNZIP ? TRUE : FALSE );
		SetFTColor( m_aFTRecoverLocal, (eType == AT_REGISTER || eType == AT_CONFIGURATION)  ? TRUE : FALSE );
		SetFTColor( m_aFTRegisterUno, eType == AT_REGUNO ? TRUE : FALSE );
	}

	Update();
	m_eOldActionType = eType;
}

// -----------------------------------------------------------------------------
void FixedTextDC::DataChanged( const DataChangedEvent& _rDCEvt)
{
	if (( _rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( _rDCEvt.GetFlags() & SETTINGS_STYLE ))
	{
		if (! m_bAllowChanges)
		{
			// we want to hold our old colors,
			// so UNDO to old StyleSettings
			AllSettings aASettings( GetSettings() );
			const AllSettings aOldAllSettings ( *(_rDCEvt.GetOldSettings()) );

			aASettings.SetStyleSettings( aOldAllSettings.GetStyleSettings() );

			m_bAllowChanges = TRUE; // suppress recursion
			SetSettings( aASettings );
			m_bAllowChanges = FALSE;
		}
	}

	FixedText::DataChanged(_rDCEvt);
}
// -----------------------------------------------------------------------------

void LeftWin::SetFTColor( FixedTextDC& rText, BOOL bActive )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Color			aColor( bActive? COL_SUN_BLUE : COL_DISABLED );
    AllSettings		aASettings( rText.GetSettings() );
	StyleSettings	aStyle( aASettings.GetStyleSettings() );

	if ( UseSysColors() )
    {
        AllSettings	  aSysSettings( Application::GetSettings() );
        StyleSettings aSysStyle( aSysSettings.GetStyleSettings() );

        aColor = aSysStyle.GetLabelTextColor();
        if ( bActive )
            rText.Enable();
        else
            rText.Disable();
    }
    else
        rText.Enable();
    
    Font aFont( aStyle.GetLabelFont() );
	if( bActive )
	{
		aFont.SetWeight( WEIGHT_BOLD );
	}
	else
	{
		aFont.SetWeight( WEIGHT_NORMAL );
	}
	aStyle.SetLabelFont( aFont );
	aStyle.SetLabelTextColor( aColor );

	aASettings.SetStyleSettings( aStyle );

    if ( IsBlack() )
        rText.SetControlBackground( Color( COL_BLACK ) );
    else
        rText.SetControlBackground( Color( COL_WHITE ) );
    
    rText.m_bAllowChanges = TRUE;
	rText.SetSettings( aASettings );
	rText.Update();
	rText.Flush();
	rText.m_bAllowChanges = FALSE;

    if ( bActive && Application::GetAppWindow()->IsActive() )
        rText.GrabFocus();
}

IMPL_LINK( LeftWin, TimeoutHdl, void*, EMPTYARG )
{
	if( m_nPercent > 0 )
	{
		Time	aTime = m_aStopWatch.GetDuration();
		long	lGuess = ((aTime.GetMSFromTime() / 1000) * 100) / m_nPercent;
		if( m_lGuess <= 0 )
		{
			m_lGuess = lGuess;
			return 0;
		}
		double	dDiff  = double(lGuess) / double(m_lGuess);

		if( dDiff > 0.9 && dDiff < 1.0 )
		{
			Time aNewTime;

			aNewTime.MakeTimeFromMS(1000*lGuess);
			aNewTime -= aTime;

			if( ((aNewTime.GetMSFromTime() / 1000) > 0) &&
				aNewTime < m_aLastTime )
			{
				m_aLastTime = aNewTime;
				DrawTime( &m_aLastTime );
			}
		}
		m_lGuess = lGuess;
	}
	return 0;
}

// -----------------------------------------------------------------------
void LeftWin::LanguageChanged()
{
    ResMgr* pMgr = pSetupApp->GetResManager();
    
    FixedText aFTPrepare	    ( this, ResId(FT_INSTINFO_PREPARE, pMgr) );
    FixedText aFTMkDir	   		( this, ResId(FT_INSTINFO_MKDIR, pMgr) );
    FixedText aFTCopy			( this, ResId(FT_INSTINFO_COPY, pMgr) );
    FixedText aFTLocal			( this, ResId(FT_INSTINFO_LOCAL, pMgr) );
    FixedText aFTRegisterUno    ( this, ResId(FT_INSTINFO_REGUNOCOMPONENT, pMgr) );
    FixedText aFTChange			( this, ResId(FT_INSTINFO_CHANGE, pMgr) );
    FixedText aFTDelete			( this, ResId(FT_INSTINFO_DELETE, pMgr) );
    FixedText aFTRmDir			( this, ResId(FT_INSTINFO_RMDIR, pMgr) );
    FixedText aFTUnregister		( this, ResId(FT_INSTINFO_UNREGISTER, pMgr) );
    FixedText aFTRecoverFiles	( this, ResId(FT_INSTINFO_RECOVER_FILES, pMgr) );
    FixedText aFTRecoverLocal	( this, ResId(FT_INSTINFO_RECOVER_LOCAL, pMgr) );
    FixedText aFTRecoverHelp	( this, ResId(FT_INSTINFO_RECOVER_HELP, pMgr) );

    m_aFTPrepare.SetText(   aFTPrepare.GetText() );
    m_aFTMkDir.SetText(     aFTMkDir.GetText() );
    m_aFTCopy.SetText(      aFTCopy.GetText() );
    m_aFTLocal.SetText(     aFTLocal.GetText() );
    m_aFTRegisterUno.SetText( aFTRegisterUno.GetText() );
    m_aFTChange.SetText(    aFTChange.GetText() );
    m_aFTDelete.SetText(    aFTDelete.GetText() );
    m_aFTRmDir.SetText(     aFTRmDir.GetText() );
    m_aFTUnregister.SetText( aFTUnregister.GetText() );
    m_aFTRecoverFiles.SetText( aFTRecoverFiles.GetText() );
    m_aFTRecoverLocal.SetText( aFTRecoverLocal.GetText() );
    m_aFTRecoverHelp.SetText( aFTRecoverHelp.GetText() );
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

ContWin::ContWin( Window* pParent, WinBits nWinBits, ResMgr* pMgr ) :
		Window		(pParent, nWinBits | WB_CLIPCHILDREN ),
		m_aTextPos	( 0, 0 )
{
#ifdef WALLPAPER_MODE
	Bitmap aBmp( ResId(STAR_TEXTURE, pMgr) );
	m_pTexture = new Texture;
	m_pTexture->SetStyle( TEXTURE_TILE );
	m_pTexture->SetBitmap( aBmp );
#else
	m_pTexture	= NULL;
#endif

	m_pActSlide = NULL;
	m_pVDev 	= NULL;
	m_bDoFade	= FALSE;
}

ContWin::~ContWin()
{
#ifdef WALLPAPER_MODE
	delete m_pTexture;
#endif

	if( m_pVDev )
		delete m_pVDev;
}

// -----------------------------------------------------------------------------
void ContWin::DataChanged( const DataChangedEvent& _rDCEvt )
{
    if (( _rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( _rDCEvt.GetFlags() & SETTINGS_STYLE ))
    {
        // Do some changes for High contrast
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
        delete m_pVDev;
        m_pVDev = NULL;
        Invalidate();
    }
    // call super function
    Window::DataChanged(_rDCEvt);
}

// -----------------------------------------------------------------------------
void ContWin::Resize()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	delete m_pVDev;
	m_pVDev = NULL;
	Invalidate();
}

void ContWin::Paint( const Rectangle& rRect )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( Application::GetAppWindow()->IsMinimized() )
		return ;

    if ( IsBlack() )
        SetBackground( Wallpaper( Color( COL_BLACK ) ) );
    else
        SetBackground( Wallpaper( Color( COL_WHITE ) ) );

	ReDrawVDev();
}

presentation::FadeEffect _StrAsFadeType(const ByteString& rStr)
{
	if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_LEFT") == COMPARE_EQUAL )			return presentation::FadeEffect_FADE_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_TOP") == COMPARE_EQUAL )		return presentation::FadeEffect_FADE_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_FADE_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_TO_CENTER") == COMPARE_EQUAL )		return presentation::FadeEffect_FADE_TO_CENTER;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_CENTER") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_CENTER;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_MOVE_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_TOP") == COMPARE_EQUAL )		return presentation::FadeEffect_MOVE_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_MOVE_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_MOVE_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_ROLL_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_TOP") == COMPARE_EQUAL )		return presentation::FadeEffect_ROLL_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_ROLL_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_ROLL_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_HORIZONTAL_STRIPES") == COMPARE_EQUAL )	return presentation::FadeEffect_HORIZONTAL_STRIPES;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_VERTICAL_STRIPES") == COMPARE_EQUAL )	return presentation::FadeEffect_VERTICAL_STRIPES;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_CLOCKWISE") == COMPARE_EQUAL )			return presentation::FadeEffect_CLOCKWISE;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_COUNTERCLOCKWISE") == COMPARE_EQUAL )	return presentation::FadeEffect_COUNTERCLOCKWISE;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_UPPERLEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_UPPERLEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_UPPERRIGHT") == COMPARE_EQUAL )return presentation::FadeEffect_FADE_FROM_UPPERRIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_LOWERLEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_LOWERLEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_LOWERRIGHT") == COMPARE_EQUAL )return presentation::FadeEffect_FADE_FROM_LOWERRIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_CLOSE_VERTICAL") == COMPARE_EQUAL )		return presentation::FadeEffect_CLOSE_VERTICAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_CLOSE_HORIZONTAL") == COMPARE_EQUAL )	return presentation::FadeEffect_CLOSE_HORIZONTAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_OPEN_VERTICAL") == COMPARE_EQUAL )		return presentation::FadeEffect_OPEN_VERTICAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_OPEN_HORIZONTAL") == COMPARE_EQUAL )		return presentation::FadeEffect_OPEN_HORIZONTAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALIN_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALIN_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALIN_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALIN_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALOUT_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALOUT_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALOUT_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALOUT_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_DISSOLVE") == COMPARE_EQUAL )			return presentation::FadeEffect_DISSOLVE;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_LEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_WAVYLINE_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_TOP") == COMPARE_EQUAL )	return presentation::FadeEffect_WAVYLINE_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_RIGHT") == COMPARE_EQUAL )	return presentation::FadeEffect_WAVYLINE_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_BOTTOM") == COMPARE_EQUAL )return presentation::FadeEffect_WAVYLINE_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_RANDOM") == COMPARE_EQUAL )				return presentation::FadeEffect_RANDOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_LEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_TOP") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_RIGHT") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_HORIZONTAL_LINES") == COMPARE_EQUAL )	return presentation::FadeEffect_HORIZONTAL_LINES;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_VERTICAL_LINES") == COMPARE_EQUAL )		return presentation::FadeEffect_VERTICAL_LINES;
	return presentation::FadeEffect_NONE;
}

void ContWin::ReDrawVDev()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
	BOOL bNormalPaint = TRUE;
	if( !m_pVDev )
	{
		m_pVDev = new VirtualDevice( *this );

        if ( IsBlack() )
            m_pVDev->SetBackground( Wallpaper( Color( COL_BLACK ) ) );
        else
            m_pVDev->SetBackground( Wallpaper( Color( COL_WHITE ) ) );

		m_pVDev->SetOutputSizePixel( GetOutputSizePixel() );

#ifdef WALLPAPER_MODE
		DrawTexture( m_pVDev, *m_pTexture );
#endif

		if( m_pActSlide )
		{
			DrawSlideBitmap( m_pVDev );
			DrawSlideText( m_pVDev, FALSE );
			DrawSlideText( m_pVDev );
		}

		if( m_bDoFade )
		{
			Fader* pFader = new Fader( this );
			pFader->SetEffect( m_eFadeType );
			pFader->SetSpeed( m_eFadeSpeed );
			pFader->SetSource(Rectangle( Point(), GetOutputSizePixel()) );
			pFader->SetTarget(Rectangle( Point(), GetOutputSizePixel()) );
			pFader->SetNewVirtualDevice( m_pVDev );
			pFader->Fade();
			delete pFader;

			m_bDoFade = FALSE;
			bNormalPaint = FALSE;
		}
	}

	if( bNormalPaint )
	{
		DrawOutDev( Point(0, 0), GetOutputSizePixel(), Point(0, 0),
					m_pVDev->GetOutputSizePixel(), *m_pVDev );
	}
}

void ContWin::Reset()
{
	delete m_pVDev;
	m_pVDev = NULL;

	m_pActSlide = NULL;

	ReDrawVDev();
}

void ContWin::AnimSlide( const SiSlide* pSlide )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	m_pActSlide = NULL;

	if( pSlide->HasLangRef() )
	{
		m_pActSlide = (SiSlide*)((SiSlide*)pSlide)->GetLangRef( pSetupApp->GetLanguage() );
		if( m_pActSlide ) m_pActSlide->JoinWithParent();
	}
	if( !m_pActSlide )
		m_pActSlide = (SiSlide*)pSlide;

	Bitmap		aBmp;
	SiDirEntry 	aFileName( pSetupApp->GetEnvironment()->GetStartPath() );

	aFileName += pSlide->GetBmpFileName();
	aFileName.ToAbs();

	SvFileStream aSvFileStrm( aFileName.GetFullUni(), STREAM_READ );
	aSvFileStrm >> aBmp;

	m_aImg = Image( aBmp, aBmp.CreateMask( COL_LIGHTMAGENTA, 5UL ) );

#if defined(WNT)
	if( m_pActSlide->GetWaveFileName().Len() )
	{
		aFileName = pSetupApp->GetEnvironment()->GetStartPath();
		aFileName += m_pActSlide->GetWaveFileName();
		if( aFileName.Exists() )
			PlaySound( aFileName.GetFull().GetBuffer(), NULL, SND_ASYNC | SND_FILENAME );
	}
#endif

	if( m_pVDev )
	{
		delete m_pVDev;
		m_pVDev = NULL;
	}

	if( pSlide->GetFadeType().Len() )
	{
		m_eFadeType = _StrAsFadeType( pSlide->GetFadeType() );
		if( pSlide->GetFadeSpeed().CompareIgnoreCaseToAscii("SLOW") == COMPARE_EQUAL )
			m_eFadeSpeed = FADE_SPEED_SLOW;
		else if( pSlide->GetFadeSpeed().CompareIgnoreCaseToAscii("FAST") == COMPARE_EQUAL )
			m_eFadeSpeed = FADE_SPEED_FAST;
		else
			m_eFadeSpeed = FADE_SPEED_MEDIUM;

		m_bDoFade = TRUE;
	}
	ReDrawVDev();
}

void ContWin::DrawSlideBitmap( OutputDevice* pOutDev )
{
	if( !m_pActSlide )
		return ;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Size  aSz( GetOutputSizePixel() );
	Size  aImgSz( m_aImg.GetSizePixel() );
	Point aPt( ((aSz.Width() - aImgSz.Width())/2),
			   ((aSz.Height() - aImgSz.Height())/2) );

	pOutDev->DrawImage(aPt, m_aImg);
}


void ContWin::DrawSlideText( OutputDevice* pOutDev, BOOL bDraw )
{
	if( !m_pActSlide )
		return ;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Font aFont;
	aFont = GetSettings().GetStyleSettings().GetAppFont();

	aFont.SetCharSet( Langcode2TextEncoding(pSetupApp->GetLanguage()) );
	aFont.SetTransparent( TRUE );
	aFont.SetColor( Color(COL_WHITE) );
	// aFont.SetWeight( WEIGHT_BOLD );

	Font aOld( pOutDev->GetFont() );
	pOutDev->SetFont( aFont );

	ByteString aText( m_pActSlide->GetText() );
	while( aText.Search("\\n") != STRING_NOTFOUND )
		aText.SearchAndReplace( "\\n", "\n" );

	USHORT	nLine		= 0;
	USHORT	nParts		= aText.GetTokenCount('\n');
	ULONG  	nLastY		= m_aTextPos.Y();

	for( USHORT i=0; i < nParts; i++ )
	{
		ByteString	s			( aText.GetToken(i, '\n') );
		UniString	aUniText	( s.GetBuffer(), Langcode2TextEncoding(pSetupApp->GetLanguage()) );

		USHORT c = 0;

		if( i != 0 )
			nLine++;

		if( !aUniText.Len() )
			nLine++;

		else while( c < aUniText.Len() )
		{
			USHORT j;
			// UniString aUniText( s.GetBuffer(), Langcode2TextEncoding(pSetupApp->GetLanguage()) );
			if( nLine == 0)
				j = pOutDev->GetTextBreak( aUniText, 1000, c );
			else
				j = pOutDev->GetTextBreak( aUniText, m_pActSlide->GetTextSize().Width(), c );

			if( j != (USHORT)-1 )
			{
				USHORT nLength = j-c+1;
				USHORT nGoBack = 0;

				while( nLength - nGoBack > 0 && aUniText.GetChar(j-nGoBack) != ' ' )
					nGoBack++;

				if( (nLength - nGoBack) == 0 || (nLine == 0) )
					nGoBack = 0;

				if( bDraw )
				{
					if( nLine == 0 )
					{
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize() + DEF_HEADLINE_FONTSIZE_OFFSET) );
						pOutDev->SetFont(aFont);
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c, nLength - nGoBack );
						ULONG nHeight = pOutDev->GetFont().GetSize().Height();
						nLastY += nHeight + nHeight / 2;
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize()) );
						pOutDev->SetFont(aFont);
					}
					else
					{
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c, nLength - nGoBack );
						nLastY += pOutDev->GetFont().GetSize().Height() + DEF_LINE_DIST;
					}
				}
				c = j+1-nGoBack;
				nLine++;
			}
			else
			{
				if( bDraw )
				{
					if( nLine == 0 )
					{
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize() + DEF_HEADLINE_FONTSIZE_OFFSET) );
						pOutDev->SetFont(aFont);
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c );

						ULONG nHeight = pOutDev->GetFont().GetSize().Height();
						nLastY += nHeight + nHeight / 2;
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize()) );
						pOutDev->SetFont(aFont);
					}
					else
					{
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c );
						nLastY += pOutDev->GetFont().GetSize().Height() + DEF_LINE_DIST;
					}
				}
				c = j;
			}
			nLine++;
		}
	}


	Size aMySz( GetOutputSizePixel() );
	Size aImgSz( m_aImg.GetSizePixel() );
	Point aPt( ((aMySz.Width() - aImgSz.Width())/2),
			   ((aMySz.Height() - aImgSz.Height())/2) );

	m_aTextPos = aPt;
	m_aTextPos += m_pActSlide->GetBmpPos();

	pOutDev->SetFont( aOld );
}

// -----------------------------------------------------------------------------
// ---------------------------- external prototypes ----------------------------
// -----------------------------------------------------------------------------
extern BOOL ImportGIF(SvStream& rStm, Graphic& rGraphic, void* pCallerData);

////////////////////////////////////////////////////////////////////////////////
// BinaryResLoader
//

class BinaryResLoader : public Resource
{
public:
	BinaryResLoader( SvMemoryStream& rStrm, const ResId& rId );
};
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// Due to some trouble with BinaryResLoader we(LLA, OK) have decide to insert the animation here.
// to create this, take X.exe (giftotxt.exe) and create the output.
// insert the output here.
// take a picture program and get the picture size

char pProgressAnim[2560] =
{
	"GIF89a\245\0\17\0\221\0\0YO\277\333\336\337\377\377\377\0\0\0!\377\13NETSCAPE2.0\3\1\0\0\0!\376\35Built with GIF Movie Gear 3.0\0!\371\4"
	"\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2x\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32\31\300\266\300\352\262\350L\327\366M\253X,\357<\16\14\12\207#\235\200\367\362\305\210\314\246\263fD\302\226\317\252\365\252\211\376"
	"\224.\254\367K\324R\217[\260\371\214\22w\271-\264\373\35R\267\331=\270\375.\257K\357\374w>I6\326\67\370\365\67\265F\230xe\244\330\70h\1\31)9IY\11Y\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\211\214\217"
	"\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32\31\300\266\300\352\262p\214\326\366\215\347i0\273}\373\223\351\206\304\242\21\243\302\304\204\202\345K\271<J\247\324P\262\31\205\322\264\276\252\367+\275:\203O\354\26\214N\333\304Ys\327\15"
	"T\313\347\42\366y\314\215\323\367|$/\317\204\7\307\324W\250f\367&(h\310\370\205\250\247\330\326\70\71\365\30\330\266H\251It\265\351\271i\21*:JZj\32Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\211\214\217\251\313"
	"\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32#\300\266@\346\266p\374\242\366\215\347\271*\322\265\340\233\305t\304\242\261\310\13\5\61K \355\10\215J?IP\363\372\234j\267\306\352\7;df\271\344\262\311\353\1\273\204k\263\373\355Aw"
	"\324\62q\30\216\207\313\71t\26\273\236\27X\266\267\321\367\323$\230\70E\250a\370\347\247\30\31\305\370x8\206(\231\271\23\240\331\351\231b\21*:JZjjQ\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\210\214\217\251\313\355\17"
	"\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32\350\6\264.\220\275n,\303\353\215\347z\247\346\265-\370\321d\273\242\361\30\352\341\204\30f\260\206\214J\215\312\233\363\12\235j\267\246\352\12Klf\271\344\62\307\213\2\277\206k\263\333\214>\251g\342"
	"\360\373\256\215\233\346-6\35\17\210\244W\302\7\344\24\210\250\63HR\350\327\227\10\211\263\70\322X\327\26\211\331\25\220\311\331\71b\1\32*:JZ\12Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\212\214\217\251\313\355\17\243\234\264"
	"F\201\263\336\274\373\17\206\342H\226\346\11\32h\11\264.\220\275n,\303\353\215\347\267\252\177\265-\370\321d\275\242\361(\340!\207/\346\14#\\J\247\42\245\64\32\254\71[\324\256Wc]b\307\332\257y\32F\222\211\320\362\371mL\37\327\315\66\33\216"
	"\317\311\215\364g\366\236\27x\262W\324\307eW'\250HB\330c\10\204\265(\371\321\250\363\270\5\64\251\271Q\271\351\371\211a!:JZjz*Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\212\214\217\251\313\355\17\243\234\264F"
	"\201\263\336\274\373\17\206\342H\226\346\11\32\350\312\1\356\13d\360+\317\61\213\347:\247\356\250}\23\0k3\237\361X\352!GCLSh[J\247\31%\325\363\314F\257\\\237\265\253\321\26\235[\260\31\365=\213aD\366\371\235\14\300\333\64\362\30z\237"
	"\353;i\363\272\216\347\266\67\250\321\7\366\347B\227H\310(`\330\205\30\364\324\270\367\310\25\251\30D\251g\271\351\371Ye!:JZjzjQ\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\210\214\217\251\313\355\17\243\234\264F\201"
	"\263\336\274\373\17\206\342H\226\346\11\32\350j\2\356\13d\360+\317\61\213\347\253\252\367\233}\23\0k3\237\361\270\341!uCLSh[J{\312\351\352\211\215Z\267\247*\267\224-:\265\337r*`n\221\303\260\264\233\343}{\330\264\261X\376\216\343"
	"\177\353\376}o\246\7h\327FX\7\365\67\310%8H\347BT\250\370\305\10\350\30\364$\271E\231\311\331\11g\1\32*:JZjQ\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\210\214\217\251\313\355\17\243\234\264F\201\263\336\274"
	"\373\17\206\342H\226\346\11\32\350\312r\300\13\3Y\14\317\264\334\346:\247\356\376x\303\11\202\66\332\357\310\352!\227\32\42\306\71\274\61\247\42%\25\11\315J\257\334\215\265\273\323\32\237[p\367kn\211cEv\232\213~\243\326\65\362X>\215\343K\364W"
	"\273\276\267\244\27(\322'\4E\370\63\230\370a\370\347\307\250\30\20i\342h\347F\251\263\230\311\331\231a\1\32*:JZ\12Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\210\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206"
	"\342H\226\346\11\32\350\312\232\300\13\3Y\14\317\264\334\346\253\252\367\376\215\23\0m4\237Q\304;*]7b\314Y[J3\311\251\265\63\304d\205\315\353\262\352\15o\307\335\260\21l\266\222\213\332rZ\207~/\327\317\66[\236\213\343\215\364(\367\276\267"
	"\23\20\70\325\367\2uH(\250\70Wf\30\304X\242\27\271\362\210\10I\211\64\230\311\331)i\1\32*:JZjQ\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\211\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226"
	"\346\11\32\350\312\266\33\0\307@&\307t=\273z\247\356\376\337\301\345\4\302[\15\370\353!\227\273\42\306I\304\61u\312\251\365\4\315J\257\253*\367\13\322\36\237[p\311kN\33ek\33y\254\26\241\343f1\373}\247\247\2z\272\335\35\5\327\307\303"
	"\67\230\366\7\323\226hH\310XW\206\70\344\230\61\67\211\24\251(iYi\331\351\271a\21*:JZj\32Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\213\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11"
	"\32\350\312\266%\0\307@&\307t=\273\254\252\367>\213\313\11\202\267\332\357\304;*\227\35\42\306\71\304\61G\311\251\365\10\315J\257\237*\367\13\334F\215O1X\343=\253GZ\362X\266F\7\342tQ\33^v\307\323\365~\36\377f\363'H\307\347"
	"WwG\10\265\67w\350\30\10S\4\270\270f\370\250\226\30\71\250Y\330x\371\11Jb1JZjz\212:Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\212\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11"
	"\32\350\312\266n\6\304\62\0\317qm\277i\240\367\376/\260\335\60B\32Q\10\334\250\222\314\246\250\210\233EeN\301\262\212\305B\217\71\256\324y\315\212\223\333 \322K\5\363\306\354_\371}n\206\333t\26\274k\306\63\347\365~\351\376\225\27\270\267\346g"
	"H\2\230&\250Hx\350\370\24\227\70$W\370h\271!i\264\70\331x\351\371)b!:JZjz*Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\201\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32"
	"\350\312\266\356\10\304\62\220\315rm\323\256\372\366\376O\312\351\4B\234\355\305\3*\227\300\42\306I\314!\3\314\252\225\5\315Jw\324\253\367\13\322\36\237\333V\22\214F\213gF67\15\7\257o\344\261\271\33\317\63\347\261\66\375\256\27\250\304\67\4\305r"
	"&\230\210UF8\245\370\270h\327\370\6YiYb\221\251\271\311\331\351\231Y\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\204\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32\350\312\266\356\13\304\62\220\315r"
	"m\323\242\372\366\376\337\313\351\4B\234m\304\3*\227\314N\21\363$\346\220\201\246\365\12\214j\247\273*\366\13>m\217Pn(\31N\253\71\343\231\321\335]\313\347\355[\231|\366\316\367\340z\354m\227\307\67\210\345\67\24\225\242G\270\230efH\305\30"
	"\371\363x\7'(\211\231\371a\301\331\351\371\11\32\312Y\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2\211\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32\350\312\266\356\13\2\362\14d\364l\337\65\246\302\376\17"
	"\14bt;\1\61w\313\364\204\314\246\363s\34\352\220\64e\340\211\315\66\243\306\251\64\311\273j\307\344\26\367\354\25,\313\354v,\215\6\253\305\356\272\375[\305\343\364\62\353\375\357\26\227\327%\267\6x\210%\270G8h\210\370(\244\330\307W\344\10y\11"
	"#Y\304e\211\351\211h\21*:JZj\32Z\0\0!\371\4\0\12\0\0\0,\0\0\0\0\245\0\17\0\0\2v\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17\206\342H\226\346\11\32\350\312\266\356\313\2\362\14d\364\234\251\360\316\367\276x\223\331"
	"\202\271\300\357\210L\266\202\65\14\263\250\214J\247\233\247\223\210\321Q\267\334\236U\360\325v\307\344\323\67l,\253\327\240\63V f\313\331\356\33t\216_\327i\367\274\277\273\207\223\225\366W8\25(4h\270hh\341\370\10\31)9\351X\0\0;"
};

char pProgressAnimHC[2560] =
{
	"GIF89a\245\0\17\0\200\1\0\377\377\377\377\377\377!\377\13NETSCAPE2.0\3\1\0\0\0!\371\4\5\12\0\1\0,\0\0\0\0\245\0\17\0\0\2p\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11"
	"\32\331\262*\350\13\307\362\14\253\30{\273\364\316\367\276h\13\340\204\272\237\361\210|\5\207\303\244\363\11\315\265\22SD\364\212\375-\213\315\254\367k\332Rsc\260\371\374\21[\311k\264\373\255>T\345\357\372\71\216\7\330\367\337\374<\310\27\370\4(Xh"
	"g\201\230\250\270\310\330\210X\0\0!\371\4\11\12\0\1\0,\4\0\2\0\33\0\13\0\0\2\36\214\217\231\300\15\12\241k\261\236\311\254\305OG\356}X(\215\344b\236W\252\6`kp\5\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0"
	"\2_\214\217\251\313\355\17\243\234\264\332\213\263\336\274_\0\206\300!\206d9z\352\312\252h\32\274g\331\326\366\15\311\206\36\243\370\17\274\361\206\276\240\361\270!\322vE\244\363\31Q\212fS\250\365\232\220\232\230K\254\27\252\5Q\267\337\362\61\14\343\231\327"
	"\70\364X\314\216\333\334\334\252\374\216\317\353\367\374x\1\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0\2}\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\266d-\366\256\362L\327\234J\307\272b\367\376\37\302\315"
	"v\11\27\17\210L\366\204\62\42\302XTJ\247&\346\312y\200>\251\334n\307\212\302\12c\336\62\27|\22\3\264Y\263{\212\256\36\3\352\267=\31/\325a\363\273\277\226G\262G\327\367g\30\266\226\63\67x\330\250\227\350\30)\31dQiy\211\231\251"
	"iQ\0\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0\2\177\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32h\271d-\366\256\362L\257j\375\305\272\202\367\376\37\270\1]<X1x\34*\227)\0\23\231 F"
	"\215\323\247\325*T\356\252\261\253w\230\5\37\267\210\257\31\30F\217\327\325\263{\226\376\221\17\322\362\373ns2\347\302.\376/\22\347\303\247\7e\7\210\330\364DXG\227\370\330!\10\71I\271aq\211\231\251\271\311yY\0\0!\371\4\11\12\0\1\0"
	",\0\0\0\0\245\0\17\0\0\2{\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\312-\231\213\301\354L\327\233j\243\362\256\344\376_\302\1G\274\304\253\67L*c\200e\250\210\70\32\235\324\234\260zC\6\240\7\254\227u"
	"\375n\265\334\260\370\374\61{\313M\346\24\15\367\250\261li4\216\317\306\353\356{\376?W\305\67\366\366\207\27H5(c\270\327\306\370\10Ib1IYiy\211\71Y\0\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0\2~\204\217\251\313"
	"\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350j.\231\213\301\354L\243j\215o\362\256\344\376\257\3\0s\274\304\253\67L\326nJV\21q46\247'&\265\205\14<\17\327\256\310\352\375f\267\340\260Y+<\213\245h\266Lm.\303"
	"\203\356qv\356\225\343c\366:{\177\245\267G\226\326\6\5\330%\210G\30u\210H\245\370(9\311aay\211\231\251\271iY\0\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0\2|\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206"
	"\342H\226\346\11\32\350\312rK\366bqK\327\233j\347\343\314+\372\317\302\1\207\232^\2\346#*C\302%\320\210@\36\235\324\33\240\372L\6\240\7\254\267\351\245q\205\263\360\22l^\215\257\62m\232\210~\233\326\322\250\34\316\276\243\350\355\251\376\27\367"
	"\307\244\305'\230\23h\350QX\226\330\202\330\10\31YdAYiy\211\231iQ\0\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0\2~\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\312\232K\366bqK\243"
	"j\215\347\363\256\344\276x\373\11]=Y10\33*\221\200\245\63u\344%\236\312 \365\312\234\32\265Y\4\366g\375:\245\336mY\\\13\243\207\344\3\354\270f\251\343\276v0I?\315\363\351\250\237\313G\24(d\327d\346\66(\230\250\363w\206\267\10"
	"\5)99bay\211\231\251\271iY\0\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0\2|\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\312\266\333\222\301\230\354\326\234j\347zG\367\312\256\303\1\207\66_"
	"\42\366#\272\204\312\346\311\210@\36\235+&\365\232J\6\240\7\354\23\340\15{\270B\232\70d=\207\311\340\231V\375I\303\257lit\36o\343\275u\367t\177\243\7H\325\267\365\66\350\206H\247U\250h\350\10\31\231eAYiy\211\231YQ\0\0"
	"!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17\0\0\2~\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\312\266\345\222\301\230\354\256j\215\347,\315+\372y\373\11\207\235^\42\346#\212\202\312\346\317\210@\36\235\37&\365"
	"\272K\6\240\7l\21\340\15\243\270A\232x\13>\253C\344\64z\252\266\256\347\322\350Lk\26\313\351\363v\275\273\266\307\27\207W\10w&8\250gh\367\326\210\350\246(9ibay\211\231\251\271iY\0\0!\371\4\11\12\0\1\0,\0\0\0\0"
	"\245\0\17\0\0\2~\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\312\266n\266\300\212\234\274)`\347\372\36\304\230\337\233\361\64\252\241\361(\2*\205\307\42\362\11\375\61\227\65\244\63\212\35R\21\64\256\25\227\15\357\266\207n"
	"\371+N\333\310N\240\361\252\216\233\330\340`\265Y\227\353Gt3\234\367\267'\310\321'u\367\226\67\250H4\325x\250\225\270(9\351aay\211\231\251\271iY\0\0!\371\4\5\12\0\1\0,\0\0\0\0\245\0\17\0\0\2y\204\217\251\313\355\17"
	"\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\312\266\356\270d16\267\352\213\347:Y\367\312{\333\11\207;_B\366s\5\211\314\346\311\210@\36\225\0\247\365\32\202\36\244Q*\366\13\246%\3\332\345\312\34N\17\313U\361\324\326V\313\205l"
	"\356\326;\317\347\352\356.\\\17H\365\306\367\27h\370\64F\310\202v\330\350\330a\21)9IYi\31Y\0\0!\371\4\11\12\0\1\0,r\0\2\0\7\0\13\0\0\2\7\214\217\251\313\355\377\12\0!\371\4\11\12\0\1\0,\0\0\0\0\245\0\17"
	"\0\0\2G\214\217\251\313\355\17\243\234\264\332\213\263\336\274\373\17\206b\3\224&0\246\352\12\236&\13\307\62\344\226\363\215\313\65\232\367~[\373\11\207\230\35\361\210|\30\223\314f`\351\214\16\241\322j\216j\315\306\260\332\256\367\13\16\25\0\0!\371\4\5"
	"\12\0\1\0,\0\0\0\0\245\0\17\0\0\2w\204\217\251\313\355\17\243\234\264\306\200\263\336\274\373\17\206\342H\226\346\11\32\350\312\266\356\233*\331\62\313\230\12\347\372\316\337v@\363%j\275\242\361\30\12\2\177J\34\362\11\355\65\231\324\250\365\352\232\16\205"
	"\10\42\366\13\26i\273\334\203\67\214N\227\235c\263O\15\17\267\331\325\270\335:\7\324\266\313\273\377\231\267G\326\367W(E\305\67e\270\310\270d\361\10\31)9IYQ\0\0;"
};

// -----------------------------------------------------------------------------
GifAnimator::GifAnimator(Window* _pParent, ResMgr* _pResMgr)
		:m_pWindow(_pParent),
		 m_pResMgr(_pResMgr),
		 m_pFB(NULL),
		 m_pAnim(NULL),
		 m_bAnim(false)
{
	OSL_ASSERT(_pParent);
	OSL_ASSERT(_pResMgr);

	m_pFB = new FixedBitmap( m_pWindow );

	SetSize();
}

// -----------------------------------------------------------------------------
GifAnimator::~GifAnimator()
{
    StopAnim();

    m_aStartAnimTimer.Stop();
    m_aStartAnimTimer.SetTimeoutHdl( Link() );
    delete m_pFB;
}

// -----------------------------------------------------------------------------
void GifAnimator::SetSize()
{
	// Size of the GIF, sorry
	Size aWinSz(165, 15);

	m_aRect.SetSize(aWinSz);

	m_pFB->SetSizePixel( aWinSz );
}

void GifAnimator::SetPos(Point const& _aPoint)
{
	m_pFB->SetPosPixel( _aPoint );
	m_aRect.SetPos(_aPoint);
}

IMPL_LINK(GifAnimator, AnimHdl, void*, pEmpty)
{
	if( !m_bAnim )
		return 1;

/* File based
	ByteString sFilename = "progressanim.gif";
	UniString suFilename(sFilename, osl_getThreadTextEncoding());

	SvFileStream aStrm(suFilename, STREAM_READ);
*/

// Hard coded
	SvMemoryStream	aStrm(pProgressAnim, 2560, STREAM_READ);
	SvMemoryStream	aStrmHC(pProgressAnimHC, 2560, STREAM_READ);

	// delete old animation
	if( m_pAnim )
		delete m_pAnim;

	// create new animation object
	m_pAnim = new Graphic;
	aStrm.Seek( STREAM_SEEK_TO_BEGIN );
	aStrmHC.Seek( STREAM_SEEK_TO_BEGIN );

	BOOL bSucc;
    
    if ( m_bIsBlack )
    {
        bSucc = ImportGIF( aStrmHC, *m_pAnim, NULL );
        m_pFB->SetBackground( Wallpaper( Color( COL_BLACK ) ) );
    }
    else
    {
        bSucc = ImportGIF( aStrm, *m_pAnim, NULL );
        m_pFB->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
    }

	if( bSucc )
	{
		m_pFB->Show();
		m_pAnim->StartAnimation( m_pFB, Point(0, 0) );
	}

	return 1;
}

void GifAnimator::Paint()
{
    if( m_bAnim && m_pAnim )
	{
	    Rectangle aBorder( m_pFB->GetPosPixel(), m_pFB->GetSizePixel() );
        Color aLastLC = m_pWindow->GetLineColor();
        Color aLastFC = m_pWindow->GetFillColor();
    
        if ( m_bIsBlack )
        {
            m_pWindow->SetLineColor( Color( COL_WHITE ) );
            m_pWindow->SetFillColor( Color( COL_BLACK ) );
        }
        else
        {
            m_pWindow->SetLineColor( COL_BORDER );
            m_pWindow->SetFillColor( Color( COL_WHITE ) );
        }
        m_pWindow->DrawRect( aBorder );
        m_pWindow->SetLineColor( aLastLC );
        m_pWindow->SetFillColor( aLastFC );

		m_pFB->Paint(m_aRect);
	}
}

void GifAnimator::StartAnim( BOOL bIsBlack )
{
	if (m_bAnim == false)
	{
		m_bAnim = true;
        m_bIsBlack = (bool) bIsBlack;
		m_aStartAnimTimer.SetTimeout( 5 );
		m_aStartAnimTimer.SetTimeoutHdl( LINK(this, GifAnimator, AnimHdl) );
		m_aStartAnimTimer.Start();
        Paint();
	}
}

void GifAnimator::StopAnim()
{
	if( m_bAnim && m_pAnim )
	{
		m_pFB->Hide();
		m_pAnim->StopAnimation();
		delete m_pAnim;
		m_pAnim = NULL;

        Rectangle aBorder( m_pFB->GetPosPixel(), m_pFB->GetSizePixel() );
    
        m_pWindow->Invalidate( aBorder );
	}
}
