/*************************************************************************
 *
 *  $RCSfile: maindlg.cxx,v $
 *
 *  $Revision: 1.32 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 09:55:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include <tools/l2txtenc.hxx>

#include "maindlg.hxx"
#include "main.hxx"
#include "environ.hxx"
#include "script.hxx"
#include "decltor.hxx"
#include "arch.hxx"
#include "sihelp.hxx"

#include "maindlg.hrc"
#include "pages.hrc"
#include "strings.hrc"

#include "pupdate.hxx"
#include "pwelcome.hxx"
#include "plicense.hxx"
#include "pimode.hxx"
#include "pipath.hxx"
#include "pusrinst.hxx"
#include "preadygo.hxx"
#include "preadme.hxx"
#include "phavefun.hxx"
#include "paddr.hxx"
#include "pwsetup.hxx"
#include "preins.hxx"
#include "puninst.hxx"
#include "precover.hxx"
#include "pcrc.hxx"
#include "plang.hxx"
#include "ppatch.hxx"
#include "preguser.hxx"
#include "pasreins.hxx"
#include "pasuinst.hxx"
#include "prepair.hxx"
#include "pmigrate.hxx"
#include "pscript.hxx"
#include "pprofile.hxx"
#include "pcfgserver.hxx"
#include "prspwizard.hxx"
#include "pmodules.hxx"

#define EVENT_NOT_SET		0xffffffff

SetupAgentDialog::SetupAgentDialog( Window* pParent, ResMgr* pMgr,
                                    SetupApp *pSetup, BOOL bWizard ) :
	SvAgentDlg	( pParent, pMgr, pSetup, bWizard? RESID_MAINDLG_LOGO_WIZARD : RESID_MAINDLG_LOGO /*, TRUE*/ )
{
	nSuccEventID = EVENT_NOT_SET;
	nFailEventID = EVENT_NOT_SET;
	eModelType 	 = MODEL_NOTSET;

	bModalFlag	= FALSE;
	bModalSucc	= FALSE;
	bAskOnExit	= TRUE;

	nLanguage	= 0;
	pEnv		= NULL;
	pCScript	= NULL;
	pOldCScript	= NULL;

	SetInitHdl( LINK(this,SetupAgentDialog,InitPage) );

    if ( pSetup )
    {
        SetLanguage( pSetup->GetLanguage() );
        SetEnv( pSetup->GetEnvironment() );
    }
}

SetupAgentDialog::~SetupAgentDialog()
{
}

BOOL SetupAgentDialog::AskExit()
{
	if( !bAskOnExit ) return TRUE;

	String aMsg;
	if( eModelType == MODEL_RESPONSE_WIZARD )
		aMsg = String( ResId(STR_EXITRESPONSEWIZARD) );
	else
		aMsg = String( ResId(STR_EXITSETUP) );

	aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString::CreateFromAscii(pEnv->GetProductName().GetBuffer()) );

	QueryBox aBox( this, WB_YES_NO | WB_DEF_NO, aMsg );
	if( aBox.Execute() == RET_YES )
		return TRUE;
	return FALSE;
}

BOOL SetupAgentDialog::Close()
{
	if( !AskExit() )
		return FALSE;

	if( nFailEventID != EVENT_NOT_SET )
		Application::PostUserEvent( nFailEventID );
	else
		Application::PostUserEvent( EVT_END );

	return TRUE;
}

BOOL SetupAgentDialog::EndAgentDlg(BOOL bSucc)
{
	if( bSucc && nSuccEventID != EVENT_NOT_SET )
		Application::PostUserEvent( nSuccEventID );
	else if( !bSucc && nFailEventID != EVENT_NOT_SET )
	{
		if( !AskExit() )
			return FALSE;
		Application::PostUserEvent( nFailEventID );
	}

	bModalSucc = bSucc;
	bModalFlag = TRUE;

	return TRUE;
}

BOOL SetupAgentDialog::DoModal()
{
	bModalFlag = FALSE;
	bModalSucc = FALSE;

	Window* pOldParent = Application::GetDefModalDialogParent();
	Application::SetDefModalDialogParent( this );

	if( Application::GetAppWindow() )
		Application::GetAppWindow()->EnableInput( FALSE, TRUE );

	while( !bModalFlag && IsVisible() )
	{
		Application::Yield();
	}

	if( Application::GetAppWindow() )
		Application::GetAppWindow()->EnableInput( TRUE, TRUE );

	Application::SetDefModalDialogParent( pOldParent );
	return bModalSucc;
}

IMPL_LINK(SetupAgentDialog,InitPage,SvAgentPage*,pPage)
{
	if ( pCScript )
    {
        USHORT      nId     = pPage->GetId();
        SiHelpText *pText   = NULL;

        if ( GetEnv()->IsLocal() && GetEnv()->InstallFromNet() )
            pText = pCScript->GetHelpTextForId( nId + WKS_OFFSET, nLanguage );
        else if ( ! GetEnv()->IsLocal() )
            pText = pCScript->GetHelpTextForId( nId + NET_OFFSET, nLanguage );

        if ( !pText )
            pText = pCScript->GetHelpTextForId( nId, nLanguage );

        if( pText )
        {
            ByteString aHelpText( pText->GetHelpText() );
            aHelpText.SearchAndReplaceAll("\\n", "\n");
            UniString aHelp( aHelpText, Langcode2TextEncoding(nLanguage) );
            SetHelpAvailable( aHelp );
        }
    }

	switch( pPage->GetId() )
	{
		//////////////////////////////////////////////
		//	RESID_PAGE_PAGERECOVER
		case RESID_PAGE_PAGERECOVER :
			if( eModelType == MODEL_REINSTALL )
				SuccEvent( EVT_REINST_RECOVER );
			break;

		//////////////////////////////////////////////
		//	RESID_PAGE_PAGEUNINSTALL
		case RESID_PAGE_PAGEUNINSTALL :
			if( eModelType == MODEL_REINSTALL )
				SuccEvent( EVT_REINST_UNINSTALL );
			break;

		//////////////////////////////////////////////
		//	RESID_PAGE_PAGEUSERDEFINED
		case RESID_PAGE_PAGEUSERDEFINED :
			if( eModelType == MODEL_REINSTALL )
				SuccEvent( EVT_REINST_CHANGE );
			break;

		//////////////////////////////////////////////
		//	RESID_PAGE_PAGEHAVEFUN
		case RESID_PAGE_PAGEHAVEFUN	:
			SetButtonState( BSTATE_DISABLE_CANCEL );

			if( eModelType == MODEL_END_FIRST_INST_BOOT )
				((PageHaveFun*)pPage)->ShowReboot();
			else if( eModelType == MODEL_PATCH )
				((PageHaveFun*)pPage)->ShowPatch();
			else if( eModelType == MODEL_RESPONSE_WIZARD )
				((PageHaveFun*)pPage)->ShowResponsfileWizard();
			else if( eModelType == MODEL_END_INST_BOOT ||
				eModelType == MODEL_END_INST )
			{
				if( pEnv->GetInstallType() == IT_CHANGE )
					((PageHaveFun*)pPage)->ShowChange();
				else if( pEnv->GetInstallType() == IT_RECOVER )
					((PageHaveFun*)pPage)->ShowRecover();
				else if( pEnv->GetInstallType() == IT_UNINSTALL )
					((PageHaveFun*)pPage)->ShowUnInstall( pEnv->IsReboot() || pEnv->IsLogout() );

				if( eModelType == MODEL_END_INST_BOOT &&
					pEnv->GetInstallType() != IT_UNINSTALL )  // grumpf &%(%&!"(%&!" (siehe zwei Zeilen drueber)
					((PageHaveFun*)pPage)->ShowReboot();
			}
			break;

		//////////////////////////////////////////////
		//	RESID_PAGE_PAGEREADME
		case RESID_PAGE_PAGEREADME :
		{
			GetButtonNext()->Enable( FALSE );

            SiDirEntry aReadmeFile;

            if ( pEnv->InstallFromNet() )
            {
                aReadmeFile  = pEnv->GetSourcePath();
                aReadmeFile += ByteString( "share" );
                aReadmeFile += ByteString( "readme" );
            }
            else
                aReadmeFile = pEnv->GetStartPath();

            aReadmeFile += SiHelp::GetReadmeFilename( nLanguage, 1 );

            // when we didn't find a language specific readme, we try the default one
            if ( !aReadmeFile.Exists() )
            {
                aReadmeFile  = pEnv->GetSourcePath();
                aReadmeFile += ByteString( README_FILE_NAME );
            }

			aReadmeFile.ToAbs();
			((PageReadme*)pPage)->SetReadmeFile( aReadmeFile.GetFullUni() );

			GetButtonNext()->Enable( TRUE );
			GetButtonNext()->GrabFocus();
			break;
		}

		//////////////////////////////////////////////
		//	RESID_PAGE_PAGELICENSE
		case RESID_PAGE_PAGELICENSE :
		{
			SetNextText( UniString::CreateFromAscii("") );
			SetBackText( UniString::CreateFromAscii("") );

			SiDirEntry aLicenseFile;

            if ( pEnv->InstallFromNet() )
            {
                aLicenseFile  = pEnv->GetSourcePath();
                aLicenseFile += ByteString( "share" );
                aLicenseFile += ByteString( "readme" );
            }
            else
                aLicenseFile = pEnv->GetStartPath();

            aLicenseFile += SiHelp::GetReadmeFilename( nLanguage, 2 );

            // when we didn't find a language specific readme, we try the default one
            if ( !aLicenseFile.Exists() )
            {
                aLicenseFile  = pEnv->GetSourcePath();
                aLicenseFile += ByteString( LICENSE_FILE_NAME );
            }

			aLicenseFile.ToAbs();
			((PageLicense*)pPage)->SetLicenseFile( aLicenseFile.GetFullUni() );

			break;
		}

		//////////////////////////////////////////////
		//	RESID_PAGE_PAGEASRV_USERNAME
		case RESID_PAGE_PAGEASRV_USERNAME :
			if( eModelType == MODEL_REINST_APPSERVER )
				SuccEvent( EVT_REINST_APPSERVER_USERADD );
			break;

		//////////////////////////////////////////////
		//	RESID_PAGE_PAGEASRV_UNINSTALL
		case RESID_PAGE_PAGEASRV_UNINSTALL :
			if( eModelType == MODEL_REINST_APPSERVER )
				SuccEvent( EVT_REINST_APPSERVER_DEINSTALL );
			break;
	}
	return 1;
}

// ============================================================================
//
void SetupAgentDialog::AddAllPages()
{
	InsertPage( RESID_PAGE_PAGELANGUAGE,			PageLanguage::Create,	 	   		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEADDRESS,				PageAddress::Create,	 	   		LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGECRCCHECK,			PageCRCCheck::Create,				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEHAVEFUN,				PageHaveFun::Create,				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEINSTALLMODE,			PageInstallMode::Create,			SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEINSTPATH,			PageInstPath::Create,		   		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGELICENSE,				PageLicense::Create,				LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEREADME,				PageReadme::Create,					LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEREADYGO,				PageReadyGo::Create,				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGERECOVER,				PageRecover::Create,				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEREINSTALLATION,		PageReInstallation::Create,			SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEUNINSTALL,			PageUnInstall::Create,				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEUSERDEFINED,			PageUserDefined::Create,			LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEWELCOME,				PageWelcome::Create,	   			SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEWRONGSETUP,			PageWrongSetup::Create,				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEUPDATEINSTALL,		PageUpdateInstall::Create,			SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEUSERREGISTRATION,	PageUserRegistration::Create,		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEREPAIR,				PageRepair::Create,	   				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGESCRIPTNOTFOUND,	 	PageScriptNotFound::Create,	   	   	SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEMIGRATION,	  		PageMigration::Create,	   	   		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEPROFILE,				PageProfile::Create,	   	   		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGECONFIGSERVER,		PageConfigServer::Create,	   	 	SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGERSPWIZARD,			PageResponseWizard::Create,	   	 	SMALL_PAGE );
	InsertPage( RESID_PAGE_PATCH,					PagePatchSetup::Create,	   	 		SMALL_PAGE );
}

// ============================================================================
//								Page Model's
// ============================================================================
// FirstInstallation
// ============================================================================
void SetupAgentDialog::CreateModel_FirstInstallation()
{
	eModelType = MODEL_FIRST_INST;

	BOOL bHasLanguages  = pEnv->GetUILanguageContext().Count() > 1 ? TRUE : FALSE;
	BOOL bHasSubModules	= pCScript->GetRootModule()->HasUISubModules();
	BOOL bOnlyCustom	= pCScript->GetInstallation()->IsOnlyCustom();
	BOOL bPathPage	    = pCScript->GetInstallation()->IsPathPage();
	BOOL bIsPageReadyGo = pCScript->GetInstallation()->IsPageReadyGo();

	if ( pEnv->IsUpdateOldVersion() )
        InsertPage( RESID_PAGE_PAGEUPDATEINSTALL,   PageUpdateInstall::Create,  SMALL_PAGE,		AGENT_STARTPAGE );
    else
    	InsertPage( RESID_PAGE_PAGEWELCOME, 		PageWelcome::Create,		SMALL_PAGE,		AGENT_STARTPAGE );
	
    InsertPage( RESID_PAGE_PAGELICENSE,			PageLicense::Create,		LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEADDRESS,     	PageAddress::Create,	 	LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEINSTALLMODE,     PageInstallMode::Create,	SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEINSTPATH,		PageInstPath::Create,		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEUSERDEFINED,     PageUserDefined::Create,	LARGE_PAGE );
	if (bIsPageReadyGo) InsertPage( RESID_PAGE_PAGEREADYGO,     	PageReadyGo::Create,	   	SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEREADME,			PageReadme::Create,			LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGELANGUAGE,		PageLanguage::Create,	 	SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEMIGRATION,		PageMigration::Create,		SMALL_PAGE );

	if( pEnv->IsLocal() )
	{
	//	================================
	//	keine Registrierung
	//	================================

       	USHORT nSecondPage;

        // When the language has been set with the -lang parameter, we don't
        // want to offer the choose language page !
        if ( GetSetupApp() && GetSetupApp()->HadParamLanguage() )
            bHasLanguages = FALSE;

        if ( bHasLanguages )
            nSecondPage = RESID_PAGE_PAGELANGUAGE;
        else
            nSecondPage = RESID_PAGE_PAGEREADME;

        if ( pEnv->IsUpdateOldVersion() )
            Rule( RESID_PAGE_PAGEUPDATEINSTALL,				nSecondPage );
        else
            Rule( RESID_PAGE_PAGEWELCOME,			   		nSecondPage );

        if ( bHasLanguages )
            Rule( RESID_PAGE_PAGELANGUAGE, 					RESID_PAGE_PAGEREADME );
        
        Rule( RESID_PAGE_PAGEREADME, 						RESID_PAGE_PAGELICENSE );

		if( bHasSubModules && !bOnlyCustom )
		{
            if( pEnv->IsMigrationAvailable() )
            {
			    RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL, 	RESID_PAGE_PAGEMIGRATION );
				if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_UPDATE, 	RESID_PAGE_PAGEREADYGO );
            }
			else
            {
			    RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL, 	RESID_PAGE_PAGEADDRESS );
			    if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_UPDATE, 	RESID_PAGE_PAGEREADYGO );
            }

			if( pEnv->IsMigrationAvailable() )
			{
				RuleIf( RESID_PAGE_PAGEMIGRATION,	PMIGRATION_YES,	RESID_PAGE_PAGEINSTALLMODE );
				RuleIf( RESID_PAGE_PAGEMIGRATION,	PMIGRATION_NO,	RESID_PAGE_PAGEADDRESS );
			}

			Rule( RESID_PAGE_PAGEADDRESS,	                	 	RESID_PAGE_PAGEINSTALLMODE );
		}
		else
		{
			//# RuleIf( RESID_PAGE_PAGELICENSE, RETURN_LIC_NORMAL,  RESID_PAGE_PAGEINSTPATH );
			if (bPathPage)
			{
				RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL,  RESID_PAGE_PAGEINSTPATH );
			}
			else
			{
				if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL,  RESID_PAGE_PAGEREADYGO );
			}
			if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_UPDATE, 	RESID_PAGE_PAGEREADYGO );
		}
	}
	else
	{
        if ( pEnv->IsUpdateOldVersion() )
            Rule( RESID_PAGE_PAGEUPDATEINSTALL,				    RESID_PAGE_PAGEREADME );
        else
            Rule( RESID_PAGE_PAGEWELCOME,			   		    RESID_PAGE_PAGEREADME );

        Rule	( RESID_PAGE_PAGEREADME,				   		RESID_PAGE_PAGELICENSE );

        if( bHasSubModules && !bOnlyCustom )
        {
            if( bHasLanguages )
            {
                RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL,  RESID_PAGE_PAGELANGUAGE );
                if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_UPDATE, 	RESID_PAGE_PAGEREADYGO );
                Rule( RESID_PAGE_PAGELANGUAGE,				   		RESID_PAGE_PAGEINSTALLMODE );
            }
            else
            {
                RuleIf( RESID_PAGE_PAGELICENSE, RETURN_LIC_NORMAL,  RESID_PAGE_PAGEINSTALLMODE );
                if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_UPDATE, 	RESID_PAGE_PAGEREADYGO );
            }
        }
        else
        {
            if( bHasLanguages )
            {
                RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL,  RESID_PAGE_PAGELANGUAGE );
                if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_UPDATE, 	RESID_PAGE_PAGEREADYGO );
                if (bPathPage)
                {
                    Rule( RESID_PAGE_PAGELANGUAGE,				   		RESID_PAGE_PAGEINSTPATH );
                }
                else
                {
                    if (bIsPageReadyGo) Rule( RESID_PAGE_PAGELANGUAGE,				   		RESID_PAGE_PAGEREADYGO );
                }
            }
            else
            {
                if (bPathPage)
                {
                    RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL,  RESID_PAGE_PAGEINSTPATH );
                }
                else
                {
                    if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_NORMAL,  RESID_PAGE_PAGEREADYGO );
                }
                if (bIsPageReadyGo) RuleIf( RESID_PAGE_PAGELICENSE,	RETURN_LIC_UPDATE, 	RESID_PAGE_PAGEREADYGO );
            }
        }
    }

	if (!bOnlyCustom)
	{
		RuleIf	( RESID_PAGE_PAGEINSTALLMODE,  RETURN_USERDEFINED,	RESID_PAGE_PAGEUSERDEFINED );
		if (bPathPage)
		{
			RuleIf	( RESID_PAGE_PAGEINSTALLMODE,  RETURN_NORMAL,	RESID_PAGE_PAGEINSTPATH );
			
			Rule	( RESID_PAGE_PAGEUSERDEFINED,	   				RESID_PAGE_PAGEINSTPATH );
			if (bIsPageReadyGo) Rule    ( RESID_PAGE_PAGEINSTPATH,	 			  		RESID_PAGE_PAGEREADYGO );
		}
		else
		{
			if (bIsPageReadyGo) RuleIf	( RESID_PAGE_PAGEINSTALLMODE,  RETURN_NORMAL,	RESID_PAGE_PAGEREADYGO );
			if (bIsPageReadyGo) Rule	( RESID_PAGE_PAGEUSERDEFINED,	   				RESID_PAGE_PAGEREADYGO );
		}
	}
	else
	{
		if (bPathPage)
		{
			if (bIsPageReadyGo) Rule    ( RESID_PAGE_PAGEINSTPATH,	 			  		RESID_PAGE_PAGEREADYGO );
		}
	}
	
	if( bOnlyCustom )
	{
		pCScript->GetRootModule()->Select( SiModule::ALL_DEFAULT );
		pEnv->SetInstallType( IT_USERDEFINED );
	}
}

// ============================================================================
// EndFirstInstallation
// ============================================================================
void SetupAgentDialog::CreateModel_EndFirstInstallation( BOOL bReboot )
{
	eModelType = bReboot? MODEL_END_FIRST_INST_BOOT : MODEL_END_FIRST_INST;
	InsertPage( RESID_PAGE_PAGEHAVEFUN, PageHaveFun::Create, SMALL_PAGE, AGENT_STARTPAGE );
}

// ============================================================================
// EndInstallation
// ============================================================================
void SetupAgentDialog::CreateModel_EndInstallation( BOOL bReboot )
{
	eModelType = bReboot? MODEL_END_INST_BOOT : MODEL_END_INST;
	InsertPage( RESID_PAGE_PAGEHAVEFUN, PageHaveFun::Create, SMALL_PAGE, AGENT_STARTPAGE );
}

// ============================================================================
// ReInstallation
// ============================================================================
void SetupAgentDialog::CreateModel_ReInstallation()
{
	eModelType = MODEL_REINSTALL;

	BOOL bHasLanguages 	= pEnv->GetUILanguageContext().Count() > 1 ? TRUE : FALSE;

	InsertPage( RESID_PAGE_PAGEREINSTALLATION,	PageReInstallation::Create,		SMALL_PAGE,
				AGENT_STARTPAGE );
	InsertPage( RESID_PAGE_PAGEUSERDEFINED,     PageUserDefined::Create,	  	LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEUNINSTALL, 		PageUnInstall::Create,			SMALL_PAGE);
	InsertPage( RESID_PAGE_PAGERECOVER, 		PageRecover::Create,			SMALL_PAGE);

    InsertPage( RESID_PAGE_PAGELANGUAGE,		PageLanguage::Create,	 	   	SMALL_PAGE );

	if( bHasLanguages )
		RuleIf( RESID_PAGE_PAGEREINSTALLATION, 	RETURN_CHANGE,			RESID_PAGE_PAGELANGUAGE );
	else
		RuleIf( RESID_PAGE_PAGEREINSTALLATION, 	RETURN_CHANGE,			RESID_PAGE_PAGEUSERDEFINED );

	RuleIf( RESID_PAGE_PAGEREINSTALLATION, 	RETURN_UNINSTALL,	  	RESID_PAGE_PAGEUNINSTALL );
	RuleIf( RESID_PAGE_PAGEREINSTALLATION, 	RETURN_RECOVER,	  		RESID_PAGE_PAGERECOVER );

	Rule  ( RESID_PAGE_PAGELANGUAGE,	   							RESID_PAGE_PAGEUSERDEFINED );
}

// ============================================================================
// WrongSetup
// ============================================================================
void SetupAgentDialog::CreateModel_WrongSetup()
{
	eModelType = MODEL_WRONG_SETUP;
	InsertPage( RESID_PAGE_PAGEWRONGSETUP,	PageWrongSetup::Create,			SMALL_PAGE, AGENT_STARTPAGE );
	InsertPage( RESID_PAGE_PAGERECOVER,  	PageRecover::Create,			SMALL_PAGE);

	RuleIf( RESID_PAGE_PAGEWRONGSETUP, 		RETURN_REPAIR,	  				RESID_PAGE_PAGERECOVER );
}

// ============================================================================
// PatchSetup
// ============================================================================
void SetupAgentDialog::CreateModel_PatchSetup()
{
	eModelType = MODEL_PATCH;
	BOOL bIsPageReadyGo = pCScript->GetInstallation()->IsPageReadyGo();

	InsertPage( RESID_PAGE_PATCH,					PagePatchSetup::Create,	  		SMALL_PAGE, AGENT_STARTPAGE );
	InsertPage( RESID_PAGE_PAGELICENSE,				PageLicense::Create,	 		LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEREADYGO,     		PageReadyGo::Create,	   		SMALL_PAGE );

	Rule( RESID_PAGE_PATCH, 			RESID_PAGE_PAGELICENSE );
	if (bIsPageReadyGo) Rule( RESID_PAGE_PAGELICENSE, 		RESID_PAGE_PAGEREADYGO );
}

// ============================================================================
// Script not found
// ============================================================================
void SetupAgentDialog::CreateModel_ScriptNotFound()
{
	eModelType = MODEL_SCRIPT_NOT_FOUND;
	InsertPage( RESID_PAGE_PAGESCRIPTNOTFOUND, PageScriptNotFound::Create, SMALL_PAGE, AGENT_STARTPAGE );
}

// ============================================================================
// WrongSetup
// ============================================================================
void SetupAgentDialog::CreateModel_UpdateOldVersion()
{
    CreateModel_FirstInstallation();
	eModelType = MODEL_UPDATE_OLD_VERSION;
}

// ============================================================================
// ResponseWizard
// ============================================================================
void SetupAgentDialog::CreateModel_ResponseWizard()
{
	eModelType = MODEL_RESPONSE_WIZARD;

	BOOL bHasLanguages  = pEnv->GetUILanguageContext().Count() > 1 ? TRUE : FALSE;
    BOOL bHasModules    = pCScript->GetModuleSetList().Count() > 0 ? TRUE : FALSE;

	InsertPage( RESID_PAGE_PAGERSPWIZARD,			PageResponseWizard::Create,	   	 	SMALL_PAGE, AGENT_STARTPAGE );
	InsertPage( RESID_PAGE_PAGEPROFILE,				PageProfile::Create,	   	   		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEMODULES,             PageModules::Create,	   	   		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEUSERDEFINED,			PageUserDefined::Create,			LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGELANGUAGE,			PageLanguage::Create,	 	   		SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEINSTPATH,			PageInstPath::Create,				SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEHAVEFUN,				PageHaveFun::Create,				SMALL_PAGE );

	Rule  ( RESID_PAGE_PAGERSPWIZARD,	   									RESID_PAGE_PAGEINSTPATH );
	if( bHasLanguages )
	{
 	RuleIf( RESID_PAGE_PAGEINSTPATH, 			RETURN_NORMAL,  			RESID_PAGE_PAGELANGUAGE );
 	RuleIf( RESID_PAGE_PAGEINSTPATH, 			RETURN_USERDEFINED,   		RESID_PAGE_PAGELANGUAGE );
		if ( bHasModules )
   		{
	Rule  ( RESID_PAGE_PAGELANGUAGE,	   									RESID_PAGE_PAGEMODULES );
	RuleIf( RESID_PAGE_PAGEMODULES, 	   		RETURN_OWN,					RESID_PAGE_PAGEPROFILE );
	RuleIf( RESID_PAGE_PAGEMODULES, 	   		RETURN_PREDEFINED,			RESID_PAGE_PAGEHAVEFUN );
    	}
		else
		{
	Rule  ( RESID_PAGE_PAGELANGUAGE,	   									RESID_PAGE_PAGEPROFILE );
		}
	}
	else
	{
		if ( bHasModules )
   		{
 	RuleIf( RESID_PAGE_PAGEINSTPATH, 			RETURN_NORMAL,  			RESID_PAGE_PAGEMODULES );
 	RuleIf( RESID_PAGE_PAGEINSTPATH, 			RETURN_USERDEFINED,   		RESID_PAGE_PAGEMODULES );

	RuleIf( RESID_PAGE_PAGEMODULES, 	   		RETURN_OWN,					RESID_PAGE_PAGEPROFILE );
	RuleIf( RESID_PAGE_PAGEMODULES, 	   		RETURN_PREDEFINED,			RESID_PAGE_PAGEHAVEFUN );
    	}
		else
		{
 	RuleIf( RESID_PAGE_PAGEINSTPATH, 			RETURN_NORMAL,  			RESID_PAGE_PAGEPROFILE );
 	RuleIf( RESID_PAGE_PAGEINSTPATH, 			RETURN_USERDEFINED,   		RESID_PAGE_PAGEPROFILE );
		}
	}

	RuleIf( RESID_PAGE_PAGEPROFILE, 			RETURN_ADDNEW,		  		RESID_PAGE_PAGEUSERDEFINED );
	RuleIf( RESID_PAGE_PAGEPROFILE, 			RETURN_NEXT,		  		RESID_PAGE_PAGEHAVEFUN );

	Rule  ( RESID_PAGE_PAGEUSERDEFINED,	   									RESID_PAGE_PAGEPROFILE );
}

// ============================================================================
// AppServerInstallation
// ============================================================================
void SetupAgentDialog::CreateModel_AppServerInstallation()
{
	BOOL bHasLanguages  = pEnv->GetUILanguageContext().Count() > 1 ? TRUE : FALSE;
	BOOL bOnlyCustom	= pCScript->GetInstallation()->IsOnlyCustom();
	BOOL bIsPageReadyGo = pCScript->GetInstallation()->IsPageReadyGo();

	eModelType = MODEL_FIRST_INST_APPSERVER;

	InsertPage( RESID_PAGE_PAGEWELCOME, 		PageWelcome::Create,			SMALL_PAGE,
				AGENT_STARTPAGE );
	InsertPage( RESID_PAGE_PAGELICENSE, 		PageLicense::Create,			LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEREADME,			PageReadme::Create,				LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEINSTALLMODE,     PageInstallMode::Create,	  	SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEINSTPATH,		PageInstPath::Create,			SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEUSERDEFINED,     PageUserDefined::Create,	  	LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGELANGUAGE,		PageLanguage::Create,	 	   	SMALL_PAGE );
	InsertPage( RESID_PAGE_PAGEREADYGO,     	PageReadyGo::Create,	   		SMALL_PAGE );

	Rule	( RESID_PAGE_PAGEWELCOME,			   		RESID_PAGE_PAGEREADME );
	Rule	( RESID_PAGE_PAGEREADME,			  		RESID_PAGE_PAGELICENSE );
	if( bHasLanguages )
	{
		Rule	( RESID_PAGE_PAGELICENSE,			  	RESID_PAGE_PAGELANGUAGE );
		if( bOnlyCustom )
			Rule( RESID_PAGE_PAGELANGUAGE,				RESID_PAGE_PAGEINSTPATH );
		else

			Rule( RESID_PAGE_PAGELANGUAGE,				RESID_PAGE_PAGEINSTALLMODE );
	}
	else
	{
		if( bOnlyCustom )
			Rule( RESID_PAGE_PAGELICENSE,				RESID_PAGE_PAGEINSTPATH );
		else
			Rule( RESID_PAGE_PAGELICENSE,				RESID_PAGE_PAGEINSTALLMODE );
	}

	if( !bOnlyCustom )
		Rule( RESID_PAGE_PAGEINSTALLMODE,				RESID_PAGE_PAGEINSTPATH );

	if (bIsPageReadyGo) RuleIf	( RESID_PAGE_PAGEINSTPATH, RETURN_NORMAL,  		RESID_PAGE_PAGEREADYGO );
	RuleIf	( RESID_PAGE_PAGEINSTPATH, RETURN_USERDEFINED, 	RESID_PAGE_PAGEUSERDEFINED );

	if (bIsPageReadyGo) Rule	( RESID_PAGE_PAGEUSERDEFINED,	   				RESID_PAGE_PAGEREADYGO );

	if( bOnlyCustom )
	{
		pCScript->GetRootModule()->Select( SiModule::ALL_DEFAULT );
		pEnv->SetInstallType( IT_USERDEFINED );
	}
}

// ============================================================================
// AppServerReInstallation
// ============================================================================
void SetupAgentDialog::CreateModel_AppServerReInstallation()
{
	eModelType = MODEL_REINST_APPSERVER;

	InsertPage( RESID_PAGE_PAGEASRV_REINSTALLATION,	PageASrvReInstallation::Create, SMALL_PAGE,
				AGENT_STARTPAGE );
	InsertPage( RESID_PAGE_PAGEASRV_UNINSTALL, 		PageASrvUnInstall::Create,		SMALL_PAGE);

	RuleIf	( RESID_PAGE_PAGEASRV_REINSTALLATION, RETURN_APS_DEINSTALL, RESID_PAGE_PAGEASRV_UNINSTALL );
}

// ============================================================================
// CRCCheck
// ============================================================================
void SetupAgentDialog::CreateModel_CRCCheck()
{
	eModelType = MODEL_CRCCHECK;
	InsertPage( RESID_PAGE_PAGECRCCHECK, PageCRCCheck::Create, SMALL_PAGE, AGENT_STARTPAGE );
}

// ============================================================================
// CRCCheck
// ============================================================================
void SetupAgentDialog::CreateModel_UserDataOnly()
{
	eModelType = MODEL_USERDATAONLY;

	InsertPage( RESID_PAGE_PAGEUSERREGISTRATION,	PageUserRegistration::Create,	LARGE_PAGE, AGENT_STARTPAGE );
	InsertPage( RESID_PAGE_PAGELICENSE, 			PageLicense::Create,			LARGE_PAGE );
	InsertPage( RESID_PAGE_PAGEADDRESS,     		PageAddress::Create,	 		LARGE_PAGE );

	Rule	( RESID_PAGE_PAGEUSERREGISTRATION,		RESID_PAGE_PAGELICENSE );
	Rule	( RESID_PAGE_PAGELICENSE,				RESID_PAGE_PAGEADDRESS );
}

// ============================================================================
// OfficeRepair
// ============================================================================
void SetupAgentDialog::CreateModel_OfficeRepair()
{
	eModelType = MODEL_OFFICEREPAIR;
	InsertPage( RESID_PAGE_PAGEREPAIR, PageRepair::Create, SMALL_PAGE, AGENT_STARTPAGE );
}

