/*************************************************************************
 *
 *  $RCSfile: paddr.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/09 10:07:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>

#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef NOOLDSV //autogen
#include <vcl/system.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#include <tools/l2txtenc.hxx>

#include "maindlg.hxx"
#include "environ.hxx"
#include "os.hxx"
#include "sihelp.hxx"

#include "paddr.hxx"
#include "paddr.hrc"

#include "stringhelper.hxx"

// -----------------------------------------------------------------------------
PageAddress::PageAddress( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage			( pParent, rResId ),
	m_aFTInfo1			( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	m_aCompanyLbl		( this, ResId( FT_COMPANY ) ),
	m_aCompanyEdit		( this, ResId( ED_COMPANY ) ),
	m_aNameLbl			( this, ResId( FT_NAME ) ),
	m_aNameLblRuss		( this, ResId( FT_NAME_RUSS ) ),
	m_aFatherName		( this, ResId( ED_FATHERNAME ) ),
	m_aFirstName 		( this, ResId( ED_FIRSTNAME ) ),
	m_aName				( this, ResId( ED_NAME ) ),
	m_aShortName 		( this, ResId( ED_SHORTNAME ) ),
	m_aStreetLbl 		( this, ResId( FT_STREET ) ),
	m_aStreetLblRuss	( this, ResId( FT_STREET_RUSS ) ),
	m_aStreetEdit		( this, ResId( ED_STREET ) ),
	m_aApartmentEdit	( this, ResId( ED_APARTMENTNR_RUSS ) ),
	m_aCityLbl			( this, ResId( FT_CITY ) ),
//	m_aCountryEdit		( this, ResId( ED_COUNTRY ) ),
	m_aPLZEdit			( this, ResId( ED_PLZ ) ),
	m_aCityEdit			( this, ResId( ED_CITY ) ),
	m_aUsCityEdit		( this, ResId( ED_US_CITY ) ),
	m_aStateEdit 		( this, ResId( ED_STATE ) ),
	m_aUsStateEdit		( this, ResId( ED_US_STATE ) ),
	m_aUsPLZEdit 		( this, ResId( ED_US_ZIP ) ),
//	m_aUsCountryEdit	( this, ResId( ED_US_COUNTRY ) ),
	m_aCountryLbl  		( this, ResId( FT_COUNTRY ) ),
	m_aCountryList 		( this, ResId( LB_COUNTRY ) ),
	m_aTitlePosLbl		( this, ResId( FT_TITLEPOS ) ),
	m_aTitleEdit		( this, ResId( ED_TITLE ) ),
	m_aPositionEdit		( this, ResId( ED_POSITION ) ),
	m_aTelPrivLbl		( this, ResId( FT_TELPRIVAT ) ),
	m_aTelPrivEdit		( this, ResId( ED_TELPRIVAT ) ),
	m_aTelCompanyLbl	( this, ResId( FT_TELCOMPANY ) ),
	m_aTelCompanyEdit	( this, ResId( ED_TELCOMPANY ) ),
	m_aFaxLbl	 		( this, ResId( FT_FAX ) ),
	m_aFaxEdit	 		( this, ResId( ED_FAX ) ),
	m_aEmailLbl	 		( this, ResId( FT_EMAIL ) ),
	m_aEmailEdit  		( this, ResId( ED_EMAIL ) ),
	m_aWarnUser  		( ResId( STR_WARN_USER ) ),
	m_aWarnUserPuff		( ResId( STR_WARN_USER_PUFF ) ),
	m_aWarnUserCampus	( ResId( STR_WARN_USER_CAMPUS ) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aTitle );

	m_aNameLblRuss.Hide();
	m_aFatherName.Hide();
	m_aStreetLblRuss.Hide();
	m_aApartmentEdit.Hide();
	m_aFTInfo1.Hide();

	if( GETDLG()->GetLanguage() == 1 /* LANGUAGE_ENGLISH_US */ )
	{
		m_aCityEdit.Hide();
		m_aPLZEdit.Hide();
		m_aStateEdit.Hide();

		m_aUsCityEdit.Show();
		m_aUsPLZEdit.Show();
		m_aUsStateEdit.Show();

		m_aCityLbl.SetText( UniString( ResId(STR_US_CITY) ) );
	}
	else if( GETDLG()->GetLanguage() == 7 /* LANGUAGE_RUSSIAN */ )
	{
		m_aNameLbl.Hide();
		m_aStreetLbl.Hide();

		m_aFirstName.SetPosSizePixel( LogicToPixel(Point(118,24), MAP_APPFONT) ,
								 LogicToPixel(Size(47,12), MAP_APPFONT) );
		m_aName.SetPosSizePixel( LogicToPixel(Point(218,24), MAP_APPFONT) ,
								 LogicToPixel(Size(47,12), MAP_APPFONT) );
		m_aShortName.SetPosSizePixel( LogicToPixel(Point(268,24), MAP_APPFONT) ,
								 LogicToPixel(Size(15,12), MAP_APPFONT) );
		m_aStreetEdit.SetPosSizePixel( LogicToPixel(Point(118,39), MAP_APPFONT) ,
								 LogicToPixel(Size(115,12), MAP_APPFONT) );

		m_aNameLblRuss.Show();
		m_aFatherName.Show();
		m_aStreetLblRuss.Show();
		m_aApartmentEdit.Show();
	}

	FreeResource();

	m_aCountryList.SetDropDownLineCount( 5 );

	m_aFirstName.SetModifyHdl( LINK( this, PageAddress, ModifyHdl ) );
	m_aName.SetModifyHdl( LINK( this, PageAddress, ModifyHdl ) );
	
	SiEnvironment* pEnv = GETDLG()->GetEnv();

	// init fields
	if( pEnv->GetUserName().getLength() )
		m_aName.SetText( pEnv->GetUserName());
	// UniString(pEnv->GetUserName(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetUserFirstName().getLength() )
		m_aFirstName.SetText( pEnv->GetUserFirstName());
	// m_aFirstName.SetText( UniString(pEnv->GetUserFirstName(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetUserId().getLength() )
		m_aShortName.SetText( pEnv->GetUserId());
	// m_aShortName.SetText( UniString(pEnv->GetUserId(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetUserFatherName().getLength() )
		m_aFatherName.SetText( pEnv->GetUserFatherName());
	// m_aFatherName.SetText( UniString(pEnv->GetUserFatherName(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetUserEMail().getLength() )
		m_aEmailEdit.SetText( pEnv->GetUserEMail());
	// m_aEmailEdit.SetText( UniString(pEnv->GetUserEMail(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetStreet().getLength() )
		m_aStreetEdit.SetText( pEnv->GetStreet());
	// m_aStreetEdit.SetText( UniString(pEnv->GetStreet(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetApartment().getLength() )
		m_aApartmentEdit.SetText( pEnv->GetApartment());
	// 	m_aApartmentEdit.SetText( UniString(pEnv->GetApartment(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetZip().getLength() )
	{
		if( GETDLG()->GetLanguage() == 1 )
		{
			m_aUsPLZEdit.SetText( pEnv->GetZip());
			// m_aUsPLZEdit.SetText( UniString(pEnv->GetZip(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
		}
		else
		{
			m_aPLZEdit.SetText( pEnv->GetZip());
			// m_aPLZEdit.SetText( UniString(pEnv->GetZip(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
		}
	}
	
	if( pEnv->GetCity().getLength() )
	{
		if( GETDLG()->GetLanguage() == 1 )
		{
			m_aUsCityEdit.SetText( pEnv->GetCity());
			// m_aUsCityEdit.SetText( UniString(pEnv->GetCity(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
		}
		else
		{
			m_aCityEdit.SetText( pEnv->GetCity());
			// m_aCityEdit.SetText( UniString(pEnv->GetCity(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
		}
	}
	
	if( pEnv->GetTitle().getLength() )
		m_aTitleEdit.SetText( pEnv->GetTitle());
	// m_aTitleEdit.SetText( UniString(pEnv->GetTitle(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetPosition().getLength() )
		m_aPositionEdit.SetText( pEnv->GetPosition());
		// m_aPositionEdit.SetText( UniString(pEnv->GetPosition(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetFax().getLength() )
		m_aFaxEdit.SetText( pEnv->GetFax());
	// m_aFaxEdit.SetText( UniString(pEnv->GetFax(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetTelefonWork().getLength() )
		m_aTelCompanyEdit.SetText( pEnv->GetTelefonWork());
	// m_aTelCompanyEdit.SetText( UniString(pEnv->GetTelefonWork(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetTelefonHome().getLength() )
		m_aTelPrivEdit.SetText( pEnv->GetTelefonHome());
	// m_aTelPrivEdit.SetText( UniString(pEnv->GetTelefonHome(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );

	if( pEnv->GetState().getLength() )
	{	if( GETDLG()->GetLanguage() == 1 )
		{
			m_aUsStateEdit.SetText( pEnv->GetState());
			// m_aUsStateEdit.SetText( UniString(pEnv->GetState(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
		}
		else
		{
			m_aStateEdit.SetText( pEnv->GetState());
			// m_aStateEdit.SetText( UniString(pEnv->GetState(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
		}
	}
	

	if( pEnv->GetCompanyName().getLength() )
	{
		m_aCompanyEdit.SetText(  pEnv->GetCompanyName() );
		// m_aCompanyEdit.SetText( UniString(pEnv->GetCompanyName(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
	}
	
	if( pEnv->GetCountryIdx() != 0 )
		SelectLanguageByIdx( pEnv->GetCountryIdx() );
	else
		SelectInitialLanguage();

	m_aCompanyEdit.GrabFocus();
}

PageAddress::~PageAddress()
{
}

SvAgentPage* PageAddress::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageAddress( pParent, rResId );
}

void PageAddress::SelectInitialLanguage()
{
	USHORT nIdx = 0;
	switch( GetSystemLanguage() )
	{
		case LANGUAGE_DANISH:					nIdx = DAENEMARK; break;
		case LANGUAGE_DUTCH:                    nIdx = NIEDERLANDE; break;
		case LANGUAGE_DUTCH_BELGIAN:			nIdx = BELGIEN; break;
		case LANGUAGE_ENGLISH:
		case LANGUAGE_ENGLISH_UK:
		case LANGUAGE_ENGLISH_EIRE:
		case LANGUAGE_ENGLISH_SAFRICA:
		case LANGUAGE_ENGLISH_JAMAICA:
		case LANGUAGE_ENGLISH_BELIZE:
		case LANGUAGE_ENGLISH_TRINIDAD:
		case LANGUAGE_ENGLISH_ZIMBABWE:
		case LANGUAGE_ENGLISH_PHILIPPINES:		nIdx = GROSSBRITANNIEN; break;
		case LANGUAGE_ENGLISH_US:
		case LANGUAGE_ENGLISH_CAN:				nIdx = VEREINIGTE_STAATEN_VON_AMERIKA; break;
		case LANGUAGE_ENGLISH_AUS:
		case LANGUAGE_ENGLISH_NZ:				nIdx = AUSTRALIEN; break;
		case LANGUAGE_FINNISH:					nIdx = FINNLAND; break;
		case LANGUAGE_FRENCH_CANADIAN:			nIdx = VEREINIGTE_STAATEN_VON_AMERIKA; break;
		case LANGUAGE_FRENCH:
		case LANGUAGE_FRENCH_BELGIAN:
		case LANGUAGE_FRENCH_SWISS:
		case LANGUAGE_FRENCH_LUXEMBOURG:
		case LANGUAGE_FRENCH_MONACO:			nIdx = FRANKREICH; break;
		case LANGUAGE_GERMAN:
		case LANGUAGE_GERMAN_SWISS:
		case LANGUAGE_GERMAN_AUSTRIAN:
		case LANGUAGE_GERMAN_LUXEMBOURG:
		case LANGUAGE_GERMAN_LIECHTENSTEIN:		nIdx = BUNDESREPUBLIK_DEUTSCHLAND; break;
		case LANGUAGE_ITALIAN:
		case LANGUAGE_ITALIAN_SWISS:			nIdx = ITALIEN; break;
		case LANGUAGE_NORWEGIAN:
		case LANGUAGE_NORWEGIAN_BOKMAL:			nIdx = NORWEGEN; break;
		case LANGUAGE_PORTUGUESE:				nIdx = PORTUGAL; break;
		case LANGUAGE_PORTUGUESE_BRAZILIAN:		nIdx = BRASILIEN; break;
		case LANGUAGE_SPANISH_MODERN:
		case LANGUAGE_SPANISH:					nIdx = SPANIEN; break;
		case LANGUAGE_SPANISH_MEXICAN:			nIdx = MEXIKO; break;
		case LANGUAGE_SPANISH_GUATEMALA:		nIdx = GUATEMALA; break;
		case LANGUAGE_SPANISH_COSTARICA:		nIdx = COSTA_RICA; break;
		case LANGUAGE_SPANISH_PANAMA:			nIdx = PANAMA; break;
// 		case LANGUAGE_SPANISH_DOMINICAN:		nIdx = DOMINIKANISCHE_REPUBLIK; break;
		case LANGUAGE_SPANISH_VENEZUELA:		nIdx = VENEZUELA; break;
		case LANGUAGE_SPANISH_COLOMBIA:			nIdx = KOLUMBIEN; break;
		case LANGUAGE_SPANISH_PERU:				nIdx = PERU; break;
		case LANGUAGE_SPANISH_ARGENTINA:		nIdx = ARGENTINIEN; break;
		case LANGUAGE_SPANISH_ECUADOR:			nIdx = ECUADOR; break;
		case LANGUAGE_SPANISH_CHILE:			nIdx = CHILE; break;
		case LANGUAGE_SPANISH_URUGUAY:			nIdx = URUGUAY; break;
		case LANGUAGE_SPANISH_PARAGUAY:			nIdx = PARAGUAY; break;
		case LANGUAGE_SPANISH_BOLIVIA:			nIdx = SPANIEN; break;
		case LANGUAGE_SWEDISH:					nIdx = SCHWEDEN; break;
		case LANGUAGE_POLISH:					nIdx = POLEN; break;
		case LANGUAGE_CZECH:					nIdx = TSCHECHIEN; break;
		case LANGUAGE_HUNGARIAN:				nIdx = UNGARN; break;
		case LANGUAGE_RUSSIAN:					nIdx = RUSSISCHE_FOEDERATION; break;
		case LANGUAGE_SLOVAK:					nIdx = SLOWAKEI; break;
		case LANGUAGE_CHINESE_SIMPLIFIED:		nIdx = CHINA; break;
		case LANGUAGE_JAPANESE:					nIdx = JAPAN; break;
		case LANGUAGE_THAI:                     nIdx = THAILAND; break;
//		case LANGUAGE_ARABIC:
        case LANGUAGE_ARABIC_SAUDI_ARABIA:      nIdx = SAUDI_ARABIEN; break;
//        case LANGUAGE_ARABIC_IRAQ:
        case LANGUAGE_ARABIC_EGYPT:             nIdx = AEGYPTEN; break;
//        case LANGUAGE_ARABIC_LIBYA:
        case LANGUAGE_ARABIC_ALGERIA:           nIdx = ALGERIEN; break;
        case LANGUAGE_ARABIC_MOROCCO:           nIdx = MAROKKO; break;
        case LANGUAGE_ARABIC_TUNISIA:           nIdx = TUNESIEN; break;
//        case LANGUAGE_ARABIC_OMAN:
//        case LANGUAGE_ARABIC_YEMEN:
//        case LANGUAGE_ARABIC_SYRIA:
        case LANGUAGE_ARABIC_JORDAN:            nIdx = JORDANIEN; break;
        case LANGUAGE_ARABIC_LEBANON:           nIdx = LIBANON; break;
        case LANGUAGE_ARABIC_KUWAIT:            nIdx = KUWAIT; break;
        case LANGUAGE_ARABIC_UAE:               nIdx = VEREINIGTE_ARABISCHE_EMIRATE; break;
//        case LANGUAGE_ARABIC_BAHRAIN:
        case LANGUAGE_ARABIC_QATAR:             nIdx = AEGYPTEN; break;
	}

	if( !nIdx )
	{
		DBG_ERRORFILE( "Found no country for language" );
        m_aCountryList.SetNoSelection();
		return;
	}
	SelectLanguageByIdx( nIdx );
}

void PageAddress::SelectLanguageByIdx( USHORT nIdx )
{
	for( USHORT i = 0; i < m_aCountryList.GetEntryCount(); ++i )
	{
		USHORT nID = (USHORT) (ULONG) m_aCountryList.GetEntryData(i);
		if( nID == nIdx )
		{
			m_aCountryList.SelectEntryPos(i);
			break;
		}
	}
}

USHORT PageAddress::GetReturnVal()
{
	return PADDR_NORMAL;
}

ULONG PageAddress::GetProperty()
{
	Userdata2Env();
	return PROP_NOTSET;
}

BOOL PageAddress::AllowNext()
{
	Userdata2Env();
	return TRUE;
}

void PageAddress::Userdata2Env()
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();

	USHORT nLangIdx = (USHORT)(ULONG) m_aCountryList.GetEntryData( m_aCountryList.GetSelectEntryPos() );

	// pEnv->SetCountry( ByteString(m_aCountryList.GetSelectEntry(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) );
	pEnv->SetCountry( stringhelper::TrimString(m_aCountryList.GetSelectEntry()));
	pEnv->SetCountryIdx( nLangIdx );

	pEnv->SetUserName(      GetUserName() );
	pEnv->SetUserFirstName( GetUserFirstName() );

	pEnv->SetUserId(        GetUserId() );
	pEnv->SetUserEMail(     GetEMail() );
	pEnv->SetCompanyName(   GetCompanyName() );
	pEnv->SetStreet(        GetCtrl(m_aStreetEdit) );

	pEnv->SetCity(          GetCtrl(m_aCityEdit) );
	pEnv->SetTitle(         GetCtrl(m_aTitleEdit) );
	pEnv->SetPosition(      GetCtrl(m_aPositionEdit) );
	pEnv->SetFax(           GetCtrl(m_aFaxEdit) );
	pEnv->SetTelefonWork(   GetCtrl(m_aTelCompanyEdit) );
	pEnv->SetTelefonHome(   GetCtrl(m_aTelPrivEdit) );
	pEnv->SetState(         GetCtrl(m_aStateEdit) );

	if( GETDLG()->GetLanguage() == 1 )
	{
		pEnv->SetZip( GetCtrl(m_aUsPLZEdit) );
		pEnv->SetCity( GetCtrl(m_aUsCityEdit) );
	}
	else
	{
		pEnv->SetZip( GetCtrl(m_aPLZEdit) );
		pEnv->SetCity( GetCtrl(m_aCityEdit) );
	}
}

String PageAddress::GetCompanyName() const
{
	String aStr( m_aCompanyEdit.GetText() );
	return stringhelper::TrimString(aStr);
}

String PageAddress::GetUserName() const
{
	String aStr( m_aName.GetText() );
	return stringhelper::TrimString(aStr);
}

String PageAddress::GetUserFirstName() const
{
	String aStr( m_aFirstName.GetText() );
	return stringhelper::TrimString(aStr);
}

String PageAddress::GetUserId() const
{
	String aStr( m_aShortName.GetText() );
	return stringhelper::TrimString(aStr);
}

String PageAddress::GetEMail() const
{
	String aStr( m_aEmailEdit.GetText() );
	return stringhelper::TrimString(aStr);
}

String PageAddress::GetCtrl(const Edit& rEdit) const
{
	String aStr( rEdit.GetText() );
	return stringhelper::TrimString(aStr);
}

IMPL_LINK( PageAddress, ModifyHdl, Edit*, pEdit )
{
	UniString aShort( m_aShortName.GetText() );
	switch( aShort.Len() )
	{
		case 0:	aShort = UniString::CreateFromAscii("  "); break;
		case 1: aShort += UniString::CreateFromAscii(" "); break;
	}
	if( pEdit == &m_aFirstName )
	{
		aShort.Erase( 0, 1 );
		if( m_aFirstName.GetText().Len() )
			aShort.Insert( m_aFirstName.GetText().GetChar(0), 0 );
		else
			aShort.Insert( ' ', 0 );
	}
	else if( pEdit == &m_aName )
	{
		aShort.Erase( 1, 1 );
		if( m_aName.GetText().Len() )
			aShort.Insert( m_aName.GetText().GetChar(0), 1 );
		else
			aShort.Insert( ' ', 1 );
	}
	m_aShortName.SetText( aShort );

	return 0;
}

