/*************************************************************************
 *
 *  $RCSfile: pcrc.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "environ.hxx"

#include "maindlg.hxx"
#include "script.hxx"
#include "zipfile.hxx"
#include "decltor.hxx"

#include "pcrc.hxx"
#include "pcrc.hrc"

PageCRCCheck::PageCRCCheck( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTInfo3		( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	aFTInfo4		( this, ResId(FT_INFO4, rResId.GetResMgr()) ),
	aFTInfo5		( this, ResId(FT_INFO5, rResId.GetResMgr()) ),
	aProgress		( this, ResId(WIN_PROGRESS, rResId.GetResMgr()) ),
	aStrInfo		( ResId(STR_INFO, rResId.GetResMgr()) ),
	aStrFileNotFound( ResId(STR_FILENOTFOUND, rResId.GetResMgr()) ),
	aStrCRCError	( ResId(STR_CRCERROR, rResId.GetResMgr()) ),
	nMaxCount		( 0 ),
	nActCount		( 0 )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aTitle );
	FreeResource();

	SiEnvironment* pEnv = GETDLG()->GetEnv();

	aProgress.SetSizePixel( LogicToPixel(Size(200, 18), MAP_APPFONT) );
	Size aSz = aProgress.GetOutputSizePixel();
	aSz.Width() -= (aSz.Width() -4)% (((aSz.Height() -4) *2 / 3) + 3);
	aProgress.SetOutputSizePixel( aSz );
	aProgress.Show();

	CountFiles( GETDLG()->GetCScript()->GetRootModule() );

	Font aBold( aFTInfo2.GetFont() );
	aBold.SetWeight( WEIGHT_BOLD );
	aFTInfo2.SetFont( aBold );
	aFTInfo2.SetText( UniString::CreateFromAscii(
		pEnv->GetSourcePath().Len()? pEnv->GetSourcePath().GetBuffer() : pEnv->GetStartPath().GetBuffer()) );

	aTitle = aFTInfo3.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%2"), UniString::CreateFromInt32(nMaxCount) );
	aFTInfo3.SetText( aTitle );

	GetAgentDlg()->SetButtonState( BSTATE_DISABLE_NEXT | BSTATE_HIDE_NEXT | BSTATE_DISABLE_CANCEL );

	aTimer.SetTimeoutHdl( LINK(this, PageCRCCheck, StartTimer) );
	aTimer.SetTimeout( 1000 );
	aTimer.Start();
}

PageCRCCheck::~PageCRCCheck()
{
}

SvAgentPage* PageCRCCheck::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageCRCCheck( pParent, rResId );
}

void PageCRCCheck::InitProperty(ULONG nProp)
{
	GetAgentDlg()->SetButtonState( BSTATE_HIDE_BACK );
}

IMPL_LINK(PageCRCCheck,StartTimer,void*,pPtr)
{
	SiModule* pRoot = GETDLG()->GetCScript()->GetRootModule();
	DoCRCCheck( pRoot );
	GetAgentDlg()->SetButtonState( BSTATE_HIDE_BACK | BSTATE_ENABLE_NEXT );
	Sound::Beep();
	return 0;
}

void PageCRCCheck::CountFiles(SiModule* pModule)
{
	const SiFileList& rFList = pModule->GetFileList();
	for( USHORT i = 0; i < rFList.Count(); ++i )
	{
		SiFile* pFile = rFList.GetObject(i);
		if( pFile->IsPacked() && !pFile->IsSetupZip() )
			nMaxCount++;
	}
	SiModuleList* pMList = pModule->GetModuleList();
	for( USHORT x = 0; x < pMList->Count(); ++x )
		CountFiles( pMList->GetObject(x) );
}

void PageCRCCheck::DoCRCCheck(SiModule* pModule)
{
	const SiFileList& rFList = pModule->GetFileList();
	SiEnvironment* pEnv = GETDLG()->GetEnv();

	for( USHORT i = 0; i < rFList.Count(); ++i )
	{
		SiFile* pFile = rFList.GetObject(i);
		if( pFile->IsPacked() && !pFile->IsSetupZip() )
		{
			SiDirEntry aFile( pEnv->GetSourcePath() );
			aFile += pFile->GetPackedName();

			String aInfoText( aStrInfo );
			aInfoText.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromInt32(++nActCount) );
			aInfoText.SearchAndReplace( UniString::CreateFromAscii("%2"), UniString::CreateFromInt32(nMaxCount) );

			aFTInfo4.SetText( aInfoText );
			aFTInfo5.SetText( UniString::CreateFromAscii(pFile->GetPackedName().GetBuffer()) );

			float nPercent = 100 * ((float)nActCount / (float)nMaxCount);
			aProgress.SetValue( (USHORT)nPercent );

			Application::Reschedule();

			if( !aFile.Exists() )
			{
				String aMsg( aStrFileNotFound );
				aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"), aFile.GetFullUni() );
				InfoBox( NULL, aMsg ).Execute();
				Application::Reschedule();
				continue;
			}

			SiZipFile aZip;
			int nErr;
			if( (nErr = aZip.CRCCheck(aFile.GetFull())) != 0 )
			{
				String aMsg( aStrCRCError );
				aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"), aFile.GetFullUni() );
				InfoBox( NULL, aMsg ).Execute();
				Application::Reschedule();
				continue;
			}
		}
	}

	SiModuleList* pMList = pModule->GetModuleList();
	for( USHORT x = 0; x < pMList->Count(); ++x )
		DoCRCCheck( pMList->GetObject(x) );
}

