/*************************************************************************
 *
 *  $RCSfile: plang.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HEADBAR_HXX //autogen
#include <svtools/headbar.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SV_SOUND_HXX
#include <vcl/sound.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif


#include "maindlg.hxx"
#include "environ.hxx"
#include "decltor.hxx"
#include "script.hxx"
#include "sibasic.hxx"

#include "plang.hxx"
#include "plang.hrc"

#define 	BTNIDX_PROG		1
#define 	BTNIDX_DOC		2
#define		HEAD_HEIGTH		19

#define		CHECK_ONLY_ONE_LANGUAGE 1

///////////////////////////////////////////////////////////////////////////////
//
PageLanguage::PageLanguage( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aProg			( ResId(STR_PROG, rResId.GetResMgr()) ),
	aDoc			( ResId(STR_DOC, rResId.GetResMgr()) ),
	aLanguage		( ResId(STR_LANGUAGE, rResId.GetResMgr()) ),
	aTabCtrl		( this, ResId(TLB_LANGVIEW, rResId.GetResMgr()) ),
	aGerman			( ResId(STR_LANG_GERMAN, rResId.GetResMgr()) ),
	aEnglishUS		( ResId(STR_LANG_ENGLISH_US, rResId.GetResMgr()) ),
	aPortugues		( ResId(STR_LANG_PORTUGUESE, rResId.GetResMgr()) ),
	aSwedish		( ResId(STR_LANG_SWEDISH, rResId.GetResMgr()) ),
	aDanish			( ResId(STR_LANG_DANISH, rResId.GetResMgr()) ),
	aItalien		( ResId(STR_LANG_ITALIEN, rResId.GetResMgr()) ),
	aSpanish		( ResId(STR_LANG_SPANISH, rResId.GetResMgr()) ),
	aFrench			( ResId(STR_LANG_FRENCH, rResId.GetResMgr()) ),
	aDutch			( ResId(STR_LANG_DUTCH, rResId.GetResMgr()) ),
	aJapan			( ResId(STR_LANG_JAPAN, rResId.GetResMgr()) ),
	aChina			( ResId(STR_LANG_CHINA, rResId.GetResMgr()) ),
	aRussian		( ResId(STR_LANG_RUSSIAN, rResId.GetResMgr()) ),
	aPolen			( ResId(STR_LANG_POLEN, rResId.GetResMgr()) ),
	aTaiwan			( ResId(STR_LANG_TAIWAN, rResId.GetResMgr()) ),
	aAegypt			( ResId(STR_LANG_AEGYPT, rResId.GetResMgr()) ),
	aGreece			( ResId(STR_LANG_GREECE, rResId.GetResMgr()) ),
	aKorea			( ResId(STR_LANG_KOREA, rResId.GetResMgr()) ),
	aTurkish		( ResId(STR_LANG_TURKISH, rResId.GetResMgr()) )
{
    String aFT_Net( ResId( STR_FT_INFO1_NET, rResId.GetResMgr()) );
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aTitle );
	FreeResource();

	pEnv = GETDLG()->GetEnv();

	aTabCtrl.SetEnv(pEnv);
	aTabCtrl.SetInstallation(GETDLG()->GetCScript()->GetInstallation());

    String aProdName = UniString::CreateFromAscii(pEnv->GetProductName().GetBuffer());
    String aReplace = UniString::CreateFromAscii("%1");

    aTitle = aFTInfo1.GetText();
	aTitle.SearchAndReplace( aReplace, aProdName );
	aFTInfo1.SetText( aTitle );

	aFT_Net.SearchAndReplace( aReplace, aProdName );

    if ( !pEnv->IsLocal() )
        aFTInfo1.SetText( aFT_Net );

	aTitle = aFTInfo2.GetText();
	aTitle.SearchAndReplace( aReplace, aProdName );
	aFTInfo2.SetText( aTitle );

#ifndef CHECK_ONLY_ONE_LANGUAGE
	if( !pEnv->IsLocal() )
#endif
		aFTInfo2.Hide();

	Point aPt( aTabCtrl.GetPosPixel() );
	Size  aSz( aTabCtrl.GetSizePixel() );

	pHeaderBar = new HeaderBar( this, WB_BUTTONSTYLE | WB_BOTTOMBORDER );
	pHeaderBar->SetPosSizePixel( Point(aPt.X(), aPt.Y()-HEAD_HEIGTH+1), Size(aSz.Width(), HEAD_HEIGTH) );

	const long nWidth = 112;
	const long nFlagWidth = 0;
#if defined(CHECK_ONLY_ONE_LANGUAGE)
	if( FALSE )
#else
	if( pEnv->IsLocal() )
#endif
	{
		pHeaderBar->InsertItem( 1, aProg, nWidth, HIB_CENTER | HIB_FIXED);
		pHeaderBar->InsertItem( 2, aDoc, 80, HIB_CENTER | HIB_FIXED);
		pHeaderBar->InsertItem( 3, aLanguage, aSz.Width() - (nWidth + 80), HIB_FIXED );

		// long nTabs[] = { 4, 0, 80, 160, 190 };
		long nTabs[] = { 4, 0, nWidth, nWidth + 80, nWidth + 80 + nFlagWidth };
		aTabCtrl.SvTabListBox::SetTabs( &nTabs[0], MAP_PIXEL );
	}
	else
	{
		pHeaderBar->InsertItem( 1, aProg, nWidth, HIB_CENTER | HIB_FIXED);
		pHeaderBar->InsertItem( 2, aLanguage, aSz.Width() - nWidth, HIB_FIXED );

		// long nTabs[] = { 3, 0, 80, 110 };
		long nTabs[] = { 3, 0, nWidth, nWidth + nFlagWidth };
		aTabCtrl.SvTabListBox::SetTabs( &nTabs[0], MAP_PIXEL );
	}

	pHeaderBar->Show();
	aTabCtrl.Show();
}

///////////////////////////////////////////////////////////////////////////////
//
PageLanguage::~PageLanguage()
{
	delete pHeaderBar;
}

///////////////////////////////////////////////////////////////////////////////
//
SvAgentPage* PageLanguage::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageLanguage( pParent, rResId );
}

///////////////////////////////////////////////////////////////////////////////
//
BOOL PageLanguage::AllowNext()
{
	SiLangCtxList& rLst = pEnv->GetUILanguageContext();
	BOOL bHasProg = FALSE;
	BOOL bHasDoc  = FALSE;

	for( USHORT x = 0; x < rLst.Count(); ++x )
	{
		LanguageContext* pCtx = (LanguageContext*)rLst.GetObject(x);

        if( pCtx->isProg )
        {
            bHasProg = TRUE;
            
            if ( pEnv->IsLocal() )
            {
                GETDLG()->SwitchLanguage( pCtx->nLanguage );
                GETDLG()->SetLanguage( pCtx->nLanguage );
            }
        }

		if( pCtx->isDoc )
			bHasDoc = TRUE;
    }

	if( !bHasProg )
	{
		ErrorBox(this, WB_OK, String(ResId(STR_ERROR_PROG))).Execute();
		return FALSE;
	}
	if( pEnv->IsLocal() && !bHasDoc )
	{
		ErrorBox(this, WB_OK, String(ResId(STR_ERROR_DOC))).Execute();
		return FALSE;
	}

	SiCompiledScript* pCS = GETDLG()->GetCScript();
	if( pEnv->IsFirstInstallation() )
	{
		SiProcedure* pProc = pCS->FindLanguageSelectProc();
		if( pProc )
        {
			SiBasic aBasic( *pCS, *pEnv );
            if ( pEnv->HasVCL() )
            {
                NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
                aBasic.Call( pProc->GetProcName(), pProc->GetCode() );
            }
            else
                aBasic.Call( pProc->GetProcName(), pProc->GetCode() );
		}
	}

	return TRUE;
}

ULONG PageLanguage::GetProperty()
{
	return 1;
}

void PageLanguage::InitProperty(ULONG nProp)
{
	if( nProp == PROP_NOTSET )
		SetNiceDefault();

	InitLangEntrys();
}

///////////////////////////////////////////////////////////////////////////////
//
void PageLanguage::SetNiceDefault( BOOL bDefLang )
{
	if( !pEnv->IsFirstInstallation() || !pEnv->IsUINiceLangDefault() )
		return;

	USHORT nUILang	= GETDLG()->GetLanguage();
	USHORT nDefLang	= (USHORT) GETDLG()->GetCScript()->GetInstallation()->GetDefLanguage().ToInt32();

	SiLangCtxList& rLst = pEnv->GetUILanguageContext();
	for( USHORT x = 0; x < rLst.Count(); ++x )
	{
		LanguageContext* pCtx = (LanguageContext*)rLst.GetObject(x);
		if( (!bDefLang && (pCtx->nLanguage == nUILang)) ||
			(bDefLang && (pCtx->nLanguage == nDefLang)) )
		{
#ifdef CHECK_ONLY_ONE_LANGUAGE
            pCtx->isDoc = TRUE;
#else
			pCtx->isDoc	 = pEnv->IsLocal()? TRUE : FALSE;
#endif
			pCtx->isProg = TRUE;
			return;
		}
	}
	if( !bDefLang )
		SetNiceDefault( TRUE );
}

void PageLanguage::InitLangEntrys()
{
	SiLangCtxList& rLst = pEnv->GetUILanguageContext();

	for( USHORT x = 0; x < rLst.Count(); ++x )
	{
		LanguageContext* pCtx = (LanguageContext*)rLst.GetObject(x);
		SvLBoxEntry* pEntry = NULL;
		switch( pCtx->nLanguage )
		{
			case 49 : pEntry = aTabCtrl.CreateEntry( aGerman,		ResId(FLAG_GERMAN) );		break;
			case 1  : pEntry = aTabCtrl.CreateEntry( aEnglishUS,	ResId(FLAG_ENGLISH_US) );	break;
			case 3  : pEntry = aTabCtrl.CreateEntry( aPortugues,	ResId(FLAG_PORTUGUESE) );	break;
			case 46 : pEntry = aTabCtrl.CreateEntry( aSwedish,		ResId(FLAG_SWEDISH) );		break;
			case 45 : pEntry = aTabCtrl.CreateEntry( aDanish,		ResId(FLAG_DANISH) );		break;
			case 39 : pEntry = aTabCtrl.CreateEntry( aItalien,		ResId(FLAG_ITALIEN) );		break;
			case 34 : pEntry = aTabCtrl.CreateEntry( aSpanish,		ResId(FLAG_SPANISH) );		break;
			case 33 : pEntry = aTabCtrl.CreateEntry( aFrench,		ResId(FLAG_FRENCH) );		break;
			case 31 : pEntry = aTabCtrl.CreateEntry( aDutch,		ResId(FLAG_DUTCH) );		break;
			case 81 : pEntry = aTabCtrl.CreateEntry( aJapan,		ResId(FLAG_JAPAN) );		break;
			case 86 : pEntry = aTabCtrl.CreateEntry( aChina,		ResId(FLAG_CHINA) );		break;
			case 7  : pEntry = aTabCtrl.CreateEntry( aRussian,		ResId(FLAG_RUSSIAN) );		break;
			case 48 : pEntry = aTabCtrl.CreateEntry( aPolen,		ResId(FLAG_POLEN) );		break;
			case 88 : pEntry = aTabCtrl.CreateEntry( aTaiwan,		ResId(FLAG_TAIWAN) );		break;
			case 96 : pEntry = aTabCtrl.CreateEntry( aAegypt,		ResId(FLAG_AEGYPT) );		break;
			case 30 : pEntry = aTabCtrl.CreateEntry( aGreece,		ResId(FLAG_GREECE) );		break;
			case 82 : pEntry = aTabCtrl.CreateEntry( aKorea,		ResId(FLAG_KOREA) );		break;
			case 90 : pEntry = aTabCtrl.CreateEntry( aTurkish,		ResId(FLAG_TURKISH) );		break;
		}
		if( pEntry )
		{
			if( pCtx->isProg )
            {
				((SvLBoxButton*)pEntry->GetItem(BTNIDX_PROG))->SetStateChecked();
            	aTabCtrl.Select( pEntry );
            }
#ifndef CHECK_ONLY_ONE_LANGUAGE
			if( pEnv->IsLocal() && pCtx->isDoc )
				((SvLBoxButton*)pEntry->GetItem(BTNIDX_DOC))->SetStateChecked();
#endif

			pEntry->SetUserData( (void*)pCtx );

			if( !pEnv->IsFirstInstallation() )
			{
				SiInstallation*	pInst = GETDLG()->GetCScript()->GetInstallation();
				BOOL bProg, bDoc;
				if( pInst->IsLanguageInstalled(pCtx->nLanguage, bProg, bDoc) )
				{
					SvLBoxButton* pButton = (SvLBoxButton*) pEntry->GetItem(BTNIDX_PROG);
					pButton->SetBaseOffs(0);
					if( bProg )
						pButton->SetBaseOffs(6);

#ifndef CHECK_ONLY_ONE_LANGUAGE
					if( pEnv->IsLocal() )
					{
						pButton = (SvLBoxButton*) pEntry->GetItem(BTNIDX_DOC);
						pButton->SetBaseOffs(0);
						if( bDoc )
							pButton->SetBaseOffs(6);
					}
#endif
				}
			}
			aTabCtrl.PaintEntry( pEntry );
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
//
//	LanguageTabBox
//
LanguageTabBox::LanguageTabBox( Window* pParent, const ResId& rResId ) :
		SvTabListBox( pParent, rResId )
{
	pBtnDataProgLang = NULL;
	pBtnDataDocLang = NULL;
}

///////////////////////////////////////////////////////////////////////////////
//
LanguageTabBox::~LanguageTabBox()
{
	if( pBtnDataProgLang )
		delete pBtnDataProgLang;
	if( pBtnDataDocLang )
		delete pBtnDataDocLang;
}

///////////////////////////////////////////////////////////////////////////////
//
void LanguageTabBox::SetTabs()
{
	SvTabListBox::SetTabs();

	USHORT nAdjust = SV_LBOXTAB_ADJUST_RIGHT|SV_LBOXTAB_ADJUST_LEFT|SV_LBOXTAB_ADJUST_CENTER|SV_LBOXTAB_ADJUST_NUMERIC|SV_LBOXTAB_FORCE;

	SvLBoxTab* pTab = (SvLBoxTab*)aTabs.GetObject( BTNIDX_PROG );
	pTab->nFlags &= ~nAdjust;
	pTab->nFlags |= SV_LBOXTAB_PUSHABLE|SV_LBOXTAB_ADJUST_CENTER|SV_LBOXTAB_FORCE;

	if( pEnv->IsLocal() )
	{
		pTab = (SvLBoxTab*)aTabs.GetObject( BTNIDX_DOC );
		pTab->nFlags &= ~nAdjust;
		pTab->nFlags |= SV_LBOXTAB_PUSHABLE|SV_LBOXTAB_ADJUST_CENTER|SV_LBOXTAB_FORCE;
	}
}

///////////////////////////////////////////////////////////////////////////////
//
SvLBoxEntry* LanguageTabBox::CreateEntry( const String& rLanguage, const ResId& rLangBmp )
{
	SvLBoxEntry* pEntry = new SvLBoxEntry;

	if( !pBtnDataProgLang )
	{
		pBtnDataProgLang = new SvLBoxButtonData;
		pBtnDataProgLang->SetLink( LINK( this, LanguageTabBox, ClickProgHdl));

#if defined (CHECK_ONLY_ONE_LANGUAGE)
        if ( pEnv->IsLocal() )
#else
        if ( FALSE )
#endif
        {
		    pBtnDataProgLang->aBmps[SV_BMP_UNCHECKED]	= Image( ResId( DEFBUT_UNCHECKED ));
		    pBtnDataProgLang->aBmps[SV_BMP_CHECKED]		= Image( ResId( DEFBUT_CHECKED ) );
		    pBtnDataProgLang->aBmps[SV_BMP_HICHECKED]	= Image( ResId( DEFBUT_HICHECKED ) );
		    pBtnDataProgLang->aBmps[SV_BMP_HIUNCHECKED]	= Image( ResId( DEFBUT_HIUNCHECKED ) );
		    pBtnDataProgLang->aBmps[SV_BMP_TRISTATE]	= Image( ResId( DEFBUT_TRISTATE ) );
		    pBtnDataProgLang->aBmps[SV_BMP_HITRISTATE]	= Image( ResId( DEFBUT_HITRISTATE ) );

		    pBtnDataProgLang->aBmps[6+SV_BMP_UNCHECKED]	= Image( ResId( DEFBUT_DEINST ));
		    pBtnDataProgLang->aBmps[6+SV_BMP_CHECKED]	= Image( ResId( DEFBUT_CHECKED ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_HICHECKED]	= Image( ResId( DEFBUT_HICHECKED ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_HIUNCHECKED]= Image( ResId( DEFBUT_HIUNCHECKED ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_TRISTATE]	= Image( ResId( DEFBUT_TRISTATE ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_HITRISTATE]= Image( ResId( DEFBUT_HITRISTATE ) );
        }
        else
        {
		    pBtnDataProgLang->aBmps[SV_BMP_UNCHECKED]	= Image( ResId( LNGBUT_UNCHECKED ));
		    pBtnDataProgLang->aBmps[SV_BMP_CHECKED]		= Image( ResId( LNGBUT_CHECKED ) );
		    pBtnDataProgLang->aBmps[SV_BMP_HICHECKED]	= Image( ResId( LNGBUT_HICHECKED ) );
		    pBtnDataProgLang->aBmps[SV_BMP_HIUNCHECKED]	= Image( ResId( LNGBUT_HIUNCHECKED ) );
		    pBtnDataProgLang->aBmps[SV_BMP_TRISTATE]	= Image( ResId( LNGBUT_TRISTATE ) );
		    pBtnDataProgLang->aBmps[SV_BMP_HITRISTATE]	= Image( ResId( LNGBUT_HITRISTATE ) );

		    pBtnDataProgLang->aBmps[6+SV_BMP_UNCHECKED]	= Image( ResId( LNGBUT_DEINST ));
		    pBtnDataProgLang->aBmps[6+SV_BMP_CHECKED]	= Image( ResId( LNGBUT_CHECKED ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_HICHECKED]	= Image( ResId( LNGBUT_HICHECKED ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_HIUNCHECKED]= Image( ResId( LNGBUT_HIUNCHECKED ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_TRISTATE]	= Image( ResId( LNGBUT_TRISTATE ) );
		    pBtnDataProgLang->aBmps[6+SV_BMP_HITRISTATE]= Image( ResId( LNGBUT_HITRISTATE ) );
        }
	}

#ifndef CHECK_ONLY_ONE_LANGUAGE
	if( pEnv->IsLocal() && !pBtnDataDocLang )
	{
		pBtnDataDocLang = new SvLBoxButtonData;
		pBtnDataDocLang->SetLink( LINK( this, LanguageTabBox, ClickDocHdl));

		pBtnDataDocLang->aBmps[SV_BMP_UNCHECKED]	= Image( ResId( DEFBUT_UNCHECKED ));
		pBtnDataDocLang->aBmps[SV_BMP_CHECKED]		= Image( ResId( DEFBUT_CHECKED ) );
		pBtnDataDocLang->aBmps[SV_BMP_HICHECKED]	= Image( ResId( DEFBUT_HICHECKED ) );
		pBtnDataDocLang->aBmps[SV_BMP_HIUNCHECKED]	= Image( ResId( DEFBUT_HIUNCHECKED ) );
		pBtnDataDocLang->aBmps[SV_BMP_TRISTATE]		= Image( ResId( DEFBUT_TRISTATE ) );
		pBtnDataDocLang->aBmps[SV_BMP_HITRISTATE]	= Image( ResId( DEFBUT_HITRISTATE ) );

		pBtnDataDocLang->aBmps[6+SV_BMP_UNCHECKED]	= Image( ResId( DEFBUT_DEINST ));
		pBtnDataDocLang->aBmps[6+SV_BMP_CHECKED]	= Image( ResId( DEFBUT_CHECKED ) );
		pBtnDataDocLang->aBmps[6+SV_BMP_HICHECKED]	= Image( ResId( DEFBUT_HICHECKED ) );
		pBtnDataDocLang->aBmps[6+SV_BMP_HIUNCHECKED]= Image( ResId( DEFBUT_HIUNCHECKED ) );
		pBtnDataDocLang->aBmps[6+SV_BMP_TRISTATE]  	= Image( ResId( DEFBUT_TRISTATE ) );
		pBtnDataDocLang->aBmps[6+SV_BMP_HITRISTATE]	= Image( ResId( DEFBUT_HITRISTATE ) );
	}
#endif

	pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(), Image(), 0 ));
	pEntry->AddItem( new SvLBoxButton( pEntry, 0, pBtnDataProgLang ) );

#ifndef CHECK_ONLY_ONE_LANGUAGE
	if( pEnv->IsLocal() )
		pEntry->AddItem( new SvLBoxButton( pEntry, 0, pBtnDataDocLang ) );
#endif

	pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(), Image(), 0 ));
	// pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(Bitmap(rLangBmp)), Image(Bitmap(rLangBmp)), 0 ));
	pEntry->AddItem( new SvLBoxString( pEntry, 0, rLanguage ) );

	Insert( pEntry );
	return pEntry;
}

///////////////////////////////////////////////////////////////////////////////
//
IMPL_LINK( LanguageTabBox, ClickProgHdl, SvLBoxButtonData*, pData )
{
	SvLBoxEntry* pEntry = pData->GetActEntry();
	LanguageContext* pLang = (LanguageContext*) pEntry->GetUserData();
	SvLBoxButton* pButton;

#if defined (CHECK_ONLY_ONE_LANGUAGE)
    if ( pEnv->IsLocal() )
#else
    if ( FALSE )
#endif
        ToggleRadioButton( pData->GetActEntry() );
    else
        pLang->isProg = pData->GetActButtonState() == SV_BUTTON_CHECKED? TRUE : FALSE;

#ifdef CHECK_ONLY_ONE_LANGUAGE
	pLang->isDoc = pLang->isProg;
#endif

	if( !pLang->isProg && pLang->isDoc && pEnv->IsLocal() )
	{
		// uncheck doc item
		pLang->isDoc = FALSE;
		pButton = (SvLBoxButton*)  pEntry->GetItem(BTNIDX_DOC);
		pButton->SetStateUnchecked();
		pButton->SetBaseOffs(0);

		// try to get new doc selection
		SvLBoxTreeList* pModel = GetModel();
        ULONG nCnt = GetEntryCount();

		for( USHORT i = 0; i < nCnt; ++i )
		{
			SvLBoxEntry* pActEntry = (SvLBoxEntry*) pModel->GetEntry( i );

			if( pActEntry != pEntry )
			{
				LanguageContext* pActLang = (LanguageContext*) pActEntry->GetUserData();
				if( pActLang->isProg )
				{
					pActLang->isDoc = TRUE;
					pButton = (SvLBoxButton*) pActEntry->GetItem(BTNIDX_DOC);
					pButton->SetStateChecked();
					pButton->SetBaseOffs(0);
					PaintEntry( pActEntry );
					break;
				}
			}
		}
	}

	pButton = (SvLBoxButton *)pEntry->GetItem(BTNIDX_PROG);
	pButton->SetBaseOffs(0);

	if( !pEnv->IsFirstInstallation() )
	{
		BOOL bProg, bDoc;
		if( pInst->IsLanguageInstalled(pLang->nLanguage, bProg, bDoc) )
			if( bProg )
				pButton->SetBaseOffs(6);
	}

	Select( pEntry );
	return 0;
}

///////////////////////////////////////////////////////////////////////////////
//
void LanguageTabBox::UncheckLocalDoc( SvLBoxEntry* pEntry )
{
#ifndef CHECK_ONLY_ONE_LANGUAGE
	if( pEnv->IsLocal() )
	{
		SvLBoxTreeList* pModel = GetModel();
		ULONG nCnt = GetEntryCount();

		for( USHORT i = 0; i < nCnt; ++i )
		{
			SvLBoxEntry* pActEntry = (SvLBoxEntry*) pModel->GetEntry( i );
			if( pActEntry != pEntry )
			{
				LanguageContext* pActLang = (LanguageContext*) pActEntry->GetUserData();
				if( pActLang->isDoc )
				{
					pActLang->isDoc = FALSE;
					SvLBoxButton* pButton = (SvLBoxButton*) pActEntry->GetItem(BTNIDX_DOC);
					pButton->SetStateUnchecked();
					pButton->SetBaseOffs(0);

					BOOL bProg, bDoc;
					if( pInst->IsLanguageInstalled(pActLang->nLanguage, bProg, bDoc) )
						if( bDoc ) pButton->SetBaseOffs(6);

					PaintEntry( pActEntry );
				}
			}
		}
	}
#endif
}

///////////////////////////////////////////////////////////////////////////////
//
IMPL_LINK( LanguageTabBox, ClickDocHdl, SvLBoxButtonData*, pData )
{
	SvLBoxEntry* pEntry	= pData->GetActEntry();
	LanguageContext* pLang = (LanguageContext*) pEntry->GetUserData();
	SvLBoxButton* pButton;

	SvLBoxButton* pBtn = (SvLBoxButton *)pEntry->GetItem(BTNIDX_DOC);
	if( pData->GetActButtonState() == SV_BUTTON_CHECKED && !pLang->isProg )
	{
		pBtn->SetStateUnchecked();
		Sound::Beep();
		return 0;
	}
	else if( pData->GetActButtonState() == SV_BUTTON_UNCHECKED )
	{
		pBtn->SetStateChecked();
		Sound::Beep();
		return 0;
	}

	pLang->isDoc = pData->GetActButtonState() == SV_BUTTON_CHECKED? TRUE : FALSE;

	pButton = (SvLBoxButton*) pEntry->GetItem(BTNIDX_DOC);
	pButton->SetBaseOffs(0);
	BOOL bProg, bDoc;
	if( pInst->IsLanguageInstalled(pLang->nLanguage, bProg, bDoc) )
		if( bDoc ) pButton->SetBaseOffs(6);

	UncheckLocalDoc(pEntry);

	if( !pEnv->IsLocal() )
	{
		SvLBoxButton* pButton = (SvLBoxButton *)pEntry->GetItem(BTNIDX_PROG);
		if( pLang->isDoc )
		{
			pButton->SetStateChecked();
			pLang->isProg = TRUE;
		}
		else
		{
			pButton->SetStateUnchecked();
			pLang->isProg = FALSE;
		}
	}

	Select( pEntry );
	return 0;
}

///////////////////////////////////////////////////////////////////////////////
//
void LanguageTabBox::KeyInput( const KeyEvent &rKeyEvent )
{
	if( !rKeyEvent.GetKeyCode().IsShift()	&&
		!rKeyEvent.GetKeyCode().IsMod1()	&&
		!rKeyEvent.GetKeyCode().IsMod2() )
	{
		switch( rKeyEvent.GetKeyCode().GetCode() )
		{
			case KEY_SPACE:
			{
#if defined(CHECK_ONLY_ONE_LANGUAGE)
				if ( pEnv->IsLocal() )
#else
                if ( FALSE )
#endif
                    ToggleRadioButton( GetCurEntry() );
                else
                {
                    SvLBoxEntry* pEntry	= GetCurEntry();
				    LanguageContext* pCtx = (LanguageContext*) pEntry->GetUserData();
				    pCtx->isProg = pCtx->isProg? FALSE : TRUE;
				    pCtx->isDoc = pCtx->isProg;
				    if( pCtx->isProg ) {
					    ((SvLBoxButton*)pEntry->GetItem(BTNIDX_PROG))->SetStateChecked();
					    if( pEnv->IsLocal() )
						    ((SvLBoxButton*)pEntry->GetItem(BTNIDX_DOC))->SetStateChecked();
				    }
				    else {
					    ((SvLBoxButton*)pEntry->GetItem(BTNIDX_PROG))->SetStateUnchecked();
					    if( pEnv->IsLocal() )
						    ((SvLBoxButton*)pEntry->GetItem(BTNIDX_DOC))->SetStateUnchecked();
				    }
				    UncheckLocalDoc(pEntry);
				    PaintEntry( pEntry );
                }
			} break;
		}
	}
	SvTabListBox::KeyInput(rKeyEvent);
}

///////////////////////////////////////////////////////////////////////////////
//

void LanguageTabBox::ToggleRadioButton( SvLBoxEntry* pCurEntry )
{
    LanguageContext* pCtx = (LanguageContext*) pCurEntry->GetUserData();

    if ( pCtx->isProg )
    {
        // Button already checked! Don't do anything but setting the
        // state to checked again because the Button::Click handler already
        // toggled the state

        ((SvLBoxButton*)pCurEntry->GetItem(BTNIDX_PROG))->SetStateChecked();
        PaintEntry( pCurEntry );
    }
    else
    {
        // uncheck the previously checked button and check the new one
        ULONG nCount = GetEntryCount();
        SvLBoxEntry* pEntry;

        for ( ULONG x=0; x<nCount; x++ )
        {
            pEntry = (SvLBoxEntry*) GetModel()->GetEntry( x );
            pCtx = (LanguageContext*) pEntry->GetUserData();

            if ( pCtx->isProg )
            {
                pCtx->isProg = FALSE;
                pCtx->isDoc = FALSE;
                ((SvLBoxButton*)pEntry->GetItem(BTNIDX_PROG))->SetStateUnchecked();
                PaintEntry( pEntry );
                break;                  // there should be only one checked button
            }
        }

        pCtx = (LanguageContext*) pCurEntry->GetUserData();
        pCtx->isProg = TRUE;
        pCtx->isDoc = TRUE;
        ((SvLBoxButton*)pCurEntry->GetItem(BTNIDX_PROG))->SetStateChecked();
        PaintEntry( pCurEntry );
    }
}

///////////////////////////////////////////////////////////////////////////////
//

