/*************************************************************************
 *
 *  $RCSfile: plicense.cxx,v $
 *
 *  $Revision: 1.17.114.1 $
 *
 *  last change: $Author: rt $ $Date: 2003/08/20 13:48:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 - 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_SCRBAR_HXX
#include <vcl/scrbar.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_PRINT_HXX
#include <vcl/print.hxx>
#endif
#ifndef _SV_KEYCODES_HXX
#include <vcl/print.hxx>
#endif

#ifndef _XTEXTEDT_HXX
#include <svtools/xtextedt.hxx>
#endif
#ifndef _SV_PRINTDLG_HXX_
#include <svtools/printdlg.hxx>
#endif

#include "maindlg.hxx"
#include "event.hxx"
#include "environ.hxx"

#include "plicense.hxx"
#include "plicense.hrc"

#define LICENCE_READ        0x01
#define LICENCE_ACCEPTED    0x02

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
PageLicense::PageLicense( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aTextEdit		( this, ResId(LICENCE_TEXT, rResId.GetResMgr()) ),
	aFTInfo1		( this, ResId(FT_INFO1,     rResId.GetResMgr()) ),
	aFTInfo2a		( this, ResId(FT_INFO2_1,   rResId.GetResMgr()) ),
	aFTInfo2b		( this, ResId(FT_INFO2,     rResId.GetResMgr()) ),
	aFTInfo3a		( this, ResId(FT_INFO3_1,   rResId.GetResMgr()) ),
	aFTInfo3b		( this, ResId(FT_INFO3,     rResId.GetResMgr()) ),
    aCBAccept		( this, ResId(CB_ACCEPT,    rResId.GetResMgr()) ),
	aPBPageDown		( this, ResId(PB_PAGEDOWN,  rResId.GetResMgr()) ),
    aArrow          ( this, ResId(IMG_ARROW,    rResId.GetResMgr()) ),
    aStrAccept		( ResId(LICENCE_ACCEPT,     rResId.GetResMgr()) ),
	aStrNotAccept	( ResId(LICENCE_NOTACCEPT,  rResId.GetResMgr()) )
{
	bEndReached = FALSE;
    bHasFile    = FALSE;
    
    pParent->SetTitleStr( String(ResId(STR_TITLE, rResId.GetResMgr())) );
	FreeResource();

    aTextEdit.SetEndReachedHdl( LINK(this, PageLicense, EndReachedHdl) );
    aTextEdit.SetScrolledHdl( LINK(this, PageLicense, ScrolledHdl) );
    
    aPBPageDown.SetClickHdl( LINK(this, PageLicense, PageDownHdl) );
    aCBAccept.SetClickHdl( LINK(this, PageLicense, AcceptHdl) );

    GetAgentDlg()->SetPrintHdl( LINK(this, PageLicense, PrintHdl) );

    // We want a automatic repeating page down button
    WinBits aStyle = aPBPageDown.GetStyle();
    aStyle |= WB_REPEAT;
    aPBPageDown.SetStyle( aStyle );
    
    aOldCancelText = pParent->GetCancelText();
    pParent->SetCancelText( aStrNotAccept, FALSE );

    ReplaceVariables( aFTInfo2b, UniString::CreateFromAscii("%PAGEDOWN"), aPBPageDown.GetText() );
}

//------------------------------------------------------------------------
PageLicense::~PageLicense()
{
    if ( GetAgentDlg() )
    {
        GetAgentDlg()->SetCancelText( aOldCancelText, TRUE );
        GetAgentDlg()->SetButtonState( BSTATE_HIDE_PRINT );
    }
}

//------------------------------------------------------------------------
ULONG PageLicense::GetProperty()
{
    ULONG nRet = 0;
    
    if ( bEndReached && bHasFile )
        nRet += LICENCE_READ;
    if ( aCBAccept.IsChecked() )
        nRet += LICENCE_ACCEPTED;

    return nRet;
}

//------------------------------------------------------------------------
void PageLicense::InitProperty( ULONG nProp )
{
    if ( nProp != PROP_NOTSET )
    {
        bEndReached = (BOOL) ( nProp & LICENCE_READ );

        if ( bEndReached )
            aTextEdit.SetEndReached( TRUE );

        BOOL bAccept = (BOOL) ( ( nProp & LICENCE_ACCEPTED ) != 0 );
        aCBAccept.Check( bAccept );
    }

    EnableControls();
}

//------------------------------------------------------------------------
SvAgentPage* PageLicense::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageLicense( pParent, rResId );
}

//------------------------------------------------------------------------
BOOL PageLicense::SetLicenseFile( const String& rFileName )
{
	SvFileStream aReadStrm(rFileName, STREAM_READ);
	if( !aReadStrm.IsOpen() )
		return FALSE;

    bHasFile = TRUE;

    aReadStrm.Seek( STREAM_SEEK_TO_END );
    ULONG nLength = aReadStrm.Tell();
    aReadStrm.Seek( STREAM_SEEK_TO_BEGIN );

    char* pBuf1 = new char[nLength+1];
    char* pBuf2 = pBuf1;
	ULONG nRead = aReadStrm.Read( pBuf1, nLength );
	aReadStrm.Close();
	pBuf1[nRead] = 0x00;

    // Skip leading byte order mark if present #104965#
    if ( ( nRead > 2 ) && ( 0 == strncmp( pBuf1, "\xEF\xBB\xBF", 3 ) ) )
        pBuf2 += 3;

	UniString aStr( pBuf2, RTL_TEXTENCODING_UTF8 );
	delete[] pBuf1;

	ULONG nPos;
	while ( ( nPos = aStr.Search( (char) 12 ) ) != STRING_NOTFOUND )
		aStr.Erase( (USHORT)nPos, 1 );

    // There should never be an empty licence file, but when there is
    // one, bEndReached has to be set to TRUE so you can continue with
    // the installation
    if ( !aStr.Len() )
        bEndReached = TRUE;
    
    aTextEdit.SetText( aStr );
    aTextEdit.Invalidate( INVALIDATE_UPDATE );

    bEndReached |= aTextEdit.IsEndReached();

    EnableControls();
    
    if ( !bEndReached )
        aTextEdit.GrabFocus();

    GetAgentDlg()->SetButtonState( BSTATE_SHOW_PRINT );
    
    return TRUE;
}

//------------------------------------------------------------------------
BOOL PageLicense::AllowNext()
{
    BOOL bAllow = aCBAccept.IsChecked();

    return bAllow;
}

//------------------------------------------------------------------------
USHORT PageLicense::GetReturnVal()
{
    if ( GETDLG()->GetEnv()->IsUpdateOldVersion() )
        return RETURN_LIC_UPDATE;
    else
        return RETURN_LIC_NORMAL;
}

//------------------------------------------------------------------------
void PageLicense::EnableControls()
{
    if ( bEndReached )
    {
        Point aPos( 0, aFTInfo3a.GetPosPixel().Y() );
        aArrow.SetPosPixel( aPos );
        aCBAccept.Enable();
    }
    else
    {
        Point aPos( 0, aFTInfo2a.GetPosPixel().Y() );
        aArrow.SetPosPixel( aPos );
        aCBAccept.Disable();
    }

    if ( aTextEdit.IsEndReached() )
        aPBPageDown.Disable();
    else
        aPBPageDown.Enable();
    
    if ( aCBAccept.IsChecked() )
    {
        PushButton *pNext = GetAgentDlg()->GetButtonNext();
        if ( ! pNext->IsEnabled() )
        {
            GetAgentDlg()->SetCancelText( aOldCancelText, FALSE );
            GetAgentDlg()->SetButtonState( BSTATE_ENABLE_NEXT );
        }
    }
    else
    {
        PushButton *pNext = GetAgentDlg()->GetButtonNext();
        if ( pNext->IsEnabled() )
        {
            GetAgentDlg()->SetCancelText( aStrNotAccept, FALSE );
            GetAgentDlg()->SetButtonState( BSTATE_DISABLE_NEXT );
        }
    }
}

//------------------------------------------------------------------------
long PageLicense::PreNotify( NotifyEvent& rNEvt )
{
    if ( rNEvt.GetType() == EVENT_KEYINPUT )
    {
        if ( rNEvt.GetWindow() != (Window*) &aTextEdit )
        {
            const KeyEvent* pKeyEvt = rNEvt.GetKeyEvent();

            if ( pKeyEvt->GetKeyCode() == KEY_PAGEUP )
            {
                aTextEdit.ScrollDown( SCROLL_PAGEUP );
                return 1;
            }
            else if ( pKeyEvt->GetKeyCode() == KEY_PAGEDOWN )
            {
                aTextEdit.ScrollDown( SCROLL_PAGEDOWN );
                return 1;
            }
        }
    }

    return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( PageLicense, AcceptHdl, CheckBox *, EMPTYARG )
{
    EnableControls();
    return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( PageLicense, PageDownHdl, PushButton *, EMPTYARG )
{
    aTextEdit.ScrollDown( SCROLL_PAGEDOWN );
    return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( PageLicense, EndReachedHdl, LicenceView *, EMPTYARG )
{
    bEndReached = TRUE;

    EnableControls();
    aCBAccept.GrabFocus();

    return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( PageLicense, ScrolledHdl, LicenceView *, EMPTYARG )
{
    EnableControls();

    return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( PageLicense, PrintHdl, SvAgentPage *, EMPTYARG )
{
    Printer *pPrinter = new Printer;
    PrintDialog aPrintDlg( this );
    
    aPrintDlg.SetPrinter( pPrinter );
    
    if ( aPrintDlg.Execute() == RET_OK )
    {
        Size aFontSize( 0, 9 );
        Font aFont = GetDefaultFont( 0, LANGUAGE_NONE, 0, pPrinter );

        pPrinter->SetMapMode( MapMode( MAP_PIXEL ) );

        aFontSize = pPrinter->LogicToPixel( aFontSize, MapMode( MAP_POINT ) );
        aFont.SetSize( aFontSize );
        pPrinter->SetFont( aFont );

        if ( pPrinter->StartJob( GetAgentDlg()->GetText() ) )
        {
            Rectangle aPageRect;
            Rectangle aTextRect;

            Size      aBorderSize( 40, 40 );
            Point     aBorderPos( 20, 20 );
            Size      aPageSize = pPrinter->GetPaperSize();
            Point     aPagePos  = pPrinter->GetPageOffset();

            UniString aLicenceText = aTextEdit.GetText();

            aBorderSize = pPrinter->LogicToPixel( aBorderSize, MapMode( MAP_MM ) );
            aBorderPos  = pPrinter->LogicToPixel( aBorderPos, MapMode( MAP_MM ) );
            
            aPageSize.Height() -= aBorderSize.Height();
            aPageSize.Width()  -= aBorderSize.Width();
            aPagePos.X()       += aBorderPos.X();
            aPagePos.Y()       += aBorderPos.Y();

            long nLineHeight = pPrinter->GetTextHeight();

            aPageSize.Height() = ( aPageSize.Height() / nLineHeight ) * nLineHeight;
            
            aPageRect = Rectangle( aPagePos, aPageSize );
            aTextRect = pPrinter->GetTextRect( aPageRect, aLicenceText,
                                               TEXT_DRAW_MULTILINE | TEXT_DRAW_WORDBREAK );

            long nPageHeight = aPageRect.GetHeight();
            long nTextHeight = aTextRect.GetHeight();

            for ( long nPrinted = 0; nPrinted < nTextHeight; nPrinted += nPageHeight )
            {
                pPrinter->StartPage();
                pPrinter->SetClipRegion( Region( aPageRect ) );
                pPrinter->DrawText( aTextRect, aLicenceText,
                                    TEXT_DRAW_MULTILINE | TEXT_DRAW_WORDBREAK );
                pPrinter->EndPage();
                aTextRect.Move( 0, -nPageHeight );
            }

            pPrinter->EndJob();
        }
    }

    return 0;
}


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
LicenceView::LicenceView( Window* pParent, const ResId& rResId )
    : MultiLineEdit( pParent, rResId )
{
    SetLeftMargin( 5 );
    
    mbEndReached = IsEndReached();

	StartListening( *GetTextEngine() );
}

//------------------------------------------------------------------------
LicenceView::~LicenceView()
{
    maEndReachedHdl = Link();
    maScrolledHdl   = Link();

    EndListeningAll();
}

//------------------------------------------------------------------------
void LicenceView::ScrollDown( ScrollType eScroll )
{
    ScrollBar*  pScroll = GetVScrollBar();
    
    if ( pScroll )
        pScroll->DoScrollAction( eScroll );
}

//------------------------------------------------------------------------
BOOL LicenceView::IsEndReached() const
{
    BOOL bEndReached;

    ExtTextView*    pView = GetTextView();
    ExtTextEngine*  pEdit = GetTextEngine();
    ULONG           nHeight = pEdit->GetTextHeight();
    Size            aOutSize = pView->GetWindow()->GetOutputSizePixel();
    Point           aBottom( 0, aOutSize.Height() );

    if ( (ULONG) pView->GetDocPos( aBottom ).Y() >= nHeight - 1 )
        bEndReached = TRUE;
    else
        bEndReached = FALSE;

    return bEndReached;
}

//------------------------------------------------------------------------
void LicenceView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    if ( rHint.IsA( TYPE(TextHint) ) )
    {
        BOOL    bLastVal = EndReached();
        ULONG   nId = ((const TextHint&)rHint).GetId();

        if ( nId == TEXT_HINT_PARAINSERTED )
        {
            if ( bLastVal )
                mbEndReached = IsEndReached();
        }
        else if ( nId == TEXT_HINT_VIEWSCROLLED )
        {
            if ( ! mbEndReached )
                mbEndReached = IsEndReached();
            maScrolledHdl.Call( this );
        }

        if ( EndReached() && !bLastVal )
        {
            maEndReachedHdl.Call( this );
        }
    }
}

//------------------------------------------------------------------------
