/*************************************************************************
 *
 *  $RCSfile: urlframe.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mba $ $Date: 2001/09/13 11:39:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXURLFRAME_HXX
#define _SFXURLFRAME_HXX

#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif

#include "frame.hxx"
#include "frmdescr.hxx"

class SfxURLFrameWindow_Impl;
class SfxURLFrame_Impl;
class SfxObjectShell;
class DockingWindow;
class SfxFrameSetViewShell;
class SfxFrameEnv_Impl;
class SvInPlaceEnvironment;
class SfxFrameDescriptor;
class SfxReleasableFrame;

//==========================================================================
// Ein SfxURLFrame stellt ein Fenster zur Verf"ugung, in dem ein beliebiger
// Inhalt, spezifiziert durch einen URL, dargestellt werden kann. Ein solcher
// SfxFrame ist immer Teil einer SfxFrameSetViewShell, die ein splitbares
// Fenster zur Verf"ugung stellt, in dem alle ChildFrames liegen.
//==========================================================================

class SfxURLFrame : public SfxFrame
{
	SfxURLFrameWindow_Impl*	pWindow;
	SfxURLFrame_Impl*		pImp;
	SfxFrameSetViewShell*	pFrameSet;

#if _SOLAR__PRIVATE
	DECL_STATIC_LINK( 		SfxURLFrame, ActivateURL_Impl, void* );
#endif

protected:
	virtual BOOL			Close();
	virtual void        	SFX_NOTIFY( SfxBroadcaster& rBC,
									const TypeId& rBCType,
									const SfxHint& rHint,
									const TypeId& rHintType );
	virtual         		~SfxURLFrame();

public:
							TYPEINFO();
							SfxURLFrame(SfxFrameDescriptor* pDescr,
										SvInPlaceEnvironment* pObj,
										SfxReleasableFrame* pRel,
										SfxFrame* pParent );

	virtual Window&     	GetWindow() const;
	DockingWindow*			GetDockingWindow() const;
	const INetURLObject&	GetURL() const
							{ return GetDescriptor()->GetActualURL(); }
	void					ActivateURL();
	void					ResizeRelToAbs();
	BOOL					IsFrameSet() const
							{ return (GetDescriptor()->GetFrameSet() != NULL); }
	virtual BOOL			InsertDocument( SfxObjectShell *pDoc);
	void					Update( SfxFrameDescriptor *pD=NULL );
	void					SetActive( BOOL );
	SfxFrameSetViewShell*	GetFrameSet() const
							{ return pFrameSet; }
	BOOL					IsEmpty() const;
	virtual void			InsertWindow( Window* );
	void					UpdateView();

#if _SOLAR__PRIVATE
	SfxURLFrameWindow_Impl* Get_Impl() { return pWindow; }
	void					ActivateWindow_Impl();
	void					DeactivateWindow_Impl();
	void                    CancelActivate_Impl();
	void 					ForceInit_Impl();
	void 					SetValidItem_Impl( BOOL bValid );
	BOOL					IsValidItem_Impl() const;
	void					LoadFinished_Impl();
	SfxURLFrame* 			GetEditFrame_Impl();
    Window*                 GetFrameWindow_Impl() const;
#endif
};

#endif

