/*************************************************************************
 *
 *  $RCSfile: fsetobsh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2001/11/28 17:00:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if SUPD>551
#ifndef _SFXECODE_HXX
#include <svtools/sfxecode.hxx>
#endif
#else
#include <sfxecode.hxx>
#endif

#include "fsetobsh.hxx"

#pragma hdrstop

#ifndef _SOT_EXCHANGE_HXX
#include <sot/exchange.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif

#include <cppuhelper/weak.hxx>
#include <osl/mutex.hxx>

#include "sfxresid.hxx"
#include "docfilt.hxx"

#if SUPD<613//MUSTINI
#include "inimgr.hxx"
#endif
#include "app.hxx"
#include "frmdescr.hxx"
#include "docfile.hxx"
#include "fcontnr.hxx"
#include "frmhtml.hxx"
#include "frmhtmlw.hxx"
#include "appdata.hxx"
#include "docinf.hxx"
#if SUPD<582
#include "sfxjs.hxx"
#endif
#include "objface.hxx"
#include "doc.hrc"

#ifdef _USE_NAMESPACE
//ASDBG using namespace usr;
using namespace ::vos;
#endif

#define SfxFrameSetObjectShell
#include <sfxslots.hxx>

static const sal_uInt16 nVersion = 3;

TYPEINIT1(SfxFrameSetObjectShell, SfxObjectShell);

class SfxFrameSetObjectShell_Impl
{
public:
	SvStrings*	pScripts;
	SvStrings*	pComments;

				SfxFrameSetObjectShell_Impl()
					: pScripts(0)
					, pComments(0)
				{}
};

sal_uInt32 DetectFrameSetFilter(
	SfxMedium& rMedium, const SfxFilter **pFilter,
	SfxFilterFlags nMust, SfxFilterFlags nDont )
{
	SvStream *pStm = rMedium.GetInStream();
	if ( pStm )
	{
		pStm->Seek(0L);

		// Wir laden HTML immer mit dem Writer-Filter ...
		const SfxFilter *pFilt = SFX_APP()->GetFilterMatcher().GetFilter4FilterName( DEFINE_CONST_UNICODE( "HTML" ) );
		if ( pFilt )
		{
			if (*pFilter )
				*pFilter = pFilt;
			sal_uInt32 nErr = pFilt->GetFilterContainer()->
				GetFilter4Content( rMedium, pFilter, nMust, nDont );
			if( !nErr )
				return ERRCODE_SFX_FORCEQUIET;
		}
	}

	// Wenn es kein HTML-Dokument ist, kann nur noch versucht werden,
	// es als eigenes Format zu "offnen
	if ( rMedium.IsStorage() )
	{
		SvStorage *pStor = rMedium.GetStorage();
		SvStorageStreamRef aStr =
			pStor->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ), STREAM_STD_READ );
		if ( aStr->GetError() )
		{
			return ERRCODE_ABORT;
		}
		else
		{
			const SfxFilter *pFilt = SfxFrameSetObjectShell::Factory().
						GetFilterContainer()->GetFilter(1);
            if ( ( pFilt->GetFilterFlags() & nMust ) == nMust &&
                 ( pFilt->GetFilterFlags() & nDont ) == 0 )
			{
				*pFilter = pFilt;
				return ERRCODE_NONE;
			}
		}
	}

	return ERRCODE_ABORT;
}

SFX_IMPL_INTERFACE(SfxFrameSetObjectShell,SfxObjectShell,SfxResId(0))
{
	// momentan keine Tools
}

SFX_IMPL_SIMPLE_OBJECTFACTORY(SfxFrameSetObjectShell, SFXOBJECTSHELL_STD_NORMAL, FrameSet )
{
	sal_uInt32 nFormat = SotExchange::RegisterFormatName( DEFINE_CONST_UNICODE( "StarFrameSetDocument" ) );

	SfxFilterContainer* pFC = Factory().GetFilterContainer();

	SFX_OWN_FILTER_REGISTRATION( DetectFrameSetFilter,
		DEFINE_CONST_UNICODE( "HTML (FrameSet)" ),
		DEFINE_CONST_UNICODE( "*.html;*.htm" ),
		SFX_FILTER_EXPORT, 0,
		DEFINE_CONST_UNICODE( "TEXT0" ),
		DEFINE_CONST_UNICODE( "HTML-FrameSet"), 0,
		DEFINE_CONST_UNICODE( "HTML" ), String() );       // MAC ?!?!?!

	pFC->GetFilter4FilterName( DEFINE_CONST_UNICODE( "HTML (FrameSet)" ) )->SetUIName(
		String( SfxResId( STR_FSET_FILTERNAME0 ) ) );

	SFX_SIMPLE_FILTER_REGISTRATION(
		DEFINE_CONST_UNICODE( "StarFrameDokument" ),
		DEFINE_CONST_UNICODE( "*.sfs" ),
		SFX_FILTER_OWN|SFX_FILTER_IMPORT|SFX_FILTER_EXPORT,
		nFormat,
		DEFINE_CONST_UNICODE( "SVfs0" ),
		DEFINE_CONST_UNICODE( "StarFrameSet" ),
		0, String(), String() );          // MAC ?!?!?!

	pFC->GetFilter4FilterName( DEFINE_CONST_UNICODE( "StarFrameDokument" ) )->SetUIName(
		String( SfxResId( STR_FSET_FILTERNAME1 ) ) );

	Factory().RegisterHelpFile( DEFINE_CONST_UNICODE( SFX_DESKTOP_HELPFILE_NAME ) );
}

//------------------------------------------------------------------

SfxFrameSetObjectShell::SfxFrameSetObjectShell(SfxObjectCreateMode eMode) :
	SfxObjectShell(eMode),
	pDescriptor(0L)
{
	// da die Writerlinge sich weigern, die BaseURL anders zu "ubergeben als
	// "uber das INetURLObject ...
	SetBaseURL( INetURLObject::GetBaseURL() );
	SetPool(&SFX_APP()->GetPool());
	SfxFrameSetModel* pModel = new SfxFrameSetModel( this );
	SetModel( pModel );
	StartLoading_Impl();
}


//------------------------------------------------------------------

SfxFrameSetObjectShell::~SfxFrameSetObjectShell()
{
	SetPool(0);
	delete pDescriptor;
}



//------------------------------------------------------------------

void SfxFrameSetObjectShell::Exec_Impl(SfxRequest&)
{
}

//------------------------------------------------------------------

void SfxFrameSetObjectShell::State_Impl(SfxItemSet&)
{
}

//------------------------------------------------------------------

sal_Bool SfxFrameSetObjectShell::InitNew( SvStorage *pStor )
{
	if ( SvPersist::InitNew( pStor ) )
	{
		pDescriptor = new SfxFrameSetDescriptor;
		pDescriptor->SetColSet( sal_True );
		SfxFrameDescriptor *pFrame = new SfxFrameDescriptor( pDescriptor );
		pFrame->SetWidthPercent( 100 );
		return sal_True;
	}
	return sal_False;
}

//------------------------------------------------------------------

sal_Bool SfxFrameSetObjectShell::Load( SvStorage *pStor )
{
	if( SvPersist::Load( pStor ) )
	{
		SvStorageStreamRef aStm = pStor->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ), STREAM_STD_READ );
		if ( aStm.Is() )
		{
			delete pDescriptor;

			sal_uInt16 nFileVersion;
			aStm->SetBufferSize(4096);

			pDescriptor = new SfxFrameSetDescriptor;
			*aStm >> nFileVersion;

			// Die alpha-Version
			if ( nFileVersion == 1 )
				return sal_False;

			String aTitle;
			aStm->ReadByteString( aTitle, RTL_TEXTENCODING_UTF8 );
			pDescriptor->SetDocumentTitle( aTitle );
			SetTitle( aTitle );

			pDescriptor->Load( *aStm, nFileVersion );
			return sal_True;
		}
	}

	return sal_False;
}

//=========================================================================

sal_Bool SfxFrameSetObjectShell::Save()
{
	if( SvPersist::Save() && SfxObjectShell::Save() )
	{
		SvStorageStreamRef aStm = GetStorage()->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ) );
		if ( aStm.Is() )
		{
			aStm->SetSize(0);
			aStm->SetBufferSize(4096);
			*aStm << nVersion;
			aStm->WriteByteString( pDescriptor->GetDocumentTitle(),	RTL_TEXTENCODING_UTF8 );
			pDescriptor->Store( *aStm );
			return sal_True;
		}
	}

	return sal_False;
}

//--------------------------------------------------------------------------

sal_Bool SfxFrameSetObjectShell::SaveAs( SvStorage * pNewStg )
{
	if( SvPersist::SaveAs( pNewStg) && SfxObjectShell::SaveAs( pNewStg ) )
	{
		SvStorageStreamRef aStm = pNewStg->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ) );
		if ( aStm.Is() )
		{
			aStm->SetSize(0);
			aStm->SetBufferSize(4096);
			*aStm << nVersion;
			aStm->WriteByteString( pDescriptor->GetDocumentTitle(),	RTL_TEXTENCODING_UTF8 );
			pDescriptor->Store( *aStm );
			return sal_True;
		}
	}

	return sal_False;
}

//--------------------------------------------------------------------

void SfxFrameSetObjectShell::FillClass( SvGlobalName * pClassName,
								   sal_uInt32 * pClipFormat,
								   String * pAppName,
								   String * pLongUserName,
								   String * pUserName ) const
{
	SvPersist::FillClass( pClassName,
							pClipFormat,
							pAppName,
							pLongUserName, pUserName );
	SfxObjectFactory &rFact = GetFactory();
	for( sal_uInt16 n = 0; n < rFact.GetFilterCount(); n++ )
	{
		const SfxFilter * pFilter = rFact.GetFilter( n );
		if( pFilter->IsOwnFormat() )
		{
			*pClassName 	= *GetSvFactory();
			*pClipFormat	= pFilter->GetFormat();
            *pLongUserName  = pFilter->GetFilterName();
            *pUserName      = pFilter->GetFilterName();
			break;
		}
	}

	*pAppName = SFX_APP()->GetName();
}

//--------------------------------------------------------------------

sal_Bool SfxFrameSetObjectShell::SaveCompleted( SvStorage * pStor )
{
	if( SvPersist::SaveCompleted( pStor ) )
	{
		if( !pStor )
			return sal_True;
		SvStorageStreamRef aStm = pStor->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ) );
		return aStm.Is();
	}
	return sal_False;
}

//--------------------------------------------------------------------

sal_Bool SfxFrameSetObjectShell::ConvertFrom( SfxMedium& rMed )
{
	// HTML-Import
	delete pDescriptor;
	pDescriptor = new SfxFrameSetDescriptor;

	// parsen
	DBG_ASSERT( rMed.GetInStream(), "Kein Stream!" );

	SvParserRef xParser = new SfxFrameHTMLParser( rMed, this );

	SfxItemSet *pItemSet = rMed.GetItemSet();
	const SfxPoolItem *pItem;
	if( pItemSet &&
		SFX_ITEM_SET == pItemSet->GetItemState( SID_FSETHTMLPARSER,
												sal_False, &pItem ) )
	{
		sal_uInt32 nVal = ((SfxUInt32Item *)pItem)->GetValue();
		xParser->SetSrcEncoding( (rtl_TextEncoding)(nVal & 0x0000ffff) );
		xParser->SetSrcUCS2BEncoding( (nVal & 0x00010000) != 0 );
		xParser->SetSwitchToUCS2( (nVal & 0x00020000) != 0 );
	}
	SvParserState eState = xParser->CallParser();

	if ( SVPAR_PENDING == eState )
	{
		return sal_True;
	}
	else
		((SfxFrameHTMLParser*)&xParser)->EndParser();

	SetTitle( GetDocInfo().GetTitle() );
	if( SVPAR_ACCEPTED==eState )
	{
		rMed.SetFilter( Factory().GetFilterContainer()->GetFilter(0) );
		return sal_True;
	}
	return sal_False;
}

//--------------------------------------------------------------------

sal_Bool SfxFrameSetObjectShell::ConvertTo( SfxMedium& rMed )
{
/*
	SvStream *pStream = GetMedium()->GetInStream();
	if ( ( IsReadOnly() || !IsModified() ) && pStream )
	{
		// HTML-Datei als ebensolche speichern; wenn das Dokument noch
		// nicht ver"andert wurde, einfach den Stream kopieren. Dadurch ist
		// es m"oglich, Dokumente, deren Inhalt teilweise "uber JavaScript
		// aufgebaut werden, als Original zu speichern
		GetMedium()->CloseInStream();
		pStream = GetMedium()->GetInStream();
		if ( pStream )
		{
			pStream->Seek(0);
			(*pStream) >> (*rMed.GetOutStream());
			return sal_True;
		}
	}
*/
	const SfxFilter *pFilter = rMed.GetFilter();
	if ( !pFilter )
	{
		// Woher nehmen und nicht stehlen ??
		return sal_False;
	}

	if ( pFilter->GetFilterName().EqualsAscii( "HTML (FrameSet)" ) ||
		 pFilter->GetFilterName().EqualsAscii( "HTML" ) )
	{
		// HTML-Export
		SvStream* pStm = rMed.GetOutStream();

		SfxFrameHTMLWriter *pWriter = new SfxFrameHTMLWriter;
		sal_uInt32 nErr = pWriter->Write( this, *pStm );
		delete pWriter;

		if( nErr==0 )
			return sal_True;
		return sal_False;
	}
	else
	{
		// Ein Fehler !!
		return sal_False;
	}
}

//--------------------------------------------------------------------

sal_Bool SfxFrameSetObjectShell::Initialize( const String& rName )
{
	sal_Bool bRet = DoInitNew( NULL );
	if ( bRet )
		pDescriptor->GetFrame(0)->SetURL( rName );
	return bRet;
}

//--------------------------------------------------------------------

void SfxFrameSetObjectShell::TakeDescriptor( SfxFrameSetDescriptor *pSet )
{
	delete pDescriptor;

	// Den neuen Descriptor "ubernehmen
	pDescriptor = pSet->Clone();
	SetModified( sal_True );

	// Rekursive FrameSets interessieren hier nicht
	pDescriptor->CutRootSet();

	// Alle Kunden informieren
	Broadcast( SfxSimpleHint( SFX_HINT_DOCCHANGED ) );
}

//--------------------------------------------------------------------

void SfxFrameSetObjectShell::ReInit_Impl( SfxFrameSetDescriptor *pSet )
{
	// Den alten Descriptor wegwerfen
	delete pDescriptor;

	// Den neuen "ubernehmen
	pDescriptor = pSet->Clone();

	// Rekursive FrameSets interessieren hier nicht
	pDescriptor->CutRootSet();

	// Alle Kunden informieren
	Broadcast( SfxSimpleHint( SFX_HINT_DOCCHANGED ) );
}

String SfxFrameSetObjectShell::GetSource()
{
	String aStr;

	// Wenn noch nicht gespeichert, ergibt GetInStream einen Error
	SvStream *pStream = HasName() ? GetMedium()->GetInStream() : 0;
	SvMemoryStream aStm;
	if ( ( IsReadOnly() || !IsModified() ) && pStream )
	{
		// Unver"anderte HTML-Datei aus dem Original-Stream lesen
		GetMedium()->CloseInStream();
		pStream = GetMedium()->GetInStream();
		if ( pStream )
			pStream->Seek(0);
		else
		{
			SfxFrameHTMLWriter *pWriter = new SfxFrameHTMLWriter;
			sal_uInt32 nErr = pWriter->Write( this, aStm );
			delete pWriter;
			if ( nErr == 0 )
				pStream = &aStm;
		}
	}
	else
	{
		SfxFrameHTMLWriter *pWriter = new SfxFrameHTMLWriter;
		sal_uInt32 nErr = pWriter->Write( this, aStm );
		delete pWriter;
		if ( nErr == 0 )
			pStream = &aStm;
	}

	if ( pStream )
	{
		pStream->Seek(0);
		ByteString aTmp;
		while ( pStream->ReadLine( aTmp ) )
		{
			aStr += String::CreateFromAscii( aTmp.GetBuffer() );
			aStr += '\n';
		}
		aStr.ConvertLineEnd();
	}

	return aStr;
}

void SfxFrameSetObjectShell::TakeSource( const String& rSource )
{
	delete pDescriptor;
	pDescriptor = new SfxFrameSetDescriptor;

	// parsen
	SvMemoryStream aStream;
	aStream.WriteByteString( rSource, RTL_TEXTENCODING_UTF8 );
	aStream.Seek(0);
	SvParserRef xParser = new SfxFrameHTMLParser( aStream, this );
	SvParserState eState = xParser->CallParser();
	SetTitle( GetDocInfo().GetTitle() );
	SetModified( sal_True );

	// Alle Kunden informieren
	Broadcast( SfxSimpleHint( SFX_HINT_DOCCHANGED ) );
}

void SfxFrameSetObjectShell::SetScriptsAndComments( SvStrings* pScripts,
	SvStrings* pComments )
{
}

SfxFrameSetModel::SfxFrameSetModel( SfxFrameSetObjectShell *pShell )
	: SfxBaseModel( pShell )
{
	pDoc = pShell;
}
//------------------------------------------------------------------

SfxFrameSetModel::SfxFrameSetModel( com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory > const & )
	: SfxBaseModel( NULL )
{
	DBG_ERRORFILE( "NIJ!" );
}
//------------------------------------------------------------------

SfxFrameSetModel::~SfxFrameSetModel()
{
}

//------------------------------------------------------------------

SFX_IMPL_XINTERFACE_2( SfxFrameSetModel, SfxBaseModel, ::com::sun::star::frame::XFrameSetModel, ::com::sun::star::lang::XServiceInfo )
SFX_IMPL_XTYPEPROVIDER_9( SfxFrameSetModel, ::com::sun::star::frame::XFrameSetModel, ::com::sun::star::frame::XModel, ::com::sun::star::lang::XEventListener, ::com::sun::star::view::XPrintable, ::com::sun::star::util::XModifiable, ::com::sun::star::frame::XStorable, ::com::sun::star::container::XChild, ::com::sun::star::document::XDocumentInfoSupplier, ::com::sun::star::lang::XServiceInfo )
SFX_IMPL_XSERVICEINFO( SfxFrameSetModel, "com.sun.star.frame.Model", "com.sun.star.comp.sfx2.FrameSetModel" )
SFX_IMPL_SINGLEFACTORY( SfxFrameSetModel )

::rtl::OUString SAL_CALL SfxFrameSetModel::getSource() throw ( ::com::sun::star::uno::RuntimeException )
{
	return pDoc->GetSource();
}

void SAL_CALL SfxFrameSetModel::setSource( const ::rtl::OUString& rSource ) throw ( ::com::sun::star::uno::RuntimeException )
{
	pDoc->TakeSource( rSource );
}


