/*************************************************************************
 *
 *  $RCSfile: JComponentListener.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package stardiv.unoctrl;

import java.io.*;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.FocusListener;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;



/**
 * Klasse zum Propagieren Events an Listener eines
 * entspr. Java-Uno-Controls
 */
public class JComponentListener implements
									MouseListener,
									MouseMotionListener,
									FocusListener,
									ComponentListener,
									KeyListener,
									IRmKeyCodes
{
    private long    	pCppJavaOwner;
    
	// vcl modifiers, buttons
	// ...already defined in stardiv.awt.vcl.VCLComponentPeer
	// which only has package scope...
	static final int	VCL_SHIFT_MASK			= 0x01;
	static final int	VCL_MOD1_MASK			= 0x02;
	static final int	VCL_MOD2_MASK			= 0x04;

	static final int	VCL_BUTTONLEFT_MASK		= 0x01;
	static final int	VCL_BUTTONRIGHT_MASK	= 0x02;
	static final int	VCL_BUTTONMIDDLE_MASK	= 0x04;
	//

    static final int	NO_BUTTON_MASK	= ~(
		    					InputEvent.BUTTON1_MASK |
					    		InputEvent.BUTTON2_MASK |
   		 						InputEvent.BUTTON3_MASK );

	// Ctor
	public JComponentListener( long pCppObj_ )
	{
        pCppJavaOwner	= pCppObj_;
    }

    protected void finalize() //throws Throwable
    {
		if (pCppJavaOwner != 0)
			onFinalize();
        pCppJavaOwner	= 0;
    }

	// C++ Objekt freigeben
	public native void onFinalize();

//=============================================================================

	// Listener-Methoden auf C++-Seite
	public native void JCmousePressed(
				int nModifiers, int nButtons,
				int nX, int nY, int nClickCount, boolean bIsPopup );
	public native void JCmouseReleased(
				int nModifiers, int nButtons,
				int nX, int nY, int nClickCount, boolean bIsPopup );
//	public native void JCmouseClicked(
//				int nModifiers, int nButtons,
//				int nX, int nY, int nClickCount, boolean bIsPopup );
	public native void JCmouseEntered(
				int nModifiers, int nButtons,
				int nX, int nY, int nClickCount, boolean bIsPopup );
	public native void JCmouseExited(
				int nModifiers, int nButtons,
				int nX, int nY, int nClickCount, boolean bIsPopup );
				
    public native void JCmouseDragged(
				int nModifiers, int nButtons,
				int nX, int nY, int nClickCount, boolean bIsPopup );
    public native void JCmouseMoved(
				int nModifiers, int nButtons,
				int nX, int nY, int nClickCount, boolean bIsPopup );
    
    public native void JCkeyTyped(
    			int nModifiers, int nKeyCode, int nKeyChar );
//	public native void JCkeyPressed(
//				int nModifiers, int nKeyCode, int nKeyChar );
//	public native void JCkeyReleased(
//				int nModifiers, int nKeyCode, int nKeyChar );

    public native void JCfocusGained( boolean isTemporary );
    public native void JCfocusLost( boolean isTemporary );
    
	//
	// ComponentListener direkt auf C++-Seite
	//
    public native void componentResized( ComponentEvent evt );
    public native void componentMoved( ComponentEvent evt );
    public native void componentShown( ComponentEvent evt );
    public native void componentHidden( ComponentEvent evt );

//=============================================================================

	public static final byte[] getStreamedJavaData( Object rObject )
		throws IOException
	{
		ByteArrayOutputStream aBar	= new ByteArrayOutputStream();
		ObjectOutputStream aOutput	= new ObjectOutputStream( aBar );
		aOutput.writeObject( rObject );
		aOutput.flush();
		return aBar.toByteArray();
	}

	public static final Object reInstance( byte[] pStreamedJavaData )
		throws
			StreamCorruptedException,
			IOException,
			OptionalDataException,
			ClassNotFoundException
	{
		ByteArrayInputStream aBar	=
					new ByteArrayInputStream( pStreamedJavaData );
		ObjectInputStream aInput	= new ObjectInputStream( aBar );
		return aInput.readObject();
	}

	public static final void drawComponent( java.awt.Component rComp, int device_id )
	{
//		if (rComp!=null)
//			rComp.update( new stardiv.awt.vcl.VCLGraphics( device_id, (VCLToolkit)rComp.getToolkit() );
	}

	
	//
	// Conversion help
	//
	public final static int javaToVCLModifiers( int nModifiers )
	{
		return
			((nModifiers & InputEvent.SHIFT_MASK)!=0 ? VCL_SHIFT_MASK : 0)	|
			((nModifiers & InputEvent.CTRL_MASK)!=0 ? VCL_MOD1_MASK : 0)	|
			((nModifiers & InputEvent.ALT_MASK)!=0 ? VCL_MOD2_MASK : 0);
	}
	
	public final static int javaToVCLButtons( int nModifiers )
	{
		return
			((nModifiers & InputEvent.BUTTON1_MASK)!=0 ? VCL_BUTTONLEFT_MASK : 0)	|
			((nModifiers & InputEvent.BUTTON2_MASK)!=0 ? VCL_BUTTONMIDDLE_MASK : 0)	|
			((nModifiers & InputEvent.BUTTON3_MASK)!=0 ? VCL_BUTTONRIGHT_MASK : 0);
	}

	public final static int javaToVCLKeyCode( int javaKeyCode )
	{
		//VK_0 thru VK_9 are the same as ASCII '0' thru '9' (0x30 - 0x39)
		if (javaKeyCode >= KeyEvent.VK_0 && javaKeyCode <= KeyEvent.VK_9)
			return javaKeyCode - JAVA_NUM_OFF + KEYGROUP_NUM;

		//VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A)
		if (javaKeyCode >= KeyEvent.VK_A && javaKeyCode <= KeyEvent.VK_Z)
			return javaKeyCode - JAVA_ALPHA_OFF + KEYGROUP_ALPHA;
		
		//VK_F1 ... VK_F12
		if (javaKeyCode >= KeyEvent.VK_F1 && javaKeyCode <= KeyEvent.VK_F12)
			return javaKeyCode - JAVA_FUNC_OFF + KEYGROUP_FKEYS;
		
		switch (javaKeyCode)
		{
			case KeyEvent.VK_DOWN			: return SVKEY_DOWN;
			case KeyEvent.VK_UP    			: return SVKEY_UP;
			case KeyEvent.VK_LEFT       	: return SVKEY_LEFT;
			case KeyEvent.VK_RIGHT      	: return SVKEY_RIGHT;
			case KeyEvent.VK_HOME        	: return SVKEY_HOME;
			case KeyEvent.VK_END         	: return SVKEY_END;
			case KeyEvent.VK_PAGE_UP      	: return SVKEY_PAGEUP;
			case KeyEvent.VK_PAGE_DOWN    	: return SVKEY_PAGEDOWN;
			case KeyEvent.VK_ENTER      	: return SVKEY_RETURN;
			case KeyEvent.VK_ESCAPE      	: return SVKEY_ESCAPE;
			case KeyEvent.VK_TAB         	: return SVKEY_TAB;
			case KeyEvent.VK_BACK_SPACE   	: return SVKEY_BACKSPACE;
			case KeyEvent.VK_SPACE       	: return SVKEY_SPACE;
			case KeyEvent.VK_INSERT      	: return SVKEY_INSERT;
			case KeyEvent.VK_DELETE      	: return SVKEY_DELETE;
			case KeyEvent.VK_ADD         	: return SVKEY_ADD;
			case KeyEvent.VK_SUBTRACT    	: return SVKEY_SUBTRACT;
			case KeyEvent.VK_MULTIPLY    	: return SVKEY_MULTIPLY;
			case KeyEvent.VK_DIVIDE      	: return SVKEY_DIVIDE;
			case KeyEvent.VK_DECIMAL       	: return SVKEY_POINT;
			case KeyEvent.VK_COMMA       	: return SVKEY_COMMA;
			case 60        					: return SVKEY_LESS;
			case 62     					: return SVKEY_GREATER;
			case KeyEvent.VK_EQUALS       	: return SVKEY_EQUAL;
			case KeyEvent.VK_HELP        	: return SVKEY_HELP;
			
			case KeyEvent.VK_SHIFT       	: return KEY_SHIFT;
			case KeyEvent.VK_CONTROL        : return KEY_MOD1;
			case KeyEvent.VK_META        	: return KEY_MOD2;
		};
		return 0;	// undefined
	}
	//

	//
	// MouseListener
	//
	public void mousePressed( MouseEvent evt )
	{
		int nMod	= evt.getModifiers();
		JCmousePressed(
			javaToVCLModifiers(nMod & NO_BUTTON_MASK), javaToVCLButtons(nMod),
			evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger() );
	}
	public void mouseReleased( MouseEvent evt )
	{
		int nMod	= evt.getModifiers();
		JCmouseReleased(
			javaToVCLModifiers(nMod & NO_BUTTON_MASK), javaToVCLButtons(nMod),
			evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger() );
	}
	public void mouseEntered( MouseEvent evt )
	{
		int nMod	= evt.getModifiers();
		JCmouseEntered(
			javaToVCLModifiers(nMod & NO_BUTTON_MASK), javaToVCLButtons(nMod),
			evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger() );
	}
	public void mouseExited( MouseEvent evt )
	{
		int nMod	= evt.getModifiers();
		JCmouseExited(
			javaToVCLModifiers(nMod & NO_BUTTON_MASK), javaToVCLButtons(nMod),
			evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger() );
	}
	public void mouseClicked( MouseEvent evt )
	{
		// is ignored
	}
	
	//
	// MouseMotionListener
	//
    public void mouseDragged( MouseEvent evt )
    {
		int nMod	= evt.getModifiers();
		JCmouseDragged(
			javaToVCLModifiers(nMod & NO_BUTTON_MASK), javaToVCLButtons(nMod),
			evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger() );
    }
    public void mouseMoved( MouseEvent evt )
    {
		int nMod	= evt.getModifiers();
		JCmouseMoved(
			javaToVCLModifiers(nMod & NO_BUTTON_MASK), javaToVCLButtons(nMod),
			evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger() );
    }
	
	//
	// KeyListener
	//
    public void keyTyped( KeyEvent evt )
    {
		// is ignored
    }
    public void keyPressed( KeyEvent evt )
    {	// Pressed als Typed verkauft, uuh!  MUSS ge"andert werden!
    	JCkeyTyped(
			javaToVCLModifiers( evt.getModifiers() ),
			javaToVCLKeyCode( evt.getKeyCode() ),
			evt.getKeyChar() );
    }
    public void keyReleased( KeyEvent evt )
    {
		// is ignored
    }
    
	//
	// FocusListener
	//
    public void focusGained( FocusEvent evt )
    {
		JCfocusGained( evt.isTemporary() );
    }
    public void focusLost( FocusEvent evt )
    {
		JCfocusLost( evt.isTemporary() );
    }
    
}
