/*************************************************************************
 *
 *  $RCSfile: insdlg.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _INSDLG_HXX
#define _INSDLG_HXX

#ifndef _GLOBNAME_HXX //autogen
#include <tools/globname.hxx>
#endif
#ifndef _OWNCONT_HXX
#include <svtools/ownlist.hxx>
#endif
#ifndef _SO2REF_HXX
#include <so2ref.hxx>
#endif

class SvAppletObject;

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif
#ifndef SV_DECL_SVBASELINK2_DEFINED
#define SV_DECL_SVBASELINK2_DEFINED
SV_DECL_REF(SvBaseLink2)
#endif

/********************** SvObjectServer ***********************************
*************************************************************************/
class SvObjectServer
{
private:
	SvGlobalName    aClassName;
	String          aHumanName;

public:
	SvObjectServer( const SvGlobalName & rClassP, const String & rHumanP ) :
		aClassName( rClassP ),
		aHumanName( rHumanP ) {}

	const SvGlobalName &    GetClassName() const { return aClassName; }
	const String &          GetHumanName() const { return aHumanName; }
};

class SvObjectServerList
{
	PRV_SV_DECL_OWNER_LIST(SvObjectServerList,SvObjectServer)
	const SvObjectServer *  Get( const String & rHumanName ) const;
	const SvObjectServer *  Get( const SvGlobalName & ) const;
	void                    Remove( const SvGlobalName & );

	void					FillInsertObjects();
};

class SvStorage;
class INetURLObject;

// class SvDialog --------------------------------------------------------

class SvDialog

/*	[Beschreibung]

	Die abstrakte Klasse SvDialog stellt ein Interface zur Verf"ugung
	um im SO2-Bereich Dialoge anzubieten, an denen nachtr"aglich die
	HelpId gesetzt werden kann.
*/

{
protected:
	ULONG			nHelpId;

public:
					SvDialog() : nHelpId( 0 ) {}

	void			SetHelpId( ULONG nNewId )	{ nHelpId = nNewId; }
};

// class SvInsertOleObjectDialog -----------------------------------------

class SvInsertOleObjectDialog : public SvDialog

/*	[Beschreibung]

	Die Klasse SvInsertOleObjectDialog stellt das UI-Interface zum
	einfgen von Ole-Objekten (Neu oder aus Datei) zur Verfgung.
*/

{
private:
	String				_aFileName;
	BOOL				_bCreateNew	: 1,
						_bLink 		: 1;

public:
						SvInsertOleObjectDialog() : _bCreateNew(FALSE) {}

	static void			FillObjectServerList( SvObjectServerList* );

	SvInPlaceObjectRef	Execute( Window* pParent, SvStorage* pStor,
								 const SvObjectServerList* pServers = NULL );
	const String&		GetFileName() const { return _aFileName; }
	BOOL				IsCreateNew() const { return _bCreateNew; }
	BOOL				IsLinked() const	{ return _bLink; }
};

// class SvInsertPlugInDialog --------------------------------------------

class SvInsertPlugInDialog : public SvDialog

/*	[Beschreibung]

	Die Klasse SvInsertPlugInDialog stellt das UI-Interface zum
	einfgen von PlugIn-Objekten, das sind spezielle Ole-Objekte,
	zur Verfgung.
*/

{
private:
	INetURLObject*		pURL;
	String				aCommands;

public:
						SvInsertPlugInDialog() : pURL( NULL ) {}
						~SvInsertPlugInDialog();


	SvInPlaceObjectRef	Execute( Window* pParent, SvStorage* pStor );

	INetURLObject*		GetURL() const { return pURL; }
	const String&		GetCommands() const { return aCommands; }
};

// class SvInsertAppletDialog --------------------------------------------

class SvInsertAppletDialog : public SvDialog

/*	[Beschreibung]

	Die Klasse SvInsertAppletDialog stellt das UI-Interface zum
	einfgen von Applet-Objekten, das sind spezielle Ole-Objekte,
	zur Verfgung.
*/

{
private:
	INetURLObject*		pURL;
	String				aClass;
	String				aCommands;

public:
						SvInsertAppletDialog() : pURL( NULL ) {}
						~SvInsertAppletDialog();

#if SUPD<=358
	SvInPlaceObjectRef	Execute( Window* pParent, SvStorage* pStor );
	SvInPlaceObjectRef	Execute( Window* pParent, SvStorage* pStor,
								 SvAppletObject * );
#else
	SvInPlaceObjectRef	Execute( Window* pParent, SvStorage* pStor,
								 SvAppletObject * = 0);
#endif


	INetURLObject*		GetURL() const { return pURL; }
	const String&		GetClass() const { return aClass; }
	const String&		GetCommands() const { return aCommands; }
};



#endif // _INSDLG_HXX

