#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.29 $
#
#   last change: $Author: hr $ $Date: 2003/03/27 11:48:58 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

.IF "$(OS)"=="MACOSX"

# PRJ, PRJNAME, TARGET needs to be set via arguments to dmake it use this
# makefile.mk

# --- Settings ---

.INCLUDE : settings.mk

# --- Targets ---

FURTHERLINKLIBS=

# This is a hack to allow linking when we instantiated cppu::*ImplHelper static
# data members. Ideally, we need to link to libcppuhelper, but sometimes it
# may not yet be built so we need to leave them undefined until a later run.

CPPUHELPERLIBNAME=$(DLLPRE)$(CPPUHELPERLIB:s/-l//)$(DLLPOST)
.IF "$(shell -/bin/sh -c "ls $(SOLARLIBDIR)$/$(CPPUHELPERLIBNAME) $(LB)$/$(CPPUHELPERLIBNAME) 2>/dev/null")"!=""
	FURTHERLINKLIBS+=$(CPPUHELPERLIB)
.ENDIF

# sal needs to be on the static data link list after is it created.
SALLIBNAME=$(DLLPRE)$(SALLIB:s/-l//)$(DLLPOST)
.IF "$(shell -/bin/sh -c "ls $(SOLARLIBDIR)$/$(SALLIBNAME) $(LB)$/$(SALLIBNAME) 2>/dev/null")"!=""
	FURTHERLINKLIBS+=$(SALLIB)
.ENDIF

.IF "$(FURTHERLINKLIBS)"!=""
	LINKFLAGSSHL+=$(FURTHERLINKLIBS)
.ENDIF

# get the name of the stlport .dylib for the init-static-data-template script.
# Its called *.dylib for STLport 4.5, and a number of things for 4.0
ISDTSTLPORTLIB=
.IF "$(STLPORT4)"!=""
	.IF "$(STLPORT4)"=="NO_STLPORT4"
		# Look for STLport 4.5 libraries in SOLARLIBDIR
		ISDTSTLPORTLIB+=$(shell -/bin/sh -c "ls $(SOLARLIBDIR)$/$(DLLPRE)$(LIBSTLPORT:s/-l//)$(DLLPOST) 2>/dev/null")
	.ELSE
		# Look for STLport 4.0 libraries in the STLport4 home directory
		ISDTSTLPORTLIB+=$(shell -/bin/sh -c "ls $(SOLARLIBDIR)$/$(DLLPRE)$(LIBSTLPORT:s/-l//)$(DLLPOST) $(STLPORT4)$/lib$/$(DLLPRE)$(LIBSTLPORT:s/-l//)$(DLLPOST) $(STLPORT4)$/lib$/$(DLLPRE)$(LIBSTLPORT:s/-l//)$(DLLPOST).[0-9] 2>/dev/null")
	.ENDIF
.ENDIF

# Get the list of dylibs to link against in @executable_path/dylib:/path/to/dylib format
DYLIBLINKLIST=$(shell -/bin/sh -c "dylib-link-list $(PRJNAME) $(SOLARVERSION)$/$(INPATH)$/lib $(PRJ)$/$(INPATH)$/lib $(DYLIBLINKLIBS) $(FURTHERLINKLIBS) -l$(LIBSTLPORT)")

# Update, compile and link static data member library. Note that we do all of
# these steps in our custom recipes. This avoids dependency and recursion
# problems associated with using the standard rules.

ALL: $(LB)$/$(DLLPRE)$(PRJNAME)$(TARGET)$(STATICLIBNAME)$(DLLPOST)

.INCLUDE : target.mk

LINKFLAGSSTATICSHL=$(shell echo $(LINKFLAGSSHL) | sed 's/$(PRJNAME)$(TARGET)$(STATICLIBNAME)/$(STATICLIBNAME)/g')

$(LB)$/$(DLLPRE)$(PRJNAME)$(TARGET)$(STATICLIBNAME)$(DLLPOST): $(MISC)$/$(PRJNAME)$(TARGET)staticdatamembers.o
	+$(LINK) $(LINKFLAGS) $(LINKFLAGSSTATICSHL) $(DYLIBLINKLIST) $(SOLARLIB) -L$(PRJ)$/$(ROUT)$/lib -o $@ $<
	+ln -sf ..$/lib$/$(@:f) $(MISC)$/$(DLLPRE)$(STATICLIBNAME)$(DLLPOST)

# Merge all of the *staticdatamembers.cxx, *staticdatamembers.hxx, and
# *staticdatamembers.h files and compile the merged result

$(MISC)$/$(PRJNAME)$(TARGET)staticdatamembers.o: \
	$(MISC)$/$(PRJNAME)$(TARGET)staticdatamembers.cxx
	@+-$(RM) @.cmd
	@+-$(RM) $(MISC)$/$(@:b).merged.cxx $(MISC)$/$(@:b).merged.hxx $(MISC)$/$(@:b).merged.h
	@+-$(TOUCH) $(MISC)$/$(@:b).merged.cxx $(MISC)$/$(@:b).merged.hxx $(MISC)$/$(@:b).merged.h
	@+-cat /dev/null $(MISC)$/$(@:b).cxx | grep -v '^$$' | sed 's/$(PRJNAME)$(TARGET)staticdatamembers\.h/$(PRJNAME)$(TARGET)staticdatamembers\.merged\.h/' > $(MISC)$/$(@:b).merged.cxx
	@+-cat /dev/null $(MISC)$/$(@:b).hxx | grep -v '^$$' > $(MISC)$/$(@:b).merged.hxx
	@+-cat /dev/null $(MISC)$/$(@:b).h | grep -v '^$$' > $(MISC)$/$(@:b).merged.h
	@+-cat /dev/null `/bin/sh -c "ls $(SOLARINCDIR)$/*staticdatamembers.cxx 2>/dev/null"` | grep -v -e '^$$' -e '#include.*staticdatamembers\.h' >> $(MISC)$/$(@:b).merged.cxx
	@+-cat /dev/null `/bin/sh -c "ls $(SOLARINCDIR)$/*staticdatamembers.hxx 2>/dev/null"` | grep -v '^$$' >> $(MISC)$/$(@:b).merged.hxx
	@+-cat /dev/null `/bin/sh -c "ls $(SOLARINCDIR)$/*staticdatamembers.h 2>/dev/null"` | grep -v '^$$' >> $(MISC)$/$(@:b).merged.h
#dirty hack - added cppuhelper to includepath
	+$(CC) $(CFLAGS) -I$(SOLARSRC)/cppuhelper/unxmacxp.pro/inc $(CFLAGSCXX) $(CFLAGSCXXSLO) $(CFLAGSSLO) $(CFLAGSEXCEPTIONS) $(CDEFS) $(CDEFSSLO) $(CDEFSMT) $(PCHSLOFLAGSU) $(CFLAGSOUTOBJ) $(@) $(MISC)$/$(@:b).merged.cxx

# Generate a source and header file for this project's undefined static data
# members

$(MISC)$/$(PRJNAME)$(TARGET)staticdatamembers.cxx: \
	$(shell -/bin/sh -c "ls $(SLO)$/*.o $(OBJ)$/*.o 2>/dev/null")
	@$(RM) $@ $(MISC)$/$(@:b).hxx $(MISC)$/$(@:b).h
	+$(SOLARENV)$/$(OUTPATH)$/bin$/init-static-template-data -E$(SOLARENV)$/$(OUTPATH)$/inc$/excludedclasses.txt $& $(ISDTSTLPORTLIB) $@

.ENDIF
