/*************************************************************************
 *
 *  $RCSfile: xchar.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:58:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _XOUTX_HXX //autogen
#include <svx/xoutx.hxx>
#endif

#include "xchar.hxx"
#include "types.hxx"

#include "smdll.hxx"
#include "starmath.hrc"



PolyPolygon  SmGetPolyPolygon(const XPolyPolygon &rPoly, OutputDevice *pDev)
	// convert XPolyPolygon in PolyPolygon
{
	PolyPolygon aResult(rPoly.Count());

	USHORT	n = rPoly.Count();
	for (USHORT i = 0;	i < n;	i++)
	{	// nRough = 1 is maximal resolution
		Polygon  aTmp (XOutCreatePolygon(rPoly[i], pDev, 1));
		aResult.Insert(aTmp, i);
	}

	return aResult;
}


XPolyPolygon & SmLogicToPixel(XPolyPolygon &rXPPoly, const OutputDevice &rDev)
	// convert points of 'rXPPoly' from logic coordinates to pixel coordinates
	// according to 'rDev'.
{
	USHORT	n = rXPPoly.Count();
	for (USHORT i = 0;	i < n;	i++)
	{	XPolygon  &rXPoly = rXPPoly[i];

		USHORT	m = rXPoly.GetPointCount();
		for (USHORT j = 0;	j < m;	j++)
		{	Point &rPoint = rXPoly[j];

			rPoint = rDev.LogicToPixel(rPoint);
		}
	}

	return rXPPoly;
}


XPolyPolygon & SmPixelToLogic(XPolyPolygon &rXPPoly, const OutputDevice &rDev)
	// convert points of 'rXPPoly' from pixel coordinates to logic coordinates
	// according to 'rDev'.
{
	for (USHORT i = rXPPoly.Count() - 1;  i >= 0;  i--)
	{	XPolygon  &rXPoly = rXPPoly[i];

		for (USHORT j = rXPoly.GetPointCount() - 1;  j >= 0;  j--)
		{	Point &rPoint = rXPoly[j];

			rPoint = rDev.PixelToLogic(rPoint);
		}
	}

	return rXPPoly;
}


////////////////////////////////////////


static BOOL SmWillBeVisible(const Point &rStart, const Point &rEnd)
	// returns TRUE iff 'SmDrawPolygon' has to draw a line
{
	return 		rStart.Y() >  rEnd.Y()
			||	rStart.Y() == rEnd.Y()	&&	rStart.X() < rEnd.X();
}



void SmDrawPolyPolygon(OutputDevice &rDev, const PolyPolygon &rPPoly)
	// workaround for the "polygon vanishes partly or in whole bug" that
	// occurs when the linecolor is not set.
	// It should become superfluous in the near future when the bug is fixed.
{
	Point  aFrom,
		   aPF, aPT;
	int    nIdx;

	USHORT	nPolys = rPPoly.Count();
	for (USHORT i = 0;	i < nPolys;  i++)
	{	const Polygon &rPoly = rPPoly[i];

		USHORT	nPoints = rPoly.GetSize();
		if (nPoints >= 2)
			aFrom = rPoly[0];
		for (USHORT j = 1;	j < nPoints;  j++)
		{	const Point &rTo = rPoly[j];

			aPF = aFrom;
			aPT = rTo;

			BOOL bDraw = TRUE;

			if (aFrom.Y() > rTo.Y())
			{	if (aFrom.X() == rTo.X())
				{	// draw startpoint only if previous line is to be drawn
					nIdx = j - 2;
					if (nIdx < 0)
						nIdx += nPoints;

					if (   !SmWillBeVisible(rPoly[nIdx], aFrom)
						&&	aPF.Y() > aPT.Y())
							aPF.Y()--;
				}
			}
			else if (aFrom.Y() == rTo.Y()  &&  aFrom.X() < rTo.X())
			{	// draw endpoint only if next line is to be drawn
					nIdx = j + 1;
					if (nIdx == nPoints)
						nIdx = 0;

					if (   !SmWillBeVisible(rTo, rPoly[nIdx])
						&&	aPT.X() > aPF.X())
							aPT.X()--;
			}
			else
				bDraw = FALSE;

			if (bDraw)
				rDev.DrawLine(aPF, aPT);

			aFrom = rTo;
		}
	}
}


////////////////////////////////////////


class SmPolygonLoader : public Resource
{
public:
	SmPolygonLoader(const SmResId &rId, SmPolygon &rSmPolygon);
};


SmPolygonLoader::SmPolygonLoader(const SmResId& rId, SmPolygon &rSmPolygon)
:	Resource (rId)
{
	USHORT	nBytesLeft;		// upper size limit to a single resource is 64 kB!

	// set cursor to begin of resource
	//GetClassRes();	// it's done automatically!

	// get number of bytes from actual position to end of resource
	nBytesLeft = GetRemainSizeRes();

	char *pStr = (char *) GetClassRes();
	SvMemoryStream	aStrm(pStr, nBytesLeft, STREAM_READ);

	aStrm >> rSmPolygon.cChar
		  >> rSmPolygon.aFontSize
		  >> rSmPolygon.aOrigPos
		  >> rSmPolygon.aOrigSize
		  >> rSmPolygon.aPoly;

	//! Warning: don't know why, but it has to be done!
	IncrementRes(nBytesLeft);
}


////////////////////////////////////////
// SmPolygon
//

SmPolygon::SmPolygon()
{
	cChar = sal_Char('\x00'),
	fScaleX = fScaleY =
	fDelayedFactorX = fDelayedFactorY = 1.0;
	bDelayedScale = bDelayedBoundRect = FALSE;
}


SmPolygon::SmPolygon(sal_Unicode cCharP)
{
	cChar = cCharP;
	fScaleX = fScaleY =
	fDelayedFactorX = fDelayedFactorY = 1.0;
	bDelayedScale = bDelayedBoundRect = FALSE;

	if (cChar == sal_Char('\0'))
		return;

	// get appropriate resource id
	int  nResId = 0;
    switch (cChar)
	{
		case MS_LINE : 			nResId = RID_XPP_LINE; 			break;
		case MS_DLINE : 		nResId = RID_XPP_DLINE; 		break;
		case MS_SQRT : 			nResId = RID_XPP_SQRT; 			break;
		case MS_SQRT2 : 		nResId = RID_XPP_SQRT2; 		break;
		case MS_HAT : 			nResId = RID_XPP_HAT; 			break;
		case MS_TILDE : 		nResId = RID_XPP_TILDE; 		break;
		case MS_BAR : 			nResId = RID_XPP_BAR; 			break;
		case MS_VEC : 			nResId = RID_XPP_VEC; 			break;
		case MS_LBRACE : 		nResId = RID_XPP_LBRACE; 		break;
		case MS_RBRACE : 		nResId = RID_XPP_RBRACE; 		break;
		case MS_LPARENT : 		nResId = RID_XPP_LPARENT; 		break;
		case MS_RPARENT : 		nResId = RID_XPP_RPARENT; 		break;
		case MS_LANGLE : 		nResId = RID_XPP_LANGLE; 		break;
		case MS_RANGLE : 		nResId = RID_XPP_RANGLE; 		break;
		case MS_LBRACKET : 		nResId = RID_XPP_LBRACKET; 		break;
		case MS_RBRACKET : 		nResId = RID_XPP_RBRACKET; 		break;
		case MS_LDBRACKET : 	nResId = RID_XPP_LDBRACKET; 	break;
		case MS_RDBRACKET : 	nResId = RID_XPP_RDBRACKET; 	break;
		case MS_LCEIL : 		nResId = RID_XPP_LCEIL; 		break;
		case MS_RCEIL : 		nResId = RID_XPP_RCEIL; 		break;
		case MS_LFLOOR : 		nResId = RID_XPP_LFLOOR; 		break;
		case MS_RFLOOR : 		nResId = RID_XPP_RFLOOR; 		break;
		case MS_OVERBRACE : 	nResId = RID_XPP_OVERBRACE;		break;
		case MS_UNDERBRACE :	nResId = RID_XPP_UNDERBRACE;	break;

		default :
			DBG_ASSERT(0, "Sm: char hat kein Polygon");
	}

	if (nResId)
	{
		// SmPolygon (XPolyPolygon, ...) aus der Resource laden
		SmResId aSmResId(nResId);
		SmPolygonLoader(aSmResId, *this);

		// die verbleibenden member Variablen setzen
		aBoundRect = aPoly.GetBoundRect();
		aPos	   = GetOrigPos();

		// jetzt nach (0, 0) verschieben verbessert die Chancen, da in Scale()
		// (welches ia fter aufgerufen wird) nicht das MoveTo ausgefhrt
		// werden mu
		MoveTo(Point());
	}
}


void SmPolygon::Scale()
{
	DBG_ASSERT(bDelayedScale, "Sm: es gibt nichts zu skalieren");

	Point aOrigin,
		  aDelta;

	if (aPos != aOrigin)
	{
		aDelta = aOrigin - aPos;
		aPoly.Move(aDelta.X(), aDelta.Y());
	}

	aPoly.Scale(fDelayedFactorX, fDelayedFactorY);
	fScaleX *= fDelayedFactorX;
	fScaleY *= fDelayedFactorY;

	bDelayedScale = FALSE;
	fDelayedFactorX = fDelayedFactorY = 1.0;

	// Anm.: aBoundRect stimmt hier immer noch nicht!
	// Das passiert erst wenn es bentigt wird.

	// ggf Ausgangsposition wiederherstellen
	if (aPos != aOrigin)
		aPoly.Move(-aDelta.X(), -aDelta.Y());

}


void SmPolygon::ScaleBy(double fFactorX, double fFactorY)
{
	if (fFactorX != 1.0  ||  fFactorY != 1.0)
	{
		fDelayedFactorX *= fFactorX;
		fDelayedFactorY *= fFactorY;

		bDelayedScale = TRUE;
		bDelayedBoundRect = TRUE;
	}
}


void SmPolygon::AdaptToX(const OutputDevice &rDev, ULONG nWidth)
{
	DBG_ASSERT(aOrigSize.Width() != 0, "Sm: Polygon hat keine Breite");
	if (aOrigSize.Width() != 0)
	{
		double  fFactor = 1.0 / GetScaleX() * nWidth / aOrigSize.Width();
		ScaleBy(fFactor, 1.0);
	}
}


void SmPolygon::AdaptToY(const OutputDevice &rDev, ULONG nHeight)
{
	DBG_ASSERT(aOrigSize.Height() != 0, "Sm: Polygon hat keine Hhe");
	if (aOrigSize.Height() != 0)
	{
		double  fFactor = 1.0 / GetScaleY() * nHeight / aOrigSize.Height();
		ScaleBy(1.0, fFactor);
	}
}


void SmPolygon::Move(const Point &rPoint)
{
	long  nX = rPoint.X(),
		  nY = rPoint.Y();

	aPoly     .Move(nX, nY);
	aBoundRect.Move(nX, nY);
	aPos      .Move(nX, nY);
}


const XPolyPolygon & SmPolygon::GetXPolyPolygon() const
{
	if (bDelayedScale)
		((SmPolygon *) this)->Scale();
	return aPoly;
}


const Rectangle & SmPolygon::GetBoundRect(const OutputDevice &rDev) const
{
	SmPolygon *pNCthis = ((SmPolygon *) this);

	if (bDelayedScale)
		pNCthis->Scale();
	if (bDelayedBoundRect)
	{
		pNCthis->aBoundRect = aPoly.GetBoundRect((OutputDevice *) &rDev);
		pNCthis->bDelayedBoundRect = FALSE;
	}
	return aBoundRect;
}


void SmPolygon::Draw(OutputDevice &rDev, const Point &rPoint) const
{
	if (bDelayedScale)
		((SmPolygon *) this)->Scale();

	// align output position with pixel position
	Point aPos (rDev.PixelToLogic(rDev.LogicToPixel(rPoint)));

	PolyPolygon  aDrawPoly (SmGetPolyPolygon(aPoly, &rDev));

	Point  aDelta (aPos - aDrawPoly.GetBoundRect().TopLeft());
	aDrawPoly.Move(aDelta.X(), aDelta.Y());

	rDev.DrawPolyPolygon(aDrawPoly);

	if (rDev.GetOutDevType() != OUTDEV_PRINTER)
	{	// workaround to avoid vanishing of the polygon
		Color aOldCol = rDev.GetLineColor();
		rDev.SetLineColor(rDev.GetFont().GetColor());
		SmDrawPolyPolygon(rDev, aDrawPoly);
		rDev.SetLineColor(aOldCol);
	}
}


