/*************************************************************************
 *
 *  $RCSfile: sbxbool.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ab $ $Date: 2002/10/14 08:36:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif
#include "sbx.hxx"
#include "sbxconv.hxx"
#include "sbxres.hxx"

// AB 29.10.99 Unicode
#ifndef _USE_NO_NAMESPACE
using namespace rtl;
#endif

INT16 ImpGetBool( const SbxValues* p )
{
	INT16 nRes;
	switch( p->eType )
	{
		case SbxNULL:
			SbxBase::SetError( SbxERR_CONVERSION );
		case SbxEMPTY:
			nRes = SbxFALSE; break;
		case SbxCHAR:
			nRes = p->nChar ? SbxTRUE : SbxFALSE; break;
		case SbxBYTE:
			nRes = p->nByte ? SbxTRUE : SbxFALSE; break;
		case SbxINTEGER:
		case SbxBOOL:
			nRes = p->nInteger ? SbxTRUE : SbxFALSE; break;
		case SbxERROR:
		case SbxUSHORT:
			nRes = p->nUShort ? SbxTRUE : SbxFALSE; break;
		case SbxLONG:
			nRes = p->nLong ? SbxTRUE : SbxFALSE; break;
		case SbxULONG:
			nRes = p->nULong ? SbxTRUE : SbxFALSE; break;
		case SbxSINGLE:
			nRes = p->nSingle ? SbxTRUE : SbxFALSE; break;
		case SbxDATE:
		case SbxDOUBLE:
			nRes = p->nDouble ? SbxTRUE : SbxFALSE; break;
		case SbxSALINT64:
            nRes = p->nInt64 ? SbxTRUE : SbxFALSE; break;
		case SbxSALUINT64:
            nRes = p->uInt64 ? SbxTRUE : SbxFALSE; break;
		case SbxULONG64:
			nRes = !!p->nULong64 ? SbxTRUE : SbxFALSE; break;
		case SbxLONG64:
		case SbxCURRENCY:
			nRes = !!p->nLong64 ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxSTRING:
		case SbxSTRING:
		case SbxLPSTR:
			nRes = SbxFALSE;
			if( p->pString )
			{
				if( p->pString->EqualsIgnoreCaseAscii( SbxRes( STRING_TRUE ) ) )
					nRes = SbxTRUE;
				else if( !p->pString->EqualsIgnoreCaseAscii( SbxRes( STRING_FALSE ) ) )
				{
					// Jetzt kann es noch in eine Zahl konvertierbar sein
					BOOL bError = TRUE;
					double n;
					SbxDataType t;
					USHORT nLen = 0;
					String s( *p->pString );
					if( ImpScan( s, n, t, &nLen ) == SbxERR_OK )
					{
						if( nLen == s.Len() )
						{
							bError = FALSE;
							if( n != 0.0 )
								nRes = SbxTRUE;
						}
					}
					if( bError )
						SbxBase::SetError( SbxERR_CONVERSION );
				}
			}
			break;
		case SbxOBJECT:
		{
			SbxValue* pVal = PTR_CAST(SbxValue,p->pObj);
			if( pVal )
				nRes = pVal->GetBool();
			else
			{
				SbxBase::SetError( SbxERR_NO_OBJECT ); nRes = 0;
			}
			break;
		}

		case SbxBYREF | SbxCHAR:
			nRes = *p->pChar ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxBYTE:
			nRes = *p->pByte ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxINTEGER:
		case SbxBYREF | SbxBOOL:
			nRes = *p->pInteger ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxLONG:
			nRes = *p->pLong ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxULONG:
			nRes = *p->pULong ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxERROR:
		case SbxBYREF | SbxUSHORT:
			nRes = *p->pUShort ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxSINGLE:
			nRes = ( *p->pSingle != 0 ) ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxDATE:
		case SbxBYREF | SbxDOUBLE:
			nRes = ( *p->pDouble != 0 ) ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxSALINT64:
            nRes = ( *p->pnInt64 ) ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxSALUINT64:
            nRes = ( *p->puInt64 ) ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxULONG64:
			nRes = !!*p->pULong64 ? SbxTRUE : SbxFALSE; break;
		case SbxBYREF | SbxLONG64:
		case SbxBYREF | SbxCURRENCY:
			nRes = !!*p->pLong64 ? SbxTRUE : SbxFALSE; break;

		default:
			SbxBase::SetError( SbxERR_CONVERSION ); nRes = 0;
	}
	return nRes;
}

void ImpPutBool( SbxValues* p, INT16 n )
{
	if( n )
		n = SbxTRUE;
	switch( p->eType )
	{
		case SbxCHAR:
			p->nChar = (xub_Unicode) n; break;
		case SbxUINT:
			p->nByte = (BYTE) n; break;
		case SbxINTEGER:
		case SbxBOOL:
			p->nInteger = n; break;
		case SbxLONG:
			p->nLong = n; break;
		case SbxULONG:
			p->nULong = (UINT32) n; break;
		case SbxERROR:
		case SbxUSHORT:
			p->nUShort = (UINT16) n; break;
		case SbxSINGLE:
			p->nSingle = n; break;
		case SbxDATE:
		case SbxDOUBLE:
			p->nDouble = n; break;
		case SbxSALINT64:
			p->nInt64 = n; break;
		case SbxSALUINT64:
			p->uInt64 = n; break;
		case SbxULONG64:
			p->nULong64.Set( (UINT32)n ); break;
		case SbxLONG64:
		case SbxCURRENCY:
			p->nLong64.Set( (INT32)n ); break;

		case SbxBYREF | SbxSTRING:
		case SbxSTRING:
		case SbxLPSTR:
			if( !p->pString )
				p->pString = new XubString;
			*p->pString = SbxRes( n ? STRING_TRUE : STRING_FALSE );
			break;

		case SbxOBJECT:
		{
			SbxValue* pVal = PTR_CAST(SbxValue,p->pObj);
			if( pVal )
				pVal->PutBool( BOOL( n != 0 ) );
			else
				SbxBase::SetError( SbxERR_NO_OBJECT );
			break;
		}
		case SbxBYREF | SbxCHAR:
			*p->pChar = (xub_Unicode) n; break;
		case SbxBYREF | SbxBYTE:
			*p->pByte = (BYTE) n; break;
		case SbxBYREF | SbxINTEGER:
		case SbxBYREF | SbxBOOL:
			*p->pInteger = (INT16) n; break;
		case SbxBYREF | SbxERROR:
		case SbxBYREF | SbxUSHORT:
			*p->pUShort = (UINT16) n; break;
		case SbxBYREF | SbxLONG:
			*p->pLong = n; break;
		case SbxBYREF | SbxULONG:
			*p->pULong = (UINT32) n; break;
		case SbxBYREF | SbxSINGLE:
			*p->pSingle = n; break;
		case SbxBYREF | SbxDATE:
		case SbxBYREF | SbxDOUBLE:
			*p->pDouble = n; break;
		case SbxBYREF | SbxSALINT64:
			*p->pnInt64 = n; break;
		case SbxBYREF | SbxSALUINT64:
			*p->puInt64 = n; break;
		case SbxBYREF | SbxULONG64:
			p->pULong64->Set( (UINT32)n ); break;
		case SbxBYREF | SbxLONG64:
		case SbxBYREF | SbxCURRENCY:
			p->pLong64->Set( (INT32)n ); break;

		default:
			SbxBase::SetError( SbxERR_CONVERSION );
	}
}

