/*************************************************************************
 *
 *  $RCSfile: expander.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <svtdata.hxx>
#include <svtools.hrc>
#include "expander.hxx"

#define	TEXT_ADD		4

static Point ImplCalcPos( WinBits nStyle, const Point& rPos,
						  const Size& rObjSize, const Size& rWinSize )
{
	long	nX;
	long	nY;

	if ( nStyle & WB_LEFT )
		nX = 0;
	else if ( nStyle & WB_RIGHT )
		nX = rWinSize.Width()-rObjSize.Width();
	else
		nX = (rWinSize.Width()-rObjSize.Width())/2;

	if ( nStyle & WB_TOP )
		nY = 0;
	else if ( nStyle & WB_BOTTOM )
		nX = rWinSize.Height()-rObjSize.Height();
	else
		nY = (rWinSize.Height()-rObjSize.Height())/2;

	if ( nStyle & WB_TOPLEFTVISIBLE )
	{
		if ( nX < 0 )
			nX = 0;
		if ( nY < 0 )
			nY = 0;
	}

	Point aPos( nX+rPos.X(), nY+rPos.Y() );
	return aPos;
}

SvExpander::SvExpander( Window* pParent, WinBits nStyle):
			Control(pParent,nStyle),
			maExpanderImages(SvtResId(RID_IMG_EXPANDER)),
			mbIsExpanded(TRUE),
			mbHasFocusRect(FALSE),
			mbIsInMouseDown(FALSE)
{
	SetToExpanded(mbIsExpanded);
}

SvExpander::SvExpander( Window* pParent, const ResId& rResId ) :
			Control(pParent,rResId),
			maExpanderImages(SvtResId(RID_IMG_EXPANDER)),
			mbIsExpanded(TRUE),
			mbHasFocusRect(FALSE),
			mbIsInMouseDown(FALSE)
{
	SetToExpanded(mbIsExpanded);
	Resize();
}

void SvExpander::Resize()
{
	Size aSize=GetOutputSizePixel();
	aSize.Width()=aActiveImage.GetSizePixel().Width();
	aImagePos=ImplCalcPos(GetStyle(),Point(),aActiveImage.GetSizePixel(),aSize);

	aTextPos=aImagePos;
	aTextPos.X()+=aActiveImage.GetSizePixel().Width()+TEXT_ADD;

	aSize = Size(GetTextWidth( GetText()), GetTextHeight());
	aSize.Width()+=TEXT_ADD;
	maFocusRect=Rectangle(aTextPos,aSize);

}

void SvExpander::Paint( const Rectangle& rRect )
{
	Point aPos(aImagePos);
	aPos.X()+=aActiveImage.GetSizePixel().Width()+TEXT_ADD;

	Control::Paint(rRect );

	if(mbHasFocusRect)
		ShowFocus(maFocusRect);

	DrawImage(aImagePos,aActiveImage);
	DrawText(aPos,GetText());

}
void SvExpander::SetToExpanded(BOOL bFlag)
{
	SvExpanderStateType eType=EST_NONE;
	if(bFlag)
	{
		if(IsEnabled())
			eType=EST_MIN;
		else
			eType=EST_MIN_DIS;
	}
	else
	{
		if(IsEnabled())
			eType=EST_PLUS;
		else
			eType=EST_PLUS_DIS;
	}

	SetExpanderImage(eType);
	mbIsExpanded=bFlag;
}

void SvExpander::SetExpanderImage( SvExpanderStateType eType)
{
	aActiveImage=GetExpanderImage(eType);
	DrawImage(aImagePos,aActiveImage);
}

Image SvExpander::GetExpanderImage(SvExpanderStateType eType)
{
	USHORT nId=eType;
	return maExpanderImages.GetImage(nId);
}

long SvExpander::PreNotify( NotifyEvent& rNEvt )
{
	USHORT nSwitch=rNEvt.GetType();

	if(nSwitch==EVENT_GETFOCUS)
	{
		ShowFocus(maFocusRect);
		mbHasFocusRect=TRUE;
	}
	else if(nSwitch==EVENT_LOSEFOCUS)
	{
		HideFocus();
		mbHasFocusRect=FALSE;
	}

	return Control::PreNotify(rNEvt);
}

void SvExpander::KeyInput( const KeyEvent& rKEvt )
{
	if(rKEvt.GetCharCode()==' ')
	{
		if(IsExpanded())
		{
			SetExpanderImage(EST_MIN_DOWN);
		}
		else
		{
			SetExpanderImage(EST_PLUS_DOWN);
		}
	}
	Control::KeyInput(rKEvt);
}

void SvExpander::KeyUp( const KeyEvent& rKEvt )
{
	if(rKEvt.GetCharCode()==' ')
		Click();

	Control::KeyUp(rKEvt);
}

void SvExpander::MouseButtonDown( const MouseEvent& rMEvt )
{
	if(rMEvt.IsLeft())
	{
		Point aPoint=rMEvt.GetPosPixel();
		ULONG nWidth=maFocusRect.BottomRight().X();
		Rectangle aRect(maFocusRect);
		aRect.Top()=aImagePos.Y();
		aRect.Left()=aImagePos.X();
		Region aRegion(aRect);

		BOOL bFlag=aRegion.IsInside(aPoint );

		if(bFlag)
		{
			mbIsInMouseDown=TRUE;

			if(IsExpanded())
			{
				SetExpanderImage(EST_MIN_DOWN);
			}
			else
			{
				SetExpanderImage(EST_PLUS_DOWN);
			}
		}
	}
}

void SvExpander::MouseMove( const MouseEvent& rMEvt )
{
	if(rMEvt.IsLeft() &&mbIsInMouseDown)
	{
		Point aPoint=rMEvt.GetPosPixel();
		ULONG nWidth=maFocusRect.BottomRight().X();
		Rectangle aRect(maFocusRect);
		aRect.Top()=aImagePos.Y();
		aRect.Left()=aImagePos.X();
		Region aRegion(aRect);

		BOOL bFlag=aRegion.IsInside(aPoint );

		if(bFlag)
		{
			if(IsExpanded())
			{
				SetExpanderImage(EST_MIN_DOWN);
			}	
			else
			{
				SetExpanderImage(EST_PLUS_DOWN);
			}
		}
		else
		{
			if(IsExpanded())
			{
				SetExpanderImage(EST_MIN);
			}	
			else
			{
				SetExpanderImage(EST_PLUS);
			}
		}
	}
}

void SvExpander::MouseButtonUp( const MouseEvent& rMEvt )
{
	if(rMEvt.IsLeft() &&mbIsInMouseDown)
	{
		mbIsInMouseDown=FALSE;

		Point aPoint=rMEvt.GetPosPixel();
		ULONG nWidth=maFocusRect.BottomRight().X();
		Rectangle aRect(maFocusRect);
		aRect.Top()=aImagePos.Y();
		aRect.Left()=aImagePos.X();
		Region aRegion(aRect);

		BOOL bFlag=aRegion.IsInside(aPoint );

		if(bFlag) Click();
	}
}
void SvExpander::Click()
{
	maToggleHdl.Call(this);
	SetToExpanded(!mbIsExpanded);
}

Size SvExpander::GetMinSize() const
{
	Size aSize( aActiveImage.GetSizePixel());
	aSize.Width()+=TEXT_ADD;
	return aSize;
}


