/*************************************************************************
 *
 *  $RCSfile: about3.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "about3.hxx"

// --- AboutBox::AboutBox() ----------------------------------------

AboutBox::AboutBox( Window* pParent ) :
		  ModalDialog( pParent, WB_STDMODAL ),
		  aText( this, WB_CENTER ),
		  aButton( this )
{
	SetText( "Paint and Mail" );
	ChangePosPixel( Point( 100, 100 ) );
	ChangeSizePixel( Size( 200, 200 ) );

	aText.SetText( "StarView Paint and Mail\n"
				   "(c) STAR DIVISION\n"
				   "and Peter Burow\n"
				   "1994" );
	aText.ChangePosPixel( Point( 25, 80 ) );
	aText.ChangeSizePixel( Size( 150, 50 ) );
	aText.Show();

	aButton.SetText( "~OK" );
	aButton.ChangePosPixel( Point( 65, 135 ) );
	aButton.ChangeSizePixel( Size( 70, 25 ) );
	aButton.ChangeClickHdl( LINK( this, AboutBox, ButtonHdl ) );
	aButton.Show();
}

// --- AboutBox::Paint() -------------------------------------------

void AboutBox::Paint( const Rectangle& )
{
	Brush   aOldBrush;
	Point   aPointAry[3];
	aPointAry[0] = Point( 110,70 );
	aPointAry[1] = Point( 140,30 );
	aPointAry[2] = Point( 170,70 );

	aOldBrush = ChangeFillInBrush( Brush( Color( COL_RED ) ) );
	DrawRect( Rectangle( Point( 20, 10 ), Point( 80, 50 ) ) );

	ChangeFillInBrush( Brush( Color( COL_BLUE ) ) );
	DrawEllipse( Rectangle( Point( 60, 20 ), Point( 130, 60 ) ) );

	ChangeFillInBrush( Brush( Color( COL_GREEN ) ) );
	DrawPolygon( Polygon( 3, aPointAry ) );

	ChangeFillInBrush( aOldBrush );
}

// --- AboutBox::ButtonHdl() ---------------------------------------

IMPL_LINK_INLINE_START( AboutBox, ButtonHdl, Button *, EMPTYARG )
{
	EndDialog();
	return 0;
}
IMPL_LINK_INLINE_END( AboutBox, ButtonHdl, Button *, EMPTYARG )
