/*************************************************************************
 *
 *  $RCSfile: grfatr.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/07/16 18:07:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _GRFATR_HXX
#define _GRFATR_HXX

#ifndef _HINTIDS_HXX
#include <hintids.hxx>		// fuer die WhichIds
#endif

#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SVX_GRFCROP_HXX
#include <svx/grfcrop.hxx>
#endif

#ifndef _SWATRSET_HXX
#include <swatrset.hxx>		// fuer inlines
#endif
#ifndef _FORMAT_HXX
#include <format.hxx>		// fuer inlines
#endif

/******************************************************************************
 *	class SwMirrorGrf
 ******************************************************************************/

enum GRFMIRROR
{
RES_GRFMIRROR_BEGIN,
	RES_DONT_MIRROR_GRF = RES_GRFMIRROR_BEGIN,
	RES_MIRROR_GRF_VERT,
	RES_MIRROR_GRF_HOR,
	RES_MIRROR_GRF_BOTH,
RES_GRFMIRROR_END
};

class SwMirrorGrf : public SfxEnumItem
{
	BOOL bGrfToggle; // auf geraden Seiten Grafiken spiegeln

public:
	SwMirrorGrf( USHORT nMiro = RES_DONT_MIRROR_GRF )
		: SfxEnumItem( RES_GRFATR_MIRRORGRF, nMiro ), bGrfToggle( sal_False )
	{}
	SwMirrorGrf::SwMirrorGrf( const SwMirrorGrf &rMirrorGrf )
		: SfxEnumItem( RES_GRFATR_MIRRORGRF, rMirrorGrf.GetValue()),
		bGrfToggle( rMirrorGrf.IsGrfToggle() )
	{}

	// pure virtual-Methoden von SfxPoolItem
	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;

	// pure virtual-Methiden von SfxEnumItem
	virtual USHORT			GetValueCount() const;
	virtual USHORT			GetVersion( USHORT nFFVer ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nVer ) const;
	virtual SvStream&		Store(SvStream &, USHORT nIVer) const;
	virtual int				operator==( const SfxPoolItem& ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper*    pIntl = 0 ) const;

	virtual	BOOL        	 QueryValue( com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 ) const;
	virtual	BOOL			 PutValue( const com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 );

	inline SwMirrorGrf& operator=( const SwMirrorGrf& rMirrorGrf )
		{
			SfxEnumItem::SetValue( rMirrorGrf.GetValue() );
			bGrfToggle = rMirrorGrf.IsGrfToggle();
			return *this;
		}

	inline BOOL IsGrfToggle() const			{ return bGrfToggle; }
	inline void SetGrfToggle( BOOL bNew )	{ bGrfToggle = bNew; }
};


/******************************************************************************
 *	class SwAttrCropGrf
 ******************************************************************************/

class SwCropGrf : public SvxGrfCrop
{
public:
	TYPEINFO();
	SwCropGrf();
	SwCropGrf(  sal_Int32 nLeft,	sal_Int32 nRight,
				sal_Int32 nTop,		sal_Int32 nBottom );

	// "pure virtual Methoden" vom SfxPoolItem
	virtual SfxPoolItem*		Clone( SfxItemPool *pPool = 0 ) const;
	virtual USHORT			 	GetVersion( USHORT nFileVersion ) const;
};

class SwRotationGrf : public SfxUInt16Item
{
	Size aUnrotatedSize;
public:
	SwRotationGrf( sal_Int16 nVal = 0 )
		: SfxUInt16Item( RES_GRFATR_ROTATION, nVal )
	{}
	SwRotationGrf( sal_Int16 nVal, const Size& rSz )
		: SfxUInt16Item( RES_GRFATR_ROTATION, nVal ), aUnrotatedSize( rSz )
	{}

	// pure virtual-Methiden from SfxInt16Item
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
	virtual USHORT		 GetVersion( USHORT nFFVer ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nVer ) const;
	virtual SvStream&		Store(SvStream &, USHORT nIVer) const;
	virtual int				operator==( const SfxPoolItem& ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;
	virtual	BOOL        	 QueryValue( com::sun::star::uno::Any& rVal,
											BYTE nMemberId = 0 ) const;
	virtual	BOOL			 PutValue( const com::sun::star::uno::Any& rVal,
											BYTE nMemberId = 0 );

	void SetUnrotatedSize( const Size& rSz ) 		{ aUnrotatedSize = rSz; }
	const Size& GetUnrotatedSize() const 			{ return aUnrotatedSize; }
};

class SwLuminanceGrf : public SfxInt16Item
{
public:
	SwLuminanceGrf( sal_Int16 nVal = 0 )
		: SfxInt16Item( RES_GRFATR_LUMINANCE, nVal )
	{}

	// pure virtual-Methiden from SfxInt16Item
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
	virtual USHORT		 GetVersion( USHORT nFFVer ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;
};

class SwContrastGrf : public SfxInt16Item
{
public:
	SwContrastGrf( sal_Int16 nVal = 0 )
		: SfxInt16Item( RES_GRFATR_CONTRAST, nVal )
	{}

	// pure virtual-Methiden from SfxInt16Item
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
	virtual USHORT		 GetVersion( USHORT nFFVer ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;
};

class SwChannelGrf : public SfxInt16Item
{
protected:
	SwChannelGrf( sal_Int16 nVal, USHORT nWhich )
		: SfxInt16Item( nWhich, nVal )
	{}

public:
	// pure virtual-Methiden from SfxInt16Item
	virtual USHORT			GetVersion( USHORT nFFVer ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;
};

class SwChannelRGrf : public SwChannelGrf
{
public:
    SwChannelRGrf( sal_Int16 nVal = 0 )
		: SwChannelGrf( nVal, RES_GRFATR_CHANNELR )
    {}
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
};
class SwChannelGGrf : public SwChannelGrf
{
public:
    SwChannelGGrf( sal_Int16 nVal = 0 )
		: SwChannelGrf( nVal, RES_GRFATR_CHANNELG )
    {}
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
};
class SwChannelBGrf : public SwChannelGrf
{
public:
    SwChannelBGrf( sal_Int16 nVal = 0 )
		: SwChannelGrf( nVal, RES_GRFATR_CHANNELB )
    {}
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
};

class SwGammaGrf : public SfxPoolItem
{
	double nValue;
public:
	TYPEINFO();
	SwGammaGrf() : SfxPoolItem( RES_GRFATR_GAMMA ), nValue( 1.0 )
	{}

	SwGammaGrf( const double& rVal )
		: SfxPoolItem( RES_GRFATR_GAMMA ), nValue( rVal )
	{}

	inline SwGammaGrf& operator=( const SwGammaGrf& rCopy )
		{
			SetValue( rCopy.GetValue() );
			return *this;
		}

	// pure virtual-Methiden von SfxEnumItem
    virtual SfxPoolItem* 	Clone( SfxItemPool *pPool = 0 ) const;
	virtual USHORT			GetVersion( USHORT nFFVer ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nVer ) const;
	virtual SvStream&		Store(SvStream &, USHORT nIVer) const;
	virtual int				operator==( const SfxPoolItem& ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;

	virtual	BOOL        	 QueryValue( com::sun::star::uno::Any& rVal,
											BYTE nMemberId = 0 ) const;
	virtual	BOOL			 PutValue( const com::sun::star::uno::Any& rVal,
											BYTE nMemberId = 0 );


	const double& GetValue() const				{ return nValue; }
	void SetValue( const double& rVal )			{ nValue = rVal; }
};

class SwInvertGrf: public SfxBoolItem
{
public:
	SwInvertGrf( sal_Bool bVal = sal_False )
		: SfxBoolItem( RES_GRFATR_INVERT, bVal )
	{}

	// pure virtual-Methiden from SfxInt16Item
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
	virtual USHORT		 GetVersion( USHORT nFFVer ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;
};

class SwTransparencyGrf : public SfxByteItem
{
public:
	SwTransparencyGrf( sal_Int8 nVal = 0 )
		: SfxByteItem( RES_GRFATR_TRANSPARENCY, nVal )
	{}

	// pure virtual-Methiden from SfxInt16Item
    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
	virtual USHORT		 GetVersion( USHORT nFFVer ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;
	virtual	BOOL        	QueryValue( com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 ) const;
	virtual	BOOL			PutValue( const com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 );
};

class SwDrawModeGrf : public SfxEnumItem
{
public:
	SwDrawModeGrf( USHORT nMode = 0 )
		: SfxEnumItem( RES_GRFATR_DRAWMODE, nMode )
	{}

	// pure virtual-Methoden von SfxPoolItem
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;

	// pure virtual-Methiden von SfxEnumItem
	virtual USHORT			GetValueCount() const;
	virtual USHORT			GetVersion( USHORT nFFVer ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper*    pIntl = 0 ) const;

	virtual	BOOL        	QueryValue( com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 ) const;
	virtual	BOOL			PutValue( const com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 );
};



/******************************************************************************
 *	Implementierung der GrafikAttribut Methoden vom SwAttrSet
 ******************************************************************************/

#if !(defined(MACOSX) && ( __GNUC__ < 3 ))
// GrP moved to gcc_outl.cxx; revisit with gcc3
inline const SwMirrorGrf &SwAttrSet::GetMirrorGrf(BOOL bInP) const
	{ return (const SwMirrorGrf&)Get( RES_GRFATR_MIRRORGRF,bInP); }
#endif
inline const SwCropGrf   &SwAttrSet::GetCropGrf(BOOL bInP) const
	{ return (const SwCropGrf&)Get( RES_GRFATR_CROPGRF,bInP); }
inline const SwRotationGrf &SwAttrSet::GetRotationGrf(BOOL bInP) const
	{ return (const SwRotationGrf&)Get( RES_GRFATR_ROTATION,bInP); }
inline const SwLuminanceGrf &SwAttrSet::GetLuminanceGrf(BOOL bInP) const
	{ return (const SwLuminanceGrf&)Get( RES_GRFATR_LUMINANCE,bInP); }
inline const SwContrastGrf &SwAttrSet::GetContrastGrf(BOOL bInP) const
	{ return (const SwContrastGrf&)Get( RES_GRFATR_CONTRAST,bInP); }
inline const SwChannelRGrf &SwAttrSet::GetChannelRGrf(BOOL bInP) const
	{ return (const SwChannelRGrf&)Get( RES_GRFATR_CHANNELR,bInP); }
inline const SwChannelGGrf &SwAttrSet::GetChannelGGrf(BOOL bInP) const
	{ return (const SwChannelGGrf&)Get( RES_GRFATR_CHANNELG,bInP); }
inline const SwChannelBGrf &SwAttrSet::GetChannelBGrf(BOOL bInP) const
	{ return (const SwChannelBGrf&)Get( RES_GRFATR_CHANNELB,bInP); }
inline const SwGammaGrf &SwAttrSet::GetGammaGrf(BOOL bInP) const
	{ return (const SwGammaGrf&)Get( RES_GRFATR_GAMMA,bInP); }
inline const SwInvertGrf &SwAttrSet::GetInvertGrf(BOOL bInP) const
	{ return (const SwInvertGrf&)Get( RES_GRFATR_INVERT,bInP); }
inline const SwTransparencyGrf &SwAttrSet::GetTransparencyGrf(BOOL bInP) const
	{ return (const SwTransparencyGrf&)Get( RES_GRFATR_TRANSPARENCY,bInP); }
inline const SwDrawModeGrf		&SwAttrSet::GetDrawModeGrf(BOOL bInP) const
	{ return (const SwDrawModeGrf&)Get( RES_GRFATR_DRAWMODE,bInP); }

/******************************************************************************
 *	Implementierung der GrafikAttribut Methoden vom SwFmt
 ******************************************************************************/

#if ! (defined(MACOSX) && ( __GNUC__ < 3 ) )
// GrP moved to gcc_outl.cxx; revisit with gcc3
inline const SwMirrorGrf &SwFmt::GetMirrorGrf(BOOL bInP) const
	{ return aSet.GetMirrorGrf(bInP); }
#endif
inline const SwCropGrf   &SwFmt::GetCropGrf(BOOL bInP) const
	{ return aSet.GetCropGrf(bInP); }
inline const SwRotationGrf &SwFmt::GetRotationGrf(BOOL bInP) const
	{ return aSet.GetRotationGrf(bInP); }
inline const SwLuminanceGrf &SwFmt::GetLuminanceGrf(BOOL bInP) const
	{ return aSet.GetLuminanceGrf( bInP); }
inline const SwContrastGrf &SwFmt::GetContrastGrf(BOOL bInP) const
	{ return aSet.GetContrastGrf( bInP); }
inline const SwChannelRGrf &SwFmt::GetChannelRGrf(BOOL bInP) const
	{ return aSet.GetChannelRGrf( bInP); }
inline const SwChannelGGrf &SwFmt::GetChannelGGrf(BOOL bInP) const
	{ return aSet.GetChannelGGrf( bInP); }
inline const SwChannelBGrf &SwFmt::GetChannelBGrf(BOOL bInP) const
	{ return aSet.GetChannelBGrf( bInP); }
inline const SwGammaGrf	&SwFmt::GetGammaGrf(BOOL bInP) const
	{ return aSet.GetGammaGrf( bInP); }
inline const SwInvertGrf &SwFmt::GetInvertGrf(BOOL bInP) const
	{ return aSet.GetInvertGrf( bInP); }
inline const SwTransparencyGrf &SwFmt::GetTransparencyGrf(BOOL bInP) const
	{ return aSet.GetTransparencyGrf( bInP); }
inline const SwDrawModeGrf &SwFmt::GetDrawModeGrf(BOOL bInP) const
	{ return aSet.GetDrawModeGrf(bInP); }


#endif  // _GRFATR_HXX
