/*************************************************************************
 *
 *  $RCSfile: purge.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _PURGE_HXX
#define _PURGE_HXX

#include <mac_start.h>
 #include <Resources.h>
 #include <Strings.h>
#include <mac_end.h>

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif

#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif
/*
#include <sv.hxx>
#include <svmem.hxx>
*/
#include "swtypes.hxx"


class PurgeStatus;

/******************************************************************************
 *								 SegmentInfo
 ******************************************************************************/
struct SegInfo
{
	Handle	aSegHdl;
	long	nAddrStart;
	long	nAddrEnd;
	BOOL	bLoad;
};

/******************************************************************************
 *							   ModelFarCodeHeader
 ******************************************************************************/
struct ModelFarCodeHeader
{
	short 	field1;
	short 	field2;
	long 	A5OffsetOf16BitEntries;
	long 	numOf16BitEntries;
	long 	A5OffsetOf32BitEntries;
	long 	numOf32BitEntries;
	char 	otherEvenMorePrivateStuff;
};

/******************************************************************************
 *								 class SwPurge
 ******************************************************************************/
enum SwPurgeStatus
{
	STATUS_NORMAL = 0, 		STATUS_ATTENTION = 1,		STATUS_CRITICAL = 2,
	STATUS_EMERGENCY = 3,	STATUS_NOMEM = 4
};

SV_DECL_PTRARR( SegmentInfo, SegInfo*, 5, 5 )
SV_DECL_VARARR( HeapWalk, long, 255, 255 )

class SegmentLRU
{
	USHORT	*pSegIDCache;
	USHORT	nSize, nPos;
public:
		SegmentLRU( USHORT nSz );
		SegmentLRU() {};
		~SegmentLRU();

	void	Insert( USHORT nValue );
	USHORT	operator[]( USHORT nIdx );
};

class SwPurge
{
	friend class PurgeStatus;				// das ist Doctor Purge
protected:
	static AutoTimer		aTimer;
	static SwPurgeStatus	eStatus;
	static long				nFreeMem;

	static void		Unload(SegInfo *pSInfo);
	static BOOL		UpdateHeapWalk();
	void			UpdateStatus();
	void			BrowseSegs();
	void			PurgeA5Init();
public:
	static SegmentInfo	*pSegList;
	static HeapWalk		*pHeapWalk;
	static SegmentLRU	aSegLRU;

	SwPurge();
	~SwPurge();

	DECL_LINK( Purger, Timer * );
	static void		UnloadSegments( BOOL bLRU = TRUE );
};


/******************************************************************************
 *							Funktionen aus PTOOLS.CXX
 ******************************************************************************/
extern void	_SegInfoLoad( Handle h, SegInfo &rInfo );
extern void	_SegInfoUnLoad( SegInfo &rInfo );
extern BOOL	_IsHandlePurged(Handle h);
extern BOOL	_IsHandleLocked(Handle h);
extern BOOL	_IsHandlePurgeable(Handle h);
extern BOOL	_IsModelFarCodeSegment(Handle h);


#endif
