/*************************************************************************
 *
 *  $RCSfile: wrt_db.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _WRT_DB_HXX
#define _WRT_DB_HXX

#include "shellio.hxx"
#include "wrt_fn.hxx"

// einige Forward Deklarationen
class SwFmt;
class SwTableNode;
class SwPaM;
class SwNodes;
class SwNumRule;

extern SwAttrFnTab aDBAttrFnTab;
extern SwNodeFnTab aDBNodeFnTab;


// der DB-Writer

class SwDBWriter : public Writer
{
protected:
	virtual ULONG WriteStream();

public:
	BOOL bOutTable : 1;
	BOOL bTxtAttr : 1;				// werden TextAttribute ausgegeben ?

	const SwFmt* pNdFmt, *pNdCondColl;	// akt. Format/Collection vom Node
									// fuer den Zugriff auf einige Attribute
									// z.B. Font-Size, LR-Space,..

#if defined(MAC) || defined(UNX)
	static const sal_Char sNewLine;		// nur \012 oder \015
#else
	static const sal_Char __FAR_DATA sNewLine[];	// \015\012
#endif

	SwDBWriter();
	virtual ~SwDBWriter();
	void Out_SwDoc( SwPaM*, const SwNodes& rNds );

	SwPaM* GetEndPaM() 				{ return pOrigPam; }
	void SetEndPaM( SwPaM* pPam )	{ pOrigPam = pPam; }
};

Writer& OutDB_SwTableNode( Writer&, SwTableNode & rNode );
Writer& OutDB_SwSectionNode( Writer&, SwSectionNode & rNode );
Writer& OutDB_SwPageDescs( Writer&, const SwDoc& rDoc);
Writer& OutDB_SwFmt( Writer&, const SwFmt& rFmt );
Writer& OutDB_SwNumRule( Writer& rWrt, const SwNumRule& rRule );



#endif	//  _WRT_DB_HXX
