/*************************************************************************
 *
 *  $RCSfile: excui.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __EXCUI_HXX__
#define __EXCUI_HXX__

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

class ExcUiList;
class ExcDataPool;

enum ExcEntryType {
	EET_Table = 0,			// Tabellenname mit benutztem Bereich
	EET_NamedRange = 1,		// benannter Bereich mit Area-Reference
	EET_UserRange = 2 };	// user-defined Area

// stellt einen Eintrag zum Selektieren dar
class ExcUiEntry
	{
	private:
		friend				ExcUiList;
		friend				ExcDataPool;

		String				aName;			// Bezeichnung des Bereiches
		ExcEntryType		eType;

		String				aTabName;		// Name der Tabelle, fix
		USHORT				nTab;			// Definition des Bereiches
		USHORT				nColStart;
		USHORT				nColEnd;
		USHORT				nRowStart;
		USHORT				nRowEnd;
		//ULONG				nStrPos;

		String				*pDefString;	// "Visualisierung" der Definition

		String				*pPageTemplPre;	// Vorlagen vor
		String				*pParaTemplPre;
		String				*pPageTemplPst;	// Vorlagen nach
		String				*pParaTemplPst;

		ExcUiEntry			*pNext;			// naechster in Kette

							ExcUiEntry();	// nur fuer Freunde
		void				SetTempl( String *&pPrimPos, String *&pSecPos,
								const String* );
		void				GenerateDefString( void );
	public:
							ExcUiEntry( const ExcUiEntry &rEntry );
							~ExcUiEntry();

		const ExcUiEntry	&operator =( const ExcUiEntry &rEntry );
		BOOL				operator <( const ExcUiEntry &rEntry ) const;
		BOOL				operator ==( const ExcUiEntry &rEntry ) const;

		// fuer Eintragsbezeichner
		const String		&GetName( void ) const;
		void				GetName( String &rName ) const;
		void				SetName( const String &rName );

		// fuer Tabellen-Namen (fest)
		const String		&GetTabName( void ) const;
		void				GetTabName( String &rName ) const;

		// fuer Eintragstyp
		ExcEntryType		GetType( void );
		void				GetType( ExcEntryType &rType );
		void				SetType( ExcEntryType eType );

		// fuer Eintragsvorlage
		void				SetTemplate(
								const String *pName,	// Name der Vorlage
								BOOL bTemplPage,		// Seitenvorlage?
								BOOL bPosPre = TRUE );	// vor Tabelle?

		// Definition des Eintragsbezeichners
		const String		&GetRange( void );
		void				GetRange( String &rRange );
		void				SetRange(
								USHORT nColStart, USHORT nColEnd,
								USHORT nRowStart, USHORT nRowEnd );
		void				SetRange( const String &rRange );
	};

//
class ExcUiList
	{
	private:
		ExcUiEntry			*pListe;	// erster Eintrag in sortierter Liste
		ExcUiEntry			*pAkt;		// aktuelle Eintrag fuer Iterator
		USHORT				nAnz;		// Anzahl Eintraege
	public:
		ExcUiList();
		~ExcUiList();

		const ExcUiEntry	*operator []( USHORT nIndex ) const;

		const ExcUiEntry	*GetFirst( void );
		const ExcUiEntry	*GetNext( void );

		void				Insert( const ExcUiEntry &rEntry );
							// fuegt rEntry SORTIERT ein

		void				Insert( const ExcUiEntry &rEntry, USHORT nIndex );
							// fuegt Entry VOR nIndex in Liste ein

		BOOL				InList( const ExcUiEntry &rEntry );
	};


#endif

