/*************************************************************************
 *
 *  $RCSfile: wizempf.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 16:00:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif

#ifndef _SWDBDATA_HXX
#include <swdbdata.hxx>
#endif
#include "swtypes.hxx"
#include "dbmgr.hxx"
#include "wizard.hrc"
#include "wizempf.hxx"
#include "initui.hxx"

using namespace com::sun::star::uno;
using namespace rtl;

WizardEmpfDlg::WizardEmpfDlg(SwWizardDialog* pDlgWin, BOOL bTele, BOOL bAnrd)
{
	pWizDlg = pDlgWin;
	pEmpf = NULL;
	bAnrede = bAnrd;
	bTelfon = bTele;

	pE_Text_EmpTit = new FixedText (pDlgWin,SW_RES(DLG_Emp_Text_EmpTit ));
	pE_Text_DBase  = new FixedText (pDlgWin,SW_RES(DLG_Emp_Text_DBase  ));
	pE_List_DBase  = new ListBox   (pDlgWin,SW_RES(DLG_Emp_List_DBase  ));
	pE_List_DBTable= new ListBox   (pDlgWin,SW_RES(DLG_Emp_List_DBTable));

	if (bTelfon)
	{
	   pE_Text_Telfon = new FixedText(pDlgWin,SW_RES(DLG_Emp_Text_Telfon));
	   pE_List_Telfon = new ListBox  (pDlgWin,SW_RES(DLG_Emp_List_Telfon));
	   pE_Text_Telfax = new FixedText(pDlgWin,SW_RES(DLG_Emp_Text_Telfax));
	   pE_List_Telfax = new ListBox  (pDlgWin,SW_RES(DLG_Emp_List_Telfax));
	}
	else
	{
		pE_Text_Telfon = 0;
		pE_List_Telfon = 0;
		pE_Text_Telfax = 0;
		pE_List_Telfax = 0;
	}
	pE_Text_Adress = new FixedText    (pDlgWin,SW_RES(DLG_Emp_Text_Adress));
	pE_MEdt_Adress = new MultiLineEdit(pDlgWin,SW_RES(DLG_Emp_MEdt_Adress));
	pE_SBtn_Insert = new ImageButton (pDlgWin,SW_RES(DLG_Emp_SBtn_Insert));
	pE_BBtn_NewLin = new ImageButton (pDlgWin,SW_RES(DLG_Emp_BBtn_NewLin));
	pE_BBtn_NewLin->SetModeImage(SW_RES(DLG_Emp_Image_NewLin),BMP_COLOR_HIGHCONTRAST);
	pE_Text_Fields = new FixedText    (pDlgWin,SW_RES(DLG_Emp_Text_Fields));
	pE_List_Fields = new ListBox      (pDlgWin,SW_RES(DLG_Emp_List_Fields));

	if (bAnrede)
	{
	   pE_Text_AnrFix = new FixedText(pDlgWin,SW_RES(DLG_Emp_Text_AnrFix));
	   pE_Edit_AnrFix = new Edit     (pDlgWin,SW_RES(DLG_Emp_Edit_AnrFix));
	   pE_Text_AnrFld = new FixedText(pDlgWin,SW_RES(DLG_Emp_Text_AnrFld));
	   pE_List_AnrFld = new ListBox  (pDlgWin,SW_RES(DLG_Emp_List_AnrFld));
	}
	else
	{
		pE_Text_AnrFix = 0;
		pE_Edit_AnrFix = 0;
		pE_Text_AnrFld = 0;
		pE_List_AnrFld = 0;
	}

	SetEventHandler();
	pDBasMgr = new SwNewDBMgr;
	InitUI();
}

WizardEmpfDlg::~WizardEmpfDlg()
{
	delete pE_Text_EmpTit ;
	delete pE_Text_DBase  ;
	delete pE_List_DBase  ;
	delete pE_List_DBTable;
	if (pE_Text_Telfon ) delete pE_Text_Telfon ;
	if (pE_List_Telfon ) delete pE_List_Telfon ;
	if (pE_Text_Telfax ) delete pE_Text_Telfax ;
	if (pE_List_Telfax ) delete pE_List_Telfax ;
	delete pE_Text_Adress ;
	delete pE_MEdt_Adress ;
	delete pE_SBtn_Insert ;
	delete pE_BBtn_NewLin ;
	delete pE_Text_Fields ;
	delete pE_List_Fields ;
	if (pE_Text_AnrFix ) delete pE_Text_AnrFix ;
	if (pE_Edit_AnrFix ) delete pE_Edit_AnrFix ;
	if (pE_Text_AnrFld ) delete pE_Text_AnrFld ;
	if (pE_List_AnrFld ) delete pE_List_AnrFld ;
	delete pDBasMgr;
}

void WizardEmpfDlg::Fill(MultiOne& WinArr)
{
	WinArr.AddWin( pE_Text_EmpTit );
	WinArr.AddWin( pE_Text_DBase  );
	WinArr.AddWin( pE_List_DBase, TRUE );
	WinArr.AddWin( pE_List_DBTable, TRUE);
	WinArr.AddWin( pE_Text_Adress );
	WinArr.AddWin( pE_MEdt_Adress, TRUE );
	WinArr.AddWin( pE_SBtn_Insert, TRUE );
	WinArr.AddWin( pE_BBtn_NewLin, TRUE );
	WinArr.AddWin( pE_Text_Fields );
	WinArr.AddWin( pE_List_Fields, TRUE );
	if( pE_Text_AnrFix ) WinArr.AddWin( pE_Text_AnrFix );
	if( pE_Edit_AnrFix ) WinArr.AddWin( pE_Edit_AnrFix, TRUE );
	if( pE_Text_AnrFld ) WinArr.AddWin( pE_Text_AnrFld );
	if( pE_List_AnrFld ) WinArr.AddWin( pE_List_AnrFld, TRUE );
	if( pE_Text_Telfon ) WinArr.AddWin( pE_Text_Telfon );
	if( pE_List_Telfon ) WinArr.AddWin( pE_List_Telfon, TRUE );
	if( pE_Text_Telfax ) WinArr.AddWin( pE_Text_Telfax );
	if( pE_List_Telfax ) WinArr.AddWin( pE_List_Telfax, TRUE );
}

void WizardEmpfDlg::SetPtr(WizardText* pEmp)
{
	pEmpf=pEmp;
	ToUI();
}

void WizardEmpfDlg::FillFeldList(ListBox* pList, BOOL bUnselect, BOOL bInklKeins)
{
	if( pList )
	{
		String aMerk(pE_List_DBase->GetSelectEntry());
		pList->Clear();
		pList->SetNoSelection();
		if( bInklKeins )
			pList->InsertEntry( SW_RESSTR( STR_Emp_NoField ));

		pDBasMgr->GetColumnNames(pList,
				pE_List_DBase->GetSelectEntry(),
				pE_List_DBTable->GetSelectEntry(),
				TRUE);
		pList->SelectEntry( aMerk );
		if( !pList->GetSelectEntryCount() && bInklKeins )
			pList->SelectEntryPos( 0 );
	}
}

String WizardEmpfDlg::GetDBFieldNam(USHORT nNum, BOOL bKlammern)
{
	String aStr(pE_List_DBase->GetSelectEntry());
	aStr += '.';
	aStr += pE_List_DBTable->GetSelectEntry();
	aStr += '.';
    aStr += pE_List_DBTable->GetEntryData(pE_List_DBTable->GetSelectEntryPos()) == 0 ? '0' : '1';
    aStr += '.';
    aStr += pE_List_Fields->GetEntry( nNum );
	if (bKlammern)
	{
		aStr.Insert('<',0);
		aStr+='>';
	}
	return aStr;
}

void WizardEmpfDlg::SelectDBasList( USHORT nNum )
{
	Sequence<OUString> aDataNames = SwNewDBMgr::GetExistingDatabaseNames();
	long nCount = aDataNames.getLength();
	if( nNum < nCount )
	{
		String aNam( pE_List_DBase->GetEntry( nNum ) );
		String sDBName = aNam;
		aNam += DB_DELIM;
		aNam += pE_List_DBTable->GetSelectEntry();
		if( aNam != aAktDB )
		{
			pE_MEdt_Adress->SetText( aEmptyStr );
			if( pEmpf ) // Datenbank gewechselt? -> EmpfFeld raeumen
				pEmpf->SetStr( aEmptyStr, &pWizDlg->aPrevWin );
			pDBasMgr->GetTableNames(pE_List_DBTable, sDBName);

			aAktDB = aNam;
			pE_List_DBase->SelectEntry(sDBName);
		}

	}

	FillFeldList(pE_List_Fields);
	FillFeldList(pE_List_Telfon,TRUE,TRUE);
	FillFeldList(pE_List_Telfax,TRUE,TRUE);
	FillFeldList(pE_List_AnrFld,TRUE,TRUE);
}

void WizardEmpfDlg::ReadDBasList()
{
	String aOldDBName( pE_List_DBase->GetSelectEntry() );
	String aOldTableName( pE_List_DBTable->GetSelectEntry() );
	USHORT nMerk = pE_List_DBase->GetSelectEntryPos();
	pE_List_DBase->Clear();

	Sequence<OUString> aDataNames = SwNewDBMgr::GetExistingDatabaseNames();
	const OUString* pDataNames = aDataNames.getConstArray();
	long nPos = 0, nCount = aDataNames.getLength();
	for(long i = 0; i < nCount; i++)
		pE_List_DBase->InsertEntry( pDataNames[i] );

	pE_List_DBase->SelectEntry( aOldDBName );
	if( !pE_List_DBase->GetSelectEntryCount() )
	{
		if (nMerk != LISTBOX_ENTRY_NOTFOUND)
			pE_List_DBase->SelectEntryPos( nMerk );
		if( !pE_List_DBase->GetSelectEntryCount() )
		{
			SwDBData aData (pDBasMgr->GetAddressDBName());
			aOldTableName = aData.sCommand;
			pE_List_DBase->SelectEntry(aData.sDataSource);
		}
	}
	pDBasMgr->GetTableNames(pE_List_DBTable, pE_List_DBase->GetSelectEntry());
	pE_List_DBTable->SelectEntry( aOldTableName );
	if (!pE_List_DBTable->GetSelectEntryCount())
		pE_List_DBTable->SelectEntryPos(0);

	SelectDBasList( pE_List_DBase->GetSelectEntryPos( 0 ) );
}

void WizardEmpfDlg::ToUI()
{
	if (pEmpf==NULL)
		return;
	String aStr(pEmpf->GetStr());
	if (aStr.Len()!=0)
		pE_MEdt_Adress->SetText(aStr);
	else
		pEmpf->SetStr(pE_MEdt_Adress->GetText());
	pE_List_DBase->SelectEntry(aAktDB.GetToken(0, DB_DELIM));
}

void WizardEmpfDlg::InitUI()
{
	ReadDBasList();
}

void WizardEmpfDlg::AddAktFeld()
{
	String aStr(pE_MEdt_Adress->GetText());
	String aFld(pE_List_DBase->GetSelectEntry());
	aFld += '.';
	aFld += pE_List_DBTable->GetSelectEntry();
	aFld += '.';
    aFld += pE_List_DBTable->GetEntryData(pE_List_DBTable->GetSelectEntryPos()) == 0 ? '0' : '1';
	aFld += '.';
    aFld += pE_List_Fields->GetSelectEntry();

	short nPos=pE_MEdt_Adress->GetSelection().Min();
	char c;
	if (aFld.Len()>0)
	{
		aFld.Insert('<',0);
		aFld+='>';
		if (aStr.Len()>0)
		{
			if (nPos>0) { // ein Space davor
				c= aStr.GetChar( nPos-1 );
				if (c!='\n' && c!='\r') aFld.Insert(' ',0);
			}
			if (USHORT(nPos)<aStr.Len())
			{
				c=aStr.GetChar( nPos );
				if (c!='\n' && c!='\r') aFld+=' ';
			}
		}
		aStr.Insert(aFld,nPos);
		pE_MEdt_Adress->SetText(aStr);
		if (pEmpf!=NULL)
			pEmpf->SetStr(aStr,&pWizDlg->aPrevWin);
		nPos+=aFld.Len();
		pE_MEdt_Adress->SetSelection(Selection(nPos));
	}
}

void WizardEmpfDlg::AddCR()
{
	String aStr(pE_MEdt_Adress->GetText());
	short nPos=pE_MEdt_Adress->GetSelection().Min();
	aStr.InsertAscii(NEWLINE,nPos);
	nPos += sizeof(NEWLINE);
	pE_MEdt_Adress->SetText(aStr);
	if (pEmpf!=NULL) pEmpf->SetStr(aStr,&pWizDlg->aPrevWin);
	pE_MEdt_Adress->SetSelection(Selection(nPos));
}

IMPL_LINK( WizardEmpfDlg, DBasListHdl, ListBox *, pLst )
{
	SelectDBasList(pE_List_DBase->GetSelectEntryPos());
	return 0;
}

IMPL_LINK( WizardEmpfDlg, EmpfModfHdl, MultiLineEdit *, pEdt )
{
	if( pEmpf )
		pEmpf->SetStr( pEdt->GetText(), &pWizDlg->aPrevWin );
	return 0;
}

IMPL_LINK( WizardEmpfDlg, InsrPBtnHdl, PushButton *, EMPTYARG )
{
	AddAktFeld();
	return 0;
}

IMPL_LINK( WizardEmpfDlg, NewLPBtnHdl, PushButton *, pBtn )
{
	AddCR();
	return 0;
}

IMPL_LINK( WizardEmpfDlg, FeldListHdl, ListBox*, pLst )
{
	AddAktFeld();
	return 0;
}

void WizardEmpfDlg::SetEventHandler()
{
	pE_List_DBase ->SetSelectHdl     (LINK(this,WizardEmpfDlg,DBasListHdl));
	pE_List_DBTable->SetSelectHdl    (LINK(this,WizardEmpfDlg,DBasListHdl));
	pE_MEdt_Adress->SetModifyHdl     (LINK(this,WizardEmpfDlg,EmpfModfHdl));
	pE_SBtn_Insert->SetClickHdl      (LINK(this,WizardEmpfDlg,InsrPBtnHdl));
	pE_BBtn_NewLin->SetClickHdl      (LINK(this,WizardEmpfDlg,NewLPBtnHdl));
	pE_List_Fields->SetDoubleClickHdl(LINK(this,WizardEmpfDlg,FeldListHdl));
}


