/*************************************************************************
 *
 *  $RCSfile: wizfusz.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 16:00:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "swtypes.hxx"
#include "uitool.hxx"
#include "wizfusz.hxx"
#include "wizard.hrc"



WizardFuszDlg::WizardFuszDlg(SwWizardDialog* pDlgWin, BOOL bAbst)
{
	pWizDlg=pDlgWin;
	pFusz=NULL;
	bAbstand=bAbst;
	pF_Text_FusTit = new FixedText (pDlgWin,SW_RES(DLG_Fzl_Text_FusTit));
	pF_CBox_FussAn = new CheckBox  (pDlgWin,SW_RES(DLG_Fzl_CBox_FussAn));
	pF_CBox_TrennL = new CheckBox  (pDlgWin,SW_RES(DLG_Fzl_CBox_TrennL));
	if (bAbstand)
	{
	   pF_Text_VonUnt = new FixedText  (pDlgWin,SW_RES(DLG_Fzl_Text_VonUnt));
	   pF_MFld_VonUnt = new MetricField(pDlgWin,SW_RES(DLG_Fzl_MFld_VonUnt));
	   pF_Text_ZumTxt = new FixedText  (pDlgWin,SW_RES(DLG_Fzl_Text_ZumTxt));
	   pF_MFld_ZumTxt = new MetricField(pDlgWin,SW_RES(DLG_Fzl_MFld_ZumTxt));

	   FieldUnit eMetric = ::GetDfltMetric(FALSE);
	   pF_MFld_VonUnt->SetUnit(eMetric);
	   pF_MFld_ZumTxt->SetUnit(eMetric);
	}
	else
	{
		pF_Text_ZumTxt=NULL;
		pF_MFld_ZumTxt=NULL;
		pF_Text_VonUnt=NULL;
		pF_MFld_VonUnt=NULL;
	}
	pF_MEdt_FusZei=new MultiLineEdit(pDlgWin,SW_RES(DLG_Fzl_MEdt_FusZei));
    pF_FL_FusZei=new FixedLine     (pDlgWin,SW_RES(DLG_Fzl_FL_FusZei));
	SetEventHandler();
}

WizardFuszDlg::~WizardFuszDlg()
{
	delete pF_Text_FusTit;
	delete pF_CBox_FussAn;
	delete pF_CBox_TrennL;

	if (pF_Text_VonUnt!=NULL) delete pF_Text_VonUnt;
	if (pF_MFld_VonUnt!=NULL) delete pF_MFld_VonUnt;
	if (pF_Text_ZumTxt!=NULL) delete pF_Text_ZumTxt;
	if (pF_MFld_ZumTxt!=NULL) delete pF_MFld_ZumTxt;

	delete pF_MEdt_FusZei;
    delete pF_FL_FusZei;
}

void WizardFuszDlg::Fill(MultiOne& WinArr)
{
	WinArr.AddWin(pF_Text_FusTit);
	WinArr.AddWin(pF_CBox_FussAn, TRUE);
	WinArr.AddWin(pF_CBox_TrennL, TRUE);

	if (pF_Text_VonUnt!=NULL) WinArr.AddWin(pF_Text_VonUnt);
	if (pF_MFld_VonUnt!=NULL) WinArr.AddWin(pF_MFld_VonUnt, TRUE);
	if (pF_Text_ZumTxt!=NULL) WinArr.AddWin(pF_Text_ZumTxt);
	if (pF_MFld_ZumTxt!=NULL) WinArr.AddWin(pF_MFld_ZumTxt, TRUE);

	WinArr.AddWin(pF_MEdt_FusZei, TRUE);
    WinArr.AddWin(pF_FL_FusZei,FALSE,TRUE);
}

void WizardFuszDlg::SetPtr(WizardFusz* pFzl)
{
	pFusz=pFzl;
	ToUI();
}

void WizardFuszDlg::SetDisable()
{
	if (pFusz==NULL) return;

	BOOL bEnable = pFusz->IsVisible();
	pF_CBox_TrennL->Enable(bEnable);
	pF_MEdt_FusZei->Enable(bEnable);
	if (bAbstand) {
		pF_Text_VonUnt->Enable(bEnable);
		pF_MFld_VonUnt->Enable(bEnable);
		pF_Text_ZumTxt->Enable(bEnable);
		pF_MFld_ZumTxt->Enable(bEnable);
	}
}

void WizardFuszDlg::ToUI()
{
	if (pFusz==NULL) return;
	pF_CBox_FussAn->Check(pFusz->IsVisible());
	pF_CBox_TrennL->Check(pFusz->IsTrennlinie());
	if (bAbstand) {
		pF_MFld_VonUnt->SetValue(pFusz->GetVer(), FUNIT_CM);
		pF_MFld_ZumTxt->SetValue(pFusz->GetTextDst(), FUNIT_CM);
	}
	pF_MEdt_FusZei->SetText(pFusz->GetStr());
	SetDisable();
}

IMPL_LINK( WizardFuszDlg, ClckHdl, CheckBox *, pBtn )
{
	if (pBtn==pF_CBox_FussAn) {
		pFusz->Show(&pWizDlg->aPrevWin,pF_CBox_FussAn->IsChecked());
		SetDisable();
	}
	if (pBtn==pF_CBox_TrennL) {
		pFusz->SetTrennlinie(pF_CBox_TrennL->IsChecked(),&pWizDlg->aPrevWin);
	}
	return 0;
}

IMPL_LINK_INLINE_START( WizardFuszDlg, MetrHdl, MetricField *, pEdt )
{
	USHORT nVal=USHORT(pEdt->GetValue(FUNIT_CM));
	if (pEdt==pF_MFld_VonUnt) pFusz->SetVer(nVal,&pWizDlg->aPrevWin);
	if (pEdt==pF_MFld_ZumTxt) pFusz->SetTextDst(nVal,&pWizDlg->aPrevWin);
	return 0;
}
IMPL_LINK_INLINE_END( WizardFuszDlg, MetrHdl, MetricField *, pEdt )

IMPL_LINK( WizardFuszDlg, EditHdl, MultiLineEdit *, pEdt )
{
	if (pFusz!=NULL)
		pFusz->SetStr(pEdt->GetText());
	return 0;
}

void WizardFuszDlg::SetEventHandler()
{
	pF_CBox_FussAn->SetClickHdl (LINK(this,WizardFuszDlg,ClckHdl));
	pF_CBox_TrennL->SetClickHdl (LINK(this,WizardFuszDlg,ClckHdl));
	if (pF_MFld_VonUnt!=NULL) pF_MFld_VonUnt->SetModifyHdl(LINK(this,WizardFuszDlg,MetrHdl));
	if (pF_MFld_ZumTxt!=NULL) pF_MFld_ZumTxt->SetModifyHdl(LINK(this,WizardFuszDlg,MetrHdl));
	pF_MEdt_FusZei->SetModifyHdl(LINK(this,WizardFuszDlg,EditHdl));
}



