/*************************************************************************
 *
 *  $RCSfile: wrkdlg.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:15:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#include <stardiv/uno/beans/propset.hxx>
#include <stardiv/one/text/offfield.hxx>
#ifndef __UNO_ONE_OFFSTYLE_HXX__
#include <stardiv/one/offstyle.hxx>
#endif

#define U2S(string) OUStringToString(string, CHARSET_SYSTEM)
#define S2U(string) StringToOUString(string, CHARSET_SYSTEM)

#define MAX_BOXES 80

enum BoxType
{
	BOXTYPE_CHECKBOX,
	BOXTYPE_FIXEDTEXT,
	BOXTYPE_NUMERIC,
	BOXTYPE_DBL_NUMERIC,
	BOXTYPE_FLOAT,
	BOXTYPE_STRING,
	BOXTYPE_ENUM,
	BOXTYPE_DD_LISTBOX,
	BOXTYPE_SECT_LINK,
	BOXTYPE_BUTTON
};
/*-----------------25.02.98 11:42-------------------

--------------------------------------------------*/
class AnyAndBox
{
	BoxType eBox;
	UsrAny aVal;
	FixedText* 		pTxt;
	NumericField*	pField2;
	union
	{
		CheckBox* 		pBox;
		Edit* 			pValueTxt;
		NumericField* 	pField;
		ListBox*		pListBox;
		PushButton* 	pButton;
		Window* 		pWin;
	};

	DECL_LINK(ClickHdl, CheckBox*);
	DECL_LINK(EditHdl, Edit*);

	public:
		AnyAndBox(BoxType eSet, Window* pParent, UsrAny& rVal);
		~AnyAndBox();
	Window* 		GetWin(){return pWin;}
	UsrAny&     	GetAny(){return aVal;}
	const String& 	GetPropName(){return pTxt ? pTxt->GetText() : pBox->GetText();}
	BOOL			HasValueChanged() const;
	void			SetPosSizePixel(Point, Size);
	void 			SetValue(long nVal, long nVal2 = 0)
					{
						if(eBox == BOXTYPE_NUMERIC || eBox == BOXTYPE_DBL_NUMERIC)
						{
							pField->SetValue(nVal);
							pField->SaveValue();
							if(pField2)
							{
								pField2->SetValue(nVal2);
								pField2->SaveValue();
							}
						}
					}

	void			SetValue(double fVal)
					{
						long nVal = (long)(fVal * 1000.);
						pField->SetValue(nVal);
						pField->SaveValue();

					};

	void 			SetText(String rText, String* pValueText = 0)
					{
						if(eBox == BOXTYPE_CHECKBOX)
							pBox->SetText(rText);
						else
							pTxt->SetText(rText);
						if((eBox == BOXTYPE_SECT_LINK || eBox == BOXTYPE_STRING) && pValueText)
						{
							pValueTxt->SetText(*pValueText);
							pValueTxt->SaveValue();
						}
					}
	void			AppendValue(const String& rEntry)
					{
						pListBox->InsertEntry(rEntry);
					}
	void			SetLink(Link& rLink)
					{
						if(eBox == BOXTYPE_BUTTON)
							pButton->SetClickHdl(rLink);
					}

};
/************************************************************************

************************************************************************/


class PropertyDialog : public ModalDialog
{

		OKButton		aOk;
		CancelButton	aCancel;
		long 			nXPos;
		long 			nYPos;
		USHORT 			nNumberingPosition;
		AnyAndBox*      aBoxes[MAX_BOXES];
		XPropertySetRef xPropSet;

			DECL_LINK(OkHdl, PushButton*);
			DECL_LINK(NumberingHdl, PushButton*);
	public:
		PropertyDialog(Window* pParent, XPropertySetRef xProp );
		~PropertyDialog();
		void AddProperty(const String& rName, UsrAny aVal, Property* pProp );
		UsrAny* getAny(unsigned short nIndex);

};

/************************************************************************

************************************************************************/
class NumberingDialog : public ModalDialog
{
	UsrAny&					rVal;
	OKButton				aOk;
	FixedText				aNumTypeFT;
	Edit					aNumTypeED;
	FixedText				aPrefixFT;
	Edit					aPrefixED;
	FixedText				aSuffixFT;
	Edit					aSuffixED;

		DECL_LINK(OkHdl, PushButton*);
	public:
		NumberingDialog(Window* pParent, UsrAny& rAny);
};
/************************************************************************

************************************************************************/
class FieldViewDlg : public ModalDialog
{
	OKButton		aOk;
	ListBox			aFieldTypeIdsLB;
	ListBox			aFieldTypesLB;
	ListBox			aFieldsLB;

	XFieldTypesRef 	xTypes;

	DECL_LINK(FieldIdHdl, ListBox* );
	DECL_LINK(FieldTypeHdl, ListBox* );
	DECL_LINK(FieldHdl, ListBox* );

	public:
		FieldViewDlg(Window* pParent, XFieldTypes* pFieldTypes);


};

/************************************************************************

************************************************************************/

class StyleDialog : public ModalDialog
{
		XStyleFamiliesRef	xStyles;
		OKButton		aOk;
		CancelButton	aCancel;

		FixedText		aCharFT;
		ListBox			aCharLB;
		PushButton 		aCharPB;
		FixedText		aParaFT;
		ListBox			aParaLB;
		PushButton 		aParaPB;
		FixedText		aFrameFT;
		ListBox			aFrameLB;
		PushButton 		aFramePB;
		FixedText		aPageFT;
		ListBox			aPageLB;
		PushButton 		aPagePB;
		FixedText		aNumberFT;
		ListBox			aNumberLB;
		PushButton 		aNumberPB;

			DECL_LINK(OkHdl, PushButton*);
			DECL_LINK(PropertyHdl, PushButton*);
	public:
		StyleDialog(Window* pParent, XStyleFamiliesRef xRef );

};


