#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=..$/..

PRJNAME=sysui
TARGET=kdeint

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

# --- Files --------------------------------------------------------

MIMEDIR = $(MISC)$/kde$/share$/mimelnk$/application

UNIXTEXT = \
	$(MIMEDIR)$/vnd.stardivision.calc.desktop \
	$(MIMEDIR)$/vnd.stardivision.chart.desktop \
	$(MIMEDIR)$/vnd.stardivision.draw.desktop \
	$(MIMEDIR)$/vnd.stardivision.impress.desktop \
	$(MIMEDIR)$/vnd.stardivision.math.desktop \
	$(MIMEDIR)$/vnd.stardivision.writer.desktop \
	$(MIMEDIR)$/vnd.stardivision.writer-global.desktop

MIMEFILES= \
	$(MIMEDIR)$/vnd.sun.xml.calc.desktop \
	$(MIMEDIR)$/vnd.sun.xml.calc.template.desktop \
	$(MIMEDIR)$/vnd.sun.xml.draw.desktop \
	$(MIMEDIR)$/vnd.sun.xml.draw.template.desktop \
	$(MIMEDIR)$/vnd.sun.xml.impress.desktop \
	$(MIMEDIR)$/vnd.sun.xml.impress.template.desktop \
	$(MIMEDIR)$/vnd.sun.xml.writer.desktop \
	$(MIMEDIR)$/vnd.sun.xml.writer.global.desktop \
	$(MIMEDIR)$/vnd.sun.xml.writer.math.desktop \
	$(MIMEDIR)$/vnd.sun.xml.writer.template.desktop

UNIXTEXT+=$(MIMEFILES)
LANGMIMEFLAGFILE = $(MISC)$/kdemime.flag

LAUNCHERDIR = $(MISC)$/kde$/share$/applnk$/OpenOffice.org

LAUNCHERCOMMENTFILES = \
	$(LAUNCHERDIR)$/writer.desktop \
	$(LAUNCHERDIR)$/draw.desktop \
	$(LAUNCHERDIR)$/impress.desktop \
	$(LAUNCHERDIR)$/calc.desktop \
	$(LAUNCHERDIR)$/math.desktop \
	$(LAUNCHERDIR)$/web.desktop


LAUNCHERNAMEFILES = \
	$(LAUNCHERDIR)$/printeradmin.desktop \
	$(LAUNCHERDIR)$/template.desktop


UNIXTEXT+=$(LAUNCHERCOMMENTFILES)
UNIXTEXT+=$(LAUNCHERNAMEFILES)

LANGLAUNCHERCOMMENTFLAGFILE = $(MISC)$/kdeappcomment.flag
LANGLAUNCHERNAMEFLAGFILE = $(MISC)$/kdeappname.flag
DIRECTORYFILEFLAGFILE = $(MISC)/kdeappdir.flag

ZIPFLAGS= -u -r

ZIP1TARGET = kdeicons
ZIP1LIST   = share/icons

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

ALLTAR : MIMETREE LAUNCHERTREE

# ensure unix line ends and attach localization to mime files
MIMETREE: $(MIMEFILES) $(LEGACYMIMEFILES) $(LANGMIMEFLAGFILE)

$(MIMEDIR):
	+@$(MKDIR) -p $(MIMEDIR)

$(LANGMIMEFLAGFILE): $(MIMEFILES) translate.pl makefile.mk ../share/documents.ulf 
	+@$(PERL) translate.pl ../share/documents.ulf $(MIMEDIR)$/vnd.sun.xml. Comment
	+@touch $(LANGMIMEFLAGFILE)

$(UNIXTEXT): $(MIMEDIR) $(LAUNCHERDIR) $(@:f)

# ensure unix line ends and attach localization to launcher files
LAUNCHERTREE: $(LAUNCHERCOMMENTFILES) $(LAUNCHERNAMEFILES) $(LANGLAUNCHERCOMMENTFLAGFILE) $(LANGLAUNCHERNAMEFLAGFILE) $(DIRECTORYFILEFLAGFILE)

$(LAUNCHERDIR):
	+@$(MKDIR) -p $(LAUNCHERDIR)

$(LANGLAUNCHERCOMMENTFLAGFILE): $(LAUNCHERCOMMENTFILES) translate.pl makefile.mk ../share/launcher_comment.ulf 
	+@$(PERL) translate.pl ../share/launcher_comment.ulf $(LAUNCHERDIR)$/ Comment
	+@touch $(LANGLAUNCHERCOMMENTFLAGFILE)

$(LANGLAUNCHERNAMEFLAGFILE): $(LAUNCHERNAMEFILES) translate.pl makefile.mk ../share/launcher_name.ulf 
	+@$(PERL) translate.pl ../share/launcher_name.ulf $(LAUNCHERDIR)$/ Name
	+@touch $(LANGLAUNCHERNAMEFLAGFILE)

$(DIRECTORYFILEFLAGFILE): ooo.directory 
	+@tr -d "\015" < ooo.directory > $(LAUNCHERDIR)$/.directory
	+@touch $(DIRECTORYFILEFLAGFILE)

