/*************************************************************************
 *
 *  $RCSfile: testshl.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 16:38:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#ifndef _SAL_TESTSHL_TLOG_HXX_
#include "tlog.hxx"
#endif

#ifndef _SAL_TESTSHL_TSTMGR_HXX_
#include "tstMgr.hxx"
#endif

#ifndef _RTL_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#include <osl/time.h>

using namespace tstutl;
using namespace osl;

void usage();
void test_shl( vector< sal_Char* >& cmdln );
sal_uInt32 createFlags( vector< sal_Char* >& cmdln );

#if (defined UNX) || (defined OS2)
int main( int argc, char* argv[] )
#else
int _cdecl main( int argc, char* argv[] )
#endif
{
     /* show usage screen if too less parameters */
    if ( argc < 3 )
        usage();

    vector< sal_Char* > cmdln;
    sal_Int32 i;

     /* collect comandline */
    for ( i = 1; i < argc; i++ )
         cmdln.push_back( argv[i] );

    test_shl( cmdln );
	cmdln.clear();
    return 0;
}

/**
 * create testmanager and run test
 */
void test_shl( vector< sal_Char*>& cmdln )
{
    TestManager tst;
    sal_uInt32 cmdflags = createFlags( cmdln );
    sal_Char* ptr = 0;

    if ( tst.initialize( cmdln, cmdflags ) )
        tst.test_EntriesFromFile();
	else {
        sal_Char* msg = "could not find module\n";
        fprintf( stdout, "%s\n", msg );
	}
}

/**
 * create bitmap of comandline parameters
 */
sal_uInt32 createFlags( vector< sal_Char* >& cmdln )
{
    sal_uInt32 retflags = 0;

    vector< sal_Char* >::iterator iter = cmdln.begin();
    while( iter != cmdln.end() )
    {
        fprintf( stderr, "%s\n", *iter );
        if ( *iter[0] == '-' )
        {
            ::rtl::OString item( *iter );
            if ( item == "-boom" )
                retflags |= rtl_tres_Flag_BOOM;

            if ( item == "-verbose" )
                retflags |= rtl_tres_Flag_VERBOSE;

            if ( item == "-skip" )
                retflags |= rtl_tres_Flag_SKIP;

            if ( item == "-log" )
                retflags |= rtl_tres_Flag_LOG;

            if ( item == "-his" )
                retflags |= rtl_tres_Flag_HIS;

            if ( item == "-time" )
                retflags |= rtl_tres_Flag_TIME;

            if ( item == "-msg" )
                retflags |= rtl_tres_Flag_MSG;
        }
        iter++;
    }

	return retflags;
}
/**
 * display usage screen
 */
void usage()
{
    fprintf( stdout,
            "USAGE: testshl shlname scename [-boom][-verbose][-log][-his][-msg]\n" );
    exit(0);
}

