/*************************************************************************
 *
 *  $RCSfile: accessiblemenubasecomponent.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 08:47:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#ifndef _TOOLKIT_AWT_ACCESSIBLEMENUBASECOMPONENT_HXX_
#include <toolkit/awt/accessiblemenubasecomponent.hxx>
#endif

#ifndef _TOOLKIT_AWT_VCLXACCESSIBLEMENU_HXX_
#include <toolkit/awt/vclxaccessiblemenu.hxx>
#endif
#ifndef _TOOLKIT_AWT_VCLXACCESSIBLEMENUITEM_HXX_
#include <toolkit/awt/vclxaccessiblemenuitem.hxx>
#endif
#ifndef _TOOLKIT_AWT_VCLXACCESSIBLEMENUSEPARATOR_HXX_
#include <toolkit/awt/vclxaccessiblemenuseparator.hxx>
#endif

#ifndef _TOOLKIT_HELPER_EXTERNALLOCK_HXX_
#include <toolkit/helper/externallock.hxx>
#endif
#ifndef _TOOLKIT_HELPER_CONVERT_HXX_
#include <toolkit/helper/convert.hxx>
#endif

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif
#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif


using namespace ::com::sun::star;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::accessibility;
using namespace ::comphelper;


// -----------------------------------------------------------------------------
// OAccessibleMenuBaseComponent
// -----------------------------------------------------------------------------

OAccessibleMenuBaseComponent::OAccessibleMenuBaseComponent( Menu* pMenu )
	:AccessibleExtendedComponentHelper_BASE( new VCLExternalSolarLock() )
	,m_pMenu( pMenu )
	,m_bEnabled( sal_False )
	,m_bFocused( sal_False )
	,m_bShowing( sal_False )
	,m_bSelected( sal_False )
	,m_bHighlighted( sal_False )
	,m_bChecked( sal_False )
{
	m_pExternalLock = static_cast< VCLExternalSolarLock* >( getExternalLock() );

	if ( m_pMenu )
	{
		m_aAccessibleChildren.assign( m_pMenu->GetItemCount(), Reference< XAccessible >() );
		m_pMenu->AddEventListener( LINK( this, OAccessibleMenuBaseComponent, MenuEventListener ) );
	}
}

// -----------------------------------------------------------------------------

OAccessibleMenuBaseComponent::~OAccessibleMenuBaseComponent()
{
	if ( m_pMenu )
		m_pMenu->RemoveEventListener( LINK( this, OAccessibleMenuBaseComponent, MenuEventListener ) );

	delete m_pExternalLock;
	m_pExternalLock = NULL;
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsEnabled()
{
	return sal_False;
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsFocused()
{
	return sal_False;
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsShowing()
{
	return sal_False;
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsSelectable()
{
	sal_Bool bSelectable = sal_False;

	Reference< XAccessibleStateSet > xStates = getAccessibleStateSet();
	if ( xStates.is() && xStates->contains( AccessibleStateType::SELECTABLE ) )
		bSelectable = sal_True;

	return bSelectable;
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsSelected()
{
	return sal_False;
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsHighlighted()
{
	return sal_False;
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsChecked()
{
	return sal_False;
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SetStates()
{
	m_bEnabled = IsEnabled();
	m_bFocused = IsFocused();
	m_bShowing = IsShowing();
	m_bSelected = IsSelected();
	m_bHighlighted = IsHighlighted();
	m_bChecked = IsChecked();
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SetEnabled( sal_Bool bEnabled )
{
	if ( m_bEnabled != bEnabled )
	{
		Any aOldValue, aNewValue;
		if ( m_bEnabled )
			aOldValue <<= AccessibleStateType::ENABLED;
		else
			aNewValue <<= AccessibleStateType::ENABLED;
		m_bEnabled = bEnabled;
		NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SetFocused( sal_Bool bFocused )
{
	if ( m_bFocused != bFocused )
	{
		Any aOldValue, aNewValue;
		if ( m_bFocused )
			aOldValue <<= AccessibleStateType::FOCUSED;
		else
			aNewValue <<= AccessibleStateType::FOCUSED;
		m_bFocused = bFocused;
		NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SetShowing( sal_Bool bShowing )
{
	if ( m_bShowing != bShowing )
	{
		Any aOldValue, aNewValue;
		if ( m_bShowing )
			aOldValue <<= AccessibleStateType::SHOWING;
		else
			aNewValue <<= AccessibleStateType::SHOWING;
		m_bShowing = bShowing;
		NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SetSelected( sal_Bool bSelected )
{
	if ( m_bSelected != bSelected )
	{
		Any aOldValue, aNewValue;
		if ( m_bSelected )
		{
			// TODO: remove the preprocessor directive after #104858# is fixed (tbe)
#ifdef WNT
			if ( getenv( "SAL_ACCESSIBILITY_ENABLE_MENU_SELECTED" ) )
			{
#endif
				aOldValue <<= AccessibleStateType::SELECTED;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
#ifdef WNT
			}
#endif
		}
		else
		{
			aNewValue <<= AccessibleStateType::SELECTED;
		    NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
		}
		m_bSelected = bSelected;
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SetHighlighted( sal_Bool bHighlighted )
{
	if ( m_bHighlighted != bHighlighted )
	{
		Any aOldValue, aNewValue;
		if ( m_bHighlighted )
			aOldValue <<= AccessibleStateType::ARMED;
		else
			aNewValue <<= AccessibleStateType::ARMED;
		m_bHighlighted = bHighlighted;
		NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SetChecked( sal_Bool bChecked )
{
	if ( m_bChecked != bChecked )
	{
		Any aOldValue, aNewValue;
		if ( m_bChecked )
			aOldValue <<= AccessibleStateType::CHECKED;
		else
			aNewValue <<= AccessibleStateType::CHECKED;
		m_bChecked = bChecked;
		NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::UpdateEnabled( sal_Int32 i, sal_Bool bEnabled )
{
	if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
	{
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
		if ( xChild.is() )
		{
			OAccessibleMenuBaseComponent* pComp = static_cast< OAccessibleMenuBaseComponent* >( xChild.get() );
			if ( pComp )
				pComp->SetEnabled( bEnabled );
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::UpdateShowing()
{
	for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
	{
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
		if ( xChild.is() )
		{
			OAccessibleMenuBaseComponent* pComp = static_cast< OAccessibleMenuBaseComponent* >( xChild.get() );
			if ( pComp )
				pComp->SetShowing( pComp->IsShowing() );
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::UpdateSelected( sal_Int32 i, sal_Bool bSelected )
{
	NotifyAccessibleEvent( AccessibleEventId::SELECTION_CHANGED, Any(), Any() );

	if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
	{
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
		if ( xChild.is() )
		{
			OAccessibleMenuBaseComponent* pComp = static_cast< OAccessibleMenuBaseComponent* >( xChild.get() );
			if ( pComp )
				pComp->SetSelected( bSelected );
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::UpdateHighlighted( sal_Int32 i, sal_Bool bHighlighted )
{
	if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
	{
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
		if ( xChild.is() )
		{
			OAccessibleMenuBaseComponent* pComp = static_cast< OAccessibleMenuBaseComponent* >( xChild.get() );
			if ( pComp )
				pComp->SetHighlighted( bHighlighted );
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::UpdateChecked( sal_Int32 i, sal_Bool bChecked )
{
	if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
	{
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
		if ( xChild.is() )
		{
			OAccessibleMenuBaseComponent* pComp = static_cast< OAccessibleMenuBaseComponent* >( xChild.get() );
			if ( pComp )
				pComp->SetChecked( bChecked );
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::UpdateAccessibleName( sal_Int32 i )
{
	if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
	{
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
		if ( xChild.is() )
		{
			OAccessibleMenuItemComponent* pComp = static_cast< OAccessibleMenuItemComponent* >( xChild.get() );
			if ( pComp )
				pComp->SetAccessibleName( pComp->GetAccessibleName() );
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::UpdateItemText( sal_Int32 i )
{
	if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
	{
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
		if ( xChild.is() )
		{
			OAccessibleMenuItemComponent* pComp = static_cast< OAccessibleMenuItemComponent* >( xChild.get() );
			if ( pComp )
				pComp->SetItemText( pComp->GetItemText() );
		}
	}
}

// -----------------------------------------------------------------------------

sal_Int32 OAccessibleMenuBaseComponent::GetChildCount()
{
	return m_aAccessibleChildren.size();
}

// -----------------------------------------------------------------------------

Reference< XAccessible > OAccessibleMenuBaseComponent::GetChild( sal_Int32 i )
{
	Reference< XAccessible > xChild = m_aAccessibleChildren[i];
	if ( !xChild.is() )
	{
		if ( m_pMenu )
		{
			// create a new child
			OAccessibleMenuBaseComponent* pChild;

			if ( m_pMenu->GetItemType( (USHORT)i ) == MENUITEM_SEPARATOR )
			{
				pChild = new VCLXAccessibleMenuSeparator( m_pMenu, (sal_uInt16)i );
			}
			else
			{
				PopupMenu* pPopupMenu = m_pMenu->GetPopupMenu( m_pMenu->GetItemId( (USHORT)i ) );
				if ( pPopupMenu )
				{
					pChild = new VCLXAccessibleMenu( m_pMenu, (sal_uInt16)i, pPopupMenu );
					pPopupMenu->SetAccessible( pChild );
				}
				else
				{
					pChild = new VCLXAccessibleMenuItem( m_pMenu, (sal_uInt16)i );
				}
			}

			// set states
			pChild->SetStates();

			xChild = pChild;

			// insert into menu item list
			m_aAccessibleChildren[i] = xChild;
		}
	}

    return xChild;
}

// -----------------------------------------------------------------------------

Reference< XAccessible > OAccessibleMenuBaseComponent::GetChildAt( const awt::Point& rPoint )
{
	Reference< XAccessible > xChild;
	for ( sal_uInt32 i = 0, nCount = getAccessibleChildCount(); i < nCount; ++i )
	{
		Reference< XAccessible > xAcc = getAccessibleChild( i );
		if ( xAcc.is() )
		{			
			Reference< XAccessibleComponent > xComp( xAcc->getAccessibleContext(), UNO_QUERY );				
			if ( xComp.is() )
			{
				Rectangle aRect = VCLRectangle( xComp->getBounds() );
				Point aPos = VCLPoint( rPoint );
				if ( aRect.IsInside( aPos ) )
				{
					xChild = xAcc;
					break;
				}
			}
		}
	}

	return xChild;
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::InsertChild( sal_Int32 i )
{
	if ( i > (sal_Int32)m_aAccessibleChildren.size() )
		i = m_aAccessibleChildren.size();

	if ( i >= 0 )
	{
		// insert entry in child list
		m_aAccessibleChildren.insert( m_aAccessibleChildren.begin() + i, Reference< XAccessible >() );

		// update item position of accessible children
		for ( sal_uInt32 j = i, nCount = m_aAccessibleChildren.size(); j < nCount; ++j )
		{
			Reference< XAccessible > xAcc( m_aAccessibleChildren[j] );
			if ( xAcc.is() )
			{
				OAccessibleMenuItemComponent* pComp = static_cast< OAccessibleMenuItemComponent* >( xAcc.get() );
				if ( pComp )
					pComp->SetItemPos( (sal_uInt16)j );
			}
		}

		// send accessible child event
		Reference< XAccessible > xChild( GetChild( i ) );
		if ( xChild.is() )
		{
			Any aOldValue, aNewValue;
			aNewValue <<= xChild;
			NotifyAccessibleEvent( AccessibleEventId::CHILD, aOldValue, aNewValue );
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::RemoveChild( sal_Int32 i )
{
	if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
	{
		// keep the accessible of the removed item
		Reference< XAccessible > xChild( m_aAccessibleChildren[i] );

		// remove entry in child list
		m_aAccessibleChildren.erase( m_aAccessibleChildren.begin() + i );

		// update item position of accessible children
		for ( sal_uInt32 j = i, nCount = m_aAccessibleChildren.size(); j < nCount; ++j )
		{
			Reference< XAccessible > xAcc( m_aAccessibleChildren[j] );
			if ( xAcc.is() )
			{
				OAccessibleMenuItemComponent* pComp = static_cast< OAccessibleMenuItemComponent* >( xAcc.get() );
				if ( pComp )
					pComp->SetItemPos( (sal_uInt16)j );
			}
		}

		// send accessible child event
		if ( xChild.is() )
		{
			Any aOldValue, aNewValue;
			aOldValue <<= xChild;
			NotifyAccessibleEvent( AccessibleEventId::CHILD, aOldValue, aNewValue );

			Reference< XComponent > xComponent( xChild, UNO_QUERY );
			if ( xComponent.is() )
				xComponent->dispose();
		}
	}
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::SelectChild( sal_Int32 i )
{
	// select the menu
	if ( IsSelectable() && !IsSelected() )
		Select();

	// select the child
	if ( m_pMenu )
		m_pMenu->SelectItem( m_pMenu->GetItemId( (USHORT)i ) );
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::DeSelectAll()
{
	if ( m_pMenu )
		m_pMenu->DeSelect();
}

// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::IsChildSelected( sal_Int32 i )
{
	sal_Bool bSelected = sal_False;

	if ( m_pMenu )
	{
		PopupMenu* pPopupMenu = m_pMenu->GetPopupMenu( m_pMenu->GetItemId( (USHORT)i ) );
		if ( pPopupMenu && pPopupMenu->IsMenuVisible() )
			bSelected = sal_True;
	}

	return bSelected;
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::Select()
{
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::DeSelect()
{
}

// -----------------------------------------------------------------------------

IMPL_LINK( OAccessibleMenuBaseComponent, MenuEventListener, VclSimpleEvent*, pEvent )
{
	DBG_ASSERT( pEvent && pEvent->ISA( VclMenuEvent ), "OAccessibleMenuBaseComponent - Unknown MenuEvent!" );
	if ( pEvent && pEvent->ISA( VclMenuEvent ) )
	{
		DBG_ASSERT( ((VclMenuEvent*)pEvent)->GetMenu(), "OAccessibleMenuBaseComponent - Menu?" );
		ProcessMenuEvent( *(VclMenuEvent*)pEvent );
	}
	return 0;
}

// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::ProcessMenuEvent( const VclMenuEvent& rVclMenuEvent )
{
	sal_uInt16 nItemPos = rVclMenuEvent.GetItemPos();

	switch ( rVclMenuEvent.GetId() )
	{
		case VCLEVENT_MENU_ACTIVATE:
		case VCLEVENT_MENU_DEACTIVATE:
		{
			UpdateShowing();
		}
		break;
		case VCLEVENT_MENU_HIGHLIGHT:
		{
			UpdateHighlighted( nItemPos, sal_True );
		}
		break;
		case VCLEVENT_MENU_DEHIGHLIGHT:
		{
			UpdateHighlighted( nItemPos, sal_False );
		}
		break;
		case VCLEVENT_MENU_SUBMENUACTIVATE:
		{
			UpdateSelected( nItemPos, sal_True );
		}
		break;
		case VCLEVENT_MENU_SUBMENUDEACTIVATE:
		{
			UpdateSelected( nItemPos, sal_False );
		}
		break;
		case VCLEVENT_MENU_ENABLE:
		{
			UpdateEnabled( nItemPos, sal_True );
		}
		break;
		case VCLEVENT_MENU_DISABLE:
		{
			UpdateEnabled( nItemPos, sal_False );
		}
		break;
		case VCLEVENT_MENU_SUBMENUCHANGED:
		{
			RemoveChild( nItemPos );
			InsertChild( nItemPos );
		}
		break;
		case VCLEVENT_MENU_INSERTITEM:
		{
			InsertChild( nItemPos );
		}
		break;
		case VCLEVENT_MENU_REMOVEITEM:
		{
			RemoveChild( nItemPos );
		}
		break;
		case VCLEVENT_MENU_ACCESSIBLENAMECHANGED:
		{
			UpdateAccessibleName( nItemPos );
		}
		break;
		case VCLEVENT_MENU_ITEMTEXTCHANGED:
		{
			UpdateAccessibleName( nItemPos );
			UpdateItemText( nItemPos );
		}
		break;
		case VCLEVENT_MENU_ITEMCHECKED:
		{
			UpdateChecked( nItemPos, sal_True );
		}
		break;
		case VCLEVENT_MENU_ITEMUNCHECKED:
		{
			UpdateChecked( nItemPos, sal_False );
		}
		break;
        case VCLEVENT_OBJECT_DYING:
        {
			if ( m_pMenu )
			{
				m_pMenu->RemoveEventListener( LINK( this, OAccessibleMenuBaseComponent, MenuEventListener ) );

				m_pMenu = NULL;

				// dispose all menu items
				for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
				{
					Reference< XComponent > xComponent( m_aAccessibleChildren[i], UNO_QUERY );
					if ( xComponent.is() )
						xComponent->dispose();
				}
				m_aAccessibleChildren.clear();
			}
        }
        break;
		default:
		{
		}
		break;
	}
}

// -----------------------------------------------------------------------------
// XInterface
// -----------------------------------------------------------------------------

IMPLEMENT_FORWARD_XINTERFACE2( OAccessibleMenuBaseComponent, AccessibleExtendedComponentHelper_BASE, OAccessibleMenuBaseComponent_BASE )

// -----------------------------------------------------------------------------
// XTypeProvider
// -----------------------------------------------------------------------------

IMPLEMENT_FORWARD_XTYPEPROVIDER2( OAccessibleMenuBaseComponent, AccessibleExtendedComponentHelper_BASE, OAccessibleMenuBaseComponent_BASE )

// -----------------------------------------------------------------------------
// XComponent
// -----------------------------------------------------------------------------

void OAccessibleMenuBaseComponent::disposing()
{
	AccessibleExtendedComponentHelper_BASE::disposing();

	if ( m_pMenu )
	{
		m_pMenu->RemoveEventListener( LINK( this, OAccessibleMenuBaseComponent, MenuEventListener ) );

		m_pMenu = NULL;

		// dispose all menu items
		for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
		{
			Reference< XComponent > xComponent( m_aAccessibleChildren[i], UNO_QUERY );
			if ( xComponent.is() )
				xComponent->dispose();
		}
		m_aAccessibleChildren.clear();
	}
}

// -----------------------------------------------------------------------------
// XServiceInfo
// -----------------------------------------------------------------------------

sal_Bool OAccessibleMenuBaseComponent::supportsService( const ::rtl::OUString& rServiceName ) throw (RuntimeException)
{
	Sequence< ::rtl::OUString > aNames( getSupportedServiceNames() );
	const ::rtl::OUString* pNames = aNames.getConstArray();
	const ::rtl::OUString* pEnd = pNames + aNames.getLength();
	for ( ; pNames != pEnd && !pNames->equals( rServiceName ); ++pNames )
		;

	return pNames != pEnd;
}

// -----------------------------------------------------------------------------
// XAccessible
// -----------------------------------------------------------------------------

Reference< XAccessibleContext > OAccessibleMenuBaseComponent::getAccessibleContext(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	return this;
}

// -----------------------------------------------------------------------------
// XAccessibleContext
// -----------------------------------------------------------------------------

Reference< XAccessibleStateSet > OAccessibleMenuBaseComponent::getAccessibleStateSet(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	utl::AccessibleStateSetHelper* pStateSetHelper = new utl::AccessibleStateSetHelper;
	Reference< XAccessibleStateSet > xSet = pStateSetHelper;

	if ( !rBHelper.bDisposed && !rBHelper.bInDispose )
	{
		FillAccessibleStateSet( *pStateSetHelper );
	}
	else
	{
        pStateSetHelper->AddState( AccessibleStateType::DEFUNC );
	}

	return xSet;
}

// -----------------------------------------------------------------------------
