/*************************************************************************
 *
 *  $RCSfile: l2txtenc.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:04:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "solar.h"
#include "l2txtenc.hxx"

#define COMMENT					0
#define ENGLISH_US				1
#define PORTUGUESE				3
#define GERMAN_DE				4
#define RUSSIAN					7
#define GREEK					30
#define DUTCH					31
#define FRENCH					33
#define SPANISH					34
#define FINNISH					35
#define HUNGARIAN				36
#define ITALIAN					39
#define CZECH					42
#define SLOVAK                  43
#define ENGLISH					44
#define DANISH					45
#define SWEDISH					46
#define NORWEGIAN				47
#define POLISH					48
#define GERMAN					49
#define PORTUGUESE_BRAZILIAN	55
#define ESTONIAN                77
#define JAPANESE   				81
#define KOREAN					82
#define CHINESE_SIMPLIFIED		86
#define CHINESE_TRADITIONAL		88
#define TURKISH					90
#define ARABIC					96
#define HEBREW					97
#define CATALAN					37
#define THAI					66
#define HINDI					91
#define EXTERN					99

rtl_TextEncoding Langcode2TextEncoding( USHORT nLang )
{
	switch ( nLang ) {
		case COMMENT: return RTL_TEXTENCODING_MS_1252;
		case ENGLISH_US: return RTL_TEXTENCODING_MS_1252;
		case PORTUGUESE: return RTL_TEXTENCODING_MS_1252;
		case RUSSIAN: return RTL_TEXTENCODING_MS_1251;
		case GREEK: return RTL_TEXTENCODING_MS_1253;
		case DUTCH: return RTL_TEXTENCODING_MS_1252;
		case ESTONIAN: return RTL_TEXTENCODING_UTF8;
		case FRENCH: return RTL_TEXTENCODING_MS_1252;
		case SPANISH: return RTL_TEXTENCODING_MS_1252;
		case FINNISH: return RTL_TEXTENCODING_MS_1252;
		case HUNGARIAN: return RTL_TEXTENCODING_MS_1250;
		case ITALIAN: return RTL_TEXTENCODING_MS_1252;
		case CZECH: return RTL_TEXTENCODING_UTF8;
		case SLOVAK: return RTL_TEXTENCODING_UTF8;
		case ENGLISH: return RTL_TEXTENCODING_MS_1252;
		case DANISH: return RTL_TEXTENCODING_MS_1252;
		case SWEDISH: return RTL_TEXTENCODING_MS_1252;
		case NORWEGIAN: return RTL_TEXTENCODING_MS_1252;
		case POLISH: return RTL_TEXTENCODING_MS_1250;
		case GERMAN: return RTL_TEXTENCODING_MS_1252;
		case PORTUGUESE_BRAZILIAN: return RTL_TEXTENCODING_MS_1252;
		case JAPANESE: return RTL_TEXTENCODING_UTF8;
		case KOREAN: return RTL_TEXTENCODING_UTF8;
		case CHINESE_SIMPLIFIED: return RTL_TEXTENCODING_UTF8;
		case CHINESE_TRADITIONAL: return RTL_TEXTENCODING_UTF8;
		case TURKISH: return RTL_TEXTENCODING_MS_1254;
		case ARABIC: return RTL_TEXTENCODING_MS_1256;
		case HEBREW: return RTL_TEXTENCODING_UTF8;
		case CATALAN: return RTL_TEXTENCODING_MS_1252;
		case THAI: return RTL_TEXTENCODING_UTF8;
		case HINDI: return RTL_TEXTENCODING_UTF8;
		case EXTERN: return RTL_TEXTENCODING_UTF8;
	}
	return RTL_TEXTENCODING_MS_1252;
}
