/*************************************************************************
 *
 *  $RCSfile: fffolder.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <prewin.h>
#include <io.h>
#include "shutil.h"
#include <postwin.h>

#include "ctxmenu.hxx"
#include "shortcut.hxx"

#include <debug.hxx>

#include <fastfsys.hxx>
#include "parser.hxx"
#include "impffsys.hxx"
#include <winshell.hxx>
#include <shellex.h>

#ifndef SFGAO_BROWSABLE
#define SFGAO_BROWSABLE         0x08000000L     // is in-place browsable
#endif // SFGAO_BROWSABLE

// Contextmenu verbs

/*
#define CMI_COMMAND_CREATELINK	0x10
#define CMI_COMMAND_DELETE		0x11
#define CMI_COMMAND_RENAME		0x12
#define CMI_COMMAND_PROPERTIES	0x13
#define CMI_COMMAND_CUT			0x18
#define CMI_COMMAND_COPY		0x19

#define CMI_VERB_OPEN			"open"
#define CMI_VERB_EXPLORE		"explore"
#define CMI_VERB_FIND			"find"
#define CMI_VERB_CREATELINK		MAKEINTRESOURCE( CMI_COMMAND_CREATELINK )
#define CMI_VERB_DELETE			MAKEINTRESOURCE( CMI_COMMAND_DELETE )
#define CMI_VERB_RENAME			MAKEINTRESOURCE( CMI_COMMAND_RENAME )
#define CMI_VERB_PROPERTIES		MAKEINTRESOURCE( CMI_COMMAND_PROPERTIES )
#define CMI_VERB_CUT			MAKEINTRESOURCE( CMI_COMMAND_CUT )
#define CMI_VERB_COPY			MAKEINTRESOURCE( CMI_COMMAND_COPY )
*/

// Bekannte Class-IDs fuer wichtige Ordner

// Hilfs-Klasse fuer Folder-Daten

//--------------------------------------------------------------------------

struct FolderData
{
	IShellFolder	*pShellFolder;
	IShellFolder	*pDrivesFolder;
	IEnumIDList		*pEnumIDList;
	IEnumIDList		*pEnumDrives;
	BOOL			bFoundDesktop;
	IShellIcon		*pShellIcon;
	CItemIDList		aIDList;
	String			aPath;
	Link			aLink;
	BOOL			fIsFileSystem;
	BOOL			fIsValid;
	HANDLE			hCancelWait;
	HANDLE			hNotifyThread;
	HANDLE			hNotifyHandle;
	HWND			hWndNotify;

	FolderData();
	~FolderData();
};


//--------------------------------------------------------------------------

FolderData::FolderData()
{
	pShellFolder = NULL;
	pDrivesFolder = NULL;
	pEnumIDList = NULL;
	pEnumDrives = NULL;
	pShellIcon = NULL;
	fIsValid = FALSE;
	fIsFileSystem = FALSE;
	bFoundDesktop = FALSE;
	hNotifyThread = INVALID_HANDLE_VALUE;
	hCancelWait = INVALID_HANDLE_VALUE;
	hNotifyHandle = INVALID_HANDLE_VALUE;
	hWndNotify = NULL;
}


//--------------------------------------------------------------------------

FolderData::~FolderData()
{
	// Monitor-Thread abbrechen

	if ( hNotifyHandle != INVALID_HANDLE_VALUE )
		SHChangeNotifyDeregister( hNotifyHandle );

	if ( hWndNotify )
		DestroyWindow( hWndNotify );

	if ( hCancelWait != INVALID_HANDLE_VALUE )
	{
		SetEvent( hCancelWait );
		CloseHandle( hCancelWait );
	}

	// Auf Terminierung des Threads warten

	if ( hNotifyThread != INVALID_HANDLE_VALUE  )
	{
		// Maximal 500 ms warten

		DWORD	dwEvent = WaitForSingleObject( hNotifyThread, 500 );

		// Falls der Thread nicht terminiert, wir er eben gekillt

		if ( dwEvent != WAIT_OBJECT_0 )
			TerminateThread( hNotifyThread, (DWORD)-1 );
		CloseHandle( hNotifyThread );
	}

	if ( pShellFolder )
		pShellFolder->Release();
	if ( pDrivesFolder )
		pDrivesFolder->Release();

	if ( pEnumIDList )
		pEnumIDList->Release();
	if ( pEnumDrives )
		pEnumDrives->Release();

	if ( pShellIcon )
		pShellIcon->Release();
}

//--------------------------------------------------------------------------
// Klasse zur Initialisierung von COM
//--------------------------------------------------------------------------

class COMInit
{
public:
	COMInit() { fInit = SUCCEEDED(CoInitialize(NULL)); };
	~COMInit() { if ( fInit ) CoUninitialize(); };
private:
	BOOL	fInit;
};

static COMInit	__COMInit;

//--------------------------------------------------------------------------
// Klasse zur Bestimmung von OS und Shell Version
//--------------------------------------------------------------------------

static DWORD	g_dwOSVersion = GetVersion();
static DWORD	g_dwShellVersion = WIN_GetShellVersion();

//--------------------------------------------------------------------------
//	Static members
//--------------------------------------------------------------------------

static BOOL g_bShowExtensions = FALSE;
Folder	*Folder::pRoot = NULL;

//--------------------------------------------------------------------------

Folder &Folder::GetRootFolder()
{
	if ( !pRoot )
		pRoot = new Folder( ItemIDPath( FOLDER_ROOT), FIND_FLAG_INCLUDE_FOLDER );

	return *pRoot;
}

//--------------------------------------------------------------------------

void Folder::DestroyRoot()
{
	if ( pRoot )
		delete pRoot;
}

//--------------------------------------------------------------------------

BOOL Folder::IsAvailable()
{
	DWORD	dwVersion = GetVersion();
	DWORD	dwMajorVersion =  (DWORD)(LOBYTE(LOWORD(dwVersion)));

	return (BOOL)(dwMajorVersion >= 4);
}

//--------------------------------------------------------------------------

void Folder::ShowExtensions( BOOL bShow )
{
	g_bShowExtensions = bShow;
/*
	DWORD	dwHideFileExt = (DWORD)!bShow;

	// Fuer Win98/NT5 oder Win95/NT4 mit IE4-Shell

	WIN_SHSetValue( 
		HKEY_CURRENT_USER, 
		"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced",
		"HideFileExt",
		REG_DWORD,
		&dwHideFileExt,
		sizeof(DWORD)
		);


	// Fuer Standard Win95/NT

	BYTE	aShellState[0x10];
	DWORD	dwType = REG_BINARY;
	DWORD	dwSize = sizeof(aShellState);

	if ( ERROR_SUCCESS != WIN_SHGetValue( 
		HKEY_CURRENT_USER, 
		"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer",
		"ShellState",
		&dwType,
		aShellState,
		&dwSize
		) || REG_BINARY != dwType )
	{
		// Default-Value erzeugen

		FillMemory( aShellState, sizeof(aShellState), 0 );
		*(LPDWORD)&aShellState[0] = sizeof(aShellState);	// Erstes DWORD gibt die Lnge an
		aShellState[4] = bShow ? 0x02 : 0x00;
	}
	else
	{
		if ( bShow )
			aShellState[4] ^= 0x02;
		else
			aShellState[4] &= ~0x02;
	}

	WIN_SHSetValue( 
		HKEY_CURRENT_USER, 
		"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer",
		"ShellState",
		REG_BINARY,
		aShellState,
		sizeof(aShellState)
		);

	SHChangeNotify( SHCNE_ASSOCCHANGED, SHCNF_IDLIST, 0, 0 );
*/
}

//--------------------------------------------------------------------------
//	Constructors & Destructor
//--------------------------------------------------------------------------

Folder::Folder( const ItemIDPath & path, FindFlags nFindWhat )
{
	FolderData	*pFData = new FolderData();

	if ( pFData )
	{
		pFData->aIDList = path.pData->m_aPath;

		if ( WIN_SHGetFolderFromIDList( pFData->aIDList, &pFData->pShellFolder ) )
		{
			DWORD	grfFlags = 0;

			if ( nFindWhat & FIND_FLAG_INCLUDE_NONFOLDER )
				grfFlags |= SHCONTF_NONFOLDERS;
			if ( nFindWhat & FIND_FLAG_INCLUDE_FOLDER )
				grfFlags |= SHCONTF_FOLDERS;
//			if ( nFindWhat & FIND_FLAG_INCLUDE_HIDDEN )
				grfFlags |= SHCONTF_INCLUDEHIDDEN;

			pFData->pShellFolder->EnumObjects( GetFocus(), grfFlags, &pFData->pEnumIDList );
			pFData->pShellFolder->QueryInterface( IID_IShellIcon, (LPVOID *)&pFData->pShellIcon );

			pFData->aPath = pFData->aIDList.GetFilePath();
			pFData->fIsFileSystem = pFData->aPath.Len() != 0;
			pFData->fIsValid = pFData->pEnumIDList != NULL;

			if ( pFData->aIDList.GetRootID() == CSIDL_ROOT )
			{
				if ( WIN_SHGetSpecialFolder( CSIDL_DRIVES, &pFData->pDrivesFolder ) )
					pFData->pDrivesFolder->EnumObjects( NULL, grfFlags, &pFData->pEnumDrives );
			}

		}
// Hotfix fuer 62179
//		else
//			WIN_SHInvokeCommand( GetFocus(), SHIC_PIDL, (LPCSTR)(LPCITEMIDLIST)pFData->aIDList, CMDSTR_DEFAULT, NULL, NULL, 0 );
	}

	pData = pFData;
}

//--------------------------------------------------------------------------

Folder::~Folder()
{
	FolderData	*pFData = (FolderData *)pData;

	if ( pFData )
		delete pFData;
}

//--------------------------------------------------------------------------
//	Folder::InstallChangeNotifier
//--------------------------------------------------------------------------

static DWORD WINAPI NotificationThread( void *pParam )	 
{

	FolderData	*pFData = (FolderData *)pParam;

	HANDLE hHandles[2];

	hHandles[0] = pFData->hCancelWait;
	hHandles[1] = FindFirstChangeNotification( 
		pFData->aPath, FALSE, 
		FILE_NOTIFY_CHANGE_FILE_NAME | 
		FILE_NOTIFY_CHANGE_DIR_NAME | 
		FILE_NOTIFY_CHANGE_LAST_WRITE );


	BOOL	fCanceled = FALSE;

	do
	{
		DWORD	dwEvent = WaitForMultipleObjects( 2, hHandles, FALSE, INFINITE );
		
		switch ( dwEvent )
		{
		case WAIT_OBJECT_0:
			fCanceled = TRUE;
			break;
		case WAIT_OBJECT_0 + 1:
			// #65398# HRO: Wait a little bit because Windows 9x Services
			// need a undefined time to recognize that something has changed.
			// Let's take 3 seconds
			Sleep( 3000 );
			pFData->aLink.Call( NULL );
			break;
		case WAIT_TIMEOUT:
			fCanceled = TRUE;
			break;
		case WAIT_ABANDONED:
			fCanceled = TRUE;
			break;
		case WAIT_FAILED:
			fCanceled = TRUE;
			break;
		default:
			fCanceled = TRUE;
			break;
		}

	} while ( !fCanceled && FindNextChangeNotification( hHandles[1] ) );

	return FindCloseChangeNotification( hHandles[1] );
}

//--------------------------------------------------------------------------

#define WM_SHELLNOTIFY	(WM_USER + 1 )
static LRESULT CALLBACK NotifyWindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	switch ( uMsg )
	{
	case WM_CREATE:
		{
		LPCREATESTRUCT	lpcs = (LPCREATESTRUCT)lParam;
		SetWindowLong( hWnd, GWL_USERDATA, (LONG)lpcs->lpCreateParams );
		return 0;
		}
	case WM_SHELLNOTIFY:
		{
		FolderData	*pFData = (FolderData *)GetWindowLong( hWnd, GWL_USERDATA );
		pFData->aLink.Call( NULL );
		}
		return 0;
	default:
		return DefWindowProc( hWnd, uMsg, wParam, lParam );
	}
}

class NotifyRegisterWindow
{
public:
	NotifyRegisterWindow();
};

NotifyRegisterWindow::NotifyRegisterWindow()
{
	WNDCLASS	wc;

	ZeroMemory( &wc, sizeof(wc) );
	wc.lpfnWndProc = NotifyWindowProc;
	wc.hInstance = GetModuleHandle(NULL);
	wc.lpszClassName = "SO52_ShellNotifyWnd32";

	ATOM	atom = RegisterClass( &wc );
}

static NotifyRegisterWindow __NotifyRegisterWindow;

Link Folder::InstallChangeNotifier( const Link& rLink )
{
	FolderData	*pFData = (FolderData *)pData;

	Link		aOldLink = pFData->aLink;
	pFData->aLink = rLink;

#if 1
	if ( !pFData->hWndNotify  )
		pFData->hWndNotify = CreateWindow(
			"SO52_ShellNotifyWnd32",
			NULL,
			0,
			0, 0, 0, 0,
			NULL,
			NULL,
			GetModuleHandle(NULL),
			pFData
			);

	if ( pFData->hNotifyHandle == INVALID_HANDLE_VALUE )
	{
		NOTIFYREGISTER	aItem;

		aItem.pidlPath = pFData->aIDList;
		aItem.bWatchSubtree = FALSE;

		pFData->hNotifyHandle = SHChangeNotifyRegister( pFData->hWndNotify, SHCNF_ACCEPT_ALL, 
			SHCNE_ALLEVENTS,
			WM_SHELLNOTIFY,
			1,
			&aItem );
	}

#else
	DWORD	dwThreadID;

	if ( pFData->hNotifyThread == INVALID_HANDLE_VALUE )
		pFData->hNotifyThread = CreateThread( NULL, 0, NotificationThread, pFData, CREATE_SUSPENDED, &dwThreadID );

	if ( pFData->hNotifyThread != INVALID_HANDLE_VALUE )
	{
		pFData->hCancelWait = CreateEvent( NULL, TRUE, FALSE, NULL );
		ResumeThread( pFData->hNotifyThread );
	}
#endif

	return aOldLink;
}

//--------------------------------------------------------------------------
//	Folder::IsValid
//--------------------------------------------------------------------------

BOOL Folder::IsValid() const
{
	FolderData *	pFData = (FolderData *)pData;

	return (BOOL)( NULL != pFData && NULL != pFData->pShellFolder && pFData->fIsValid );
}

//--------------------------------------------------------------------------
//	Folder::RestartEnum
//--------------------------------------------------------------------------

BOOL Folder::RestartEnum( FindFlags nFindWhat )
{
	FolderData *	pFData = (FolderData *)pData;
	BOOL			fSuccess = FALSE;

	if ( pFData )
	{
		if ( pFData->pEnumIDList )
		{
			pFData->pEnumIDList->Release();
			pFData->pEnumIDList = NULL;
		}

		if ( pFData->pEnumDrives )
		{
			pFData->pEnumDrives->Release();
			pFData->pEnumDrives = NULL;
		}

		pFData->bFoundDesktop = FALSE;

		DWORD	grfFlags = 0;

		if ( nFindWhat & FIND_FLAG_INCLUDE_NONFOLDER )
			grfFlags |= SHCONTF_NONFOLDERS;
		if ( nFindWhat & FIND_FLAG_INCLUDE_FOLDER )
			grfFlags |= SHCONTF_FOLDERS;
//		if ( nFindWhat & FIND_FLAG_INCLUDE_HIDDEN )
			grfFlags |= SHCONTF_INCLUDEHIDDEN;

		if ( pFData->pShellFolder )
			pFData->pShellFolder->EnumObjects( GetFocus(), grfFlags, &pFData->pEnumIDList );

		pFData->fIsValid = pFData->pEnumIDList != NULL;

		if ( pFData->pDrivesFolder )
			pFData->pDrivesFolder->EnumObjects( GetFocus(), grfFlags, &pFData->pEnumDrives );

		fSuccess = pFData->pEnumIDList != NULL;
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	Folder::GetNextItem
//--------------------------------------------------------------------------

BOOL Folder::GetNextItem( ItemIDPath & path )
{
	FolderData *	pFData = (FolderData *)pData;
	BOOL			fSuccess = FALSE;

	
	if ( pFData && pFData->pEnumIDList )
	{
		LPITEMIDLIST	pidl;
		BOOL			fFoundItem;
		ULONG			nFetched;

		do
		{
			// PsiWin 2.1 braucht unbedingt das nFetched auch wenn nur ein Item gelesen
			// werden soll. Bug in Psion-DLL !!!

			fFoundItem = (BOOL)(NOERROR == pFData->pEnumIDList->Next( 1, &pidl, &nFetched ));

			if ( fFoundItem && pFData->aIDList.GetRootID() == CSIDL_ROOT )
			{
				LPCLSID	pClsId = (LPCLSID)&pidl->mkid.abID[2];

				if ( memcmp( pClsId, &CLSID_MyComputer, sizeof(GUID) ) == 0 ||
					 memcmp( pClsId, &CLSID_Network, sizeof(GUID) ) == 0 )
					 fSuccess = fFoundItem;
				else
					WIN_SHFree( pidl );
			}

/* MyComputer and Network are included
			else if ( fFoundItem && pFData->aIDList.GetRootID() != CSIDL_ROOT && pFData->aIDList.GetTokenCount() == 0 )
			{
				LPCLSID	pClsId = (LPCLSID)&pidl->mkid.abID[2];

				if ( memcmp( pClsId, &CLSID_MyComputer, sizeof(GUID) ) == 0 ||
					 memcmp( pClsId, &CLSID_Network, sizeof(GUID) ) == 0 )
					WIN_SHFree( pidl );
				else
					 fSuccess = fFoundItem;
			}
*/
			else if ( fFoundItem && pFData->aIDList == CItemIDList(CSIDL_DRIVES) )
			{
				if ( SHITEMKIND(pidl) < SHGII_COMPUTER_REGITEM )
					WIN_SHFree( pidl );
				else
					fSuccess = fFoundItem;
			}
			else
				fSuccess = fFoundItem;

		} while ( fFoundItem && !fSuccess );

		if ( fSuccess )
			path.SetData( pidl, 0 );
		else	// Enumerator loeschen
		{
			pFData->pEnumIDList->Release();
			pFData->pEnumIDList = NULL;
		}
	}

// Laufwerke holen

	if ( !fSuccess && pFData && pFData->pEnumDrives )
	{
		LPITEMIDLIST	pidl;
		BOOL			fFoundItem;
		ULONG			nFetched;

		do
		{
			fFoundItem = (BOOL)(NOERROR == pFData->pEnumDrives->Next( 1, &pidl, &nFetched ));

			if ( fFoundItem && SHITEMKIND(pidl) < SHGII_COMPUTER_REGITEM )
				fSuccess = fFoundItem;
			else
				WIN_SHFree( pidl );

		} while ( fFoundItem && !fSuccess );

		if ( fSuccess )
		{
			path.pData->m_aPath = CItemIDList( CSIDL_DRIVES ) + CItemIDList( pidl );
			WIN_SHFree( pidl );
		}
		else if ( !pFData->bFoundDesktop )
		{
			path.pData->m_aPath = CItemIDList( CSIDL_DESKTOP );
			path.pData->m_bIsDesktop = TRUE;
			pFData->bFoundDesktop = TRUE;
			fSuccess = TRUE;
		}
	}

	return fSuccess;
}


//--------------------------------------------------------------------------
//	Folder::GetItemInfo
//--------------------------------------------------------------------------

BOOL Folder::GetItemIDInfo( const ItemIDPath & path, FastItemInfo & info )
{
	FolderData *	pFData = (FolderData *)pData;
	BOOL			fSuccess = FALSE;
	STRRET			str;

	if ( pFData && pFData->pShellFolder )
	{
		int nTokenCount = path.GetTokenCount();

		if ( nTokenCount > 1 )
			nTokenCount = nTokenCount + 1;

		LPCITEMIDLIST	pidl = path.pData->m_aPath;

		// Only use SFGAO_LINK, because SFGAO_DISPLAYATTRMASK contains SFGAO_READONLY which
		// will force floppy access.

		ULONG	dwAttributes =	SFGAO_CAPABILITYMASK	| 
								SFGAO_CONTENTSMASK		|
								SFGAO_LINK				|
								SFGAO_FOLDER			|
								SFGAO_FILESYSTEM		|
								0;

		if ( NOERROR == pFData->pShellFolder->GetAttributesOf( 1, &pidl, &dwAttributes ) )
		{
			// Attribute setzen

			info.aAttributes = 0;

			if ( dwAttributes & SFGAO_CANCOPY )
				info.aAttributes |= ITEM_FLAG_COPYABLE;
			if ( dwAttributes & SFGAO_CANDELETE )
				info.aAttributes |= ITEM_FLAG_DISCARDABLE;
			if ( dwAttributes & SFGAO_CANMOVE )
				info.aAttributes |= ITEM_FLAG_MOVABLE;
			if ( dwAttributes & SFGAO_CANLINK )
				info.aAttributes |= ITEM_FLAG_LINKABLE;
			if ( dwAttributes & SFGAO_CANRENAME )
				info.aAttributes |= ITEM_FLAG_RENAMABLE;

			if ( dwAttributes & SFGAO_FILESYSTEM)
				info.aAttributes |= ITEM_FLAG_ISFILESYSTEM;

			if ( dwAttributes & SFGAO_LINK )
				info.aAttributes |= ITEM_FLAG_ISLINK;

			if ( (dwAttributes & SFGAO_FOLDER ) /*&& (dwAttributes & SFGAO_BROWSABLE)*/ )
			{
				info.aAttributes |= ITEM_FLAG_ISFOLDER | ITEM_FLAG_HASITEMS;
				if ( dwAttributes & SFGAO_HASSUBFOLDER )
					info.aAttributes |= ITEM_FLAG_HASSUBFOLDERS;
			}

			// #64611# Mark Desktop as unrenamable

			if ( pidl->mkid.cb == 0 )
				info.aAttributes &= ~ITEM_FLAG_RENAMABLE;

			CHAR	szDisplayName[MAX_PATH] = "";

			// Namen holen


			// Extensions abschneiden

			if ( (dwAttributes & SFGAO_FILESYSTEM) && !(dwAttributes & SFGAO_FOLDER) && !(dwAttributes & SFGAO_LINK) )
			{
				pFData->pShellFolder->GetDisplayNameOf( pidl, SHGDN_INFOLDER | SHGDN_FORPARSING | SHGDN_INCLUDE_NONFILESYS, &str );
				WIN_SHStrRetToMultiByte( pidl, &str, szDisplayName, MAX_PATH );

				LPSTR	pExtension = strrchr( szDisplayName, '.' );

				// Extension nur abschneiden, wenn der Name nicht mit Punkt beginnt und keine weitere
				// extension folgt.

				if ( pExtension && pExtension != &szDisplayName[0] )
				{
					// URL und LNK werden hardcoded als Links behandelt, um evtl. Probleme mit kaputter Registry zu umgehen

					if ( !stricmp( pExtension, ".url" ) ||
						 !strcmp( pExtension, ".lnk" ) )
						 info.aAttributes |= ITEM_FLAG_ISLINK;

					// Bei Links wir die Extension immer abgeschnitten

					if ( !g_bShowExtensions || (info.aAttributes & ITEM_FLAG_ISLINK) )
							*pExtension = '\0';
				}
			}
			else
			{
				pFData->pShellFolder->GetDisplayNameOf( pidl, SHGDN_INFOLDER, &str );
				WIN_SHStrRetToMultiByte( pidl, &str, szDisplayName, MAX_PATH );
			}

			info.aDisplayName = szDisplayName;


			// Item Kind setzen

			if ( pFData->fIsFileSystem || pFData->aIDList.GetTokenCount() <= 1 )
			{
				switch ( pidl->mkid.abID[0] & SHGII_CONTAINER_MASK )
				{
				case SHGII_COMPUTER:
					if ( pidl->mkid.abID[0] < SHGII_COMPUTER_REGITEM )
						info.aItemKind = ITEM_KIND_VOLUME;
					else
						info.aItemKind = ITEM_KIND_NAMESPACE;
					break;
				case SHGII_ROOT:
					info.aItemKind = ITEM_KIND_NAMESPACE;
					break;
				case SHGII_NETWORK:
					info.aItemKind = ITEM_KIND_NETWORK;

					// Wenn es ein Netzwerkdrucker ist, dann Folder-flags abschalten

					if ( pidl->mkid.abID[1] == 0x02 )
						info.aAttributes &= ~(ITEM_FLAG_ISFOLDER | ITEM_FLAG_HASITEMS);
					else if ( SHITEMKIND(pidl) == SHGII_NETWORK_DIRECTORY )
						info.aItemKind = ITEM_KIND_FILESYSTEM;
					break;
				case SHGII_FILESYSTEM:
					if ( dwAttributes & SFGAO_FILESYSTEM )
						info.aItemKind = ITEM_KIND_FILESYSTEM;
					else
						info.aItemKind = ITEM_KIND_OTHER;
					break;
				default:
					info.aItemKind = ITEM_KIND_OTHER;
					break;
				}
			}
			else if ( dwAttributes & SFGAO_FILESYSTEM )
				info.aItemKind = ITEM_KIND_FILESYSTEM;
			else
				info.aItemKind = ITEM_KIND_OTHER;


			// Jetzt Icon-Location ermitteln

			BOOL	fFoundIcon = FALSE;

  			// 1. Versuch ueber IExtractIcon

			if ( !fFoundIcon ) 
			{
				HRESULT			hResult;
				UINT			rgfInOut = 0;
				IExtractIcon *	pExtractIcon;
				
				hResult = pFData->pShellFolder->GetUIObjectOf( 
					NULL, 1, &pidl, IID_IExtractIcon, &rgfInOut,
					(LPVOID *)&pExtractIcon );

				if ( hResult == NOERROR )
				{
					UINT	uFlags = 0;
					int		nIndex = 0;
					CHAR	szIconPath[MAX_PATH + 32] = ">";

					hResult = pExtractIcon->GetIconLocation( GIL_FORSHELL, &szIconPath[1], MAX_PATH, &nIndex, &uFlags );

					nIndex = (short)(nIndex & 0xFFFF);
					if ( hResult == NOERROR )
					{
						if ( nIndex == -1 )
							nIndex = 0;

						if ( !strcmp( &szIconPath[1], "*" ) )
						{
							wsprintf( szIconPath, "#%d", nIndex );
							info.aIconLocation = szIconPath;
							fFoundIcon = TRUE;
						}
						else if ( uFlags & GIL_NOTFILENAME )
							fFoundIcon = FALSE;
						else
						{
							LPCSTR	pszLastToken = strrchr( &szIconPath[1], '\\' );

							if ( pszLastToken )
								pszLastToken++;
							else
								pszLastToken = &szIconPath[1];

							if ( !(g_dwOSVersion & 0x8000000) && HIWORD(g_dwShellVersion) < 71 )
							{
								if ( !strcmpi( pszLastToken, "SHELL32.DLL" ) && 42 == nIndex )
									nIndex = 73;
							}

//	#63769# Da wir eh keine aufgeklappten Icons mehr anzeigen, ist es so schneller und schoener !!!
//							if ( !strcmpi( pszLastToken, "SHELL32.DLL" ) && 3 == nIndex )
//								info.aIconLocation = "";
//							else
							{
								wsprintf( &szIconPath[strlen(szIconPath)], ",%d", nIndex );
								info.aIconLocation = szIconPath;
							}
							fFoundIcon = TRUE;
						}
					}

					pExtractIcon->Release();
				}
			}

			// 2. Versuch ueber IShellIcon

//
//  			if ( !fFoundIcon && pFData->pShellIcon )
//			{
//				CHAR	szIndex[32];
//				int		nIconIndex = 0;
//
//				if ( NOERROR == pFData->pShellIcon->GetIconOf( pidl, GIL_FORSHELL, &nIconIndex ) )
//				{
//					wsprintf( szIndex, "#%d", nIconIndex );
//					info.aIconLocation = szIndex;
//					fFoundIcon = TRUE;
//				}
//			}
//
			// Setzen wir die Location halt so !

			if ( !fFoundIcon )
			{
				CItemIDList		aFullIDList = pFData->aIDList + path.pData->m_aPath;

				info.aIconLocation = "::";
				info.aIconLocation += CreateStringFromData( (LPCITEMIDLIST)aFullIDList, WIN_SHGetIDListSize( aFullIDList ) );
				fFoundIcon = TRUE;
			}

			// Internet Explorer, MyComputer und Network nicht als Ordner verkaufen

			if ( pFData->aIDList.GetRootID() != CSIDL_ROOT && SHITEMKIND(pidl) == SHGII_ROOT_REGITEM )
			{
				LPCLSID	pClsId = (LPCLSID)&pidl->mkid.abID[2];

				if ( memcmp( pClsId, &CLSID_IE4, sizeof(GUID) ) == 0 ||
					 memcmp( pClsId, &CLSID_MyComputer, sizeof(GUID) ) == 0 ||
					 memcmp( pClsId, &CLSID_Network, sizeof(GUID) ) == 0 )
					info.aAttributes &= ~( ITEM_FLAG_ISFOLDER | ITEM_FLAG_HASSUBFOLDERS | ITEM_FLAG_HASITEMS );
			}

			// In der Root den Arbeitsplatz als System verkaufen

			if ( pFData->aIDList.GetRootID() == CSIDL_ROOT && SHITEMKIND(pidl) == SHGII_ROOT_REGITEM )
			{
				CItemIDList aIDList( pidl );

				if ( aIDList.GetTokenCount() > 1 )
					info.aItemKind = ITEM_KIND_VOLUME;
				else
				{
					LPCLSID	pClsId = (LPCLSID)&pidl->mkid.abID[2];

					if (  memcmp( pClsId, &CLSID_MyComputer, sizeof(GUID) ) == 0 )
					{
						info.aDisplayName = "System";
						info.aIconLocation = ">SHELL32.DLL,21";
					}
				}
			}

			fSuccess = TRUE;

			// HRO: Der Hack des Jahres
			// Sollte es sich um eines dieser besonderen Spezialordner handeln, die sich zwar als Ordner verkaufen
			// aber die niemals Kinnder haben, so scheint allen gemeinsam zu sein, dass die PIDL als erstes Byte nach
			// der Laengenangabe 0xB1 enthaelt. (SHGII_ANCESTOR | SHGII_FILESYSTEM_FILE)

			if ( info.aItemKind == ITEM_KIND_NAMESPACE || info.aItemKind == ITEM_KIND_OTHER )
			{
				if ( pidl->mkid.abID[0] == (SHGII_ANCESTOR | SHGII_FILESYSTEM_FILE) && (dwAttributes & SFGAO_FOLDER) != 0 )
						info.aAttributes &= ~(ITEM_FLAG_ISFOLDER  | ITEM_FLAG_HASITEMS | ITEM_FLAG_HASSUBFOLDERS);
			}


		}
	}


	return fSuccess;
}

//--------------------------------------------------------------------------
//	Folder::GetFileInfo
//--------------------------------------------------------------------------

static BOOL FileTimeValid( const FILETIME *pft )
{
	return (BOOL)(pft->dwLowDateTime || pft->dwHighDateTime);
}

static void SetDateTime( DateTime &dt, const FILETIME *pftUTC )
{
	SYSTEMTIME	st;
	FILETIME	ftLocal;

	FileTimeToLocalFileTime( pftUTC, &ftLocal );
	FileTimeToSystemTime( &ftLocal, &st );

	dt.SetHour( st.wHour );
	dt.SetMin( st.wMinute );
	dt.SetSec( st.wSecond );
	dt.Set100Sec( st.wMilliseconds / 10 );

	dt.SetYear( st.wYear );
	dt.SetMonth( st.wMonth );
	dt.SetDay( st.wDay );
}

static void SetFileInfo( FastFileInfo &info, const WIN32_FIND_DATA *pfd )
{
	info.aFileName = pfd->cFileName;
	info.aAlternateName = pfd->cAlternateFileName;
	info.aFileSize = pfd->nFileSizeLow;
	info.aFileSizeHigh = pfd->nFileSizeHigh;

	
	SetDateTime( info.aLastWriteTime, &pfd->ftLastWriteTime );

	if ( FileTimeValid( &pfd->ftLastAccessTime ) )
		SetDateTime( info.aLastAccessTime, &pfd->ftLastAccessTime );
	else 
		info.aLastAccessTime = info.aLastWriteTime;

	if ( FileTimeValid( &pfd->ftCreationTime ) )
		SetDateTime( info.aCreationTime, &pfd->ftCreationTime );
	else 
		info.aCreationTime = info.aLastWriteTime;

	info.aAttributes = 0;
	if ( pfd->dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE )
		info.aAttributes |= FILE_FLAG_ARCHIVE;
	if ( pfd->dwFileAttributes & FILE_ATTRIBUTE_READONLY )
		info.aAttributes |= FILE_FLAG_READONLY;
	if ( pfd->dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED )
		info.aAttributes |= FILE_FLAG_COMPRESSED;
	if ( pfd->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
		info.aAttributes |= FILE_FLAG_DIRECTORY;
	if ( pfd->dwFileAttributes & FILE_ATTRIBUTE_SYSTEM )
		info.aAttributes |= FILE_FLAG_SYSTEM;
	if ( pfd->dwFileAttributes & FILE_ATTRIBUTE_HIDDEN )
		info.aAttributes |= FILE_FLAG_HIDDEN;

	if ( info.aAttributes & FILE_FLAG_DIRECTORY )
		info.aFileKind = FILE_KIND_DIRECTORY;
	else
		info.aFileKind = FILE_KIND_FILE;

	// Executable Flag aufgrund der Extension setzen

	char *pszPoint = strrchr( pfd->cFileName, '.' );

	if ( pszPoint && (
		strcmpi(pszPoint, ".exe") == 0 || 
		strcmpi(pszPoint, ".scr") == 0 ||
		strcmpi(pszPoint, ".com") == 0 ) )
	{
		info.aAttributes |= FILE_FLAG_EXECUTABLE;
	}

}

//--------------------------------------------------------------------------

BOOL Folder::GetFileInfo( const ItemIDPath & path, FastFileInfo & info )
{
	BOOL			fSuccess	= FALSE;
	WIN32_FIND_DATA	fd;
	FolderData *	pFData = (FolderData *)pData;

	if ( pFData && pFData->pShellFolder )
	{
		int nTokenCount = path.GetTokenCount();

		if ( nTokenCount > 1 )
			nTokenCount++;

		LPCITEMIDLIST	pidl = path.pData->m_aPath;

		CHAR	szPath[MAX_PATH];
		CItemIDList	aIDList = pFData->aIDList + path.pData->m_aPath;

		// Prefer Findfirstfile

		if ( WIN_SHGetPathFromIDList( aIDList, szPath ) )
		{
			HANDLE	hFindFile = FindFirstFile( szPath, &fd );

			if ( hFindFile != INVALID_HANDLE_VALUE )
			{
				FindClose( hFindFile );
				SetFileInfo( info, &fd );
				fSuccess = TRUE;
			}
		}

		// WIN_SHGetDataFromIDList does not always set the file times

		if ( !fSuccess && NOERROR == WIN_SHGetDataFromIDList( pFData->pShellFolder, pidl, SHGDFIL_FINDDATA, &fd, sizeof(fd) ) )
		{
			SetFileInfo( info, &fd );
			fSuccess = TRUE;
		}

		if ( !fSuccess )
		{
			STRRET	str;

			HRESULT	hResult = pFData->pShellFolder->GetDisplayNameOf( pidl, SHGDN_FORPARSING | SHGDN_INCLUDE_NONFILESYS, &str );

			// Namen holen

			if ( SUCCEEDED(hResult) )
			{
				CHAR	szDisplayName[MAX_PATH] = "";
				LPCSTR	pszLastBkSlash = NULL;

				WIN_SHStrRetToMultiByte( pidl, &str, szDisplayName, MAX_PATH );

				pszLastBkSlash = strrchr( szDisplayName, '\\' );

				if ( !pszLastBkSlash )
					pszLastBkSlash = szDisplayName;
				else
					pszLastBkSlash++;

				if ( *pszLastBkSlash )
				{
					info.aFileName = pszLastBkSlash;
					info.aAlternateName = "";
					info.aFileSize = 0;
					info.aFileSizeHigh = 0;
					info.aAttributes = 0;
					info.aFileKind = FILE_KIND_DIRECTORY;
					fSuccess = TRUE;
				}
			}
		}
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	Folder::GetVolumeInfo
//--------------------------------------------------------------------------

BOOL Folder::GetVolumeInfo( const ItemIDPath & path, VolumeInfo & info )
{
	FolderData *	pFData = (FolderData *)pData;

	int nTokenCount = path.GetTokenCount();
	ItemIDPath		token( path[nTokenCount - 1] );
	LPCITEMIDLIST	pidl = token.pData->m_aPath;

	if ( nTokenCount > 1 )
	{
		LPITEMIDLIST	pidlFolder, pidlItem;

		if ( WIN_SHSplitIDList( path.pData->m_aPath, &pidlFolder, &pidlItem ) )
		{
			ItemIDPath	itemPath(pidlItem, 0);
			ItemIDPath	folderPath(pidlFolder, 0);
			Folder		folder(folderPath);

			return	folder.GetVolumeInfo( itemPath, info );
		}
		else
			return FALSE;
	}

	if ( pidl )
	{
		if ( SHITEMCONTAINER(pidl) == SHGII_COMPUTER && SHITEMKIND(pidl) < SHGII_COMPUTER_REGITEM )
		{
			CHAR	szVolumeName[MAX_PATH];
			CHAR	szFileSystemName[MAX_PATH];
			DWORD	dwSerialNumber, dwMaxComponentLength, dwFileSystemFlags;

			BOOL bOK = FALSE;

			if ( SHITEMKIND(pidl) != SHGII_COMPUTER_FLOPPY525 &&
				 SHITEMKIND(pidl) != SHGII_COMPUTER_FLOPPY35 )
			{
				bOK = GetVolumeInformation( (LPCSTR)&pidl->mkid.abID[1],
					szVolumeName, MAX_PATH,
					&dwSerialNumber,
					&dwMaxComponentLength,
					&dwFileSystemFlags,
					szFileSystemName, MAX_PATH );

			}
			
			if ( bOK ) 
			{
				info.aVolumeName = szVolumeName;
				info.nMaxFileNameLength = dwMaxComponentLength;
				info.nMaxFilePathLength = dwMaxComponentLength;
				info.aFileSystemName = szFileSystemName;
			}
			else
			{
				info.aVolumeName = "";
				info.nMaxFileNameLength = MAX_PATH;
				info.nMaxFilePathLength = MAX_PATH;
				info.aFileSystemName = "";
			}

			info.aMappingName = (LPCSTR)&pidl->mkid.abID[1];
			info.aDeviceName = (LPCSTR)&pidl->mkid.abID[1];

			switch ( SHITEMKIND(pidl) )
			{
			case SHGII_COMPUTER_FLOPPY525:
				info.aVolumeKind = VOLUME_KIND_FLOPPY_525;
				break;
			case SHGII_COMPUTER_FLOPPY35:
				info.aVolumeKind = VOLUME_KIND_FLOPPY_35;
				break;
			case SHGII_COMPUTER_FIXED:
				info.aVolumeKind = VOLUME_KIND_FIXED;
				break;
			case SHGII_COMPUTER_RAMDISK:
				info.aVolumeKind = VOLUME_KIND_RAM;
				break;
			case SHGII_COMPUTER_REMOTE:
			case SHGII_COMPUTER_NETWORK:
				{
					DWORD	nLength = MAX_PATH;
					CHAR	szDevice[3];

					wsprintf( szDevice, "%c:", pidl->mkid.abID[1] );
					WNetGetConnection( szDevice, szVolumeName, &nLength );
					info.aMappingName = szVolumeName;
				}
				info.aVolumeKind = VOLUME_KIND_REMOTE;
				break;
			case SHGII_COMPUTER_REMOVABLE:
				info.aVolumeKind = VOLUME_KIND_REMOVABLE;
				break;
			case SHGII_COMPUTER_CDROM:
				info.aVolumeKind = VOLUME_KIND_CDROM;
				break;
			default:
				info.aVolumeKind = VOLUME_KIND_OTHER;
				break;
			}

			return TRUE;
		}
	}

	return FALSE;
}


//--------------------------------------------------------------------------
//	Folder::GetNetworkInfo
//--------------------------------------------------------------------------

BOOL Folder::GetNetworkInfo( const ItemIDPath & path, NetworkInfo & info )
{
	return FALSE;
}


//--------------------------------------------------------------------------
//	Folder::GetNameSpaceInfo
//--------------------------------------------------------------------------

BOOL Folder::GetNameSpaceInfo( const ItemIDPath & path, NameSpaceInfo & info )
{
	return FALSE;
}

//--------------------------------------------------------------------------
//	Folder::GetLinkFileInfo
//--------------------------------------------------------------------------

BOOL Folder::GetLinkFileInfo( const ItemIDPath & path, LinkFileInfo & info )
{
	BOOL			fSuccess = FALSE;
	HRESULT			hResult;
	IShellLink *	pShellLink;

	// Zeiger auf die Implementierung des IShellLink-Interface holen
	hResult = CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (LPVOID *)&pShellLink);

	if (SUCCEEDED(hResult))
	{
		IPersistFile* pPersistFile;

		// Zeiger auf die Implementierung des IPersistFile des Link-Interface holen
		hResult = pShellLink->QueryInterface(IID_IPersistFile, (LPVOID *)&pPersistFile);

		if (SUCCEEDED(hResult))
		{
			WCHAR			wszFileName[MAX_PATH];
			CHAR			szFileName[MAX_PATH];
			ItemIDPath		token = path[path.GetTokenCount() - 1];
			ItemIDPath		full = GetItemIDPath() + token;
			LPCITEMIDLIST	pidl = full.pData->m_aPath;
			

			SHGetPathFromIDList( pidl, szFileName );

			// Dateinamen in UNIcode-String umwandeln
			MultiByteToWideChar(CP_ACP, 0, szFileName, -1, wszFileName, MAX_PATH);

			// Jetzt die Link-Datei zum Lesen oeffnen
			hResult = pPersistFile->Load(wszFileName, STGM_READ);

			if (SUCCEEDED(hResult))
			{
				 // Das Resolven des Link lassen wir weg.
				// hResult = pShellLink->Resolve((HWND)NULL, SLR_ANY_MATCH);

				fSuccess = TRUE;

				WIN32_FIND_DATA	fd;
				CHAR			szTargetPath[MAX_PATH];
				CHAR			szIconLocation[MAX_PATH];

				// Jetzt kann an dem IShellLink Interface abgefragt werden
				// Das Target abfragen

				hResult = pShellLink->GetPath(szTargetPath, MAX_PATH, &fd, SLGP_UNCPRIORITY );

				if ( SUCCEEDED(hResult) )
				{
					if ( szTargetPath[0] )
					{
						info.aTargetPath.pData->m_aPath = CItemIDList( szTargetPath );
						info.aTargetURL = GetURLFromHostNotation( szTargetPath );

//						WIN32_FIND_DATA	fd;
//						HANDLE			hFind;
//
//						hFind = FindFirstFile( szTargetPath, &fd );
//						if ( hFind != INVALID_HANDLE_VALUE )
//						{
//							if ( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
//								info.aTargetURL += String( "/" );
//						}
					}
					else
					{
						info.aTargetURL = "";

						LPITEMIDLIST	pidl;

						hResult = pShellLink->GetIDList( &pidl );

						if ( SUCCEEDED(hResult) )
						{
							info.aTargetPath.pData->m_aPath = CItemIDList( pidl );
							info.aTargetURL = "file:///";
							info.aTargetURL += info.aTargetPath.GetBinaryDescription();
							WIN_SHFree( pidl );
						}
					}
				}


				int	iIcon = 0;

				hResult = pShellLink->GetIconLocation( szIconLocation, MAX_PATH, &iIcon );

				if ( SUCCEEDED(hResult) )
				{
					CHAR	szBuffer[MAX_PATH + 10] = "";

					if ( *szIconLocation )
					{
						if ( !(g_dwOSVersion & 0x80000000) && HIWORD(g_dwShellVersion) < 71 )
						{
							LPCSTR	pszLastToken = strrchr( szIconLocation, '\\' );

							if ( pszLastToken )
								pszLastToken++;
							else
								pszLastToken = szIconLocation;
						
							if ( !strcmpi( pszLastToken, "SHELL32.DLL" ) && 42 == iIcon )
								iIcon = 73;
						}

						wsprintf( szBuffer, ">%s,%d", szIconLocation, iIcon );
					}
					else // Wenn keine Icon-Location gesetzt, dann auf Fallback Target
					{
						SHFILEINFO	sfi;

						if ( SHGetFileInfo( szTargetPath, 0, &sfi, sizeof(SHFILEINFO), SHGFI_ICONLOCATION ) && sfi.szDisplayName[0] )
						{
							if ( !(g_dwOSVersion & 0x80000000) && HIWORD(g_dwShellVersion) < 71 )
							{
								LPCSTR	pszLastToken = strrchr( sfi.szDisplayName, '\\' );

								if ( pszLastToken )
									pszLastToken++;
								else
									pszLastToken = szIconLocation;

								if ( !strcmpi( pszLastToken, "SHELL32.DLL" ) && 42 == sfi.iIcon )
									sfi.iIcon = 73;
							}

							wsprintf( szBuffer, ">%s,%d", sfi.szDisplayName, sfi.iIcon );
						}
						else
							wsprintf( szBuffer, "%s", szTargetPath );
					}

					info.aIconLocation = szBuffer;
				}
				else
					info.aIconLocation = "";
			}

		// IPersistFile Interface freigeben
		pPersistFile->Release();
		}

	// IShellLinkInterface freigeben

	pShellLink->Release();
	}

	if ( !fSuccess )
	{
		info.aIconLocation = "";
		info.aTargetURL = "";
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	Folder::GetItemIDPath
//--------------------------------------------------------------------------

ItemIDPath Folder::GetItemIDPath() const
{
	ItemIDPath	path;
	
	FolderData *	pFData = (FolderData *)pData;

	if ( pFData )
		path.pData->m_aPath = pFData->aIDList;

	return path;
}

//--------------------------------------------------------------------------
//	Folder::IsCaseSensitive
//--------------------------------------------------------------------------

BOOL Folder::IsCaseSensitive() const
{
	return FALSE;
}

//--------------------------------------------------------------------------
//	Folder::GetContextMenu
//--------------------------------------------------------------------------

IfcContextMenu * Folder::GetContextMenu( UINT32 nItems, const ItemIDPath *pathList )
{
	IfcContextMenu *pCtxMenu = NULL;
	FolderData *	pFData = (FolderData *)pData;
	BOOL			bIsVolume = FALSE;
	BOOL			bIsLevel = FALSE;

	if ( pFData && pFData->aIDList.GetTokenCount() == 0 )
	{
		if ( pathList[0].pData->m_aPath.GetTokenCount() == 2 )
		{
			bIsVolume = TRUE;
			bIsLevel = TRUE;
		}
		else
		{
			LPCITEMIDLIST pidl = pathList[0].pData->m_aPath;

			bIsVolume = SHITEMKIND(pidl) < SHGII_COMPUTER_REGITEM && SHITEMCONTAINER(pidl) == SHGII_COMPUTER;
			bIsLevel = FALSE;
		}
	}


	if ( bIsVolume )
	{
		// Laufwerk in der Root !!!

		LPCITEMIDLIST	*pidlList = new LPCITEMIDLIST[nItems];
		IContextMenu *	pMenu;
		UINT32			i;

		if ( bIsLevel )
		{
			for ( i = 0; i < nItems; i++ )
				pidlList[i] = pathList[i].pData->m_aPath[1];
		}
		else
		{
			for ( i = 0; i < nItems; i++ )
				pidlList[i] = pathList[i].pData->m_aPath;
		}

		LPSHELLFOLDER	pDrivesFolder;
		
		if ( WIN_SHGetSpecialFolder( CSIDL_DRIVES, &pDrivesFolder ) )
		{
			if ( NOERROR == pDrivesFolder->GetUIObjectOf( NULL, nItems, pidlList ,IID_IContextMenu, NULL, (LPVOID *)&pMenu ) )
			{
				pCtxMenu = new ImplContextMenu( pMenu );

				pMenu->Release();
			}
		}

		delete [] pidlList;

	}
	else if ( pFData && pFData->pShellFolder )
	{
		LPCITEMIDLIST	*pidlList = new LPCITEMIDLIST[nItems];
		IContextMenu *	pMenu;
		BOOL			bWrongParent = FALSE;

		for ( UINT32 i = 0; i < nItems; i++ )
		{
			if ( pathList[i].GetTokenCount() == 0 )
			{
				// HRO: #65728# It is not possible to query a context menu for an empty PIDL.
				// Means: A context menu for the desktop can't be queried
				bWrongParent = TRUE;
			}

			pidlList[i] = pathList[i].pData->m_aPath;
		}

		if ( !bWrongParent && NOERROR == pFData->pShellFolder->GetUIObjectOf( NULL, nItems, pidlList ,IID_IContextMenu, NULL, (LPVOID *)&pMenu ) )
		{
			LPDATAOBJECT	pDataObject = NULL;

			pFData->pShellFolder->GetUIObjectOf( NULL, nItems, pidlList ,IID_IDataObject, NULL, (LPVOID *)&pDataObject);

			/* Wenn der IE4 immer intern geoeffnet werden soll, muss dieser Code ausgefuehrt werden

			if ( nItems == 1 && pFData->aIDList.GetRootID() != CSIDL_ROOT && 
				SHITEMKIND(pidlList[0]) == SHGII_ROOT_REGITEM &&
				memcmp( (LPCLSID)&pidlList[0]->mkid.abID[2], &CLSID_IE4, sizeof(GUID) ) == 0 
				)
				pCtxMenu = new ImplInternetExplorer4Menu( pMenu, pDataObject );
			else
			*/
				pCtxMenu = new ImplContextMenu( pMenu, pDataObject );

			if (pDataObject)
				pDataObject->Release();

			pMenu->Release();
		}

		delete [] pidlList;
	}

	return pCtxMenu;
}

//--------------------------------------------------------------------------
//	Folder::RenameFile
//--------------------------------------------------------------------------

BOOL Folder::RenameFile( const ItemIDPath & crOldIDPath, ItemIDPath & rNewIDPath, const String & crNewFileName )
{
	FolderData	*pFData = (FolderData *)pData;
	BOOL		bSuccess = FALSE;

	ItemIDPath	aFullOldIDPath = GetItemIDPath() + crOldIDPath;
	String	aOldFilePath = aFullOldIDPath.GetHostNotationPath();

	if ( aOldFilePath.Len() )
	{
		TCHAR	szDrive[_MAX_DRIVE];
		TCHAR	szDir[_MAX_DIR];
		TCHAR	szFName[_MAX_FNAME];
		TCHAR	szExt[_MAX_EXT];

		_splitpath( aOldFilePath.GetStr(), szDrive, szDir, szFName, szExt );

		String	aNewFilePath = szDrive;
		aNewFilePath += szDir;
		aNewFilePath += crNewFileName;

		if ( 0 == rename( aOldFilePath.GetStr(), aNewFilePath.GetStr() ) )
		{
			ItemIDPath	aFullNewIDPath( aNewFilePath.GetStr() );
			ItemIDPath	aFullParentIDPath;

			bSuccess = aFullNewIDPath.Split( aFullParentIDPath, rNewIDPath );
		}
	}

	return bSuccess;
}


//--------------------------------------------------------------------------
//	Folder::RenameItem
//--------------------------------------------------------------------------

BOOL Folder::RenameItem( const ItemIDPath &oldPath, ItemIDPath &newPath, const String &rNewTitle )
{
	FolderData *pFData = (FolderData *)pData;
	BOOL		fSuccess = FALSE;
	WCHAR		wszName[MAX_PATH];
	String		aNewName = rNewTitle;

	if ( pFData && pFData->pShellFolder )
	{
		ULONG	dwAttributes =	SFGAO_CAPABILITYMASK	| 
								SFGAO_DISPLAYATTRMASK	|
								SFGAO_LINK				|
								SFGAO_FOLDER			|
								SFGAO_FILESYSTEM		|
								SFGAO_HASSUBFOLDER		|
								0;

		LPCITEMIDLIST	pidlOld = oldPath.pData->m_aPath;

		pFData->pShellFolder->GetAttributesOf( 1, &pidlOld, &dwAttributes );

		if ( (dwAttributes & SFGAO_FILESYSTEM) && !(dwAttributes & SFGAO_FOLDER) && !(dwAttributes & SFGAO_LINK))
		{
			STRRET	str;
			CHAR	szOldPath[_MAX_PATH], szOldDrive[_MAX_DRIVE], szOldDir[_MAX_DIR], szOldFName[_MAX_FNAME], szOldExt[_MAX_EXT];
			CHAR	szNewPath[_MAX_PATH] = "";

			pFData->pShellFolder->GetDisplayNameOf( pidlOld, SHGDN_NORMAL | SHGDN_FORPARSING, &str );
			WIN_SHStrRetToMultiByte( pidlOld, &str, szOldPath, _MAX_PATH );

			_splitpath( szOldPath, szOldDrive, szOldDir, szOldFName, szOldExt );

			if ( !g_bShowExtensions )
				_makepath( szNewPath, szOldDrive, szOldDir, aNewName.GetStr(), szOldExt );
			else
			{
				CHAR	szNewFName[_MAX_FNAME], szNewExt[_MAX_EXT];

				_splitpath( aNewName.GetStr(), NULL, NULL, szNewFName, szNewExt );
				_makepath( szNewPath, szOldDrive, szOldDir, szNewFName, szNewExt );
			}

			fSuccess = !rename( szOldPath, szNewPath );

			if ( fSuccess )
			{
				ItemIDPath	aDummyParent;
				ItemIDPath( szNewPath ).Split( aDummyParent, newPath);

			}
		}
		else
		{
			LPITEMIDLIST pidlNew = NULL;

			MultiByteToWideChar( CP_ACP, 0, aNewName.GetStr(), -1, wszName, MAX_PATH );
			HRESULT hResult = pFData->pShellFolder->SetNameOf( (HWND)NULL, oldPath.pData->m_aPath, wszName, SHGDN_NORMAL, &pidlNew );

			// HRO: #72283# Windows 2000 returns -1 if the new name is identical to the old name

			fSuccess = SUCCEEDED(hResult) || hResult == (HRESULT)-1;

			if ( pidlNew )
				newPath.SetData( pidlNew, 0 );
		}
	}

	return fSuccess;
}


//--------------------------------------------------------------------------
//	Folder::DeleteItem
//--------------------------------------------------------------------------

BOOL Folder::DeleteItem( const ItemIDPath &path )
{
	FolderData *	pFData = (FolderData *)pData;
	BOOL			fSuccess = FALSE;
	LPCITEMIDLIST	pidl = path.pData->m_aPath;

	if (pFData->pShellFolder )
	{
		IContextMenu	*pContextMenu;

		if ( NOERROR == pFData->pShellFolder->GetUIObjectOf( NULL, 1, &pidl, IID_IContextMenu, NULL, (LPVOID *)&pContextMenu ) )
		{
			HMENU	hMenu = CreatePopupMenu();

			if ( hMenu )
			{
				HRESULT hResult = pContextMenu->QueryContextMenu( hMenu, 0, 0, 1000, CMF_NORMAL | CMF_CANRENAME | CMF_INCLUDESTATIC );

				if ( SUCCEEDED(hResult) )
				{
					CMINVOKECOMMANDINFO	ici;

					ici.cbSize = sizeof(ici);
					ici.fMask = 0;
					ici.hwnd = GetFocus();
					ici.lpParameters = NULL;
					ici.lpDirectory = NULL;
					ici.nShow = SW_SHOWNORMAL;
					ici.dwHotKey = 0;
					ici.hIcon = NULL;
					ici.lpVerb = CMDSTR_DELETE;

					fSuccess = (BOOL)(NOERROR == pContextMenu->InvokeCommand( &ici ));
				}

				DestroyMenu( hMenu );
			}


			pContextMenu->Release();
		}
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	Folder::BuildCRC
//--------------------------------------------------------------------------

UINT32 Folder::BuildCRC( FindFlags )
{
	FolderData *	pFData = (FolderData *)pData;
	DWORD			dwCRC = 0;
	CHAR			szFindPath[MAX_PATH];
	
	if ( pFData->fIsFileSystem )	// Geht schneller !!!
	{
		WIN32_FIND_DATA	fd;

		strcpy( szFindPath, pFData->aPath );
		if ( szFindPath[strlen(szFindPath) - 1] != '\\' )
			strcat( szFindPath, "\\" );
		strcat( szFindPath, "*.*" );

		memset( &fd, 0, sizeof(fd) );

		HANDLE			hFind = FindFirstFile( szFindPath, &fd );
		BOOL			fFindNext = (BOOL)(INVALID_HANDLE_VALUE != hFind);

		while( fFindNext )
		{
			// Die folgenden Member scheinen zumindest unter NT ohne ersichtlichen Grund
			// zu variieren. Sie duerfen nicht mit einbezogen werden, um das Ergebnis nicht
			// zu verfaelschen.

			fd.dwReserved0 = 0;
			fd.dwReserved1 = 0;
			fd.ftLastAccessTime.dwLowDateTime = 0;
			fd.ftLastAccessTime.dwHighDateTime = 0;

			dwCRC ^= WIN_SHBuildCRC( &fd, sizeof(fd) );

			memset( &fd, 0, sizeof(fd) );
			fFindNext = FindNextFile( hFind, &fd );
		}

		if ( INVALID_HANDLE_VALUE != hFind )
			FindClose( hFind );
	}
	else if ( pFData )	// Ganz normal ber das Folder-Interface
	{
		LPITEMIDLIST	pidl;
		LPENUMIDLIST	pEnumIDList = NULL;

		if ( pFData->pShellFolder )
			pFData->pShellFolder->EnumObjects( NULL, SHCONTF_ALL, &pEnumIDList );

		if ( pEnumIDList )
		{
			while ( pEnumIDList->Next( 1, &pidl, NULL ) == NOERROR )
			{
				dwCRC ^= WIN_SHBuildCRC( pidl, WIN_SHGetIDListSize(pidl) );
				WIN_SHFree( pidl );
			}

			pEnumIDList->Release();
		}
	}

	return dwCRC;
}

//--------------------------------------------------------------------------

IfcShortcut *Folder::CreateShortcutInstance( const String & crLanguage )
{
	FolderData	*pFData = (FolderData *)pData;

	// Shortcut-Instanzen koennen nur im File-System erzeugt werden

	return (pFData && pFData->aPath.Len()) ? new Impl_Shortcut( crLanguage, GetItemIDPath() ) : NULL;
}

