/*************************************************************************
 *
 *  $RCSfile: cunobrok.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sb $ $Date: 2001/05/02 10:59:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_CUNOBROK_HXX_
#include "cunobrok.hxx"
#endif

#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGE_HPP_
#include <com/sun/star/bridge/XBridge.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGEFACTORY_HPP_
#include <com/sun/star/bridge/XBridgeFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_ALREADYACCEPTINGEXCEPTION_HPP_
#include <com/sun/star/connection/AlreadyAcceptingException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_CONNECTIONSETUPEXCEPTION_HPP_
#include <com/sun/star/connection/ConnectionSetupException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XACCEPTOR_HPP_
#include <com/sun/star/connection/XAcceptor.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTION_HPP_
#include <com/sun/star/connection/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _UCBHELPER_REMOTECONTENTPROVIDERSCONTROL_HXX_
#include <ucbhelper/remotecontentproviderscontrol.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

using namespace com::sun;
using ucb_main::AcceptorThread;

//============================================================================
//
//  AcceptorThread
//
//============================================================================

AcceptorThread::AcceptorThread(
	star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory,
	star::uno::Reference< star::bridge::XBridgeFactory > const &
        rBridgeFactory,
	star::uno::Reference< star::bridge::XInstanceProvider > const &
        rInstanceProvider,
	rtl::OUString const & rConnection,
	rtl::OUString const & rProtocol):
	AcceptThread(rServiceFactory,
                 rBridgeFactory,
                 rInstanceProvider,
				 rConnection,
                 rProtocol)
{}

//============================================================================
// virtual
void SAL_CALL AcceptorThread::run()
{
	star::uno::Reference< star::connection::XAcceptor > xAcceptor;
	try
	{
		xAcceptor
			= star::uno::Reference< star::connection::XAcceptor >(
				  getServiceFactory()->
				      createInstance(
						  rtl::OUString(
                              RTL_CONSTASCII_USTRINGPARAM(
                                  "com.sun.star.connection.Acceptor"))),
				  star::uno::UNO_QUERY);
	}
	catch (star::uno::Exception &)
    {
        OSL_ENSURE(false, "com::sun::star::uno::Exception caught");
    }
	if (!xAcceptor.is())
	{
		OSL_ENSURE(false, "No com.sun.star.connection.Acceptor");
		return;
	}

	// Helper for the com.sun.star.ucb.RemoteContentProviderAcceptor service,
	// so that it can clean up when it no longer needs the accepted remote
	// content providers:
	vos::ORef< ucb::RemoteContentProvidersControl >
		xControl(new ucb::RemoteContentProvidersControl(getServiceFactory()));

	for (;;)
	{
		star::uno::Reference< star::connection::XConnection > xConnection;
		try
		{
			xConnection = xAcceptor->accept(getConnection());
		}
		catch (star::connection::AlreadyAcceptingException &)
		{
			OSL_ENSURE(false,
					   "com::sun::star::connection::AlreadyAcceptingException"
                           " caught");
		}
		catch (star::connection::ConnectionSetupException &)
		{
			OSL_ENSURE(false,
                       "com::sun::star::connection::ConnectionSetupException"
                           " caught");
		}
		catch (star::lang::IllegalArgumentException &)
		{
			OSL_ENSURE(false,
                       "com::sun::star::lang::IllegalArgumentException"
                           " caught");
		}
		catch (star::uno::RuntimeException &)
		{
			OSL_ENSURE(false, "com::sun::star::uno::RuntimeException caught");
		}
		if (!xConnection.is())
			break;

		xControl->addConnection(xConnection);

        star::uno::Reference< star::bridge::XBridge > xBridge;
		try
		{
            xBridge
                = getBridgeFactory()->createBridge(rtl::OUString(),
                                                   getProtocol(),
                                                   xConnection,
                                                   getInstanceProvider());
		}
		catch (star::bridge::BridgeExistsException &)
		{
			OSL_ENSURE(false,
                       "com::sun::star::bridge::BridgeExistsException"
                           " caught");
		}
		catch (star::lang::IllegalArgumentException &)
		{
			OSL_ENSURE(false,
                       "com::sun:.star::lang::IllegalArgumentException"
                           " caught");
		}
		catch (star::uno::RuntimeException &)
		{
			OSL_ENSURE(false, "com::sun:star::uno::RuntimeException caught");
		}
        if (!xBridge.is())
            break;

        xControl->detectDistributionConnection(xConnection, xBridge);
	}
}
